import permissions from './permissions.mjs';
import metrics from './metrics.mjs';
import localizations from './localizations.mjs';
import locales from './locales.mjs';
import isoLocalesService from './iso-locales.mjs';
import contentTypes from './content-types.mjs';
import sanitize from './sanitize/index.mjs';
import { createSettingsService } from './settings.mjs';
import { createAILocalizationsService } from './ai-localizations.mjs';
import { createAILocalizationJobsService } from './ai-localization-jobs.mjs';

var services = {
    permissions,
    metrics,
    localizations,
    locales,
    sanitize,
    'iso-locales': isoLocalesService,
    'content-types': contentTypes,
    'ai-localizations': createAILocalizationsService,
    'ai-localization-jobs': createAILocalizationJobsService,
    settings: createSettingsService
};

export { services as default };
//# sourceMappingURL=index.mjs.map
