import { i18nApi } from './api.mjs';

const settingsApi = i18nApi.injectEndpoints({
    endpoints: (builder)=>({
            getSettings: builder.query({
                query: ()=>'/i18n/settings',
                providesTags: [
                    'Settings'
                ]
            }),
            updatei18nSettings: builder.mutation({
                query: (data)=>({
                        url: '/i18n/settings',
                        method: 'PUT',
                        data
                    }),
                invalidatesTags: [
                    'Settings',
                    'AIFeatureConfig'
                ]
            })
        })
});
const { useGetSettingsQuery, useUpdatei18nSettingsMutation } = settingsApi;

export { useGetSettingsQuery, useUpdatei18nSettingsMutation };
//# sourceMappingURL=settings.mjs.map
