'use strict';

var api = require('./api.js');

const settingsApi = api.i18nApi.injectEndpoints({
    endpoints: (builder)=>({
            getSettings: builder.query({
                query: ()=>'/i18n/settings',
                providesTags: [
                    'Settings'
                ]
            }),
            updatei18nSettings: builder.mutation({
                query: (data)=>({
                        url: '/i18n/settings',
                        method: 'PUT',
                        data
                    }),
                invalidatesTags: [
                    'Settings',
                    'AIFeatureConfig'
                ]
            })
        })
});
const { useGetSettingsQuery, useUpdatei18nSettingsMutation } = settingsApi;

exports.useGetSettingsQuery = useGetSettingsQuery;
exports.useUpdatei18nSettingsMutation = useUpdatei18nSettingsMutation;
//# sourceMappingURL=settings.js.map
