'use strict';

var jsxRuntime = require('react/jsx-runtime');
require('react');
var strapiAdmin = require('@strapi/admin/strapi-admin');
var ee = require('@strapi/admin/strapi-admin/ee');
var designSystem = require('@strapi/design-system');
var icons = require('@strapi/icons');
var symbols = require('@strapi/icons/symbols');
var reactIntl = require('react-intl');
var CreateLocale = require('../components/CreateLocale.js');
var LocaleTable = require('../components/LocaleTable.js');
var constants = require('../constants.js');
var locales = require('../services/locales.js');
var settings = require('../services/settings.js');
var getTranslation = require('../utils/getTranslation.js');

const SettingsErrrorTooltip = ({ children, error })=>{
    const { _unstableFormatAPIError: formatAPIError } = strapiAdmin.useAPIErrorHandler();
    if (error) {
        return /*#__PURE__*/ jsxRuntime.jsx(designSystem.Tooltip, {
            label: formatAPIError(error),
            style: {
                maxWidth: '200px'
            },
            children: children
        });
    }
    return children;
};
const SettingsPage = ()=>{
    const { formatMessage } = reactIntl.useIntl();
    const { toggleNotification } = strapiAdmin.useNotification();
    const { data: locales$1, isLoading: isLoadingLocales, error } = locales.useGetLocalesQuery();
    const { isLoading: isLoadingRBAC, allowedActions: { canUpdate, canCreate, canDelete } } = strapiAdmin.useRBAC(constants.PERMISSIONS);
    const isAIAvailable = ee.useAIAvailability();
    // Settings state management
    const { data: settings$1, isLoading: isLoadingSettings, error: settingsError } = settings.useGetSettingsQuery();
    const [updateSettings] = settings.useUpdatei18nSettingsMutation();
    const handleToggleChange = async (checked)=>{
        try {
            await updateSettings({
                aiLocalizations: checked
            }).unwrap();
            toggleNotification({
                type: 'success',
                message: formatMessage({
                    id: 'notification.form.success.fields'
                })
            });
        } catch (err) {
            console.error(err);
            toggleNotification({
                type: 'danger',
                message: formatMessage({
                    id: 'notification.error',
                    defaultMessage: 'An error occurred'
                })
            });
        }
    };
    const isLoading = isLoadingLocales || isLoadingRBAC || isLoadingSettings;
    if (isLoading) {
        return /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Page.Loading, {});
    }
    if (error || !Array.isArray(locales$1)) {
        return /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Page.Error, {});
    }
    return /*#__PURE__*/ jsxRuntime.jsxs(strapiAdmin.Page.Main, {
        tabIndex: -1,
        children: [
            /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Layouts.Header, {
                primaryAction: /*#__PURE__*/ jsxRuntime.jsx(CreateLocale.CreateLocale, {
                    disabled: !canCreate
                }),
                title: formatMessage({
                    id: getTranslation.getTranslation('plugin.name'),
                    defaultMessage: 'Internationalization'
                }),
                subtitle: formatMessage({
                    id: getTranslation.getTranslation('Settings.list.description'),
                    defaultMessage: 'Configure the settings'
                })
            }),
            /*#__PURE__*/ jsxRuntime.jsxs(strapiAdmin.Layouts.Content, {
                children: [
                    isAIAvailable && /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
                        background: "neutral0",
                        padding: 6,
                        marginBottom: 6,
                        shadow: "filterShadow",
                        hasRadius: true,
                        children: [
                            /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
                                direction: "column",
                                alignItems: "stretch",
                                gap: 1,
                                flex: 1,
                                children: [
                                    /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
                                        gap: 1,
                                        children: [
                                            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Box, {
                                                color: "alternative700",
                                                children: /*#__PURE__*/ jsxRuntime.jsx(icons.Sparkle, {})
                                            }),
                                            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Typography, {
                                                variant: "delta",
                                                tag: "h2",
                                                children: formatMessage({
                                                    id: getTranslation.getTranslation('Settings.aiLocalizations.label'),
                                                    defaultMessage: 'AI Translations'
                                                })
                                            })
                                        ]
                                    }),
                                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Typography, {
                                        variant: "pi",
                                        textColor: "neutral600",
                                        fontSize: "14px",
                                        children: formatMessage({
                                            id: getTranslation.getTranslation('Settings.aiLocalizations.description'),
                                            defaultMessage: 'Everytime you save in the Content Manager, our AI will use your default locale to translate all other locales automatically.'
                                        })
                                    })
                                ]
                            }),
                            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Field.Root, {
                                name: "aiLocalizations",
                                minWidth: "200px",
                                children: /*#__PURE__*/ jsxRuntime.jsx(SettingsErrrorTooltip, {
                                    error: settingsError,
                                    children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Toggle, {
                                        disabled: Boolean(settingsError),
                                        checked: settings$1?.data?.aiLocalizations ?? false,
                                        offLabel: formatMessage({
                                            id: 'app.components.ToggleCheckbox.disabled-label',
                                            defaultMessage: 'Disabled'
                                        }),
                                        onLabel: formatMessage({
                                            id: 'app.components.ToggleCheckbox.enabled-label',
                                            defaultMessage: 'Enabled'
                                        }),
                                        onChange: (e)=>handleToggleChange(e.target.checked)
                                    })
                                })
                            })
                        ]
                    }),
                    locales$1.length > 0 ? /*#__PURE__*/ jsxRuntime.jsx(LocaleTable.LocaleTable, {
                        locales: locales$1,
                        canDelete: canDelete,
                        canUpdate: canUpdate
                    }) : /*#__PURE__*/ jsxRuntime.jsx(designSystem.EmptyStateLayout, {
                        icon: /*#__PURE__*/ jsxRuntime.jsx(symbols.EmptyDocuments, {
                            width: undefined,
                            height: undefined
                        }),
                        content: formatMessage({
                            id: getTranslation.getTranslation('Settings.list.empty.title'),
                            defaultMessage: 'There are no locales'
                        }),
                        action: /*#__PURE__*/ jsxRuntime.jsx(CreateLocale.CreateLocale, {
                            disabled: !canCreate,
                            variant: "secondary"
                        })
                    })
                ]
            })
        ]
    });
};
const ProtectedSettingsPage = ()=>{
    return /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Page.Protect, {
        permissions: constants.PERMISSIONS.read,
        children: /*#__PURE__*/ jsxRuntime.jsx(SettingsPage, {})
    });
};

exports.ProtectedSettingsPage = ProtectedSettingsPage;
exports.SettingsPage = SettingsPage;
//# sourceMappingURL=SettingsPage.js.map
