'use strict';

var React = require('react');
var strapiAdmin = require('@strapi/admin/strapi-admin');
var reactIntl = require('react-intl');
var reactRedux = require('react-redux');
var aiLocalizationJobs = require('../services/aiLocalizationJobs.js');
var getTranslation = require('../utils/getTranslation.js');

function _interopNamespaceDefault(e) {
  var n = Object.create(null);
  if (e) {
    Object.keys(e).forEach(function (k) {
      if (k !== 'default') {
        var d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: function () { return e[k]; }
        });
      }
    });
  }
  n.default = e;
  return Object.freeze(n);
}

var React__namespace = /*#__PURE__*/_interopNamespaceDefault(React);

const useAILocalizationJobsPolling = ({ documentId, model, collectionType })=>{
    const { toggleNotification } = strapiAdmin.useNotification();
    const { formatMessage } = reactIntl.useIntl();
    const dispatch = reactRedux.useDispatch();
    const [previousJobStatus, setPreviousJobStatus] = React__namespace.useState(null);
    /**
   * NOTE:
   * Due to a limitation with RTK query it is not possible to dynamically update the polling interval
   * @see https://github.com/reduxjs/redux-toolkit/issues/1651
   */ const { data: initialJobData } = aiLocalizationJobs.useGetAILocalizationJobsByDocumentQuery({
        documentId: documentId,
        model: model,
        collectionType: collectionType
    });
    const shouldPoll = initialJobData?.data?.status === 'processing' || previousJobStatus === 'processing';
    const { data: jobData } = aiLocalizationJobs.useGetAILocalizationJobsByDocumentQuery({
        documentId: documentId,
        model: model,
        collectionType: collectionType
    }, {
        skip: !shouldPoll,
        pollingInterval: 1000
    });
    const job = jobData?.data || initialJobData?.data;
    const currentJobStatus = job?.status;
    const invalidateDocument = React__namespace.useCallback(()=>{
        dispatch(strapiAdmin.adminApi.util.invalidateTags([
            {
                // @ts-expect-error tag isn't available
                type: 'Document',
                id: collectionType !== 'single-types' ? `${model}_${documentId}` : model
            }
        ]));
    }, [
        dispatch,
        collectionType,
        model,
        documentId
    ]);
    // Check for job status changes and trigger callbacks
    React__namespace.useEffect(()=>{
        if (!currentJobStatus) return;
        // Detect transition from 'processing' to a terminal state
        if (previousJobStatus === 'processing' && currentJobStatus === 'completed') {
            toggleNotification({
                type: 'success',
                message: formatMessage({
                    id: getTranslation.getTranslation('CMEditViewAITranslation.job-completed'),
                    defaultMessage: 'AI translation completed successfully!'
                })
            });
            invalidateDocument();
        }
        if (previousJobStatus === 'processing' && currentJobStatus === 'failed') {
            toggleNotification({
                type: 'warning',
                message: formatMessage({
                    id: getTranslation.getTranslation('CMEditViewAITranslation.job-failed'),
                    defaultMessage: 'AI translation failed. Please try again.'
                })
            });
            invalidateDocument();
        }
        // Update the previous status if it changed
        if (previousJobStatus !== currentJobStatus) {
            setPreviousJobStatus(currentJobStatus);
        }
    }, [
        currentJobStatus,
        previousJobStatus,
        setPreviousJobStatus,
        toggleNotification,
        formatMessage,
        invalidateDocument
    ]);
    return {
        status: job?.status
    };
};

exports.useAILocalizationJobsPolling = useAILocalizationJobsPolling;
//# sourceMappingURL=useAILocalizationJobsPolling.js.map
