import { jsx, jsxs } from 'react/jsx-runtime';
import { Flex, VisuallyHidden, Tooltip } from '@strapi/design-system';
import { Earth } from '@strapi/icons';
import { useIntl } from 'react-intl';
import { styled } from 'styled-components';
import { getTranslation } from '../utils/getTranslation.mjs';

const mutateEditViewHook = ({ layout })=>{
    // If i18n isn't explicitly enabled on the content type, then no field can be localized
    if (!('i18n' in layout.options) || typeof layout.options.i18n === 'object' && layout.options.i18n !== null && 'localized' in layout.options.i18n && !layout.options.i18n.localized) {
        return {
            layout
        };
    }
    const decorateField = (field)=>addLabelActionToField(field, layout);
    const components = Object.entries(layout.components).reduce((acc, [key, componentLayout])=>{
        return {
            ...acc,
            [key]: {
                ...componentLayout,
                layout: componentLayout.layout.map((row)=>row.map(decorateField))
            }
        };
    }, {});
    return {
        layout: {
            ...layout,
            components,
            layout: layout.layout.map((panel)=>panel.map((row)=>row.map(decorateField)))
        }
    };
};
const isFieldLocalized = (attribute, layout)=>{
    const contentTypeLocalized = !!layout.options?.i18n && !!layout.options.i18n.localized;
    if (!contentTypeLocalized) {
        return false;
    }
    const pluginOptions = attribute && typeof attribute === 'object' && 'pluginOptions' in attribute ? attribute.pluginOptions : undefined;
    return pluginOptions?.i18n?.localized === true;
};
const addLabelActionToField = (field, layout)=>{
    const localized = isFieldLocalized(field.attribute, layout);
    if (!localized) {
        return field;
    }
    const title = {
        id: getTranslation('Field.localized'),
        defaultMessage: 'This value is unique for the selected locale'
    };
    return {
        ...field,
        labelAction: /*#__PURE__*/ jsx(LabelAction, {
            title: title
        })
    };
};
const LabelAction = ({ title })=>{
    const { formatMessage } = useIntl();
    return /*#__PURE__*/ jsxs(Span, {
        tag: "span",
        title: title,
        children: [
            /*#__PURE__*/ jsx(VisuallyHidden, {
                tag: "span",
                children: formatMessage(title)
            }),
            /*#__PURE__*/ jsx(Tooltip, {
                label: formatMessage(title),
                children: /*#__PURE__*/ jsx(Earth, {
                    "aria-hidden": true,
                    focusable: false
                })
            })
        ]
    });
};
const Span = styled(Flex)`
  svg {
    width: 12px;
    height: 12px;

    fill: ${({ theme })=>theme.colors.neutral500};

    path {
      fill: ${({ theme })=>theme.colors.neutral500};
    }
  }
`;

export { mutateEditViewHook };
//# sourceMappingURL=editView.mjs.map
