'use strict';

var jsxRuntime = require('react/jsx-runtime');
var React = require('react');
var strapiAdmin = require('@strapi/admin/strapi-admin');
var designSystem = require('@strapi/design-system');
var icons = require('@strapi/icons');
var reactIntl = require('react-intl');
var yup = require('yup');
var locales = require('../services/locales.js');
var baseQuery = require('../utils/baseQuery.js');
var getTranslation = require('../utils/getTranslation.js');

function _interopNamespaceDefault(e) {
  var n = Object.create(null);
  if (e) {
    Object.keys(e).forEach(function (k) {
      if (k !== 'default') {
        var d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: function () { return e[k]; }
        });
      }
    });
  }
  n.default = e;
  return Object.freeze(n);
}

var React__namespace = /*#__PURE__*/_interopNamespaceDefault(React);
var yup__namespace = /*#__PURE__*/_interopNamespaceDefault(yup);

const CreateLocale = ({ disabled, variant = 'default' })=>{
    const { formatMessage } = reactIntl.useIntl();
    const [visible, setVisible] = React__namespace.useState(false);
    return /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Modal.Root, {
        open: visible,
        onOpenChange: setVisible,
        children: [
            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Modal.Trigger, {
                children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Button, {
                    variant: variant,
                    disabled: disabled,
                    startIcon: /*#__PURE__*/ jsxRuntime.jsx(icons.Plus, {}),
                    onClick: ()=>setVisible(true),
                    size: "S",
                    children: formatMessage({
                        id: getTranslation.getTranslation('Settings.list.actions.add'),
                        defaultMessage: 'Add new locale'
                    })
                })
            }),
            /*#__PURE__*/ jsxRuntime.jsx(CreateModal, {
                onClose: ()=>setVisible(false)
            })
        ]
    });
};
/* -------------------------------------------------------------------------------------------------
 * CreateModal
 * -----------------------------------------------------------------------------------------------*/ const LOCALE_SCHEMA = yup__namespace.object().shape({
    code: yup__namespace.string().nullable().required({
        id: 'Settings.locales.modal.create.code.error',
        defaultMessage: 'Please select a locale'
    }),
    name: yup__namespace.string().nullable().max(50, {
        id: 'Settings.locales.modal.create.name.error.min',
        defaultMessage: 'The locale display name can only be less than 50 characters.'
    }).required({
        id: 'Settings.locales.modal.create.name.error.required',
        defaultMessage: 'Please give the locale a display name'
    }),
    isDefault: yup__namespace.boolean()
});
const initialFormValues = {
    code: '',
    name: '',
    isDefault: false
};
const CreateModal = ({ onClose })=>{
    const titleId = designSystem.useId();
    const { toggleNotification } = strapiAdmin.useNotification();
    const { _unstableFormatAPIError: formatAPIError, _unstableFormatValidationErrors: formatValidationErrors } = strapiAdmin.useAPIErrorHandler();
    const [createLocale] = locales.useCreateLocaleMutation();
    const { formatMessage } = reactIntl.useIntl();
    const refetchPermissions = strapiAdmin.useAuth('CreateModal', (state)=>state.refetchPermissions);
    const handleSubmit = async (values, helpers)=>{
        try {
            const res = await createLocale(values);
            if ('error' in res) {
                if (baseQuery.isBaseQueryError(res.error) && res.error.name === 'ValidationError') {
                    helpers.setErrors(formatValidationErrors(res.error));
                } else {
                    toggleNotification({
                        type: 'danger',
                        message: formatAPIError(res.error)
                    });
                }
                return;
            }
            toggleNotification({
                type: 'success',
                message: formatMessage({
                    id: getTranslation.getTranslation('Settings.locales.modal.create.success'),
                    defaultMessage: 'Locale successfully added'
                })
            });
            refetchPermissions();
            onClose();
        } catch (err) {
            toggleNotification({
                type: 'danger',
                message: formatMessage({
                    id: 'notification.error',
                    defaultMessage: 'An error occurred, please try again'
                })
            });
        }
    };
    return /*#__PURE__*/ jsxRuntime.jsx(designSystem.Modal.Content, {
        children: /*#__PURE__*/ jsxRuntime.jsxs(strapiAdmin.Form, {
            method: "POST",
            initialValues: initialFormValues,
            validationSchema: LOCALE_SCHEMA,
            onSubmit: handleSubmit,
            children: [
                /*#__PURE__*/ jsxRuntime.jsx(designSystem.Modal.Header, {
                    children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Modal.Title, {
                        children: formatMessage({
                            id: getTranslation.getTranslation('Settings.list.actions.add'),
                            defaultMessage: 'Add new locale'
                        })
                    })
                }),
                /*#__PURE__*/ jsxRuntime.jsx(designSystem.Modal.Body, {
                    children: /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Tabs.Root, {
                        variant: "simple",
                        defaultValue: "basic",
                        children: [
                            /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
                                justifyContent: "space-between",
                                children: [
                                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Typography, {
                                        tag: "h2",
                                        variant: "beta",
                                        id: titleId,
                                        children: formatMessage({
                                            id: getTranslation.getTranslation('Settings.locales.modal.title'),
                                            defaultMessage: 'Configuration'
                                        })
                                    }),
                                    /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Tabs.List, {
                                        "aria-labelledby": titleId,
                                        children: [
                                            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Tabs.Trigger, {
                                                value: "basic",
                                                children: formatMessage({
                                                    id: getTranslation.getTranslation('Settings.locales.modal.base'),
                                                    defaultMessage: 'Basic settings'
                                                })
                                            }),
                                            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Tabs.Trigger, {
                                                value: "advanced",
                                                children: formatMessage({
                                                    id: getTranslation.getTranslation('Settings.locales.modal.advanced'),
                                                    defaultMessage: 'Advanced settings'
                                                })
                                            })
                                        ]
                                    })
                                ]
                            }),
                            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Divider, {}),
                            /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Box, {
                                paddingTop: 7,
                                paddingBottom: 7,
                                children: [
                                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Tabs.Content, {
                                        value: "basic",
                                        children: /*#__PURE__*/ jsxRuntime.jsx(BaseForm, {})
                                    }),
                                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Tabs.Content, {
                                        value: "advanced",
                                        children: /*#__PURE__*/ jsxRuntime.jsx(AdvancedForm, {})
                                    })
                                ]
                            })
                        ]
                    })
                }),
                /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Modal.Footer, {
                    children: [
                        /*#__PURE__*/ jsxRuntime.jsx(designSystem.Modal.Close, {
                            children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Button, {
                                variant: "tertiary",
                                children: formatMessage({
                                    id: 'app.components.Button.cancel',
                                    defaultMessage: 'Cancel'
                                })
                            })
                        }),
                        /*#__PURE__*/ jsxRuntime.jsx(SubmitButton, {})
                    ]
                })
            ]
        })
    });
};
/* -------------------------------------------------------------------------------------------------
 * SubmitButton
 * -----------------------------------------------------------------------------------------------*/ const SubmitButton = ()=>{
    const { formatMessage } = reactIntl.useIntl();
    const isSubmitting = strapiAdmin.useForm('SubmitButton', (state)=>state.isSubmitting);
    const modified = strapiAdmin.useForm('SubmitButton', (state)=>state.modified);
    return /*#__PURE__*/ jsxRuntime.jsx(designSystem.Button, {
        type: "submit",
        startIcon: /*#__PURE__*/ jsxRuntime.jsx(icons.Check, {}),
        disabled: isSubmitting || !modified,
        children: formatMessage({
            id: 'global.save',
            defaultMessage: 'Save'
        })
    });
};
const BaseForm = ({ mode = 'create' })=>{
    const { formatMessage } = reactIntl.useIntl();
    const { toggleNotification } = strapiAdmin.useNotification();
    const { _unstableFormatAPIError: formatAPIError } = strapiAdmin.useAPIErrorHandler();
    const { data: defaultLocales, error } = locales.useGetDefaultLocalesQuery();
    React__namespace.useEffect(()=>{
        if (error) {
            toggleNotification({
                type: 'danger',
                message: formatAPIError(error)
            });
        }
    }, [
        error,
        formatAPIError,
        toggleNotification
    ]);
    if (!Array.isArray(defaultLocales)) {
        return null;
    }
    const options = defaultLocales.map((locale)=>({
            label: locale.name,
            value: locale.code
        }));
    const translatedForm = [
        {
            disabled: mode !== 'create',
            label: {
                id: getTranslation.getTranslation('Settings.locales.modal.create.code.label'),
                defaultMessage: 'Locales'
            },
            name: 'code',
            options,
            placeholder: {
                id: 'components.placeholder.select',
                defaultMessage: 'Select'
            },
            required: true,
            size: 6,
            type: 'enumeration'
        },
        {
            hint: {
                id: getTranslation.getTranslation('Settings.locales.modal.create.name.label.description'),
                defaultMessage: 'Locale will be displayed under that name in the administration panel'
            },
            label: {
                id: getTranslation.getTranslation('Settings.locales.modal.create.name.label'),
                defaultMessage: 'Locale display name'
            },
            name: 'name',
            required: true,
            size: 6,
            type: 'string'
        }
    ].map((field)=>({
            ...field,
            hint: field.hint ? formatMessage(field.hint) : undefined,
            label: formatMessage(field.label),
            placeholder: field.placeholder ? formatMessage(field.placeholder) : undefined
        }));
    return /*#__PURE__*/ jsxRuntime.jsx(designSystem.Grid.Root, {
        gap: 4,
        children: translatedForm.map(({ size, ...field })=>/*#__PURE__*/ jsxRuntime.jsx(designSystem.Grid.Item, {
                xs: 12,
                m: size,
                direction: "column",
                alignItems: "stretch",
                children: /*#__PURE__*/ jsxRuntime.jsx(FormRenderer, {
                    ...field
                })
            }, field.name))
    });
};
const AdvancedForm = ({ isDefaultLocale })=>{
    const { formatMessage } = reactIntl.useIntl();
    const form = [
        {
            disabled: isDefaultLocale,
            hint: {
                id: getTranslation.getTranslation('Settings.locales.modal.advanced.setAsDefault.hint'),
                defaultMessage: 'One default locale is required, change it by selecting another one'
            },
            label: {
                id: getTranslation.getTranslation('Settings.locales.modal.advanced.setAsDefault'),
                defaultMessage: 'Set as default locale'
            },
            name: 'isDefault',
            size: 6,
            type: 'boolean'
        }
    ].map((field)=>({
            ...field,
            hint: field.hint ? formatMessage(field.hint) : undefined,
            label: formatMessage(field.label)
        }));
    return /*#__PURE__*/ jsxRuntime.jsx(designSystem.Grid.Root, {
        gap: 4,
        children: form.map(({ size, ...field })=>/*#__PURE__*/ jsxRuntime.jsx(designSystem.Grid.Item, {
                xs: 12,
                m: size,
                direction: "column",
                alignItems: "stretch",
                children: /*#__PURE__*/ jsxRuntime.jsx(FormRenderer, {
                    ...field
                })
            }, field.name))
    });
};
/* -------------------------------------------------------------------------------------------------
 * FormRenderer
 * -----------------------------------------------------------------------------------------------*/ const FormRenderer = (field)=>{
    switch(field.type){
        /**
     * This will override the default input renderer
     * choice for `enumeration`.
     */ case 'enumeration':
            return /*#__PURE__*/ jsxRuntime.jsx(EnumerationInput, {
                ...field
            });
        default:
            return /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.InputRenderer, {
                ...field
            });
    }
};
const EnumerationInput = ({ disabled, hint, label, name, options, placeholder, required })=>{
    const { value, error, onChange } = strapiAdmin.useField(name);
    const { data: defaultLocales = [] } = locales.useGetDefaultLocalesQuery();
    const handleChange = (value)=>{
        if (Array.isArray(defaultLocales)) {
            // We know it exists because the options are created from the list of default locales
            const locale = defaultLocales.find((locale)=>locale.code === value);
            onChange(name, value);
            // This lets us automatically fill the name field with the locale name
            onChange('name', locale.name);
        } else {
            onChange(name, value);
        }
    };
    return /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Field.Root, {
        error: error,
        hint: hint,
        name: name,
        required: required,
        children: [
            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Field.Label, {
                children: label
            }),
            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Combobox, {
                disabled: disabled,
                onChange: handleChange,
                onClear: ()=>handleChange(''),
                placeholder: placeholder,
                value: value,
                autocomplete: {
                    type: 'list',
                    filter: 'contains'
                },
                children: options.map((option)=>/*#__PURE__*/ jsxRuntime.jsx(designSystem.ComboboxOption, {
                        value: option.value,
                        children: option.label
                    }, option.value))
            }),
            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Field.Error, {}),
            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Field.Hint, {})
        ]
    });
};

exports.AdvancedForm = AdvancedForm;
exports.BaseForm = BaseForm;
exports.CreateLocale = CreateLocale;
exports.LOCALE_SCHEMA = LOCALE_SCHEMA;
exports.SubmitButton = SubmitButton;
//# sourceMappingURL=CreateLocale.js.map
