'use strict';

var admin = {
    type: 'admin',
    routes: [
        {
            method: 'POST',
            path: '/',
            handler: 'email.send',
            config: {
                policies: [
                    'admin::isAuthenticatedAdmin'
                ]
            }
        },
        {
            method: 'POST',
            path: '/test',
            handler: 'email.test',
            config: {
                policies: [
                    'admin::isAuthenticatedAdmin',
                    {
                        name: 'admin::hasPermissions',
                        config: {
                            actions: [
                                'plugin::email.settings.read'
                            ]
                        }
                    }
                ]
            }
        },
        {
            method: 'GET',
            path: '/settings',
            handler: 'email.getSettings',
            config: {
                policies: [
                    'admin::isAuthenticatedAdmin',
                    {
                        name: 'admin::hasPermissions',
                        config: {
                            actions: [
                                'plugin::email.settings.read'
                            ]
                        }
                    }
                ]
            }
        }
    ]
};

module.exports = admin;
//# sourceMappingURL=admin.js.map
