import { DefaultTheme } from 'styled-components';
/**
 * Shared text styles for input components (Combobox, Select, DatePicker, TimePicker)
 * Mobile: 1.6rem / 2.4rem
 * Above small breakpoint: 1.4rem / 2.2rem
 */
export declare const inputTextStyles: import('styled-components').RuleSet<object>;
interface ClearableFieldPaddingProps {
    $size?: 'S' | 'M';
    $hasValue?: boolean;
    $hasClear?: boolean;
    theme: DefaultTheme;
}
/**
 * Shared padding styles for clearable elements (Combobox, Select, DatePicker, TimePicker)
 */
export declare const clearableFieldPaddingStyles: ({ $size, $hasValue, $hasClear, theme, }: ClearableFieldPaddingProps) => import('styled-components').RuleSet<object>;
export {};
//# sourceMappingURL=input.d.ts.map