import { styled as x, css as D, keyframes as fe, useTheme as Xa, createGlobalStyle as Ja, ThemeProvider as Qa } from "styled-components";
import * as m from "react";
import { useEffect as gs, useLayoutEffect as Za, useRef as Yr, useState as Mn, startTransition as Xr, useMemo as ps, Children as eh, useCallback as th } from "react";
import { useCallbackRef as ms } from "@radix-ui/react-use-callback-ref";
import { DateFormatter as ih, getLocalTimeZone as Dn, today as br, parseAbsolute as nh, toCalendarDate as rh, minDate as On, maxDate as En, startOfMonth as oh, startOfWeek as bs, getDayOfWeek as sh, isSameDay as ys, endOfMonth as lh, parseAbsoluteToLocal as ah, toCalendarDateTime as hh } from "@internationalized/date";
import { jsx as u, jsxs as $, Fragment as yr } from "react/jsx-runtime";
import * as rt from "@radix-ui/react-tooltip";
import { Provider as ch } from "@radix-ui/react-tooltip";
import * as dh from "@radix-ui/react-dismissable-layer";
import { useCallbackRef as ws, Combobox as Oe, Select as Le, composeEventHandlers as wt, usePrev as uh } from "@strapi/ui-primitives";
import { composeEventHandlers as N1, useCallbackRef as F1, useCollator as W1, useFilter as H1 } from "@strapi/ui-primitives";
import * as xi from "@radix-ui/react-accordion";
import { CaretDown as Ze, Cross as kt, CheckCircle as fh, WarningCircle as gh, Information as ph, Loader as xs, ExternalLink as mh, ChevronRight as wr, Minus as bh, ChevronLeft as vs, Calendar as yh, Clock as wh, Search as Ss } from "@strapi/icons";
import * as xr from "@radix-ui/react-avatar";
import * as Ee from "@radix-ui/react-dropdown-menu";
import * as Cs from "@radix-ui/react-checkbox";
import { flushSync as xh, createPortal as vh } from "react-dom";
import * as nn from "@radix-ui/react-scroll-area";
import * as tt from "@radix-ui/react-alert-dialog";
import { useFloating as Sh, autoUpdate as Ch, offset as kh, shift as $h, flip as Ah } from "@floating-ui/react-dom";
import { useFocusGuards as Th } from "@radix-ui/react-focus-guards";
import { FocusScope as Rh } from "@radix-ui/react-focus-scope";
import { RemoveScroll as Mh } from "react-remove-scroll";
import { json as Dh, jsonParseLinter as Oh } from "@codemirror/lang-json";
import { useCodeMirror as Eh } from "@uiw/react-codemirror";
import * as $t from "@radix-ui/react-dialog";
import { NumberParser as Ih, NumberFormatter as Ph } from "@internationalized/number";
import * as _t from "@radix-ui/react-popover";
import * as ks from "@radix-ui/react-progress";
import * as vr from "@radix-ui/react-radio-group";
import * as $s from "@radix-ui/react-switch";
import * as rn from "@radix-ui/react-tabs";
import { cloneDeep as Jr, assignWith as Lh, merge as Bh } from "lodash";
const Gt = (i, e) => {
  const t = m.createContext(e), n = (o) => {
    const { children: s, ...l } = o, a = m.useMemo(() => l, Object.values(l));
    return /* @__PURE__ */ u(t.Provider, { value: a, children: s });
  };
  function r(o) {
    const s = m.useContext(t);
    if (s) return s;
    if (e !== void 0) return e;
    throw new Error(`\`${o}\` must be used within \`${i}\``);
  }
  return n.displayName = `${i}Provider`, [n, r];
};
function zh(i, e) {
  return typeof i == "string" ? !1 : e in i;
}
function Ri(i) {
  return i && typeof i == "object" && !Array.isArray(i);
}
function Wi(i, e, t) {
  return i && e && zh(i, e) ? i[e] : t;
}
const Qr = {
  padding: ["padding-block-start", "padding-inline-end", "padding-block-end", "padding-inline-start"],
  paddingTop: "padding-block-start",
  paddingRight: "padding-inline-end",
  paddingBottom: "padding-block-end",
  paddingLeft: "padding-inline-start",
  margin: ["margin-block-start", "margin-inline-end", "margin-block-end", "margin-inline-start"],
  marginLeft: "margin-inline-start",
  marginRight: "margin-inline-end",
  marginTop: "margin-block-start",
  marginBottom: "margin-block-end",
  borderRadius: "border-radius",
  borderStyle: "border-style",
  borderWidth: "border-width",
  borderColor: "border-color",
  fontSize: "font-size",
  fontWeight: "font-weight",
  lineHeight: "line-height",
  zIndex: "z-index",
  boxShadow: "box-shadow",
  pointerEvents: "pointer-events",
  textAlign: "text-align",
  textTransform: "text-transform",
  textDecoration: "text-decoration",
  flexGrow: "flex-grow",
  flexShrink: "flex-shrink",
  flexBasis: "flex-basis",
  minWidth: "min-width",
  maxWidth: "max-width",
  minHeight: "min-height",
  maxHeight: "max-height",
  order: "order",
  flexDirection: "flex-direction",
  flexWrap: "flex-wrap",
  justifyContent: "justify-content",
  alignItems: "align-items"
}, Nh = (i) => {
  const [e, t, n, r] = i, o = t ?? e;
  return [e, o, n ?? e, r ?? o];
};
function Fh(i, e) {
  switch (i) {
    case "gap":
    case "padding":
    case "margin":
    case "paddingTop":
    case "paddingLeft":
    case "paddingRight":
    case "paddingBottom":
    case "marginTop":
    case "marginLeft":
    case "marginRight":
    case "marginBottom":
    case "left":
    case "right":
    case "top":
    case "bottom":
    case "width":
    case "maxWidth":
    case "minWidth":
    case "height":
    case "maxHeight":
    case "minHeight":
    case "borderRadius":
    case "borderWidth":
      return e.spaces;
    case "color":
    case "background":
    case "borderColor":
      return e.colors;
    case "fontSize":
      return e.fontSizes;
    case "fontWeight":
      return e.fontWeights;
    case "lineHeight":
      return e.lineHeights;
    case "zIndex":
      return e.zIndices;
    case "boxShadow":
      return e.shadows;
    default:
      return null;
  }
}
const Bt = (i, e) => {
  const t = Object.entries(i).reduce(
    (n, r) => {
      const [o, s] = r, l = Fh(o, e), a = Object.prototype.hasOwnProperty.call(Qr, o) ? Qr[o] : o;
      return a && (s || s === 0) && (typeof s == "object" && !Array.isArray(s) ? Object.entries(s).forEach(([c, h]) => {
        n[c] = {
          ...n[c],
          ...Zr(a, h, l)
        };
      }) : n.initial = {
        ...n.initial,
        ...Zr(a, s, l)
      }), n;
    },
    {
      initial: {},
      small: {},
      medium: {},
      large: {}
    }
  );
  return Object.entries(t).reduce((n, [r, o]) => {
    if (o && Object.keys(o).length > 0) {
      const s = Object.entries(o).reduce((l, [a, c]) => (l.push(`${a}: ${c};`), l), []).join(`
`);
      r === "initial" ? n.push(s) : n.push(`${e.breakpoints[r]}{ ${s} }`);
    }
    return n;
  }, []).join(`
`);
}, Zr = (i, e, t) => {
  if (Array.isArray(i) && Array.isArray(e)) {
    const n = Nh(e);
    return i.reduce((r, o, s) => (r[o] = Wi(t, n[s], n[s]), r), {});
  } else return Array.isArray(i) && !Array.isArray(e) ? i.reduce((n, r) => (n[r] = Wi(t, e, e), n), {}) : !Array.isArray(i) && !Array.isArray(e) ? {
    [i]: Wi(t, e, e)
  } : (console.warn(
    "You've passed an array of values to a property that does not support it. Please check the property and value you're passing."
  ), {});
}, xe = m.forwardRef, R = xe((i, e) => {
  const {
    animation: t,
    background: n,
    basis: r,
    borderColor: o,
    borderRadius: s,
    borderStyle: l,
    borderWidth: a,
    bottom: c,
    color: h,
    cursor: d,
    display: f,
    flex: g,
    fontSize: p,
    fontWeight: b,
    grow: w,
    hasRadius: y,
    height: v,
    left: k,
    lineHeight: C,
    margin: A,
    marginBottom: S,
    marginLeft: M,
    marginRight: N,
    marginTop: z,
    maxHeight: F,
    maxWidth: Q,
    minHeight: U,
    minWidth: K,
    order: L,
    overflow: se,
    padding: ue,
    paddingBottom: B,
    paddingLeft: J,
    paddingRight: re,
    paddingTop: oe,
    pointerEvents: le,
    position: Be,
    right: V,
    shadow: qe,
    shrink: ae,
    tag: Tt,
    textAlign: ht,
    textTransform: ct,
    top: Ke,
    transform: Rt,
    transition: dt,
    width: Jt,
    zIndex: Qt,
    ...ut
  } = i;
  return /* @__PURE__ */ u(Wh, { as: Tt || "div", ref: e, ...{
    $animation: t,
    $background: n,
    $basis: r,
    $borderColor: o,
    $borderRadius: s,
    $borderStyle: l,
    $borderWidth: a,
    $bottom: c,
    $color: h,
    $cursor: d,
    $display: f,
    $flex: g,
    $fontSize: p,
    $fontWeight: b,
    $grow: w,
    $hasRadius: y,
    $height: v,
    $left: k,
    $lineHeight: C,
    $margin: A,
    $marginBottom: S,
    $marginLeft: M,
    $marginRight: N,
    $marginTop: z,
    $maxHeight: F,
    $maxWidth: Q,
    $minHeight: U,
    $minWidth: K,
    $order: L,
    $overflow: se,
    $padding: ue,
    $paddingBottom: B,
    $paddingLeft: J,
    $paddingRight: re,
    $paddingTop: oe,
    $pointerEvents: le,
    $position: Be,
    $right: V,
    $shadow: qe,
    $shrink: ae,
    $textAlign: ht,
    $textTransform: ct,
    $top: Ke,
    $transform: Rt,
    $transition: dt,
    $width: Jt,
    $zIndex: Qt
  }, ...ut });
}), Wh = x.div`
  ${({ theme: i, ...e }) => Bt(
  {
    animation: e.$animation,
    background: e.$background,
    borderColor: e.$borderColor,
    borderRadius: e.$hasRadius ? i.borderRadius : e.$borderRadius,
    borderStyle: e.$borderColor && !e.$borderStyle ? "solid" : e.$borderStyle,
    borderWidth: e.$borderColor && !e.$borderWidth ? "1px" : e.$borderWidth,
    bottom: e.$bottom,
    boxShadow: e.$shadow,
    color: e.$color,
    cursor: e.$cursor,
    display: e.$display,
    flex: e.$flex,
    flexBasis: e.$basis,
    flexGrow: e.$grow,
    flexShrink: e.$shrink,
    fontSize: e.$fontSize,
    fontWeight: e.$fontWeight,
    height: e.$height,
    left: e.$left,
    lineHeight: e.$lineHeight,
    margin: e.$margin,
    marginBottom: e.$marginBottom,
    marginLeft: e.$marginLeft,
    marginRight: e.$marginRight,
    marginTop: e.$marginTop,
    maxHeight: e.$maxHeight,
    maxWidth: e.$maxWidth,
    minHeight: e.$minHeight,
    minWidth: e.$minWidth,
    order: e.$order,
    overflow: e.$overflow,
    padding: e.$padding,
    paddingBottom: e.$paddingBottom,
    paddingLeft: e.$paddingLeft,
    paddingRight: e.$paddingRight,
    paddingTop: e.$paddingTop,
    pointerEvents: e.$pointerEvents,
    position: e.$position,
    right: e.$right,
    textAlign: e.$textAlign,
    textTransform: e.$textTransform,
    top: e.$top,
    transform: e.$transform,
    transition: e.$transition,
    width: e.$width,
    zIndex: e.$zIndex
  },
  i
)};
`, T = xe((i, e) => {
  const { className: t, alignItems: n, direction: r, inline: o, gap: s, justifyContent: l, wrap: a, ...c } = i;
  return /* @__PURE__ */ u(Hh, { className: t, ref: e, ...{
    $alignItems: n,
    $direction: r,
    $gap: s,
    $justifyContent: l,
    $wrap: a,
    $inline: o
  }, ...c });
}), Hh = x(R)`
  ${({ theme: i, $display: e = "flex", $alignItems: t = "center", $direction: n = "row", ...r }) => Bt(
  {
    gap: r.$gap,
    alignItems: t,
    justifyContent: r.$justifyContent,
    flexWrap: r.$wrap,
    flexDirection: n,
    display: r.$inline ? "inline-flex" : e
  },
  i
)};
`, Vh = "alpha", jh = "beta", qh = "delta", Kh = "epsilon", eo = "omega", Uh = "pi", _h = "sigma", As = D`
  display: block;
  white-space: nowrap;
  overflow: hidden;
  text-overflow: ellipsis;
`, Gh = ({ $variant: i = eo, theme: e, $fontSize: t, $lineHeight: n }) => {
  const r = t && Bt({ fontSize: t }, e), o = n && Bt({ lineHeight: n }, e);
  switch (i) {
    case Vh:
      return D`
        font-weight: ${e.fontWeights.bold};

        /* -------------------------------------------------------------
         * Font Size
         * -------------------------------------------------------------*/
        ${r || D`
          /* Mobile: 2.8rem */
          font-size: ${e.fontSizes[6]};

          ${e.breakpoints.medium} {
            /* Tablet + Desktop: 3.2rem */
            font-size: ${e.fontSizes[7]};
          }
        `}

        /* -------------------------------------------------------------
         * Line Height
         * -------------------------------------------------------------*/
        ${o || D`
          /* Mobile: 3.2rem */
          line-height: ${e.lineHeights[0]};

          ${e.breakpoints.medium} {
            /* Tablet + Desktop: 4rem */
            line-height: ${e.lineHeights[2]};
          }
        `}
      `;
    case jh:
      return D`
        font-weight: ${e.fontWeights.bold};

        /* -------------------------------------------------------------
         * Font Size
         * -------------------------------------------------------------*/
        ${r || D`
          /* Mobile: 2rem */
          font-size: ${e.fontSizes[5]};

          ${e.breakpoints.medium} {
            /* Tablet + Desktop: 1.8rem */
            font-size: ${e.fontSizes[4]};
          }
        `}

        /* -------------------------------------------------------------
         * Line Height
         * -------------------------------------------------------------*/
        ${o || D`
          /* Mobile: 2.4rem */
          line-height: ${e.lineHeights[1]};
        `}
      `;
    case qh:
      return D`
        font-weight: ${e.fontWeights.semiBold};

        /* -------------------------------------------------------------
         * Font Size
         * -------------------------------------------------------------*/
        ${r || D`
          /* Mobile: 1.8rem */
          font-size: ${e.fontSizes[4]};

          ${e.breakpoints.medium} {
            /* Tablet + Desktop: 1.6rem */
            font-size: ${e.fontSizes[3]};
          }
        `}

        /* -------------------------------------------------------------
         * Line Height
         * -------------------------------------------------------------*/
        ${o || D`
          /* Mobile: 2.4rem */
          line-height: ${e.lineHeights[3]};

          ${e.breakpoints.medium} {
            /* Tablet + Desktop: 2rem */
            line-height: ${e.lineHeights[2]};
          }
        `}
      `;
    case Kh:
      return D`
        /* -------------------------------------------------------------
         * Font Size
         * -------------------------------------------------------------*/
        ${r || D`
          /* Mobile: 1.8rem */
          font-size: ${e.fontSizes[4]};

          ${e.breakpoints.medium} {
            /* Tablet + Desktop: 1.6rem */
            font-size: ${e.fontSizes[3]};
          }
        `}

        /* -------------------------------------------------------------
         * Line Height
         * -------------------------------------------------------------*/
        ${o || D`
          /* Mobile: 2.4rem */
          line-height: ${e.lineHeights[3]};

          ${e.breakpoints.medium} {
            /* Tablet + Desktop: 2.4rem */
            line-height: ${e.lineHeights[6]};
          }
        `}
      `;
    case eo:
      return D`
        /* -------------------------------------------------------------
         * Font Size
         * -------------------------------------------------------------*/
        ${r || D`
          /* Mobile: 1.6rem */
          font-size: ${e.fontSizes[3]};

          ${e.breakpoints.medium} {
            /* Tablet + Desktop: 1.4rem */
            font-size: ${e.fontSizes[2]};
          }
        `}

        /* -------------------------------------------------------------
         * Line Height
         * -------------------------------------------------------------*/
        ${o || D`
          /* Mobile: 2.4rem */
          line-height: ${e.lineHeights[6]};

          ${e.breakpoints.medium} {
            /* Tablet + Desktop: 2.0rem */
            line-height: ${e.lineHeights[4]};
          }
        `}
      `;
    case Uh:
      return D`
        /* -------------------------------------------------------------
         * Font Size
         * -------------------------------------------------------------*/
        ${r || D`
          /* All: 1.2rem */
          font-size: ${e.fontSizes[1]};
        `}

        /* -------------------------------------------------------------
         * Line Height
         * -------------------------------------------------------------*/
        ${o || D`
          /* All: 1.6rem */
          line-height: ${e.lineHeights[3]};
        `}
      `;
    case _h:
      return D`
        font-weight: ${e.fontWeights.bold};
        text-transform: uppercase;

        /* -------------------------------------------------------------
         * Font Size
         * -------------------------------------------------------------*/
        ${r || D`
          /* All: 1.1rem */
          font-size: ${e.fontSizes[0]};
        `}

        /* -------------------------------------------------------------
         * Line Height
         * -------------------------------------------------------------*/
        ${o || D`
          /* All: 1.6rem */
          line-height: ${e.lineHeights[5]};
        `}
      `;
    default:
      return D`
        /* -------------------------------------------------------------
         * Font Size
         * -------------------------------------------------------------*/
        ${r || D`
          /* Mobile: 1.6rem */
          font-size: ${e.fontSizes[3]};

          ${e.breakpoints.medium} {
            /* Tablet + Desktop: 1.4rem */
            font-size: ${e.fontSizes[2]};
          }
        `}
      `;
  }
}, I = xe(
  (i, e) => {
    const {
      ellipsis: t,
      textColor: n = "currentcolor",
      textDecoration: r,
      textTransform: o,
      variant: s,
      lineHeight: l,
      fontWeight: a,
      fontSize: c,
      ...h
    } = i;
    return /* @__PURE__ */ u(Yh, { ref: e, tag: "span", ...{
      $ellipsis: t,
      $textColor: n,
      $textDecoration: r,
      $textTransform: o,
      $variant: s,
      $lineHeight: l,
      $fontWeight: a,
      $fontSize: c
    }, ...h });
  }
), Yh = x(R)`
  ${({ $variant: i, $fontSize: e, $lineHeight: t, theme: n }) => Gh({ $variant: i, theme: n, $fontSize: e, $lineHeight: t })}
  ${({ $ellipsis: i }) => i ? As : ""}

  ${({ theme: i, ...e }) => Bt(
  {
    color: e.$textColor,
    textDecoration: e.$textDecoration,
    textTransform: e.$textTransform,
    lineHeight: e.$lineHeight,
    fontWeight: e.$fontWeight,
    fontSize: e.$fontSize
  },
  i
)}
`, [Xh, Sr] = Gt("Accordion"), Jh = m.forwardRef(({ children: i, size: e = "S", ...t }, n) => /* @__PURE__ */ u(Qh, { ref: n, $size: e, collapsible: !0, ...t, type: "single", children: /* @__PURE__ */ u(Xh, { size: e, children: i }) })), Qh = x(xi.Root)`
  background-color: ${(i) => i.theme.colors.neutral0};

  ${(i) => i.$size === "S" ? D`
        border-radius: ${(e) => e.theme.borderRadius};
        border: solid 1px ${(e) => e.theme.colors.neutral200};
      ` : D`
        
      `}
`, Zh = m.forwardRef((i, e) => {
  const { size: t } = Sr("Item");
  return /* @__PURE__ */ u(ec, { $size: t, "data-size": t, ref: e, ...i });
}), ec = x(xi.Item)`
  overflow: hidden;
  margin: 1px 0;

  &:first-child {
    border-top-left-radius: 0.3rem;
    border-top-right-radius: 0.3rem;
    margin-top: 0;
  }

  &:last-child {
    border-bottom-left-radius: 0.3rem;
    border-bottom-right-radius: 0.3rem;
    margin-bottom: 0;
  }

  &[data-size='S'] {
    & + & {
      border-top: solid 1px ${(i) => i.theme.colors.neutral200};
    }
  }

  &[data-state='open'] {
    box-shadow: 0 0 0 1px ${(i) => i.theme.colors.primary600};
  }

  &:not([data-disabled]):hover {
    box-shadow: 0 0 0 1px ${(i) => i.theme.colors.primary600};
  }

  /* This applies our desired focus effect correctly. */
  &:focus-within {
    position: relative;
    z-index: 1;
    box-shadow: 0 0 0 1px ${(i) => i.theme.colors.primary600};
  }

  @media (prefers-reduced-motion: no-preference) {
    transition: box-shadow ${(i) => i.theme.motion.timings[120]}
      ${(i) => i.theme.motion.easings.easeOutQuad};
  }
`, tc = m.forwardRef(
  ({ caretPosition: i = "left", description: e, icon: t, iconProps: n, children: r, ...o }, s) => {
    const { size: l } = Sr("Trigger");
    return /* @__PURE__ */ $(Rs, { $caretPosition: i, $size: l, ref: s, ...o, children: [
      i === "left" ? /* @__PURE__ */ u(_i, { $size: l, children: /* @__PURE__ */ u(Ze, { width: l === "S" ? "1.2rem" : "1.6rem", height: l === "S" ? "1.2rem" : "1.6rem" }) }) : null,
      /* @__PURE__ */ $(T, { tag: "span", gap: 2, overflow: "hidden", children: [
        t && l === "S" ? /* @__PURE__ */ u(Ts, { children: /* @__PURE__ */ u(t, { ...n }) }) : null,
        /* @__PURE__ */ $(T, { alignItems: "flex-start", direction: "column", tag: "span", ref: s, overflow: "hidden", children: [
          /* @__PURE__ */ u(
            I,
            {
              fontWeight: l === "S" ? "bold" : void 0,
              ellipsis: !0,
              variant: l === "M" ? "delta" : void 0,
              textAlign: "left",
              width: "100%",
              children: r
            }
          ),
          e && l === "M" ? /* @__PURE__ */ u(I, { textAlign: "left", children: e }) : null
        ] })
      ] }),
      i === "right" ? /* @__PURE__ */ u(_i, { $size: l, children: /* @__PURE__ */ u(Ze, { width: l === "S" ? "1.2rem" : "1.6rem", height: l === "S" ? "1.2rem" : "1.6rem" }) }) : null
    ] });
  }
), Ts = x(R)`
  color: ${(i) => i.theme.colors.neutral500};
  display: flex;

  @media (prefers-reduced-motion: no-preference) {
    transition: ${(i) => i.theme.transitions.color};
  }
`, _i = x(T).attrs((i) => ({
  ...i,
  tag: "span"
}))`
  background-color: ${(i) => i.theme.colors.neutral200};
  width: ${(i) => i.$size === "S" ? "2.4rem" : "3.2rem"};
  height: ${(i) => i.$size === "S" ? "2.4rem" : "3.2rem"};
  flex: ${(i) => i.$size === "S" ? "0 0 2.4rem" : "0 0 3.2rem"};
  border-radius: 50%;
  justify-content: center;

  @media (prefers-reduced-motion: no-preference) {
    transition:
      transform ${(i) => i.theme.motion.timings[200]} ${(i) => i.theme.motion.easings.authenticMotion},
      ${(i) => i.theme.transitions.backgroundColor};
  }
`, Rs = x(xi.Trigger)`
  display: flex;
  align-items: center;
  justify-content: ${(i) => i.$caretPosition === "left" ? "flex-start" : "space-between"};
  width: 100%;
  gap: ${(i) => i.theme.spaces[4]};
  padding-inline: ${(i) => i.$size === "S" ? i.theme.spaces[4] : i.theme.spaces[6]};
  padding-block: ${(i) => i.$size === "S" ? i.theme.spaces[3] : i.theme.spaces[6]};
  cursor: pointer;
  color: ${(i) => i.theme.colors.neutral800};
  overflow: hidden;

  &[data-disabled] {
    cursor: default;
    color: ${(i) => i.theme.colors.neutral600};
  }

  &[data-state='open'] > ${_i} {
    transform: rotate(180deg);
  }

  /* we remove the default focus because the entire item should have the focus style and the default would be hidden. */
  &:focus-visible {
    outline: none;
  }

  @media (prefers-reduced-motion: no-preference) {
    transition: ${(i) => i.theme.transitions.color};
  }
`, ic = m.forwardRef((i, e) => {
  const { size: t } = Sr("Trigger");
  return /* @__PURE__ */ u(Ms, { $size: t, ...i, ref: e });
}), Ms = x(T).attrs((i) => ({
  ...i,
  tag: "span"
}))`
  padding-inline: ${(i) => i.$size === "S" ? i.theme.spaces[2] : i.theme.spaces[6]};
  padding-block: ${(i) => i.$size === "S" ? i.theme.spaces[2] : i.theme.spaces[6]};

  // Remove default IconButton styles so there are no backgrounds or borders.
  & > button {
    border: none;
    background: none;
    color: ${(i) => i.theme.colors.neutral600};

    @media (prefers-reduced-motion: no-preference) {
      transition: ${(i) => i.theme.transitions.color};
    }
  }
`, nc = m.forwardRef(({ variant: i = "primary", ...e }, t) => /* @__PURE__ */ u(rc, { $variant: i, ref: t, ...e })), rc = x(xi.Header)`
  display: flex;
  align-items: center;
  background-color: ${(i) => i.$variant === "primary" ? i.theme.colors.neutral0 : i.theme.colors.neutral100};

  &[data-disabled] {
    background-color: ${(i) => i.theme.colors.neutral150};
  }

  &:not([data-disabled]) {
    &:hover,
    &[data-state='open'] {
      background-color: ${(i) => i.theme.colors.primary100};

      & > ${Rs} {
        color: ${(i) => i.theme.colors.primary600};

        & ${Ts} {
          color: ${(i) => i.theme.colors.primary600};
        }

        & ${_i} {
          background-color: ${(i) => i.theme.colors.primary200};
        }
      }

      & > ${Ms} > button {
        color: ${(i) => i.theme.colors.primary600};
      }
    }
  }

  @media (prefers-reduced-motion: no-preference) {
    transition: ${(i) => i.theme.transitions.backgroundColor};
  }
`, oc = m.forwardRef((i, e) => /* @__PURE__ */ u(ac, { ref: e, ...i })), sc = fe`
  from {
    height: 0;
  }
  to {
    height: var(--radix-accordion-content-height);
  }
`, lc = fe`
  from {
    height: var(--radix-accordion-content-height);
  }
  to {
    height: 0;
  }
`, ac = x(xi.Content)`
  overflow: hidden;

  @media (prefers-reduced-motion: no-preference) {
    &[data-state='open'] {
      animation: ${sc} ${(i) => i.theme.motion.timings[320]}
        ${(i) => i.theme.motion.easings.authenticMotion};
    }

    &[data-state='closed'] {
      animation: ${lc} ${(i) => i.theme.motion.timings[320]}
        ${(i) => i.theme.motion.easings.authenticMotion};
    }
  }
`, Sm = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  Actions: ic,
  Content: oc,
  Header: nc,
  Item: Zh,
  Root: Jh,
  Trigger: tc
}, Symbol.toStringTag, { value: "Module" })), on = D`
  position: relative;
  outline: none;

  &:after {
    transition-property: all;
    transition-duration: 0.2s;
    border-radius: 8px;
    content: '';
    position: absolute;
    top: -4px;
    bottom: -4px;
    left: -4px;
    right: -4px;
    border: 2px solid transparent;
  }

  &:focus-visible {
    outline: none;

    &:after {
      border-radius: 8px;
      content: '';
      position: absolute;
      top: -5px;
      bottom: -5px;
      left: -5px;
      right: -5px;
      border: 2px solid ${(i) => i.theme.colors.primary600};
    }
  }
`, lt = ({ tag: i, ...e }) => /* @__PURE__ */ u(hc, { ...e, as: i || "span" }), hc = x.span`
  border: 0;
  clip: rect(0 0 0 0);
  height: 1px;
  margin: -1px;
  overflow: hidden;
  padding: 0;
  position: absolute;
  width: 1px;
`, zt = ({ children: i, label: e }) => {
  const t = m.Children.only(i);
  return /* @__PURE__ */ $(yr, { children: [
    m.cloneElement(t, {
      // accessibility
      "aria-hidden": "true",
      focusable: "false"
      // See: https://allyjs.io/tutorials/focusing-in-svg.html#making-svg-elements-focusable
    }),
    /* @__PURE__ */ u(lt, { children: e })
  ] });
};
zt.displayName = "AccessibleIcon";
const Ds = (i) => {
  switch (i) {
    case "danger":
      return "danger100";
    case "success":
      return "success100";
    case "warning":
      return "warning100";
    default:
      return "primary100";
  }
}, cc = (i) => Ds(i).replace("100", "200"), In = ({ theme: i, $variant: e }) => e === "danger" ? i.colors.danger700 : e === "success" ? i.colors.success700 : e === "warning" ? i.colors.warning700 : i.colors.primary700, dc = x(R)`
  ${on};
`, uc = x(T)`
  svg {
    height: 100%;
    width: 100%;

    path {
      fill: ${In};
    }
  }
`, fc = ({ variant: i, ...e }) => i === "success" ? /* @__PURE__ */ u(fh, { ...e }) : i === "danger" || i === "warning" ? /* @__PURE__ */ u(gh, { ...e }) : /* @__PURE__ */ u(ph, { ...e }), gc = x(R)`
  & a > span {
    color: ${In};
  }

  svg path {
    fill: ${In};
  }
`, Cm = ({
  title: i,
  children: e,
  variant: t = "default",
  onClose: n,
  closeLabel: r,
  titleAs: o = "p",
  action: s,
  ...l
}) => /* @__PURE__ */ $(
  T,
  {
    alignItems: "flex-start",
    background: Ds(t),
    borderColor: cc(t),
    shadow: "filterShadow",
    gap: 3,
    hasRadius: !0,
    padding: 5,
    paddingRight: 6,
    ...l,
    children: [
      /* @__PURE__ */ u(uc, { height: "2rem", shrink: 0, $variant: t, width: "2rem", children: /* @__PURE__ */ u(fc, { "aria-hidden": !0, variant: t }) }),
      /* @__PURE__ */ $(
        T,
        {
          alignItems: "start",
          gap: s ? 2 : 1,
          wrap: "wrap",
          role: t === "danger" ? "alert" : "status",
          width: "100%",
          children: [
            i && /* @__PURE__ */ u(I, { fontWeight: "bold", textColor: "neutral800", tag: o, children: i }),
            /* @__PURE__ */ u(I, { tag: "p", textColor: "neutral800", children: e }),
            s && /* @__PURE__ */ u(gc, { $variant: t, children: s })
          ]
        }
      ),
      /* @__PURE__ */ u(
        dc,
        {
          tag: "button",
          background: "transparent",
          borderColor: void 0,
          height: "1.6rem",
          width: "1.6rem",
          marginTop: 1,
          onClick: n,
          color: "neutral700",
          children: /* @__PURE__ */ u(zt, { label: r, children: /* @__PURE__ */ u(kt, {}) })
        }
      )
    ]
  }
);
function We({ prop: i, defaultProp: e, onChange: t = () => {
} }) {
  const [n, r] = Os({ defaultProp: e, onChange: t }), o = i !== void 0, s = o ? i : n, l = ms(t), a = m.useCallback(
    (c) => {
      if (o) {
        const d = typeof c == "function" ? c(i) : c;
        d !== i && l(d);
      } else
        r(c);
    },
    [o, i, r, l]
  );
  return [s, a];
}
function Os({ defaultProp: i, onChange: e }) {
  const t = m.useState(i), [n] = t, r = m.useRef(n), o = ms(e);
  return m.useEffect(() => {
    r.current !== n && (o(n), r.current = n);
  }, [n, r, o]), t;
}
const Pn = {
  easeInSine: "cubic-bezier(0.47, 0, 0.745, 0.715)",
  easeOutSine: "cubic-bezier(0.39, 0.575, 0.565, 1)",
  easeInOutSine: "cubic-bezier(0.39, 0.575, 0.565, 1)",
  easeInQuad: "cubic-bezier(0.55, 0.085, 0.68, 0.53)",
  easeOutQuad: "cubic-bezier(0.25, 0.46, 0.45, 0.94)",
  easeInOutQuad: "cubic-bezier(0.25, 0.46, 0.45, 0.94)",
  easeInCubic: "cubic-bezier(0.55, 0.055, 0.675, 0.19)",
  easeOutCubic: "cubic-bezier(0.215, 0.61, 0.355, 1)",
  easeInOutCubic: "cubic-bezier(0.215, 0.61, 0.355, 1)",
  easeInQuart: "cubic-bezier(0.895, 0.03, 0.685, 0.22)",
  easeOutQuart: "cubic-bezier(0.165, 0.84, 0.44, 1)",
  easeInOutQuart: "cubic-bezier(0.165, 0.84, 0.44, 1)",
  easeInQuint: "cubic-bezier(0.755, 0.05, 0.855, 0.06)",
  easeOutQuint: "cubic-bezier(0.23, 1, 0.32, 1)",
  easeInOutQuint: "cubic-bezier(0.23, 1, 0.32, 1)",
  easeInExpo: "cubic-bezier(0.95, 0.05, 0.795, 0.035)",
  easeOutExpo: "cubic-bezier(0.19, 1, 0.22, 1)",
  easeInOutExpo: "cubic-bezier(0.19, 1, 0.22, 1)",
  easeInCirc: "cubic-bezier(0.6, 0.04, 0.98, 0.335)",
  easeOutCirc: "cubic-bezier(0.075, 0.82, 0.165, 1)",
  easeInOutCirc: "cubic-bezier(0.075, 0.82, 0.165, 1)",
  easeInBack: "cubic-bezier(0.6, -0.28, 0.735, 0.045)",
  easeOutBack: "cubic-bezier(0.175, 0.885, 0.32, 1.275)",
  easeInOutBack: "cubic-bezier(0.68, -0.55, 0.265, 1.55)",
  easeInOutFast: "cubic-bezier(1,0,0,1)",
  authenticMotion: "cubic-bezier(.4,0,.2,1)"
}, Ln = {
  320: "320ms",
  200: "200ms",
  120: "120ms"
}, pc = {
  color: `color ${Ln[120]} ${Pn.easeOutQuad}`,
  backgroundColor: `background-color ${Ln[120]} ${Pn.easeOutQuad}`
}, te = {
  overlayFadeIn: fe`
    from {
      opacity: 0;
    }
    to {
      opacity: 0.2;
    }
  `,
  modalPopIn: fe`
    from {
      transform:translate(-50%, -50%)  scale(0.8);
      opacity: 0;
    }
    to {
      transform: translate(-50%, -50%) scale(1);
      opacity: 1;
    }
  `,
  modalPopOut: fe`
    from {
      transform: translate(-50%, -50%) scale(1);
      opacity: 1;
    }
    to {
      transform:translate(-50%, -50%)  scale(0.8);
      opacity: 0;
    }
  `,
  popIn: fe`
    from {
      transform: scale(0.8);
      opacity: 0;
    }
    to {
      transform: scale(1);
      opacity: 1;
    }
  `,
  popOut: fe`
    from {
      transform: scale(1);
      opacity: 1;
    }
    to {
      transform: scale(0.8);
      opacity: 0;
    }
  `,
  slideDownIn: fe`
    from {
      opacity: 0;
      transform: translateY(-10px);
    }
    to {
      opacity: 1;
      transform: translateY(0);
    }
  `,
  slideDownOut: fe`
    from {
      opacity: 1;
      transform: translateY(0);
    }
    to {
      opacity: 0;
      transform: translateY(-10px);
    }
  `,
  slideUpIn: fe`
    from {
      opacity: 0;
      transform: translateY(10px);
    }
    to {
      opacity: 1;
      transform: translateY(0);
    }
  `,
  slideUpOut: fe`
    from {
      opacity: 1;
      transform: translateY(0);
    }
    to {
      opacity: 0;
      transform: translateY(10px);
    }
  `,
  fadeIn: fe`
    from {
      opacity: 0;
    }
    to {
      opacity: 1;
    }
  `,
  fadeOut: fe`
    from {
      opacity: 1;
    }
    to {
      opacity: 0;
    }
  `
}, ui = 32, to = 2, mc = m.forwardRef(
  ({ onLoadingStatusChange: i, delayMs: e = 600, src: t, alt: n, fallback: r, preview: o = !1, ...s }, l) => {
    const [a, c] = We({
      onChange: i
    }), [h, d] = m.useState(!1), f = o && a === "loaded", g = (p) => {
      f && d(p);
    };
    return /* @__PURE__ */ $(rt.Root, { onOpenChange: g, children: [
      /* @__PURE__ */ u(rt.Trigger, { asChild: !0, children: /* @__PURE__ */ $(Bn, { ref: l, ...s, children: [
        f ? /* @__PURE__ */ u(
          bc,
          {
            width: "100%",
            height: "100%",
            position: "absolute",
            background: "neutral0",
            zIndex: "overlay",
            style: { opacity: h ? 0.4 : 0 }
          }
        ) : null,
        /* @__PURE__ */ u(yc, { src: t, alt: n, onLoadingStatusChange: c }),
        /* @__PURE__ */ u(xr.Fallback, { delayMs: e, children: /* @__PURE__ */ u(I, { fontWeight: "bold", textTransform: "uppercase", children: r }) })
      ] }) }),
      f ? /* @__PURE__ */ u(rt.Portal, { children: /* @__PURE__ */ u(wc, { side: "top", sideOffset: 4, children: /* @__PURE__ */ u(xc, { src: t, alt: n }) }) }) : null
    ] });
  }
), Es = D`
  display: inline-flex;
  align-items: center;
  justify-content: center;
  vertical-align: middle;
  overflow: hidden;
  user-select: none;
  overflow: hidden;
  border-radius: 50%;
`, Is = D`
  width: 100%;
  height: 100%;
  object-fit: cover;
  border-radius: inherit;
`, Bn = x(xr.Root)`
  position: relative;
  z-index: 0;
  ${Es}
  width: ${ui / 10}rem;
  height: ${ui / 10}rem;
  /* TODO: we should get the user email & hash it to turn it into a hex-value so different emails can consistently get a different background */
  background-color: ${(i) => i.theme.colors.primary600};
  color: ${(i) => i.theme.colors.neutral0};
`, bc = x(R)`
  @media (prefers-reduced-motion: no-preference) {
    transition: opacity ${(i) => i.theme.motion.timings[200]}
      ${(i) => i.theme.motion.easings.authenticMotion};
  }
`, yc = x(xr.Image)`
  ${Is}
`, wc = x(rt.Content)`
  ${Es}
  width: ${ui * to / 10}rem;
  height: ${ui * to / 10}rem;

  @media (prefers-reduced-motion: no-preference) {
    animation: ${te.fadeIn} ${(i) => i.theme.motion.timings[200]}
      ${(i) => i.theme.motion.easings.authenticMotion};
  }
`, xc = x.img`
  ${Is}
`, vc = m.forwardRef((i, e) => /* @__PURE__ */ u(Sc, { ...i, ref: e, tag: "div" })), Sc = x(T)`
  & > ${Bn} + ${Bn} {
    margin-left: -${ui / 10 / 2}rem;
  }
`, km = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  Group: vc,
  Item: mc
}, Symbol.toStringTag, { value: "Module" })), Ps = ({
  active: i = !1,
  size: e = "M",
  textColor: t = "neutral600",
  backgroundColor: n = "neutral150",
  variant: r,
  children: o,
  minWidth: s = 5,
  ...l
}) => {
  const a = e === "S" ? 1 : 2, c = r ? {
    backgroundColor: `${r}200`,
    textColor: `${r}700`
  } : {
    backgroundColor: n,
    textColor: t
  };
  return /* @__PURE__ */ u(
    Cc,
    {
      inline: !0,
      alignItems: "center",
      justifyContent: "center",
      minWidth: s,
      paddingLeft: a,
      paddingRight: a,
      background: i ? "primary200" : c.backgroundColor,
      $size: e,
      ...l,
      children: /* @__PURE__ */ u(I, { variant: "sigma", textColor: i ? "primary600" : c.textColor, lineHeight: "1rem", children: o })
    }
  );
}, Cc = x(T)`
  border-radius: ${({ theme: i, $size: e }) => e === "S" ? "2px" : i.borderRadius};
  ${({ $size: i, theme: e }) => i === "S" ? D`
        padding-block: 0.3rem;
        padding-inline ${e.spaces[1]}
      ` : D`
      padding-block: 0.7rem;
      padding-inline ${e.spaces[2]}
    `};
`, kc = x(R)`
  text-decoration: none;

  &:visited {
    color: inherit;
  }
`, vi = xe(
  ({ href: i, disabled: e = !1, isExternal: t = !1, ...n }, r) => /* @__PURE__ */ u(
    kc,
    {
      tag: "a",
      ref: r,
      target: t ? "_blank" : void 0,
      rel: t ? "noreferrer noopener" : void 0,
      href: i,
      tabIndex: e ? -1 : void 0,
      "aria-disabled": e,
      pointerEvents: e ? "none" : void 0,
      cursor: e ? void 0 : "pointer",
      ...n
    }
  )
), Ls = () => /* @__PURE__ */ u(R, { "aria-hidden": !0, paddingLeft: 1, paddingRight: 1, children: /* @__PURE__ */ u(I, { variant: "pi", textColor: "neutral500", children: "/" }) });
Ls.displayName = "Divider";
const $c = x(T)`
  // CrumbLinks do have padding-x, because they need to have a
  // interaction effect, which mis-aligns the breadcrumbs on the left.
  // This normalizes the behavior by moving the first item to left by
  // the same amount it has inner padding
  & > *:first-child {
    margin-left: ${({ theme: i }) => `calc(-1*${i.spaces[2]})`};
  }
`, Ac = m.forwardRef(
  ({ label: i, children: e, ...t }, n) => {
    const r = m.Children.toArray(e);
    return /* @__PURE__ */ u(R, { "aria-label": i, tag: "nav", ...t, ref: n, children: /* @__PURE__ */ u($c, { tag: "ol", children: m.Children.map(r, (o, s) => {
      const l = r.length > 1 && s + 1 < r.length;
      return /* @__PURE__ */ $(T, { inline: !0, tag: "li", children: [
        o,
        l && /* @__PURE__ */ u(Ls, {})
      ] });
    }) }) });
  }
);
Ac.displayName = "Breadcrumbs";
const Tc = m.forwardRef(
  ({ children: i, isCurrent: e = !1, ...t }, n) => /* @__PURE__ */ u(R, { paddingLeft: 2, paddingRight: 2, paddingTop: 1, paddingBottom: 1, ref: n, children: /* @__PURE__ */ u(
    I,
    {
      variant: "pi",
      textColor: "neutral800",
      fontWeight: e ? "bold" : "regular",
      "aria-current": e,
      ...t,
      children: i
    }
  ) })
);
Tc.displayName = "Crumb";
const Rc = x(vi)`
  border-radius: ${({ theme: i }) => i.borderRadius};
  color: ${({ theme: i }) => i.colors.neutral600};
  font-size: ${({ theme: i }) => i.fontSizes[1]};
  line-height: ${({ theme: i }) => i.lineHeights[4]};
  padding: ${({ theme: i }) => `${i.spaces[1]} ${i.spaces[2]}`};
  text-decoration: none;

  :hover,
  :focus {
    background-color: ${({ theme: i }) => i.colors.neutral200};
    color: ${({ theme: i }) => i.colors.neutral700};
  }
`, Mc = m.forwardRef(({ children: i, ...e }, t) => /* @__PURE__ */ u(Rc, { ref: t, ...e, children: i }));
Mc.displayName = "CrumbLink";
const Nt = (i) => i.replaceAll(":", "");
function Dc(i, e) {
  typeof i == "function" ? i(e) : i != null && (i.current = e);
}
function Bs(...i) {
  return (e) => i.forEach((t) => Dc(t, e));
}
function ve(...i) {
  return m.useCallback(Bs(...i), i);
}
const Oc = () => typeof window > "u" || !window.navigator || /ServerSideRendering|^Deno\//.test(window.navigator.userAgent), He = Oc() ? gs : Za, Ec = m.useId || (() => {
});
let Ic = 0;
const Se = (i) => {
  const [e, t] = m.useState(Ec());
  return He(() => {
    i || t((n) => n ?? String(Ic++));
  }, [i]), (i == null ? void 0 : i.toString()) ?? (e || "");
}, Si = (i, e, { selectorToWatch: t, skipWhen: n = !1 }) => {
  const r = ws(e);
  m.useEffect(() => {
    if (n || !i.current) return;
    const o = {
      root: i.current,
      rootMargin: "0px"
    }, s = (c) => {
      c.forEach((h) => {
        h.isIntersecting && i.current && i.current.scrollHeight > i.current.clientHeight && r(h);
      });
    }, l = new IntersectionObserver(s, o), a = i.current.querySelector(t);
    return a && l.observe(a), () => {
      l.disconnect();
    };
  }, [n, r, t, i]);
}, Cr = "success-light", kr = "danger-light", sn = "default", Ci = "tertiary", ki = "secondary", zs = "danger", Ns = "success", ln = "ghost", $r = [Cr, kr], Pc = [sn, Ci, ki, zs, Ns, ln, ...$r], Lc = ["XS", "S", "M", "L"], De = (i) => i === Cr || i === kr ? `${i.substring(0, i.lastIndexOf("-"))}` : i === Ci ? "neutral" : i === sn || i === ki || Pc.every((e) => e !== i) ? "primary" : `${i}`, Fs = ({ theme: i }) => D`
    border: 1px solid ${i.colors.neutral200};
    background: ${i.colors.neutral150};
    color: ${i.colors.neutral600};
    cursor: default;
  `, Ws = ({ theme: i, $variant: e }) => [...$r, ki].includes(e) ? D`
      background-color: ${i.colors.neutral0};
    ` : e === Ci ? D`
      background-color: ${i.colors.neutral100};
    ` : e === ln ? D`
      background-color: ${i.colors.neutral100};
    ` : e === sn ? D`
      border: 1px solid ${i.colors.buttonPrimary500};
      background: ${i.colors.buttonPrimary500};
    ` : D`
    border: 1px solid ${i.colors[`${De(e)}500`]};
    background: ${i.colors[`${De(e)}500`]};
  `, Hs = ({ theme: i, $variant: e }) => [...$r, ki].includes(e) ? D`
      background-color: ${i.colors.neutral0};
      border: 1px solid ${i.colors[`${De(e)}600`]};
      color: ${i.colors[`${De(e)}600`]};
    ` : e === Ci || e === ln ? D`
      background-color: ${i.colors.neutral150};
    ` : D`
    border: 1px solid ${i.colors[`${De(e)}600`]};
    background: ${i.colors[`${De(e)}600`]};
  `, Vs = ({ theme: i, $variant: e }) => {
  switch (e) {
    case kr:
    case Cr:
    case ki:
      return D`
        border: 1px solid ${i.colors[`${De(e)}200`]};
        background: ${i.colors[`${De(e)}100`]};
        color: ${i.colors[`${De(e)}700`]};
      `;
    case Ci:
      return D`
        border: 1px solid ${i.colors.neutral200};
        background: ${i.colors.neutral0};
        color: ${i.colors.neutral800};
      `;
    case ln:
      return D`
        border: 1px solid transparent;
        background: transparent;
        color: ${i.colors.neutral800};

        svg {
          fill: ${i.colors.neutral500};
        }
      `;
    case Ns:
    case zs:
      return D`
        border: 1px solid ${i.colors[`${De(e)}600`]};
        background: ${i.colors[`${De(e)}600`]};
        color: ${i.colors.neutral0};
      `;
    default:
      return D`
        border: 1px solid ${i.colors.buttonPrimary600};
        background: ${i.colors.buttonPrimary600};
        color: ${i.colors.buttonNeutral0};
      `;
  }
}, zn = xe(
  ({
    variant: i = sn,
    startIcon: e,
    endIcon: t,
    disabled: n = !1,
    children: r,
    onClick: o,
    size: s = Lc[1],
    loading: l = !1,
    fullWidth: a = !1,
    type: c = "button",
    ...h
  }, d) => {
    const f = n || l, g = (w) => {
      !f && o && o(w);
    }, p = h.tag ?? "button";
    return /* @__PURE__ */ $(
      Nc,
      {
        ref: d,
        "aria-disabled": f,
        disabled: f,
        $size: s,
        $variant: i,
        tag: "button",
        onClick: g,
        hasRadius: !0,
        gap: 2,
        inline: !0,
        alignItems: "center",
        justifyContent: "center",
        width: a ? "100%" : void 0,
        paddingLeft: 4,
        paddingRight: 4,
        cursor: "pointer",
        type: p === "button" || p === "input" ? c : void 0,
        ...h,
        children: [
          (e || l) && /* @__PURE__ */ u(T, { tag: "span", "aria-hidden": !0, children: l ? /* @__PURE__ */ u(zc, {}) : e }),
          /* @__PURE__ */ u(I, { variant: s === "S" ? "pi" : void 0, fontWeight: "bold", children: r }),
          t && /* @__PURE__ */ u(T, { tag: "span", "aria-hidden": !0, children: t })
        ]
      }
    );
  }
), Bc = fe`
  from {
    transform: rotate(0deg);
  }
  to {
    transform: rotate(359deg);
  }
`, zc = x(xs)`
  animation: ${Bc} 2s infinite linear;
  will-change: transform;
`, Nc = x(T)`
  ${({ theme: i, $size: e }) => {
  const t = i.sizes.button[e];
  if (typeof t == "string")
    return `height: ${t};`;
  const n = [];
  return Object.entries(t).forEach(([r, o]) => {
    if (o) {
      if (r === "initial")
        n.push(`height: ${o};`);
      else if (r in i.breakpoints) {
        const s = i.breakpoints[r];
        n.push(`${s} { height: ${o}; }`);
      }
    }
  }), n.join(`
`);
}}
  text-decoration: none;
  ${Vs}

  &:hover {
    ${Ws}
  }

  &:active {
    ${Hs}
  }

  &[aria-disabled='true'] {
    ${Fs}
  }

  @media (prefers-reduced-motion: no-preference) {
    transition:
      ${(i) => i.theme.transitions.backgroundColor},
      ${(i) => i.theme.transitions.color},
      border-color ${(i) => i.theme.motion.timings[200]} ${(i) => i.theme.motion.easings.easeOutQuad};
  }
`, Ar = m.forwardRef(
  ({
    children: i,
    description: e,
    label: t,
    defaultOpen: n,
    open: r,
    onOpenChange: o,
    delayDuration: s = 500,
    disableHoverableContent: l,
    ...a
  }, c) => !t && !e ? i : /* @__PURE__ */ $(
    rt.Root,
    {
      defaultOpen: n,
      open: r,
      onOpenChange: o,
      delayDuration: s,
      disableHoverableContent: l,
      children: [
        /* @__PURE__ */ u(rt.Trigger, { asChild: !0, children: i }),
        /* @__PURE__ */ u(rt.Portal, { children: /* @__PURE__ */ u(Fc, { ref: c, sideOffset: 8, ...a, children: /* @__PURE__ */ u(I, { variant: "pi", fontWeight: "bold", children: t || e }) }) })
      ]
    }
  )
), Fc = x(rt.Content)`
  background-color: ${(i) => i.theme.colors.neutral900};
  color: ${(i) => i.theme.colors.neutral0};
  padding-inline: ${(i) => i.theme.spaces[2]};
  padding-block: ${(i) => i.theme.spaces[2]};
  border-radius: ${(i) => i.theme.borderRadius};
  z-index: ${(i) => i.theme.zIndices.tooltip};
  will-change: opacity;
  transform-origin: var(--radix-tooltip-content-transform-origin);

  @media (prefers-reduced-motion: no-preference) {
    animation: ${te.fadeIn} ${(i) => i.theme.motion.timings[200]}
      ${(i) => i.theme.motion.easings.authenticMotion};
  }
`, ot = xe(
  ({
    label: i,
    background: e,
    children: t,
    disabled: n = !1,
    onClick: r,
    size: o = "S",
    variant: s = "tertiary",
    withTooltip: l = !0,
    type: a = "button",
    ...c
  }, h) => {
    const f = /* @__PURE__ */ u(
      ni,
      {
        "aria-disabled": n,
        background: n ? "neutral150" : e,
        tag: "button",
        display: "inline-flex",
        justifyContent: "center",
        hasRadius: !0,
        cursor: "pointer",
        ...c,
        ref: h,
        $size: o,
        onClick: (g) => {
          !n && r && r(g);
        },
        $variant: s,
        type: a,
        children: /* @__PURE__ */ u(zt, { label: i, children: t })
      }
    );
    return l ? /* @__PURE__ */ u(Ar, { label: i, children: f }) : f;
  }
), ni = x(T)`
  text-decoration: none;

  ${(i) => {
  switch (i.$size) {
    case "XS":
      return D`
          padding-block: 0.7rem;
          padding-inline: 0.7rem;

          ${({ theme: e }) => e.breakpoints.medium} {
            padding-block: 0.2rem;
            padding-inline: 0.2rem;
          }
        `;
    case "S":
      return D`
          padding-block: 1.1rem;
          padding-inline: 1.1rem;

          ${({ theme: e }) => e.breakpoints.medium} {
            padding-block: 0.7rem;
            padding-inline: 0.7rem;
          }
        `;
    case "M":
      return D`
          padding-block: 1.1rem;
          padding-inline: 1.1rem;

          ${({ theme: e }) => e.breakpoints.medium} {
            padding-block: 0.9rem;
            padding-inline: 0.9rem;
          }
        `;
    case "L":
      return D`
          padding-block: 1.5rem;
          padding-inline: 1.5rem;

          ${({ theme: e }) => e.breakpoints.medium} {
            padding-block: 1.1rem;
            padding-inline: 1.1rem;
          }
        `;
  }
}}
  ${Vs}
  ${(i) => i.$variant === "tertiary" ? D`
          color: ${i.theme.colors.neutral500};
        ` : ""}

  &:hover {
    ${Ws}
    ${(i) => i.$variant === "tertiary" ? D`
            color: ${i.theme.colors.neutral600};
          ` : ""}
  }

  &:active {
    ${Hs}
  }

  &[aria-disabled='true'] {
    ${Fs}
  }

  @media (prefers-reduced-motion: no-preference) {
    transition:
      ${(i) => i.theme.transitions.backgroundColor},
      ${(i) => i.theme.transitions.color},
      border-color ${(i) => i.theme.motion.timings[200]} ${(i) => i.theme.motion.easings.easeOutQuad};
  }
`, $m = x(T)`
  & ${ni}:first-child {
    border-radius: ${({ theme: i }) => `${i.borderRadius} 0 0 ${i.borderRadius}`};
  }

  & ${ni}:last-child {
    border-radius: ${({ theme: i }) => `0 ${i.borderRadius} ${i.borderRadius} 0`};
  }

  & ${ni} {
    border-radius: 0;

    & + ${ni} {
      border-left: none;
    }
  }
`, Wc = xe(
  ({
    children: i,
    href: e,
    disabled: t = !1,
    startIcon: n,
    endIcon: r,
    isExternal: o = !1,
    color: s = "primary600",
    activeColor: l = "primary700",
    ...a
  }, c) => /* @__PURE__ */ $(
    Hc,
    {
      ref: c,
      href: e,
      disabled: t,
      isExternal: o,
      $activeColor: l,
      $color: s,
      ...a,
      children: [
        n,
        /* @__PURE__ */ u(I, { textColor: t ? "neutral600" : s, children: i }),
        r,
        e && !r && o && /* @__PURE__ */ u(mh, { fill: s })
      ]
    }
  )
), Hc = x(vi)`
  display: inline-flex;
  align-items: center;
  text-decoration: none;
  gap: ${({ theme: i }) => i.spaces[2]};
  pointer-events: ${({ disabled: i }) => i ? "none" : void 0};

  svg {
    font-size: 1rem;

    path {
      fill: ${({ disabled: i, $color: e, theme: t }) => i ? t.colors.neutral600 : t.colors[e || "primary600"]};
    }
  }

  &:hover {
    & > span {
      color: ${({ theme: i, $color: e }) => i.colors[e || "primary600"]};
    }

    svg path {
      fill: ${({ theme: i, $color: e }) => i.colors[e || "primary600"]};
    }
  }

  &:active {
    color: ${({ theme: i, $activeColor: e }) => i.colors[e || "primary700"]};
  }

  ${on};
`, Vc = (i) => {
  switch (i) {
    case "danger":
      return "danger100";
    default:
      return "primary100";
  }
}, Nn = (i, e) => {
  switch (i) {
    case "danger":
      return e ? "danger500" : "danger700";
    default:
      return e ? "neutral500" : "neutral800";
  }
}, li = (i, e) => {
  switch (i) {
    case "danger":
      return e ? "danger500" : "danger700";
    default:
      return e ? "neutral300" : "neutral500";
  }
}, jc = Ee.Root, qc = m.forwardRef(
  ({ label: i, endIcon: e = /* @__PURE__ */ u(Ze, { width: "1.2rem", height: "1.2rem", "aria-hidden": !0 }), tag: t = zn, icon: n, ...r }, o) => {
    const s = {
      ...r,
      ref: o,
      type: "button"
    };
    return /* @__PURE__ */ u(Ee.Trigger, { asChild: !0, disabled: s.disabled, children: t === ot ? /* @__PURE__ */ u(ot, { label: i, variant: "tertiary", ...s, children: n }) : /* @__PURE__ */ u(zn, { endIcon: e, variant: "ghost", ...s }) });
  }
), Kc = m.forwardRef(
  ({ children: i, intersectionId: e, onCloseAutoFocus: t, popoverPlacement: n = "bottom-start", ...r }, o) => {
    const [s, l] = n.split("-");
    return /* @__PURE__ */ u(Ee.Portal, { children: /* @__PURE__ */ u(Uc, { align: l, side: s, loop: !0, onCloseAutoFocus: t, asChild: !0, children: /* @__PURE__ */ $(
      js,
      {
        ref: o,
        direction: "column",
        borderColor: "neutral150",
        hasRadius: !0,
        background: "neutral0",
        shadow: "filterShadow",
        maxHeight: "15rem",
        padding: 1,
        marginTop: 1,
        marginBottom: 1,
        alignItems: "flex-start",
        position: "relative",
        overflow: "auto",
        ...r,
        children: [
          i,
          /* @__PURE__ */ u(R, { id: e, width: "100%", height: "1px" })
        ]
      }
    ) }) });
  }
), js = x(T)`
  scrollbar-width: none;
  -ms-overflow-style: none;
  -webkit-overflow-scrolling: touch;
  z-index: ${(i) => i.theme.zIndices.popover};

  &::-webkit-scrollbar {
    display: none;
  }
`, Uc = x(Ee.Content)`
  @media (prefers-reduced-motion: no-preference) {
    animation-duration: ${(i) => i.theme.motion.timings[200]};

    &[data-state='open'] {
      animation-timing-function: ${(i) => i.theme.motion.easings.authenticMotion};

      &[data-side='top'] {
        animation-name: ${te.slideUpIn};
      }

      &[data-side='bottom'] {
        animation-name: ${te.slideDownIn};
      }
    }
  }
`, _c = ({
  onSelect: i,
  disabled: e = !1,
  isLink: t,
  startIcon: n,
  endIcon: r,
  isExternal: o,
  variant: s = "default",
  ...l
}) => /* @__PURE__ */ u(Ee.Item, { asChild: !0, onSelect: i, disabled: e, children: t || o ? /* @__PURE__ */ u(
  Gc,
  {
    color: Nn(s, e),
    startIcon: n,
    endIcon: r,
    ...l,
    isExternal: o ?? !1,
    $variant: s,
    children: l.children
  }
) : /* @__PURE__ */ $(
  Ks,
  {
    cursor: "pointer",
    color: Nn(s, e),
    background: "transparent",
    borderStyle: "none",
    gap: 2,
    $variant: s,
    ...l,
    children: [
      n && /* @__PURE__ */ u(T, { tag: "span", color: li(s, e), "aria-hidden": !0, children: n }),
      /* @__PURE__ */ u(I, { grow: 1, children: l.children }),
      r && /* @__PURE__ */ u(T, { tag: "span", color: li(s, e), "aria-hidden": !0, children: r })
    ]
  }
) }), qs = ({ theme: i, $variant: e }) => D`
  text-align: left;
  width: 100%;
  border-radius: ${i.borderRadius};
  padding: ${i.spaces[2]} ${i.spaces[4]};

  &[aria-disabled='true'] {
    cursor: not-allowed;
  }

  &[data-highlighted] {
    background-color: ${i.colors[Vc(e)]};
  }

  &:focus-visible {
    outline: none;

    &:after {
      content: none;
    }
  }

  color: ${i.colors[Nn(e, !1)]};
`, Ks = x(T)`
  ${({ theme: i, $variant: e }) => qs({ theme: i, $variant: e })}
`, Gc = x(Wc)`
  /* We include this here again because typically when people use OptionLink they provide an as prop which cancels the Box props */
  color: ${({ theme: i, color: e }) => Wi(i.colors, e, void 0)};
  text-decoration: none;

  &:hover {
    color: unset;

    > svg {
      path {
        fill: ${({ theme: i, $variant: e }) => i.colors[li(e, !1)]};
      }
    }
  }
  > svg {
    path {
      fill: ${({ theme: i, $variant: e }) => i.colors[li(e, !1)]};
    }
  }
  &[aria-disabled='true'] {
    pointer-events: none;

    > svg {
      path {
        fill: ${({ theme: i, $variant: e }) => i.colors[li(e, !0)]};
      }
    }
  }

  ${({ theme: i, $variant: e }) => qs({ theme: i, $variant: e })}
`, Yc = x(R)`
  /* Negative horizontal margin to compensate Menu.Content's padding */
  margin: ${({ theme: i }) => i.spaces[1]} -${({ theme: i }) => i.spaces[1]};
  width: calc(100% + ${({ theme: i }) => i.spaces[2]});
  /* Hide separator if there's nothing above in the menu */
  &:first-child {
    display: none;
  }
`, Xc = m.forwardRef((i, e) => /* @__PURE__ */ u(Ee.Separator, { ...i, asChild: !0, children: /* @__PURE__ */ u(Yc, { height: "1px", shrink: 0, background: "neutral150", ref: e }) })), Jc = m.forwardRef((i, e) => /* @__PURE__ */ u(Ee.Label, { asChild: !0, children: /* @__PURE__ */ u(Qc, { ref: e, variant: "sigma", textColor: "neutral600", ...i }) })), Qc = x(I)`
  padding: ${({ theme: i }) => i.spaces[2]} ${({ theme: i }) => i.spaces[4]};
`, Zc = Ee.Sub, ed = m.forwardRef(({ disabled: i = !1, ...e }, t) => /* @__PURE__ */ u(Ee.SubTrigger, { asChild: !0, disabled: i, children: /* @__PURE__ */ $(
  td,
  {
    ref: t,
    color: "neutral800",
    tag: "button",
    type: "button",
    background: "transparent",
    borderStyle: "none",
    gap: 5,
    ...e,
    children: [
      /* @__PURE__ */ u(I, { children: e.children }),
      /* @__PURE__ */ u(wr, { fill: "neutral500", height: "1.2rem", width: "1.2rem" })
    ]
  }
) })), td = x(Ks)`
  &[data-state='open'] {
    background-color: ${({ theme: i }) => i.colors.primary100};
  }
`, id = m.forwardRef((i, e) => /* @__PURE__ */ u(Ee.Portal, { children: /* @__PURE__ */ u(Ee.SubContent, { sideOffset: 8, asChild: !0, children: /* @__PURE__ */ u(
  js,
  {
    ref: e,
    direction: "column",
    borderStyle: "solid",
    borderWidth: "1px",
    borderColor: "neutral150",
    hasRadius: !0,
    background: "neutral0",
    shadow: "filterShadow",
    maxHeight: "15rem",
    padding: 1,
    alignItems: "flex-start",
    overflow: "auto",
    ...i
  }
) }) })), Us = jc, _s = qc, Gs = Kc, Ys = _c, nd = Xc, rd = Jc, od = Zc, sd = ed, ld = id, Am = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  Content: Gs,
  Item: Ys,
  Label: rd,
  Root: Us,
  Separator: nd,
  SubContent: ld,
  SubRoot: od,
  SubTrigger: sd,
  Trigger: _s
}, Symbol.toStringTag, { value: "Module" })), ad = m.forwardRef(
  ({ children: i, onOpen: e, onClose: t, popoverPlacement: n, onReachEnd: r, ...o }, s) => {
    const l = m.useRef(null), a = ve(s, l), c = m.useRef(null), [h, d] = m.useState(!1), f = (w) => {
      r && r(w);
    }, g = (w) => {
      w && typeof e == "function" ? e() : !w && typeof t == "function" && t(), d(w);
    }, p = Se(), b = `intersection-${Nt(p)}`;
    return Si(c, f, {
      selectorToWatch: `#${b}`,
      /**
       * We need to know when the select is open because only then will viewportRef
       * not be null. Because it uses a portal that (sensibly) is not mounted 24/7.
       */
      skipWhen: !h
    }), /* @__PURE__ */ $(Us, { onOpenChange: g, children: [
      /* @__PURE__ */ u(_s, { ref: a, ...o, children: o.label }),
      /* @__PURE__ */ u(Gs, { ref: c, intersectionId: b, popoverPlacement: n, children: i })
    ] });
  }
), Tm = Ys, hd = x(ad)`
  padding: ${({ theme: i }) => `${i.spaces[1]} ${i.spaces[2]}`};
  height: unset;

  :hover,
  :focus {
    background-color: ${({ theme: i }) => i.colors.neutral200};
  }
`, cd = m.forwardRef(
  ({ children: i, ...e }, t) => /* @__PURE__ */ u(hd, { ref: t, endIcon: null, size: "S", ...e, children: i })
);
cd.displayName = "CrumbSimpleMenu";
const Xs = m.createContext({ id: "" }), Js = () => m.useContext(Xs), Rm = m.forwardRef(({ id: i, ...e }, t) => {
  const n = Se(i), r = m.useMemo(() => ({ id: n }), [n]);
  return /* @__PURE__ */ u(Xs.Provider, { value: r, children: /* @__PURE__ */ u(
    R,
    {
      ref: t,
      id: i,
      tabIndex: 0,
      hasRadius: !0,
      background: "neutral0",
      borderStyle: "solid",
      borderWidth: "1px",
      borderColor: "neutral150",
      shadow: "tableShadow",
      tag: "article",
      "aria-labelledby": `${n}-title`,
      ...e
    }
  ) });
}), dd = m.forwardRef(({ position: i, ...e }, t) => /* @__PURE__ */ u(ud, { ref: t, $position: i, ...e, direction: "row", gap: 2 })), ud = x(T)`
  position: absolute;
  top: ${({ theme: i }) => i.spaces[3]};
  right: ${({ $position: i, theme: e }) => {
  if (i === "end")
    return e.spaces[3];
}};
  left: ${({ $position: i, theme: e }) => {
  if (i === "start")
    return e.spaces[3];
}};
`, Mm = ({ size: i = "M", children: e, ...t }) => /* @__PURE__ */ u(gd, { $size: i, children: e || /* @__PURE__ */ u(fd, { ...t, "aria-hidden": !0 }) }), fd = x.img`
  // inline flows is based on typography and displays an extra white space below the image
  // switch to block is required in order to make the img stick the bottom of the container
  // addition infos: https://stackoverflow.com/questions/5804256/image-inside-div-has-extra-space-below-the-image
  margin: 0;
  padding: 0;
  max-height: 100%;
  max-width: 100%;
  object-fit: contain;
`, gd = x.div`
  display: flex;
  justify-content: center;
  height: ${({ $size: i }) => i === "S" ? "8.8rem" : "16.4rem"};
  width: 100%;
  background: repeating-conic-gradient(${({ theme: i }) => i.colors.neutral100} 0% 25%, transparent 0% 50%) 50% / 20px
    20px;
  border-top-left-radius: ${({ theme: i }) => i.borderRadius};
  border-top-right-radius: ${({ theme: i }) => i.borderRadius};
`, pd = x.div`
  margin-left: auto;
  flex-shrink: 0;
`, md = x(Ps)`
  margin-left: ${({ theme: i }) => i.spaces[1]};
`, Dm = (i) => /* @__PURE__ */ u(pd, { children: /* @__PURE__ */ u(md, { ...i }) }), Om = (i) => /* @__PURE__ */ u(R, { paddingLeft: 3, paddingRight: 3, paddingTop: 2, paddingBottom: 2, children: /* @__PURE__ */ u(T, { ...i, alignItems: "flex-start" }) }), bd = ({ fill: i, ...e }) => {
  const { colors: t } = Xa();
  return /* @__PURE__ */ u(
    R,
    {
      tag: "svg",
      viewBox: "0 0 32 32",
      xmlns: "http://www.w3.org/2000/svg",
      fill: i ? t[i] : void 0,
      ...e,
      children: /* @__PURE__ */ u("path", { d: "M29.0613 10.0613L13.0613 26.0613C12.9219 26.2011 12.7563 26.3121 12.574 26.3878C12.3917 26.4635 12.1962 26.5024 11.9988 26.5024C11.8013 26.5024 11.6059 26.4635 11.4235 26.3878C11.2412 26.3121 11.0756 26.2011 10.9363 26.0613L3.93626 19.0613C3.79673 18.9217 3.68605 18.7561 3.61053 18.5738C3.53502 18.3915 3.49615 18.1961 3.49615 17.9988C3.49615 17.8014 3.53502 17.606 3.61053 17.4237C3.68605 17.2414 3.79673 17.0758 3.93626 16.9363C4.07579 16.7967 4.24143 16.686 4.42374 16.6105C4.60604 16.535 4.80143 16.4962 4.99876 16.4962C5.19608 16.4962 5.39147 16.535 5.57378 16.6105C5.75608 16.686 5.92173 16.7967 6.06126 16.9363L12 22.875L26.9388 7.93876C27.2205 7.65697 27.6027 7.49866 28.0013 7.49866C28.3998 7.49866 28.782 7.65697 29.0638 7.93876C29.3455 8.22055 29.5039 8.60274 29.5039 9.00126C29.5039 9.39977 29.3455 9.78197 29.0638 10.0638L29.0613 10.0613Z" })
    }
  );
}, io = m.forwardRef(
  ({ defaultChecked: i, checked: e, onCheckedChange: t, ...n }, r) => {
    const o = m.useRef(null), [s, l] = We({
      defaultProp: i,
      prop: e,
      onChange: t
    }), a = ve(o, r);
    return /* @__PURE__ */ u(yd, { ref: a, checked: s, onCheckedChange: l, ...n, children: /* @__PURE__ */ $(wd, { forceMount: !0, children: [
      s === !0 ? /* @__PURE__ */ u(bd, { width: "1.6rem", fill: "neutral0" }) : null,
      s === "indeterminate" ? /* @__PURE__ */ u(bh, { fill: "neutral0" }) : null
    ] }) });
  }
), yd = x(Cs.Root)`
  background: ${(i) => i.theme.colors.neutral0};
  width: 2rem;
  height: 2rem;
  border-radius: ${(i) => i.theme.borderRadius};
  border: 1px solid ${(i) => i.theme.colors.neutral300};
  position: relative;
  z-index: 0;
  display: flex;
  justify-content: center;
  align-items: center;
  // this ensures the checkbox is always a square even in flex-containers.
  flex: 0 0 2rem;

  &[data-state='checked']:not([data-disabled]),
  &[data-state='indeterminate']:not([data-disabled]) {
    border: 1px solid ${(i) => i.theme.colors.primary600};
    background-color: ${(i) => i.theme.colors.primary600};
  }

  &[data-disabled] {
    background-color: ${(i) => i.theme.colors.neutral200};
  }

  /* increase target size for touch devices https://www.w3.org/WAI/WCAG21/Understanding/target-size.html */
  &::before {
    content: '';
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    width: 100%;
    height: 100%;
    z-index: -1;
    min-width: 44px;
    min-height: 44px;
  }
`, wd = x(Cs.Indicator)`
  display: inline-flex;
  pointer-events: auto !important;
  width: 100%;
  height: 100%;
  cursor: pointer;
  justify-content: center;
  align-items: center;

  &[data-disabled] {
    cursor: not-allowed;
  }
`, Tr = m.forwardRef(({ children: i, ...e }, t) => {
  const n = Se(e.id);
  return i ? /* @__PURE__ */ $(T, { gap: 2, children: [
    /* @__PURE__ */ u(io, { id: n, ...e }),
    /* @__PURE__ */ u(I, { tag: "label", textColor: "neutral800", htmlFor: n, children: i })
  ] }) : /* @__PURE__ */ u(io, { ref: t, ...e });
}), Em = m.forwardRef((i, e) => {
  const { id: t } = Js();
  return /* @__PURE__ */ u(dd, { position: "start", children: /* @__PURE__ */ u(Tr, { "aria-labelledby": `${t}-title`, ...i, ref: e }) });
}), xd = x(R)`
  word-break: break-all;
`, Im = ({ children: i, ...e }) => /* @__PURE__ */ u(xd, { ...e, children: i }), vd = x(T)`
  border-bottom: 1px solid ${({ theme: i }) => i.colors.neutral150};
`, Pm = (i) => /* @__PURE__ */ u(vd, { position: "relative", justifyContent: "center", ...i }), Lm = ({ children: i, ...e }) => /* @__PURE__ */ u(
  R,
  {
    tag: "time",
    background: "neutral800",
    bottom: 1,
    right: 1,
    color: "neutral0",
    hasRadius: !0,
    position: "absolute",
    padding: 1,
    ...e,
    children: /* @__PURE__ */ u(I, { variant: "pi", textColor: "neutral0", children: i })
  }
), Bm = (i) => {
  const { id: e } = Js();
  return /* @__PURE__ */ u(I, { variant: "pi", id: `${e}-title`, textColor: "neutral800", fontWeight: "bold", tag: "div", ...i });
}, zm = (i) => /* @__PURE__ */ u(I, { variant: "pi", ...i, textColor: "neutral600", tag: "div" }), Y = {
  DOWN: "ArrowDown",
  UP: "ArrowUp",
  RIGHT: "ArrowRight",
  LEFT: "ArrowLeft",
  ESCAPE: "Escape",
  ENTER: "Enter",
  TAB: "Tab",
  END: "End",
  HOME: "Home",
  PAGE_UP: "PageUp",
  PAGE_DOWN: "PageDown"
}, Sd = x(R)`
  grid-template-columns: auto 1fr auto;
  grid-template-areas: 'startAction slides endAction';
`, Cd = x(T)`
  grid-area: slides;
`, no = x(R)`
  grid-area: ${({ $area: i }) => i};

  &:focus svg path,
  &:hover svg path {
    fill: ${({ theme: i }) => i.colors.neutral900};
  }
`, kd = m.forwardRef(
  ({ actions: i, children: e, label: t, nextLabel: n, onNext: r, onPrevious: o, previousLabel: s, secondaryLabel: l, selectedSlide: a, ...c }, h) => {
    const d = m.useRef(null), f = m.useRef(null), g = m.Children.map(
      e,
      (b, w) => m.cloneElement(b, { selected: w === a })
    );
    return /* @__PURE__ */ u(R, { ref: h, ...c, onKeyDown: (b) => {
      switch (b.key) {
        case Y.RIGHT: {
          b.preventDefault(), f != null && f.current && f.current.focus(), r && r();
          break;
        }
        case Y.LEFT: {
          b.preventDefault(), d != null && d.current && d.current.focus(), o && o();
          break;
        }
      }
    }, children: /* @__PURE__ */ $(R, { padding: 2, borderColor: "neutral200", hasRadius: !0, background: "neutral100", children: [
      /* @__PURE__ */ $(
        Sd,
        {
          tag: "section",
          "aria-roledescription": "carousel",
          "aria-label": t,
          display: "grid",
          position: "relative",
          children: [
            g && g.length > 1 && /* @__PURE__ */ $(yr, { children: [
              /* @__PURE__ */ u(no, { tag: "button", onClick: o, $area: "startAction", ref: d, type: "button", children: /* @__PURE__ */ u(zt, { label: s, children: /* @__PURE__ */ u(vs, { width: "1.6rem", height: "1.6rem", fill: "neutral600" }) }) }),
              /* @__PURE__ */ u(no, { tag: "button", onClick: r, $area: "endAction", ref: f, type: "button", children: /* @__PURE__ */ u(zt, { label: n, children: /* @__PURE__ */ u(wr, { width: "1.6rem", height: "1.6rem", fill: "neutral600" }) }) })
            ] }),
            /* @__PURE__ */ u(Cd, { "aria-live": "polite", paddingLeft: 2, paddingRight: 2, width: "100%", overflow: "hidden", children: g }),
            i
          ]
        }
      ),
      l && /* @__PURE__ */ u(R, { paddingTop: 2, paddingLeft: 4, paddingRight: 4, children: /* @__PURE__ */ u(Ar, { label: l, children: /* @__PURE__ */ u(T, { justifyContent: "center", children: /* @__PURE__ */ u(I, { variant: "pi", textColor: "neutral600", ellipsis: !0, children: l }) }) }) })
    ] }) });
  }
), $d = {
  accordions: {
    S: "4.8rem",
    M: "8.8rem"
  },
  button: {
    S: {
      initial: "4rem",
      medium: "3.2rem"
    },
    M: {
      initial: "4.4rem",
      medium: "3.6rem"
    },
    L: {
      initial: "4.8rem",
      medium: "4rem"
    }
  }
}, Qs = {
  sizes: $d,
  zIndices: {
    navigation: 100,
    overlay: 300,
    modal: 310,
    dialog: 320,
    popover: 500,
    notification: 700,
    tooltip: 1e3
  },
  spaces: ["0px", "4px", "8px", "12px", "16px", "20px", "24px", "32px", "40px", "48px", "56px", "64px"],
  borderRadius: "4px",
  breakpoints: {
    initial: "@media(min-width: 0px)",
    small: "@media(min-width: 520px)",
    medium: "@media(min-width: 768px)",
    large: "@media(min-width: 1080px)"
  },
  fontSizes: ["1.1rem", "1.2rem", "1.4rem", "1.6rem", "1.8rem", "2rem", "2.8rem", "3.2rem"],
  lineHeights: [1.14, 1.22, 1.25, 1.33, 1.43, 1.45, 1.5],
  fontWeights: {
    regular: 400,
    semiBold: 500,
    bold: 600
  },
  transitions: pc,
  motion: {
    easings: Pn,
    timings: Ln
  }
}, Ad = {
  color: {
    alternative100: "#f6ecfc",
    alternative200: "#e0c1f4",
    alternative500: "#ac73e6",
    alternative600: "#9736e8",
    alternative700: "#8312d1",
    buttonNeutral0: "#ffffff",
    buttonPrimary500: "#7b79ff",
    buttonPrimary600: "#4945ff",
    danger100: "#fcecea",
    danger200: "#f5c0b8",
    danger500: "#ee5e52",
    danger600: "#d02b20",
    danger700: "#b72b1a",
    neutral0: "#ffffff",
    neutral100: "#f6f6f9",
    neutral1000: "#181826",
    neutral150: "#eaeaef",
    neutral200: "#dcdce4",
    neutral300: "#c0c0cf",
    neutral400: "#a5a5ba",
    neutral500: "#8e8ea9",
    neutral600: "#666687",
    neutral700: "#4a4a6a",
    neutral800: "#32324d",
    neutral900: "#212134",
    primary100: "#f0f0ff",
    primary200: "#d9d8ff",
    primary500: "#7b79ff",
    primary600: "#4945ff",
    primary700: "#271fe0",
    secondary100: "#eaf5ff",
    secondary200: "#b8e1ff",
    secondary500: "#66b7f1",
    secondary600: "#0c75af",
    secondary700: "#006096",
    success100: "#eafbe7",
    success200: "#c6f0c2",
    success500: "#5cb176",
    success600: "#328048",
    success700: "#2f6846",
    warning100: "#fdf4dc",
    warning200: "#fae7b9",
    warning500: "#f29d41",
    warning600: "#d9822f",
    warning700: "#be5d01"
  }
}, Td = {
  shadow: {
    filterShadow: "0px 1px 4px rgba(33, 33, 52, 0.1)",
    focus: "inset 2px 0px 0px rgb(39, 31, 224), inset 0px 2px 0px rgb(39, 31, 224), inset -2px 0px 0px rgb(39, 31, 224), inset 0px -2px 0px rgb(39, 31, 224)",
    focusShadow: "0px 0px 6px rgba(76, 191, 255, 0.75)",
    popupShadow: "0px 2px 15px rgba(33, 33, 52, 0.1)",
    tableShadow: "0px 1px 4px rgba(33, 33, 52, 0.1)"
  }
}, Zs = {
  colors: Ad.color,
  shadows: Td.shadow,
  ...Qs
}, Rd = {
  color: {
    alternative100: "#181826",
    alternative200: "#4a4a6a",
    alternative500: "#ac73e6",
    alternative600: "#ac73e6",
    alternative700: "#e0c1f4",
    buttonNeutral0: "#ffffff",
    buttonPrimary500: "#7b79ff",
    buttonPrimary600: "#4945ff",
    danger100: "#181826",
    danger200: "#4a4a6a",
    danger500: "#ee5e52",
    danger600: "#ee5e52",
    danger700: "#ee5e52",
    neutral0: "#212134",
    neutral100: "#181826",
    neutral1000: "#ffffff",
    neutral150: "#32324d",
    neutral200: "#4a4a6a",
    neutral300: "#666687",
    neutral400: "#a5a5ba",
    neutral500: "#c0c0cf",
    neutral600: "#a5a5ba",
    neutral700: "#eaeaef",
    neutral800: "#ffffff",
    neutral900: "#ffffff",
    primary100: "#181826",
    primary200: "#4a4a6a",
    primary500: "#4945ff",
    primary600: "#7b79ff",
    primary700: "#7b79ff",
    secondary100: "#181826",
    secondary200: "#4a4a6a",
    secondary500: "#66b7f1",
    secondary600: "#66b7f1",
    secondary700: "#b8e1ff",
    success100: "#181826",
    success200: "#4a4a6a",
    success500: "#5cb176",
    success600: "#5cb176",
    success700: "#c6f0c2",
    warning100: "#181826",
    warning200: "#4a4a6a",
    warning500: "#f29d41",
    warning600: "#f29d41",
    warning700: "#fae7b9"
  }
}, Md = {
  shadow: {
    filterShadow: "1px 1px 10px rgba(3, 3, 5, 0.35)",
    focus: "inset 2px 0px 0px rgb(39, 31, 224), inset 0px 2px 0px rgb(39, 31, 224), inset -2px 0px 0px rgb(39, 31, 224), inset 0px -2px 0px rgb(39, 31, 224)",
    focusShadow: "0px 0px 6px rgba(76, 191, 255, 0.75)",
    popupShadow: "1px 1px 10px rgba(3, 3, 5, 0.35)",
    tableShadow: "1px 1px 10px rgba(3, 3, 5, 0.2)"
  }
}, Nm = {
  colors: Rd.color,
  shadows: Md.shadow,
  ...Qs
}, ro = (i) => `
${i}

The following is an example:


import { lightTheme, extendTheme } from '@strapi/design-system';

const myCustomTheme = extendTheme(lightTheme, {
    ${Object.keys(Zs).map((e) => `${e}: /* put the overrides for the ${e} key */,`).join(`
`)}
})
`, Fm = (i, e) => {
  if (!Ri(i)) {
    const o = ro(
      "The first argument should be an object and corresponds to the theme you want to extend."
    );
    throw new Error(o);
  }
  if (!Ri(e)) {
    const o = ro(
      "The second argument should be an object and corresponds to the keys of the theme you want to override."
    );
    throw new Error(o);
  }
  function t(o, s) {
    if (Array.isArray(o))
      return s;
    if (Ri(o) && Ri(s))
      return Bh(o, s);
  }
  const n = Jr(i ?? {}), r = Jr(e ?? {});
  return Lh(n, r, t), n;
}, Wm = (i) => ({ theme: e, size: t }) => e.sizes[i][t], at = (i = "&") => ({ theme: e, $hasError: t = !1 }) => D`
    outline: none;
    box-shadow: none;
    transition-property: border-color, box-shadow, fill;
    transition-duration: 0.2s;

    ${i}:focus-within {
      border: 1px solid ${t ? e.colors.danger600 : e.colors.primary600};
      box-shadow: ${t ? e.colors.danger600 : e.colors.primary600} 0px 0px 0px 2px;
    }
  `, [Dd, Ce] = Gt("Field", {}), xt = m.forwardRef(
  ({ children: i, name: e, error: t = !1, hint: n, id: r, required: o = !1, ...s }, l) => {
    const a = Se(r), [c, h] = m.useState();
    return /* @__PURE__ */ u(
      Dd,
      {
        name: e,
        id: a,
        error: t,
        hint: n,
        required: o,
        labelNode: c,
        setLabelNode: h,
        children: /* @__PURE__ */ u(T, { direction: "column", alignItems: "stretch", gap: 1, ref: l, ...s, children: i })
      }
    );
  }
), Rr = m.forwardRef(({ children: i, action: e, ...t }, n) => {
  const { id: r, required: o, setLabelNode: s } = Ce("Label"), l = ve(n, s);
  return i ? /* @__PURE__ */ $(T, { alignItems: "center", children: [
    /* @__PURE__ */ $(
      Od,
      {
        ref: l,
        variant: "pi",
        textColor: "neutral800",
        fontWeight: "bold",
        ...t,
        id: `${r}-label`,
        htmlFor: r,
        tag: "label",
        ellipsis: !0,
        children: [
          i,
          o && /* @__PURE__ */ u(I, { "aria-hidden": !0, lineHeight: "1em", textColor: "danger600", children: "*" })
        ]
      }
    ),
    e && /* @__PURE__ */ u(Ed, { marginLeft: 1, children: e })
  ] }) : null;
}), Od = x(I)`
  display: block;
`, Ed = x(T)`
  line-height: 0;
  color: ${({ theme: i }) => i.colors.neutral500};
`, an = m.forwardRef(
  ({
    endAction: i,
    startAction: e,
    disabled: t = !1,
    onChange: n,
    hasError: r,
    required: o,
    className: s,
    size: l = "M",
    ...a
  }, c) => {
    const { id: h, error: d, hint: f, name: g, required: p } = Ce("Input");
    let b;
    d ? b = `${h}-error` : f && (b = `${h}-hint`);
    const w = !!d, y = m.useRef(null), v = m.useRef(null), k = ve(v, c), C = (A) => {
      !t && n && n(A);
    };
    return m.useLayoutEffect(() => {
      if (y.current && v.current) {
        const A = y.current.offsetWidth, S = v.current;
        if (S) {
          const M = A + 8 + 16;
          S.style.paddingRight = `${M}px`;
        }
      }
    }, [i]), /* @__PURE__ */ $(
      Ld,
      {
        gap: 2,
        justifyContent: "space-between",
        $hasError: w || r,
        $disabled: t,
        $size: l,
        $hasLeftAction: !!e,
        $hasRightAction: !!i,
        className: s,
        children: [
          e,
          /* @__PURE__ */ u(
            Id,
            {
              id: h,
              name: g,
              ref: k,
              $size: l,
              "aria-describedby": b,
              "aria-invalid": w || r,
              "aria-disabled": t,
              disabled: t,
              "data-disabled": t ? "" : void 0,
              onChange: C,
              "aria-required": p || o,
              $hasLeftAction: !!e,
              $hasRightAction: !!i,
              ...a
            }
          ),
          i && /* @__PURE__ */ u(Pd, { ref: y, children: i })
        ]
      }
    );
  }
), Id = x.input`
  border: none;
  border-radius: ${({ theme: i }) => i.borderRadius};
  cursor: ${(i) => i["aria-disabled"] ? "not-allowed" : void 0};

  color: ${({ theme: i }) => i.colors.neutral800};
  font-weight: 400;
  font-size: ${(i) => i.theme.fontSizes[3]};
  line-height: 2.4rem;
  display: block;
  width: 100%;
  background: inherit;

  ${({ theme: i }) => i.breakpoints.medium} {
    font-size: ${({ theme: i }) => i.fontSizes[2]};
    line-height: 2.2rem;
  }

  &::placeholder {
    color: ${({ theme: i }) => i.colors.neutral600};
    opacity: 1;
  }

  &[aria-disabled='true'] {
    color: inherit;
  }

  //focus managed by InputWrapper
  &:focus {
    outline: none;
    box-shadow: none;
  }

  ${(i) => {
  switch (i.$size) {
    case "S":
      return D`
          padding-inline-start: ${i.$hasLeftAction ? 0 : i.theme.spaces[4]};
          padding-inline-end: ${i.$hasRightAction ? 0 : i.theme.spaces[4]};
          padding-block: ${i.theme.spaces[2]};

          ${({ theme: e }) => e.breakpoints.medium} {
            padding-block: ${i.theme.spaces[1]};
          }
        `;
    default:
      return D`
          padding-inline-start: ${i.$hasLeftAction ? 0 : i.theme.spaces[4]};
          padding-inline-end: ${i.$hasRightAction ? 0 : i.theme.spaces[4]};
          padding-block: ${i.theme.spaces[3]};

          ${({ theme: e }) => e.breakpoints.medium} {
            padding-block: ${i.theme.spaces[2]};
          }
        `;
  }
}}
`, Pd = x(T)`
  position: absolute;
  right: ${({ theme: i }) => i.spaces[4]};
  top: 50%;
  transform: translateY(-50%);
`, Ld = x(T)`
  border: 1px solid ${({ theme: i, $hasError: e }) => e ? i.colors.danger600 : i.colors.neutral200};
  border-radius: ${({ theme: i }) => i.borderRadius};
  background: ${({ theme: i }) => i.colors.neutral0};
  padding-inline-start: ${({ $hasLeftAction: i, theme: e }) => i ? e.spaces[4] : 0};
  position: relative;

  ${at()}
  ${({ theme: i, $disabled: e }) => e ? D`
          color: ${i.colors.neutral600};
          background: ${i.colors.neutral150};
        ` : void 0};
`, el = () => {
  const { id: i, hint: e, error: t } = Ce("Hint");
  return !e || t ? null : /* @__PURE__ */ u(I, { variant: "pi", tag: "p", id: `${i}-hint`, textColor: "neutral600", children: e });
}, tl = () => {
  const { id: i, error: e } = Ce("Error");
  return !e || typeof e != "string" ? null : /* @__PURE__ */ u(I, { variant: "pi", tag: "p", id: `${i}-error`, textColor: "danger600", "data-strapi-field-error": !0, children: e });
}, Bd = m.forwardRef(({ label: i, children: e, ...t }, n) => /* @__PURE__ */ u(
  zd,
  {
    justifyContent: "unset",
    background: "transparent",
    borderStyle: "none",
    ...t,
    type: "button",
    tag: "button",
    ref: n,
    children: /* @__PURE__ */ u(zt, { label: i, children: e })
  }
)), zd = x(T)`
  font-size: 1.6rem;
  padding: 0;
`, Hm = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  Action: Bd,
  Error: tl,
  Hint: el,
  Input: an,
  Label: Rr,
  Root: xt,
  useField: Ce
}, Symbol.toStringTag, { value: "Module" })), Vm = m.forwardRef(
  ({
    actions: i,
    children: e,
    error: t,
    hint: n,
    label: r,
    labelAction: o,
    nextLabel: s,
    onNext: l,
    onPrevious: a,
    previousLabel: c,
    required: h,
    secondaryLabel: d,
    selectedSlide: f,
    id: g,
    ...p
  }, b) => {
    const w = Se(g);
    return /* @__PURE__ */ u(xt, { hint: n, error: t, id: w, required: h, children: /* @__PURE__ */ $(T, { direction: "column", alignItems: "stretch", gap: 1, children: [
      r && /* @__PURE__ */ u(Rr, { action: o, children: r }),
      /* @__PURE__ */ u(
        kd,
        {
          ref: b,
          actions: i,
          label: r,
          nextLabel: s,
          onNext: l,
          onPrevious: a,
          previousLabel: c,
          secondaryLabel: d,
          selectedSlide: f,
          id: w,
          ...p,
          children: e
        }
      ),
      /* @__PURE__ */ u(el, {}),
      /* @__PURE__ */ u(tl, {})
    ] }) });
  }
), jm = ({ horizontal: i = !0, ...e }) => /* @__PURE__ */ u(
  T,
  {
    justifyContent: "center",
    direction: i ? "row" : "column",
    alignItems: i ? "center" : "stretch",
    position: "absolute",
    width: "100%",
    bottom: 1,
    gap: 1,
    ...e
  }
), oo = x(R)`
  ${As}
`, qm = (i) => {
  const [e, t] = m.useState(!1), n = () => {
    t(!0);
  };
  return e ? /* @__PURE__ */ u(Ar, { label: i.alt ?? "", children: /* @__PURE__ */ u(oo, { tag: "img", height: "100%", maxWidth: "100%", ...i }) }) : /* @__PURE__ */ u(oo, { tag: "img", height: "100%", maxWidth: "100%", ...i, onError: n });
}, Nd = x(T)`
  display: ${({ $selected: i }) => i ? "flex" : "none"};
`, Km = ({ label: i, children: e, selected: t = !1, ...n }) => /* @__PURE__ */ u(
  Nd,
  {
    $selected: t,
    alignItems: "center",
    role: "group",
    "aria-roledescription": "slide",
    "aria-label": i,
    justifyContent: "center",
    height: "124px",
    width: "100%",
    ...n,
    children: e
  }
), il = D`
  font-size: 1.6rem;
  line-height: 2.4rem;

  ${({ theme: i }) => i.breakpoints.medium} {
    font-size: 1.4rem;
    line-height: 2.2rem;
  }
`, Mr = ({
  $size: i = "M",
  $hasValue: e = !1,
  $hasClear: t = !1,
  theme: n
}) => {
  switch (i) {
    case "S":
      return D`
        padding-block: calc(
          ${e && t ? n.spaces[1] : n.spaces[2]} - 1px
        ); // 1px to compensate for the border

        ${n.breakpoints.medium} {
          padding-block: ${n.spaces[1]};
        }
      `;
    default:
      return D`
        padding-block: calc(
          ${e && t ? n.spaces[2] : n.spaces[3]} - 1px
        ); // 1px to compensate for the border

        ${n.breakpoints.medium} {
          padding-block: ${n.spaces[2]};
        }
      `;
  }
}, hn = m.forwardRef(
  ({ children: i, viewportRef: e, ...t }, n) => /* @__PURE__ */ $(Fd, { ref: n, ...t, children: [
    /* @__PURE__ */ u(Wd, { ref: e, children: i }),
    /* @__PURE__ */ u(so, { orientation: "vertical", children: /* @__PURE__ */ u(lo, {}) }),
    /* @__PURE__ */ u(so, { orientation: "horizontal", children: /* @__PURE__ */ u(lo, {}) })
  ] })
), Fd = x(nn.Root)`
  width: 100%;
  height: 100%;
  overflow: hidden;
  display: flex;
`, Wd = x(nn.Viewport)`
  min-width: 100%;
`, so = x(nn.Scrollbar)`
  display: flex;
  /* ensures no selection */
  user-select: none;
  /* disable browser handling of all panning and zooming gestures on touch devices */
  touch-action: none;

  &[data-orientation='vertical'] {
    width: 0.4rem;
    margin: 0.4rem;
  }

  &[data-orientation='horizontal'] {
    flex-direction: column;
    height: 0.4rem;
    margin: 0.4rem;
  }
`, lo = x(nn.Thumb)`
  position: relative;
  flex: 1;
  background-color: ${(i) => i.theme.colors.neutral150};
  border-radius: 0.4rem;

  /* increase target size for touch devices https://www.w3.org/WAI/WCAG21/Understanding/target-size.html */
  @media (hover: none), (pointer: coarse) {
    &::before {
      content: '';
      position: absolute;
      top: 50%;
      left: 50%;
      transform: translate(-50%, -50%);
      width: 100%;
      height: 100%;
      min-width: 44px;
      min-height: 44px;
    }
  }
`, Hd = "data:image/svg+xml,%3csvg%20width='63'%20height='63'%20viewBox='0%200%2063%2063'%20fill='none'%20xmlns='http://www.w3.org/2000/svg'%3e%3cpath%20d='M42.5563%2011.9816C39.484%2010.3071%2035.8575%209.29097%2032.3354%209.13521C28.6443%208.92888%2024.8295%209.72318%2021.3336%2011.4129C20.9123%2011.5901%2020.5376%2011.8101%2020.1722%2012.0249L20.0108%2012.1179C19.8774%2012.1951%2019.7441%2012.2724%2019.608%2012.3536C19.3253%2012.5146%2019.0492%2012.6744%2018.7544%2012.8792C18.5463%2013.0329%2018.3395%2013.1759%2018.1301%2013.323C17.5658%2013.7208%2016.9868%2014.1317%2016.4983%2014.5979C14.8476%2015.9524%2013.5571%2017.6075%2012.6071%2018.9214C10.4365%2022.1566%209.08622%2025.9567%208.80702%2029.6143L8.7764%2030.1588C8.73328%2030.9196%208.68476%2031.7057%208.75353%2032.4555C8.76648%2032.6084%208.7661%2032.7638%208.77506%2032.914C8.78895%2033.229%208.80152%2033.5373%208.846%2033.8672L9.07396%2035.4221C9.09756%2035.5764%209.1198%2035.7413%209.1633%2035.9263L9.65919%2037.9272L10.138%2039.2823C10.2729%2039.6673%2010.4158%2040.0751%2010.6%2040.43C12.0292%2043.637%2014.1425%2046.4578%2016.7063%2048.585C19.0508%2050.5296%2021.824%2052.0023%2024.7491%2052.8452L26.2371%2053.2376C26.3781%2053.2693%2026.4926%2053.2889%2026.6031%2053.3058L26.7775%2053.3311C27.0052%2053.3636%2027.2195%2053.3986%2027.4445%2053.435C27.8598%2053.5076%2028.2672%2053.5748%2028.7079%2053.6183L30.5641%2053.7229C30.9516%2053.7249%2031.3352%2053.7068%2031.7081%2053.6874C31.9039%2053.681%2032.0984%2053.6681%2032.3288%2053.662C34.5253%2053.4772%2036.5106%2053.0634%2038.0516%2052.4652C38.1769%2052.4171%2038.3008%2052.3796%2038.4234%2052.3355C38.6727%2052.2499%2038.9259%2052.167%2039.1432%2052.0599L40.8591%2051.2626L42.5702%2050.266C42.9009%2050.0682%2043.0205%2049.6414%2042.8282%2049.2984C42.632%2048.9526%2042.2034%2048.8308%2041.8634%2049.0166L40.1792%2049.9218L38.4995%2050.6224C38.3169%2050.6953%2038.121%2050.7534%2037.9224%2050.8155C37.7838%2050.8489%2037.6518%2050.8983%2037.5012%2050.9408C36.0711%2051.435%2034.2445%2051.7425%2032.244%2051.8346C32.0442%2051.8383%2031.8471%2051.8379%2031.654%2051.8403C31.3051%2051.8414%2030.9602%2051.8451%2030.6392%2051.8305L28.9177%2051.6725C28.5476%2051.619%2028.1695%2051.5427%2027.7848%2051.4678C27.5639%2051.4167%2027.3376%2051.3737%2027.1299%2051.3374L26.9529%2051.2987C26.8704%2051.2834%2026.7772%2051.2667%2026.7333%2051.2543L25.3466%2050.8322C22.7651%2049.9789%2020.33%2048.5729%2018.2942%2046.7557C16.1056%2044.7951%2014.3339%2042.2335%2013.1742%2039.3582C12.0276%2036.6013%2011.5988%2033.2792%2011.9716%2030.0076C12.3145%2027.0213%2013.3948%2024.1635%2015.1858%2021.5083C15.3034%2021.3339%2015.421%2021.1596%2015.5212%2021.0196C16.4309%2019.8688%2017.5408%2018.5589%2018.9483%2017.496C19.3367%2017.1525%2019.7862%2016.856%2020.2611%2016.5478C20.4878%2016.4009%2020.7079%2016.2553%2020.8907%2016.1306C21.0974%2016.0048%2021.3188%2015.8831%2021.5348%2015.7694C21.6761%2015.6975%2021.8162%2015.619%2021.9388%2015.5576L22.1002%2015.4646C22.4002%2015.3037%2022.6749%2015.1546%2022.9908%2015.039L24.1186%2014.5715C24.3399%2014.4844%2024.5718%2014.4159%2024.7997%2014.3447C24.953%2014.2982%2025.0982%2014.2635%2025.2635%2014.2078C25.786%2014.0182%2026.3283%2013.9112%2026.9105%2013.7965C27.117%2013.7571%2027.3302%2013.7163%2027.5608%2013.6585C27.7553%2013.611%2027.9737%2013.5969%2028.2082%2013.5762C28.364%2013.5603%2028.5172%2013.5483%2028.6318%2013.5333C28.7876%2013.5173%2028.9342%2013.5066%2029.0927%2013.4867C29.3285%2013.4555%2029.5456%2013.4347%2029.7494%2013.4337C30.0237%2013.44%2030.2994%2013.4357%2030.5777%2013.4274C31.0811%2013.421%2031.5579%2013.4197%2032.0318%2013.4914C34.9664%2013.7352%2037.7144%2014.6085%2040.2052%2016.0868C42.3489%2017.3655%2044.2716%2019.1525%2045.7607%2021.264C47.0255%2023.0628%2047.9756%2025.0528%2048.4928%2027.0393C48.572%2027.3176%2048.6299%2027.5931%2048.6839%2027.8659C48.7154%2028.0428%2048.7563%2028.2145%2048.7892%2028.3636C48.8037%2028.4541%2048.8208%2028.5406%2048.8445%2028.6258C48.8749%2028.7443%2048.8986%2028.864%2048.9116%2028.9651L48.9793%2029.6047C48.9922%2029.7748%2049.0132%2029.9331%2049.0301%2030.0887C49.0668%2030.3268%2049.0889%2030.5608%2049.0964%2030.7561L49.1083%2031.9001C49.1312%2032.3307%2049.089%2032.7116%2049.0522%2033.0673C49.0384%2033.2598%2049.0126%2033.4443%2049.0123%2033.5824C48.9961%2033.6926%2048.9918%2033.7935%2048.9836%2033.8917C48.9753%2034.0072%2048.9724%2034.1148%2048.9414%2034.2554L48.5449%2036.3059C48.3134%2037.8623%2049.3793%2039.3365%2050.9488%2039.5822C52.0417%2039.7601%2053.1536%2039.2819%2053.7711%2038.3664C54.0063%2038.0176%2054.1604%2037.6257%2054.2227%2037.2064L54.5217%2035.2574C54.5514%2035.0756%2054.572%2034.83%2054.5846%2034.5791L54.6028%2034.2338C54.6098%2034.0598%2054.6223%2033.8779%2054.6347%2033.6788C54.6734%2033.1052%2054.7163%2032.4479%2054.6619%2031.8058L54.5867%2030.4289C54.5622%2030.0952%2054.5097%2029.76%2054.4559%2029.4181C54.431%2029.2572%2054.4048%2029.0896%2054.3826%2028.9074L54.2687%2028.104C54.2332%2027.9244%2054.1804%2027.7273%2054.1329%2027.5396L54.0643%2027.2454C54.0195%2027.071%2053.9773%2026.8927%2053.9338%2026.7076C53.8455%2026.3309%2053.7479%2025.9422%2053.613%2025.5571C52.84%2023.0292%2051.5383%2020.5194%2049.8338%2018.2799C47.8544%2015.682%2045.3333%2013.5087%2042.5563%2011.9816Z'%20fill='%234945FF'/%3e%3c/svg%3e", Vd = m.forwardRef(({ children: i, small: e = !1, ...t }, n) => /* @__PURE__ */ $("div", { role: "alert", "aria-live": "assertive", ref: n, ...t, children: [
  /* @__PURE__ */ u(lt, { children: i }),
  /* @__PURE__ */ u(qd, { src: Hd, "aria-hidden": !0, $small: e })
] })), jd = fe`
  from {
    transform: rotate(0deg);
  }
  to {
    transform: rotate(359deg);
  }
`, qd = x.img`
  animation: ${jd} 1s infinite linear;
  will-change: transform;
  ${({ $small: i, theme: e }) => i && `width: ${e.spaces[6]}; height: ${e.spaces[6]};`}
`;
function Mt(i, e, t) {
  let n = t.initialDeps ?? [], r;
  function o() {
    var s, l, a, c;
    let h;
    t.key && ((s = t.debug) != null && s.call(t)) && (h = Date.now());
    const d = i();
    if (!(d.length !== n.length || d.some((p, b) => n[b] !== p)))
      return r;
    n = d;
    let g;
    if (t.key && ((l = t.debug) != null && l.call(t)) && (g = Date.now()), r = e(...d), t.key && ((a = t.debug) != null && a.call(t))) {
      const p = Math.round((Date.now() - h) * 100) / 100, b = Math.round((Date.now() - g) * 100) / 100, w = b / 16, y = (v, k) => {
        for (v = String(v); v.length < k; )
          v = " " + v;
        return v;
      };
      console.info(
        `%c⏱ ${y(b, 5)} /${y(p, 5)} ms`,
        `
            font-size: .6rem;
            font-weight: bold;
            color: hsl(${Math.max(
          0,
          Math.min(120 - 120 * w, 120)
        )}deg 100% 31%);`,
        t == null ? void 0 : t.key
      );
    }
    return (c = t == null ? void 0 : t.onChange) == null || c.call(t, r), r;
  }
  return o.updateDeps = (s) => {
    n = s;
  }, o;
}
function ao(i, e) {
  if (i === void 0)
    throw new Error("Unexpected undefined");
  return i;
}
const Kd = (i, e) => Math.abs(i - e) < 1.01, Ud = (i, e, t) => {
  let n;
  return function(...r) {
    i.clearTimeout(n), n = i.setTimeout(() => e.apply(this, r), t);
  };
}, ho = (i) => {
  const { offsetWidth: e, offsetHeight: t } = i;
  return { width: e, height: t };
}, _d = (i) => i, Gd = (i) => {
  const e = Math.max(i.startIndex - i.overscan, 0), t = Math.min(i.endIndex + i.overscan, i.count - 1), n = [];
  for (let r = e; r <= t; r++)
    n.push(r);
  return n;
}, Yd = (i, e) => {
  const t = i.scrollElement;
  if (!t)
    return;
  const n = i.targetWindow;
  if (!n)
    return;
  const r = (s) => {
    const { width: l, height: a } = s;
    e({ width: Math.round(l), height: Math.round(a) });
  };
  if (r(ho(t)), !n.ResizeObserver)
    return () => {
    };
  const o = new n.ResizeObserver((s) => {
    const l = () => {
      const a = s[0];
      if (a != null && a.borderBoxSize) {
        const c = a.borderBoxSize[0];
        if (c) {
          r({ width: c.inlineSize, height: c.blockSize });
          return;
        }
      }
      r(ho(t));
    };
    i.options.useAnimationFrameWithResizeObserver ? requestAnimationFrame(l) : l();
  });
  return o.observe(t, { box: "border-box" }), () => {
    o.unobserve(t);
  };
}, co = {
  passive: !0
}, uo = typeof window > "u" ? !0 : "onscrollend" in window, Xd = (i, e) => {
  const t = i.scrollElement;
  if (!t)
    return;
  const n = i.targetWindow;
  if (!n)
    return;
  let r = 0;
  const o = i.options.useScrollendEvent && uo ? () => {
  } : Ud(
    n,
    () => {
      e(r, !1);
    },
    i.options.isScrollingResetDelay
  ), s = (h) => () => {
    const { horizontal: d, isRtl: f } = i.options;
    r = d ? t.scrollLeft * (f && -1 || 1) : t.scrollTop, o(), e(r, h);
  }, l = s(!0), a = s(!1);
  a(), t.addEventListener("scroll", l, co);
  const c = i.options.useScrollendEvent && uo;
  return c && t.addEventListener("scrollend", a, co), () => {
    t.removeEventListener("scroll", l), c && t.removeEventListener("scrollend", a);
  };
}, Jd = (i, e, t) => {
  if (e != null && e.borderBoxSize) {
    const n = e.borderBoxSize[0];
    if (n)
      return Math.round(
        n[t.options.horizontal ? "inlineSize" : "blockSize"]
      );
  }
  return i[t.options.horizontal ? "offsetWidth" : "offsetHeight"];
}, Qd = (i, {
  adjustments: e = 0,
  behavior: t
}, n) => {
  var r, o;
  const s = i + e;
  (o = (r = n.scrollElement) == null ? void 0 : r.scrollTo) == null || o.call(r, {
    [n.options.horizontal ? "left" : "top"]: s,
    behavior: t
  });
};
class Zd {
  constructor(e) {
    this.unsubs = [], this.scrollElement = null, this.targetWindow = null, this.isScrolling = !1, this.measurementsCache = [], this.itemSizeCache = /* @__PURE__ */ new Map(), this.pendingMeasuredCacheIndexes = [], this.scrollRect = null, this.scrollOffset = null, this.scrollDirection = null, this.scrollAdjustments = 0, this.elementsCache = /* @__PURE__ */ new Map(), this.observer = /* @__PURE__ */ (() => {
      let t = null;
      const n = () => t || (!this.targetWindow || !this.targetWindow.ResizeObserver ? null : t = new this.targetWindow.ResizeObserver((r) => {
        r.forEach((o) => {
          const s = () => {
            this._measureElement(o.target, o);
          };
          this.options.useAnimationFrameWithResizeObserver ? requestAnimationFrame(s) : s();
        });
      }));
      return {
        disconnect: () => {
          var r;
          (r = n()) == null || r.disconnect(), t = null;
        },
        observe: (r) => {
          var o;
          return (o = n()) == null ? void 0 : o.observe(r, { box: "border-box" });
        },
        unobserve: (r) => {
          var o;
          return (o = n()) == null ? void 0 : o.unobserve(r);
        }
      };
    })(), this.range = null, this.setOptions = (t) => {
      Object.entries(t).forEach(([n, r]) => {
        typeof r > "u" && delete t[n];
      }), this.options = {
        debug: !1,
        initialOffset: 0,
        overscan: 1,
        paddingStart: 0,
        paddingEnd: 0,
        scrollPaddingStart: 0,
        scrollPaddingEnd: 0,
        horizontal: !1,
        getItemKey: _d,
        rangeExtractor: Gd,
        onChange: () => {
        },
        measureElement: Jd,
        initialRect: { width: 0, height: 0 },
        scrollMargin: 0,
        gap: 0,
        indexAttribute: "data-index",
        initialMeasurementsCache: [],
        lanes: 1,
        isScrollingResetDelay: 150,
        enabled: !0,
        isRtl: !1,
        useScrollendEvent: !1,
        useAnimationFrameWithResizeObserver: !1,
        ...t
      };
    }, this.notify = (t) => {
      var n, r;
      (r = (n = this.options).onChange) == null || r.call(n, this, t);
    }, this.maybeNotify = Mt(
      () => (this.calculateRange(), [
        this.isScrolling,
        this.range ? this.range.startIndex : null,
        this.range ? this.range.endIndex : null
      ]),
      (t) => {
        this.notify(t);
      },
      {
        key: process.env.NODE_ENV !== "production" && "maybeNotify",
        debug: () => this.options.debug,
        initialDeps: [
          this.isScrolling,
          this.range ? this.range.startIndex : null,
          this.range ? this.range.endIndex : null
        ]
      }
    ), this.cleanup = () => {
      this.unsubs.filter(Boolean).forEach((t) => t()), this.unsubs = [], this.observer.disconnect(), this.scrollElement = null, this.targetWindow = null;
    }, this._didMount = () => () => {
      this.cleanup();
    }, this._willUpdate = () => {
      var t;
      const n = this.options.enabled ? this.options.getScrollElement() : null;
      if (this.scrollElement !== n) {
        if (this.cleanup(), !n) {
          this.maybeNotify();
          return;
        }
        this.scrollElement = n, this.scrollElement && "ownerDocument" in this.scrollElement ? this.targetWindow = this.scrollElement.ownerDocument.defaultView : this.targetWindow = ((t = this.scrollElement) == null ? void 0 : t.window) ?? null, this.elementsCache.forEach((r) => {
          this.observer.observe(r);
        }), this._scrollToOffset(this.getScrollOffset(), {
          adjustments: void 0,
          behavior: void 0
        }), this.unsubs.push(
          this.options.observeElementRect(this, (r) => {
            this.scrollRect = r, this.maybeNotify();
          })
        ), this.unsubs.push(
          this.options.observeElementOffset(this, (r, o) => {
            this.scrollAdjustments = 0, this.scrollDirection = o ? this.getScrollOffset() < r ? "forward" : "backward" : null, this.scrollOffset = r, this.isScrolling = o, this.maybeNotify();
          })
        );
      }
    }, this.getSize = () => this.options.enabled ? (this.scrollRect = this.scrollRect ?? this.options.initialRect, this.scrollRect[this.options.horizontal ? "width" : "height"]) : (this.scrollRect = null, 0), this.getScrollOffset = () => this.options.enabled ? (this.scrollOffset = this.scrollOffset ?? (typeof this.options.initialOffset == "function" ? this.options.initialOffset() : this.options.initialOffset), this.scrollOffset) : (this.scrollOffset = null, 0), this.getFurthestMeasurement = (t, n) => {
      const r = /* @__PURE__ */ new Map(), o = /* @__PURE__ */ new Map();
      for (let s = n - 1; s >= 0; s--) {
        const l = t[s];
        if (r.has(l.lane))
          continue;
        const a = o.get(
          l.lane
        );
        if (a == null || l.end > a.end ? o.set(l.lane, l) : l.end < a.end && r.set(l.lane, !0), r.size === this.options.lanes)
          break;
      }
      return o.size === this.options.lanes ? Array.from(o.values()).sort((s, l) => s.end === l.end ? s.index - l.index : s.end - l.end)[0] : void 0;
    }, this.getMeasurementOptions = Mt(
      () => [
        this.options.count,
        this.options.paddingStart,
        this.options.scrollMargin,
        this.options.getItemKey,
        this.options.enabled
      ],
      (t, n, r, o, s) => (this.pendingMeasuredCacheIndexes = [], {
        count: t,
        paddingStart: n,
        scrollMargin: r,
        getItemKey: o,
        enabled: s
      }),
      {
        key: !1
      }
    ), this.getMeasurements = Mt(
      () => [this.getMeasurementOptions(), this.itemSizeCache],
      ({ count: t, paddingStart: n, scrollMargin: r, getItemKey: o, enabled: s }, l) => {
        if (!s)
          return this.measurementsCache = [], this.itemSizeCache.clear(), [];
        this.measurementsCache.length === 0 && (this.measurementsCache = this.options.initialMeasurementsCache, this.measurementsCache.forEach((h) => {
          this.itemSizeCache.set(h.key, h.size);
        }));
        const a = this.pendingMeasuredCacheIndexes.length > 0 ? Math.min(...this.pendingMeasuredCacheIndexes) : 0;
        this.pendingMeasuredCacheIndexes = [];
        const c = this.measurementsCache.slice(0, a);
        for (let h = a; h < t; h++) {
          const d = o(h), f = this.options.lanes === 1 ? c[h - 1] : this.getFurthestMeasurement(c, h), g = f ? f.end + this.options.gap : n + r, p = l.get(d), b = typeof p == "number" ? p : this.options.estimateSize(h), w = g + b, y = f ? f.lane : h % this.options.lanes;
          c[h] = {
            index: h,
            start: g,
            size: b,
            end: w,
            key: d,
            lane: y
          };
        }
        return this.measurementsCache = c, c;
      },
      {
        key: process.env.NODE_ENV !== "production" && "getMeasurements",
        debug: () => this.options.debug
      }
    ), this.calculateRange = Mt(
      () => [
        this.getMeasurements(),
        this.getSize(),
        this.getScrollOffset(),
        this.options.lanes
      ],
      (t, n, r, o) => this.range = t.length > 0 && n > 0 ? eu({
        measurements: t,
        outerSize: n,
        scrollOffset: r,
        lanes: o
      }) : null,
      {
        key: process.env.NODE_ENV !== "production" && "calculateRange",
        debug: () => this.options.debug
      }
    ), this.getVirtualIndexes = Mt(
      () => {
        let t = null, n = null;
        const r = this.calculateRange();
        return r && (t = r.startIndex, n = r.endIndex), this.maybeNotify.updateDeps([this.isScrolling, t, n]), [
          this.options.rangeExtractor,
          this.options.overscan,
          this.options.count,
          t,
          n
        ];
      },
      (t, n, r, o, s) => o === null || s === null ? [] : t({
        startIndex: o,
        endIndex: s,
        overscan: n,
        count: r
      }),
      {
        key: process.env.NODE_ENV !== "production" && "getVirtualIndexes",
        debug: () => this.options.debug
      }
    ), this.indexFromElement = (t) => {
      const n = this.options.indexAttribute, r = t.getAttribute(n);
      return r ? parseInt(r, 10) : (console.warn(
        `Missing attribute name '${n}={index}' on measured element.`
      ), -1);
    }, this._measureElement = (t, n) => {
      const r = this.indexFromElement(t), o = this.measurementsCache[r];
      if (!o)
        return;
      const s = o.key, l = this.elementsCache.get(s);
      l !== t && (l && this.observer.unobserve(l), this.observer.observe(t), this.elementsCache.set(s, t)), t.isConnected && this.resizeItem(r, this.options.measureElement(t, n, this));
    }, this.resizeItem = (t, n) => {
      const r = this.measurementsCache[t];
      if (!r)
        return;
      const o = this.itemSizeCache.get(r.key) ?? r.size, s = n - o;
      s !== 0 && ((this.shouldAdjustScrollPositionOnItemSizeChange !== void 0 ? this.shouldAdjustScrollPositionOnItemSizeChange(r, s, this) : r.start < this.getScrollOffset() + this.scrollAdjustments) && (process.env.NODE_ENV !== "production" && this.options.debug && console.info("correction", s), this._scrollToOffset(this.getScrollOffset(), {
        adjustments: this.scrollAdjustments += s,
        behavior: void 0
      })), this.pendingMeasuredCacheIndexes.push(r.index), this.itemSizeCache = new Map(this.itemSizeCache.set(r.key, n)), this.notify(!1));
    }, this.measureElement = (t) => {
      if (!t) {
        this.elementsCache.forEach((n, r) => {
          n.isConnected || (this.observer.unobserve(n), this.elementsCache.delete(r));
        });
        return;
      }
      this._measureElement(t, void 0);
    }, this.getVirtualItems = Mt(
      () => [this.getVirtualIndexes(), this.getMeasurements()],
      (t, n) => {
        const r = [];
        for (let o = 0, s = t.length; o < s; o++) {
          const l = t[o], a = n[l];
          r.push(a);
        }
        return r;
      },
      {
        key: process.env.NODE_ENV !== "production" && "getVirtualItems",
        debug: () => this.options.debug
      }
    ), this.getVirtualItemForOffset = (t) => {
      const n = this.getMeasurements();
      if (n.length !== 0)
        return ao(
          n[nl(
            0,
            n.length - 1,
            (r) => ao(n[r]).start,
            t
          )]
        );
    }, this.getOffsetForAlignment = (t, n, r = 0) => {
      const o = this.getSize(), s = this.getScrollOffset();
      n === "auto" && (n = t >= s + o ? "end" : "start"), n === "center" ? t += (r - o) / 2 : n === "end" && (t -= o);
      const l = this.getTotalSize() + this.options.scrollMargin - o;
      return Math.max(Math.min(l, t), 0);
    }, this.getOffsetForIndex = (t, n = "auto") => {
      t = Math.max(0, Math.min(t, this.options.count - 1));
      const r = this.measurementsCache[t];
      if (!r)
        return;
      const o = this.getSize(), s = this.getScrollOffset();
      if (n === "auto")
        if (r.end >= s + o - this.options.scrollPaddingEnd)
          n = "end";
        else if (r.start <= s + this.options.scrollPaddingStart)
          n = "start";
        else
          return [s, n];
      const l = n === "end" ? r.end + this.options.scrollPaddingEnd : r.start - this.options.scrollPaddingStart;
      return [
        this.getOffsetForAlignment(l, n, r.size),
        n
      ];
    }, this.isDynamicMode = () => this.elementsCache.size > 0, this.scrollToOffset = (t, { align: n = "start", behavior: r } = {}) => {
      r === "smooth" && this.isDynamicMode() && console.warn(
        "The `smooth` scroll behavior is not fully supported with dynamic size."
      ), this._scrollToOffset(this.getOffsetForAlignment(t, n), {
        adjustments: void 0,
        behavior: r
      });
    }, this.scrollToIndex = (t, { align: n = "auto", behavior: r } = {}) => {
      r === "smooth" && this.isDynamicMode() && console.warn(
        "The `smooth` scroll behavior is not fully supported with dynamic size."
      ), t = Math.max(0, Math.min(t, this.options.count - 1));
      let o = 0;
      const s = 10, l = (c) => {
        if (!this.targetWindow) return;
        const h = this.getOffsetForIndex(t, c);
        if (!h) {
          console.warn("Failed to get offset for index:", t);
          return;
        }
        const [d, f] = h;
        this._scrollToOffset(d, { adjustments: void 0, behavior: r }), this.targetWindow.requestAnimationFrame(() => {
          const g = this.getScrollOffset(), p = this.getOffsetForIndex(t, f);
          if (!p) {
            console.warn("Failed to get offset for index:", t);
            return;
          }
          Kd(p[0], g) || a(f);
        });
      }, a = (c) => {
        this.targetWindow && (o++, o < s ? (process.env.NODE_ENV !== "production" && this.options.debug && console.info("Schedule retry", o, s), this.targetWindow.requestAnimationFrame(() => l(c))) : console.warn(
          `Failed to scroll to index ${t} after ${s} attempts.`
        ));
      };
      l(n);
    }, this.scrollBy = (t, { behavior: n } = {}) => {
      n === "smooth" && this.isDynamicMode() && console.warn(
        "The `smooth` scroll behavior is not fully supported with dynamic size."
      ), this._scrollToOffset(this.getScrollOffset() + t, {
        adjustments: void 0,
        behavior: n
      });
    }, this.getTotalSize = () => {
      var t;
      const n = this.getMeasurements();
      let r;
      if (n.length === 0)
        r = this.options.paddingStart;
      else if (this.options.lanes === 1)
        r = ((t = n[n.length - 1]) == null ? void 0 : t.end) ?? 0;
      else {
        const o = Array(this.options.lanes).fill(null);
        let s = n.length - 1;
        for (; s >= 0 && o.some((l) => l === null); ) {
          const l = n[s];
          o[l.lane] === null && (o[l.lane] = l.end), s--;
        }
        r = Math.max(...o.filter((l) => l !== null));
      }
      return Math.max(
        r - this.options.scrollMargin + this.options.paddingEnd,
        0
      );
    }, this._scrollToOffset = (t, {
      adjustments: n,
      behavior: r
    }) => {
      this.options.scrollToFn(t, { behavior: r, adjustments: n }, this);
    }, this.measure = () => {
      this.itemSizeCache = /* @__PURE__ */ new Map(), this.notify(!1);
    }, this.setOptions(e);
  }
}
const nl = (i, e, t, n) => {
  for (; i <= e; ) {
    const r = (i + e) / 2 | 0, o = t(r);
    if (o < n)
      i = r + 1;
    else if (o > n)
      e = r - 1;
    else
      return r;
  }
  return i > 0 ? i - 1 : 0;
};
function eu({
  measurements: i,
  outerSize: e,
  scrollOffset: t,
  lanes: n
}) {
  const r = i.length - 1, o = (a) => i[a].start;
  if (i.length <= n)
    return {
      startIndex: 0,
      endIndex: r
    };
  let s = nl(
    0,
    r,
    o,
    t
  ), l = s;
  if (n === 1)
    for (; l < r && i[l].end < t + e; )
      l++;
  else if (n > 1) {
    const a = Array(n).fill(0);
    for (; l < r && a.some((h) => h < t + e); ) {
      const h = i[l];
      a[h.lane] = h.end, l++;
    }
    const c = Array(n).fill(t + e);
    for (; s >= 0 && c.some((h) => h >= t); ) {
      const h = i[s];
      c[h.lane] = h.start, s--;
    }
    s = Math.max(0, s - s % n), l = Math.min(r, l + (n - 1 - l % n));
  }
  return { startIndex: s, endIndex: l };
}
const fo = typeof document < "u" ? m.useLayoutEffect : m.useEffect;
function tu(i) {
  const e = m.useReducer(() => ({}), {})[1], t = {
    ...i,
    onChange: (r, o) => {
      var s;
      o ? xh(e) : e(), (s = i.onChange) == null || s.call(i, r, o);
    }
  }, [n] = m.useState(
    () => new Zd(t)
  );
  return n.setOptions(t), fo(() => n._didMount(), []), fo(() => n._willUpdate()), n;
}
function iu(i) {
  return tu({
    observeElementRect: Yd,
    observeElementOffset: Xd,
    scrollToFn: Qd,
    ...i
  });
}
const nu = xe((i, e) => {
  const { gap: t = 0, gridCols: n = 12, ...r } = i;
  return /* @__PURE__ */ u(ru, { ref: e, $gap: t, $gridCols: n, ...r });
}), ru = x(R)`
  display: grid;
  grid-template-columns: repeat(${({ $gridCols: i }) => i}, 1fr);
  ${({ theme: i, $gap: e }) => Bt({ gap: e }, i)}
`, ou = xe(
  ({ col: i, s: e, xs: t, m: n, ...r }, o) => /* @__PURE__ */ u(su, { ref: o, $col: i, $s: e, $xs: t, $m: n, ...r })
), su = x(T)`
  grid-column: span ${({ $xs: i, $col: e }) => i ?? e ?? 12};
  max-width: 100%;

  ${({ theme: i }) => i.breakpoints.small} {
    grid-column: span ${({ $s: i, $xs: e, $col: t }) => i ?? e ?? t ?? 12};
  }

  ${({ theme: i }) => i.breakpoints.medium} {
    grid-column: span ${({ $m: i, $s: e, $xs: t, $col: n }) => i ?? e ?? t ?? n ?? 12};
  }

  ${({ theme: i }) => i.breakpoints.large} {
    grid-column: span ${({ $col: i, $m: e, $s: t, $xs: n }) => i ?? e ?? t ?? n ?? 12};
  }
`, Um = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  Item: ou,
  Root: nu
}, Symbol.toStringTag, { value: "Module" })), lu = ({
  children: i,
  estimatedItemSize: e = 40,
  overscan: t = 10,
  itemCount: n,
  renderItem: r
}) => {
  const o = Yr(null), [s, l] = Mn(!1), a = Yr(!0);
  gs(() => (a.current = !0, typeof Xr == "function" && Xr(() => {
    a.current && l(!0);
  }), () => {
    a.current = !1;
  }), []);
  const c = ps(() => r && n !== void 0 ? [] : eh.toArray(i), [i, r, n]), h = n ?? c.length, d = iu({
    count: h,
    // parentRef is the inner container; the scroll element is its closest scrollable ancestor
    getScrollElement: () => o.current ?? null,
    estimateSize: th(() => e, [e]),
    overscan: t,
    // Optimize scroll performance
    scrollMargin: 0,
    // Don't measure elements dynamically - use fixed size
    measureElement: void 0,
    // Use lanes for better performance with large lists
    lanes: 1
  }), f = s && a.current ? d.getVirtualItems() : [];
  return s ? /* @__PURE__ */ u(
    R,
    {
      ref: o,
      height: `${d.getTotalSize() > 0 ? d.getTotalSize() : 0}px`,
      width: "100%",
      position: "relative",
      "data-testid": "virtualized-list",
      style: {
        willChange: "transform"
      },
      children: f.map((g) => {
        const p = r ? r(g.index) : c[g.index];
        return /* @__PURE__ */ u(
          R,
          {
            "data-index": g.index,
            style: {
              position: "absolute",
              top: 0,
              left: 0,
              width: "100%",
              transform: `translate3d(0, ${g.start}px, 0)`
            },
            children: p
          },
          g.key
        );
      })
    }
  ) : /* @__PURE__ */ u(R, { ref: o, height: "40px", width: "100%", position: "relative" });
}, au = m.forwardRef(
  ({
    allowCustomValue: i,
    autocomplete: e,
    children: t,
    className: n,
    clearLabel: r = "Clear",
    creatable: o = !1,
    creatableDisabled: s = !1,
    creatableStartIcon: l,
    createMessage: a = (V) => `Create "${V}"`,
    defaultFilterValue: c,
    defaultTextValue: h,
    defaultOpen: d = !1,
    open: f,
    onOpenChange: g,
    disabled: p = !1,
    hasError: b,
    id: w,
    filterValue: y,
    hasMoreItems: v = !1,
    isPrintableCharacter: k,
    loading: C = !1,
    loadingMessage: A = "Loading content...",
    name: S,
    noOptionsMessage: M = () => "No results found",
    onChange: N,
    onClear: z,
    onCreateOption: F,
    onFilterValueChange: Q,
    onInputChange: U,
    onTextValueChange: K,
    onLoadMore: L,
    placeholder: se = "Select or enter a value",
    required: ue = !1,
    size: B = "M",
    startIcon: J,
    textValue: re,
    value: oe,
    ...le
  }, Be) => {
    const [V, qe] = We({
      prop: f,
      defaultProp: d,
      onChange: g
    }), [ae, Tt] = We({
      prop: re,
      defaultProp: i && !h ? oe : h,
      onChange: K
    }), [ht, ct] = We({
      prop: y,
      defaultProp: c,
      onChange: Q
    }), Ke = m.useRef(null), Rt = m.useRef(null), dt = ve(Rt, Be), Jt = m.useRef(null), Qt = (ke) => {
      z && !p && (Tt(""), ct(""), z(ke), Rt.current.focus());
    }, ut = (ke) => {
      qe(ke);
    }, Z = (ke) => {
      Tt(ke);
    }, ft = (ke) => {
      ct(ke);
    }, Zt = (ke) => {
      U && U(ke);
    }, ja = (ke) => {
      N && N(ke);
    }, qa = (ke) => {
      L && v && !C && L(ke);
    }, Ur = () => {
      F && ae && o !== "visible" ? F(ae) : F && o === "visible" && (F(), qe(!1));
    }, Ka = Se(), _r = `intersection-${Nt(Ka)}`;
    Si(Ke, qa, {
      selectorToWatch: `#${_r}`,
      /**
       * We need to know when the select is open because only then will viewportRef
       * not be null. Because it uses a portal that (sensibly) is not mounted 24/7.
       */
      skipWhen: !V
    });
    const { error: pn, ...Ti } = Ce("Combobox"), Ua = !!pn || b, mn = Ti.id ?? w, _a = Ti.name ?? S, Ga = Ti.required || ue, Gr = m.Children.toArray(t).filter(Boolean).length, Ya = !!!(ae && ae !== "" || ht && ht !== "") && Gr > 100;
    let bn;
    return pn ? bn = `${mn}-error` : Ti.hint && (bn = `${mn}-hint`), /* @__PURE__ */ $(
      Oe.Root,
      {
        autocomplete: e || (o === !0 ? "list" : "both"),
        onOpenChange: ut,
        open: V,
        onTextValueChange: Z,
        textValue: ae,
        allowCustomValue: !!o || i,
        disabled: p,
        required: Ga,
        value: oe,
        onValueChange: ja,
        filterValue: ht,
        onFilterValueChange: ft,
        isPrintableCharacter: k,
        visible: o === "visible",
        children: [
          /* @__PURE__ */ $(
            hu,
            {
              $hasError: Ua,
              $size: B,
              $hasTextValue: !!ae,
              $hasClear: !!(ae && z),
              className: n,
              children: [
                /* @__PURE__ */ $(T, { flex: "1", tag: "span", gap: 3, children: [
                  J ? /* @__PURE__ */ u(T, { flex: "0 0 1.6rem", tag: "span", "aria-hidden": !0, children: J }) : null,
                  /* @__PURE__ */ u(
                    cu,
                    {
                      placeholder: se,
                      id: mn,
                      "aria-invalid": !!pn,
                      onChange: Zt,
                      ref: dt,
                      name: _a,
                      "aria-describedby": bn,
                      ...le
                    }
                  )
                ] }),
                /* @__PURE__ */ $(T, { tag: "span", gap: 3, children: [
                  ae && z ? /* @__PURE__ */ u(
                    ot,
                    {
                      size: "XS",
                      variant: "ghost",
                      onClick: Qt,
                      "aria-disabled": p,
                      "aria-label": r,
                      label: r,
                      ref: Jt,
                      children: /* @__PURE__ */ u(kt, {})
                    }
                  ) : null,
                  /* @__PURE__ */ u(du, { children: /* @__PURE__ */ u(Ze, { fill: "neutral500" }) })
                ] })
              ]
            }
          ),
          /* @__PURE__ */ u(Oe.Portal, { children: /* @__PURE__ */ $(uu, { sideOffset: 4, children: [
            /* @__PURE__ */ u(hn, { children: /* @__PURE__ */ u(Oe.Viewport, { ref: Ke, children: /* @__PURE__ */ $(R, { padding: 1, children: [
              Ya ? /* @__PURE__ */ u(lu, { itemCount: Gr, children: t }) : t,
              o !== !0 && !C ? /* @__PURE__ */ u(Oe.NoValueFound, { asChild: !0, children: /* @__PURE__ */ u(Fn, { $hasHover: !1, children: /* @__PURE__ */ u(I, { children: M(ae ?? "") }) }) }) : null,
              C ? /* @__PURE__ */ u(T, { justifyContent: "center", alignItems: "center", paddingTop: 2, paddingBottom: 2, children: /* @__PURE__ */ u(Vd, { small: !0, children: A }) }) : null,
              /* @__PURE__ */ u(R, { id: _r, width: "100%", height: "1px" })
            ] }) }) }),
            o ? /* @__PURE__ */ u(
              fu,
              {
                onPointerUp: Ur,
                onClick: Ur,
                disabled: s,
                asChild: !0,
                children: /* @__PURE__ */ u(Fn, { children: /* @__PURE__ */ $(T, { gap: 2, children: [
                  l && /* @__PURE__ */ u(R, { tag: "span", "aria-hidden": !0, display: "inline-flex", children: l }),
                  /* @__PURE__ */ u(I, { children: a(ae ?? "") })
                ] }) })
              }
            ) : null
          ] }) })
        ]
      }
    );
  }
), hu = x(Oe.Trigger)`
  position: relative;
  border: 1px solid ${({ theme: i, $hasError: e }) => e ? i.colors.danger600 : i.colors.neutral200};
  border-radius: ${({ theme: i }) => i.borderRadius};
  background: ${({ theme: i }) => i.colors.neutral0};
  overflow: hidden;
  display: flex;
  align-items: center;
  justify-content: space-between;
  gap: ${({ theme: i }) => i.spaces[4]};
  padding-inline-start: ${({ theme: i }) => i.spaces[4]};
  padding-inline-end: ${({ theme: i }) => i.spaces[3]};
  ${({ $size: i, $hasTextValue: e, $hasClear: t, theme: n }) => Mr({
  $size: i || "M",
  $hasValue: e || !1,
  $hasClear: t || !1,
  theme: n
})}

  &[data-disabled] {
    color: ${({ theme: i }) => i.colors.neutral600};
    background: ${({ theme: i }) => i.colors.neutral150};
    cursor: not-allowed;
  }

  /* Required to ensure the below inputFocusStyles are adhered too */
  &:focus-visible {
    outline: none;
  }

  ${({ theme: i, $hasError: e }) => at()({ theme: i, $hasError: e })};
`, cu = x(Oe.TextInput)`
  width: 100%;
  ${il}
  color: ${({ theme: i }) => i.colors.neutral800};
  padding: 0;
  border: none;
  background-color: transparent;
  text-overflow: ellipsis;

  &:focus-visible {
    outline: none;
  }

  &::placeholder {
    color: ${({ theme: i }) => i.colors.neutral600};
    opacity: 1;
  }

  &[aria-disabled='true'] {
    cursor: inherit;
  }
`, du = x(Oe.Icon)`
  border: none;
  background: transparent;
  padding: 0;
  color: ${({ theme: i }) => i.colors.neutral600};
  display: flex;

  &[aria-disabled='true'] {
    cursor: inherit;
  }
`, uu = x(Oe.Content)`
  background: ${({ theme: i }) => i.colors.neutral0};
  box-shadow: ${({ theme: i }) => i.shadows.filterShadow};
  border: 1px solid ${({ theme: i }) => i.colors.neutral150};
  border-radius: ${({ theme: i }) => i.borderRadius};
  width: var(--radix-combobox-trigger-width);
  /* This is from the design-system figma file. */
  max-height: 15rem;
  z-index: ${({ theme: i }) => i.zIndices.popover};

  &:focus-visible {
    outline: ${({ theme: i }) => `2px solid ${i.colors.primary600}`};
    outline-offset: 2px;
  }

  @media (prefers-reduced-motion: no-preference) {
    animation-duration: ${(i) => i.theme.motion.timings[200]};

    /* The select can't animate out yet, watch https://github.com/radix-ui/primitives/issues/1893, or take a look and solve it yourself. */
    &[data-state='open'] {
      animation-timing-function: ${(i) => i.theme.motion.easings.authenticMotion};

      &[data-side='top'] {
        animation-name: ${te.slideUpIn};
      }

      &[data-side='bottom'] {
        animation-name: ${te.slideDownIn};
      }
    }
  }
`, fu = x(Oe.CreateItem)`
  && {
    border-top: 1px solid ${({ theme: i }) => i.colors.neutral150};
    border-top-left-radius: 0;
    border-top-right-radius: 0;
    background: ${({ theme: i }) => i.colors.neutral0};
    cursor: pointer;
    padding: ${({ theme: i }) => i.spaces[1]};
    position: sticky;
    bottom: 0;
    left: 0;
  }
  &&:hover,
  &&[data-highlighted] {
    background: ${({ theme: i }) => i.colors.neutral0};
  }
  &&[data-disabled] {
    color: ${({ theme: i }) => i.colors.neutral600};
    cursor: not-allowed;
  }
  &&[data-disabled] svg {
    fill: ${({ theme: i }) => i.colors.neutral300};
  }
  && > div {
    padding: ${({ theme: i }) => i.spaces[2]} ${({ theme: i }) => i.spaces[4]};
  }
  && > div:hover,
  &&[data-highlighted] > div {
    background-color: ${({ theme: i }) => i.colors.primary100};
    border-radius: ${({ theme: i }) => i.borderRadius};
  }
  &&[data-disabled] > div {
    background-color: inherit;
  }
`, gu = m.forwardRef(
  ({ children: i, value: e, disabled: t, textValue: n, ...r }, o) => /* @__PURE__ */ u(Oe.ComboboxItem, { asChild: !0, value: e, disabled: t, textValue: n, children: /* @__PURE__ */ u(Fn, { ref: o, ...r, children: /* @__PURE__ */ u(Oe.ItemText, { asChild: !0, children: /* @__PURE__ */ u(I, { children: i }) }) }) })
), Fn = x.div`
  width: 100%;
  border: none;
  text-align: left;
  outline-offset: -3px;
  padding: ${({ theme: i }) => i.spaces[2]} ${({ theme: i }) => i.spaces[4]};
  background-color: ${({ theme: i }) => i.colors.neutral0};
  border-radius: ${({ theme: i }) => i.borderRadius};
  user-select: none;

  &[data-state='checked'] {
    background-color: ${({ theme: i }) => i.colors.primary100};
    color: ${({ theme: i }) => i.colors.primary600};
    font-weight: bold;
  }

  &:hover,
  &[data-highlighted] {
    outline: none;
    background-color: ${({ theme: i, $hasHover: e = !0 }) => e ? i.colors.primary100 : i.colors.neutral0};
  }

  &[data-highlighted] {
    color: ${({ theme: i }) => i.colors.primary600};
    font-weight: bold;
  }
`, rl = (i, e) => `${i}${Math.floor(e * 255).toString(16).padStart(2, "0")}`, pu = tt.Root, mu = m.forwardRef((i, e) => /* @__PURE__ */ u(tt.Trigger, { ...i, asChild: !0, ref: e })), bu = m.forwardRef((i, e) => /* @__PURE__ */ u(tt.Portal, { children: /* @__PURE__ */ u(yu, { children: /* @__PURE__ */ u(wu, { ref: e, ...i }) }) })), yu = x(tt.Overlay)`
  background: ${(i) => rl(i.theme.colors.neutral800, 0.2)};
  position: fixed;
  inset: 0;
  z-index: ${(i) => i.theme.zIndices.overlay};
  will-change: opacity;

  @media (prefers-reduced-motion: no-preference) {
    animation: ${te.overlayFadeIn} ${(i) => i.theme.motion.timings[200]}
      ${(i) => i.theme.motion.easings.authenticMotion};
  }
`, wu = x(tt.Content)`
  max-width: 42rem;
  height: min-content;
  width: calc(100% - ${({ theme: i }) => i.spaces[8]});
  overflow: hidden;
  margin: 0 auto;
  display: flex;
  flex-direction: column;

  position: fixed;
  top: 50%;
  left: 50%;
  transform: translate(-50%, -50%);

  border-radius: ${(i) => i.theme.borderRadius};
  background-color: ${(i) => i.theme.colors.neutral0};
  box-shadow: ${(i) => i.theme.shadows.popupShadow};
  z-index: ${(i) => i.theme.zIndices.modal};

  @media (prefers-reduced-motion: no-preference) {
    &[data-state='open'] {
      animation-duration: ${(i) => i.theme.motion.timings[200]};
      animation-timing-function: ${(i) => i.theme.motion.easings.authenticMotion};
      animation-name: ${te.modalPopIn};
    }

    &[data-state='closed'] {
      animation-duration: ${(i) => i.theme.motion.timings[120]};
      animation-timing-function: ${(i) => i.theme.motion.easings.easeOutQuad};
      animation-name: ${te.modalPopOut};
    }
  }
`, xu = m.forwardRef(({ children: i, ...e }, t) => /* @__PURE__ */ u(tt.Title, { asChild: !0, children: /* @__PURE__ */ u(vu, { tag: "h2", variant: "beta", ref: t, padding: 6, fontWeight: "bold", ...e, children: i }) })), vu = x(I)`
  display: flex;
  justify-content: center;
  border-bottom: solid 1px ${(i) => i.theme.colors.neutral150};
`, Su = m.forwardRef(({ children: i, icon: e, ...t }, n) => /* @__PURE__ */ u(
  T,
  {
    ref: n,
    gap: 2,
    direction: "column",
    paddingTop: 8,
    paddingBottom: 8,
    paddingLeft: 6,
    paddingRight: 6,
    ...t,
    children: typeof i == "string" ? /* @__PURE__ */ $(yr, { children: [
      e ? m.cloneElement(e, {
        width: 24,
        height: 24
      }) : null,
      /* @__PURE__ */ u(ol, { children: i })
    ] }) : i
  }
)), ol = m.forwardRef((i, e) => /* @__PURE__ */ u(tt.Description, { asChild: !0, children: /* @__PURE__ */ u(I, { ref: e, variant: "omega", ...i, tag: "p" }) })), Cu = m.forwardRef((i, e) => /* @__PURE__ */ u(ku, { ref: e, gap: 2, padding: 4, justifyContent: "space-between", ...i, tag: "footer" })), ku = x(T)`
  border-top: solid 1px ${(i) => i.theme.colors.neutral150};
  flex: 1;
`, $u = m.forwardRef((i, e) => /* @__PURE__ */ u(tt.Cancel, { ...i, asChild: !0, ref: e })), Au = m.forwardRef((i, e) => /* @__PURE__ */ u(tt.Action, { ...i, asChild: !0, ref: e })), _m = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  Action: Au,
  Body: Su,
  Cancel: $u,
  Content: bu,
  Description: ol,
  Footer: Cu,
  Header: xu,
  Root: pu,
  Trigger: mu
}, Symbol.toStringTag, { value: "Module" }));
function Ue(i, e) {
  const t = m.useRef(null);
  return e && t.current && Tu(e, t.current) && (e = t.current), t.current = e ?? null, m.useMemo(() => new ih(i, e), [i, e]);
}
function Tu(i, e) {
  if (i === e)
    return !0;
  const t = Object.keys(i), n = Object.keys(e);
  if (t.length !== n.length)
    return !1;
  for (const r of t)
    if (e[r] !== i[r])
      return !1;
  return !0;
}
const Et = {
  Log: "live-region-log",
  Status: "live-region-status",
  Alert: "live-region-alert"
}, go = (i) => {
  const e = document.querySelector(`#${Et.Log}`);
  e && (e.innerText = i);
}, po = (i) => {
  const e = document.querySelector(`#${Et.Status}`);
  e && (e.innerText = i);
}, mo = (i) => {
  const e = document.querySelector(`#${Et.Alert}`);
  e && (e.innerText = i);
}, Gm = () => (m.useEffect(() => () => {
  go(""), mo(""), po("");
}, []), { notifyLog: go, notifyAlert: mo, notifyStatus: po }), Ru = () => /* @__PURE__ */ $(lt, { children: [
  /* @__PURE__ */ u("p", { role: "log", "aria-live": "polite", id: Et.Log, "aria-relevant": "all" }),
  /* @__PURE__ */ u("p", { role: "status", "aria-live": "polite", id: Et.Status, "aria-relevant": "all" }),
  /* @__PURE__ */ u("p", { role: "alert", "aria-live": "assertive", id: Et.Alert, "aria-relevant": "all" })
] }), Mu = Ja`
${D`
  *,
  *::before,
  *::after {
    box-sizing: border-box;
  }

  * {
    margin: 0;
  }

  html {
    /* Sets 1rem === 10px */
    font-size: 62.5%;
  }

  body {
    height: 100%;
    font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans',
      'Helvetica Neue', sans-serif;
    color: ${({ theme: i }) => i.colors.neutral800};
    line-height: 1.5;
    -webkit-font-smoothing: antialiased;
  }

  img,
  picture,
  video,
  canvas {
    display: block;
    max-width: 100%;
  }

  input,
  button,
  textarea,
  select {
    padding: 0;
    font: inherit;
  }

  button {
    border: unset;
    background: unset;
    padding: unset;
    margin: unset;
  }

  p,
  h1,
  h2,
  h3,
  h4,
  h5,
  h6 {
    overflow-wrap: break-word;
    font: unset;
  }

  #root {
    isolation: isolate;
  }

  ol,
  ul {
    list-style: none;
    padding: unset;
    margin: unset;
  }

  table {
    border-collapse: collapse;
    border-spacing: 0;
  }

  *:focus-visible {
    outline: 2px solid ${({ theme: i }) => i.colors.primary600};
    outline-offset: 2px;
  }

  *:has(> :disabled:not(button)) {
    cursor: not-allowed !important;
  }

  [aria-disabled='true']:not(button) {
    cursor: not-allowed !important;
  }

  /* Focusing the button with a mouse, touch, or stylus will show a subtle drop shadow. */
  *:focus:not(:focus-visible) {
    outline: none;
  }

  .lock-body-scroll {
    height: 100vh;
    overflow-y: hidden;
  }
`}
`, bo = "en-EN", sl = () => typeof navigator > "u" ? bo : navigator.language ? navigator.language : bo, [Du, cn] = Gt("StrapiDesignSystem", {
  locale: sl()
}), Ym = ({
  children: i,
  locale: e = sl(),
  theme: t = Zs,
  tooltipConfig: n
}) => (He(() => {
  const r = document.createElement("style");
  r.type = "text/css", r.appendChild(
    document.createTextNode(`
        * {
          -webkit-transition: none !important;
          -moz-transition: none !important;
          -o-transition: none !important;
          -ms-transition: none !important;
          transition: none !important;
          animation: none !important;
        }
    `)
  ), document.head.appendChild(r), window.getComputedStyle(r).opacity, document.head.removeChild(r);
}, [t]), /* @__PURE__ */ u(Du, { locale: e, children: /* @__PURE__ */ $(Qa, { theme: t, children: [
  /* @__PURE__ */ u(ch, { ...n, children: i }),
  /* @__PURE__ */ u(Ru, {}),
  /* @__PURE__ */ u(Mu, {})
] }) })), Ou = dh.Root, ll = m.forwardRef(
  ({ container: i = ((n) => (n = globalThis == null ? void 0 : globalThis.document) == null ? void 0 : n.body)(), ...e }, t) => i ? vh(/* @__PURE__ */ u(R, { ref: t, ...e }), i) : null
);
ll.displayName = "Portal";
const Eu = m.forwardRef(
  ({ onClear: i, clearLabel: e = "Clear", startIcon: t, disabled: n, hasError: r, children: o, id: s, size: l = "M", withTags: a, ...c }, h) => {
    const d = m.useRef(null), f = (b) => {
      i && !n && (i(b), d.current.focus());
    }, { labelNode: g } = Ce("SelectTrigger"), p = ve(d, h);
    return /* @__PURE__ */ u(Le.Trigger, { asChild: !0, children: /* @__PURE__ */ $(
      Iu,
      {
        "aria-disabled": n,
        $hasError: r,
        ref: p,
        alignItems: "center",
        justifyContent: "space-between",
        position: "relative",
        overflow: "hidden",
        hasRadius: !0,
        background: n ? "neutral150" : "neutral0",
        gap: 4,
        cursor: "default",
        "aria-labelledby": g ? `${s}-label` : void 0,
        $size: l,
        $withTags: a,
        $hasClear: !!i,
        ...c,
        children: [
          /* @__PURE__ */ $(T, { flex: "1", tag: "span", gap: 3, overflow: "hidden", children: [
            t && /* @__PURE__ */ u(T, { tag: "span", "aria-hidden": !0, children: t }),
            o
          ] }),
          /* @__PURE__ */ $(T, { tag: "span", gap: 3, children: [
            i ? /* @__PURE__ */ u(
              ot,
              {
                size: "XS",
                variant: "ghost",
                onClick: f,
                "aria-disabled": n,
                "aria-label": e,
                label: e,
                children: /* @__PURE__ */ u(kt, {})
              }
            ) : null,
            /* @__PURE__ */ u(Pu, { children: /* @__PURE__ */ u(Ze, {}) })
          ] })
        ]
      }
    ) });
  }
), Iu = x(T)`
  border: 1px solid ${({ theme: i, $hasError: e }) => e ? i.colors.danger600 : i.colors.neutral200};
  padding-inline-start: ${({ theme: i }) => i.spaces[4]};
  padding-inline-end: ${({ theme: i }) => i.spaces[3]};

  ${({ $size: i, $hasClear: e, $withTags: t, theme: n }) => t ? D`
        padding-inline-start: calc(${n.spaces[2]} - 1px);
        padding-block: calc(${n.spaces[2]} - 1px);

        ${n.breakpoints.medium} {
          padding-inline-start: 0.3rem;
          padding-block: 0.3rem;
        }
      ` : Mr({
  $size: i || "M",
  $hasValue: e,
  $hasClear: e,
  theme: n
})}
  cursor: pointer;

  &[aria-disabled='true'] {
    color: ${(i) => i.theme.colors.neutral500};
  }

  /* Required to ensure the below inputFocusStyles are adhered too */
  &:focus-visible {
    outline: none;
  }

  ${({ theme: i, $hasError: e }) => at()({ theme: i, $hasError: e })};
`, Pu = x(Le.Icon)`
  display: flex;
  & > svg {
    fill: ${({ theme: i }) => i.colors.neutral500};
  }
`, Lu = m.forwardRef(
  ({ children: i, placeholder: e, withTags: t, ...n }, r) => /* @__PURE__ */ u(Bu, { ref: r, ellipsis: !0, ...n, children: /* @__PURE__ */ u(zu, { placeholder: e, $withTags: t, children: i }) })
), Bu = x(I)`
  flex: 1;
  min-height: 2.4rem;

  ${({ theme: i }) => i.breakpoints.medium} {
    min-height: 2.2rem;
  }
`, zu = x(Le.Value)`
  ${({ $withTags: i }) => i ? D`
          display: flex;
          flex-wrap: wrap;
          gap: ${({ theme: e }) => e.spaces[1]};
        ` : null};
`, Nu = m.forwardRef((i, e) => /* @__PURE__ */ u(Fu, { ref: e, ...i, children: /* @__PURE__ */ u(hn, { children: i.children }) })), Fu = x(Le.Content)`
  background: ${({ theme: i }) => i.colors.neutral0};
  box-shadow: ${({ theme: i }) => i.shadows.filterShadow};
  border: 1px solid ${({ theme: i }) => i.colors.neutral150};
  border-radius: ${({ theme: i }) => i.borderRadius};
  min-width: var(--radix-select-trigger-width);
  max-height: 15.6rem;
  z-index: ${({ theme: i }) => i.zIndices.popover};

  @media (prefers-reduced-motion: no-preference) {
    animation-duration: ${(i) => i.theme.motion.timings[200]};

    /* The select can't animate out yet, watch https://github.com/radix-ui/primitives/issues/1893, or take a look and solve it yourself. */
    &[data-state='open'] {
      animation-timing-function: ${(i) => i.theme.motion.easings.authenticMotion};

      &[data-side='top'] {
        animation-name: ${te.slideUpIn};
      }

      &[data-side='bottom'] {
        animation-name: ${te.slideDownIn};
      }
    }
  }
`, Wu = x(Le.Viewport)`
  padding: ${({ theme: i }) => i.spaces[1]};
`, Hu = m.forwardRef((i, e) => /* @__PURE__ */ u(ju, { ref: e, ...i })), Vu = D`
  width: 100%;
  border: none;
  text-align: left;
  outline-offset: -3px;
  border-radius: ${(i) => i.theme.borderRadius};
  padding: ${(i) => `${i.theme.spaces[2]} ${i.theme.spaces[4]}`};
  padding-left: ${({ theme: i }) => i.spaces[4]};
  background-color: ${({ theme: i }) => i.colors.neutral0};
  display: flex;
  align-items: center;
  gap: ${({ theme: i }) => i.spaces[2]};
  white-space: nowrap;
  user-select: none;
  color: ${({ theme: i }) => i.colors.neutral800};

  &:focus-visible {
    outline: none;
    background-color: ${({ theme: i }) => i.colors.primary100};
    cursor: pointer;
  }
`, ju = x(Le.Item)`
  ${Vu}

  &:hover {
    background-color: ${({ theme: i }) => i.colors.primary100};
    cursor: pointer;
  }
`, al = Le.Root, hl = Eu, cl = Lu, dl = Le.Portal, ul = Nu, fl = Wu, Dr = Hu, gl = Le.ItemIndicator, pl = Le.ItemText, qu = Le.Group, yo = m.forwardRef(
  ({
    children: i,
    clearLabel: e = "Clear",
    customizeContent: t,
    disabled: n,
    hasError: r,
    id: o,
    name: s,
    onChange: l,
    onClear: a,
    onCloseAutoFocus: c,
    onReachEnd: h,
    placeholder: d,
    required: f,
    size: g,
    startIcon: p,
    value: b,
    ...w
  }, y) => {
    const [v, k] = m.useState(), [C, A] = m.useState(!1), S = (le) => {
      A(le);
    }, M = (le) => {
      a && a(le), l || k("");
    }, N = (le) => {
      l ? l(typeof b == "number" ? Number(le) : le) : k(le);
    }, z = m.useRef(null), F = Se(), Q = `intersection-${Nt(F)}`;
    Si(z, (le) => {
      h && h(le);
    }, {
      selectorToWatch: `#${Q}`,
      /**
       * We need to know when the select is open because only then will viewportRef
       * not be null. Because it uses a portal that (sensibly) is not mounted 24/7.
       */
      skipWhen: !C
    });
    const { error: K, required: L, ...se } = Ce("SingleSelect"), ue = !!K || r, B = se.id ?? o, J = se.name ?? s;
    let re;
    K ? re = `${B}-error` : se.hint && (re = `${B}-hint`);
    const oe = (typeof b < "u" && b !== null ? b.toString() : v) ?? "";
    return /* @__PURE__ */ $(
      al,
      {
        onOpenChange: S,
        disabled: n,
        required: L ?? f,
        onValueChange: N,
        value: oe,
        ...w,
        children: [
          /* @__PURE__ */ u(
            hl,
            {
              ref: y,
              id: B,
              name: J,
              startIcon: p,
              hasError: ue,
              disabled: n,
              clearLabel: e,
              onClear: oe && a ? M : void 0,
              "aria-label": w["aria-label"],
              "aria-describedby": re ?? w["aria-describedby"],
              size: g,
              children: /* @__PURE__ */ u(cl, { placeholder: d, textColor: oe ? "neutral800" : "neutral600", children: oe && t ? t(oe) : void 0 })
            }
          ),
          /* @__PURE__ */ u(dl, { children: /* @__PURE__ */ u(ul, { position: "popper", sideOffset: 4, onCloseAutoFocus: c, children: /* @__PURE__ */ $(fl, { ref: z, children: [
            i,
            /* @__PURE__ */ u(R, { id: Q, width: "100%", height: "1px" })
          ] }) }) })
        ]
      }
    );
  }
), wo = m.forwardRef(
  ({ value: i, startIcon: e, children: t, ...n }, r) => /* @__PURE__ */ $(Dr, { ref: r, value: i.toString(), ...n, children: [
    e && /* @__PURE__ */ u(T, { tag: "span", "aria-hidden": !0, children: e }),
    /* @__PURE__ */ u(I, { lineHeight: "20px", width: "100%", children: /* @__PURE__ */ u(pl, { children: t }) })
  ] })
), Ku = 200, xo = 15, [Uu, Yt] = Gt("DatePicker"), _u = m.forwardRef(
  ({
    /**
     * DatePickerCalendar props
     */
    calendarLabel: i,
    className: e,
    initialDate: t,
    locale: n,
    maxDate: r,
    minDate: o,
    monthSelectLabel: s = "Month",
    onChange: l,
    value: a,
    yearSelectLabel: c = "Year",
    /**
     * Combobox props
     */
    hasError: h,
    id: d,
    name: f,
    disabled: g = !1,
    required: p = !1,
    onClear: b,
    clearLabel: w = "Clear",
    size: y = "M",
    ...v
  }, k) => {
    const C = Dn(), A = cn("DatePicker"), S = n ?? A.locale, M = Ue(S, {
      day: "2-digit",
      month: "2-digit",
      year: "numeric"
    }), [N, z] = m.useState(!1), [F, Q] = m.useState(null), [U, K] = m.useState(null), [L, se] = m.useState(null), [ue, B] = m.useState(), [J, re] = We({
      defaultProp: t ? gt(t) : void 0,
      prop: a ? gt(a) : void 0,
      onChange(Z) {
        l && l(Z == null ? void 0 : Z.toDate(C));
      }
    }), [oe, le] = m.useMemo(() => {
      const Z = t ? gt(t) : br("UTC"), ft = o ? gt(o) : Z.set({ day: 1, month: 1, year: Z.year - Ku });
      let Zt = r ? gt(r) : Z.set({ day: 31, month: 12, year: Z.year + xo });
      return Zt.compare(ft) < 0 && (Zt = ft.set({ day: 31, month: 12, year: ft.year + xo })), [ft, Zt];
    }, [o, r, t]), [Be, V] = m.useState(
      Gu({
        currentValue: J,
        minDate: oe,
        maxDate: le
      })
    ), qe = Se(), ae = m.useRef(null), Tt = (Z) => {
      b && !g && (B(""), re(void 0), b(Z), U == null || U.focus());
    }, ht = m.useCallback(
      (Z) => {
        Z && J && V(J), z(Z);
      },
      [J]
    );
    He(() => {
      if (a) {
        const Z = gt(a);
        B(M.format(Z.toDate(C))), V(Z);
      } else
        B("");
    }, [a, M, C]), He(() => {
      if (t && ue === void 0) {
        const Z = gt(t);
        B(M.format(Z.toDate(C)));
      }
    }, [t, ue, M, C]);
    const { error: ct, ...Ke } = Ce("Combobox"), Rt = !!ct || h, dt = Ke.id ?? d, Jt = Ke.name ?? f, Qt = Ke.required || p;
    let ut;
    return ct ? ut = `${dt}-error` : Ke.hint && (ut = `${dt}-hint`), /* @__PURE__ */ $(
      Uu,
      {
        calendarDate: Be,
        content: L,
        contentId: qe,
        disabled: g,
        locale: S,
        minDate: oe,
        maxDate: le,
        open: N,
        onCalendarDateChange: V,
        onContentChange: se,
        onOpenChange: ht,
        onTextInputChange: K,
        onTextValueChange: B,
        onTriggerChange: Q,
        onValueChange: re,
        onClear: b,
        required: Qt,
        textInput: U,
        textValue: ue,
        timeZone: C,
        trigger: F,
        value: J,
        children: [
          /* @__PURE__ */ $(Xu, { className: e, hasError: Rt, size: y, children: [
            /* @__PURE__ */ u(yh, { fill: "neutral500", "aria-hidden": !0 }),
            /* @__PURE__ */ u(Zu, { ref: k, "aria-describedby": ut, id: dt, name: Jt, ...v }),
            ue && b ? /* @__PURE__ */ u(
              ot,
              {
                size: "XS",
                variant: "ghost",
                onClick: Tt,
                "aria-disabled": g,
                "aria-label": w,
                label: w,
                ref: ae,
                children: /* @__PURE__ */ u(kt, {})
              }
            ) : null
          ] }),
          /* @__PURE__ */ u(ll, { children: /* @__PURE__ */ u(rf, { label: i, children: /* @__PURE__ */ u(df, { monthSelectLabel: s, yearSelectLabel: c }) }) })
        ]
      }
    );
  }
), vo = (i) => !!i.match(/^[^a-zA-Z]*$/), Gu = ({ currentValue: i, minDate: e, maxDate: t }) => {
  const n = br("UTC");
  return i || (On(e, n) === e && En(t, n) === t ? n : On(e, n) === n ? e : En(t, n) === n ? t : n);
}, Yu = "DatePickerTrigger", Xu = m.forwardRef(
  ({ hasError: i, size: e, ...t }, n) => {
    const r = Yt(Yu), o = ve(n, (l) => r.onTriggerChange(l)), s = () => {
      r.disabled || r.onOpenChange(!0);
    };
    return /* @__PURE__ */ u(
      Rh,
      {
        asChild: !0,
        trapped: r.open,
        onMountAutoFocus: (l) => {
          l.preventDefault();
        },
        onUnmountAutoFocus: (l) => {
          var a;
          (a = document.getSelection()) == null || a.empty(), l.preventDefault();
        },
        children: /* @__PURE__ */ u(
          Ju,
          {
            ref: o,
            $hasError: i,
            $hasTextValue: !!r.textValue,
            $size: e,
            $hasOnClear: !!r.onClear,
            ...t,
            hasRadius: !0,
            gap: 3,
            overflow: "hidden",
            background: r.disabled ? "neutral150" : "neutral0",
            onClick: wt(t.onClick, () => {
              var l;
              (l = r.textInput) == null || l.focus();
            }),
            onPointerDown: wt(t.onPointerDown, (l) => {
              var h;
              const a = l.target;
              a.hasPointerCapture(l.pointerId) && a.releasePointerCapture(l.pointerId), (a.closest("button") ?? a.closest("div")) === l.currentTarget && l.button === 0 && l.ctrlKey === !1 && (s(), (h = r.textInput) == null || h.focus());
            })
          }
        )
      }
    );
  }
), Ju = x(T)`
  min-width: ${({ $hasOnClear: i }) => i ? "160px" : "130px"};
  border: 1px solid ${({ theme: i, $hasError: e }) => e ? i.colors.danger600 : i.colors.neutral200};
  padding-inline: ${({ theme: i }) => i.spaces[3]};
  ${({ $size: i, $hasTextValue: e, $hasOnClear: t, theme: n }) => Mr({
  $size: i || "M",
  $hasValue: e || !1,
  $hasClear: t || !1,
  theme: n
})}

  & > svg {
    flex: 1 0 auto;
  }

  &[data-disabled] {
    color: ${({ theme: i }) => i.colors.neutral600};
    background: ${({ theme: i }) => i.colors.neutral150};
    cursor: not-allowed;
  }

  /* Required to ensure the below inputFocusStyles are adhered too */
  &:focus-visible {
    outline: none;
  }

  ${({ theme: i, $hasError: e }) => at()({ theme: i, $hasError: e })};
`, Qu = "DatePickerTextInput", Zu = m.forwardRef(
  ({ placeholder: i, ...e }, t) => {
    const n = Yt(Qu), { onTextValueChange: r, textValue: o, onTextInputChange: s, onOpenChange: l, disabled: a, locale: c } = n, h = ve(t, (y) => s(y)), d = () => {
      a || l(!0);
    }, f = Ue(c, {
      year: "numeric",
      month: "2-digit",
      day: "2-digit"
    }), [g, p, b] = m.useMemo(() => {
      var A;
      const y = f.formatToParts(/* @__PURE__ */ new Date()), v = y.filter(
        (S) => S.type === "year" || S.type === "month" || S.type === "day"
      ), k = v.map((S) => {
        switch (S.type) {
          case "day":
            return "DD";
          case "month":
            return "MM";
          case "year":
            return "YYYY";
          default:
            return "";
        }
      }), C = ((A = y.find((S) => S.type === "literal")) == null ? void 0 : A.value) ?? "";
      return [k, C, v];
    }, [f]), w = g.map((y) => `\\d{${y.length}}`).join(`\\${p}`);
    return /* @__PURE__ */ u(
      tf,
      {
        role: "combobox",
        type: "text",
        inputMode: "numeric",
        ref: h,
        "aria-autocomplete": "none",
        "aria-controls": n.contentId,
        "aria-disabled": n.disabled,
        "aria-expanded": n.open,
        "aria-required": n.required,
        "aria-haspopup": "dialog",
        "data-state": n.open ? "open" : "closed",
        disabled: a,
        "data-disabled": a ? "" : void 0,
        pattern: w,
        placeholder: i ?? g.join(p),
        ...e,
        value: o ?? "",
        onBlur: wt(e.onBlur, () => {
          if (!n.textValue) {
            n.onValueChange(void 0);
            return;
          }
          n.onTextValueChange(f.format(n.calendarDate.toDate(n.timeZone))), n.onValueChange(n.calendarDate);
        }),
        onChange: wt(e.onChange, (y) => {
          if (vo(y.target.value)) {
            const v = y.target.value.split(p), [k, C, A] = b.map((K, L) => {
              const se = v[L];
              return {
                ...K,
                value: se
              };
            }).sort((K, L) => K.type === "year" ? 1 : L.type === "year" ? -1 : K.type === "month" ? 1 : L.type === "month" ? -1 : 0).map((K) => K.value), S = n.calendarDate.year;
            let M = n.calendarDate.year;
            if (A) {
              const K = A.length === 1 ? `0${A}` : A;
              M = A.length < 3 ? Number(`${S}`.slice(0, 4 - K.length) + K) : Number(K);
            }
            A && A.length < 3 && M > n.maxDate.year && (M -= 100);
            const N = n.calendarDate.set({ year: M }), z = N.calendar.getMonthsInYear(N), F = N.set({
              month: C && Number(C) <= z ? Number(C) : void 0
            }), Q = F.calendar.getDaysInMonth(F), U = F.set({
              day: k && Number(k) <= Q ? Number(k) : void 0
            });
            n.onCalendarDateChange(ef(U, n.minDate, n.maxDate)), n.onTextValueChange(y.target.value);
          }
        }),
        onKeyDown: wt(e.onKeyDown, (y) => {
          if (!n.open && (vo(y.key) || ["ArrowDown", "Backspace"].includes(y.key)))
            d();
          else if (["Tab"].includes(y.key) && n.open)
            y.preventDefault();
          else if (["Escape"].includes(y.key))
            n.open ? n.onOpenChange(!1) : (n.onValueChange(void 0), n.onTextValueChange("")), y.preventDefault();
          else if (n.open && ["ArrowDown", "ArrowUp", "ArrowLeft", "ArrowRight"].includes(y.key))
            switch (y.preventDefault(), y.key) {
              case "ArrowDown": {
                const v = n.calendarDate.add({ weeks: 1 });
                if (n.maxDate && v.compare(n.maxDate) > 0)
                  return;
                n.onCalendarDateChange(v);
                return;
              }
              case "ArrowRight": {
                const v = n.calendarDate.add({ days: 1 });
                if (n.maxDate && v.compare(n.maxDate) > 0)
                  return;
                n.onCalendarDateChange(v);
                return;
              }
              case "ArrowUp": {
                const v = n.calendarDate.subtract({ weeks: 1 });
                if (n.minDate && v.compare(n.minDate) < 0)
                  return;
                n.onCalendarDateChange(v);
                return;
              }
              case "ArrowLeft": {
                const v = n.calendarDate.subtract({ days: 1 });
                if (n.minDate && v.compare(n.minDate) < 0)
                  return;
                n.onCalendarDateChange(v);
              }
            }
          else n.open && ["Enter"].includes(y.key) && (y.preventDefault(), r(f.format(n.calendarDate.toDate(n.timeZone))), n.onValueChange(n.calendarDate), n.onOpenChange(!1));
        })
      }
    );
  }
);
function ef(i, e, t) {
  return e && (i = En(i, e)), t && (i = On(i, t)), i;
}
const tf = x.input`
  width: 100%;
  ${il}
  color: ${({ theme: i }) => i.colors.neutral800};
  border: none;
  background-color: transparent;

  &:focus-visible {
    outline: none;
  }

  &::placeholder {
    color: ${({ theme: i }) => i.colors.neutral600};
    opacity: 1;
  }

  &[aria-disabled='true'] {
    cursor: inherit;
  }
`, nf = "DatePickerContent", rf = m.forwardRef((i, e) => {
  const t = Yt(nf), [n, r] = m.useState(!1);
  return m.useEffect(() => {
    t.open && !n && r(!0);
  }, [t.open, n]), !t.open && !n || !t.open ? null : /* @__PURE__ */ u(sf, { ...i, ref: e });
}), of = "DatePickerContent", sf = m.forwardRef(
  (i, e) => {
    const { label: t = "Choose date", ...n } = i, { onOpenChange: r, ...o } = Yt(of), { x: s, y: l, refs: a, strategy: c, placement: h } = Sh({
      strategy: "fixed",
      placement: "bottom-start",
      middleware: [
        kh({
          mainAxis: 4
        }),
        $h(),
        Ah()
      ],
      elements: {
        reference: o.trigger
      },
      whileElementsMounted: Ch
    });
    m.useEffect(() => {
      const f = () => {
        r(!1);
      };
      return window.addEventListener("blur", f), window.addEventListener("resize", f), () => {
        window.removeEventListener("blur", f), window.removeEventListener("resize", f);
      };
    }, [r]);
    const d = ve(
      e,
      (f) => o.onContentChange(f),
      a.setFloating
    );
    return Th(), /* @__PURE__ */ u(Mh, { allowPinchZoom: !0, children: /* @__PURE__ */ u(
      Ou,
      {
        asChild: !0,
        onFocusOutside: (f) => {
          f.preventDefault();
        },
        onDismiss: () => {
          r(!1);
        },
        children: /* @__PURE__ */ u(
          lf,
          {
            ref: d,
            "data-state": o.open ? "open" : "closed",
            "data-side": h.includes("top") ? "top" : "bottom",
            onContextMenu: (f) => f.preventDefault(),
            id: o.contentId,
            role: "dialog",
            "aria-modal": "true",
            "aria-label": t,
            style: {
              left: s,
              top: l,
              position: c
            },
            hasRadius: !0,
            background: "neutral0",
            padding: 1,
            ...n
          }
        )
      }
    ) });
  }
), lf = x(R)`
  box-shadow: ${({ theme: i }) => i.shadows.filterShadow};
  z-index: ${({ theme: i }) => i.zIndices.popover};
  border: 1px solid ${({ theme: i }) => i.colors.neutral150};

  @media (prefers-reduced-motion: no-preference) {
    animation-duration: ${(i) => i.theme.motion.timings[200]};

    &[data-state='open'] {
      animation-timing-function: ${(i) => i.theme.motion.easings.authenticMotion};

      &[data-side='top'] {
        animation-name: ${te.slideUpIn};
      }

      &[data-side='bottom'] {
        animation-name: ${te.slideDownIn};
      }
    }
  }
`, af = "DatePickerCalendar", [hf, cf] = Gt("DateFormatters"), df = m.forwardRef(
  ({ monthSelectLabel: i, yearSelectLabel: e, ...t }, n) => {
    const { locale: r, timeZone: o, minDate: s, maxDate: l, calendarDate: a, onCalendarDateChange: c } = Yt(af), h = oh(a), d = m.useMemo(() => {
      const S = s.year, M = l.year;
      return [...Array(M - S + 1).keys()].map((N) => (S + N).toString());
    }, [s, l]), f = Ue(r, { month: "long" }), g = m.useMemo(
      () => [...Array(a.calendar.getMonthsInYear(a)).keys()].map(
        (S) => f.format(a.set({ month: S + 1 }).toDate(o))
      ),
      [a, f, o]
    ), p = Ue(r, { weekday: "short" }), b = m.useMemo(() => {
      const S = bs(br(o), r);
      return [...new Array(7).keys()].map((M) => {
        const z = S.add({ days: M }).toDate(o);
        return p.format(z);
      });
    }, [o, r, p]), w = Ue(r, {
      weekday: "long",
      day: "numeric",
      month: "long",
      year: "numeric"
    }), y = Ue(r, {
      day: "numeric",
      calendar: a.calendar.identifier
    }), v = Ue(r, {
      day: "2-digit",
      month: "2-digit",
      year: "numeric"
    }), k = (S) => {
      if (typeof S == "number")
        return;
      const M = a.set({ month: g.indexOf(S) + 1 });
      c(M);
    }, C = (S) => {
      if (typeof S == "number")
        return;
      const M = a.set({ year: parseInt(S, 10) });
      c(M);
    }, A = uf(h, r);
    return /* @__PURE__ */ u(
      hf,
      {
        dateFormatter: w,
        cellDateFormatter: y,
        textValueFormatter: v,
        children: /* @__PURE__ */ $(T, { ref: n, direction: "column", alignItems: "stretch", padding: 4, ...t, children: [
          /* @__PURE__ */ $(ff, { justifyContent: "flex-start", paddingBottom: 4, paddingLeft: 2, paddingRight: 2, gap: 2, children: [
            /* @__PURE__ */ u(xt, { children: /* @__PURE__ */ u(
              yo,
              {
                "aria-label": i,
                value: g[a.month - 1],
                onChange: k,
                children: g.map((S) => /* @__PURE__ */ u(wo, { value: S, children: S }, S))
              }
            ) }),
            /* @__PURE__ */ u(xt, { children: /* @__PURE__ */ u(
              yo,
              {
                value: a.year.toString(),
                "aria-label": e,
                onChange: C,
                children: d.map((S) => /* @__PURE__ */ u(wo, { value: S, children: S }, S))
              }
            ) })
          ] }),
          /* @__PURE__ */ $("table", { role: "grid", children: [
            /* @__PURE__ */ u("thead", { "aria-hidden": !0, children: /* @__PURE__ */ u("tr", { "aria-rowindex": 0, children: b.map((S, M) => /* @__PURE__ */ u(gf, { "aria-colindex": M, children: S }, S)) }) }),
            /* @__PURE__ */ u("tbody", { children: [...new Array(6).keys()].map((S) => /* @__PURE__ */ u("tr", { "aria-rowindex": S + 2, children: A(S).map(
              (M, N) => M ? /* @__PURE__ */ u(
                bf,
                {
                  "aria-colindex": N + 1,
                  date: M,
                  startDate: h,
                  disabled: s.compare(M) > 0 || M.compare(l) > 0
                },
                M.toString()
              ) : /* @__PURE__ */ u(ml, { "aria-colindex": N + 1 }, N + 1)
            ) }, S)) })
          ] })
        ] })
      }
    );
  }
), uf = (i, e) => (t) => {
  let n = i.add({ weeks: t });
  const r = [];
  n = bs(n, e);
  const o = sh(n, e);
  for (let s = 0; s < o; s++)
    r.push(null);
  for (; r.length < 7; ) {
    r.push(n);
    const s = n.add({ days: 1 });
    if (ys(n, s))
      break;
    n = s;
  }
  for (; r.length < 7; )
    r.push(null);
  return r;
}, ff = x(T)`
  div[role='combobox'] {
    border: 1px solid transparent;
    background: transparent;
    font-weight: ${(i) => i.theme.fontWeights.bold};

    svg {
      fill: ${({ theme: i }) => i.colors.neutral500};
    }

    &:hover {
      background-color: ${({ theme: i }) => i.colors.neutral100};
    }
  }
`, gf = m.forwardRef(
  ({ children: i, ...e }, t) => /* @__PURE__ */ u(pf, { tag: "th", role: "gridcell", ref: t, ...e, height: "2.4rem", width: "3.2rem", children: /* @__PURE__ */ u(I, { variant: "pi", fontWeight: "bold", color: "neutral800", children: i.slice(0, 2) }) })
), pf = x(R)`
  border-radius: ${({ theme: i }) => i.borderRadius};
  text-transform: capitalize;
`, mf = "DatePickerCalendarCell", bf = m.forwardRef(
  ({ date: i, startDate: e, disabled: t, ...n }, r) => {
    const { timeZone: o, calendarDate: s, onValueChange: l, onOpenChange: a, onTextValueChange: c, onCalendarDateChange: h } = Yt(mf), { dateFormatter: d, cellDateFormatter: f, textValueFormatter: g } = cf("DatePickerCalendarCell"), p = ys(s, i), b = m.useMemo(() => d.format(i.toDate(o)), [d, i, o]), w = m.useMemo(
      () => f.formatToParts(i.toDate(o)).find((C) => C.type === "day").value,
      [f, i, o]
    ), y = lh(e), v = i.compare(e) < 0 || i.compare(y) > 0;
    let k = "neutral900";
    return p ? k = "primary600" : v && (k = "neutral600"), /* @__PURE__ */ u(
      ml,
      {
        tag: "td",
        role: "gridcell",
        ref: r,
        "aria-selected": p,
        ...n,
        hasRadius: !0,
        "aria-label": b,
        tabIndex: p ? 0 : -1,
        background: p ? "primary100" : "neutral0",
        cursor: "pointer",
        onPointerDown: wt(n.onPointerDown, (C) => {
          C.preventDefault(), h(i), l(i), c(g.format(i.toDate(o))), a(!1);
        }),
        "aria-disabled": t,
        children: /* @__PURE__ */ u(I, { variant: "pi", textColor: k, children: w })
      }
    );
  }
), ml = x(R)`
  text-align: center;
  padding: 0.7rem;
  // Trick to prevent the outline from overflowing because of the general outline-offset
  outline-offset: -2px !important;
  &[aria-disabled='true'] {
    pointer-events: none;
    opacity: 0.5;
  }

  &[aria-disabled='false'] {
    &:hover {
      background: ${({ theme: i }) => i.colors.primary100};
      color: ${({ theme: i }) => i.colors.primary600};
    }
  }
`, gt = (i) => {
  const e = i.toISOString(), t = nh(e, "UTC");
  return rh(t);
}, yf = m.memo(_u), yn = (i) => !!i.match(/^[^a-zA-Z]*$/);
function wf(i = "") {
  return i.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
}
const xf = x(au)`
  min-width: ${({ onClear: i }) => i ? "160px" : "130px"};
`, vf = m.forwardRef(
  ({ step: i = 15, value: e, defaultValue: t, onChange: n, ...r }, o) => {
    const s = cn("TimePicker"), [l, a] = m.useState(""), [c, h] = We({
      prop: e,
      defaultProp: t,
      onChange: n
    }), d = Ue(s.locale, {
      hour: "2-digit",
      minute: "2-digit",
      hour12: !1
    }), f = m.useMemo(() => {
      const C = d.formatToParts(/* @__PURE__ */ new Date()), { value: A } = C.find((S) => S.type === "literal");
      return A;
    }, [d]), g = m.useMemo(() => {
      const C = 60 / i;
      return [...Array(24).keys()].flatMap(
        (A) => [...Array(C).keys()].map((S) => d.format(new Date(0, 0, 0, A, S * i)))
      );
    }, [i, d]), p = (C) => {
      (!C || yn(C)) && a(C);
    }, b = (C) => {
      const [A, S] = C.split(f);
      if (!A && !S) return;
      const M = Number(A ?? "0"), N = Number(S ?? "0");
      if (!(M > 23 || N > 59))
        return d.format(new Date(0, 0, 0, M, N));
    }, w = (C) => {
      const A = b(C.target.value);
      A ? (a(A), h(A)) : a(c);
    }, y = (C) => {
      if (typeof C < "u") {
        const A = b(C);
        h(A);
      } else
        h(C);
    };
    m.useEffect(() => {
      const C = typeof e > "u" ? "" : e;
      yn(C) && a(C);
    }, [e, a]);
    const k = `\\d{2}${wf(f)}\\d{2}`;
    return /* @__PURE__ */ u(
      xf,
      {
        ...r,
        ref: o,
        value: c,
        onChange: y,
        isPrintableCharacter: yn,
        allowCustomValue: !0,
        placeholder: `--${f}--`,
        autocomplete: "none",
        startIcon: /* @__PURE__ */ u(wh, { fill: "neutral500" }),
        inputMode: "numeric",
        pattern: k,
        textValue: l,
        onTextValueChange: p,
        onBlur: w,
        children: g.map((C) => /* @__PURE__ */ u(gu, { value: C, children: C }, C))
      }
    );
  }
), Xm = m.forwardRef(
  ({
    clearLabel: i = "clear",
    dateLabel: e = "Choose date",
    timeLabel: t = "Choose time",
    disabled: n = !1,
    hasError: r,
    onChange: o,
    onClear: s,
    required: l = !1,
    step: a,
    value: c,
    initialDate: h,
    size: d,
    ...f
  }, g) => {
    const p = m.useRef(null), [b, w] = m.useState(!1), y = c ? ei(c, !1) : void 0, [v, k] = We({
      defaultProp: h ? ei(h, !1) : void 0,
      prop: b ? void 0 : y,
      onChange(B) {
        o && o(B == null ? void 0 : B.toDate(Dn()));
      }
    }), C = cn("DateTimePicker"), A = Ue(C.locale, {
      hour: "2-digit",
      minute: "2-digit",
      hour12: !1
    }), S = v ? A.format(v.toDate(Dn())) : "", M = m.useRef(c);
    He(() => {
      b && v && k(void 0);
    }, [b, v, k]), He(() => {
      const B = M.current;
      c == null && B != null && v && k(void 0), b && c !== B && w(!1), M.current = c;
    }, [c, v, b, k, w]), He(() => {
      b && v === void 0 && c == null && w(!1);
    }, [b, v, c, w]);
    const N = (B) => {
      let J = B ? ei(B) : void 0;
      if (S && J) {
        const [re, oe] = S.split(":");
        J = J.set({ hour: parseInt(re, 10), minute: parseInt(oe, 10) });
      }
      k(J);
    }, z = (B) => {
      if (!B)
        return;
      const [J, re] = B.split(":"), oe = v ? v.set({ hour: parseInt(J, 10), minute: parseInt(re, 10) }) : ei(/* @__PURE__ */ new Date()).set({
        hour: parseInt(J, 10),
        minute: parseInt(re, 10)
      });
      k(oe);
    }, F = (B) => {
      B.preventDefault(), w(!0), s && s(B);
    }, Q = () => {
      const B = v ? v.set({ hour: 0, minute: 0 }) : ei(/* @__PURE__ */ new Date());
      k(B);
    }, U = ve(p, g), { error: K, id: L, labelNode: se } = Ce("DateTimePicker"), ue = !!K || r;
    return /* @__PURE__ */ $(T, { "aria-labelledby": se ? `${L}-label` : void 0, role: "group", flex: "1", gap: 1, wrap: "wrap", children: [
      /* @__PURE__ */ u(xt, { flex: "1", children: /* @__PURE__ */ u(
        yf,
        {
          ...f,
          hasError: ue,
          size: d,
          value: v == null ? void 0 : v.toDate("UTC"),
          onChange: N,
          required: l,
          onClear: s ? F : void 0,
          clearLabel: `${i} date`,
          disabled: n,
          ref: U,
          "aria-label": e
        }
      ) }),
      /* @__PURE__ */ u(xt, { flex: "1", children: /* @__PURE__ */ u(
        vf,
        {
          size: d,
          hasError: ue,
          value: S,
          onChange: z,
          onClear: s && S !== void 0 && S !== "00:00" ? Q : void 0,
          clearLabel: `${i} time`,
          required: l,
          disabled: n,
          step: a,
          "aria-label": t
        }
      ) })
    ] });
  }
), ei = (i, e = !0) => {
  const t = i.toISOString();
  let n = ah(t);
  return e && (n = n.set({ hour: 0, minute: 0 })), hh(n);
}, bl = m.forwardRef((i, e) => /* @__PURE__ */ u(
  Sf,
  {
    ref: e,
    background: "neutral150",
    ...i,
    "data-orientation": "horizontal",
    role: "separator",
    tag: "div"
  }
)), Sf = x(R)`
  height: 1px;
  border: none;
  /* If contained in a Flex parent we want to prevent the Divider to shink */
  flex-shrink: 0;
`, Cf = x(R)`
  svg {
    height: 8.8rem;
  }
`, Jm = m.forwardRef(
  ({ icon: i, content: e, action: t, hasRadius: n = !0, shadow: r = "tableShadow" }, o) => /* @__PURE__ */ $(
    T,
    {
      ref: o,
      alignItems: "center",
      direction: "column",
      padding: 11,
      background: "neutral0",
      hasRadius: n,
      shadow: r,
      children: [
        i ? /* @__PURE__ */ u(Cf, { paddingBottom: 6, "aria-hidden": !0, children: i }) : null,
        /* @__PURE__ */ u(R, { paddingBottom: 4, children: /* @__PURE__ */ u(I, { variant: "delta", tag: "p", textAlign: "center", textColor: "neutral600", children: e }) }),
        t
      ]
    }
  )
);
let Wn = [], yl = [];
(() => {
  let i = "lc,34,7n,7,7b,19,,,,2,,2,,,20,b,1c,l,g,,2t,7,2,6,2,2,,4,z,,u,r,2j,b,1m,9,9,,o,4,,9,,3,,5,17,3,3b,f,,w,1j,,,,4,8,4,,3,7,a,2,t,,1m,,,,2,4,8,,9,,a,2,q,,2,2,1l,,4,2,4,2,2,3,3,,u,2,3,,b,2,1l,,4,5,,2,4,,k,2,m,6,,,1m,,,2,,4,8,,7,3,a,2,u,,1n,,,,c,,9,,14,,3,,1l,3,5,3,,4,7,2,b,2,t,,1m,,2,,2,,3,,5,2,7,2,b,2,s,2,1l,2,,,2,4,8,,9,,a,2,t,,20,,4,,2,3,,,8,,29,,2,7,c,8,2q,,2,9,b,6,22,2,r,,,,,,1j,e,,5,,2,5,b,,10,9,,2u,4,,6,,2,2,2,p,2,4,3,g,4,d,,2,2,6,,f,,jj,3,qa,3,t,3,t,2,u,2,1s,2,,7,8,,2,b,9,,19,3,3b,2,y,,3a,3,4,2,9,,6,3,63,2,2,,1m,,,7,,,,,2,8,6,a,2,,1c,h,1r,4,1c,7,,,5,,14,9,c,2,w,4,2,2,,3,1k,,,2,3,,,3,1m,8,2,2,48,3,,d,,7,4,,6,,3,2,5i,1m,,5,ek,,5f,x,2da,3,3x,,2o,w,fe,6,2x,2,n9w,4,,a,w,2,28,2,7k,,3,,4,,p,2,5,,47,2,q,i,d,,12,8,p,b,1a,3,1c,,2,4,2,2,13,,1v,6,2,2,2,2,c,,8,,1b,,1f,,,3,2,2,5,2,,,16,2,8,,6m,,2,,4,,fn4,,kh,g,g,g,a6,2,gt,,6a,,45,5,1ae,3,,2,5,4,14,3,4,,4l,2,fx,4,ar,2,49,b,4w,,1i,f,1k,3,1d,4,2,2,1x,3,10,5,,8,1q,,c,2,1g,9,a,4,2,,2n,3,2,,,2,6,,4g,,3,8,l,2,1l,2,,,,,m,,e,7,3,5,5f,8,2,3,,,n,,29,,2,6,,,2,,,2,,2,6j,,2,4,6,2,,2,r,2,2d,8,2,,,2,2y,,,,2,6,,,2t,3,2,4,,5,77,9,,2,6t,,a,2,,,4,,40,4,2,2,4,,w,a,14,6,2,4,8,,9,6,2,3,1a,d,,2,ba,7,,6,,,2a,m,2,7,,2,,2,3e,6,3,,,2,,7,,,20,2,3,,,,9n,2,f0b,5,1n,7,t4,,1r,4,29,,f5k,2,43q,,,3,4,5,8,8,2,7,u,4,44,3,1iz,1j,4,1e,8,,e,,m,5,,f,11s,7,,h,2,7,,2,,5,79,7,c5,4,15s,7,31,7,240,5,gx7k,2o,3k,6o".split(",").map((e) => e ? parseInt(e, 36) : 1);
  for (let e = 0, t = 0; e < i.length; e++)
    (e % 2 ? yl : Wn).push(t = t + i[e]);
})();
function kf(i) {
  if (i < 768) return !1;
  for (let e = 0, t = Wn.length; ; ) {
    let n = e + t >> 1;
    if (i < Wn[n]) t = n;
    else if (i >= yl[n]) e = n + 1;
    else return !0;
    if (e == t) return !1;
  }
}
function So(i) {
  return i >= 127462 && i <= 127487;
}
const Co = 8205;
function $f(i, e, t = !0, n = !0) {
  return (t ? wl : Af)(i, e, n);
}
function wl(i, e, t) {
  if (e == i.length) return e;
  e && xl(i.charCodeAt(e)) && vl(i.charCodeAt(e - 1)) && e--;
  let n = wn(i, e);
  for (e += ko(n); e < i.length; ) {
    let r = wn(i, e);
    if (n == Co || r == Co || t && kf(r))
      e += ko(r), n = r;
    else if (So(r)) {
      let o = 0, s = e - 2;
      for (; s >= 0 && So(wn(i, s)); )
        o++, s -= 2;
      if (o % 2 == 0) break;
      e += 2;
    } else
      break;
  }
  return e;
}
function Af(i, e, t) {
  for (; e > 0; ) {
    let n = wl(i, e - 2, t);
    if (n < e) return n;
    e--;
  }
  return 0;
}
function wn(i, e) {
  let t = i.charCodeAt(e);
  if (!vl(t) || e + 1 == i.length) return t;
  let n = i.charCodeAt(e + 1);
  return xl(n) ? (t - 55296 << 10) + (n - 56320) + 65536 : t;
}
function xl(i) {
  return i >= 56320 && i < 57344;
}
function vl(i) {
  return i >= 55296 && i < 56320;
}
function ko(i) {
  return i < 65536 ? 1 : 2;
}
class W {
  /**
  Get the line description around the given position.
  */
  lineAt(e) {
    if (e < 0 || e > this.length)
      throw new RangeError(`Invalid position ${e} in document of length ${this.length}`);
    return this.lineInner(e, !1, 1, 0);
  }
  /**
  Get the description for the given (1-based) line number.
  */
  line(e) {
    if (e < 1 || e > this.lines)
      throw new RangeError(`Invalid line number ${e} in ${this.lines}-line document`);
    return this.lineInner(e, !0, 1, 0);
  }
  /**
  Replace a range of the text with the given content.
  */
  replace(e, t, n) {
    [e, t] = Ft(this, e, t);
    let r = [];
    return this.decompose(
      0,
      e,
      r,
      2
      /* Open.To */
    ), n.length && n.decompose(
      0,
      n.length,
      r,
      3
      /* Open.To */
    ), this.decompose(
      t,
      this.length,
      r,
      1
      /* Open.From */
    ), Ne.from(r, this.length - (t - e) + n.length);
  }
  /**
  Append another document to this one.
  */
  append(e) {
    return this.replace(this.length, this.length, e);
  }
  /**
  Retrieve the text between the given points.
  */
  slice(e, t = this.length) {
    [e, t] = Ft(this, e, t);
    let n = [];
    return this.decompose(e, t, n, 0), Ne.from(n, t - e);
  }
  /**
  Test whether this text is equal to another instance.
  */
  eq(e) {
    if (e == this)
      return !0;
    if (e.length != this.length || e.lines != this.lines)
      return !1;
    let t = this.scanIdentical(e, 1), n = this.length - this.scanIdentical(e, -1), r = new ai(this), o = new ai(e);
    for (let s = t, l = t; ; ) {
      if (r.next(s), o.next(s), s = 0, r.lineBreak != o.lineBreak || r.done != o.done || r.value != o.value)
        return !1;
      if (l += r.value.length, r.done || l >= n)
        return !0;
    }
  }
  /**
  Iterate over the text. When `dir` is `-1`, iteration happens
  from end to start. This will return lines and the breaks between
  them as separate strings.
  */
  iter(e = 1) {
    return new ai(this, e);
  }
  /**
  Iterate over a range of the text. When `from` > `to`, the
  iterator will run in reverse.
  */
  iterRange(e, t = this.length) {
    return new Sl(this, e, t);
  }
  /**
  Return a cursor that iterates over the given range of lines,
  _without_ returning the line breaks between, and yielding empty
  strings for empty lines.
  
  When `from` and `to` are given, they should be 1-based line numbers.
  */
  iterLines(e, t) {
    let n;
    if (e == null)
      n = this.iter();
    else {
      t == null && (t = this.lines + 1);
      let r = this.line(e).from;
      n = this.iterRange(r, Math.max(r, t == this.lines + 1 ? this.length : t <= 1 ? 0 : this.line(t - 1).to));
    }
    return new Cl(n);
  }
  /**
  Return the document as a string, using newline characters to
  separate lines.
  */
  toString() {
    return this.sliceString(0);
  }
  /**
  Convert the document to an array of lines (which can be
  deserialized again via [`Text.of`](https://codemirror.net/6/docs/ref/#state.Text^of)).
  */
  toJSON() {
    let e = [];
    return this.flatten(e), e;
  }
  /**
  @internal
  */
  constructor() {
  }
  /**
  Create a `Text` instance for the given array of lines.
  */
  static of(e) {
    if (e.length == 0)
      throw new RangeError("A document must have at least one line");
    return e.length == 1 && !e[0] ? W.empty : e.length <= 32 ? new ee(e) : Ne.from(ee.split(e, []));
  }
}
class ee extends W {
  constructor(e, t = Tf(e)) {
    super(), this.text = e, this.length = t;
  }
  get lines() {
    return this.text.length;
  }
  get children() {
    return null;
  }
  lineInner(e, t, n, r) {
    for (let o = 0; ; o++) {
      let s = this.text[o], l = r + s.length;
      if ((t ? n : l) >= e)
        return new Rf(r, l, n, s);
      r = l + 1, n++;
    }
  }
  decompose(e, t, n, r) {
    let o = e <= 0 && t >= this.length ? this : new ee($o(this.text, e, t), Math.min(t, this.length) - Math.max(0, e));
    if (r & 1) {
      let s = n.pop(), l = Hi(o.text, s.text.slice(), 0, o.length);
      if (l.length <= 32)
        n.push(new ee(l, s.length + o.length));
      else {
        let a = l.length >> 1;
        n.push(new ee(l.slice(0, a)), new ee(l.slice(a)));
      }
    } else
      n.push(o);
  }
  replace(e, t, n) {
    if (!(n instanceof ee))
      return super.replace(e, t, n);
    [e, t] = Ft(this, e, t);
    let r = Hi(this.text, Hi(n.text, $o(this.text, 0, e)), t), o = this.length + n.length - (t - e);
    return r.length <= 32 ? new ee(r, o) : Ne.from(ee.split(r, []), o);
  }
  sliceString(e, t = this.length, n = `
`) {
    [e, t] = Ft(this, e, t);
    let r = "";
    for (let o = 0, s = 0; o <= t && s < this.text.length; s++) {
      let l = this.text[s], a = o + l.length;
      o > e && s && (r += n), e < a && t > o && (r += l.slice(Math.max(0, e - o), t - o)), o = a + 1;
    }
    return r;
  }
  flatten(e) {
    for (let t of this.text)
      e.push(t);
  }
  scanIdentical() {
    return 0;
  }
  static split(e, t) {
    let n = [], r = -1;
    for (let o of e)
      n.push(o), r += o.length + 1, n.length == 32 && (t.push(new ee(n, r)), n = [], r = -1);
    return r > -1 && t.push(new ee(n, r)), t;
  }
}
class Ne extends W {
  constructor(e, t) {
    super(), this.children = e, this.length = t, this.lines = 0;
    for (let n of e)
      this.lines += n.lines;
  }
  lineInner(e, t, n, r) {
    for (let o = 0; ; o++) {
      let s = this.children[o], l = r + s.length, a = n + s.lines - 1;
      if ((t ? a : l) >= e)
        return s.lineInner(e, t, n, r);
      r = l + 1, n = a + 1;
    }
  }
  decompose(e, t, n, r) {
    for (let o = 0, s = 0; s <= t && o < this.children.length; o++) {
      let l = this.children[o], a = s + l.length;
      if (e <= a && t >= s) {
        let c = r & ((s <= e ? 1 : 0) | (a >= t ? 2 : 0));
        s >= e && a <= t && !c ? n.push(l) : l.decompose(e - s, t - s, n, c);
      }
      s = a + 1;
    }
  }
  replace(e, t, n) {
    if ([e, t] = Ft(this, e, t), n.lines < this.lines)
      for (let r = 0, o = 0; r < this.children.length; r++) {
        let s = this.children[r], l = o + s.length;
        if (e >= o && t <= l) {
          let a = s.replace(e - o, t - o, n), c = this.lines - s.lines + a.lines;
          if (a.lines < c >> 4 && a.lines > c >> 6) {
            let h = this.children.slice();
            return h[r] = a, new Ne(h, this.length - (t - e) + n.length);
          }
          return super.replace(o, l, a);
        }
        o = l + 1;
      }
    return super.replace(e, t, n);
  }
  sliceString(e, t = this.length, n = `
`) {
    [e, t] = Ft(this, e, t);
    let r = "";
    for (let o = 0, s = 0; o < this.children.length && s <= t; o++) {
      let l = this.children[o], a = s + l.length;
      s > e && o && (r += n), e < a && t > s && (r += l.sliceString(e - s, t - s, n)), s = a + 1;
    }
    return r;
  }
  flatten(e) {
    for (let t of this.children)
      t.flatten(e);
  }
  scanIdentical(e, t) {
    if (!(e instanceof Ne))
      return 0;
    let n = 0, [r, o, s, l] = t > 0 ? [0, 0, this.children.length, e.children.length] : [this.children.length - 1, e.children.length - 1, -1, -1];
    for (; ; r += t, o += t) {
      if (r == s || o == l)
        return n;
      let a = this.children[r], c = e.children[o];
      if (a != c)
        return n + a.scanIdentical(c, t);
      n += a.length + 1;
    }
  }
  static from(e, t = e.reduce((n, r) => n + r.length + 1, -1)) {
    let n = 0;
    for (let g of e)
      n += g.lines;
    if (n < 32) {
      let g = [];
      for (let p of e)
        p.flatten(g);
      return new ee(g, t);
    }
    let r = Math.max(
      32,
      n >> 5
      /* Tree.BranchShift */
    ), o = r << 1, s = r >> 1, l = [], a = 0, c = -1, h = [];
    function d(g) {
      let p;
      if (g.lines > o && g instanceof Ne)
        for (let b of g.children)
          d(b);
      else g.lines > s && (a > s || !a) ? (f(), l.push(g)) : g instanceof ee && a && (p = h[h.length - 1]) instanceof ee && g.lines + p.lines <= 32 ? (a += g.lines, c += g.length + 1, h[h.length - 1] = new ee(p.text.concat(g.text), p.length + 1 + g.length)) : (a + g.lines > r && f(), a += g.lines, c += g.length + 1, h.push(g));
    }
    function f() {
      a != 0 && (l.push(h.length == 1 ? h[0] : Ne.from(h, c)), c = -1, a = h.length = 0);
    }
    for (let g of e)
      d(g);
    return f(), l.length == 1 ? l[0] : new Ne(l, t);
  }
}
W.empty = /* @__PURE__ */ new ee([""], 0);
function Tf(i) {
  let e = -1;
  for (let t of i)
    e += t.length + 1;
  return e;
}
function Hi(i, e, t = 0, n = 1e9) {
  for (let r = 0, o = 0, s = !0; o < i.length && r <= n; o++) {
    let l = i[o], a = r + l.length;
    a >= t && (a > n && (l = l.slice(0, n - r)), r < t && (l = l.slice(t - r)), s ? (e[e.length - 1] += l, s = !1) : e.push(l)), r = a + 1;
  }
  return e;
}
function $o(i, e, t) {
  return Hi(i, [""], e, t);
}
class ai {
  constructor(e, t = 1) {
    this.dir = t, this.done = !1, this.lineBreak = !1, this.value = "", this.nodes = [e], this.offsets = [t > 0 ? 1 : (e instanceof ee ? e.text.length : e.children.length) << 1];
  }
  nextInner(e, t) {
    for (this.done = this.lineBreak = !1; ; ) {
      let n = this.nodes.length - 1, r = this.nodes[n], o = this.offsets[n], s = o >> 1, l = r instanceof ee ? r.text.length : r.children.length;
      if (s == (t > 0 ? l : 0)) {
        if (n == 0)
          return this.done = !0, this.value = "", this;
        t > 0 && this.offsets[n - 1]++, this.nodes.pop(), this.offsets.pop();
      } else if ((o & 1) == (t > 0 ? 0 : 1)) {
        if (this.offsets[n] += t, e == 0)
          return this.lineBreak = !0, this.value = `
`, this;
        e--;
      } else if (r instanceof ee) {
        let a = r.text[s + (t < 0 ? -1 : 0)];
        if (this.offsets[n] += t, a.length > Math.max(0, e))
          return this.value = e == 0 ? a : t > 0 ? a.slice(e) : a.slice(0, a.length - e), this;
        e -= a.length;
      } else {
        let a = r.children[s + (t < 0 ? -1 : 0)];
        e > a.length ? (e -= a.length, this.offsets[n] += t) : (t < 0 && this.offsets[n]--, this.nodes.push(a), this.offsets.push(t > 0 ? 1 : (a instanceof ee ? a.text.length : a.children.length) << 1));
      }
    }
  }
  next(e = 0) {
    return e < 0 && (this.nextInner(-e, -this.dir), e = this.value.length), this.nextInner(e, this.dir);
  }
}
class Sl {
  constructor(e, t, n) {
    this.value = "", this.done = !1, this.cursor = new ai(e, t > n ? -1 : 1), this.pos = t > n ? e.length : 0, this.from = Math.min(t, n), this.to = Math.max(t, n);
  }
  nextInner(e, t) {
    if (t < 0 ? this.pos <= this.from : this.pos >= this.to)
      return this.value = "", this.done = !0, this;
    e += Math.max(0, t < 0 ? this.pos - this.to : this.from - this.pos);
    let n = t < 0 ? this.pos - this.from : this.to - this.pos;
    e > n && (e = n), n -= e;
    let { value: r } = this.cursor.next(e);
    return this.pos += (r.length + e) * t, this.value = r.length <= n ? r : t < 0 ? r.slice(r.length - n) : r.slice(0, n), this.done = !this.value, this;
  }
  next(e = 0) {
    return e < 0 ? e = Math.max(e, this.from - this.pos) : e > 0 && (e = Math.min(e, this.to - this.pos)), this.nextInner(e, this.cursor.dir);
  }
  get lineBreak() {
    return this.cursor.lineBreak && this.value != "";
  }
}
class Cl {
  constructor(e) {
    this.inner = e, this.afterBreak = !0, this.value = "", this.done = !1;
  }
  next(e = 0) {
    let { done: t, lineBreak: n, value: r } = this.inner.next(e);
    return t && this.afterBreak ? (this.value = "", this.afterBreak = !1) : t ? (this.done = !0, this.value = "") : n ? this.afterBreak ? this.value = "" : (this.afterBreak = !0, this.next()) : (this.value = r, this.afterBreak = !1), this;
  }
  get lineBreak() {
    return !1;
  }
}
typeof Symbol < "u" && (W.prototype[Symbol.iterator] = function() {
  return this.iter();
}, ai.prototype[Symbol.iterator] = Sl.prototype[Symbol.iterator] = Cl.prototype[Symbol.iterator] = function() {
  return this;
});
class Rf {
  /**
  @internal
  */
  constructor(e, t, n, r) {
    this.from = e, this.to = t, this.number = n, this.text = r;
  }
  /**
  The length of the line (not including any line break after it).
  */
  get length() {
    return this.to - this.from;
  }
}
function Ft(i, e, t) {
  return e = Math.max(0, Math.min(i.length, e)), [e, Math.max(e, Math.min(i.length, t))];
}
function Ge(i, e, t = !0, n = !0) {
  return $f(i, e, t, n);
}
const Hn = /\r\n?|\n/;
var Ae = /* @__PURE__ */ function(i) {
  return i[i.Simple = 0] = "Simple", i[i.TrackDel = 1] = "TrackDel", i[i.TrackBefore = 2] = "TrackBefore", i[i.TrackAfter = 3] = "TrackAfter", i;
}(Ae || (Ae = {}));
class Je {
  // Sections are encoded as pairs of integers. The first is the
  // length in the current document, and the second is -1 for
  // unaffected sections, and the length of the replacement content
  // otherwise. So an insertion would be (0, n>0), a deletion (n>0,
  // 0), and a replacement two positive numbers.
  /**
  @internal
  */
  constructor(e) {
    this.sections = e;
  }
  /**
  The length of the document before the change.
  */
  get length() {
    let e = 0;
    for (let t = 0; t < this.sections.length; t += 2)
      e += this.sections[t];
    return e;
  }
  /**
  The length of the document after the change.
  */
  get newLength() {
    let e = 0;
    for (let t = 0; t < this.sections.length; t += 2) {
      let n = this.sections[t + 1];
      e += n < 0 ? this.sections[t] : n;
    }
    return e;
  }
  /**
  False when there are actual changes in this set.
  */
  get empty() {
    return this.sections.length == 0 || this.sections.length == 2 && this.sections[1] < 0;
  }
  /**
  Iterate over the unchanged parts left by these changes. `posA`
  provides the position of the range in the old document, `posB`
  the new position in the changed document.
  */
  iterGaps(e) {
    for (let t = 0, n = 0, r = 0; t < this.sections.length; ) {
      let o = this.sections[t++], s = this.sections[t++];
      s < 0 ? (e(n, r, o), r += o) : r += s, n += o;
    }
  }
  /**
  Iterate over the ranges changed by these changes. (See
  [`ChangeSet.iterChanges`](https://codemirror.net/6/docs/ref/#state.ChangeSet.iterChanges) for a
  variant that also provides you with the inserted text.)
  `fromA`/`toA` provides the extent of the change in the starting
  document, `fromB`/`toB` the extent of the replacement in the
  changed document.
  
  When `individual` is true, adjacent changes (which are kept
  separate for [position mapping](https://codemirror.net/6/docs/ref/#state.ChangeDesc.mapPos)) are
  reported separately.
  */
  iterChangedRanges(e, t = !1) {
    Vn(this, e, t);
  }
  /**
  Get a description of the inverted form of these changes.
  */
  get invertedDesc() {
    let e = [];
    for (let t = 0; t < this.sections.length; ) {
      let n = this.sections[t++], r = this.sections[t++];
      r < 0 ? e.push(n, r) : e.push(r, n);
    }
    return new Je(e);
  }
  /**
  Compute the combined effect of applying another set of changes
  after this one. The length of the document after this set should
  match the length before `other`.
  */
  composeDesc(e) {
    return this.empty ? e : e.empty ? this : kl(this, e);
  }
  /**
  Map this description, which should start with the same document
  as `other`, over another set of changes, so that it can be
  applied after it. When `before` is true, map as if the changes
  in `this` happened before the ones in `other`.
  */
  mapDesc(e, t = !1) {
    return e.empty ? this : jn(this, e, t);
  }
  mapPos(e, t = -1, n = Ae.Simple) {
    let r = 0, o = 0;
    for (let s = 0; s < this.sections.length; ) {
      let l = this.sections[s++], a = this.sections[s++], c = r + l;
      if (a < 0) {
        if (c > e)
          return o + (e - r);
        o += l;
      } else {
        if (n != Ae.Simple && c >= e && (n == Ae.TrackDel && r < e && c > e || n == Ae.TrackBefore && r < e || n == Ae.TrackAfter && c > e))
          return null;
        if (c > e || c == e && t < 0 && !l)
          return e == r || t < 0 ? o : o + a;
        o += a;
      }
      r = c;
    }
    if (e > r)
      throw new RangeError(`Position ${e} is out of range for changeset of length ${r}`);
    return o;
  }
  /**
  Check whether these changes touch a given range. When one of the
  changes entirely covers the range, the string `"cover"` is
  returned.
  */
  touchesRange(e, t = e) {
    for (let n = 0, r = 0; n < this.sections.length && r <= t; ) {
      let o = this.sections[n++], s = this.sections[n++], l = r + o;
      if (s >= 0 && r <= t && l >= e)
        return r < e && l > t ? "cover" : !0;
      r = l;
    }
    return !1;
  }
  /**
  @internal
  */
  toString() {
    let e = "";
    for (let t = 0; t < this.sections.length; ) {
      let n = this.sections[t++], r = this.sections[t++];
      e += (e ? " " : "") + n + (r >= 0 ? ":" + r : "");
    }
    return e;
  }
  /**
  Serialize this change desc to a JSON-representable value.
  */
  toJSON() {
    return this.sections;
  }
  /**
  Create a change desc from its JSON representation (as produced
  by [`toJSON`](https://codemirror.net/6/docs/ref/#state.ChangeDesc.toJSON).
  */
  static fromJSON(e) {
    if (!Array.isArray(e) || e.length % 2 || e.some((t) => typeof t != "number"))
      throw new RangeError("Invalid JSON representation of ChangeDesc");
    return new Je(e);
  }
  /**
  @internal
  */
  static create(e) {
    return new Je(e);
  }
}
class he extends Je {
  constructor(e, t) {
    super(e), this.inserted = t;
  }
  /**
  Apply the changes to a document, returning the modified
  document.
  */
  apply(e) {
    if (this.length != e.length)
      throw new RangeError("Applying change set to a document with the wrong length");
    return Vn(this, (t, n, r, o, s) => e = e.replace(r, r + (n - t), s), !1), e;
  }
  mapDesc(e, t = !1) {
    return jn(this, e, t, !0);
  }
  /**
  Given the document as it existed _before_ the changes, return a
  change set that represents the inverse of this set, which could
  be used to go from the document created by the changes back to
  the document as it existed before the changes.
  */
  invert(e) {
    let t = this.sections.slice(), n = [];
    for (let r = 0, o = 0; r < t.length; r += 2) {
      let s = t[r], l = t[r + 1];
      if (l >= 0) {
        t[r] = l, t[r + 1] = s;
        let a = r >> 1;
        for (; n.length < a; )
          n.push(W.empty);
        n.push(s ? e.slice(o, o + s) : W.empty);
      }
      o += s;
    }
    return new he(t, n);
  }
  /**
  Combine two subsequent change sets into a single set. `other`
  must start in the document produced by `this`. If `this` goes
  `docA` → `docB` and `other` represents `docB` → `docC`, the
  returned value will represent the change `docA` → `docC`.
  */
  compose(e) {
    return this.empty ? e : e.empty ? this : kl(this, e, !0);
  }
  /**
  Given another change set starting in the same document, maps this
  change set over the other, producing a new change set that can be
  applied to the document produced by applying `other`. When
  `before` is `true`, order changes as if `this` comes before
  `other`, otherwise (the default) treat `other` as coming first.
  
  Given two changes `A` and `B`, `A.compose(B.map(A))` and
  `B.compose(A.map(B, true))` will produce the same document. This
  provides a basic form of [operational
  transformation](https://en.wikipedia.org/wiki/Operational_transformation),
  and can be used for collaborative editing.
  */
  map(e, t = !1) {
    return e.empty ? this : jn(this, e, t, !0);
  }
  /**
  Iterate over the changed ranges in the document, calling `f` for
  each, with the range in the original document (`fromA`-`toA`)
  and the range that replaces it in the new document
  (`fromB`-`toB`).
  
  When `individual` is true, adjacent changes are reported
  separately.
  */
  iterChanges(e, t = !1) {
    Vn(this, e, t);
  }
  /**
  Get a [change description](https://codemirror.net/6/docs/ref/#state.ChangeDesc) for this change
  set.
  */
  get desc() {
    return Je.create(this.sections);
  }
  /**
  @internal
  */
  filter(e) {
    let t = [], n = [], r = [], o = new fi(this);
    e: for (let s = 0, l = 0; ; ) {
      let a = s == e.length ? 1e9 : e[s++];
      for (; l < a || l == a && o.len == 0; ) {
        if (o.done)
          break e;
        let h = Math.min(o.len, a - l);
        ge(r, h, -1);
        let d = o.ins == -1 ? -1 : o.off == 0 ? o.ins : 0;
        ge(t, h, d), d > 0 && it(n, t, o.text), o.forward(h), l += h;
      }
      let c = e[s++];
      for (; l < c; ) {
        if (o.done)
          break e;
        let h = Math.min(o.len, c - l);
        ge(t, h, -1), ge(r, h, o.ins == -1 ? -1 : o.off == 0 ? o.ins : 0), o.forward(h), l += h;
      }
    }
    return {
      changes: new he(t, n),
      filtered: Je.create(r)
    };
  }
  /**
  Serialize this change set to a JSON-representable value.
  */
  toJSON() {
    let e = [];
    for (let t = 0; t < this.sections.length; t += 2) {
      let n = this.sections[t], r = this.sections[t + 1];
      r < 0 ? e.push(n) : r == 0 ? e.push([n]) : e.push([n].concat(this.inserted[t >> 1].toJSON()));
    }
    return e;
  }
  /**
  Create a change set for the given changes, for a document of the
  given length, using `lineSep` as line separator.
  */
  static of(e, t, n) {
    let r = [], o = [], s = 0, l = null;
    function a(h = !1) {
      if (!h && !r.length)
        return;
      s < t && ge(r, t - s, -1);
      let d = new he(r, o);
      l = l ? l.compose(d.map(l)) : d, r = [], o = [], s = 0;
    }
    function c(h) {
      if (Array.isArray(h))
        for (let d of h)
          c(d);
      else if (h instanceof he) {
        if (h.length != t)
          throw new RangeError(`Mismatched change set length (got ${h.length}, expected ${t})`);
        a(), l = l ? l.compose(h.map(l)) : h;
      } else {
        let { from: d, to: f = d, insert: g } = h;
        if (d > f || d < 0 || f > t)
          throw new RangeError(`Invalid change range ${d} to ${f} (in doc of length ${t})`);
        let p = g ? typeof g == "string" ? W.of(g.split(n || Hn)) : g : W.empty, b = p.length;
        if (d == f && b == 0)
          return;
        d < s && a(), d > s && ge(r, d - s, -1), ge(r, f - d, b), it(o, r, p), s = f;
      }
    }
    return c(e), a(!l), l;
  }
  /**
  Create an empty changeset of the given length.
  */
  static empty(e) {
    return new he(e ? [e, -1] : [], []);
  }
  /**
  Create a changeset from its JSON representation (as produced by
  [`toJSON`](https://codemirror.net/6/docs/ref/#state.ChangeSet.toJSON).
  */
  static fromJSON(e) {
    if (!Array.isArray(e))
      throw new RangeError("Invalid JSON representation of ChangeSet");
    let t = [], n = [];
    for (let r = 0; r < e.length; r++) {
      let o = e[r];
      if (typeof o == "number")
        t.push(o, -1);
      else {
        if (!Array.isArray(o) || typeof o[0] != "number" || o.some((s, l) => l && typeof s != "string"))
          throw new RangeError("Invalid JSON representation of ChangeSet");
        if (o.length == 1)
          t.push(o[0], 0);
        else {
          for (; n.length < r; )
            n.push(W.empty);
          n[r] = W.of(o.slice(1)), t.push(o[0], n[r].length);
        }
      }
    }
    return new he(t, n);
  }
  /**
  @internal
  */
  static createSet(e, t) {
    return new he(e, t);
  }
}
function ge(i, e, t, n = !1) {
  if (e == 0 && t <= 0)
    return;
  let r = i.length - 2;
  r >= 0 && t <= 0 && t == i[r + 1] ? i[r] += e : r >= 0 && e == 0 && i[r] == 0 ? i[r + 1] += t : n ? (i[r] += e, i[r + 1] += t) : i.push(e, t);
}
function it(i, e, t) {
  if (t.length == 0)
    return;
  let n = e.length - 2 >> 1;
  if (n < i.length)
    i[i.length - 1] = i[i.length - 1].append(t);
  else {
    for (; i.length < n; )
      i.push(W.empty);
    i.push(t);
  }
}
function Vn(i, e, t) {
  let n = i.inserted;
  for (let r = 0, o = 0, s = 0; s < i.sections.length; ) {
    let l = i.sections[s++], a = i.sections[s++];
    if (a < 0)
      r += l, o += l;
    else {
      let c = r, h = o, d = W.empty;
      for (; c += l, h += a, a && n && (d = d.append(n[s - 2 >> 1])), !(t || s == i.sections.length || i.sections[s + 1] < 0); )
        l = i.sections[s++], a = i.sections[s++];
      e(r, c, o, h, d), r = c, o = h;
    }
  }
}
function jn(i, e, t, n = !1) {
  let r = [], o = n ? [] : null, s = new fi(i), l = new fi(e);
  for (let a = -1; ; ) {
    if (s.done && l.len || l.done && s.len)
      throw new Error("Mismatched change set lengths");
    if (s.ins == -1 && l.ins == -1) {
      let c = Math.min(s.len, l.len);
      ge(r, c, -1), s.forward(c), l.forward(c);
    } else if (l.ins >= 0 && (s.ins < 0 || a == s.i || s.off == 0 && (l.len < s.len || l.len == s.len && !t))) {
      let c = l.len;
      for (ge(r, l.ins, -1); c; ) {
        let h = Math.min(s.len, c);
        s.ins >= 0 && a < s.i && s.len <= h && (ge(r, 0, s.ins), o && it(o, r, s.text), a = s.i), s.forward(h), c -= h;
      }
      l.next();
    } else if (s.ins >= 0) {
      let c = 0, h = s.len;
      for (; h; )
        if (l.ins == -1) {
          let d = Math.min(h, l.len);
          c += d, h -= d, l.forward(d);
        } else if (l.ins == 0 && l.len < h)
          h -= l.len, l.next();
        else
          break;
      ge(r, c, a < s.i ? s.ins : 0), o && a < s.i && it(o, r, s.text), a = s.i, s.forward(s.len - h);
    } else {
      if (s.done && l.done)
        return o ? he.createSet(r, o) : Je.create(r);
      throw new Error("Mismatched change set lengths");
    }
  }
}
function kl(i, e, t = !1) {
  let n = [], r = t ? [] : null, o = new fi(i), s = new fi(e);
  for (let l = !1; ; ) {
    if (o.done && s.done)
      return r ? he.createSet(n, r) : Je.create(n);
    if (o.ins == 0)
      ge(n, o.len, 0, l), o.next();
    else if (s.len == 0 && !s.done)
      ge(n, 0, s.ins, l), r && it(r, n, s.text), s.next();
    else {
      if (o.done || s.done)
        throw new Error("Mismatched change set lengths");
      {
        let a = Math.min(o.len2, s.len), c = n.length;
        if (o.ins == -1) {
          let h = s.ins == -1 ? -1 : s.off ? 0 : s.ins;
          ge(n, a, h, l), r && h && it(r, n, s.text);
        } else s.ins == -1 ? (ge(n, o.off ? 0 : o.len, a, l), r && it(r, n, o.textBit(a))) : (ge(n, o.off ? 0 : o.len, s.off ? 0 : s.ins, l), r && !s.off && it(r, n, s.text));
        l = (o.ins > a || s.ins >= 0 && s.len > a) && (l || n.length > c), o.forward2(a), s.forward(a);
      }
    }
  }
}
class fi {
  constructor(e) {
    this.set = e, this.i = 0, this.next();
  }
  next() {
    let { sections: e } = this.set;
    this.i < e.length ? (this.len = e[this.i++], this.ins = e[this.i++]) : (this.len = 0, this.ins = -2), this.off = 0;
  }
  get done() {
    return this.ins == -2;
  }
  get len2() {
    return this.ins < 0 ? this.len : this.ins;
  }
  get text() {
    let { inserted: e } = this.set, t = this.i - 2 >> 1;
    return t >= e.length ? W.empty : e[t];
  }
  textBit(e) {
    let { inserted: t } = this.set, n = this.i - 2 >> 1;
    return n >= t.length && !e ? W.empty : t[n].slice(this.off, e == null ? void 0 : this.off + e);
  }
  forward(e) {
    e == this.len ? this.next() : (this.len -= e, this.off += e);
  }
  forward2(e) {
    this.ins == -1 ? this.forward(e) : e == this.ins ? this.next() : (this.ins -= e, this.off += e);
  }
}
class bt {
  constructor(e, t, n) {
    this.from = e, this.to = t, this.flags = n;
  }
  /**
  The anchor of the range—the side that doesn't move when you
  extend it.
  */
  get anchor() {
    return this.flags & 32 ? this.to : this.from;
  }
  /**
  The head of the range, which is moved when the range is
  [extended](https://codemirror.net/6/docs/ref/#state.SelectionRange.extend).
  */
  get head() {
    return this.flags & 32 ? this.from : this.to;
  }
  /**
  True when `anchor` and `head` are at the same position.
  */
  get empty() {
    return this.from == this.to;
  }
  /**
  If this is a cursor that is explicitly associated with the
  character on one of its sides, this returns the side. -1 means
  the character before its position, 1 the character after, and 0
  means no association.
  */
  get assoc() {
    return this.flags & 8 ? -1 : this.flags & 16 ? 1 : 0;
  }
  /**
  The bidirectional text level associated with this cursor, if
  any.
  */
  get bidiLevel() {
    let e = this.flags & 7;
    return e == 7 ? null : e;
  }
  /**
  The goal column (stored vertical offset) associated with a
  cursor. This is used to preserve the vertical position when
  [moving](https://codemirror.net/6/docs/ref/#view.EditorView.moveVertically) across
  lines of different length.
  */
  get goalColumn() {
    let e = this.flags >> 6;
    return e == 16777215 ? void 0 : e;
  }
  /**
  Map this range through a change, producing a valid range in the
  updated document.
  */
  map(e, t = -1) {
    let n, r;
    return this.empty ? n = r = e.mapPos(this.from, t) : (n = e.mapPos(this.from, 1), r = e.mapPos(this.to, -1)), n == this.from && r == this.to ? this : new bt(n, r, this.flags);
  }
  /**
  Extend this range to cover at least `from` to `to`.
  */
  extend(e, t = e) {
    if (e <= this.anchor && t >= this.anchor)
      return E.range(e, t);
    let n = Math.abs(e - this.anchor) > Math.abs(t - this.anchor) ? e : t;
    return E.range(this.anchor, n);
  }
  /**
  Compare this range to another range.
  */
  eq(e, t = !1) {
    return this.anchor == e.anchor && this.head == e.head && (!t || !this.empty || this.assoc == e.assoc);
  }
  /**
  Return a JSON-serializable object representing the range.
  */
  toJSON() {
    return { anchor: this.anchor, head: this.head };
  }
  /**
  Convert a JSON representation of a range to a `SelectionRange`
  instance.
  */
  static fromJSON(e) {
    if (!e || typeof e.anchor != "number" || typeof e.head != "number")
      throw new RangeError("Invalid JSON representation for SelectionRange");
    return E.range(e.anchor, e.head);
  }
  /**
  @internal
  */
  static create(e, t, n) {
    return new bt(e, t, n);
  }
}
class E {
  constructor(e, t) {
    this.ranges = e, this.mainIndex = t;
  }
  /**
  Map a selection through a change. Used to adjust the selection
  position for changes.
  */
  map(e, t = -1) {
    return e.empty ? this : E.create(this.ranges.map((n) => n.map(e, t)), this.mainIndex);
  }
  /**
  Compare this selection to another selection. By default, ranges
  are compared only by position. When `includeAssoc` is true,
  cursor ranges must also have the same
  [`assoc`](https://codemirror.net/6/docs/ref/#state.SelectionRange.assoc) value.
  */
  eq(e, t = !1) {
    if (this.ranges.length != e.ranges.length || this.mainIndex != e.mainIndex)
      return !1;
    for (let n = 0; n < this.ranges.length; n++)
      if (!this.ranges[n].eq(e.ranges[n], t))
        return !1;
    return !0;
  }
  /**
  Get the primary selection range. Usually, you should make sure
  your code applies to _all_ ranges, by using methods like
  [`changeByRange`](https://codemirror.net/6/docs/ref/#state.EditorState.changeByRange).
  */
  get main() {
    return this.ranges[this.mainIndex];
  }
  /**
  Make sure the selection only has one range. Returns a selection
  holding only the main range from this selection.
  */
  asSingle() {
    return this.ranges.length == 1 ? this : new E([this.main], 0);
  }
  /**
  Extend this selection with an extra range.
  */
  addRange(e, t = !0) {
    return E.create([e].concat(this.ranges), t ? 0 : this.mainIndex + 1);
  }
  /**
  Replace a given range with another range, and then normalize the
  selection to merge and sort ranges if necessary.
  */
  replaceRange(e, t = this.mainIndex) {
    let n = this.ranges.slice();
    return n[t] = e, E.create(n, this.mainIndex);
  }
  /**
  Convert this selection to an object that can be serialized to
  JSON.
  */
  toJSON() {
    return { ranges: this.ranges.map((e) => e.toJSON()), main: this.mainIndex };
  }
  /**
  Create a selection from a JSON representation.
  */
  static fromJSON(e) {
    if (!e || !Array.isArray(e.ranges) || typeof e.main != "number" || e.main >= e.ranges.length)
      throw new RangeError("Invalid JSON representation for EditorSelection");
    return new E(e.ranges.map((t) => bt.fromJSON(t)), e.main);
  }
  /**
  Create a selection holding a single range.
  */
  static single(e, t = e) {
    return new E([E.range(e, t)], 0);
  }
  /**
  Sort and merge the given set of ranges, creating a valid
  selection.
  */
  static create(e, t = 0) {
    if (e.length == 0)
      throw new RangeError("A selection needs at least one range");
    for (let n = 0, r = 0; r < e.length; r++) {
      let o = e[r];
      if (o.empty ? o.from <= n : o.from < n)
        return E.normalized(e.slice(), t);
      n = o.to;
    }
    return new E(e, t);
  }
  /**
  Create a cursor selection range at the given position. You can
  safely ignore the optional arguments in most situations.
  */
  static cursor(e, t = 0, n, r) {
    return bt.create(e, e, (t == 0 ? 0 : t < 0 ? 8 : 16) | (n == null ? 7 : Math.min(6, n)) | (r ?? 16777215) << 6);
  }
  /**
  Create a selection range.
  */
  static range(e, t, n, r) {
    let o = (n ?? 16777215) << 6 | (r == null ? 7 : Math.min(6, r));
    return t < e ? bt.create(t, e, 48 | o) : bt.create(e, t, (t > e ? 8 : 0) | o);
  }
  /**
  @internal
  */
  static normalized(e, t = 0) {
    let n = e[t];
    e.sort((r, o) => r.from - o.from), t = e.indexOf(n);
    for (let r = 1; r < e.length; r++) {
      let o = e[r], s = e[r - 1];
      if (o.empty ? o.from <= s.to : o.from < s.to) {
        let l = s.from, a = Math.max(o.to, s.to);
        r <= t && t--, e.splice(--r, 2, o.anchor > o.head ? E.range(a, l) : E.range(l, a));
      }
    }
    return new E(e, t);
  }
}
function $l(i, e) {
  for (let t of i.ranges)
    if (t.to > e)
      throw new RangeError("Selection points outside of document");
}
let Or = 0;
class P {
  constructor(e, t, n, r, o) {
    this.combine = e, this.compareInput = t, this.compare = n, this.isStatic = r, this.id = Or++, this.default = e([]), this.extensions = typeof o == "function" ? o(this) : o;
  }
  /**
  Returns a facet reader for this facet, which can be used to
  [read](https://codemirror.net/6/docs/ref/#state.EditorState.facet) it but not to define values for it.
  */
  get reader() {
    return this;
  }
  /**
  Define a new facet.
  */
  static define(e = {}) {
    return new P(e.combine || ((t) => t), e.compareInput || ((t, n) => t === n), e.compare || (e.combine ? (t, n) => t === n : Er), !!e.static, e.enables);
  }
  /**
  Returns an extension that adds the given value to this facet.
  */
  of(e) {
    return new Vi([], this, 0, e);
  }
  /**
  Create an extension that computes a value for the facet from a
  state. You must take care to declare the parts of the state that
  this value depends on, since your function is only called again
  for a new state when one of those parts changed.
  
  In cases where your value depends only on a single field, you'll
  want to use the [`from`](https://codemirror.net/6/docs/ref/#state.Facet.from) method instead.
  */
  compute(e, t) {
    if (this.isStatic)
      throw new Error("Can't compute a static facet");
    return new Vi(e, this, 1, t);
  }
  /**
  Create an extension that computes zero or more values for this
  facet from a state.
  */
  computeN(e, t) {
    if (this.isStatic)
      throw new Error("Can't compute a static facet");
    return new Vi(e, this, 2, t);
  }
  from(e, t) {
    return t || (t = (n) => n), this.compute([e], (n) => t(n.field(e)));
  }
}
function Er(i, e) {
  return i == e || i.length == e.length && i.every((t, n) => t === e[n]);
}
class Vi {
  constructor(e, t, n, r) {
    this.dependencies = e, this.facet = t, this.type = n, this.value = r, this.id = Or++;
  }
  dynamicSlot(e) {
    var t;
    let n = this.value, r = this.facet.compareInput, o = this.id, s = e[o] >> 1, l = this.type == 2, a = !1, c = !1, h = [];
    for (let d of this.dependencies)
      d == "doc" ? a = !0 : d == "selection" ? c = !0 : ((t = e[d.id]) !== null && t !== void 0 ? t : 1) & 1 || h.push(e[d.id]);
    return {
      create(d) {
        return d.values[s] = n(d), 1;
      },
      update(d, f) {
        if (a && f.docChanged || c && (f.docChanged || f.selection) || qn(d, h)) {
          let g = n(d);
          if (l ? !Ao(g, d.values[s], r) : !r(g, d.values[s]))
            return d.values[s] = g, 1;
        }
        return 0;
      },
      reconfigure: (d, f) => {
        let g, p = f.config.address[o];
        if (p != null) {
          let b = Yi(f, p);
          if (this.dependencies.every((w) => w instanceof P ? f.facet(w) === d.facet(w) : w instanceof At ? f.field(w, !1) == d.field(w, !1) : !0) || (l ? Ao(g = n(d), b, r) : r(g = n(d), b)))
            return d.values[s] = b, 0;
        } else
          g = n(d);
        return d.values[s] = g, 1;
      }
    };
  }
}
function Ao(i, e, t) {
  if (i.length != e.length)
    return !1;
  for (let n = 0; n < i.length; n++)
    if (!t(i[n], e[n]))
      return !1;
  return !0;
}
function qn(i, e) {
  let t = !1;
  for (let n of e)
    hi(i, n) & 1 && (t = !0);
  return t;
}
function Mf(i, e, t) {
  let n = t.map((a) => i[a.id]), r = t.map((a) => a.type), o = n.filter((a) => !(a & 1)), s = i[e.id] >> 1;
  function l(a) {
    let c = [];
    for (let h = 0; h < n.length; h++) {
      let d = Yi(a, n[h]);
      if (r[h] == 2)
        for (let f of d)
          c.push(f);
      else
        c.push(d);
    }
    return e.combine(c);
  }
  return {
    create(a) {
      for (let c of n)
        hi(a, c);
      return a.values[s] = l(a), 1;
    },
    update(a, c) {
      if (!qn(a, o))
        return 0;
      let h = l(a);
      return e.compare(h, a.values[s]) ? 0 : (a.values[s] = h, 1);
    },
    reconfigure(a, c) {
      let h = qn(a, n), d = c.config.facets[e.id], f = c.facet(e);
      if (d && !h && Er(t, d))
        return a.values[s] = f, 0;
      let g = l(a);
      return e.compare(g, f) ? (a.values[s] = f, 0) : (a.values[s] = g, 1);
    }
  };
}
const Mi = /* @__PURE__ */ P.define({ static: !0 });
class At {
  constructor(e, t, n, r, o) {
    this.id = e, this.createF = t, this.updateF = n, this.compareF = r, this.spec = o, this.provides = void 0;
  }
  /**
  Define a state field.
  */
  static define(e) {
    let t = new At(Or++, e.create, e.update, e.compare || ((n, r) => n === r), e);
    return e.provide && (t.provides = e.provide(t)), t;
  }
  create(e) {
    let t = e.facet(Mi).find((n) => n.field == this);
    return ((t == null ? void 0 : t.create) || this.createF)(e);
  }
  /**
  @internal
  */
  slot(e) {
    let t = e[this.id] >> 1;
    return {
      create: (n) => (n.values[t] = this.create(n), 1),
      update: (n, r) => {
        let o = n.values[t], s = this.updateF(o, r);
        return this.compareF(o, s) ? 0 : (n.values[t] = s, 1);
      },
      reconfigure: (n, r) => {
        let o = n.facet(Mi), s = r.facet(Mi), l;
        return (l = o.find((a) => a.field == this)) && l != s.find((a) => a.field == this) ? (n.values[t] = l.create(n), 1) : r.config.address[this.id] != null ? (n.values[t] = r.field(this), 0) : (n.values[t] = this.create(n), 1);
      }
    };
  }
  /**
  Returns an extension that enables this field and overrides the
  way it is initialized. Can be useful when you need to provide a
  non-default starting value for the field.
  */
  init(e) {
    return [this, Mi.of({ field: this, create: e })];
  }
  /**
  State field instances can be used as
  [`Extension`](https://codemirror.net/6/docs/ref/#state.Extension) values to enable the field in a
  given state.
  */
  get extension() {
    return this;
  }
}
const pt = { lowest: 4, low: 3, default: 2, high: 1, highest: 0 };
function ti(i) {
  return (e) => new Al(e, i);
}
const Df = {
  /**
  The highest precedence level, for extensions that should end up
  near the start of the precedence ordering.
  */
  highest: /* @__PURE__ */ ti(pt.highest),
  /**
  A higher-than-default precedence, for extensions that should
  come before those with default precedence.
  */
  high: /* @__PURE__ */ ti(pt.high),
  /**
  The default precedence, which is also used for extensions
  without an explicit precedence.
  */
  default: /* @__PURE__ */ ti(pt.default),
  /**
  A lower-than-default precedence.
  */
  low: /* @__PURE__ */ ti(pt.low),
  /**
  The lowest precedence level. Meant for things that should end up
  near the end of the extension order.
  */
  lowest: /* @__PURE__ */ ti(pt.lowest)
};
class Al {
  constructor(e, t) {
    this.inner = e, this.prec = t;
  }
}
class dn {
  /**
  Create an instance of this compartment to add to your [state
  configuration](https://codemirror.net/6/docs/ref/#state.EditorStateConfig.extensions).
  */
  of(e) {
    return new Kn(this, e);
  }
  /**
  Create an [effect](https://codemirror.net/6/docs/ref/#state.TransactionSpec.effects) that
  reconfigures this compartment.
  */
  reconfigure(e) {
    return dn.reconfigure.of({ compartment: this, extension: e });
  }
  /**
  Get the current content of the compartment in the state, or
  `undefined` if it isn't present.
  */
  get(e) {
    return e.config.compartments.get(this);
  }
}
class Kn {
  constructor(e, t) {
    this.compartment = e, this.inner = t;
  }
}
class Gi {
  constructor(e, t, n, r, o, s) {
    for (this.base = e, this.compartments = t, this.dynamicSlots = n, this.address = r, this.staticValues = o, this.facets = s, this.statusTemplate = []; this.statusTemplate.length < n.length; )
      this.statusTemplate.push(
        0
        /* SlotStatus.Unresolved */
      );
  }
  staticFacet(e) {
    let t = this.address[e.id];
    return t == null ? e.default : this.staticValues[t >> 1];
  }
  static resolve(e, t, n) {
    let r = [], o = /* @__PURE__ */ Object.create(null), s = /* @__PURE__ */ new Map();
    for (let f of Of(e, t, s))
      f instanceof At ? r.push(f) : (o[f.facet.id] || (o[f.facet.id] = [])).push(f);
    let l = /* @__PURE__ */ Object.create(null), a = [], c = [];
    for (let f of r)
      l[f.id] = c.length << 1, c.push((g) => f.slot(g));
    let h = n == null ? void 0 : n.config.facets;
    for (let f in o) {
      let g = o[f], p = g[0].facet, b = h && h[f] || [];
      if (g.every(
        (w) => w.type == 0
        /* Provider.Static */
      ))
        if (l[p.id] = a.length << 1 | 1, Er(b, g))
          a.push(n.facet(p));
        else {
          let w = p.combine(g.map((y) => y.value));
          a.push(n && p.compare(w, n.facet(p)) ? n.facet(p) : w);
        }
      else {
        for (let w of g)
          w.type == 0 ? (l[w.id] = a.length << 1 | 1, a.push(w.value)) : (l[w.id] = c.length << 1, c.push((y) => w.dynamicSlot(y)));
        l[p.id] = c.length << 1, c.push((w) => Mf(w, p, g));
      }
    }
    let d = c.map((f) => f(l));
    return new Gi(e, s, d, l, a, o);
  }
}
function Of(i, e, t) {
  let n = [[], [], [], [], []], r = /* @__PURE__ */ new Map();
  function o(s, l) {
    let a = r.get(s);
    if (a != null) {
      if (a <= l)
        return;
      let c = n[a].indexOf(s);
      c > -1 && n[a].splice(c, 1), s instanceof Kn && t.delete(s.compartment);
    }
    if (r.set(s, l), Array.isArray(s))
      for (let c of s)
        o(c, l);
    else if (s instanceof Kn) {
      if (t.has(s.compartment))
        throw new RangeError("Duplicate use of compartment in extensions");
      let c = e.get(s.compartment) || s.inner;
      t.set(s.compartment, c), o(c, l);
    } else if (s instanceof Al)
      o(s.inner, s.prec);
    else if (s instanceof At)
      n[l].push(s), s.provides && o(s.provides, l);
    else if (s instanceof Vi)
      n[l].push(s), s.facet.extensions && o(s.facet.extensions, pt.default);
    else {
      let c = s.extension;
      if (!c)
        throw new Error(`Unrecognized extension value in extension set (${s}). This sometimes happens because multiple instances of @codemirror/state are loaded, breaking instanceof checks.`);
      o(c, l);
    }
  }
  return o(i, pt.default), n.reduce((s, l) => s.concat(l));
}
function hi(i, e) {
  if (e & 1)
    return 2;
  let t = e >> 1, n = i.status[t];
  if (n == 4)
    throw new Error("Cyclic dependency between fields and/or facets");
  if (n & 2)
    return n;
  i.status[t] = 4;
  let r = i.computeSlot(i, i.config.dynamicSlots[t]);
  return i.status[t] = 2 | r;
}
function Yi(i, e) {
  return e & 1 ? i.config.staticValues[e >> 1] : i.values[e >> 1];
}
const Tl = /* @__PURE__ */ P.define(), Un = /* @__PURE__ */ P.define({
  combine: (i) => i.some((e) => e),
  static: !0
}), Rl = /* @__PURE__ */ P.define({
  combine: (i) => i.length ? i[0] : void 0,
  static: !0
}), Ml = /* @__PURE__ */ P.define(), Dl = /* @__PURE__ */ P.define(), Ol = /* @__PURE__ */ P.define(), El = /* @__PURE__ */ P.define({
  combine: (i) => i.length ? i[0] : !1
});
class Xt {
  /**
  @internal
  */
  constructor(e, t) {
    this.type = e, this.value = t;
  }
  /**
  Define a new type of annotation.
  */
  static define() {
    return new Ef();
  }
}
class Ef {
  /**
  Create an instance of this annotation.
  */
  of(e) {
    return new Xt(this, e);
  }
}
class If {
  /**
  @internal
  */
  constructor(e) {
    this.map = e;
  }
  /**
  Create a [state effect](https://codemirror.net/6/docs/ref/#state.StateEffect) instance of this
  type.
  */
  of(e) {
    return new ne(this, e);
  }
}
class ne {
  /**
  @internal
  */
  constructor(e, t) {
    this.type = e, this.value = t;
  }
  /**
  Map this effect through a position mapping. Will return
  `undefined` when that ends up deleting the effect.
  */
  map(e) {
    let t = this.type.map(this.value, e);
    return t === void 0 ? void 0 : t == this.value ? this : new ne(this.type, t);
  }
  /**
  Tells you whether this effect object is of a given
  [type](https://codemirror.net/6/docs/ref/#state.StateEffectType).
  */
  is(e) {
    return this.type == e;
  }
  /**
  Define a new effect type. The type parameter indicates the type
  of values that his effect holds. It should be a type that
  doesn't include `undefined`, since that is used in
  [mapping](https://codemirror.net/6/docs/ref/#state.StateEffect.map) to indicate that an effect is
  removed.
  */
  static define(e = {}) {
    return new If(e.map || ((t) => t));
  }
  /**
  Map an array of effects through a change set.
  */
  static mapEffects(e, t) {
    if (!e.length)
      return e;
    let n = [];
    for (let r of e) {
      let o = r.map(t);
      o && n.push(o);
    }
    return n;
  }
}
ne.reconfigure = /* @__PURE__ */ ne.define();
ne.appendConfig = /* @__PURE__ */ ne.define();
class me {
  constructor(e, t, n, r, o, s) {
    this.startState = e, this.changes = t, this.selection = n, this.effects = r, this.annotations = o, this.scrollIntoView = s, this._doc = null, this._state = null, n && $l(n, t.newLength), o.some((l) => l.type == me.time) || (this.annotations = o.concat(me.time.of(Date.now())));
  }
  /**
  @internal
  */
  static create(e, t, n, r, o, s) {
    return new me(e, t, n, r, o, s);
  }
  /**
  The new document produced by the transaction. Contrary to
  [`.state`](https://codemirror.net/6/docs/ref/#state.Transaction.state)`.doc`, accessing this won't
  force the entire new state to be computed right away, so it is
  recommended that [transaction
  filters](https://codemirror.net/6/docs/ref/#state.EditorState^transactionFilter) use this getter
  when they need to look at the new document.
  */
  get newDoc() {
    return this._doc || (this._doc = this.changes.apply(this.startState.doc));
  }
  /**
  The new selection produced by the transaction. If
  [`this.selection`](https://codemirror.net/6/docs/ref/#state.Transaction.selection) is undefined,
  this will [map](https://codemirror.net/6/docs/ref/#state.EditorSelection.map) the start state's
  current selection through the changes made by the transaction.
  */
  get newSelection() {
    return this.selection || this.startState.selection.map(this.changes);
  }
  /**
  The new state created by the transaction. Computed on demand
  (but retained for subsequent access), so it is recommended not to
  access it in [transaction
  filters](https://codemirror.net/6/docs/ref/#state.EditorState^transactionFilter) when possible.
  */
  get state() {
    return this._state || this.startState.applyTransaction(this), this._state;
  }
  /**
  Get the value of the given annotation type, if any.
  */
  annotation(e) {
    for (let t of this.annotations)
      if (t.type == e)
        return t.value;
  }
  /**
  Indicates whether the transaction changed the document.
  */
  get docChanged() {
    return !this.changes.empty;
  }
  /**
  Indicates whether this transaction reconfigures the state
  (through a [configuration compartment](https://codemirror.net/6/docs/ref/#state.Compartment) or
  with a top-level configuration
  [effect](https://codemirror.net/6/docs/ref/#state.StateEffect^reconfigure).
  */
  get reconfigured() {
    return this.startState.config != this.state.config;
  }
  /**
  Returns true if the transaction has a [user
  event](https://codemirror.net/6/docs/ref/#state.Transaction^userEvent) annotation that is equal to
  or more specific than `event`. For example, if the transaction
  has `"select.pointer"` as user event, `"select"` and
  `"select.pointer"` will match it.
  */
  isUserEvent(e) {
    let t = this.annotation(me.userEvent);
    return !!(t && (t == e || t.length > e.length && t.slice(0, e.length) == e && t[e.length] == "."));
  }
}
me.time = /* @__PURE__ */ Xt.define();
me.userEvent = /* @__PURE__ */ Xt.define();
me.addToHistory = /* @__PURE__ */ Xt.define();
me.remote = /* @__PURE__ */ Xt.define();
function Pf(i, e) {
  let t = [];
  for (let n = 0, r = 0; ; ) {
    let o, s;
    if (n < i.length && (r == e.length || e[r] >= i[n]))
      o = i[n++], s = i[n++];
    else if (r < e.length)
      o = e[r++], s = e[r++];
    else
      return t;
    !t.length || t[t.length - 1] < o ? t.push(o, s) : t[t.length - 1] < s && (t[t.length - 1] = s);
  }
}
function Il(i, e, t) {
  var n;
  let r, o, s;
  return t ? (r = e.changes, o = he.empty(e.changes.length), s = i.changes.compose(e.changes)) : (r = e.changes.map(i.changes), o = i.changes.mapDesc(e.changes, !0), s = i.changes.compose(r)), {
    changes: s,
    selection: e.selection ? e.selection.map(o) : (n = i.selection) === null || n === void 0 ? void 0 : n.map(r),
    effects: ne.mapEffects(i.effects, r).concat(ne.mapEffects(e.effects, o)),
    annotations: i.annotations.length ? i.annotations.concat(e.annotations) : e.annotations,
    scrollIntoView: i.scrollIntoView || e.scrollIntoView
  };
}
function _n(i, e, t) {
  let n = e.selection, r = It(e.annotations);
  return e.userEvent && (r = r.concat(me.userEvent.of(e.userEvent))), {
    changes: e.changes instanceof he ? e.changes : he.of(e.changes || [], t, i.facet(Rl)),
    selection: n && (n instanceof E ? n : E.single(n.anchor, n.head)),
    effects: It(e.effects),
    annotations: r,
    scrollIntoView: !!e.scrollIntoView
  };
}
function Pl(i, e, t) {
  let n = _n(i, e.length ? e[0] : {}, i.doc.length);
  e.length && e[0].filter === !1 && (t = !1);
  for (let o = 1; o < e.length; o++) {
    e[o].filter === !1 && (t = !1);
    let s = !!e[o].sequential;
    n = Il(n, _n(i, e[o], s ? n.changes.newLength : i.doc.length), s);
  }
  let r = me.create(i, n.changes, n.selection, n.effects, n.annotations, n.scrollIntoView);
  return Bf(t ? Lf(r) : r);
}
function Lf(i) {
  let e = i.startState, t = !0;
  for (let r of e.facet(Ml)) {
    let o = r(i);
    if (o === !1) {
      t = !1;
      break;
    }
    Array.isArray(o) && (t = t === !0 ? o : Pf(t, o));
  }
  if (t !== !0) {
    let r, o;
    if (t === !1)
      o = i.changes.invertedDesc, r = he.empty(e.doc.length);
    else {
      let s = i.changes.filter(t);
      r = s.changes, o = s.filtered.mapDesc(s.changes).invertedDesc;
    }
    i = me.create(e, r, i.selection && i.selection.map(o), ne.mapEffects(i.effects, o), i.annotations, i.scrollIntoView);
  }
  let n = e.facet(Dl);
  for (let r = n.length - 1; r >= 0; r--) {
    let o = n[r](i);
    o instanceof me ? i = o : Array.isArray(o) && o.length == 1 && o[0] instanceof me ? i = o[0] : i = Pl(e, It(o), !1);
  }
  return i;
}
function Bf(i) {
  let e = i.startState, t = e.facet(Ol), n = i;
  for (let r = t.length - 1; r >= 0; r--) {
    let o = t[r](i);
    o && Object.keys(o).length && (n = Il(n, _n(e, o, i.changes.newLength), !0));
  }
  return n == i ? i : me.create(e, i.changes, i.selection, n.effects, n.annotations, n.scrollIntoView);
}
const zf = [];
function It(i) {
  return i == null ? zf : Array.isArray(i) ? i : [i];
}
var Ye = /* @__PURE__ */ function(i) {
  return i[i.Word = 0] = "Word", i[i.Space = 1] = "Space", i[i.Other = 2] = "Other", i;
}(Ye || (Ye = {}));
const Nf = /[\u00df\u0587\u0590-\u05f4\u0600-\u06ff\u3040-\u309f\u30a0-\u30ff\u3400-\u4db5\u4e00-\u9fcc\uac00-\ud7af]/;
let Gn;
try {
  Gn = /* @__PURE__ */ new RegExp("[\\p{Alphabetic}\\p{Number}_]", "u");
} catch {
}
function Ff(i) {
  if (Gn)
    return Gn.test(i);
  for (let e = 0; e < i.length; e++) {
    let t = i[e];
    if (/\w/.test(t) || t > "" && (t.toUpperCase() != t.toLowerCase() || Nf.test(t)))
      return !0;
  }
  return !1;
}
function Wf(i) {
  return (e) => {
    if (!/\S/.test(e))
      return Ye.Space;
    if (Ff(e))
      return Ye.Word;
    for (let t = 0; t < i.length; t++)
      if (e.indexOf(i[t]) > -1)
        return Ye.Word;
    return Ye.Other;
  };
}
class G {
  constructor(e, t, n, r, o, s) {
    this.config = e, this.doc = t, this.selection = n, this.values = r, this.status = e.statusTemplate.slice(), this.computeSlot = o, s && (s._state = this);
    for (let l = 0; l < this.config.dynamicSlots.length; l++)
      hi(this, l << 1);
    this.computeSlot = null;
  }
  field(e, t = !0) {
    let n = this.config.address[e.id];
    if (n == null) {
      if (t)
        throw new RangeError("Field is not present in this state");
      return;
    }
    return hi(this, n), Yi(this, n);
  }
  /**
  Create a [transaction](https://codemirror.net/6/docs/ref/#state.Transaction) that updates this
  state. Any number of [transaction specs](https://codemirror.net/6/docs/ref/#state.TransactionSpec)
  can be passed. Unless
  [`sequential`](https://codemirror.net/6/docs/ref/#state.TransactionSpec.sequential) is set, the
  [changes](https://codemirror.net/6/docs/ref/#state.TransactionSpec.changes) (if any) of each spec
  are assumed to start in the _current_ document (not the document
  produced by previous specs), and its
  [selection](https://codemirror.net/6/docs/ref/#state.TransactionSpec.selection) and
  [effects](https://codemirror.net/6/docs/ref/#state.TransactionSpec.effects) are assumed to refer
  to the document created by its _own_ changes. The resulting
  transaction contains the combined effect of all the different
  specs. For [selection](https://codemirror.net/6/docs/ref/#state.TransactionSpec.selection), later
  specs take precedence over earlier ones.
  */
  update(...e) {
    return Pl(this, e, !0);
  }
  /**
  @internal
  */
  applyTransaction(e) {
    let t = this.config, { base: n, compartments: r } = t;
    for (let l of e.effects)
      l.is(dn.reconfigure) ? (t && (r = /* @__PURE__ */ new Map(), t.compartments.forEach((a, c) => r.set(c, a)), t = null), r.set(l.value.compartment, l.value.extension)) : l.is(ne.reconfigure) ? (t = null, n = l.value) : l.is(ne.appendConfig) && (t = null, n = It(n).concat(l.value));
    let o;
    t ? o = e.startState.values.slice() : (t = Gi.resolve(n, r, this), o = new G(t, this.doc, this.selection, t.dynamicSlots.map(() => null), (a, c) => c.reconfigure(a, this), null).values);
    let s = e.startState.facet(Un) ? e.newSelection : e.newSelection.asSingle();
    new G(t, e.newDoc, s, o, (l, a) => a.update(l, e), e);
  }
  /**
  Create a [transaction spec](https://codemirror.net/6/docs/ref/#state.TransactionSpec) that
  replaces every selection range with the given content.
  */
  replaceSelection(e) {
    return typeof e == "string" && (e = this.toText(e)), this.changeByRange((t) => ({
      changes: { from: t.from, to: t.to, insert: e },
      range: E.cursor(t.from + e.length)
    }));
  }
  /**
  Create a set of changes and a new selection by running the given
  function for each range in the active selection. The function
  can return an optional set of changes (in the coordinate space
  of the start document), plus an updated range (in the coordinate
  space of the document produced by the call's own changes). This
  method will merge all the changes and ranges into a single
  changeset and selection, and return it as a [transaction
  spec](https://codemirror.net/6/docs/ref/#state.TransactionSpec), which can be passed to
  [`update`](https://codemirror.net/6/docs/ref/#state.EditorState.update).
  */
  changeByRange(e) {
    let t = this.selection, n = e(t.ranges[0]), r = this.changes(n.changes), o = [n.range], s = It(n.effects);
    for (let l = 1; l < t.ranges.length; l++) {
      let a = e(t.ranges[l]), c = this.changes(a.changes), h = c.map(r);
      for (let f = 0; f < l; f++)
        o[f] = o[f].map(h);
      let d = r.mapDesc(c, !0);
      o.push(a.range.map(d)), r = r.compose(h), s = ne.mapEffects(s, h).concat(ne.mapEffects(It(a.effects), d));
    }
    return {
      changes: r,
      selection: E.create(o, t.mainIndex),
      effects: s
    };
  }
  /**
  Create a [change set](https://codemirror.net/6/docs/ref/#state.ChangeSet) from the given change
  description, taking the state's document length and line
  separator into account.
  */
  changes(e = []) {
    return e instanceof he ? e : he.of(e, this.doc.length, this.facet(G.lineSeparator));
  }
  /**
  Using the state's [line
  separator](https://codemirror.net/6/docs/ref/#state.EditorState^lineSeparator), create a
  [`Text`](https://codemirror.net/6/docs/ref/#state.Text) instance from the given string.
  */
  toText(e) {
    return W.of(e.split(this.facet(G.lineSeparator) || Hn));
  }
  /**
  Return the given range of the document as a string.
  */
  sliceDoc(e = 0, t = this.doc.length) {
    return this.doc.sliceString(e, t, this.lineBreak);
  }
  /**
  Get the value of a state [facet](https://codemirror.net/6/docs/ref/#state.Facet).
  */
  facet(e) {
    let t = this.config.address[e.id];
    return t == null ? e.default : (hi(this, t), Yi(this, t));
  }
  /**
  Convert this state to a JSON-serializable object. When custom
  fields should be serialized, you can pass them in as an object
  mapping property names (in the resulting object, which should
  not use `doc` or `selection`) to fields.
  */
  toJSON(e) {
    let t = {
      doc: this.sliceDoc(),
      selection: this.selection.toJSON()
    };
    if (e)
      for (let n in e) {
        let r = e[n];
        r instanceof At && this.config.address[r.id] != null && (t[n] = r.spec.toJSON(this.field(e[n]), this));
      }
    return t;
  }
  /**
  Deserialize a state from its JSON representation. When custom
  fields should be deserialized, pass the same object you passed
  to [`toJSON`](https://codemirror.net/6/docs/ref/#state.EditorState.toJSON) when serializing as
  third argument.
  */
  static fromJSON(e, t = {}, n) {
    if (!e || typeof e.doc != "string")
      throw new RangeError("Invalid JSON representation for EditorState");
    let r = [];
    if (n) {
      for (let o in n)
        if (Object.prototype.hasOwnProperty.call(e, o)) {
          let s = n[o], l = e[o];
          r.push(s.init((a) => s.spec.fromJSON(l, a)));
        }
    }
    return G.create({
      doc: e.doc,
      selection: E.fromJSON(e.selection),
      extensions: t.extensions ? r.concat([t.extensions]) : r
    });
  }
  /**
  Create a new state. You'll usually only need this when
  initializing an editor—updated states are created by applying
  transactions.
  */
  static create(e = {}) {
    let t = Gi.resolve(e.extensions || [], /* @__PURE__ */ new Map()), n = e.doc instanceof W ? e.doc : W.of((e.doc || "").split(t.staticFacet(G.lineSeparator) || Hn)), r = e.selection ? e.selection instanceof E ? e.selection : E.single(e.selection.anchor, e.selection.head) : E.single(0);
    return $l(r, n.length), t.staticFacet(Un) || (r = r.asSingle()), new G(t, n, r, t.dynamicSlots.map(() => null), (o, s) => s.create(o), null);
  }
  /**
  The size (in columns) of a tab in the document, determined by
  the [`tabSize`](https://codemirror.net/6/docs/ref/#state.EditorState^tabSize) facet.
  */
  get tabSize() {
    return this.facet(G.tabSize);
  }
  /**
  Get the proper [line-break](https://codemirror.net/6/docs/ref/#state.EditorState^lineSeparator)
  string for this state.
  */
  get lineBreak() {
    return this.facet(G.lineSeparator) || `
`;
  }
  /**
  Returns true when the editor is
  [configured](https://codemirror.net/6/docs/ref/#state.EditorState^readOnly) to be read-only.
  */
  get readOnly() {
    return this.facet(El);
  }
  /**
  Look up a translation for the given phrase (via the
  [`phrases`](https://codemirror.net/6/docs/ref/#state.EditorState^phrases) facet), or return the
  original string if no translation is found.
  
  If additional arguments are passed, they will be inserted in
  place of markers like `$1` (for the first value) and `$2`, etc.
  A single `$` is equivalent to `$1`, and `$$` will produce a
  literal dollar sign.
  */
  phrase(e, ...t) {
    for (let n of this.facet(G.phrases))
      if (Object.prototype.hasOwnProperty.call(n, e)) {
        e = n[e];
        break;
      }
    return t.length && (e = e.replace(/\$(\$|\d*)/g, (n, r) => {
      if (r == "$")
        return "$";
      let o = +(r || 1);
      return !o || o > t.length ? n : t[o - 1];
    })), e;
  }
  /**
  Find the values for a given language data field, provided by the
  the [`languageData`](https://codemirror.net/6/docs/ref/#state.EditorState^languageData) facet.
  
  Examples of language data fields are...
  
  - [`"commentTokens"`](https://codemirror.net/6/docs/ref/#commands.CommentTokens) for specifying
    comment syntax.
  - [`"autocomplete"`](https://codemirror.net/6/docs/ref/#autocomplete.autocompletion^config.override)
    for providing language-specific completion sources.
  - [`"wordChars"`](https://codemirror.net/6/docs/ref/#state.EditorState.charCategorizer) for adding
    characters that should be considered part of words in this
    language.
  - [`"closeBrackets"`](https://codemirror.net/6/docs/ref/#autocomplete.CloseBracketConfig) controls
    bracket closing behavior.
  */
  languageDataAt(e, t, n = -1) {
    let r = [];
    for (let o of this.facet(Tl))
      for (let s of o(this, t, n))
        Object.prototype.hasOwnProperty.call(s, e) && r.push(s[e]);
    return r;
  }
  /**
  Return a function that can categorize strings (expected to
  represent a single [grapheme cluster](https://codemirror.net/6/docs/ref/#state.findClusterBreak))
  into one of:
  
   - Word (contains an alphanumeric character or a character
     explicitly listed in the local language's `"wordChars"`
     language data, which should be a string)
   - Space (contains only whitespace)
   - Other (anything else)
  */
  charCategorizer(e) {
    return Wf(this.languageDataAt("wordChars", e).join(""));
  }
  /**
  Find the word at the given position, meaning the range
  containing all [word](https://codemirror.net/6/docs/ref/#state.CharCategory.Word) characters
  around it. If no word characters are adjacent to the position,
  this returns null.
  */
  wordAt(e) {
    let { text: t, from: n, length: r } = this.doc.lineAt(e), o = this.charCategorizer(e), s = e - n, l = e - n;
    for (; s > 0; ) {
      let a = Ge(t, s, !1);
      if (o(t.slice(a, s)) != Ye.Word)
        break;
      s = a;
    }
    for (; l < r; ) {
      let a = Ge(t, l);
      if (o(t.slice(l, a)) != Ye.Word)
        break;
      l = a;
    }
    return s == l ? null : E.range(s + n, l + n);
  }
}
G.allowMultipleSelections = Un;
G.tabSize = /* @__PURE__ */ P.define({
  combine: (i) => i.length ? i[0] : 4
});
G.lineSeparator = Rl;
G.readOnly = El;
G.phrases = /* @__PURE__ */ P.define({
  compare(i, e) {
    let t = Object.keys(i), n = Object.keys(e);
    return t.length == n.length && t.every((r) => i[r] == e[r]);
  }
});
G.languageData = Tl;
G.changeFilter = Ml;
G.transactionFilter = Dl;
G.transactionExtender = Ol;
dn.reconfigure = /* @__PURE__ */ ne.define();
class Wt {
  /**
  Compare this value with another value. Used when comparing
  rangesets. The default implementation compares by identity.
  Unless you are only creating a fixed number of unique instances
  of your value type, it is a good idea to implement this
  properly.
  */
  eq(e) {
    return this == e;
  }
  /**
  Create a [range](https://codemirror.net/6/docs/ref/#state.Range) with this value.
  */
  range(e, t = e) {
    return gi.create(e, t, this);
  }
}
Wt.prototype.startSide = Wt.prototype.endSide = 0;
Wt.prototype.point = !1;
Wt.prototype.mapMode = Ae.TrackDel;
class gi {
  constructor(e, t, n) {
    this.from = e, this.to = t, this.value = n;
  }
  /**
  @internal
  */
  static create(e, t, n) {
    return new gi(e, t, n);
  }
}
function Yn(i, e) {
  return i.from - e.from || i.value.startSide - e.value.startSide;
}
class Ir {
  constructor(e, t, n, r) {
    this.from = e, this.to = t, this.value = n, this.maxPoint = r;
  }
  get length() {
    return this.to[this.to.length - 1];
  }
  // Find the index of the given position and side. Use the ranges'
  // `from` pos when `end == false`, `to` when `end == true`.
  findIndex(e, t, n, r = 0) {
    let o = n ? this.to : this.from;
    for (let s = r, l = o.length; ; ) {
      if (s == l)
        return s;
      let a = s + l >> 1, c = o[a] - e || (n ? this.value[a].endSide : this.value[a].startSide) - t;
      if (a == s)
        return c >= 0 ? s : l;
      c >= 0 ? l = a : s = a + 1;
    }
  }
  between(e, t, n, r) {
    for (let o = this.findIndex(t, -1e9, !0), s = this.findIndex(n, 1e9, !1, o); o < s; o++)
      if (r(this.from[o] + e, this.to[o] + e, this.value[o]) === !1)
        return !1;
  }
  map(e, t) {
    let n = [], r = [], o = [], s = -1, l = -1;
    for (let a = 0; a < this.value.length; a++) {
      let c = this.value[a], h = this.from[a] + e, d = this.to[a] + e, f, g;
      if (h == d) {
        let p = t.mapPos(h, c.startSide, c.mapMode);
        if (p == null || (f = g = p, c.startSide != c.endSide && (g = t.mapPos(h, c.endSide), g < f)))
          continue;
      } else if (f = t.mapPos(h, c.startSide), g = t.mapPos(d, c.endSide), f > g || f == g && c.startSide > 0 && c.endSide <= 0)
        continue;
      (g - f || c.endSide - c.startSide) < 0 || (s < 0 && (s = f), c.point && (l = Math.max(l, g - f)), n.push(c), r.push(f - s), o.push(g - s));
    }
    return { mapped: n.length ? new Ir(r, o, n, l) : null, pos: s };
  }
}
class X {
  constructor(e, t, n, r) {
    this.chunkPos = e, this.chunk = t, this.nextLayer = n, this.maxPoint = r;
  }
  /**
  @internal
  */
  static create(e, t, n, r) {
    return new X(e, t, n, r);
  }
  /**
  @internal
  */
  get length() {
    let e = this.chunk.length - 1;
    return e < 0 ? 0 : Math.max(this.chunkEnd(e), this.nextLayer.length);
  }
  /**
  The number of ranges in the set.
  */
  get size() {
    if (this.isEmpty)
      return 0;
    let e = this.nextLayer.size;
    for (let t of this.chunk)
      e += t.value.length;
    return e;
  }
  /**
  @internal
  */
  chunkEnd(e) {
    return this.chunkPos[e] + this.chunk[e].length;
  }
  /**
  Update the range set, optionally adding new ranges or filtering
  out existing ones.
  
  (Note: The type parameter is just there as a kludge to work
  around TypeScript variance issues that prevented `RangeSet<X>`
  from being a subtype of `RangeSet<Y>` when `X` is a subtype of
  `Y`.)
  */
  update(e) {
    let { add: t = [], sort: n = !1, filterFrom: r = 0, filterTo: o = this.length } = e, s = e.filter;
    if (t.length == 0 && !s)
      return this;
    if (n && (t = t.slice().sort(Yn)), this.isEmpty)
      return t.length ? X.of(t) : this;
    let l = new Ll(this, null, -1).goto(0), a = 0, c = [], h = new Xi();
    for (; l.value || a < t.length; )
      if (a < t.length && (l.from - t[a].from || l.startSide - t[a].value.startSide) >= 0) {
        let d = t[a++];
        h.addInner(d.from, d.to, d.value) || c.push(d);
      } else l.rangeIndex == 1 && l.chunkIndex < this.chunk.length && (a == t.length || this.chunkEnd(l.chunkIndex) < t[a].from) && (!s || r > this.chunkEnd(l.chunkIndex) || o < this.chunkPos[l.chunkIndex]) && h.addChunk(this.chunkPos[l.chunkIndex], this.chunk[l.chunkIndex]) ? l.nextChunk() : ((!s || r > l.to || o < l.from || s(l.from, l.to, l.value)) && (h.addInner(l.from, l.to, l.value) || c.push(gi.create(l.from, l.to, l.value))), l.next());
    return h.finishInner(this.nextLayer.isEmpty && !c.length ? X.empty : this.nextLayer.update({ add: c, filter: s, filterFrom: r, filterTo: o }));
  }
  /**
  Map this range set through a set of changes, return the new set.
  */
  map(e) {
    if (e.empty || this.isEmpty)
      return this;
    let t = [], n = [], r = -1;
    for (let s = 0; s < this.chunk.length; s++) {
      let l = this.chunkPos[s], a = this.chunk[s], c = e.touchesRange(l, l + a.length);
      if (c === !1)
        r = Math.max(r, a.maxPoint), t.push(a), n.push(e.mapPos(l));
      else if (c === !0) {
        let { mapped: h, pos: d } = a.map(l, e);
        h && (r = Math.max(r, h.maxPoint), t.push(h), n.push(d));
      }
    }
    let o = this.nextLayer.map(e);
    return t.length == 0 ? o : new X(n, t, o || X.empty, r);
  }
  /**
  Iterate over the ranges that touch the region `from` to `to`,
  calling `f` for each. There is no guarantee that the ranges will
  be reported in any specific order. When the callback returns
  `false`, iteration stops.
  */
  between(e, t, n) {
    if (!this.isEmpty) {
      for (let r = 0; r < this.chunk.length; r++) {
        let o = this.chunkPos[r], s = this.chunk[r];
        if (t >= o && e <= o + s.length && s.between(o, e - o, t - o, n) === !1)
          return;
      }
      this.nextLayer.between(e, t, n);
    }
  }
  /**
  Iterate over the ranges in this set, in order, including all
  ranges that end at or after `from`.
  */
  iter(e = 0) {
    return pi.from([this]).goto(e);
  }
  /**
  @internal
  */
  get isEmpty() {
    return this.nextLayer == this;
  }
  /**
  Iterate over the ranges in a collection of sets, in order,
  starting from `from`.
  */
  static iter(e, t = 0) {
    return pi.from(e).goto(t);
  }
  /**
  Iterate over two groups of sets, calling methods on `comparator`
  to notify it of possible differences.
  */
  static compare(e, t, n, r, o = -1) {
    let s = e.filter((d) => d.maxPoint > 0 || !d.isEmpty && d.maxPoint >= o), l = t.filter((d) => d.maxPoint > 0 || !d.isEmpty && d.maxPoint >= o), a = To(s, l, n), c = new ii(s, a, o), h = new ii(l, a, o);
    n.iterGaps((d, f, g) => Ro(c, d, h, f, g, r)), n.empty && n.length == 0 && Ro(c, 0, h, 0, 0, r);
  }
  /**
  Compare the contents of two groups of range sets, returning true
  if they are equivalent in the given range.
  */
  static eq(e, t, n = 0, r) {
    r == null && (r = 999999999);
    let o = e.filter((h) => !h.isEmpty && t.indexOf(h) < 0), s = t.filter((h) => !h.isEmpty && e.indexOf(h) < 0);
    if (o.length != s.length)
      return !1;
    if (!o.length)
      return !0;
    let l = To(o, s), a = new ii(o, l, 0).goto(n), c = new ii(s, l, 0).goto(n);
    for (; ; ) {
      if (a.to != c.to || !Xn(a.active, c.active) || a.point && (!c.point || !a.point.eq(c.point)))
        return !1;
      if (a.to > r)
        return !0;
      a.next(), c.next();
    }
  }
  /**
  Iterate over a group of range sets at the same time, notifying
  the iterator about the ranges covering every given piece of
  content. Returns the open count (see
  [`SpanIterator.span`](https://codemirror.net/6/docs/ref/#state.SpanIterator.span)) at the end
  of the iteration.
  */
  static spans(e, t, n, r, o = -1) {
    let s = new ii(e, null, o).goto(t), l = t, a = s.openStart;
    for (; ; ) {
      let c = Math.min(s.to, n);
      if (s.point) {
        let h = s.activeForPoint(s.to), d = s.pointFrom < t ? h.length + 1 : s.point.startSide < 0 ? h.length : Math.min(h.length, a);
        r.point(l, c, s.point, h, d, s.pointRank), a = Math.min(s.openEnd(c), h.length);
      } else c > l && (r.span(l, c, s.active, a), a = s.openEnd(c));
      if (s.to > n)
        return a + (s.point && s.to > n ? 1 : 0);
      l = s.to, s.next();
    }
  }
  /**
  Create a range set for the given range or array of ranges. By
  default, this expects the ranges to be _sorted_ (by start
  position and, if two start at the same position,
  `value.startSide`). You can pass `true` as second argument to
  cause the method to sort them.
  */
  static of(e, t = !1) {
    let n = new Xi();
    for (let r of e instanceof gi ? [e] : t ? Hf(e) : e)
      n.add(r.from, r.to, r.value);
    return n.finish();
  }
  /**
  Join an array of range sets into a single set.
  */
  static join(e) {
    if (!e.length)
      return X.empty;
    let t = e[e.length - 1];
    for (let n = e.length - 2; n >= 0; n--)
      for (let r = e[n]; r != X.empty; r = r.nextLayer)
        t = new X(r.chunkPos, r.chunk, t, Math.max(r.maxPoint, t.maxPoint));
    return t;
  }
}
X.empty = /* @__PURE__ */ new X([], [], null, -1);
function Hf(i) {
  if (i.length > 1)
    for (let e = i[0], t = 1; t < i.length; t++) {
      let n = i[t];
      if (Yn(e, n) > 0)
        return i.slice().sort(Yn);
      e = n;
    }
  return i;
}
X.empty.nextLayer = X.empty;
class Xi {
  finishChunk(e) {
    this.chunks.push(new Ir(this.from, this.to, this.value, this.maxPoint)), this.chunkPos.push(this.chunkStart), this.chunkStart = -1, this.setMaxPoint = Math.max(this.setMaxPoint, this.maxPoint), this.maxPoint = -1, e && (this.from = [], this.to = [], this.value = []);
  }
  /**
  Create an empty builder.
  */
  constructor() {
    this.chunks = [], this.chunkPos = [], this.chunkStart = -1, this.last = null, this.lastFrom = -1e9, this.lastTo = -1e9, this.from = [], this.to = [], this.value = [], this.maxPoint = -1, this.setMaxPoint = -1, this.nextLayer = null;
  }
  /**
  Add a range. Ranges should be added in sorted (by `from` and
  `value.startSide`) order.
  */
  add(e, t, n) {
    this.addInner(e, t, n) || (this.nextLayer || (this.nextLayer = new Xi())).add(e, t, n);
  }
  /**
  @internal
  */
  addInner(e, t, n) {
    let r = e - this.lastTo || n.startSide - this.last.endSide;
    if (r <= 0 && (e - this.lastFrom || n.startSide - this.last.startSide) < 0)
      throw new Error("Ranges must be added sorted by `from` position and `startSide`");
    return r < 0 ? !1 : (this.from.length == 250 && this.finishChunk(!0), this.chunkStart < 0 && (this.chunkStart = e), this.from.push(e - this.chunkStart), this.to.push(t - this.chunkStart), this.last = n, this.lastFrom = e, this.lastTo = t, this.value.push(n), n.point && (this.maxPoint = Math.max(this.maxPoint, t - e)), !0);
  }
  /**
  @internal
  */
  addChunk(e, t) {
    if ((e - this.lastTo || t.value[0].startSide - this.last.endSide) < 0)
      return !1;
    this.from.length && this.finishChunk(!0), this.setMaxPoint = Math.max(this.setMaxPoint, t.maxPoint), this.chunks.push(t), this.chunkPos.push(e);
    let n = t.value.length - 1;
    return this.last = t.value[n], this.lastFrom = t.from[n] + e, this.lastTo = t.to[n] + e, !0;
  }
  /**
  Finish the range set. Returns the new set. The builder can't be
  used anymore after this has been called.
  */
  finish() {
    return this.finishInner(X.empty);
  }
  /**
  @internal
  */
  finishInner(e) {
    if (this.from.length && this.finishChunk(!1), this.chunks.length == 0)
      return e;
    let t = X.create(this.chunkPos, this.chunks, this.nextLayer ? this.nextLayer.finishInner(e) : e, this.setMaxPoint);
    return this.from = null, t;
  }
}
function To(i, e, t) {
  let n = /* @__PURE__ */ new Map();
  for (let o of i)
    for (let s = 0; s < o.chunk.length; s++)
      o.chunk[s].maxPoint <= 0 && n.set(o.chunk[s], o.chunkPos[s]);
  let r = /* @__PURE__ */ new Set();
  for (let o of e)
    for (let s = 0; s < o.chunk.length; s++) {
      let l = n.get(o.chunk[s]);
      l != null && (t ? t.mapPos(l) : l) == o.chunkPos[s] && !(t != null && t.touchesRange(l, l + o.chunk[s].length)) && r.add(o.chunk[s]);
    }
  return r;
}
class Ll {
  constructor(e, t, n, r = 0) {
    this.layer = e, this.skip = t, this.minPoint = n, this.rank = r;
  }
  get startSide() {
    return this.value ? this.value.startSide : 0;
  }
  get endSide() {
    return this.value ? this.value.endSide : 0;
  }
  goto(e, t = -1e9) {
    return this.chunkIndex = this.rangeIndex = 0, this.gotoInner(e, t, !1), this;
  }
  gotoInner(e, t, n) {
    for (; this.chunkIndex < this.layer.chunk.length; ) {
      let r = this.layer.chunk[this.chunkIndex];
      if (!(this.skip && this.skip.has(r) || this.layer.chunkEnd(this.chunkIndex) < e || r.maxPoint < this.minPoint))
        break;
      this.chunkIndex++, n = !1;
    }
    if (this.chunkIndex < this.layer.chunk.length) {
      let r = this.layer.chunk[this.chunkIndex].findIndex(e - this.layer.chunkPos[this.chunkIndex], t, !0);
      (!n || this.rangeIndex < r) && this.setRangeIndex(r);
    }
    this.next();
  }
  forward(e, t) {
    (this.to - e || this.endSide - t) < 0 && this.gotoInner(e, t, !0);
  }
  next() {
    for (; ; )
      if (this.chunkIndex == this.layer.chunk.length) {
        this.from = this.to = 1e9, this.value = null;
        break;
      } else {
        let e = this.layer.chunkPos[this.chunkIndex], t = this.layer.chunk[this.chunkIndex], n = e + t.from[this.rangeIndex];
        if (this.from = n, this.to = e + t.to[this.rangeIndex], this.value = t.value[this.rangeIndex], this.setRangeIndex(this.rangeIndex + 1), this.minPoint < 0 || this.value.point && this.to - this.from >= this.minPoint)
          break;
      }
  }
  setRangeIndex(e) {
    if (e == this.layer.chunk[this.chunkIndex].value.length) {
      if (this.chunkIndex++, this.skip)
        for (; this.chunkIndex < this.layer.chunk.length && this.skip.has(this.layer.chunk[this.chunkIndex]); )
          this.chunkIndex++;
      this.rangeIndex = 0;
    } else
      this.rangeIndex = e;
  }
  nextChunk() {
    this.chunkIndex++, this.rangeIndex = 0, this.next();
  }
  compare(e) {
    return this.from - e.from || this.startSide - e.startSide || this.rank - e.rank || this.to - e.to || this.endSide - e.endSide;
  }
}
class pi {
  constructor(e) {
    this.heap = e;
  }
  static from(e, t = null, n = -1) {
    let r = [];
    for (let o = 0; o < e.length; o++)
      for (let s = e[o]; !s.isEmpty; s = s.nextLayer)
        s.maxPoint >= n && r.push(new Ll(s, t, n, o));
    return r.length == 1 ? r[0] : new pi(r);
  }
  get startSide() {
    return this.value ? this.value.startSide : 0;
  }
  goto(e, t = -1e9) {
    for (let n of this.heap)
      n.goto(e, t);
    for (let n = this.heap.length >> 1; n >= 0; n--)
      xn(this.heap, n);
    return this.next(), this;
  }
  forward(e, t) {
    for (let n of this.heap)
      n.forward(e, t);
    for (let n = this.heap.length >> 1; n >= 0; n--)
      xn(this.heap, n);
    (this.to - e || this.value.endSide - t) < 0 && this.next();
  }
  next() {
    if (this.heap.length == 0)
      this.from = this.to = 1e9, this.value = null, this.rank = -1;
    else {
      let e = this.heap[0];
      this.from = e.from, this.to = e.to, this.value = e.value, this.rank = e.rank, e.value && e.next(), xn(this.heap, 0);
    }
  }
}
function xn(i, e) {
  for (let t = i[e]; ; ) {
    let n = (e << 1) + 1;
    if (n >= i.length)
      break;
    let r = i[n];
    if (n + 1 < i.length && r.compare(i[n + 1]) >= 0 && (r = i[n + 1], n++), t.compare(r) < 0)
      break;
    i[n] = t, i[e] = r, e = n;
  }
}
class ii {
  constructor(e, t, n) {
    this.minPoint = n, this.active = [], this.activeTo = [], this.activeRank = [], this.minActive = -1, this.point = null, this.pointFrom = 0, this.pointRank = 0, this.to = -1e9, this.endSide = 0, this.openStart = -1, this.cursor = pi.from(e, t, n);
  }
  goto(e, t = -1e9) {
    return this.cursor.goto(e, t), this.active.length = this.activeTo.length = this.activeRank.length = 0, this.minActive = -1, this.to = e, this.endSide = t, this.openStart = -1, this.next(), this;
  }
  forward(e, t) {
    for (; this.minActive > -1 && (this.activeTo[this.minActive] - e || this.active[this.minActive].endSide - t) < 0; )
      this.removeActive(this.minActive);
    this.cursor.forward(e, t);
  }
  removeActive(e) {
    Di(this.active, e), Di(this.activeTo, e), Di(this.activeRank, e), this.minActive = Mo(this.active, this.activeTo);
  }
  addActive(e) {
    let t = 0, { value: n, to: r, rank: o } = this.cursor;
    for (; t < this.activeRank.length && (o - this.activeRank[t] || r - this.activeTo[t]) > 0; )
      t++;
    Oi(this.active, t, n), Oi(this.activeTo, t, r), Oi(this.activeRank, t, o), e && Oi(e, t, this.cursor.from), this.minActive = Mo(this.active, this.activeTo);
  }
  // After calling this, if `this.point` != null, the next range is a
  // point. Otherwise, it's a regular range, covered by `this.active`.
  next() {
    let e = this.to, t = this.point;
    this.point = null;
    let n = this.openStart < 0 ? [] : null;
    for (; ; ) {
      let r = this.minActive;
      if (r > -1 && (this.activeTo[r] - this.cursor.from || this.active[r].endSide - this.cursor.startSide) < 0) {
        if (this.activeTo[r] > e) {
          this.to = this.activeTo[r], this.endSide = this.active[r].endSide;
          break;
        }
        this.removeActive(r), n && Di(n, r);
      } else if (this.cursor.value)
        if (this.cursor.from > e) {
          this.to = this.cursor.from, this.endSide = this.cursor.startSide;
          break;
        } else {
          let o = this.cursor.value;
          if (!o.point)
            this.addActive(n), this.cursor.next();
          else if (t && this.cursor.to == this.to && this.cursor.from < this.cursor.to)
            this.cursor.next();
          else {
            this.point = o, this.pointFrom = this.cursor.from, this.pointRank = this.cursor.rank, this.to = this.cursor.to, this.endSide = o.endSide, this.cursor.next(), this.forward(this.to, this.endSide);
            break;
          }
        }
      else {
        this.to = this.endSide = 1e9;
        break;
      }
    }
    if (n) {
      this.openStart = 0;
      for (let r = n.length - 1; r >= 0 && n[r] < e; r--)
        this.openStart++;
    }
  }
  activeForPoint(e) {
    if (!this.active.length)
      return this.active;
    let t = [];
    for (let n = this.active.length - 1; n >= 0 && !(this.activeRank[n] < this.pointRank); n--)
      (this.activeTo[n] > e || this.activeTo[n] == e && this.active[n].endSide >= this.point.endSide) && t.push(this.active[n]);
    return t.reverse();
  }
  openEnd(e) {
    let t = 0;
    for (let n = this.activeTo.length - 1; n >= 0 && this.activeTo[n] > e; n--)
      t++;
    return t;
  }
}
function Ro(i, e, t, n, r, o) {
  i.goto(e), t.goto(n);
  let s = n + r, l = n, a = n - e;
  for (; ; ) {
    let c = i.to + a - t.to, h = c || i.endSide - t.endSide, d = h < 0 ? i.to + a : t.to, f = Math.min(d, s);
    if (i.point || t.point ? i.point && t.point && (i.point == t.point || i.point.eq(t.point)) && Xn(i.activeForPoint(i.to), t.activeForPoint(t.to)) || o.comparePoint(l, f, i.point, t.point) : f > l && !Xn(i.active, t.active) && o.compareRange(l, f, i.active, t.active), d > s)
      break;
    (c || i.openEnd != t.openEnd) && o.boundChange && o.boundChange(d), l = d, h <= 0 && i.next(), h >= 0 && t.next();
  }
}
function Xn(i, e) {
  if (i.length != e.length)
    return !1;
  for (let t = 0; t < i.length; t++)
    if (i[t] != e[t] && !i[t].eq(e[t]))
      return !1;
  return !0;
}
function Di(i, e) {
  for (let t = e, n = i.length - 1; t < n; t++)
    i[t] = i[t + 1];
  i.pop();
}
function Oi(i, e, t) {
  for (let n = i.length - 1; n >= e; n--)
    i[n + 1] = i[n];
  i[e] = t;
}
function Mo(i, e) {
  let t = -1, n = 1e9;
  for (let r = 0; r < e.length; r++)
    (e[r] - n || i[r].endSide - i[t].endSide) < 0 && (t = r, n = e[r]);
  return t;
}
function Vf(i, e, t, n) {
  for (let r = 0, o = 0; ; ) {
    if (o >= e)
      return r;
    if (r == i.length)
      break;
    o += i.charCodeAt(r) == 9 ? t - o % t : 1, r = Ge(i, r);
  }
  return i.length;
}
const Jn = "ͼ", Do = typeof Symbol > "u" ? "__" + Jn : Symbol.for(Jn), Qn = typeof Symbol > "u" ? "__styleSet" + Math.floor(Math.random() * 1e8) : Symbol("styleSet"), Oo = typeof globalThis < "u" ? globalThis : typeof window < "u" ? window : {};
class Ht {
  // :: (Object<Style>, ?{finish: ?(string) → string})
  // Create a style module from the given spec.
  //
  // When `finish` is given, it is called on regular (non-`@`)
  // selectors (after `&` expansion) to compute the final selector.
  constructor(e, t) {
    this.rules = [];
    let { finish: n } = t || {};
    function r(s) {
      return /^@/.test(s) ? [s] : s.split(/,\s*/);
    }
    function o(s, l, a, c) {
      let h = [], d = /^@(\w+)\b/.exec(s[0]), f = d && d[1] == "keyframes";
      if (d && l == null) return a.push(s[0] + ";");
      for (let g in l) {
        let p = l[g];
        if (/&/.test(g))
          o(
            g.split(/,\s*/).map((b) => s.map((w) => b.replace(/&/, w))).reduce((b, w) => b.concat(w)),
            p,
            a
          );
        else if (p && typeof p == "object") {
          if (!d) throw new RangeError("The value of a property (" + g + ") should be a primitive value.");
          o(r(g), p, h, f);
        } else p != null && h.push(g.replace(/_.*/, "").replace(/[A-Z]/g, (b) => "-" + b.toLowerCase()) + ": " + p + ";");
      }
      (h.length || f) && a.push((n && !d && !c ? s.map(n) : s).join(", ") + " {" + h.join(" ") + "}");
    }
    for (let s in e) o(r(s), e[s], this.rules);
  }
  // :: () → string
  // Returns a string containing the module's CSS rules.
  getRules() {
    return this.rules.join(`
`);
  }
  // :: () → string
  // Generate a new unique CSS class name.
  static newName() {
    let e = Oo[Do] || 1;
    return Oo[Do] = e + 1, Jn + e.toString(36);
  }
  // :: (union<Document, ShadowRoot>, union<[StyleModule], StyleModule>, ?{nonce: ?string})
  //
  // Mount the given set of modules in the given DOM root, which ensures
  // that the CSS rules defined by the module are available in that
  // context.
  //
  // Rules are only added to the document once per root.
  //
  // Rule order will follow the order of the modules, so that rules from
  // modules later in the array take precedence of those from earlier
  // modules. If you call this function multiple times for the same root
  // in a way that changes the order of already mounted modules, the old
  // order will be changed.
  //
  // If a Content Security Policy nonce is provided, it is added to
  // the `<style>` tag generated by the library.
  static mount(e, t, n) {
    let r = e[Qn], o = n && n.nonce;
    r ? o && r.setNonce(o) : r = new jf(e, o), r.mount(Array.isArray(t) ? t : [t], e);
  }
}
let Eo = /* @__PURE__ */ new Map();
class jf {
  constructor(e, t) {
    let n = e.ownerDocument || e, r = n.defaultView;
    if (!e.head && e.adoptedStyleSheets && r.CSSStyleSheet) {
      let o = Eo.get(n);
      if (o) return e[Qn] = o;
      this.sheet = new r.CSSStyleSheet(), Eo.set(n, this);
    } else
      this.styleTag = n.createElement("style"), t && this.styleTag.setAttribute("nonce", t);
    this.modules = [], e[Qn] = this;
  }
  mount(e, t) {
    let n = this.sheet, r = 0, o = 0;
    for (let s = 0; s < e.length; s++) {
      let l = e[s], a = this.modules.indexOf(l);
      if (a < o && a > -1 && (this.modules.splice(a, 1), o--, a = -1), a == -1) {
        if (this.modules.splice(o++, 0, l), n) for (let c = 0; c < l.rules.length; c++)
          n.insertRule(l.rules[c], r++);
      } else {
        for (; o < a; ) r += this.modules[o++].rules.length;
        r += l.rules.length, o++;
      }
    }
    if (n)
      t.adoptedStyleSheets.indexOf(this.sheet) < 0 && (t.adoptedStyleSheets = [this.sheet, ...t.adoptedStyleSheets]);
    else {
      let s = "";
      for (let a = 0; a < this.modules.length; a++)
        s += this.modules[a].getRules() + `
`;
      this.styleTag.textContent = s;
      let l = t.head || t;
      this.styleTag.parentNode != l && l.insertBefore(this.styleTag, l.firstChild);
    }
  }
  setNonce(e) {
    this.styleTag && this.styleTag.getAttribute("nonce") != e && this.styleTag.setAttribute("nonce", e);
  }
}
var Vt = {
  8: "Backspace",
  9: "Tab",
  10: "Enter",
  12: "NumLock",
  13: "Enter",
  16: "Shift",
  17: "Control",
  18: "Alt",
  20: "CapsLock",
  27: "Escape",
  32: " ",
  33: "PageUp",
  34: "PageDown",
  35: "End",
  36: "Home",
  37: "ArrowLeft",
  38: "ArrowUp",
  39: "ArrowRight",
  40: "ArrowDown",
  44: "PrintScreen",
  45: "Insert",
  46: "Delete",
  59: ";",
  61: "=",
  91: "Meta",
  92: "Meta",
  106: "*",
  107: "+",
  108: ",",
  109: "-",
  110: ".",
  111: "/",
  144: "NumLock",
  145: "ScrollLock",
  160: "Shift",
  161: "Shift",
  162: "Control",
  163: "Control",
  164: "Alt",
  165: "Alt",
  173: "-",
  186: ";",
  187: "=",
  188: ",",
  189: "-",
  190: ".",
  191: "/",
  192: "`",
  219: "[",
  220: "\\",
  221: "]",
  222: "'"
}, Zn = {
  48: ")",
  49: "!",
  50: "@",
  51: "#",
  52: "$",
  53: "%",
  54: "^",
  55: "&",
  56: "*",
  57: "(",
  59: ":",
  61: "+",
  173: "_",
  186: ":",
  187: "+",
  188: "<",
  189: "_",
  190: ">",
  191: "?",
  192: "~",
  219: "{",
  220: "|",
  221: "}",
  222: '"'
};
for (var de = 0; de < 10; de++) Vt[48 + de] = Vt[96 + de] = String(de);
for (var de = 1; de <= 24; de++) Vt[de + 111] = "F" + de;
for (var de = 65; de <= 90; de++)
  Vt[de] = String.fromCharCode(de + 32), Zn[de] = String.fromCharCode(de);
for (var vn in Vt) Zn.hasOwnProperty(vn) || (Zn[vn] = Vt[vn]);
function mi(i) {
  let e;
  return i.nodeType == 11 ? e = i.getSelection ? i : i.ownerDocument : e = i, e.getSelection();
}
function er(i, e) {
  return e ? i == e || i.contains(e.nodeType != 1 ? e.parentNode : e) : !1;
}
function ji(i, e) {
  if (!e.anchorNode)
    return !1;
  try {
    return er(i, e.anchorNode);
  } catch {
    return !1;
  }
}
function bi(i) {
  return i.nodeType == 3 ? St(i, 0, i.nodeValue.length).getClientRects() : i.nodeType == 1 ? i.getClientRects() : [];
}
function ci(i, e, t, n) {
  return t ? Io(i, e, t, n, -1) || Io(i, e, t, n, 1) : !1;
}
function vt(i) {
  for (var e = 0; ; e++)
    if (i = i.previousSibling, !i)
      return e;
}
function Ji(i) {
  return i.nodeType == 1 && /^(DIV|P|LI|UL|OL|BLOCKQUOTE|DD|DT|H\d|SECTION|PRE)$/.test(i.nodeName);
}
function Io(i, e, t, n, r) {
  for (; ; ) {
    if (i == t && e == n)
      return !0;
    if (e == (r < 0 ? 0 : je(i))) {
      if (i.nodeName == "DIV")
        return !1;
      let o = i.parentNode;
      if (!o || o.nodeType != 1)
        return !1;
      e = vt(i) + (r < 0 ? 0 : 1), i = o;
    } else if (i.nodeType == 1) {
      if (i = i.childNodes[e + (r < 0 ? -1 : 0)], i.nodeType == 1 && i.contentEditable == "false")
        return !1;
      e = r < 0 ? je(i) : 0;
    } else
      return !1;
  }
}
function je(i) {
  return i.nodeType == 3 ? i.nodeValue.length : i.childNodes.length;
}
function un(i, e) {
  let t = e ? i.left : i.right;
  return { left: t, right: t, top: i.top, bottom: i.bottom };
}
function qf(i) {
  let e = i.visualViewport;
  return e ? {
    left: 0,
    right: e.width,
    top: 0,
    bottom: e.height
  } : {
    left: 0,
    right: i.innerWidth,
    top: 0,
    bottom: i.innerHeight
  };
}
function Bl(i, e) {
  let t = e.width / i.offsetWidth, n = e.height / i.offsetHeight;
  return (t > 0.995 && t < 1.005 || !isFinite(t) || Math.abs(e.width - i.offsetWidth) < 1) && (t = 1), (n > 0.995 && n < 1.005 || !isFinite(n) || Math.abs(e.height - i.offsetHeight) < 1) && (n = 1), { scaleX: t, scaleY: n };
}
function Kf(i, e, t, n, r, o, s, l) {
  let a = i.ownerDocument, c = a.defaultView || window;
  for (let h = i, d = !1; h && !d; )
    if (h.nodeType == 1) {
      let f, g = h == a.body, p = 1, b = 1;
      if (g)
        f = qf(c);
      else {
        if (/^(fixed|sticky)$/.test(getComputedStyle(h).position) && (d = !0), h.scrollHeight <= h.clientHeight && h.scrollWidth <= h.clientWidth) {
          h = h.assignedSlot || h.parentNode;
          continue;
        }
        let v = h.getBoundingClientRect();
        ({ scaleX: p, scaleY: b } = Bl(h, v)), f = {
          left: v.left,
          right: v.left + h.clientWidth * p,
          top: v.top,
          bottom: v.top + h.clientHeight * b
        };
      }
      let w = 0, y = 0;
      if (r == "nearest")
        e.top < f.top ? (y = e.top - (f.top + s), t > 0 && e.bottom > f.bottom + y && (y = e.bottom - f.bottom + s)) : e.bottom > f.bottom && (y = e.bottom - f.bottom + s, t < 0 && e.top - y < f.top && (y = e.top - (f.top + s)));
      else {
        let v = e.bottom - e.top, k = f.bottom - f.top;
        y = (r == "center" && v <= k ? e.top + v / 2 - k / 2 : r == "start" || r == "center" && t < 0 ? e.top - s : e.bottom - k + s) - f.top;
      }
      if (n == "nearest" ? e.left < f.left ? (w = e.left - (f.left + o), t > 0 && e.right > f.right + w && (w = e.right - f.right + o)) : e.right > f.right && (w = e.right - f.right + o, t < 0 && e.left < f.left + w && (w = e.left - (f.left + o))) : w = (n == "center" ? e.left + (e.right - e.left) / 2 - (f.right - f.left) / 2 : n == "start" == l ? e.left - o : e.right - (f.right - f.left) + o) - f.left, w || y)
        if (g)
          c.scrollBy(w, y);
        else {
          let v = 0, k = 0;
          if (y) {
            let C = h.scrollTop;
            h.scrollTop += y / b, k = (h.scrollTop - C) * b;
          }
          if (w) {
            let C = h.scrollLeft;
            h.scrollLeft += w / p, v = (h.scrollLeft - C) * p;
          }
          e = {
            left: e.left - v,
            top: e.top - k,
            right: e.right - v,
            bottom: e.bottom - k
          }, v && Math.abs(v - w) < 1 && (n = "nearest"), k && Math.abs(k - y) < 1 && (r = "nearest");
        }
      if (g)
        break;
      (e.top < f.top || e.bottom > f.bottom || e.left < f.left || e.right > f.right) && (e = {
        left: Math.max(e.left, f.left),
        right: Math.min(e.right, f.right),
        top: Math.max(e.top, f.top),
        bottom: Math.min(e.bottom, f.bottom)
      }), h = h.assignedSlot || h.parentNode;
    } else if (h.nodeType == 11)
      h = h.host;
    else
      break;
}
function Uf(i) {
  let e = i.ownerDocument, t, n;
  for (let r = i.parentNode; r && !(r == e.body || t && n); )
    if (r.nodeType == 1)
      !n && r.scrollHeight > r.clientHeight && (n = r), !t && r.scrollWidth > r.clientWidth && (t = r), r = r.assignedSlot || r.parentNode;
    else if (r.nodeType == 11)
      r = r.host;
    else
      break;
  return { x: t, y: n };
}
class _f {
  constructor() {
    this.anchorNode = null, this.anchorOffset = 0, this.focusNode = null, this.focusOffset = 0;
  }
  eq(e) {
    return this.anchorNode == e.anchorNode && this.anchorOffset == e.anchorOffset && this.focusNode == e.focusNode && this.focusOffset == e.focusOffset;
  }
  setRange(e) {
    let { anchorNode: t, focusNode: n } = e;
    this.set(t, Math.min(e.anchorOffset, t ? je(t) : 0), n, Math.min(e.focusOffset, n ? je(n) : 0));
  }
  set(e, t, n, r) {
    this.anchorNode = e, this.anchorOffset = t, this.focusNode = n, this.focusOffset = r;
  }
}
let Dt = null;
function zl(i) {
  if (i.setActive)
    return i.setActive();
  if (Dt)
    return i.focus(Dt);
  let e = [];
  for (let t = i; t && (e.push(t, t.scrollTop, t.scrollLeft), t != t.ownerDocument); t = t.parentNode)
    ;
  if (i.focus(Dt == null ? {
    get preventScroll() {
      return Dt = { preventScroll: !0 }, !0;
    }
  } : void 0), !Dt) {
    Dt = !1;
    for (let t = 0; t < e.length; ) {
      let n = e[t++], r = e[t++], o = e[t++];
      n.scrollTop != r && (n.scrollTop = r), n.scrollLeft != o && (n.scrollLeft = o);
    }
  }
}
let Po;
function St(i, e, t = e) {
  let n = Po || (Po = document.createRange());
  return n.setEnd(i, t), n.setStart(i, e), n;
}
function Pt(i, e, t, n) {
  let r = { key: e, code: e, keyCode: t, which: t, cancelable: !0 };
  n && ({ altKey: r.altKey, ctrlKey: r.ctrlKey, shiftKey: r.shiftKey, metaKey: r.metaKey } = n);
  let o = new KeyboardEvent("keydown", r);
  o.synthetic = !0, i.dispatchEvent(o);
  let s = new KeyboardEvent("keyup", r);
  return s.synthetic = !0, i.dispatchEvent(s), o.defaultPrevented || s.defaultPrevented;
}
function Gf(i) {
  for (; i; ) {
    if (i && (i.nodeType == 9 || i.nodeType == 11 && i.host))
      return i;
    i = i.assignedSlot || i.parentNode;
  }
  return null;
}
function Nl(i) {
  for (; i.attributes.length; )
    i.removeAttributeNode(i.attributes[0]);
}
function Yf(i, e) {
  let t = e.focusNode, n = e.focusOffset;
  if (!t || e.anchorNode != t || e.anchorOffset != n)
    return !1;
  for (n = Math.min(n, je(t)); ; )
    if (n) {
      if (t.nodeType != 1)
        return !1;
      let r = t.childNodes[n - 1];
      r.contentEditable == "false" ? n-- : (t = r, n = je(t));
    } else {
      if (t == i)
        return !0;
      n = vt(t), t = t.parentNode;
    }
}
function Fl(i) {
  return i.scrollTop > Math.max(1, i.scrollHeight - i.clientHeight - 4);
}
function Wl(i, e) {
  for (let t = i, n = e; ; ) {
    if (t.nodeType == 3 && n > 0)
      return { node: t, offset: n };
    if (t.nodeType == 1 && n > 0) {
      if (t.contentEditable == "false")
        return null;
      t = t.childNodes[n - 1], n = je(t);
    } else if (t.parentNode && !Ji(t))
      n = vt(t), t = t.parentNode;
    else
      return null;
  }
}
function Hl(i, e) {
  for (let t = i, n = e; ; ) {
    if (t.nodeType == 3 && n < t.nodeValue.length)
      return { node: t, offset: n };
    if (t.nodeType == 1 && n < t.childNodes.length) {
      if (t.contentEditable == "false")
        return null;
      t = t.childNodes[n], n = 0;
    } else if (t.parentNode && !Ji(t))
      n = vt(t) + 1, t = t.parentNode;
    else
      return null;
  }
}
class pe {
  constructor(e, t, n = !0) {
    this.node = e, this.offset = t, this.precise = n;
  }
  static before(e, t) {
    return new pe(e.parentNode, vt(e), t);
  }
  static after(e, t) {
    return new pe(e.parentNode, vt(e) + 1, t);
  }
}
const Pr = [];
class q {
  constructor() {
    this.parent = null, this.dom = null, this.flags = 2;
  }
  get overrideDOMText() {
    return null;
  }
  get posAtStart() {
    return this.parent ? this.parent.posBefore(this) : 0;
  }
  get posAtEnd() {
    return this.posAtStart + this.length;
  }
  posBefore(e) {
    let t = this.posAtStart;
    for (let n of this.children) {
      if (n == e)
        return t;
      t += n.length + n.breakAfter;
    }
    throw new RangeError("Invalid child in posBefore");
  }
  posAfter(e) {
    return this.posBefore(e) + e.length;
  }
  sync(e, t) {
    if (this.flags & 2) {
      let n = this.dom, r = null, o;
      for (let s of this.children) {
        if (s.flags & 7) {
          if (!s.dom && (o = r ? r.nextSibling : n.firstChild)) {
            let l = q.get(o);
            (!l || !l.parent && l.canReuseDOM(s)) && s.reuseDOM(o);
          }
          s.sync(e, t), s.flags &= -8;
        }
        if (o = r ? r.nextSibling : n.firstChild, t && !t.written && t.node == n && o != s.dom && (t.written = !0), s.dom.parentNode == n)
          for (; o && o != s.dom; )
            o = Lo(o);
        else
          n.insertBefore(s.dom, o);
        r = s.dom;
      }
      for (o = r ? r.nextSibling : n.firstChild, o && t && t.node == n && (t.written = !0); o; )
        o = Lo(o);
    } else if (this.flags & 1)
      for (let n of this.children)
        n.flags & 7 && (n.sync(e, t), n.flags &= -8);
  }
  reuseDOM(e) {
  }
  localPosFromDOM(e, t) {
    let n;
    if (e == this.dom)
      n = this.dom.childNodes[t];
    else {
      let r = je(e) == 0 ? 0 : t == 0 ? -1 : 1;
      for (; ; ) {
        let o = e.parentNode;
        if (o == this.dom)
          break;
        r == 0 && o.firstChild != o.lastChild && (e == o.firstChild ? r = -1 : r = 1), e = o;
      }
      r < 0 ? n = e : n = e.nextSibling;
    }
    if (n == this.dom.firstChild)
      return 0;
    for (; n && !q.get(n); )
      n = n.nextSibling;
    if (!n)
      return this.length;
    for (let r = 0, o = 0; ; r++) {
      let s = this.children[r];
      if (s.dom == n)
        return o;
      o += s.length + s.breakAfter;
    }
  }
  domBoundsAround(e, t, n = 0) {
    let r = -1, o = -1, s = -1, l = -1;
    for (let a = 0, c = n, h = n; a < this.children.length; a++) {
      let d = this.children[a], f = c + d.length;
      if (c < e && f > t)
        return d.domBoundsAround(e, t, c);
      if (f >= e && r == -1 && (r = a, o = c), c > t && d.dom.parentNode == this.dom) {
        s = a, l = h;
        break;
      }
      h = f, c = f + d.breakAfter;
    }
    return {
      from: o,
      to: l < 0 ? n + this.length : l,
      startDOM: (r ? this.children[r - 1].dom.nextSibling : null) || this.dom.firstChild,
      endDOM: s < this.children.length && s >= 0 ? this.children[s].dom : null
    };
  }
  markDirty(e = !1) {
    this.flags |= 2, this.markParentsDirty(e);
  }
  markParentsDirty(e) {
    for (let t = this.parent; t; t = t.parent) {
      if (e && (t.flags |= 2), t.flags & 1)
        return;
      t.flags |= 1, e = !1;
    }
  }
  setParent(e) {
    this.parent != e && (this.parent = e, this.flags & 7 && this.markParentsDirty(!0));
  }
  setDOM(e) {
    this.dom != e && (this.dom && (this.dom.cmView = null), this.dom = e, e.cmView = this);
  }
  get rootView() {
    for (let e = this; ; ) {
      let t = e.parent;
      if (!t)
        return e;
      e = t;
    }
  }
  replaceChildren(e, t, n = Pr) {
    this.markDirty();
    for (let r = e; r < t; r++) {
      let o = this.children[r];
      o.parent == this && n.indexOf(o) < 0 && o.destroy();
    }
    n.length < 250 ? this.children.splice(e, t - e, ...n) : this.children = [].concat(this.children.slice(0, e), n, this.children.slice(t));
    for (let r = 0; r < n.length; r++)
      n[r].setParent(this);
  }
  ignoreMutation(e) {
    return !1;
  }
  ignoreEvent(e) {
    return !1;
  }
  childCursor(e = this.length) {
    return new Vl(this.children, e, this.children.length);
  }
  childPos(e, t = 1) {
    return this.childCursor().findPos(e, t);
  }
  toString() {
    let e = this.constructor.name.replace("View", "");
    return e + (this.children.length ? "(" + this.children.join() + ")" : this.length ? "[" + (e == "Text" ? this.text : this.length) + "]" : "") + (this.breakAfter ? "#" : "");
  }
  static get(e) {
    return e.cmView;
  }
  get isEditable() {
    return !0;
  }
  get isWidget() {
    return !1;
  }
  get isHidden() {
    return !1;
  }
  merge(e, t, n, r, o, s) {
    return !1;
  }
  become(e) {
    return !1;
  }
  canReuseDOM(e) {
    return e.constructor == this.constructor && !((this.flags | e.flags) & 8);
  }
  // When this is a zero-length view with a side, this should return a
  // number <= 0 to indicate it is before its position, or a
  // number > 0 when after its position.
  getSide() {
    return 0;
  }
  destroy() {
    for (let e of this.children)
      e.parent == this && e.destroy();
    this.parent = null;
  }
}
q.prototype.breakAfter = 0;
function Lo(i) {
  let e = i.nextSibling;
  return i.parentNode.removeChild(i), e;
}
class Vl {
  constructor(e, t, n) {
    this.children = e, this.pos = t, this.i = n, this.off = 0;
  }
  findPos(e, t = 1) {
    for (; ; ) {
      if (e > this.pos || e == this.pos && (t > 0 || this.i == 0 || this.children[this.i - 1].breakAfter))
        return this.off = e - this.pos, this;
      let n = this.children[--this.i];
      this.pos -= n.length + n.breakAfter;
    }
  }
}
function jl(i, e, t, n, r, o, s, l, a) {
  let { children: c } = i, h = c.length ? c[e] : null, d = o.length ? o[o.length - 1] : null, f = d ? d.breakAfter : s;
  if (!(e == n && h && !s && !f && o.length < 2 && h.merge(t, r, o.length ? d : null, t == 0, l, a))) {
    if (n < c.length) {
      let g = c[n];
      g && (r < g.length || g.breakAfter && (d != null && d.breakAfter)) ? (e == n && (g = g.split(r), r = 0), !f && d && g.merge(0, r, d, !0, 0, a) ? o[o.length - 1] = g : ((r || g.children.length && !g.children[0].length) && g.merge(0, r, null, !1, 0, a), o.push(g))) : g != null && g.breakAfter && (d ? d.breakAfter = 1 : s = 1), n++;
    }
    for (h && (h.breakAfter = s, t > 0 && (!s && o.length && h.merge(t, h.length, o[0], !1, l, 0) ? h.breakAfter = o.shift().breakAfter : (t < h.length || h.children.length && h.children[h.children.length - 1].length == 0) && h.merge(t, h.length, null, !1, l, 0), e++)); e < n && o.length; )
      if (c[n - 1].become(o[o.length - 1]))
        n--, o.pop(), a = o.length ? 0 : l;
      else if (c[e].become(o[0]))
        e++, o.shift(), l = o.length ? 0 : a;
      else
        break;
    !o.length && e && n < c.length && !c[e - 1].breakAfter && c[n].merge(0, 0, c[e - 1], !1, l, a) && e--, (e < n || o.length) && i.replaceChildren(e, n, o);
  }
}
function ql(i, e, t, n, r, o) {
  let s = i.childCursor(), { i: l, off: a } = s.findPos(t, 1), { i: c, off: h } = s.findPos(e, -1), d = e - t;
  for (let f of n)
    d += f.length;
  i.length += d, jl(i, c, h, l, a, n, 0, r, o);
}
let Te = typeof navigator < "u" ? navigator : { userAgent: "", vendor: "", platform: "" }, tr = typeof document < "u" ? document : { documentElement: { style: {} } };
const ir = /* @__PURE__ */ /Edge\/(\d+)/.exec(Te.userAgent), Kl = /* @__PURE__ */ /MSIE \d/.test(Te.userAgent), nr = /* @__PURE__ */ /Trident\/(?:[7-9]|\d{2,})\..*rv:(\d+)/.exec(Te.userAgent), fn = !!(Kl || nr || ir), Bo = !fn && /* @__PURE__ */ /gecko\/(\d+)/i.test(Te.userAgent), Sn = !fn && /* @__PURE__ */ /Chrome\/(\d+)/.exec(Te.userAgent), Xf = "webkitFontSmoothing" in tr.documentElement.style, Ul = !fn && /* @__PURE__ */ /Apple Computer/.test(Te.vendor), zo = Ul && (/* @__PURE__ */ /Mobile\/\w+/.test(Te.userAgent) || Te.maxTouchPoints > 2);
var O = {
  mac: zo || /* @__PURE__ */ /Mac/.test(Te.platform),
  ie: fn,
  ie_version: Kl ? tr.documentMode || 6 : nr ? +nr[1] : ir ? +ir[1] : 0,
  gecko: Bo,
  gecko_version: Bo ? +(/* @__PURE__ */ /Firefox\/(\d+)/.exec(Te.userAgent) || [0, 0])[1] : 0,
  chrome: !!Sn,
  chrome_version: Sn ? +Sn[1] : 0,
  ios: zo,
  android: /* @__PURE__ */ /Android\b/.test(Te.userAgent),
  safari: Ul,
  webkit_version: Xf ? +(/* @__PURE__ */ /\bAppleWebKit\/(\d+)/.exec(Te.userAgent) || [0, 0])[1] : 0,
  tabSize: tr.documentElement.style.tabSize != null ? "tab-size" : "-moz-tab-size"
};
const Jf = 256;
class Ie extends q {
  constructor(e) {
    super(), this.text = e;
  }
  get length() {
    return this.text.length;
  }
  createDOM(e) {
    this.setDOM(e || document.createTextNode(this.text));
  }
  sync(e, t) {
    this.dom || this.createDOM(), this.dom.nodeValue != this.text && (t && t.node == this.dom && (t.written = !0), this.dom.nodeValue = this.text);
  }
  reuseDOM(e) {
    e.nodeType == 3 && this.createDOM(e);
  }
  merge(e, t, n) {
    return this.flags & 8 || n && (!(n instanceof Ie) || this.length - (t - e) + n.length > Jf || n.flags & 8) ? !1 : (this.text = this.text.slice(0, e) + (n ? n.text : "") + this.text.slice(t), this.markDirty(), !0);
  }
  split(e) {
    let t = new Ie(this.text.slice(e));
    return this.text = this.text.slice(0, e), this.markDirty(), t.flags |= this.flags & 8, t;
  }
  localPosFromDOM(e, t) {
    return e == this.dom ? t : t ? this.text.length : 0;
  }
  domAtPos(e) {
    return new pe(this.dom, e);
  }
  domBoundsAround(e, t, n) {
    return { from: n, to: n + this.length, startDOM: this.dom, endDOM: this.dom.nextSibling };
  }
  coordsAt(e, t) {
    return Qf(this.dom, e, t);
  }
}
class et extends q {
  constructor(e, t = [], n = 0) {
    super(), this.mark = e, this.children = t, this.length = n;
    for (let r of t)
      r.setParent(this);
  }
  setAttrs(e) {
    if (Nl(e), this.mark.class && (e.className = this.mark.class), this.mark.attrs)
      for (let t in this.mark.attrs)
        e.setAttribute(t, this.mark.attrs[t]);
    return e;
  }
  canReuseDOM(e) {
    return super.canReuseDOM(e) && !((this.flags | e.flags) & 8);
  }
  reuseDOM(e) {
    e.nodeName == this.mark.tagName.toUpperCase() && (this.setDOM(e), this.flags |= 6);
  }
  sync(e, t) {
    this.dom ? this.flags & 4 && this.setAttrs(this.dom) : this.setDOM(this.setAttrs(document.createElement(this.mark.tagName))), super.sync(e, t);
  }
  merge(e, t, n, r, o, s) {
    return n && (!(n instanceof et && n.mark.eq(this.mark)) || e && o <= 0 || t < this.length && s <= 0) ? !1 : (ql(this, e, t, n ? n.children.slice() : [], o - 1, s - 1), this.markDirty(), !0);
  }
  split(e) {
    let t = [], n = 0, r = -1, o = 0;
    for (let l of this.children) {
      let a = n + l.length;
      a > e && t.push(n < e ? l.split(e - n) : l), r < 0 && n >= e && (r = o), n = a, o++;
    }
    let s = this.length - e;
    return this.length = e, r > -1 && (this.children.length = r, this.markDirty()), new et(this.mark, t, s);
  }
  domAtPos(e) {
    return _l(this, e);
  }
  coordsAt(e, t) {
    return Yl(this, e, t);
  }
}
function Qf(i, e, t) {
  let n = i.nodeValue.length;
  e > n && (e = n);
  let r = e, o = e, s = 0;
  e == 0 && t < 0 || e == n && t >= 0 ? O.chrome || O.gecko || (e ? (r--, s = 1) : o < n && (o++, s = -1)) : t < 0 ? r-- : o < n && o++;
  let l = St(i, r, o).getClientRects();
  if (!l.length)
    return null;
  let a = l[(s ? s < 0 : t >= 0) ? 0 : l.length - 1];
  return O.safari && !s && a.width == 0 && (a = Array.prototype.find.call(l, (c) => c.width) || a), s ? un(a, s < 0) : a || null;
}
class yt extends q {
  static create(e, t, n) {
    return new yt(e, t, n);
  }
  constructor(e, t, n) {
    super(), this.widget = e, this.length = t, this.side = n, this.prevWidget = null;
  }
  split(e) {
    let t = yt.create(this.widget, this.length - e, this.side);
    return this.length -= e, t;
  }
  sync(e) {
    (!this.dom || !this.widget.updateDOM(this.dom, e)) && (this.dom && this.prevWidget && this.prevWidget.destroy(this.dom), this.prevWidget = null, this.setDOM(this.widget.toDOM(e)), this.widget.editable || (this.dom.contentEditable = "false"));
  }
  getSide() {
    return this.side;
  }
  merge(e, t, n, r, o, s) {
    return n && (!(n instanceof yt) || !this.widget.compare(n.widget) || e > 0 && o <= 0 || t < this.length && s <= 0) ? !1 : (this.length = e + (n ? n.length : 0) + (this.length - t), !0);
  }
  become(e) {
    return e instanceof yt && e.side == this.side && this.widget.constructor == e.widget.constructor ? (this.widget.compare(e.widget) || this.markDirty(!0), this.dom && !this.prevWidget && (this.prevWidget = this.widget), this.widget = e.widget, this.length = e.length, !0) : !1;
  }
  ignoreMutation() {
    return !0;
  }
  ignoreEvent(e) {
    return this.widget.ignoreEvent(e);
  }
  get overrideDOMText() {
    if (this.length == 0)
      return W.empty;
    let e = this;
    for (; e.parent; )
      e = e.parent;
    let { view: t } = e, n = t && t.state.doc, r = this.posAtStart;
    return n ? n.slice(r, r + this.length) : W.empty;
  }
  domAtPos(e) {
    return (this.length ? e == 0 : this.side > 0) ? pe.before(this.dom) : pe.after(this.dom, e == this.length);
  }
  domBoundsAround() {
    return null;
  }
  coordsAt(e, t) {
    let n = this.widget.coordsAt(this.dom, e, t);
    if (n)
      return n;
    let r = this.dom.getClientRects(), o = null;
    if (!r.length)
      return null;
    let s = this.side ? this.side < 0 : e > 0;
    for (let l = s ? r.length - 1 : 0; o = r[l], !(e > 0 ? l == 0 : l == r.length - 1 || o.top < o.bottom); l += s ? -1 : 1)
      ;
    return un(o, !s);
  }
  get isEditable() {
    return !1;
  }
  get isWidget() {
    return !0;
  }
  get isHidden() {
    return this.widget.isHidden;
  }
  destroy() {
    super.destroy(), this.dom && this.widget.destroy(this.dom);
  }
}
class jt extends q {
  constructor(e) {
    super(), this.side = e;
  }
  get length() {
    return 0;
  }
  merge() {
    return !1;
  }
  become(e) {
    return e instanceof jt && e.side == this.side;
  }
  split() {
    return new jt(this.side);
  }
  sync() {
    if (!this.dom) {
      let e = document.createElement("img");
      e.className = "cm-widgetBuffer", e.setAttribute("aria-hidden", "true"), this.setDOM(e);
    }
  }
  getSide() {
    return this.side;
  }
  domAtPos(e) {
    return this.side > 0 ? pe.before(this.dom) : pe.after(this.dom);
  }
  localPosFromDOM() {
    return 0;
  }
  domBoundsAround() {
    return null;
  }
  coordsAt(e) {
    return this.dom.getBoundingClientRect();
  }
  get overrideDOMText() {
    return W.empty;
  }
  get isHidden() {
    return !0;
  }
}
Ie.prototype.children = yt.prototype.children = jt.prototype.children = Pr;
function _l(i, e) {
  let t = i.dom, { children: n } = i, r = 0;
  for (let o = 0; r < n.length; r++) {
    let s = n[r], l = o + s.length;
    if (!(l == o && s.getSide() <= 0)) {
      if (e > o && e < l && s.dom.parentNode == t)
        return s.domAtPos(e - o);
      if (e <= o)
        break;
      o = l;
    }
  }
  for (let o = r; o > 0; o--) {
    let s = n[o - 1];
    if (s.dom.parentNode == t)
      return s.domAtPos(s.length);
  }
  for (let o = r; o < n.length; o++) {
    let s = n[o];
    if (s.dom.parentNode == t)
      return s.domAtPos(0);
  }
  return new pe(t, 0);
}
function Gl(i, e, t) {
  let n, { children: r } = i;
  t > 0 && e instanceof et && r.length && (n = r[r.length - 1]) instanceof et && n.mark.eq(e.mark) ? Gl(n, e.children[0], t - 1) : (r.push(e), e.setParent(i)), i.length += e.length;
}
function Yl(i, e, t) {
  let n = null, r = -1, o = null, s = -1;
  function l(c, h) {
    for (let d = 0, f = 0; d < c.children.length && f <= h; d++) {
      let g = c.children[d], p = f + g.length;
      p >= h && (g.children.length ? l(g, h - f) : (!o || o.isHidden && (t > 0 || eg(o, g))) && (p > h || f == p && g.getSide() > 0) ? (o = g, s = h - f) : (f < h || f == p && g.getSide() < 0 && !g.isHidden) && (n = g, r = h - f)), f = p;
    }
  }
  l(i, e);
  let a = (t < 0 ? n : o) || n || o;
  return a ? a.coordsAt(Math.max(0, a == n ? r : s), t) : Zf(i);
}
function Zf(i) {
  let e = i.dom.lastChild;
  if (!e)
    return i.dom.getBoundingClientRect();
  let t = bi(e);
  return t[t.length - 1] || null;
}
function eg(i, e) {
  let t = i.coordsAt(0, 1), n = e.coordsAt(0, 1);
  return t && n && n.top < t.bottom;
}
function rr(i, e) {
  for (let t in i)
    t == "class" && e.class ? e.class += " " + i.class : t == "style" && e.style ? e.style += ";" + i.style : e[t] = i[t];
  return e;
}
const No = /* @__PURE__ */ Object.create(null);
function Qi(i, e, t) {
  if (i == e)
    return !0;
  i || (i = No), e || (e = No);
  let n = Object.keys(i), r = Object.keys(e);
  if (n.length - (t && n.indexOf(t) > -1 ? 1 : 0) != r.length - (t && r.indexOf(t) > -1 ? 1 : 0))
    return !1;
  for (let o of n)
    if (o != t && (r.indexOf(o) == -1 || i[o] !== e[o]))
      return !1;
  return !0;
}
function or(i, e, t) {
  let n = !1;
  if (e)
    for (let r in e)
      t && r in t || (n = !0, r == "style" ? i.style.cssText = "" : i.removeAttribute(r));
  if (t)
    for (let r in t)
      e && e[r] == t[r] || (n = !0, r == "style" ? i.style.cssText = t[r] : i.setAttribute(r, t[r]));
  return n;
}
function tg(i) {
  let e = /* @__PURE__ */ Object.create(null);
  for (let t = 0; t < i.attributes.length; t++) {
    let n = i.attributes[t];
    e[n.name] = n.value;
  }
  return e;
}
class Lr {
  /**
  Compare this instance to another instance of the same type.
  (TypeScript can't express this, but only instances of the same
  specific class will be passed to this method.) This is used to
  avoid redrawing widgets when they are replaced by a new
  decoration of the same type. The default implementation just
  returns `false`, which will cause new instances of the widget to
  always be redrawn.
  */
  eq(e) {
    return !1;
  }
  /**
  Update a DOM element created by a widget of the same type (but
  different, non-`eq` content) to reflect this widget. May return
  true to indicate that it could update, false to indicate it
  couldn't (in which case the widget will be redrawn). The default
  implementation just returns false.
  */
  updateDOM(e, t) {
    return !1;
  }
  /**
  @internal
  */
  compare(e) {
    return this == e || this.constructor == e.constructor && this.eq(e);
  }
  /**
  The estimated height this widget will have, to be used when
  estimating the height of content that hasn't been drawn. May
  return -1 to indicate you don't know. The default implementation
  returns -1.
  */
  get estimatedHeight() {
    return -1;
  }
  /**
  For inline widgets that are displayed inline (as opposed to
  `inline-block`) and introduce line breaks (through `<br>` tags
  or textual newlines), this must indicate the amount of line
  breaks they introduce. Defaults to 0.
  */
  get lineBreaks() {
    return 0;
  }
  /**
  Can be used to configure which kinds of events inside the widget
  should be ignored by the editor. The default is to ignore all
  events.
  */
  ignoreEvent(e) {
    return !0;
  }
  /**
  Override the way screen coordinates for positions at/in the
  widget are found. `pos` will be the offset into the widget, and
  `side` the side of the position that is being queried—less than
  zero for before, greater than zero for after, and zero for
  directly at that position.
  */
  coordsAt(e, t, n) {
    return null;
  }
  /**
  @internal
  */
  get isHidden() {
    return !1;
  }
  /**
  @internal
  */
  get editable() {
    return !1;
  }
  /**
  This is called when the an instance of the widget is removed
  from the editor view.
  */
  destroy(e) {
  }
}
var Ve = /* @__PURE__ */ function(i) {
  return i[i.Text = 0] = "Text", i[i.WidgetBefore = 1] = "WidgetBefore", i[i.WidgetAfter = 2] = "WidgetAfter", i[i.WidgetRange = 3] = "WidgetRange", i;
}(Ve || (Ve = {}));
class ye extends Wt {
  constructor(e, t, n, r) {
    super(), this.startSide = e, this.endSide = t, this.widget = n, this.spec = r;
  }
  /**
  @internal
  */
  get heightRelevant() {
    return !1;
  }
  /**
  Create a mark decoration, which influences the styling of the
  content in its range. Nested mark decorations will cause nested
  DOM elements to be created. Nesting order is determined by
  precedence of the [facet](https://codemirror.net/6/docs/ref/#view.EditorView^decorations), with
  the higher-precedence decorations creating the inner DOM nodes.
  Such elements are split on line boundaries and on the boundaries
  of lower-precedence decorations.
  */
  static mark(e) {
    return new $i(e);
  }
  /**
  Create a widget decoration, which displays a DOM element at the
  given position.
  */
  static widget(e) {
    let t = Math.max(-1e4, Math.min(1e4, e.side || 0)), n = !!e.block;
    return t += n && !e.inlineOrder ? t > 0 ? 3e8 : -4e8 : t > 0 ? 1e8 : -1e8, new st(e, t, t, n, e.widget || null, !1);
  }
  /**
  Create a replace decoration which replaces the given range with
  a widget, or simply hides it.
  */
  static replace(e) {
    let t = !!e.block, n, r;
    if (e.isBlockGap)
      n = -5e8, r = 4e8;
    else {
      let { start: o, end: s } = Xl(e, t);
      n = (o ? t ? -3e8 : -1 : 5e8) - 1, r = (s ? t ? 2e8 : 1 : -6e8) + 1;
    }
    return new st(e, n, r, t, e.widget || null, !0);
  }
  /**
  Create a line decoration, which can add DOM attributes to the
  line starting at the given position.
  */
  static line(e) {
    return new Ai(e);
  }
  /**
  Build a [`DecorationSet`](https://codemirror.net/6/docs/ref/#view.DecorationSet) from the given
  decorated range or ranges. If the ranges aren't already sorted,
  pass `true` for `sort` to make the library sort them for you.
  */
  static set(e, t = !1) {
    return X.of(e, t);
  }
  /**
  @internal
  */
  hasHeight() {
    return this.widget ? this.widget.estimatedHeight > -1 : !1;
  }
}
ye.none = X.empty;
class $i extends ye {
  constructor(e) {
    let { start: t, end: n } = Xl(e);
    super(t ? -1 : 5e8, n ? 1 : -6e8, null, e), this.tagName = e.tagName || "span", this.class = e.class || "", this.attrs = e.attributes || null;
  }
  eq(e) {
    var t, n;
    return this == e || e instanceof $i && this.tagName == e.tagName && (this.class || ((t = this.attrs) === null || t === void 0 ? void 0 : t.class)) == (e.class || ((n = e.attrs) === null || n === void 0 ? void 0 : n.class)) && Qi(this.attrs, e.attrs, "class");
  }
  range(e, t = e) {
    if (e >= t)
      throw new RangeError("Mark decorations may not be empty");
    return super.range(e, t);
  }
}
$i.prototype.point = !1;
class Ai extends ye {
  constructor(e) {
    super(-2e8, -2e8, null, e);
  }
  eq(e) {
    return e instanceof Ai && this.spec.class == e.spec.class && Qi(this.spec.attributes, e.spec.attributes);
  }
  range(e, t = e) {
    if (t != e)
      throw new RangeError("Line decoration ranges must be zero-length");
    return super.range(e, t);
  }
}
Ai.prototype.mapMode = Ae.TrackBefore;
Ai.prototype.point = !0;
class st extends ye {
  constructor(e, t, n, r, o, s) {
    super(t, n, o, e), this.block = r, this.isReplace = s, this.mapMode = r ? t <= 0 ? Ae.TrackBefore : Ae.TrackAfter : Ae.TrackDel;
  }
  // Only relevant when this.block == true
  get type() {
    return this.startSide != this.endSide ? Ve.WidgetRange : this.startSide <= 0 ? Ve.WidgetBefore : Ve.WidgetAfter;
  }
  get heightRelevant() {
    return this.block || !!this.widget && (this.widget.estimatedHeight >= 5 || this.widget.lineBreaks > 0);
  }
  eq(e) {
    return e instanceof st && ig(this.widget, e.widget) && this.block == e.block && this.startSide == e.startSide && this.endSide == e.endSide;
  }
  range(e, t = e) {
    if (this.isReplace && (e > t || e == t && this.startSide > 0 && this.endSide <= 0))
      throw new RangeError("Invalid range for replacement decoration");
    if (!this.isReplace && t != e)
      throw new RangeError("Widget decorations can only have zero-length ranges");
    return super.range(e, t);
  }
}
st.prototype.point = !0;
function Xl(i, e = !1) {
  let { inclusiveStart: t, inclusiveEnd: n } = i;
  return t == null && (t = i.inclusive), n == null && (n = i.inclusive), { start: t ?? e, end: n ?? e };
}
function ig(i, e) {
  return i == e || !!(i && e && i.compare(e));
}
function qi(i, e, t, n = 0) {
  let r = t.length - 1;
  r >= 0 && t[r] + n >= i ? t[r] = Math.max(t[r], e) : t.push(i, e);
}
class ie extends q {
  constructor() {
    super(...arguments), this.children = [], this.length = 0, this.prevAttrs = void 0, this.attrs = null, this.breakAfter = 0;
  }
  // Consumes source
  merge(e, t, n, r, o, s) {
    if (n) {
      if (!(n instanceof ie))
        return !1;
      this.dom || n.transferDOM(this);
    }
    return r && this.setDeco(n ? n.attrs : null), ql(this, e, t, n ? n.children.slice() : [], o, s), !0;
  }
  split(e) {
    let t = new ie();
    if (t.breakAfter = this.breakAfter, this.length == 0)
      return t;
    let { i: n, off: r } = this.childPos(e);
    r && (t.append(this.children[n].split(r), 0), this.children[n].merge(r, this.children[n].length, null, !1, 0, 0), n++);
    for (let o = n; o < this.children.length; o++)
      t.append(this.children[o], 0);
    for (; n > 0 && this.children[n - 1].length == 0; )
      this.children[--n].destroy();
    return this.children.length = n, this.markDirty(), this.length = e, t;
  }
  transferDOM(e) {
    this.dom && (this.markDirty(), e.setDOM(this.dom), e.prevAttrs = this.prevAttrs === void 0 ? this.attrs : this.prevAttrs, this.prevAttrs = void 0, this.dom = null);
  }
  setDeco(e) {
    Qi(this.attrs, e) || (this.dom && (this.prevAttrs = this.attrs, this.markDirty()), this.attrs = e);
  }
  append(e, t) {
    Gl(this, e, t);
  }
  // Only called when building a line view in ContentBuilder
  addLineDeco(e) {
    let t = e.spec.attributes, n = e.spec.class;
    t && (this.attrs = rr(t, this.attrs || {})), n && (this.attrs = rr({ class: n }, this.attrs || {}));
  }
  domAtPos(e) {
    return _l(this, e);
  }
  reuseDOM(e) {
    e.nodeName == "DIV" && (this.setDOM(e), this.flags |= 6);
  }
  sync(e, t) {
    var n;
    this.dom ? this.flags & 4 && (Nl(this.dom), this.dom.className = "cm-line", this.prevAttrs = this.attrs ? null : void 0) : (this.setDOM(document.createElement("div")), this.dom.className = "cm-line", this.prevAttrs = this.attrs ? null : void 0), this.prevAttrs !== void 0 && (or(this.dom, this.prevAttrs, this.attrs), this.dom.classList.add("cm-line"), this.prevAttrs = void 0), super.sync(e, t);
    let r = this.dom.lastChild;
    for (; r && q.get(r) instanceof et; )
      r = r.lastChild;
    if (!r || !this.length || r.nodeName != "BR" && ((n = q.get(r)) === null || n === void 0 ? void 0 : n.isEditable) == !1 && (!O.ios || !this.children.some((o) => o instanceof Ie))) {
      let o = document.createElement("BR");
      o.cmIgnore = !0, this.dom.appendChild(o);
    }
  }
  measureTextSize() {
    if (this.children.length == 0 || this.length > 20)
      return null;
    let e = 0, t;
    for (let n of this.children) {
      if (!(n instanceof Ie) || /[^ -~]/.test(n.text))
        return null;
      let r = bi(n.dom);
      if (r.length != 1)
        return null;
      e += r[0].width, t = r[0].height;
    }
    return e ? {
      lineHeight: this.dom.getBoundingClientRect().height,
      charWidth: e / this.length,
      textHeight: t
    } : null;
  }
  coordsAt(e, t) {
    let n = Yl(this, e, t);
    if (!this.children.length && n && this.parent) {
      let { heightOracle: r } = this.parent.view.viewState, o = n.bottom - n.top;
      if (Math.abs(o - r.lineHeight) < 2 && r.textHeight < o) {
        let s = (o - r.textHeight) / 2;
        return { top: n.top + s, bottom: n.bottom - s, left: n.left, right: n.left };
      }
    }
    return n;
  }
  become(e) {
    return e instanceof ie && this.children.length == 0 && e.children.length == 0 && Qi(this.attrs, e.attrs) && this.breakAfter == e.breakAfter;
  }
  covers() {
    return !0;
  }
  static find(e, t) {
    for (let n = 0, r = 0; n < e.children.length; n++) {
      let o = e.children[n], s = r + o.length;
      if (s >= t) {
        if (o instanceof ie)
          return o;
        if (s > t)
          break;
      }
      r = s + o.breakAfter;
    }
    return null;
  }
}
class Qe extends q {
  constructor(e, t, n) {
    super(), this.widget = e, this.length = t, this.deco = n, this.breakAfter = 0, this.prevWidget = null;
  }
  merge(e, t, n, r, o, s) {
    return n && (!(n instanceof Qe) || !this.widget.compare(n.widget) || e > 0 && o <= 0 || t < this.length && s <= 0) ? !1 : (this.length = e + (n ? n.length : 0) + (this.length - t), !0);
  }
  domAtPos(e) {
    return e == 0 ? pe.before(this.dom) : pe.after(this.dom, e == this.length);
  }
  split(e) {
    let t = this.length - e;
    this.length = e;
    let n = new Qe(this.widget, t, this.deco);
    return n.breakAfter = this.breakAfter, n;
  }
  get children() {
    return Pr;
  }
  sync(e) {
    (!this.dom || !this.widget.updateDOM(this.dom, e)) && (this.dom && this.prevWidget && this.prevWidget.destroy(this.dom), this.prevWidget = null, this.setDOM(this.widget.toDOM(e)), this.widget.editable || (this.dom.contentEditable = "false"));
  }
  get overrideDOMText() {
    return this.parent ? this.parent.view.state.doc.slice(this.posAtStart, this.posAtEnd) : W.empty;
  }
  domBoundsAround() {
    return null;
  }
  become(e) {
    return e instanceof Qe && e.widget.constructor == this.widget.constructor ? (e.widget.compare(this.widget) || this.markDirty(!0), this.dom && !this.prevWidget && (this.prevWidget = this.widget), this.widget = e.widget, this.length = e.length, this.deco = e.deco, this.breakAfter = e.breakAfter, !0) : !1;
  }
  ignoreMutation() {
    return !0;
  }
  ignoreEvent(e) {
    return this.widget.ignoreEvent(e);
  }
  get isEditable() {
    return !1;
  }
  get isWidget() {
    return !0;
  }
  coordsAt(e, t) {
    let n = this.widget.coordsAt(this.dom, e, t);
    return n || (this.widget instanceof sr ? null : un(this.dom.getBoundingClientRect(), this.length ? e == 0 : t <= 0));
  }
  destroy() {
    super.destroy(), this.dom && this.widget.destroy(this.dom);
  }
  covers(e) {
    let { startSide: t, endSide: n } = this.deco;
    return t == n ? !1 : e < 0 ? t < 0 : n > 0;
  }
}
class sr extends Lr {
  constructor(e) {
    super(), this.height = e;
  }
  toDOM() {
    let e = document.createElement("div");
    return e.className = "cm-gap", this.updateDOM(e), e;
  }
  eq(e) {
    return e.height == this.height;
  }
  updateDOM(e) {
    return e.style.height = this.height + "px", !0;
  }
  get editable() {
    return !0;
  }
  get estimatedHeight() {
    return this.height;
  }
  ignoreEvent() {
    return !1;
  }
}
class di {
  constructor(e, t, n, r) {
    this.doc = e, this.pos = t, this.end = n, this.disallowBlockEffectsFor = r, this.content = [], this.curLine = null, this.breakAtStart = 0, this.pendingBuffer = 0, this.bufferMarks = [], this.atCursorPos = !0, this.openStart = -1, this.openEnd = -1, this.text = "", this.textOff = 0, this.cursor = e.iter(), this.skip = t;
  }
  posCovered() {
    if (this.content.length == 0)
      return !this.breakAtStart && this.doc.lineAt(this.pos).from != this.pos;
    let e = this.content[this.content.length - 1];
    return !(e.breakAfter || e instanceof Qe && e.deco.endSide < 0);
  }
  getLine() {
    return this.curLine || (this.content.push(this.curLine = new ie()), this.atCursorPos = !0), this.curLine;
  }
  flushBuffer(e = this.bufferMarks) {
    this.pendingBuffer && (this.curLine.append(Ei(new jt(-1), e), e.length), this.pendingBuffer = 0);
  }
  addBlockWidget(e) {
    this.flushBuffer(), this.curLine = null, this.content.push(e);
  }
  finish(e) {
    this.pendingBuffer && e <= this.bufferMarks.length ? this.flushBuffer() : this.pendingBuffer = 0, !this.posCovered() && !(e && this.content.length && this.content[this.content.length - 1] instanceof Qe) && this.getLine();
  }
  buildText(e, t, n) {
    for (; e > 0; ) {
      if (this.textOff == this.text.length) {
        let { value: o, lineBreak: s, done: l } = this.cursor.next(this.skip);
        if (this.skip = 0, l)
          throw new Error("Ran out of text content when drawing inline views");
        if (s) {
          this.posCovered() || this.getLine(), this.content.length ? this.content[this.content.length - 1].breakAfter = 1 : this.breakAtStart = 1, this.flushBuffer(), this.curLine = null, this.atCursorPos = !0, e--;
          continue;
        } else
          this.text = o, this.textOff = 0;
      }
      let r = Math.min(
        this.text.length - this.textOff,
        e,
        512
        /* T.Chunk */
      );
      this.flushBuffer(t.slice(t.length - n)), this.getLine().append(Ei(new Ie(this.text.slice(this.textOff, this.textOff + r)), t), n), this.atCursorPos = !0, this.textOff += r, e -= r, n = 0;
    }
  }
  span(e, t, n, r) {
    this.buildText(t - e, n, r), this.pos = t, this.openStart < 0 && (this.openStart = r);
  }
  point(e, t, n, r, o, s) {
    if (this.disallowBlockEffectsFor[s] && n instanceof st) {
      if (n.block)
        throw new RangeError("Block decorations may not be specified via plugins");
      if (t > this.doc.lineAt(this.pos).to)
        throw new RangeError("Decorations that replace line breaks may not be specified via plugins");
    }
    let l = t - e;
    if (n instanceof st)
      if (n.block)
        n.startSide > 0 && !this.posCovered() && this.getLine(), this.addBlockWidget(new Qe(n.widget || qt.block, l, n));
      else {
        let a = yt.create(n.widget || qt.inline, l, l ? 0 : n.startSide), c = this.atCursorPos && !a.isEditable && o <= r.length && (e < t || n.startSide > 0), h = !a.isEditable && (e < t || o > r.length || n.startSide <= 0), d = this.getLine();
        this.pendingBuffer == 2 && !c && !a.isEditable && (this.pendingBuffer = 0), this.flushBuffer(r), c && (d.append(Ei(new jt(1), r), o), o = r.length + Math.max(0, o - r.length)), d.append(Ei(a, r), o), this.atCursorPos = h, this.pendingBuffer = h ? e < t || o > r.length ? 1 : 2 : 0, this.pendingBuffer && (this.bufferMarks = r.slice());
      }
    else this.doc.lineAt(this.pos).from == this.pos && this.getLine().addLineDeco(n);
    l && (this.textOff + l <= this.text.length ? this.textOff += l : (this.skip += l - (this.text.length - this.textOff), this.text = "", this.textOff = 0), this.pos = t), this.openStart < 0 && (this.openStart = o);
  }
  static build(e, t, n, r, o) {
    let s = new di(e, t, n, o);
    return s.openEnd = X.spans(r, t, n, s), s.openStart < 0 && (s.openStart = s.openEnd), s.finish(s.openEnd), s;
  }
}
function Ei(i, e) {
  for (let t of e)
    i = new et(t, [i], i.length);
  return i;
}
class qt extends Lr {
  constructor(e) {
    super(), this.tag = e;
  }
  eq(e) {
    return e.tag == this.tag;
  }
  toDOM() {
    return document.createElement(this.tag);
  }
  updateDOM(e) {
    return e.nodeName.toLowerCase() == this.tag;
  }
  get isHidden() {
    return !0;
  }
}
qt.inline = /* @__PURE__ */ new qt("span");
qt.block = /* @__PURE__ */ new qt("div");
var be = /* @__PURE__ */ function(i) {
  return i[i.LTR = 0] = "LTR", i[i.RTL = 1] = "RTL", i;
}(be || (be = {}));
const Ct = be.LTR, Br = be.RTL;
function Jl(i) {
  let e = [];
  for (let t = 0; t < i.length; t++)
    e.push(1 << +i[t]);
  return e;
}
const ng = /* @__PURE__ */ Jl("88888888888888888888888888888888888666888888787833333333337888888000000000000000000000000008888880000000000000000000000000088888888888888888888888888888888888887866668888088888663380888308888800000000000000000000000800000000000000000000000000000008"), rg = /* @__PURE__ */ Jl("4444448826627288999999999992222222222222222222222222222222222222222222222229999999999999999999994444444444644222822222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222999999949999999229989999223333333333"), lr = /* @__PURE__ */ Object.create(null), ze = [];
for (let i of ["()", "[]", "{}"]) {
  let e = /* @__PURE__ */ i.charCodeAt(0), t = /* @__PURE__ */ i.charCodeAt(1);
  lr[e] = t, lr[t] = -e;
}
function Ql(i) {
  return i <= 247 ? ng[i] : 1424 <= i && i <= 1524 ? 2 : 1536 <= i && i <= 1785 ? rg[i - 1536] : 1774 <= i && i <= 2220 ? 4 : 8192 <= i && i <= 8204 ? 256 : 64336 <= i && i <= 65023 ? 4 : 1;
}
const og = /[\u0590-\u05f4\u0600-\u06ff\u0700-\u08ac\ufb50-\ufdff]/;
class nt {
  /**
  The direction of this span.
  */
  get dir() {
    return this.level % 2 ? Br : Ct;
  }
  /**
  @internal
  */
  constructor(e, t, n) {
    this.from = e, this.to = t, this.level = n;
  }
  /**
  @internal
  */
  side(e, t) {
    return this.dir == t == e ? this.to : this.from;
  }
  /**
  @internal
  */
  forward(e, t) {
    return e == (this.dir == t);
  }
  /**
  @internal
  */
  static find(e, t, n, r) {
    let o = -1;
    for (let s = 0; s < e.length; s++) {
      let l = e[s];
      if (l.from <= t && l.to >= t) {
        if (l.level == n)
          return s;
        (o < 0 || (r != 0 ? r < 0 ? l.from < t : l.to > t : e[o].level > l.level)) && (o = s);
      }
    }
    if (o < 0)
      throw new RangeError("Index out of range");
    return o;
  }
}
function Zl(i, e) {
  if (i.length != e.length)
    return !1;
  for (let t = 0; t < i.length; t++) {
    let n = i[t], r = e[t];
    if (n.from != r.from || n.to != r.to || n.direction != r.direction || !Zl(n.inner, r.inner))
      return !1;
  }
  return !0;
}
const j = [];
function sg(i, e, t, n, r) {
  for (let o = 0; o <= n.length; o++) {
    let s = o ? n[o - 1].to : e, l = o < n.length ? n[o].from : t, a = o ? 256 : r;
    for (let c = s, h = a, d = a; c < l; c++) {
      let f = Ql(i.charCodeAt(c));
      f == 512 ? f = h : f == 8 && d == 4 && (f = 16), j[c] = f == 4 ? 2 : f, f & 7 && (d = f), h = f;
    }
    for (let c = s, h = a, d = a; c < l; c++) {
      let f = j[c];
      if (f == 128)
        c < l - 1 && h == j[c + 1] && h & 24 ? f = j[c] = h : j[c] = 256;
      else if (f == 64) {
        let g = c + 1;
        for (; g < l && j[g] == 64; )
          g++;
        let p = c && h == 8 || g < t && j[g] == 8 ? d == 1 ? 1 : 8 : 256;
        for (let b = c; b < g; b++)
          j[b] = p;
        c = g - 1;
      } else f == 8 && d == 1 && (j[c] = 1);
      h = f, f & 7 && (d = f);
    }
  }
}
function lg(i, e, t, n, r) {
  let o = r == 1 ? 2 : 1;
  for (let s = 0, l = 0, a = 0; s <= n.length; s++) {
    let c = s ? n[s - 1].to : e, h = s < n.length ? n[s].from : t;
    for (let d = c, f, g, p; d < h; d++)
      if (g = lr[f = i.charCodeAt(d)])
        if (g < 0) {
          for (let b = l - 3; b >= 0; b -= 3)
            if (ze[b + 1] == -g) {
              let w = ze[b + 2], y = w & 2 ? r : w & 4 ? w & 1 ? o : r : 0;
              y && (j[d] = j[ze[b]] = y), l = b;
              break;
            }
        } else {
          if (ze.length == 189)
            break;
          ze[l++] = d, ze[l++] = f, ze[l++] = a;
        }
      else if ((p = j[d]) == 2 || p == 1) {
        let b = p == r;
        a = b ? 0 : 1;
        for (let w = l - 3; w >= 0; w -= 3) {
          let y = ze[w + 2];
          if (y & 2)
            break;
          if (b)
            ze[w + 2] |= 2;
          else {
            if (y & 4)
              break;
            ze[w + 2] |= 4;
          }
        }
      }
  }
}
function ag(i, e, t, n) {
  for (let r = 0, o = n; r <= t.length; r++) {
    let s = r ? t[r - 1].to : i, l = r < t.length ? t[r].from : e;
    for (let a = s; a < l; ) {
      let c = j[a];
      if (c == 256) {
        let h = a + 1;
        for (; ; )
          if (h == l) {
            if (r == t.length)
              break;
            h = t[r++].to, l = r < t.length ? t[r].from : e;
          } else if (j[h] == 256)
            h++;
          else
            break;
        let d = o == 1, f = (h < e ? j[h] : n) == 1, g = d == f ? d ? 1 : 2 : n;
        for (let p = h, b = r, w = b ? t[b - 1].to : i; p > a; )
          p == w && (p = t[--b].from, w = b ? t[b - 1].to : i), j[--p] = g;
        a = h;
      } else
        o = c, a++;
    }
  }
}
function ar(i, e, t, n, r, o, s) {
  let l = n % 2 ? 2 : 1;
  if (n % 2 == r % 2)
    for (let a = e, c = 0; a < t; ) {
      let h = !0, d = !1;
      if (c == o.length || a < o[c].from) {
        let b = j[a];
        b != l && (h = !1, d = b == 16);
      }
      let f = !h && l == 1 ? [] : null, g = h ? n : n + 1, p = a;
      e: for (; ; )
        if (c < o.length && p == o[c].from) {
          if (d)
            break e;
          let b = o[c];
          if (!h)
            for (let w = b.to, y = c + 1; ; ) {
              if (w == t)
                break e;
              if (y < o.length && o[y].from == w)
                w = o[y++].to;
              else {
                if (j[w] == l)
                  break e;
                break;
              }
            }
          if (c++, f)
            f.push(b);
          else {
            b.from > a && s.push(new nt(a, b.from, g));
            let w = b.direction == Ct != !(g % 2);
            hr(i, w ? n + 1 : n, r, b.inner, b.from, b.to, s), a = b.to;
          }
          p = b.to;
        } else {
          if (p == t || (h ? j[p] != l : j[p] == l))
            break;
          p++;
        }
      f ? ar(i, a, p, n + 1, r, f, s) : a < p && s.push(new nt(a, p, g)), a = p;
    }
  else
    for (let a = t, c = o.length; a > e; ) {
      let h = !0, d = !1;
      if (!c || a > o[c - 1].to) {
        let b = j[a - 1];
        b != l && (h = !1, d = b == 16);
      }
      let f = !h && l == 1 ? [] : null, g = h ? n : n + 1, p = a;
      e: for (; ; )
        if (c && p == o[c - 1].to) {
          if (d)
            break e;
          let b = o[--c];
          if (!h)
            for (let w = b.from, y = c; ; ) {
              if (w == e)
                break e;
              if (y && o[y - 1].to == w)
                w = o[--y].from;
              else {
                if (j[w - 1] == l)
                  break e;
                break;
              }
            }
          if (f)
            f.push(b);
          else {
            b.to < a && s.push(new nt(b.to, a, g));
            let w = b.direction == Ct != !(g % 2);
            hr(i, w ? n + 1 : n, r, b.inner, b.from, b.to, s), a = b.from;
          }
          p = b.from;
        } else {
          if (p == e || (h ? j[p - 1] != l : j[p - 1] == l))
            break;
          p--;
        }
      f ? ar(i, p, a, n + 1, r, f, s) : p < a && s.push(new nt(p, a, g)), a = p;
    }
}
function hr(i, e, t, n, r, o, s) {
  let l = e % 2 ? 2 : 1;
  sg(i, r, o, n, l), lg(i, r, o, n, l), ag(r, o, n, l), ar(i, r, o, e, t, n, s);
}
function hg(i, e, t) {
  if (!i)
    return [new nt(0, 0, e == Br ? 1 : 0)];
  if (e == Ct && !t.length && !og.test(i))
    return ea(i.length);
  if (t.length)
    for (; i.length > j.length; )
      j[j.length] = 256;
  let n = [], r = e == Ct ? 0 : 1;
  return hr(i, r, r, t, 0, i.length, n), n;
}
function ea(i) {
  return [new nt(0, i, 0)];
}
let ta = "";
function cg(i, e, t, n, r) {
  var o;
  let s = n.head - i.from, l = nt.find(e, s, (o = n.bidiLevel) !== null && o !== void 0 ? o : -1, n.assoc), a = e[l], c = a.side(r, t);
  if (s == c) {
    let f = l += r ? 1 : -1;
    if (f < 0 || f >= e.length)
      return null;
    a = e[l = f], s = a.side(!r, t), c = a.side(r, t);
  }
  let h = Ge(i.text, s, a.forward(r, t));
  (h < a.from || h > a.to) && (h = c), ta = i.text.slice(Math.min(s, h), Math.max(s, h));
  let d = l == (r ? e.length - 1 : 0) ? null : e[l + (r ? 1 : -1)];
  return d && h == c && d.level + (r ? 0 : 1) < a.level ? E.cursor(d.side(!r, t) + i.from, d.forward(r, t) ? 1 : -1, d.level) : E.cursor(h + i.from, a.forward(r, t) ? -1 : 1, a.level);
}
function dg(i, e, t) {
  for (let n = e; n < t; n++) {
    let r = Ql(i.charCodeAt(n));
    if (r == 1)
      return Ct;
    if (r == 2 || r == 4)
      return Br;
  }
  return Ct;
}
const ia = /* @__PURE__ */ P.define(), na = /* @__PURE__ */ P.define(), ra = /* @__PURE__ */ P.define(), oa = /* @__PURE__ */ P.define(), cr = /* @__PURE__ */ P.define(), sa = /* @__PURE__ */ P.define(), la = /* @__PURE__ */ P.define(), zr = /* @__PURE__ */ P.define(), Nr = /* @__PURE__ */ P.define(), aa = /* @__PURE__ */ P.define({
  combine: (i) => i.some((e) => e)
}), ug = /* @__PURE__ */ P.define({
  combine: (i) => i.some((e) => e)
}), ha = /* @__PURE__ */ P.define();
class Lt {
  constructor(e, t = "nearest", n = "nearest", r = 5, o = 5, s = !1) {
    this.range = e, this.y = t, this.x = n, this.yMargin = r, this.xMargin = o, this.isSnapshot = s;
  }
  map(e) {
    return e.empty ? this : new Lt(this.range.map(e), this.y, this.x, this.yMargin, this.xMargin, this.isSnapshot);
  }
  clip(e) {
    return this.range.to <= e.doc.length ? this : new Lt(E.cursor(e.doc.length), this.y, this.x, this.yMargin, this.xMargin, this.isSnapshot);
  }
}
const Ii = /* @__PURE__ */ ne.define({ map: (i, e) => i.map(e) }), ca = /* @__PURE__ */ ne.define();
function Xe(i, e, t) {
  let n = i.facet(oa);
  n.length ? n[0](e) : window.onerror && window.onerror(String(e), t, void 0, void 0, e) || (t ? console.error(t + ":", e) : console.error(e));
}
const _e = /* @__PURE__ */ P.define({ combine: (i) => i.length ? i[0] : !0 });
let fg = 0;
const Ot = /* @__PURE__ */ P.define({
  combine(i) {
    return i.filter((e, t) => {
      for (let n = 0; n < t; n++)
        if (i[n].plugin == e.plugin)
          return !1;
      return !0;
    });
  }
});
class yi {
  constructor(e, t, n, r, o) {
    this.id = e, this.create = t, this.domEventHandlers = n, this.domEventObservers = r, this.baseExtensions = o(this), this.extension = this.baseExtensions.concat(Ot.of({ plugin: this, arg: void 0 }));
  }
  /**
  Create an extension for this plugin with the given argument.
  */
  of(e) {
    return this.baseExtensions.concat(Ot.of({ plugin: this, arg: e }));
  }
  /**
  Define a plugin from a constructor function that creates the
  plugin's value, given an editor view.
  */
  static define(e, t) {
    const { eventHandlers: n, eventObservers: r, provide: o, decorations: s } = t || {};
    return new yi(fg++, e, n, r, (l) => {
      let a = [];
      return s && a.push(wi.of((c) => {
        let h = c.plugin(l);
        return h ? s(h) : ye.none;
      })), o && a.push(o(l)), a;
    });
  }
  /**
  Create a plugin for a class whose constructor takes a single
  editor view as argument.
  */
  static fromClass(e, t) {
    return yi.define((n, r) => new e(n, r), t);
  }
}
class Cn {
  constructor(e) {
    this.spec = e, this.mustUpdate = null, this.value = null;
  }
  get plugin() {
    return this.spec && this.spec.plugin;
  }
  update(e) {
    if (this.value) {
      if (this.mustUpdate) {
        let t = this.mustUpdate;
        if (this.mustUpdate = null, this.value.update)
          try {
            this.value.update(t);
          } catch (n) {
            if (Xe(t.state, n, "CodeMirror plugin crashed"), this.value.destroy)
              try {
                this.value.destroy();
              } catch {
              }
            this.deactivate();
          }
      }
    } else if (this.spec)
      try {
        this.value = this.spec.plugin.create(e, this.spec.arg);
      } catch (t) {
        Xe(e.state, t, "CodeMirror plugin crashed"), this.deactivate();
      }
    return this;
  }
  destroy(e) {
    var t;
    if (!((t = this.value) === null || t === void 0) && t.destroy)
      try {
        this.value.destroy();
      } catch (n) {
        Xe(e.state, n, "CodeMirror plugin crashed");
      }
  }
  deactivate() {
    this.spec = this.value = null;
  }
}
const da = /* @__PURE__ */ P.define(), Fr = /* @__PURE__ */ P.define(), wi = /* @__PURE__ */ P.define(), ua = /* @__PURE__ */ P.define(), Wr = /* @__PURE__ */ P.define(), fa = /* @__PURE__ */ P.define();
function Fo(i, e) {
  let t = i.state.facet(fa);
  if (!t.length)
    return t;
  let n = t.map((o) => o instanceof Function ? o(i) : o), r = [];
  return X.spans(n, e.from, e.to, {
    point() {
    },
    span(o, s, l, a) {
      let c = o - e.from, h = s - e.from, d = r;
      for (let f = l.length - 1; f >= 0; f--, a--) {
        let g = l[f].spec.bidiIsolate, p;
        if (g == null && (g = dg(e.text, c, h)), a > 0 && d.length && (p = d[d.length - 1]).to == c && p.direction == g)
          p.to = h, d = p.inner;
        else {
          let b = { from: c, to: h, direction: g, inner: [] };
          d.push(b), d = b.inner;
        }
      }
    }
  }), r;
}
const ga = /* @__PURE__ */ P.define();
function pa(i) {
  let e = 0, t = 0, n = 0, r = 0;
  for (let o of i.state.facet(ga)) {
    let s = o(i);
    s && (s.left != null && (e = Math.max(e, s.left)), s.right != null && (t = Math.max(t, s.right)), s.top != null && (n = Math.max(n, s.top)), s.bottom != null && (r = Math.max(r, s.bottom)));
  }
  return { left: e, right: t, top: n, bottom: r };
}
const ri = /* @__PURE__ */ P.define();
class Re {
  constructor(e, t, n, r) {
    this.fromA = e, this.toA = t, this.fromB = n, this.toB = r;
  }
  join(e) {
    return new Re(Math.min(this.fromA, e.fromA), Math.max(this.toA, e.toA), Math.min(this.fromB, e.fromB), Math.max(this.toB, e.toB));
  }
  addToSet(e) {
    let t = e.length, n = this;
    for (; t > 0; t--) {
      let r = e[t - 1];
      if (!(r.fromA > n.toA)) {
        if (r.toA < n.fromA)
          break;
        n = n.join(r), e.splice(t - 1, 1);
      }
    }
    return e.splice(t, 0, n), e;
  }
  static extendWithRanges(e, t) {
    if (t.length == 0)
      return e;
    let n = [];
    for (let r = 0, o = 0, s = 0, l = 0; ; r++) {
      let a = r == e.length ? null : e[r], c = s - l, h = a ? a.fromB : 1e9;
      for (; o < t.length && t[o] < h; ) {
        let d = t[o], f = t[o + 1], g = Math.max(l, d), p = Math.min(h, f);
        if (g <= p && new Re(g + c, p + c, g, p).addToSet(n), f > h)
          break;
        o += 2;
      }
      if (!a)
        return n;
      new Re(a.fromA, a.toA, a.fromB, a.toB).addToSet(n), s = a.toA, l = a.toB;
    }
  }
}
class Zi {
  constructor(e, t, n) {
    this.view = e, this.state = t, this.transactions = n, this.flags = 0, this.startState = e.state, this.changes = he.empty(this.startState.doc.length);
    for (let o of n)
      this.changes = this.changes.compose(o.changes);
    let r = [];
    this.changes.iterChangedRanges((o, s, l, a) => r.push(new Re(o, s, l, a))), this.changedRanges = r;
  }
  /**
  @internal
  */
  static create(e, t, n) {
    return new Zi(e, t, n);
  }
  /**
  Tells you whether the [viewport](https://codemirror.net/6/docs/ref/#view.EditorView.viewport) or
  [visible ranges](https://codemirror.net/6/docs/ref/#view.EditorView.visibleRanges) changed in this
  update.
  */
  get viewportChanged() {
    return (this.flags & 4) > 0;
  }
  /**
  Returns true when
  [`viewportChanged`](https://codemirror.net/6/docs/ref/#view.ViewUpdate.viewportChanged) is true
  and the viewport change is not just the result of mapping it in
  response to document changes.
  */
  get viewportMoved() {
    return (this.flags & 8) > 0;
  }
  /**
  Indicates whether the height of a block element in the editor
  changed in this update.
  */
  get heightChanged() {
    return (this.flags & 2) > 0;
  }
  /**
  Returns true when the document was modified or the size of the
  editor, or elements within the editor, changed.
  */
  get geometryChanged() {
    return this.docChanged || (this.flags & 18) > 0;
  }
  /**
  True when this update indicates a focus change.
  */
  get focusChanged() {
    return (this.flags & 1) > 0;
  }
  /**
  Whether the document changed in this update.
  */
  get docChanged() {
    return !this.changes.empty;
  }
  /**
  Whether the selection was explicitly set in this update.
  */
  get selectionSet() {
    return this.transactions.some((e) => e.selection);
  }
  /**
  @internal
  */
  get empty() {
    return this.flags == 0 && this.transactions.length == 0;
  }
}
class Wo extends q {
  get length() {
    return this.view.state.doc.length;
  }
  constructor(e) {
    super(), this.view = e, this.decorations = [], this.dynamicDecorationMap = [!1], this.domChanged = null, this.hasComposition = null, this.markedForComposition = /* @__PURE__ */ new Set(), this.editContextFormatting = ye.none, this.lastCompositionAfterCursor = !1, this.minWidth = 0, this.minWidthFrom = 0, this.minWidthTo = 0, this.impreciseAnchor = null, this.impreciseHead = null, this.forceSelection = !1, this.lastUpdate = Date.now(), this.setDOM(e.contentDOM), this.children = [new ie()], this.children[0].setParent(this), this.updateDeco(), this.updateInner([new Re(0, 0, 0, e.state.doc.length)], 0, null);
  }
  // Update the document view to a given state.
  update(e) {
    var t;
    let n = e.changedRanges;
    this.minWidth > 0 && n.length && (n.every(({ fromA: c, toA: h }) => h < this.minWidthFrom || c > this.minWidthTo) ? (this.minWidthFrom = e.changes.mapPos(this.minWidthFrom, 1), this.minWidthTo = e.changes.mapPos(this.minWidthTo, 1)) : this.minWidth = this.minWidthFrom = this.minWidthTo = 0), this.updateEditContextFormatting(e);
    let r = -1;
    this.view.inputState.composing >= 0 && !this.view.observer.editContext && (!((t = this.domChanged) === null || t === void 0) && t.newSel ? r = this.domChanged.newSel.head : !xg(e.changes, this.hasComposition) && !e.selectionSet && (r = e.state.selection.main.head));
    let o = r > -1 ? pg(this.view, e.changes, r) : null;
    if (this.domChanged = null, this.hasComposition) {
      this.markedForComposition.clear();
      let { from: c, to: h } = this.hasComposition;
      n = new Re(c, h, e.changes.mapPos(c, -1), e.changes.mapPos(h, 1)).addToSet(n.slice());
    }
    this.hasComposition = o ? { from: o.range.fromB, to: o.range.toB } : null, (O.ie || O.chrome) && !o && e && e.state.doc.lines != e.startState.doc.lines && (this.forceSelection = !0);
    let s = this.decorations, l = this.updateDeco(), a = yg(s, l, e.changes);
    return n = Re.extendWithRanges(n, a), !(this.flags & 7) && n.length == 0 ? !1 : (this.updateInner(n, e.startState.doc.length, o), e.transactions.length && (this.lastUpdate = Date.now()), !0);
  }
  // Used by update and the constructor do perform the actual DOM
  // update
  updateInner(e, t, n) {
    this.view.viewState.mustMeasureContent = !0, this.updateChildren(e, t, n);
    let { observer: r } = this.view;
    r.ignore(() => {
      this.dom.style.height = this.view.viewState.contentHeight / this.view.scaleY + "px", this.dom.style.flexBasis = this.minWidth ? this.minWidth + "px" : "";
      let s = O.chrome || O.ios ? { node: r.selectionRange.focusNode, written: !1 } : void 0;
      this.sync(this.view, s), this.flags &= -8, s && (s.written || r.selectionRange.focusNode != s.node) && (this.forceSelection = !0), this.dom.style.height = "";
    }), this.markedForComposition.forEach(
      (s) => s.flags &= -9
      /* ViewFlag.Composition */
    );
    let o = [];
    if (this.view.viewport.from || this.view.viewport.to < this.view.state.doc.length)
      for (let s of this.children)
        s instanceof Qe && s.widget instanceof sr && o.push(s.dom);
    r.updateGaps(o);
  }
  updateChildren(e, t, n) {
    let r = n ? n.range.addToSet(e.slice()) : e, o = this.childCursor(t);
    for (let s = r.length - 1; ; s--) {
      let l = s >= 0 ? r[s] : null;
      if (!l)
        break;
      let { fromA: a, toA: c, fromB: h, toB: d } = l, f, g, p, b;
      if (n && n.range.fromB < d && n.range.toB > h) {
        let C = di.build(this.view.state.doc, h, n.range.fromB, this.decorations, this.dynamicDecorationMap), A = di.build(this.view.state.doc, n.range.toB, d, this.decorations, this.dynamicDecorationMap);
        g = C.breakAtStart, p = C.openStart, b = A.openEnd;
        let S = this.compositionView(n);
        A.breakAtStart ? S.breakAfter = 1 : A.content.length && S.merge(S.length, S.length, A.content[0], !1, A.openStart, 0) && (S.breakAfter = A.content[0].breakAfter, A.content.shift()), C.content.length && S.merge(0, 0, C.content[C.content.length - 1], !0, 0, C.openEnd) && C.content.pop(), f = C.content.concat(S).concat(A.content);
      } else
        ({ content: f, breakAtStart: g, openStart: p, openEnd: b } = di.build(this.view.state.doc, h, d, this.decorations, this.dynamicDecorationMap));
      let { i: w, off: y } = o.findPos(c, 1), { i: v, off: k } = o.findPos(a, -1);
      jl(this, v, k, w, y, f, g, p, b);
    }
    n && this.fixCompositionDOM(n);
  }
  updateEditContextFormatting(e) {
    this.editContextFormatting = this.editContextFormatting.map(e.changes);
    for (let t of e.transactions)
      for (let n of t.effects)
        n.is(ca) && (this.editContextFormatting = n.value);
  }
  compositionView(e) {
    let t = new Ie(e.text.nodeValue);
    t.flags |= 8;
    for (let { deco: r } of e.marks)
      t = new et(r, [t], t.length);
    let n = new ie();
    return n.append(t, 0), n;
  }
  fixCompositionDOM(e) {
    let t = (o, s) => {
      s.flags |= 8 | (s.children.some(
        (a) => a.flags & 7
        /* ViewFlag.Dirty */
      ) ? 1 : 0), this.markedForComposition.add(s);
      let l = q.get(o);
      l && l != s && (l.dom = null), s.setDOM(o);
    }, n = this.childPos(e.range.fromB, 1), r = this.children[n.i];
    t(e.line, r);
    for (let o = e.marks.length - 1; o >= -1; o--)
      n = r.childPos(n.off, 1), r = r.children[n.i], t(o >= 0 ? e.marks[o].node : e.text, r);
  }
  // Sync the DOM selection to this.state.selection
  updateSelection(e = !1, t = !1) {
    (e || !this.view.observer.selectionRange.focusNode) && this.view.observer.readSelectionRange();
    let n = this.view.root.activeElement, r = n == this.dom, o = !r && !(this.view.state.facet(_e) || this.dom.tabIndex > -1) && ji(this.dom, this.view.observer.selectionRange) && !(n && this.dom.contains(n));
    if (!(r || t || o))
      return;
    let s = this.forceSelection;
    this.forceSelection = !1;
    let l = this.view.state.selection.main, a = this.moveToLine(this.domAtPos(l.anchor)), c = l.empty ? a : this.moveToLine(this.domAtPos(l.head));
    if (O.gecko && l.empty && !this.hasComposition && gg(a)) {
      let d = document.createTextNode("");
      this.view.observer.ignore(() => a.node.insertBefore(d, a.node.childNodes[a.offset] || null)), a = c = new pe(d, 0), s = !0;
    }
    let h = this.view.observer.selectionRange;
    (s || !h.focusNode || (!ci(a.node, a.offset, h.anchorNode, h.anchorOffset) || !ci(c.node, c.offset, h.focusNode, h.focusOffset)) && !this.suppressWidgetCursorChange(h, l)) && (this.view.observer.ignore(() => {
      O.android && O.chrome && this.dom.contains(h.focusNode) && wg(h.focusNode, this.dom) && (this.dom.blur(), this.dom.focus({ preventScroll: !0 }));
      let d = mi(this.view.root);
      if (d) if (l.empty) {
        if (O.gecko) {
          let f = mg(a.node, a.offset);
          if (f && f != 3) {
            let g = (f == 1 ? Wl : Hl)(a.node, a.offset);
            g && (a = new pe(g.node, g.offset));
          }
        }
        d.collapse(a.node, a.offset), l.bidiLevel != null && d.caretBidiLevel !== void 0 && (d.caretBidiLevel = l.bidiLevel);
      } else if (d.extend) {
        d.collapse(a.node, a.offset);
        try {
          d.extend(c.node, c.offset);
        } catch {
        }
      } else {
        let f = document.createRange();
        l.anchor > l.head && ([a, c] = [c, a]), f.setEnd(c.node, c.offset), f.setStart(a.node, a.offset), d.removeAllRanges(), d.addRange(f);
      }
      o && this.view.root.activeElement == this.dom && (this.dom.blur(), n && n.focus());
    }), this.view.observer.setSelectionRange(a, c)), this.impreciseAnchor = a.precise ? null : new pe(h.anchorNode, h.anchorOffset), this.impreciseHead = c.precise ? null : new pe(h.focusNode, h.focusOffset);
  }
  // If a zero-length widget is inserted next to the cursor during
  // composition, avoid moving it across it and disrupting the
  // composition.
  suppressWidgetCursorChange(e, t) {
    return this.hasComposition && t.empty && ci(e.focusNode, e.focusOffset, e.anchorNode, e.anchorOffset) && this.posFromDOM(e.focusNode, e.focusOffset) == t.head;
  }
  enforceCursorAssoc() {
    if (this.hasComposition)
      return;
    let { view: e } = this, t = e.state.selection.main, n = mi(e.root), { anchorNode: r, anchorOffset: o } = e.observer.selectionRange;
    if (!n || !t.empty || !t.assoc || !n.modify)
      return;
    let s = ie.find(this, t.head);
    if (!s)
      return;
    let l = s.posAtStart;
    if (t.head == l || t.head == l + s.length)
      return;
    let a = this.coordsAt(t.head, -1), c = this.coordsAt(t.head, 1);
    if (!a || !c || a.bottom > c.top)
      return;
    let h = this.domAtPos(t.head + t.assoc);
    n.collapse(h.node, h.offset), n.modify("move", t.assoc < 0 ? "forward" : "backward", "lineboundary"), e.observer.readSelectionRange();
    let d = e.observer.selectionRange;
    e.docView.posFromDOM(d.anchorNode, d.anchorOffset) != t.from && n.collapse(r, o);
  }
  // If a position is in/near a block widget, move it to a nearby text
  // line, since we don't want the cursor inside a block widget.
  moveToLine(e) {
    let t = this.dom, n;
    if (e.node != t)
      return e;
    for (let r = e.offset; !n && r < t.childNodes.length; r++) {
      let o = q.get(t.childNodes[r]);
      o instanceof ie && (n = o.domAtPos(0));
    }
    for (let r = e.offset - 1; !n && r >= 0; r--) {
      let o = q.get(t.childNodes[r]);
      o instanceof ie && (n = o.domAtPos(o.length));
    }
    return n ? new pe(n.node, n.offset, !0) : e;
  }
  nearest(e) {
    for (let t = e; t; ) {
      let n = q.get(t);
      if (n && n.rootView == this)
        return n;
      t = t.parentNode;
    }
    return null;
  }
  posFromDOM(e, t) {
    let n = this.nearest(e);
    if (!n)
      throw new RangeError("Trying to find position for a DOM position outside of the document");
    return n.localPosFromDOM(e, t) + n.posAtStart;
  }
  domAtPos(e) {
    let { i: t, off: n } = this.childCursor().findPos(e, -1);
    for (; t < this.children.length - 1; ) {
      let r = this.children[t];
      if (n < r.length || r instanceof ie)
        break;
      t++, n = 0;
    }
    return this.children[t].domAtPos(n);
  }
  coordsAt(e, t) {
    let n = null, r = 0;
    for (let o = this.length, s = this.children.length - 1; s >= 0; s--) {
      let l = this.children[s], a = o - l.breakAfter, c = a - l.length;
      if (a < e)
        break;
      if (c <= e && (c < e || l.covers(-1)) && (a > e || l.covers(1)) && (!n || l instanceof ie && !(n instanceof ie && t >= 0)))
        n = l, r = c;
      else if (n && c == e && a == e && l instanceof Qe && Math.abs(t) < 2) {
        if (l.deco.startSide < 0)
          break;
        s && (n = null);
      }
      o = c;
    }
    return n ? n.coordsAt(e - r, t) : null;
  }
  coordsForChar(e) {
    let { i: t, off: n } = this.childPos(e, 1), r = this.children[t];
    if (!(r instanceof ie))
      return null;
    for (; r.children.length; ) {
      let { i: l, off: a } = r.childPos(n, 1);
      for (; ; l++) {
        if (l == r.children.length)
          return null;
        if ((r = r.children[l]).length)
          break;
      }
      n = a;
    }
    if (!(r instanceof Ie))
      return null;
    let o = Ge(r.text, n);
    if (o == n)
      return null;
    let s = St(r.dom, n, o).getClientRects();
    for (let l = 0; l < s.length; l++) {
      let a = s[l];
      if (l == s.length - 1 || a.top < a.bottom && a.left < a.right)
        return a;
    }
    return null;
  }
  measureVisibleLineHeights(e) {
    let t = [], { from: n, to: r } = e, o = this.view.contentDOM.clientWidth, s = o > Math.max(this.view.scrollDOM.clientWidth, this.minWidth) + 1, l = -1, a = this.view.textDirection == be.LTR;
    for (let c = 0, h = 0; h < this.children.length; h++) {
      let d = this.children[h], f = c + d.length;
      if (f > r)
        break;
      if (c >= n) {
        let g = d.dom.getBoundingClientRect();
        if (t.push(g.height), s) {
          let p = d.dom.lastChild, b = p ? bi(p) : [];
          if (b.length) {
            let w = b[b.length - 1], y = a ? w.right - g.left : g.right - w.left;
            y > l && (l = y, this.minWidth = o, this.minWidthFrom = c, this.minWidthTo = f);
          }
        }
      }
      c = f + d.breakAfter;
    }
    return t;
  }
  textDirectionAt(e) {
    let { i: t } = this.childPos(e, 1);
    return getComputedStyle(this.children[t].dom).direction == "rtl" ? be.RTL : be.LTR;
  }
  measureTextSize() {
    for (let o of this.children)
      if (o instanceof ie) {
        let s = o.measureTextSize();
        if (s)
          return s;
      }
    let e = document.createElement("div"), t, n, r;
    return e.className = "cm-line", e.style.width = "99999px", e.style.position = "absolute", e.textContent = "abc def ghi jkl mno pqr stu", this.view.observer.ignore(() => {
      this.dom.appendChild(e);
      let o = bi(e.firstChild)[0];
      t = e.getBoundingClientRect().height, n = o ? o.width / 27 : 7, r = o ? o.height : t, e.remove();
    }), { lineHeight: t, charWidth: n, textHeight: r };
  }
  childCursor(e = this.length) {
    let t = this.children.length;
    return t && (e -= this.children[--t].length), new Vl(this.children, e, t);
  }
  computeBlockGapDeco() {
    let e = [], t = this.view.viewState;
    for (let n = 0, r = 0; ; r++) {
      let o = r == t.viewports.length ? null : t.viewports[r], s = o ? o.from - 1 : this.length;
      if (s > n) {
        let l = (t.lineBlockAt(s).bottom - t.lineBlockAt(n).top) / this.view.scaleY;
        e.push(ye.replace({
          widget: new sr(l),
          block: !0,
          inclusive: !0,
          isBlockGap: !0
        }).range(n, s));
      }
      if (!o)
        break;
      n = o.to + 1;
    }
    return ye.set(e);
  }
  updateDeco() {
    let e = 1, t = this.view.state.facet(wi).map((o) => (this.dynamicDecorationMap[e++] = typeof o == "function") ? o(this.view) : o), n = !1, r = this.view.state.facet(ua).map((o, s) => {
      let l = typeof o == "function";
      return l && (n = !0), l ? o(this.view) : o;
    });
    for (r.length && (this.dynamicDecorationMap[e++] = n, t.push(X.join(r))), this.decorations = [
      this.editContextFormatting,
      ...t,
      this.computeBlockGapDeco(),
      this.view.viewState.lineGapDeco
    ]; e < this.decorations.length; )
      this.dynamicDecorationMap[e++] = !1;
    return this.decorations;
  }
  scrollIntoView(e) {
    if (e.isSnapshot) {
      let c = this.view.viewState.lineBlockAt(e.range.head);
      this.view.scrollDOM.scrollTop = c.top - e.yMargin, this.view.scrollDOM.scrollLeft = e.xMargin;
      return;
    }
    for (let c of this.view.state.facet(ha))
      try {
        if (c(this.view, e.range, e))
          return !0;
      } catch (h) {
        Xe(this.view.state, h, "scroll handler");
      }
    let { range: t } = e, n = this.coordsAt(t.head, t.empty ? t.assoc : t.head > t.anchor ? -1 : 1), r;
    if (!n)
      return;
    !t.empty && (r = this.coordsAt(t.anchor, t.anchor > t.head ? -1 : 1)) && (n = {
      left: Math.min(n.left, r.left),
      top: Math.min(n.top, r.top),
      right: Math.max(n.right, r.right),
      bottom: Math.max(n.bottom, r.bottom)
    });
    let o = pa(this.view), s = {
      left: n.left - o.left,
      top: n.top - o.top,
      right: n.right + o.right,
      bottom: n.bottom + o.bottom
    }, { offsetWidth: l, offsetHeight: a } = this.view.scrollDOM;
    Kf(this.view.scrollDOM, s, t.head < t.anchor ? -1 : 1, e.x, e.y, Math.max(Math.min(e.xMargin, l), -l), Math.max(Math.min(e.yMargin, a), -a), this.view.textDirection == be.LTR);
  }
}
function gg(i) {
  return i.node.nodeType == 1 && i.node.firstChild && (i.offset == 0 || i.node.childNodes[i.offset - 1].contentEditable == "false") && (i.offset == i.node.childNodes.length || i.node.childNodes[i.offset].contentEditable == "false");
}
function ma(i, e) {
  let t = i.observer.selectionRange;
  if (!t.focusNode)
    return null;
  let n = Wl(t.focusNode, t.focusOffset), r = Hl(t.focusNode, t.focusOffset), o = n || r;
  if (r && n && r.node != n.node) {
    let l = q.get(r.node);
    if (!l || l instanceof Ie && l.text != r.node.nodeValue)
      o = r;
    else if (i.docView.lastCompositionAfterCursor) {
      let a = q.get(n.node);
      !a || a instanceof Ie && a.text != n.node.nodeValue || (o = r);
    }
  }
  if (i.docView.lastCompositionAfterCursor = o != n, !o)
    return null;
  let s = e - o.offset;
  return { from: s, to: s + o.node.nodeValue.length, node: o.node };
}
function pg(i, e, t) {
  let n = ma(i, t);
  if (!n)
    return null;
  let { node: r, from: o, to: s } = n, l = r.nodeValue;
  if (/[\n\r]/.test(l) || i.state.doc.sliceString(n.from, n.to) != l)
    return null;
  let a = e.invertedDesc, c = new Re(a.mapPos(o), a.mapPos(s), o, s), h = [];
  for (let d = r.parentNode; ; d = d.parentNode) {
    let f = q.get(d);
    if (f instanceof et)
      h.push({ node: d, deco: f.mark });
    else {
      if (f instanceof ie || d.nodeName == "DIV" && d.parentNode == i.contentDOM)
        return { range: c, text: r, marks: h, line: d };
      if (d != i.contentDOM)
        h.push({ node: d, deco: new $i({
          inclusive: !0,
          attributes: tg(d),
          tagName: d.tagName.toLowerCase()
        }) });
      else
        return null;
    }
  }
}
function mg(i, e) {
  return i.nodeType != 1 ? 0 : (e && i.childNodes[e - 1].contentEditable == "false" ? 1 : 0) | (e < i.childNodes.length && i.childNodes[e].contentEditable == "false" ? 2 : 0);
}
let bg = class {
  constructor() {
    this.changes = [];
  }
  compareRange(e, t) {
    qi(e, t, this.changes);
  }
  comparePoint(e, t) {
    qi(e, t, this.changes);
  }
  boundChange(e) {
    qi(e, e, this.changes);
  }
};
function yg(i, e, t) {
  let n = new bg();
  return X.compare(i, e, t, n), n.changes;
}
function wg(i, e) {
  for (let t = i; t && t != e; t = t.assignedSlot || t.parentNode)
    if (t.nodeType == 1 && t.contentEditable == "false")
      return !0;
  return !1;
}
function xg(i, e) {
  let t = !1;
  return e && i.iterChangedRanges((n, r) => {
    n < e.to && r > e.from && (t = !0);
  }), t;
}
function vg(i, e, t = 1) {
  let n = i.charCategorizer(e), r = i.doc.lineAt(e), o = e - r.from;
  if (r.length == 0)
    return E.cursor(e);
  o == 0 ? t = 1 : o == r.length && (t = -1);
  let s = o, l = o;
  t < 0 ? s = Ge(r.text, o, !1) : l = Ge(r.text, o);
  let a = n(r.text.slice(s, l));
  for (; s > 0; ) {
    let c = Ge(r.text, s, !1);
    if (n(r.text.slice(c, s)) != a)
      break;
    s = c;
  }
  for (; l < r.length; ) {
    let c = Ge(r.text, l);
    if (n(r.text.slice(l, c)) != a)
      break;
    l = c;
  }
  return E.range(s + r.from, l + r.from);
}
function Sg(i, e) {
  return e.left > i ? e.left - i : Math.max(0, i - e.right);
}
function Cg(i, e) {
  return e.top > i ? e.top - i : Math.max(0, i - e.bottom);
}
function kn(i, e) {
  return i.top < e.bottom - 1 && i.bottom > e.top + 1;
}
function Ho(i, e) {
  return e < i.top ? { top: e, left: i.left, right: i.right, bottom: i.bottom } : i;
}
function Vo(i, e) {
  return e > i.bottom ? { top: i.top, left: i.left, right: i.right, bottom: e } : i;
}
function dr(i, e, t) {
  let n, r, o, s, l = !1, a, c, h, d;
  for (let p = i.firstChild; p; p = p.nextSibling) {
    let b = bi(p);
    for (let w = 0; w < b.length; w++) {
      let y = b[w];
      r && kn(r, y) && (y = Ho(Vo(y, r.bottom), r.top));
      let v = Sg(e, y), k = Cg(t, y);
      if (v == 0 && k == 0)
        return p.nodeType == 3 ? jo(p, e, t) : dr(p, e, t);
      (!n || s > k || s == k && o > v) && (n = p, r = y, o = v, s = k, l = v ? e < y.left ? w > 0 : w < b.length - 1 : !0), v == 0 ? t > y.bottom && (!h || h.bottom < y.bottom) ? (a = p, h = y) : t < y.top && (!d || d.top > y.top) && (c = p, d = y) : h && kn(h, y) ? h = Vo(h, y.bottom) : d && kn(d, y) && (d = Ho(d, y.top));
    }
  }
  if (h && h.bottom >= t ? (n = a, r = h) : d && d.top <= t && (n = c, r = d), !n)
    return { node: i, offset: 0 };
  let f = Math.max(r.left, Math.min(r.right, e));
  if (n.nodeType == 3)
    return jo(n, f, t);
  if (l && n.contentEditable != "false")
    return dr(n, f, t);
  let g = Array.prototype.indexOf.call(i.childNodes, n) + (e >= (r.left + r.right) / 2 ? 1 : 0);
  return { node: i, offset: g };
}
function jo(i, e, t) {
  let n = i.nodeValue.length, r = -1, o = 1e9, s = 0;
  for (let l = 0; l < n; l++) {
    let a = St(i, l, l + 1).getClientRects();
    for (let c = 0; c < a.length; c++) {
      let h = a[c];
      if (h.top == h.bottom)
        continue;
      s || (s = e - h.left);
      let d = (h.top > t ? h.top - t : t - h.bottom) - 1;
      if (h.left - 1 <= e && h.right + 1 >= e && d < o) {
        let f = e >= (h.left + h.right) / 2, g = f;
        if ((O.chrome || O.gecko) && St(i, l).getBoundingClientRect().left == h.right && (g = !f), d <= 0)
          return { node: i, offset: l + (g ? 1 : 0) };
        r = l + (g ? 1 : 0), o = d;
      }
    }
  }
  return { node: i, offset: r > -1 ? r : s > 0 ? i.nodeValue.length : 0 };
}
function ba(i, e, t, n = -1) {
  var r, o;
  let s = i.contentDOM.getBoundingClientRect(), l = s.top + i.viewState.paddingTop, a, { docHeight: c } = i.viewState, { x: h, y: d } = e, f = d - l;
  if (f < 0)
    return 0;
  if (f > c)
    return i.state.doc.length;
  for (let C = i.viewState.heightOracle.textHeight / 2, A = !1; a = i.elementAtHeight(f), a.type != Ve.Text; )
    for (; f = n > 0 ? a.bottom + C : a.top - C, !(f >= 0 && f <= c); ) {
      if (A)
        return t ? null : 0;
      A = !0, n = -n;
    }
  d = l + f;
  let g = a.from;
  if (g < i.viewport.from)
    return i.viewport.from == 0 ? 0 : t ? null : qo(i, s, a, h, d);
  if (g > i.viewport.to)
    return i.viewport.to == i.state.doc.length ? i.state.doc.length : t ? null : qo(i, s, a, h, d);
  let p = i.dom.ownerDocument, b = i.root.elementFromPoint ? i.root : p, w = b.elementFromPoint(h, d);
  w && !i.contentDOM.contains(w) && (w = null), w || (h = Math.max(s.left + 1, Math.min(s.right - 1, h)), w = b.elementFromPoint(h, d), w && !i.contentDOM.contains(w) && (w = null));
  let y, v = -1;
  if (w && ((r = i.docView.nearest(w)) === null || r === void 0 ? void 0 : r.isEditable) != !1) {
    if (p.caretPositionFromPoint) {
      let C = p.caretPositionFromPoint(h, d);
      C && ({ offsetNode: y, offset: v } = C);
    } else if (p.caretRangeFromPoint) {
      let C = p.caretRangeFromPoint(h, d);
      C && ({ startContainer: y, startOffset: v } = C, (!i.contentDOM.contains(y) || O.safari && kg(y, v, h) || O.chrome && $g(y, v, h)) && (y = void 0));
    }
    y && (v = Math.min(je(y), v));
  }
  if (!y || !i.docView.dom.contains(y)) {
    let C = ie.find(i.docView, g);
    if (!C)
      return f > a.top + a.height / 2 ? a.to : a.from;
    ({ node: y, offset: v } = dr(C.dom, h, d));
  }
  let k = i.docView.nearest(y);
  if (!k)
    return null;
  if (k.isWidget && ((o = k.dom) === null || o === void 0 ? void 0 : o.nodeType) == 1) {
    let C = k.dom.getBoundingClientRect();
    return e.y < C.top || e.y <= C.bottom && e.x <= (C.left + C.right) / 2 ? k.posAtStart : k.posAtEnd;
  } else
    return k.localPosFromDOM(y, v) + k.posAtStart;
}
function qo(i, e, t, n, r) {
  let o = Math.round((n - e.left) * i.defaultCharacterWidth);
  if (i.lineWrapping && t.height > i.defaultLineHeight * 1.5) {
    let l = i.viewState.heightOracle.textHeight, a = Math.floor((r - t.top - (i.defaultLineHeight - l) * 0.5) / l);
    o += a * i.viewState.heightOracle.lineLength;
  }
  let s = i.state.sliceDoc(t.from, t.to);
  return t.from + Vf(s, o, i.state.tabSize);
}
function kg(i, e, t) {
  let n, r = i;
  if (i.nodeType != 3 || e != (n = i.nodeValue.length))
    return !1;
  for (; ; ) {
    let o = r.nextSibling;
    if (o) {
      if (o.nodeName == "BR")
        break;
      return !1;
    } else {
      let s = r.parentNode;
      if (!s || s.nodeName == "DIV")
        break;
      r = s;
    }
  }
  return St(i, n - 1, n).getBoundingClientRect().right > t;
}
function $g(i, e, t) {
  if (e != 0)
    return !1;
  for (let r = i; ; ) {
    let o = r.parentNode;
    if (!o || o.nodeType != 1 || o.firstChild != r)
      return !1;
    if (o.classList.contains("cm-line"))
      break;
    r = o;
  }
  let n = i.nodeType == 1 ? i.getBoundingClientRect() : St(i, 0, Math.max(i.nodeValue.length, 1)).getBoundingClientRect();
  return t - n.left > 5;
}
function Ag(i, e, t) {
  let n = i.lineBlockAt(e);
  if (Array.isArray(n.type)) {
    let r;
    for (let o of n.type) {
      if (o.from > e)
        break;
      if (!(o.to < e)) {
        if (o.from < e && o.to > e)
          return o;
        (!r || o.type == Ve.Text && (r.type != o.type || (t < 0 ? o.from < e : o.to > e))) && (r = o);
      }
    }
    return r || n;
  }
  return n;
}
function Tg(i, e, t, n) {
  let r = Ag(i, e.head, e.assoc || -1), o = !n || r.type != Ve.Text || !(i.lineWrapping || r.widgetLineBreaks) ? null : i.coordsAtPos(e.assoc < 0 && e.head > r.from ? e.head - 1 : e.head);
  if (o) {
    let s = i.dom.getBoundingClientRect(), l = i.textDirectionAt(r.from), a = i.posAtCoords({
      x: t == (l == be.LTR) ? s.right - 1 : s.left + 1,
      y: (o.top + o.bottom) / 2
    });
    if (a != null)
      return E.cursor(a, t ? -1 : 1);
  }
  return E.cursor(t ? r.to : r.from, t ? -1 : 1);
}
function Ko(i, e, t, n) {
  let r = i.state.doc.lineAt(e.head), o = i.bidiSpans(r), s = i.textDirectionAt(r.from);
  for (let l = e, a = null; ; ) {
    let c = cg(r, o, s, l, t), h = ta;
    if (!c) {
      if (r.number == (t ? i.state.doc.lines : 1))
        return l;
      h = `
`, r = i.state.doc.line(r.number + (t ? 1 : -1)), o = i.bidiSpans(r), c = i.visualLineSide(r, !t);
    }
    if (a) {
      if (!a(h))
        return l;
    } else {
      if (!n)
        return c;
      a = n(h);
    }
    l = c;
  }
}
function Rg(i, e, t) {
  let n = i.state.charCategorizer(e), r = n(t);
  return (o) => {
    let s = n(o);
    return r == Ye.Space && (r = s), r == s;
  };
}
function Mg(i, e, t, n) {
  let r = e.head, o = t ? 1 : -1;
  if (r == (t ? i.state.doc.length : 0))
    return E.cursor(r, e.assoc);
  let s = e.goalColumn, l, a = i.contentDOM.getBoundingClientRect(), c = i.coordsAtPos(r, e.assoc || -1), h = i.documentTop;
  if (c)
    s == null && (s = c.left - a.left), l = o < 0 ? c.top : c.bottom;
  else {
    let g = i.viewState.lineBlockAt(r);
    s == null && (s = Math.min(a.right - a.left, i.defaultCharacterWidth * (r - g.from))), l = (o < 0 ? g.top : g.bottom) + h;
  }
  let d = a.left + s, f = n ?? i.viewState.heightOracle.textHeight >> 1;
  for (let g = 0; ; g += 10) {
    let p = l + (f + g) * o, b = ba(i, { x: d, y: p }, !1, o);
    if (p < a.top || p > a.bottom || (o < 0 ? b < r : b > r)) {
      let w = i.docView.coordsForChar(b), y = !w || p < w.top ? -1 : 1;
      return E.cursor(b, y, void 0, s);
    }
  }
}
function Ki(i, e, t) {
  for (; ; ) {
    let n = 0;
    for (let r of i)
      r.between(e - 1, e + 1, (o, s, l) => {
        if (e > o && e < s) {
          let a = n || t || (e - o < s - e ? -1 : 1);
          e = a < 0 ? o : s, n = a;
        }
      });
    if (!n)
      return e;
  }
}
function $n(i, e, t) {
  let n = Ki(i.state.facet(Wr).map((r) => r(i)), t.from, e.head > t.from ? -1 : 1);
  return n == t.from ? t : E.cursor(n, n < t.from ? 1 : -1);
}
const oi = "￿";
class Dg {
  constructor(e, t) {
    this.points = e, this.text = "", this.lineSeparator = t.facet(G.lineSeparator);
  }
  append(e) {
    this.text += e;
  }
  lineBreak() {
    this.text += oi;
  }
  readRange(e, t) {
    if (!e)
      return this;
    let n = e.parentNode;
    for (let r = e; ; ) {
      this.findPointBefore(n, r);
      let o = this.text.length;
      this.readNode(r);
      let s = r.nextSibling;
      if (s == t)
        break;
      let l = q.get(r), a = q.get(s);
      (l && a ? l.breakAfter : (l ? l.breakAfter : Ji(r)) || Ji(s) && (r.nodeName != "BR" || r.cmIgnore) && this.text.length > o) && this.lineBreak(), r = s;
    }
    return this.findPointBefore(n, t), this;
  }
  readTextNode(e) {
    let t = e.nodeValue;
    for (let n of this.points)
      n.node == e && (n.pos = this.text.length + Math.min(n.offset, t.length));
    for (let n = 0, r = this.lineSeparator ? null : /\r\n?|\n/g; ; ) {
      let o = -1, s = 1, l;
      if (this.lineSeparator ? (o = t.indexOf(this.lineSeparator, n), s = this.lineSeparator.length) : (l = r.exec(t)) && (o = l.index, s = l[0].length), this.append(t.slice(n, o < 0 ? t.length : o)), o < 0)
        break;
      if (this.lineBreak(), s > 1)
        for (let a of this.points)
          a.node == e && a.pos > this.text.length && (a.pos -= s - 1);
      n = o + s;
    }
  }
  readNode(e) {
    if (e.cmIgnore)
      return;
    let t = q.get(e), n = t && t.overrideDOMText;
    if (n != null) {
      this.findPointInside(e, n.length);
      for (let r = n.iter(); !r.next().done; )
        r.lineBreak ? this.lineBreak() : this.append(r.value);
    } else e.nodeType == 3 ? this.readTextNode(e) : e.nodeName == "BR" ? e.nextSibling && this.lineBreak() : e.nodeType == 1 && this.readRange(e.firstChild, null);
  }
  findPointBefore(e, t) {
    for (let n of this.points)
      n.node == e && e.childNodes[n.offset] == t && (n.pos = this.text.length);
  }
  findPointInside(e, t) {
    for (let n of this.points)
      (e.nodeType == 3 ? n.node == e : e.contains(n.node)) && (n.pos = this.text.length + (Og(e, n.node, n.offset) ? t : 0));
  }
}
function Og(i, e, t) {
  for (; ; ) {
    if (!e || t < je(e))
      return !1;
    if (e == i)
      return !0;
    t = vt(e) + 1, e = e.parentNode;
  }
}
class Uo {
  constructor(e, t) {
    this.node = e, this.offset = t, this.pos = -1;
  }
}
class Eg {
  constructor(e, t, n, r) {
    this.typeOver = r, this.bounds = null, this.text = "", this.domChanged = t > -1;
    let { impreciseHead: o, impreciseAnchor: s } = e.docView;
    if (e.state.readOnly && t > -1)
      this.newSel = null;
    else if (t > -1 && (this.bounds = e.docView.domBoundsAround(t, n, 0))) {
      let l = o || s ? [] : Lg(e), a = new Dg(l, e.state);
      a.readRange(this.bounds.startDOM, this.bounds.endDOM), this.text = a.text, this.newSel = Bg(l, this.bounds.from);
    } else {
      let l = e.observer.selectionRange, a = o && o.node == l.focusNode && o.offset == l.focusOffset || !er(e.contentDOM, l.focusNode) ? e.state.selection.main.head : e.docView.posFromDOM(l.focusNode, l.focusOffset), c = s && s.node == l.anchorNode && s.offset == l.anchorOffset || !er(e.contentDOM, l.anchorNode) ? e.state.selection.main.anchor : e.docView.posFromDOM(l.anchorNode, l.anchorOffset), h = e.viewport;
      if ((O.ios || O.chrome) && e.state.selection.main.empty && a != c && (h.from > 0 || h.to < e.state.doc.length)) {
        let d = Math.min(a, c), f = Math.max(a, c), g = h.from - d, p = h.to - f;
        (g == 0 || g == 1 || d == 0) && (p == 0 || p == -1 || f == e.state.doc.length) && (a = 0, c = e.state.doc.length);
      }
      this.newSel = E.single(c, a);
    }
  }
}
function ya(i, e) {
  let t, { newSel: n } = e, r = i.state.selection.main, o = i.inputState.lastKeyTime > Date.now() - 100 ? i.inputState.lastKeyCode : -1;
  if (e.bounds) {
    let { from: s, to: l } = e.bounds, a = r.from, c = null;
    (o === 8 || O.android && e.text.length < l - s) && (a = r.to, c = "end");
    let h = Pg(i.state.doc.sliceString(s, l, oi), e.text, a - s, c);
    h && (O.chrome && o == 13 && h.toB == h.from + 2 && e.text.slice(h.from, h.toB) == oi + oi && h.toB--, t = {
      from: s + h.from,
      to: s + h.toA,
      insert: W.of(e.text.slice(h.from, h.toB).split(oi))
    });
  } else n && (!i.hasFocus && i.state.facet(_e) || n.main.eq(r)) && (n = null);
  if (!t && !n)
    return !1;
  if (!t && e.typeOver && !r.empty && n && n.main.empty ? t = { from: r.from, to: r.to, insert: i.state.doc.slice(r.from, r.to) } : (O.mac || O.android) && t && t.from == t.to && t.from == r.head - 1 && /^\. ?$/.test(t.insert.toString()) && i.contentDOM.getAttribute("autocorrect") == "off" ? (n && t.insert.length == 2 && (n = E.single(n.main.anchor - 1, n.main.head - 1)), t = { from: t.from, to: t.to, insert: W.of([t.insert.toString().replace(".", " ")]) }) : t && t.from >= r.from && t.to <= r.to && (t.from != r.from || t.to != r.to) && r.to - r.from - (t.to - t.from) <= 4 ? t = {
    from: r.from,
    to: r.to,
    insert: i.state.doc.slice(r.from, t.from).append(t.insert).append(i.state.doc.slice(t.to, r.to))
  } : O.chrome && t && t.from == t.to && t.from == r.head && t.insert.toString() == `
 ` && i.lineWrapping && (n && (n = E.single(n.main.anchor - 1, n.main.head - 1)), t = { from: r.from, to: r.to, insert: W.of([" "]) }), t)
    return Hr(i, t, n, o);
  if (n && !n.main.eq(r)) {
    let s = !1, l = "select";
    return i.inputState.lastSelectionTime > Date.now() - 50 && (i.inputState.lastSelectionOrigin == "select" && (s = !0), l = i.inputState.lastSelectionOrigin), i.dispatch({ selection: n, scrollIntoView: s, userEvent: l }), !0;
  } else
    return !1;
}
function Hr(i, e, t, n = -1) {
  if (O.ios && i.inputState.flushIOSKey(e))
    return !0;
  let r = i.state.selection.main;
  if (O.android && (e.to == r.to && // GBoard will sometimes remove a space it just inserted
  // after a completion when you press enter
  (e.from == r.from || e.from == r.from - 1 && i.state.sliceDoc(e.from, r.from) == " ") && e.insert.length == 1 && e.insert.lines == 2 && Pt(i.contentDOM, "Enter", 13) || (e.from == r.from - 1 && e.to == r.to && e.insert.length == 0 || n == 8 && e.insert.length < e.to - e.from && e.to > r.head) && Pt(i.contentDOM, "Backspace", 8) || e.from == r.from && e.to == r.to + 1 && e.insert.length == 0 && Pt(i.contentDOM, "Delete", 46)))
    return !0;
  let o = e.insert.toString();
  i.inputState.composing >= 0 && i.inputState.composing++;
  let s, l = () => s || (s = Ig(i, e, t));
  return i.state.facet(sa).some((a) => a(i, e.from, e.to, o, l)) || i.dispatch(l()), !0;
}
function Ig(i, e, t) {
  let n, r = i.state, o = r.selection.main;
  if (e.from >= o.from && e.to <= o.to && e.to - e.from >= (o.to - o.from) / 3 && (!t || t.main.empty && t.main.from == e.from + e.insert.length) && i.inputState.composing < 0) {
    let l = o.from < e.from ? r.sliceDoc(o.from, e.from) : "", a = o.to > e.to ? r.sliceDoc(e.to, o.to) : "";
    n = r.replaceSelection(i.state.toText(l + e.insert.sliceString(0, void 0, i.state.lineBreak) + a));
  } else {
    let l = r.changes(e), a = t && t.main.to <= l.newLength ? t.main : void 0;
    if (r.selection.ranges.length > 1 && i.inputState.composing >= 0 && e.to <= o.to && e.to >= o.to - 10) {
      let c = i.state.sliceDoc(e.from, e.to), h, d = t && ma(i, t.main.head);
      if (d) {
        let p = e.insert.length - (e.to - e.from);
        h = { from: d.from, to: d.to - p };
      } else
        h = i.state.doc.lineAt(o.head);
      let f = o.to - e.to, g = o.to - o.from;
      n = r.changeByRange((p) => {
        if (p.from == o.from && p.to == o.to)
          return { changes: l, range: a || p.map(l) };
        let b = p.to - f, w = b - c.length;
        if (p.to - p.from != g || i.state.sliceDoc(w, b) != c || // Unfortunately, there's no way to make multiple
        // changes in the same node work without aborting
        // composition, so cursors in the composition range are
        // ignored.
        p.to >= h.from && p.from <= h.to)
          return { range: p };
        let y = r.changes({ from: w, to: b, insert: e.insert }), v = p.to - o.to;
        return {
          changes: y,
          range: a ? E.range(Math.max(0, a.anchor + v), Math.max(0, a.head + v)) : p.map(y)
        };
      });
    } else
      n = {
        changes: l,
        selection: a && r.selection.replaceRange(a)
      };
  }
  let s = "input.type";
  return (i.composing || i.inputState.compositionPendingChange && i.inputState.compositionEndedAt > Date.now() - 50) && (i.inputState.compositionPendingChange = !1, s += ".compose", i.inputState.compositionFirstChange && (s += ".start", i.inputState.compositionFirstChange = !1)), r.update(n, { userEvent: s, scrollIntoView: !0 });
}
function Pg(i, e, t, n) {
  let r = Math.min(i.length, e.length), o = 0;
  for (; o < r && i.charCodeAt(o) == e.charCodeAt(o); )
    o++;
  if (o == r && i.length == e.length)
    return null;
  let s = i.length, l = e.length;
  for (; s > 0 && l > 0 && i.charCodeAt(s - 1) == e.charCodeAt(l - 1); )
    s--, l--;
  if (n == "end") {
    let a = Math.max(0, o - Math.min(s, l));
    t -= s + a - o;
  }
  if (s < o && i.length < e.length) {
    let a = t <= o && t >= s ? o - t : 0;
    o -= a, l = o + (l - s), s = o;
  } else if (l < o) {
    let a = t <= o && t >= l ? o - t : 0;
    o -= a, s = o + (s - l), l = o;
  }
  return { from: o, toA: s, toB: l };
}
function Lg(i) {
  let e = [];
  if (i.root.activeElement != i.contentDOM)
    return e;
  let { anchorNode: t, anchorOffset: n, focusNode: r, focusOffset: o } = i.observer.selectionRange;
  return t && (e.push(new Uo(t, n)), (r != t || o != n) && e.push(new Uo(r, o))), e;
}
function Bg(i, e) {
  if (i.length == 0)
    return null;
  let t = i[0].pos, n = i.length == 2 ? i[1].pos : t;
  return t > -1 && n > -1 ? E.single(t + e, n + e) : null;
}
class zg {
  setSelectionOrigin(e) {
    this.lastSelectionOrigin = e, this.lastSelectionTime = Date.now();
  }
  constructor(e) {
    this.view = e, this.lastKeyCode = 0, this.lastKeyTime = 0, this.lastTouchTime = 0, this.lastFocusTime = 0, this.lastScrollTop = 0, this.lastScrollLeft = 0, this.pendingIOSKey = void 0, this.tabFocusMode = -1, this.lastSelectionOrigin = null, this.lastSelectionTime = 0, this.lastContextMenu = 0, this.scrollHandlers = [], this.handlers = /* @__PURE__ */ Object.create(null), this.composing = -1, this.compositionFirstChange = null, this.compositionEndedAt = 0, this.compositionPendingKey = !1, this.compositionPendingChange = !1, this.mouseSelection = null, this.draggedContent = null, this.handleEvent = this.handleEvent.bind(this), this.notifiedFocused = e.hasFocus, O.safari && e.contentDOM.addEventListener("input", () => null), O.gecko && ep(e.contentDOM.ownerDocument);
  }
  handleEvent(e) {
    !Ug(this.view, e) || this.ignoreDuringComposition(e) || e.type == "keydown" && this.keydown(e) || (this.view.updateState != 0 ? Promise.resolve().then(() => this.runHandlers(e.type, e)) : this.runHandlers(e.type, e));
  }
  runHandlers(e, t) {
    let n = this.handlers[e];
    if (n) {
      for (let r of n.observers)
        r(this.view, t);
      for (let r of n.handlers) {
        if (t.defaultPrevented)
          break;
        if (r(this.view, t)) {
          t.preventDefault();
          break;
        }
      }
    }
  }
  ensureHandlers(e) {
    let t = Ng(e), n = this.handlers, r = this.view.contentDOM;
    for (let o in t)
      if (o != "scroll") {
        let s = !t[o].handlers.length, l = n[o];
        l && s != !l.handlers.length && (r.removeEventListener(o, this.handleEvent), l = null), l || r.addEventListener(o, this.handleEvent, { passive: s });
      }
    for (let o in n)
      o != "scroll" && !t[o] && r.removeEventListener(o, this.handleEvent);
    this.handlers = t;
  }
  keydown(e) {
    if (this.lastKeyCode = e.keyCode, this.lastKeyTime = Date.now(), e.keyCode == 9 && this.tabFocusMode > -1 && (!this.tabFocusMode || Date.now() <= this.tabFocusMode))
      return !0;
    if (this.tabFocusMode > 0 && e.keyCode != 27 && Wg.indexOf(e.keyCode) < 0 && (this.tabFocusMode = -1), O.android && O.chrome && !e.synthetic && (e.keyCode == 13 || e.keyCode == 8))
      return this.view.observer.delayAndroidKey(e.key, e.keyCode), !0;
    let t;
    return O.ios && !e.synthetic && !e.altKey && !e.metaKey && ((t = wa.find((n) => n.keyCode == e.keyCode)) && !e.ctrlKey || Fg.indexOf(e.key) > -1 && e.ctrlKey && !e.shiftKey) ? (this.pendingIOSKey = t || e, setTimeout(() => this.flushIOSKey(), 250), !0) : (e.keyCode != 229 && this.view.observer.forceFlush(), !1);
  }
  flushIOSKey(e) {
    let t = this.pendingIOSKey;
    return !t || t.key == "Enter" && e && e.from < e.to && /^\S+$/.test(e.insert.toString()) ? !1 : (this.pendingIOSKey = void 0, Pt(this.view.contentDOM, t.key, t.keyCode, t instanceof KeyboardEvent ? t : void 0));
  }
  ignoreDuringComposition(e) {
    return /^key/.test(e.type) ? this.composing > 0 ? !0 : O.safari && !O.ios && this.compositionPendingKey && Date.now() - this.compositionEndedAt < 100 ? (this.compositionPendingKey = !1, !0) : !1 : !1;
  }
  startMouseSelection(e) {
    this.mouseSelection && this.mouseSelection.destroy(), this.mouseSelection = e;
  }
  update(e) {
    this.view.observer.update(e), this.mouseSelection && this.mouseSelection.update(e), this.draggedContent && e.docChanged && (this.draggedContent = this.draggedContent.map(e.changes)), e.transactions.length && (this.lastKeyCode = this.lastSelectionTime = 0);
  }
  destroy() {
    this.mouseSelection && this.mouseSelection.destroy();
  }
}
function _o(i, e) {
  return (t, n) => {
    try {
      return e.call(i, n, t);
    } catch (r) {
      Xe(t.state, r);
    }
  };
}
function Ng(i) {
  let e = /* @__PURE__ */ Object.create(null);
  function t(n) {
    return e[n] || (e[n] = { observers: [], handlers: [] });
  }
  for (let n of i) {
    let r = n.spec, o = r && r.plugin.domEventHandlers, s = r && r.plugin.domEventObservers;
    if (o)
      for (let l in o) {
        let a = o[l];
        a && t(l).handlers.push(_o(n.value, a));
      }
    if (s)
      for (let l in s) {
        let a = s[l];
        a && t(l).observers.push(_o(n.value, a));
      }
  }
  for (let n in Pe)
    t(n).handlers.push(Pe[n]);
  for (let n in Me)
    t(n).observers.push(Me[n]);
  return e;
}
const wa = [
  { key: "Backspace", keyCode: 8, inputType: "deleteContentBackward" },
  { key: "Enter", keyCode: 13, inputType: "insertParagraph" },
  { key: "Enter", keyCode: 13, inputType: "insertLineBreak" },
  { key: "Delete", keyCode: 46, inputType: "deleteContentForward" }
], Fg = "dthko", Wg = [16, 17, 18, 20, 91, 92, 224, 225], Pi = 6;
function Li(i) {
  return Math.max(0, i) * 0.7 + 8;
}
function Hg(i, e) {
  return Math.max(Math.abs(i.clientX - e.clientX), Math.abs(i.clientY - e.clientY));
}
class Vg {
  constructor(e, t, n, r) {
    this.view = e, this.startEvent = t, this.style = n, this.mustSelect = r, this.scrollSpeed = { x: 0, y: 0 }, this.scrolling = -1, this.lastEvent = t, this.scrollParents = Uf(e.contentDOM), this.atoms = e.state.facet(Wr).map((s) => s(e));
    let o = e.contentDOM.ownerDocument;
    o.addEventListener("mousemove", this.move = this.move.bind(this)), o.addEventListener("mouseup", this.up = this.up.bind(this)), this.extend = t.shiftKey, this.multiple = e.state.facet(G.allowMultipleSelections) && jg(e, t), this.dragging = Kg(e, t) && Sa(t) == 1 ? null : !1;
  }
  start(e) {
    this.dragging === !1 && this.select(e);
  }
  move(e) {
    if (e.buttons == 0)
      return this.destroy();
    if (this.dragging || this.dragging == null && Hg(this.startEvent, e) < 10)
      return;
    this.select(this.lastEvent = e);
    let t = 0, n = 0, r = 0, o = 0, s = this.view.win.innerWidth, l = this.view.win.innerHeight;
    this.scrollParents.x && ({ left: r, right: s } = this.scrollParents.x.getBoundingClientRect()), this.scrollParents.y && ({ top: o, bottom: l } = this.scrollParents.y.getBoundingClientRect());
    let a = pa(this.view);
    e.clientX - a.left <= r + Pi ? t = -Li(r - e.clientX) : e.clientX + a.right >= s - Pi && (t = Li(e.clientX - s)), e.clientY - a.top <= o + Pi ? n = -Li(o - e.clientY) : e.clientY + a.bottom >= l - Pi && (n = Li(e.clientY - l)), this.setScrollSpeed(t, n);
  }
  up(e) {
    this.dragging == null && this.select(this.lastEvent), this.dragging || e.preventDefault(), this.destroy();
  }
  destroy() {
    this.setScrollSpeed(0, 0);
    let e = this.view.contentDOM.ownerDocument;
    e.removeEventListener("mousemove", this.move), e.removeEventListener("mouseup", this.up), this.view.inputState.mouseSelection = this.view.inputState.draggedContent = null;
  }
  setScrollSpeed(e, t) {
    this.scrollSpeed = { x: e, y: t }, e || t ? this.scrolling < 0 && (this.scrolling = setInterval(() => this.scroll(), 50)) : this.scrolling > -1 && (clearInterval(this.scrolling), this.scrolling = -1);
  }
  scroll() {
    let { x: e, y: t } = this.scrollSpeed;
    e && this.scrollParents.x && (this.scrollParents.x.scrollLeft += e, e = 0), t && this.scrollParents.y && (this.scrollParents.y.scrollTop += t, t = 0), (e || t) && this.view.win.scrollBy(e, t), this.dragging === !1 && this.select(this.lastEvent);
  }
  skipAtoms(e) {
    let t = null;
    for (let n = 0; n < e.ranges.length; n++) {
      let r = e.ranges[n], o = null;
      if (r.empty) {
        let s = Ki(this.atoms, r.from, 0);
        s != r.from && (o = E.cursor(s, -1));
      } else {
        let s = Ki(this.atoms, r.from, -1), l = Ki(this.atoms, r.to, 1);
        (s != r.from || l != r.to) && (o = E.range(r.from == r.anchor ? s : l, r.from == r.head ? s : l));
      }
      o && (t || (t = e.ranges.slice()), t[n] = o);
    }
    return t ? E.create(t, e.mainIndex) : e;
  }
  select(e) {
    let { view: t } = this, n = this.skipAtoms(this.style.get(e, this.extend, this.multiple));
    (this.mustSelect || !n.eq(t.state.selection, this.dragging === !1)) && this.view.dispatch({
      selection: n,
      userEvent: "select.pointer"
    }), this.mustSelect = !1;
  }
  update(e) {
    e.transactions.some((t) => t.isUserEvent("input.type")) ? this.destroy() : this.style.update(e) && setTimeout(() => this.select(this.lastEvent), 20);
  }
}
function jg(i, e) {
  let t = i.state.facet(ia);
  return t.length ? t[0](e) : O.mac ? e.metaKey : e.ctrlKey;
}
function qg(i, e) {
  let t = i.state.facet(na);
  return t.length ? t[0](e) : O.mac ? !e.altKey : !e.ctrlKey;
}
function Kg(i, e) {
  let { main: t } = i.state.selection;
  if (t.empty)
    return !1;
  let n = mi(i.root);
  if (!n || n.rangeCount == 0)
    return !0;
  let r = n.getRangeAt(0).getClientRects();
  for (let o = 0; o < r.length; o++) {
    let s = r[o];
    if (s.left <= e.clientX && s.right >= e.clientX && s.top <= e.clientY && s.bottom >= e.clientY)
      return !0;
  }
  return !1;
}
function Ug(i, e) {
  if (!e.bubbles)
    return !0;
  if (e.defaultPrevented)
    return !1;
  for (let t = e.target, n; t != i.contentDOM; t = t.parentNode)
    if (!t || t.nodeType == 11 || (n = q.get(t)) && n.ignoreEvent(e))
      return !1;
  return !0;
}
const Pe = /* @__PURE__ */ Object.create(null), Me = /* @__PURE__ */ Object.create(null), xa = O.ie && O.ie_version < 15 || O.ios && O.webkit_version < 604;
function _g(i) {
  let e = i.dom.parentNode;
  if (!e)
    return;
  let t = e.appendChild(document.createElement("textarea"));
  t.style.cssText = "position: fixed; left: -10000px; top: 10px", t.focus(), setTimeout(() => {
    i.focus(), t.remove(), va(i, t.value);
  }, 50);
}
function gn(i, e, t) {
  for (let n of i.facet(e))
    t = n(t, i);
  return t;
}
function va(i, e) {
  e = gn(i.state, zr, e);
  let { state: t } = i, n, r = 1, o = t.toText(e), s = o.lines == t.selection.ranges.length;
  if (ur != null && t.selection.ranges.every((a) => a.empty) && ur == o.toString()) {
    let a = -1;
    n = t.changeByRange((c) => {
      let h = t.doc.lineAt(c.from);
      if (h.from == a)
        return { range: c };
      a = h.from;
      let d = t.toText((s ? o.line(r++).text : e) + t.lineBreak);
      return {
        changes: { from: h.from, insert: d },
        range: E.cursor(c.from + d.length)
      };
    });
  } else s ? n = t.changeByRange((a) => {
    let c = o.line(r++);
    return {
      changes: { from: a.from, to: a.to, insert: c.text },
      range: E.cursor(a.from + c.length)
    };
  }) : n = t.replaceSelection(o);
  i.dispatch(n, {
    userEvent: "input.paste",
    scrollIntoView: !0
  });
}
Me.scroll = (i) => {
  i.inputState.lastScrollTop = i.scrollDOM.scrollTop, i.inputState.lastScrollLeft = i.scrollDOM.scrollLeft;
};
Pe.keydown = (i, e) => (i.inputState.setSelectionOrigin("select"), e.keyCode == 27 && i.inputState.tabFocusMode != 0 && (i.inputState.tabFocusMode = Date.now() + 2e3), !1);
Me.touchstart = (i, e) => {
  i.inputState.lastTouchTime = Date.now(), i.inputState.setSelectionOrigin("select.pointer");
};
Me.touchmove = (i) => {
  i.inputState.setSelectionOrigin("select.pointer");
};
Pe.mousedown = (i, e) => {
  if (i.observer.flush(), i.inputState.lastTouchTime > Date.now() - 2e3)
    return !1;
  let t = null;
  for (let n of i.state.facet(ra))
    if (t = n(i, e), t)
      break;
  if (!t && e.button == 0 && (t = Xg(i, e)), t) {
    let n = !i.hasFocus;
    i.inputState.startMouseSelection(new Vg(i, e, t, n)), n && i.observer.ignore(() => {
      zl(i.contentDOM);
      let o = i.root.activeElement;
      o && !o.contains(i.contentDOM) && o.blur();
    });
    let r = i.inputState.mouseSelection;
    if (r)
      return r.start(e), r.dragging === !1;
  }
  return !1;
};
function Go(i, e, t, n) {
  if (n == 1)
    return E.cursor(e, t);
  if (n == 2)
    return vg(i.state, e, t);
  {
    let r = ie.find(i.docView, e), o = i.state.doc.lineAt(r ? r.posAtEnd : e), s = r ? r.posAtStart : o.from, l = r ? r.posAtEnd : o.to;
    return l < i.state.doc.length && l == o.to && l++, E.range(s, l);
  }
}
let Yo = (i, e, t) => e >= t.top && e <= t.bottom && i >= t.left && i <= t.right;
function Gg(i, e, t, n) {
  let r = ie.find(i.docView, e);
  if (!r)
    return 1;
  let o = e - r.posAtStart;
  if (o == 0)
    return 1;
  if (o == r.length)
    return -1;
  let s = r.coordsAt(o, -1);
  if (s && Yo(t, n, s))
    return -1;
  let l = r.coordsAt(o, 1);
  return l && Yo(t, n, l) ? 1 : s && s.bottom >= n ? -1 : 1;
}
function Xo(i, e) {
  let t = i.posAtCoords({ x: e.clientX, y: e.clientY }, !1);
  return { pos: t, bias: Gg(i, t, e.clientX, e.clientY) };
}
const Yg = O.ie && O.ie_version <= 11;
let Jo = null, Qo = 0, Zo = 0;
function Sa(i) {
  if (!Yg)
    return i.detail;
  let e = Jo, t = Zo;
  return Jo = i, Zo = Date.now(), Qo = !e || t > Date.now() - 400 && Math.abs(e.clientX - i.clientX) < 2 && Math.abs(e.clientY - i.clientY) < 2 ? (Qo + 1) % 3 : 1;
}
function Xg(i, e) {
  let t = Xo(i, e), n = Sa(e), r = i.state.selection;
  return {
    update(o) {
      o.docChanged && (t.pos = o.changes.mapPos(t.pos), r = r.map(o.changes));
    },
    get(o, s, l) {
      let a = Xo(i, o), c, h = Go(i, a.pos, a.bias, n);
      if (t.pos != a.pos && !s) {
        let d = Go(i, t.pos, t.bias, n), f = Math.min(d.from, h.from), g = Math.max(d.to, h.to);
        h = f < h.from ? E.range(f, g) : E.range(g, f);
      }
      return s ? r.replaceRange(r.main.extend(h.from, h.to)) : l && n == 1 && r.ranges.length > 1 && (c = Jg(r, a.pos)) ? c : l ? r.addRange(h) : E.create([h]);
    }
  };
}
function Jg(i, e) {
  for (let t = 0; t < i.ranges.length; t++) {
    let { from: n, to: r } = i.ranges[t];
    if (n <= e && r >= e)
      return E.create(i.ranges.slice(0, t).concat(i.ranges.slice(t + 1)), i.mainIndex == t ? 0 : i.mainIndex - (i.mainIndex > t ? 1 : 0));
  }
  return null;
}
Pe.dragstart = (i, e) => {
  let { selection: { main: t } } = i.state;
  if (e.target.draggable) {
    let r = i.docView.nearest(e.target);
    if (r && r.isWidget) {
      let o = r.posAtStart, s = o + r.length;
      (o >= t.to || s <= t.from) && (t = E.range(o, s));
    }
  }
  let { inputState: n } = i;
  return n.mouseSelection && (n.mouseSelection.dragging = !0), n.draggedContent = t, e.dataTransfer && (e.dataTransfer.setData("Text", gn(i.state, Nr, i.state.sliceDoc(t.from, t.to))), e.dataTransfer.effectAllowed = "copyMove"), !1;
};
Pe.dragend = (i) => (i.inputState.draggedContent = null, !1);
function es(i, e, t, n) {
  if (t = gn(i.state, zr, t), !t)
    return;
  let r = i.posAtCoords({ x: e.clientX, y: e.clientY }, !1), { draggedContent: o } = i.inputState, s = n && o && qg(i, e) ? { from: o.from, to: o.to } : null, l = { from: r, insert: t }, a = i.state.changes(s ? [s, l] : l);
  i.focus(), i.dispatch({
    changes: a,
    selection: { anchor: a.mapPos(r, -1), head: a.mapPos(r, 1) },
    userEvent: s ? "move.drop" : "input.drop"
  }), i.inputState.draggedContent = null;
}
Pe.drop = (i, e) => {
  if (!e.dataTransfer)
    return !1;
  if (i.state.readOnly)
    return !0;
  let t = e.dataTransfer.files;
  if (t && t.length) {
    let n = Array(t.length), r = 0, o = () => {
      ++r == t.length && es(i, e, n.filter((s) => s != null).join(i.state.lineBreak), !1);
    };
    for (let s = 0; s < t.length; s++) {
      let l = new FileReader();
      l.onerror = o, l.onload = () => {
        /[\x00-\x08\x0e-\x1f]{2}/.test(l.result) || (n[s] = l.result), o();
      }, l.readAsText(t[s]);
    }
    return !0;
  } else {
    let n = e.dataTransfer.getData("Text");
    if (n)
      return es(i, e, n, !0), !0;
  }
  return !1;
};
Pe.paste = (i, e) => {
  if (i.state.readOnly)
    return !0;
  i.observer.flush();
  let t = xa ? null : e.clipboardData;
  return t ? (va(i, t.getData("text/plain") || t.getData("text/uri-list")), !0) : (_g(i), !1);
};
function Qg(i, e) {
  let t = i.dom.parentNode;
  if (!t)
    return;
  let n = t.appendChild(document.createElement("textarea"));
  n.style.cssText = "position: fixed; left: -10000px; top: 10px", n.value = e, n.focus(), n.selectionEnd = e.length, n.selectionStart = 0, setTimeout(() => {
    n.remove(), i.focus();
  }, 50);
}
function Zg(i) {
  let e = [], t = [], n = !1;
  for (let r of i.selection.ranges)
    r.empty || (e.push(i.sliceDoc(r.from, r.to)), t.push(r));
  if (!e.length) {
    let r = -1;
    for (let { from: o } of i.selection.ranges) {
      let s = i.doc.lineAt(o);
      s.number > r && (e.push(s.text), t.push({ from: s.from, to: Math.min(i.doc.length, s.to + 1) })), r = s.number;
    }
    n = !0;
  }
  return { text: gn(i, Nr, e.join(i.lineBreak)), ranges: t, linewise: n };
}
let ur = null;
Pe.copy = Pe.cut = (i, e) => {
  let { text: t, ranges: n, linewise: r } = Zg(i.state);
  if (!t && !r)
    return !1;
  ur = r ? t : null, e.type == "cut" && !i.state.readOnly && i.dispatch({
    changes: n,
    scrollIntoView: !0,
    userEvent: "delete.cut"
  });
  let o = xa ? null : e.clipboardData;
  return o ? (o.clearData(), o.setData("text/plain", t), !0) : (Qg(i, t), !1);
};
const Ca = /* @__PURE__ */ Xt.define();
function ka(i, e) {
  let t = [];
  for (let n of i.facet(la)) {
    let r = n(i, e);
    r && t.push(r);
  }
  return t.length ? i.update({ effects: t, annotations: Ca.of(!0) }) : null;
}
function $a(i) {
  setTimeout(() => {
    let e = i.hasFocus;
    if (e != i.inputState.notifiedFocused) {
      let t = ka(i.state, e);
      t ? i.dispatch(t) : i.update([]);
    }
  }, 10);
}
Me.focus = (i) => {
  i.inputState.lastFocusTime = Date.now(), !i.scrollDOM.scrollTop && (i.inputState.lastScrollTop || i.inputState.lastScrollLeft) && (i.scrollDOM.scrollTop = i.inputState.lastScrollTop, i.scrollDOM.scrollLeft = i.inputState.lastScrollLeft), $a(i);
};
Me.blur = (i) => {
  i.observer.clearSelectionRange(), $a(i);
};
Me.compositionstart = Me.compositionupdate = (i) => {
  i.observer.editContext || (i.inputState.compositionFirstChange == null && (i.inputState.compositionFirstChange = !0), i.inputState.composing < 0 && (i.inputState.composing = 0));
};
Me.compositionend = (i) => {
  i.observer.editContext || (i.inputState.composing = -1, i.inputState.compositionEndedAt = Date.now(), i.inputState.compositionPendingKey = !0, i.inputState.compositionPendingChange = i.observer.pendingRecords().length > 0, i.inputState.compositionFirstChange = null, O.chrome && O.android ? i.observer.flushSoon() : i.inputState.compositionPendingChange ? Promise.resolve().then(() => i.observer.flush()) : setTimeout(() => {
    i.inputState.composing < 0 && i.docView.hasComposition && i.update([]);
  }, 50));
};
Me.contextmenu = (i) => {
  i.inputState.lastContextMenu = Date.now();
};
Pe.beforeinput = (i, e) => {
  var t, n;
  if (e.inputType == "insertReplacementText" && i.observer.editContext) {
    let o = (t = e.dataTransfer) === null || t === void 0 ? void 0 : t.getData("text/plain"), s = e.getTargetRanges();
    if (o && s.length) {
      let l = s[0], a = i.posAtDOM(l.startContainer, l.startOffset), c = i.posAtDOM(l.endContainer, l.endOffset);
      return Hr(i, { from: a, to: c, insert: i.state.toText(o) }, null), !0;
    }
  }
  let r;
  if (O.chrome && O.android && (r = wa.find((o) => o.inputType == e.inputType)) && (i.observer.delayAndroidKey(r.key, r.keyCode), r.key == "Backspace" || r.key == "Delete")) {
    let o = ((n = window.visualViewport) === null || n === void 0 ? void 0 : n.height) || 0;
    setTimeout(() => {
      var s;
      (((s = window.visualViewport) === null || s === void 0 ? void 0 : s.height) || 0) > o + 10 && i.hasFocus && (i.contentDOM.blur(), i.focus());
    }, 100);
  }
  return O.ios && e.inputType == "deleteContentForward" && i.observer.flushSoon(), O.safari && e.inputType == "insertText" && i.inputState.composing >= 0 && setTimeout(() => Me.compositionend(i, e), 20), !1;
};
const ts = /* @__PURE__ */ new Set();
function ep(i) {
  ts.has(i) || (ts.add(i), i.addEventListener("copy", () => {
  }), i.addEventListener("cut", () => {
  }));
}
const is = ["pre-wrap", "normal", "pre-line", "break-spaces"];
let Kt = !1;
function ns() {
  Kt = !1;
}
class tp {
  constructor(e) {
    this.lineWrapping = e, this.doc = W.empty, this.heightSamples = {}, this.lineHeight = 14, this.charWidth = 7, this.textHeight = 14, this.lineLength = 30;
  }
  heightForGap(e, t) {
    let n = this.doc.lineAt(t).number - this.doc.lineAt(e).number + 1;
    return this.lineWrapping && (n += Math.max(0, Math.ceil((t - e - n * this.lineLength * 0.5) / this.lineLength))), this.lineHeight * n;
  }
  heightForLine(e) {
    return this.lineWrapping ? (1 + Math.max(0, Math.ceil((e - this.lineLength) / Math.max(1, this.lineLength - 5)))) * this.lineHeight : this.lineHeight;
  }
  setDoc(e) {
    return this.doc = e, this;
  }
  mustRefreshForWrapping(e) {
    return is.indexOf(e) > -1 != this.lineWrapping;
  }
  mustRefreshForHeights(e) {
    let t = !1;
    for (let n = 0; n < e.length; n++) {
      let r = e[n];
      r < 0 ? n++ : this.heightSamples[Math.floor(r * 10)] || (t = !0, this.heightSamples[Math.floor(r * 10)] = !0);
    }
    return t;
  }
  refresh(e, t, n, r, o, s) {
    let l = is.indexOf(e) > -1, a = Math.round(t) != Math.round(this.lineHeight) || this.lineWrapping != l;
    if (this.lineWrapping = l, this.lineHeight = t, this.charWidth = n, this.textHeight = r, this.lineLength = o, a) {
      this.heightSamples = {};
      for (let c = 0; c < s.length; c++) {
        let h = s[c];
        h < 0 ? c++ : this.heightSamples[Math.floor(h * 10)] = !0;
      }
    }
    return a;
  }
}
class ip {
  constructor(e, t) {
    this.from = e, this.heights = t, this.index = 0;
  }
  get more() {
    return this.index < this.heights.length;
  }
}
class Fe {
  /**
  @internal
  */
  constructor(e, t, n, r, o) {
    this.from = e, this.length = t, this.top = n, this.height = r, this._content = o;
  }
  /**
  The type of element this is. When querying lines, this may be
  an array of all the blocks that make up the line.
  */
  get type() {
    return typeof this._content == "number" ? Ve.Text : Array.isArray(this._content) ? this._content : this._content.type;
  }
  /**
  The end of the element as a document position.
  */
  get to() {
    return this.from + this.length;
  }
  /**
  The bottom position of the element.
  */
  get bottom() {
    return this.top + this.height;
  }
  /**
  If this is a widget block, this will return the widget
  associated with it.
  */
  get widget() {
    return this._content instanceof st ? this._content.widget : null;
  }
  /**
  If this is a textblock, this holds the number of line breaks
  that appear in widgets inside the block.
  */
  get widgetLineBreaks() {
    return typeof this._content == "number" ? this._content : 0;
  }
  /**
  @internal
  */
  join(e) {
    let t = (Array.isArray(this._content) ? this._content : [this]).concat(Array.isArray(e._content) ? e._content : [e]);
    return new Fe(this.from, this.length + e.length, this.top, this.height + e.height, t);
  }
}
var _ = /* @__PURE__ */ function(i) {
  return i[i.ByPos = 0] = "ByPos", i[i.ByHeight = 1] = "ByHeight", i[i.ByPosNoHeight = 2] = "ByPosNoHeight", i;
}(_ || (_ = {}));
const Ui = 1e-3;
class we {
  constructor(e, t, n = 2) {
    this.length = e, this.height = t, this.flags = n;
  }
  get outdated() {
    return (this.flags & 2) > 0;
  }
  set outdated(e) {
    this.flags = (e ? 2 : 0) | this.flags & -3;
  }
  setHeight(e) {
    this.height != e && (Math.abs(this.height - e) > Ui && (Kt = !0), this.height = e);
  }
  // Base case is to replace a leaf node, which simply builds a tree
  // from the new nodes and returns that (HeightMapBranch and
  // HeightMapGap override this to actually use from/to)
  replace(e, t, n) {
    return we.of(n);
  }
  // Again, these are base cases, and are overridden for branch and gap nodes.
  decomposeLeft(e, t) {
    t.push(this);
  }
  decomposeRight(e, t) {
    t.push(this);
  }
  applyChanges(e, t, n, r) {
    let o = this, s = n.doc;
    for (let l = r.length - 1; l >= 0; l--) {
      let { fromA: a, toA: c, fromB: h, toB: d } = r[l], f = o.lineAt(a, _.ByPosNoHeight, n.setDoc(t), 0, 0), g = f.to >= c ? f : o.lineAt(c, _.ByPosNoHeight, n, 0, 0);
      for (d += g.to - c, c = g.to; l > 0 && f.from <= r[l - 1].toA; )
        a = r[l - 1].fromA, h = r[l - 1].fromB, l--, a < f.from && (f = o.lineAt(a, _.ByPosNoHeight, n, 0, 0));
      h += f.from - a, a = f.from;
      let p = Vr.build(n.setDoc(s), e, h, d);
      o = en(o, o.replace(a, c, p));
    }
    return o.updateHeight(n, 0);
  }
  static empty() {
    return new $e(0, 0);
  }
  // nodes uses null values to indicate the position of line breaks.
  // There are never line breaks at the start or end of the array, or
  // two line breaks next to each other, and the array isn't allowed
  // to be empty (same restrictions as return value from the builder).
  static of(e) {
    if (e.length == 1)
      return e[0];
    let t = 0, n = e.length, r = 0, o = 0;
    for (; ; )
      if (t == n)
        if (r > o * 2) {
          let l = e[t - 1];
          l.break ? e.splice(--t, 1, l.left, null, l.right) : e.splice(--t, 1, l.left, l.right), n += 1 + l.break, r -= l.size;
        } else if (o > r * 2) {
          let l = e[n];
          l.break ? e.splice(n, 1, l.left, null, l.right) : e.splice(n, 1, l.left, l.right), n += 2 + l.break, o -= l.size;
        } else
          break;
      else if (r < o) {
        let l = e[t++];
        l && (r += l.size);
      } else {
        let l = e[--n];
        l && (o += l.size);
      }
    let s = 0;
    return e[t - 1] == null ? (s = 1, t--) : e[t] == null && (s = 1, n++), new np(we.of(e.slice(0, t)), s, we.of(e.slice(n)));
  }
}
function en(i, e) {
  return i == e ? i : (i.constructor != e.constructor && (Kt = !0), e);
}
we.prototype.size = 1;
class Aa extends we {
  constructor(e, t, n) {
    super(e, t), this.deco = n;
  }
  blockAt(e, t, n, r) {
    return new Fe(r, this.length, n, this.height, this.deco || 0);
  }
  lineAt(e, t, n, r, o) {
    return this.blockAt(0, n, r, o);
  }
  forEachLine(e, t, n, r, o, s) {
    e <= o + this.length && t >= o && s(this.blockAt(0, n, r, o));
  }
  updateHeight(e, t = 0, n = !1, r) {
    return r && r.from <= t && r.more && this.setHeight(r.heights[r.index++]), this.outdated = !1, this;
  }
  toString() {
    return `block(${this.length})`;
  }
}
class $e extends Aa {
  constructor(e, t) {
    super(e, t, null), this.collapsed = 0, this.widgetHeight = 0, this.breaks = 0;
  }
  blockAt(e, t, n, r) {
    return new Fe(r, this.length, n, this.height, this.breaks);
  }
  replace(e, t, n) {
    let r = n[0];
    return n.length == 1 && (r instanceof $e || r instanceof ce && r.flags & 4) && Math.abs(this.length - r.length) < 10 ? (r instanceof ce ? r = new $e(r.length, this.height) : r.height = this.height, this.outdated || (r.outdated = !1), r) : we.of(n);
  }
  updateHeight(e, t = 0, n = !1, r) {
    return r && r.from <= t && r.more ? this.setHeight(r.heights[r.index++]) : (n || this.outdated) && this.setHeight(Math.max(this.widgetHeight, e.heightForLine(this.length - this.collapsed)) + this.breaks * e.lineHeight), this.outdated = !1, this;
  }
  toString() {
    return `line(${this.length}${this.collapsed ? -this.collapsed : ""}${this.widgetHeight ? ":" + this.widgetHeight : ""})`;
  }
}
class ce extends we {
  constructor(e) {
    super(e, 0);
  }
  heightMetrics(e, t) {
    let n = e.doc.lineAt(t).number, r = e.doc.lineAt(t + this.length).number, o = r - n + 1, s, l = 0;
    if (e.lineWrapping) {
      let a = Math.min(this.height, e.lineHeight * o);
      s = a / o, this.length > o + 1 && (l = (this.height - a) / (this.length - o - 1));
    } else
      s = this.height / o;
    return { firstLine: n, lastLine: r, perLine: s, perChar: l };
  }
  blockAt(e, t, n, r) {
    let { firstLine: o, lastLine: s, perLine: l, perChar: a } = this.heightMetrics(t, r);
    if (t.lineWrapping) {
      let c = r + (e < t.lineHeight ? 0 : Math.round(Math.max(0, Math.min(1, (e - n) / this.height)) * this.length)), h = t.doc.lineAt(c), d = l + h.length * a, f = Math.max(n, e - d / 2);
      return new Fe(h.from, h.length, f, d, 0);
    } else {
      let c = Math.max(0, Math.min(s - o, Math.floor((e - n) / l))), { from: h, length: d } = t.doc.line(o + c);
      return new Fe(h, d, n + l * c, l, 0);
    }
  }
  lineAt(e, t, n, r, o) {
    if (t == _.ByHeight)
      return this.blockAt(e, n, r, o);
    if (t == _.ByPosNoHeight) {
      let { from: g, to: p } = n.doc.lineAt(e);
      return new Fe(g, p - g, 0, 0, 0);
    }
    let { firstLine: s, perLine: l, perChar: a } = this.heightMetrics(n, o), c = n.doc.lineAt(e), h = l + c.length * a, d = c.number - s, f = r + l * d + a * (c.from - o - d);
    return new Fe(c.from, c.length, Math.max(r, Math.min(f, r + this.height - h)), h, 0);
  }
  forEachLine(e, t, n, r, o, s) {
    e = Math.max(e, o), t = Math.min(t, o + this.length);
    let { firstLine: l, perLine: a, perChar: c } = this.heightMetrics(n, o);
    for (let h = e, d = r; h <= t; ) {
      let f = n.doc.lineAt(h);
      if (h == e) {
        let p = f.number - l;
        d += a * p + c * (e - o - p);
      }
      let g = a + c * f.length;
      s(new Fe(f.from, f.length, d, g, 0)), d += g, h = f.to + 1;
    }
  }
  replace(e, t, n) {
    let r = this.length - t;
    if (r > 0) {
      let o = n[n.length - 1];
      o instanceof ce ? n[n.length - 1] = new ce(o.length + r) : n.push(null, new ce(r - 1));
    }
    if (e > 0) {
      let o = n[0];
      o instanceof ce ? n[0] = new ce(e + o.length) : n.unshift(new ce(e - 1), null);
    }
    return we.of(n);
  }
  decomposeLeft(e, t) {
    t.push(new ce(e - 1), null);
  }
  decomposeRight(e, t) {
    t.push(null, new ce(this.length - e - 1));
  }
  updateHeight(e, t = 0, n = !1, r) {
    let o = t + this.length;
    if (r && r.from <= t + this.length && r.more) {
      let s = [], l = Math.max(t, r.from), a = -1;
      for (r.from > t && s.push(new ce(r.from - t - 1).updateHeight(e, t)); l <= o && r.more; ) {
        let h = e.doc.lineAt(l).length;
        s.length && s.push(null);
        let d = r.heights[r.index++];
        a == -1 ? a = d : Math.abs(d - a) >= Ui && (a = -2);
        let f = new $e(h, d);
        f.outdated = !1, s.push(f), l += h + 1;
      }
      l <= o && s.push(null, new ce(o - l).updateHeight(e, l));
      let c = we.of(s);
      return (a < 0 || Math.abs(c.height - this.height) >= Ui || Math.abs(a - this.heightMetrics(e, t).perLine) >= Ui) && (Kt = !0), en(this, c);
    } else (n || this.outdated) && (this.setHeight(e.heightForGap(t, t + this.length)), this.outdated = !1);
    return this;
  }
  toString() {
    return `gap(${this.length})`;
  }
}
class np extends we {
  constructor(e, t, n) {
    super(e.length + t + n.length, e.height + n.height, t | (e.outdated || n.outdated ? 2 : 0)), this.left = e, this.right = n, this.size = e.size + n.size;
  }
  get break() {
    return this.flags & 1;
  }
  blockAt(e, t, n, r) {
    let o = n + this.left.height;
    return e < o ? this.left.blockAt(e, t, n, r) : this.right.blockAt(e, t, o, r + this.left.length + this.break);
  }
  lineAt(e, t, n, r, o) {
    let s = r + this.left.height, l = o + this.left.length + this.break, a = t == _.ByHeight ? e < s : e < l, c = a ? this.left.lineAt(e, t, n, r, o) : this.right.lineAt(e, t, n, s, l);
    if (this.break || (a ? c.to < l : c.from > l))
      return c;
    let h = t == _.ByPosNoHeight ? _.ByPosNoHeight : _.ByPos;
    return a ? c.join(this.right.lineAt(l, h, n, s, l)) : this.left.lineAt(l, h, n, r, o).join(c);
  }
  forEachLine(e, t, n, r, o, s) {
    let l = r + this.left.height, a = o + this.left.length + this.break;
    if (this.break)
      e < a && this.left.forEachLine(e, t, n, r, o, s), t >= a && this.right.forEachLine(e, t, n, l, a, s);
    else {
      let c = this.lineAt(a, _.ByPos, n, r, o);
      e < c.from && this.left.forEachLine(e, c.from - 1, n, r, o, s), c.to >= e && c.from <= t && s(c), t > c.to && this.right.forEachLine(c.to + 1, t, n, l, a, s);
    }
  }
  replace(e, t, n) {
    let r = this.left.length + this.break;
    if (t < r)
      return this.balanced(this.left.replace(e, t, n), this.right);
    if (e > this.left.length)
      return this.balanced(this.left, this.right.replace(e - r, t - r, n));
    let o = [];
    e > 0 && this.decomposeLeft(e, o);
    let s = o.length;
    for (let l of n)
      o.push(l);
    if (e > 0 && rs(o, s - 1), t < this.length) {
      let l = o.length;
      this.decomposeRight(t, o), rs(o, l);
    }
    return we.of(o);
  }
  decomposeLeft(e, t) {
    let n = this.left.length;
    if (e <= n)
      return this.left.decomposeLeft(e, t);
    t.push(this.left), this.break && (n++, e >= n && t.push(null)), e > n && this.right.decomposeLeft(e - n, t);
  }
  decomposeRight(e, t) {
    let n = this.left.length, r = n + this.break;
    if (e >= r)
      return this.right.decomposeRight(e - r, t);
    e < n && this.left.decomposeRight(e, t), this.break && e < r && t.push(null), t.push(this.right);
  }
  balanced(e, t) {
    return e.size > 2 * t.size || t.size > 2 * e.size ? we.of(this.break ? [e, null, t] : [e, t]) : (this.left = en(this.left, e), this.right = en(this.right, t), this.setHeight(e.height + t.height), this.outdated = e.outdated || t.outdated, this.size = e.size + t.size, this.length = e.length + this.break + t.length, this);
  }
  updateHeight(e, t = 0, n = !1, r) {
    let { left: o, right: s } = this, l = t + o.length + this.break, a = null;
    return r && r.from <= t + o.length && r.more ? a = o = o.updateHeight(e, t, n, r) : o.updateHeight(e, t, n), r && r.from <= l + s.length && r.more ? a = s = s.updateHeight(e, l, n, r) : s.updateHeight(e, l, n), a ? this.balanced(o, s) : (this.height = this.left.height + this.right.height, this.outdated = !1, this);
  }
  toString() {
    return this.left + (this.break ? " " : "-") + this.right;
  }
}
function rs(i, e) {
  let t, n;
  i[e] == null && (t = i[e - 1]) instanceof ce && (n = i[e + 1]) instanceof ce && i.splice(e - 1, 3, new ce(t.length + 1 + n.length));
}
const rp = 5;
class Vr {
  constructor(e, t) {
    this.pos = e, this.oracle = t, this.nodes = [], this.lineStart = -1, this.lineEnd = -1, this.covering = null, this.writtenTo = e;
  }
  get isCovered() {
    return this.covering && this.nodes[this.nodes.length - 1] == this.covering;
  }
  span(e, t) {
    if (this.lineStart > -1) {
      let n = Math.min(t, this.lineEnd), r = this.nodes[this.nodes.length - 1];
      r instanceof $e ? r.length += n - this.pos : (n > this.pos || !this.isCovered) && this.nodes.push(new $e(n - this.pos, -1)), this.writtenTo = n, t > n && (this.nodes.push(null), this.writtenTo++, this.lineStart = -1);
    }
    this.pos = t;
  }
  point(e, t, n) {
    if (e < t || n.heightRelevant) {
      let r = n.widget ? n.widget.estimatedHeight : 0, o = n.widget ? n.widget.lineBreaks : 0;
      r < 0 && (r = this.oracle.lineHeight);
      let s = t - e;
      n.block ? this.addBlock(new Aa(s, r, n)) : (s || o || r >= rp) && this.addLineDeco(r, o, s);
    } else t > e && this.span(e, t);
    this.lineEnd > -1 && this.lineEnd < this.pos && (this.lineEnd = this.oracle.doc.lineAt(this.pos).to);
  }
  enterLine() {
    if (this.lineStart > -1)
      return;
    let { from: e, to: t } = this.oracle.doc.lineAt(this.pos);
    this.lineStart = e, this.lineEnd = t, this.writtenTo < e && ((this.writtenTo < e - 1 || this.nodes[this.nodes.length - 1] == null) && this.nodes.push(this.blankContent(this.writtenTo, e - 1)), this.nodes.push(null)), this.pos > e && this.nodes.push(new $e(this.pos - e, -1)), this.writtenTo = this.pos;
  }
  blankContent(e, t) {
    let n = new ce(t - e);
    return this.oracle.doc.lineAt(e).to == t && (n.flags |= 4), n;
  }
  ensureLine() {
    this.enterLine();
    let e = this.nodes.length ? this.nodes[this.nodes.length - 1] : null;
    if (e instanceof $e)
      return e;
    let t = new $e(0, -1);
    return this.nodes.push(t), t;
  }
  addBlock(e) {
    this.enterLine();
    let t = e.deco;
    t && t.startSide > 0 && !this.isCovered && this.ensureLine(), this.nodes.push(e), this.writtenTo = this.pos = this.pos + e.length, t && t.endSide > 0 && (this.covering = e);
  }
  addLineDeco(e, t, n) {
    let r = this.ensureLine();
    r.length += n, r.collapsed += n, r.widgetHeight = Math.max(r.widgetHeight, e), r.breaks += t, this.writtenTo = this.pos = this.pos + n;
  }
  finish(e) {
    let t = this.nodes.length == 0 ? null : this.nodes[this.nodes.length - 1];
    this.lineStart > -1 && !(t instanceof $e) && !this.isCovered ? this.nodes.push(new $e(0, -1)) : (this.writtenTo < this.pos || t == null) && this.nodes.push(this.blankContent(this.writtenTo, this.pos));
    let n = e;
    for (let r of this.nodes)
      r instanceof $e && r.updateHeight(this.oracle, n), n += r ? r.length : 1;
    return this.nodes;
  }
  // Always called with a region that on both sides either stretches
  // to a line break or the end of the document.
  // The returned array uses null to indicate line breaks, but never
  // starts or ends in a line break, or has multiple line breaks next
  // to each other.
  static build(e, t, n, r) {
    let o = new Vr(n, e);
    return X.spans(t, n, r, o, 0), o.finish(n);
  }
}
function op(i, e, t) {
  let n = new sp();
  return X.compare(i, e, t, n, 0), n.changes;
}
class sp {
  constructor() {
    this.changes = [];
  }
  compareRange() {
  }
  comparePoint(e, t, n, r) {
    (e < t || n && n.heightRelevant || r && r.heightRelevant) && qi(e, t, this.changes, 5);
  }
}
function lp(i, e) {
  let t = i.getBoundingClientRect(), n = i.ownerDocument, r = n.defaultView || window, o = Math.max(0, t.left), s = Math.min(r.innerWidth, t.right), l = Math.max(0, t.top), a = Math.min(r.innerHeight, t.bottom);
  for (let c = i.parentNode; c && c != n.body; )
    if (c.nodeType == 1) {
      let h = c, d = window.getComputedStyle(h);
      if ((h.scrollHeight > h.clientHeight || h.scrollWidth > h.clientWidth) && d.overflow != "visible") {
        let f = h.getBoundingClientRect();
        o = Math.max(o, f.left), s = Math.min(s, f.right), l = Math.max(l, f.top), a = Math.min(c == i.parentNode ? r.innerHeight : a, f.bottom);
      }
      c = d.position == "absolute" || d.position == "fixed" ? h.offsetParent : h.parentNode;
    } else if (c.nodeType == 11)
      c = c.host;
    else
      break;
  return {
    left: o - t.left,
    right: Math.max(o, s) - t.left,
    top: l - (t.top + e),
    bottom: Math.max(l, a) - (t.top + e)
  };
}
function ap(i) {
  let e = i.getBoundingClientRect(), t = i.ownerDocument.defaultView || window;
  return e.left < t.innerWidth && e.right > 0 && e.top < t.innerHeight && e.bottom > 0;
}
function hp(i, e) {
  let t = i.getBoundingClientRect();
  return {
    left: 0,
    right: t.right - t.left,
    top: e,
    bottom: t.bottom - (t.top + e)
  };
}
class An {
  constructor(e, t, n, r) {
    this.from = e, this.to = t, this.size = n, this.displaySize = r;
  }
  static same(e, t) {
    if (e.length != t.length)
      return !1;
    for (let n = 0; n < e.length; n++) {
      let r = e[n], o = t[n];
      if (r.from != o.from || r.to != o.to || r.size != o.size)
        return !1;
    }
    return !0;
  }
  draw(e, t) {
    return ye.replace({
      widget: new cp(this.displaySize * (t ? e.scaleY : e.scaleX), t)
    }).range(this.from, this.to);
  }
}
class cp extends Lr {
  constructor(e, t) {
    super(), this.size = e, this.vertical = t;
  }
  eq(e) {
    return e.size == this.size && e.vertical == this.vertical;
  }
  toDOM() {
    let e = document.createElement("div");
    return this.vertical ? e.style.height = this.size + "px" : (e.style.width = this.size + "px", e.style.height = "2px", e.style.display = "inline-block"), e;
  }
  get estimatedHeight() {
    return this.vertical ? this.size : -1;
  }
}
class os {
  constructor(e) {
    this.state = e, this.pixelViewport = { left: 0, right: window.innerWidth, top: 0, bottom: 0 }, this.inView = !0, this.paddingTop = 0, this.paddingBottom = 0, this.contentDOMWidth = 0, this.contentDOMHeight = 0, this.editorHeight = 0, this.editorWidth = 0, this.scrollTop = 0, this.scrolledToBottom = !1, this.scaleX = 1, this.scaleY = 1, this.scrollAnchorPos = 0, this.scrollAnchorHeight = -1, this.scaler = ss, this.scrollTarget = null, this.printing = !1, this.mustMeasureContent = !0, this.defaultTextDirection = be.LTR, this.visibleRanges = [], this.mustEnforceCursorAssoc = !1;
    let t = e.facet(Fr).some((n) => typeof n != "function" && n.class == "cm-lineWrapping");
    this.heightOracle = new tp(t), this.stateDeco = e.facet(wi).filter((n) => typeof n != "function"), this.heightMap = we.empty().applyChanges(this.stateDeco, W.empty, this.heightOracle.setDoc(e.doc), [new Re(0, 0, 0, e.doc.length)]);
    for (let n = 0; n < 2 && (this.viewport = this.getViewport(0, null), !!this.updateForViewport()); n++)
      ;
    this.updateViewportLines(), this.lineGaps = this.ensureLineGaps([]), this.lineGapDeco = ye.set(this.lineGaps.map((n) => n.draw(this, !1))), this.computeVisibleRanges();
  }
  updateForViewport() {
    let e = [this.viewport], { main: t } = this.state.selection;
    for (let n = 0; n <= 1; n++) {
      let r = n ? t.head : t.anchor;
      if (!e.some(({ from: o, to: s }) => r >= o && r <= s)) {
        let { from: o, to: s } = this.lineBlockAt(r);
        e.push(new Bi(o, s));
      }
    }
    return this.viewports = e.sort((n, r) => n.from - r.from), this.updateScaler();
  }
  updateScaler() {
    let e = this.scaler;
    return this.scaler = this.heightMap.height <= 7e6 ? ss : new jr(this.heightOracle, this.heightMap, this.viewports), e.eq(this.scaler) ? 0 : 2;
  }
  updateViewportLines() {
    this.viewportLines = [], this.heightMap.forEachLine(this.viewport.from, this.viewport.to, this.heightOracle.setDoc(this.state.doc), 0, 0, (e) => {
      this.viewportLines.push(si(e, this.scaler));
    });
  }
  update(e, t = null) {
    this.state = e.state;
    let n = this.stateDeco;
    this.stateDeco = this.state.facet(wi).filter((h) => typeof h != "function");
    let r = e.changedRanges, o = Re.extendWithRanges(r, op(n, this.stateDeco, e ? e.changes : he.empty(this.state.doc.length))), s = this.heightMap.height, l = this.scrolledToBottom ? null : this.scrollAnchorAt(this.scrollTop);
    ns(), this.heightMap = this.heightMap.applyChanges(this.stateDeco, e.startState.doc, this.heightOracle.setDoc(this.state.doc), o), (this.heightMap.height != s || Kt) && (e.flags |= 2), l ? (this.scrollAnchorPos = e.changes.mapPos(l.from, -1), this.scrollAnchorHeight = l.top) : (this.scrollAnchorPos = -1, this.scrollAnchorHeight = s);
    let a = o.length ? this.mapViewport(this.viewport, e.changes) : this.viewport;
    (t && (t.range.head < a.from || t.range.head > a.to) || !this.viewportIsAppropriate(a)) && (a = this.getViewport(0, t));
    let c = a.from != this.viewport.from || a.to != this.viewport.to;
    this.viewport = a, e.flags |= this.updateForViewport(), (c || !e.changes.empty || e.flags & 2) && this.updateViewportLines(), (this.lineGaps.length || this.viewport.to - this.viewport.from > 4e3) && this.updateLineGaps(this.ensureLineGaps(this.mapLineGaps(this.lineGaps, e.changes))), e.flags |= this.computeVisibleRanges(e.changes), t && (this.scrollTarget = t), !this.mustEnforceCursorAssoc && e.selectionSet && e.view.lineWrapping && e.state.selection.main.empty && e.state.selection.main.assoc && !e.state.facet(ug) && (this.mustEnforceCursorAssoc = !0);
  }
  measure(e) {
    let t = e.contentDOM, n = window.getComputedStyle(t), r = this.heightOracle, o = n.whiteSpace;
    this.defaultTextDirection = n.direction == "rtl" ? be.RTL : be.LTR;
    let s = this.heightOracle.mustRefreshForWrapping(o), l = t.getBoundingClientRect(), a = s || this.mustMeasureContent || this.contentDOMHeight != l.height;
    this.contentDOMHeight = l.height, this.mustMeasureContent = !1;
    let c = 0, h = 0;
    if (l.width && l.height) {
      let { scaleX: C, scaleY: A } = Bl(t, l);
      (C > 5e-3 && Math.abs(this.scaleX - C) > 5e-3 || A > 5e-3 && Math.abs(this.scaleY - A) > 5e-3) && (this.scaleX = C, this.scaleY = A, c |= 16, s = a = !0);
    }
    let d = (parseInt(n.paddingTop) || 0) * this.scaleY, f = (parseInt(n.paddingBottom) || 0) * this.scaleY;
    (this.paddingTop != d || this.paddingBottom != f) && (this.paddingTop = d, this.paddingBottom = f, c |= 18), this.editorWidth != e.scrollDOM.clientWidth && (r.lineWrapping && (a = !0), this.editorWidth = e.scrollDOM.clientWidth, c |= 16);
    let g = e.scrollDOM.scrollTop * this.scaleY;
    this.scrollTop != g && (this.scrollAnchorHeight = -1, this.scrollTop = g), this.scrolledToBottom = Fl(e.scrollDOM);
    let p = (this.printing ? hp : lp)(t, this.paddingTop), b = p.top - this.pixelViewport.top, w = p.bottom - this.pixelViewport.bottom;
    this.pixelViewport = p;
    let y = this.pixelViewport.bottom > this.pixelViewport.top && this.pixelViewport.right > this.pixelViewport.left;
    if (y != this.inView && (this.inView = y, y && (a = !0)), !this.inView && !this.scrollTarget && !ap(e.dom))
      return 0;
    let v = l.width;
    if ((this.contentDOMWidth != v || this.editorHeight != e.scrollDOM.clientHeight) && (this.contentDOMWidth = l.width, this.editorHeight = e.scrollDOM.clientHeight, c |= 16), a) {
      let C = e.docView.measureVisibleLineHeights(this.viewport);
      if (r.mustRefreshForHeights(C) && (s = !0), s || r.lineWrapping && Math.abs(v - this.contentDOMWidth) > r.charWidth) {
        let { lineHeight: A, charWidth: S, textHeight: M } = e.docView.measureTextSize();
        s = A > 0 && r.refresh(o, A, S, M, Math.max(5, v / S), C), s && (e.docView.minWidth = 0, c |= 16);
      }
      b > 0 && w > 0 ? h = Math.max(b, w) : b < 0 && w < 0 && (h = Math.min(b, w)), ns();
      for (let A of this.viewports) {
        let S = A.from == this.viewport.from ? C : e.docView.measureVisibleLineHeights(A);
        this.heightMap = (s ? we.empty().applyChanges(this.stateDeco, W.empty, this.heightOracle, [new Re(0, 0, 0, e.state.doc.length)]) : this.heightMap).updateHeight(r, 0, s, new ip(A.from, S));
      }
      Kt && (c |= 2);
    }
    let k = !this.viewportIsAppropriate(this.viewport, h) || this.scrollTarget && (this.scrollTarget.range.head < this.viewport.from || this.scrollTarget.range.head > this.viewport.to);
    return k && (c & 2 && (c |= this.updateScaler()), this.viewport = this.getViewport(h, this.scrollTarget), c |= this.updateForViewport()), (c & 2 || k) && this.updateViewportLines(), (this.lineGaps.length || this.viewport.to - this.viewport.from > 4e3) && this.updateLineGaps(this.ensureLineGaps(s ? [] : this.lineGaps, e)), c |= this.computeVisibleRanges(), this.mustEnforceCursorAssoc && (this.mustEnforceCursorAssoc = !1, e.docView.enforceCursorAssoc()), c;
  }
  get visibleTop() {
    return this.scaler.fromDOM(this.pixelViewport.top);
  }
  get visibleBottom() {
    return this.scaler.fromDOM(this.pixelViewport.bottom);
  }
  getViewport(e, t) {
    let n = 0.5 - Math.max(-0.5, Math.min(0.5, e / 1e3 / 2)), r = this.heightMap, o = this.heightOracle, { visibleTop: s, visibleBottom: l } = this, a = new Bi(r.lineAt(s - n * 1e3, _.ByHeight, o, 0, 0).from, r.lineAt(l + (1 - n) * 1e3, _.ByHeight, o, 0, 0).to);
    if (t) {
      let { head: c } = t.range;
      if (c < a.from || c > a.to) {
        let h = Math.min(this.editorHeight, this.pixelViewport.bottom - this.pixelViewport.top), d = r.lineAt(c, _.ByPos, o, 0, 0), f;
        t.y == "center" ? f = (d.top + d.bottom) / 2 - h / 2 : t.y == "start" || t.y == "nearest" && c < a.from ? f = d.top : f = d.bottom - h, a = new Bi(r.lineAt(f - 1e3 / 2, _.ByHeight, o, 0, 0).from, r.lineAt(f + h + 1e3 / 2, _.ByHeight, o, 0, 0).to);
      }
    }
    return a;
  }
  mapViewport(e, t) {
    let n = t.mapPos(e.from, -1), r = t.mapPos(e.to, 1);
    return new Bi(this.heightMap.lineAt(n, _.ByPos, this.heightOracle, 0, 0).from, this.heightMap.lineAt(r, _.ByPos, this.heightOracle, 0, 0).to);
  }
  // Checks if a given viewport covers the visible part of the
  // document and not too much beyond that.
  viewportIsAppropriate({ from: e, to: t }, n = 0) {
    if (!this.inView)
      return !0;
    let { top: r } = this.heightMap.lineAt(e, _.ByPos, this.heightOracle, 0, 0), { bottom: o } = this.heightMap.lineAt(t, _.ByPos, this.heightOracle, 0, 0), { visibleTop: s, visibleBottom: l } = this;
    return (e == 0 || r <= s - Math.max(10, Math.min(
      -n,
      250
      /* VP.MaxCoverMargin */
    ))) && (t == this.state.doc.length || o >= l + Math.max(10, Math.min(
      n,
      250
      /* VP.MaxCoverMargin */
    ))) && r > s - 2 * 1e3 && o < l + 2 * 1e3;
  }
  mapLineGaps(e, t) {
    if (!e.length || t.empty)
      return e;
    let n = [];
    for (let r of e)
      t.touchesRange(r.from, r.to) || n.push(new An(t.mapPos(r.from), t.mapPos(r.to), r.size, r.displaySize));
    return n;
  }
  // Computes positions in the viewport where the start or end of a
  // line should be hidden, trying to reuse existing line gaps when
  // appropriate to avoid unneccesary redraws.
  // Uses crude character-counting for the positioning and sizing,
  // since actual DOM coordinates aren't always available and
  // predictable. Relies on generous margins (see LG.Margin) to hide
  // the artifacts this might produce from the user.
  ensureLineGaps(e, t) {
    let n = this.heightOracle.lineWrapping, r = n ? 1e4 : 2e3, o = r >> 1, s = r << 1;
    if (this.defaultTextDirection != be.LTR && !n)
      return [];
    let l = [], a = (h, d, f, g) => {
      if (d - h < o)
        return;
      let p = this.state.selection.main, b = [p.from];
      p.empty || b.push(p.to);
      for (let y of b)
        if (y > h && y < d) {
          a(h, y - 10, f, g), a(y + 10, d, f, g);
          return;
        }
      let w = up(e, (y) => y.from >= f.from && y.to <= f.to && Math.abs(y.from - h) < o && Math.abs(y.to - d) < o && !b.some((v) => y.from < v && y.to > v));
      if (!w) {
        if (d < f.to && t && n && t.visibleRanges.some((k) => k.from <= d && k.to >= d)) {
          let k = t.moveToLineBoundary(E.cursor(d), !1, !0).head;
          k > h && (d = k);
        }
        let y = this.gapSize(f, h, d, g), v = n || y < 2e6 ? y : 2e6;
        w = new An(h, d, y, v);
      }
      l.push(w);
    }, c = (h) => {
      if (h.length < s || h.type != Ve.Text)
        return;
      let d = dp(h.from, h.to, this.stateDeco);
      if (d.total < s)
        return;
      let f = this.scrollTarget ? this.scrollTarget.range.head : null, g, p;
      if (n) {
        let b = r / this.heightOracle.lineLength * this.heightOracle.lineHeight, w, y;
        if (f != null) {
          let v = Ni(d, f), k = ((this.visibleBottom - this.visibleTop) / 2 + b) / h.height;
          w = v - k, y = v + k;
        } else
          w = (this.visibleTop - h.top - b) / h.height, y = (this.visibleBottom - h.top + b) / h.height;
        g = zi(d, w), p = zi(d, y);
      } else {
        let b = d.total * this.heightOracle.charWidth, w = r * this.heightOracle.charWidth, y = 0;
        if (b > 2e6)
          for (let S of e)
            S.from >= h.from && S.from < h.to && S.size != S.displaySize && S.from * this.heightOracle.charWidth + y < this.pixelViewport.left && (y = S.size - S.displaySize);
        let v = this.pixelViewport.left + y, k = this.pixelViewport.right + y, C, A;
        if (f != null) {
          let S = Ni(d, f), M = ((k - v) / 2 + w) / b;
          C = S - M, A = S + M;
        } else
          C = (v - w) / b, A = (k + w) / b;
        g = zi(d, C), p = zi(d, A);
      }
      g > h.from && a(h.from, g, h, d), p < h.to && a(p, h.to, h, d);
    };
    for (let h of this.viewportLines)
      Array.isArray(h.type) ? h.type.forEach(c) : c(h);
    return l;
  }
  gapSize(e, t, n, r) {
    let o = Ni(r, n) - Ni(r, t);
    return this.heightOracle.lineWrapping ? e.height * o : r.total * this.heightOracle.charWidth * o;
  }
  updateLineGaps(e) {
    An.same(e, this.lineGaps) || (this.lineGaps = e, this.lineGapDeco = ye.set(e.map((t) => t.draw(this, this.heightOracle.lineWrapping))));
  }
  computeVisibleRanges(e) {
    let t = this.stateDeco;
    this.lineGaps.length && (t = t.concat(this.lineGapDeco));
    let n = [];
    X.spans(t, this.viewport.from, this.viewport.to, {
      span(o, s) {
        n.push({ from: o, to: s });
      },
      point() {
      }
    }, 20);
    let r = 0;
    if (n.length != this.visibleRanges.length)
      r = 12;
    else
      for (let o = 0; o < n.length && !(r & 8); o++) {
        let s = this.visibleRanges[o], l = n[o];
        (s.from != l.from || s.to != l.to) && (r |= 4, e && e.mapPos(s.from, -1) == l.from && e.mapPos(s.to, 1) == l.to || (r |= 8));
      }
    return this.visibleRanges = n, r;
  }
  lineBlockAt(e) {
    return e >= this.viewport.from && e <= this.viewport.to && this.viewportLines.find((t) => t.from <= e && t.to >= e) || si(this.heightMap.lineAt(e, _.ByPos, this.heightOracle, 0, 0), this.scaler);
  }
  lineBlockAtHeight(e) {
    return e >= this.viewportLines[0].top && e <= this.viewportLines[this.viewportLines.length - 1].bottom && this.viewportLines.find((t) => t.top <= e && t.bottom >= e) || si(this.heightMap.lineAt(this.scaler.fromDOM(e), _.ByHeight, this.heightOracle, 0, 0), this.scaler);
  }
  scrollAnchorAt(e) {
    let t = this.lineBlockAtHeight(e + 8);
    return t.from >= this.viewport.from || this.viewportLines[0].top - e > 200 ? t : this.viewportLines[0];
  }
  elementAtHeight(e) {
    return si(this.heightMap.blockAt(this.scaler.fromDOM(e), this.heightOracle, 0, 0), this.scaler);
  }
  get docHeight() {
    return this.scaler.toDOM(this.heightMap.height);
  }
  get contentHeight() {
    return this.docHeight + this.paddingTop + this.paddingBottom;
  }
}
class Bi {
  constructor(e, t) {
    this.from = e, this.to = t;
  }
}
function dp(i, e, t) {
  let n = [], r = i, o = 0;
  return X.spans(t, i, e, {
    span() {
    },
    point(s, l) {
      s > r && (n.push({ from: r, to: s }), o += s - r), r = l;
    }
  }, 20), r < e && (n.push({ from: r, to: e }), o += e - r), { total: o, ranges: n };
}
function zi({ total: i, ranges: e }, t) {
  if (t <= 0)
    return e[0].from;
  if (t >= 1)
    return e[e.length - 1].to;
  let n = Math.floor(i * t);
  for (let r = 0; ; r++) {
    let { from: o, to: s } = e[r], l = s - o;
    if (n <= l)
      return o + n;
    n -= l;
  }
}
function Ni(i, e) {
  let t = 0;
  for (let { from: n, to: r } of i.ranges) {
    if (e <= r) {
      t += e - n;
      break;
    }
    t += r - n;
  }
  return t / i.total;
}
function up(i, e) {
  for (let t of i)
    if (e(t))
      return t;
}
const ss = {
  toDOM(i) {
    return i;
  },
  fromDOM(i) {
    return i;
  },
  scale: 1,
  eq(i) {
    return i == this;
  }
};
class jr {
  constructor(e, t, n) {
    let r = 0, o = 0, s = 0;
    this.viewports = n.map(({ from: l, to: a }) => {
      let c = t.lineAt(l, _.ByPos, e, 0, 0).top, h = t.lineAt(a, _.ByPos, e, 0, 0).bottom;
      return r += h - c, { from: l, to: a, top: c, bottom: h, domTop: 0, domBottom: 0 };
    }), this.scale = (7e6 - r) / (t.height - r);
    for (let l of this.viewports)
      l.domTop = s + (l.top - o) * this.scale, s = l.domBottom = l.domTop + (l.bottom - l.top), o = l.bottom;
  }
  toDOM(e) {
    for (let t = 0, n = 0, r = 0; ; t++) {
      let o = t < this.viewports.length ? this.viewports[t] : null;
      if (!o || e < o.top)
        return r + (e - n) * this.scale;
      if (e <= o.bottom)
        return o.domTop + (e - o.top);
      n = o.bottom, r = o.domBottom;
    }
  }
  fromDOM(e) {
    for (let t = 0, n = 0, r = 0; ; t++) {
      let o = t < this.viewports.length ? this.viewports[t] : null;
      if (!o || e < o.domTop)
        return n + (e - r) / this.scale;
      if (e <= o.domBottom)
        return o.top + (e - o.domTop);
      n = o.bottom, r = o.domBottom;
    }
  }
  eq(e) {
    return e instanceof jr ? this.scale == e.scale && this.viewports.length == e.viewports.length && this.viewports.every((t, n) => t.from == e.viewports[n].from && t.to == e.viewports[n].to) : !1;
  }
}
function si(i, e) {
  if (e.scale == 1)
    return i;
  let t = e.toDOM(i.top), n = e.toDOM(i.bottom);
  return new Fe(i.from, i.length, t, n - t, Array.isArray(i._content) ? i._content.map((r) => si(r, e)) : i._content);
}
const Fi = /* @__PURE__ */ P.define({ combine: (i) => i.join(" ") }), fr = /* @__PURE__ */ P.define({ combine: (i) => i.indexOf(!0) > -1 }), gr = /* @__PURE__ */ Ht.newName(), Ta = /* @__PURE__ */ Ht.newName(), Ra = /* @__PURE__ */ Ht.newName(), Ma = { "&light": "." + Ta, "&dark": "." + Ra };
function pr(i, e, t) {
  return new Ht(e, {
    finish(n) {
      return /&/.test(n) ? n.replace(/&\w*/, (r) => {
        if (r == "&")
          return i;
        if (!t || !t[r])
          throw new RangeError(`Unsupported selector: ${r}`);
        return t[r];
      }) : i + " " + n;
    }
  });
}
const fp = /* @__PURE__ */ pr("." + gr, {
  "&": {
    position: "relative !important",
    boxSizing: "border-box",
    "&.cm-focused": {
      // Provide a simple default outline to make sure a focused
      // editor is visually distinct. Can't leave the default behavior
      // because that will apply to the content element, which is
      // inside the scrollable container and doesn't include the
      // gutters. We also can't use an 'auto' outline, since those
      // are, for some reason, drawn behind the element content, which
      // will cause things like the active line background to cover
      // the outline (#297).
      outline: "1px dotted #212121"
    },
    display: "flex !important",
    flexDirection: "column"
  },
  ".cm-scroller": {
    display: "flex !important",
    alignItems: "flex-start !important",
    fontFamily: "monospace",
    lineHeight: 1.4,
    height: "100%",
    overflowX: "auto",
    position: "relative",
    zIndex: 0,
    overflowAnchor: "none"
  },
  ".cm-content": {
    margin: 0,
    flexGrow: 2,
    flexShrink: 0,
    display: "block",
    whiteSpace: "pre",
    wordWrap: "normal",
    // https://github.com/codemirror/dev/issues/456
    boxSizing: "border-box",
    minHeight: "100%",
    padding: "4px 0",
    outline: "none",
    "&[contenteditable=true]": {
      WebkitUserModify: "read-write-plaintext-only"
    }
  },
  ".cm-lineWrapping": {
    whiteSpace_fallback: "pre-wrap",
    // For IE
    whiteSpace: "break-spaces",
    wordBreak: "break-word",
    // For Safari, which doesn't support overflow-wrap: anywhere
    overflowWrap: "anywhere",
    flexShrink: 1
  },
  "&light .cm-content": { caretColor: "black" },
  "&dark .cm-content": { caretColor: "white" },
  ".cm-line": {
    display: "block",
    padding: "0 2px 0 6px"
  },
  ".cm-layer": {
    position: "absolute",
    left: 0,
    top: 0,
    contain: "size style",
    "& > *": {
      position: "absolute"
    }
  },
  "&light .cm-selectionBackground": {
    background: "#d9d9d9"
  },
  "&dark .cm-selectionBackground": {
    background: "#222"
  },
  "&light.cm-focused > .cm-scroller > .cm-selectionLayer .cm-selectionBackground": {
    background: "#d7d4f0"
  },
  "&dark.cm-focused > .cm-scroller > .cm-selectionLayer .cm-selectionBackground": {
    background: "#233"
  },
  ".cm-cursorLayer": {
    pointerEvents: "none"
  },
  "&.cm-focused > .cm-scroller > .cm-cursorLayer": {
    animation: "steps(1) cm-blink 1.2s infinite"
  },
  // Two animations defined so that we can switch between them to
  // restart the animation without forcing another style
  // recomputation.
  "@keyframes cm-blink": { "0%": {}, "50%": { opacity: 0 }, "100%": {} },
  "@keyframes cm-blink2": { "0%": {}, "50%": { opacity: 0 }, "100%": {} },
  ".cm-cursor, .cm-dropCursor": {
    borderLeft: "1.2px solid black",
    marginLeft: "-0.6px",
    pointerEvents: "none"
  },
  ".cm-cursor": {
    display: "none"
  },
  "&dark .cm-cursor": {
    borderLeftColor: "#ddd"
  },
  ".cm-dropCursor": {
    position: "absolute"
  },
  "&.cm-focused > .cm-scroller > .cm-cursorLayer .cm-cursor": {
    display: "block"
  },
  ".cm-iso": {
    unicodeBidi: "isolate"
  },
  ".cm-announced": {
    position: "fixed",
    top: "-10000px"
  },
  "@media print": {
    ".cm-announced": { display: "none" }
  },
  "&light .cm-activeLine": { backgroundColor: "#cceeff44" },
  "&dark .cm-activeLine": { backgroundColor: "#99eeff33" },
  "&light .cm-specialChar": { color: "red" },
  "&dark .cm-specialChar": { color: "#f78" },
  ".cm-gutters": {
    flexShrink: 0,
    display: "flex",
    height: "100%",
    boxSizing: "border-box",
    zIndex: 200
  },
  ".cm-gutters-before": { insetInlineStart: 0 },
  ".cm-gutters-after": { insetInlineEnd: 0 },
  "&light .cm-gutters": {
    backgroundColor: "#f5f5f5",
    color: "#6c6c6c",
    border: "0px solid #ddd",
    "&.cm-gutters-before": { borderRightWidth: "1px" },
    "&.cm-gutters-after": { borderLeftWidth: "1px" }
  },
  "&dark .cm-gutters": {
    backgroundColor: "#333338",
    color: "#ccc"
  },
  ".cm-gutter": {
    display: "flex !important",
    // Necessary -- prevents margin collapsing
    flexDirection: "column",
    flexShrink: 0,
    boxSizing: "border-box",
    minHeight: "100%",
    overflow: "hidden"
  },
  ".cm-gutterElement": {
    boxSizing: "border-box"
  },
  ".cm-lineNumbers .cm-gutterElement": {
    padding: "0 3px 0 5px",
    minWidth: "20px",
    textAlign: "right",
    whiteSpace: "nowrap"
  },
  "&light .cm-activeLineGutter": {
    backgroundColor: "#e2f2ff"
  },
  "&dark .cm-activeLineGutter": {
    backgroundColor: "#222227"
  },
  ".cm-panels": {
    boxSizing: "border-box",
    position: "sticky",
    left: 0,
    right: 0,
    zIndex: 300
  },
  "&light .cm-panels": {
    backgroundColor: "#f5f5f5",
    color: "black"
  },
  "&light .cm-panels-top": {
    borderBottom: "1px solid #ddd"
  },
  "&light .cm-panels-bottom": {
    borderTop: "1px solid #ddd"
  },
  "&dark .cm-panels": {
    backgroundColor: "#333338",
    color: "white"
  },
  ".cm-dialog": {
    padding: "2px 19px 4px 6px",
    position: "relative",
    "& label": { fontSize: "80%" }
  },
  ".cm-dialog-close": {
    position: "absolute",
    top: "3px",
    right: "4px",
    backgroundColor: "inherit",
    border: "none",
    font: "inherit",
    fontSize: "14px",
    padding: "0"
  },
  ".cm-tab": {
    display: "inline-block",
    overflow: "hidden",
    verticalAlign: "bottom"
  },
  ".cm-widgetBuffer": {
    verticalAlign: "text-top",
    height: "1em",
    width: 0,
    display: "inline"
  },
  ".cm-placeholder": {
    color: "#888",
    display: "inline-block",
    verticalAlign: "top",
    userSelect: "none"
  },
  ".cm-highlightSpace": {
    backgroundImage: "radial-gradient(circle at 50% 55%, #aaa 20%, transparent 5%)",
    backgroundPosition: "center"
  },
  ".cm-highlightTab": {
    backgroundImage: `url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" width="200" height="20"><path stroke="%23888" stroke-width="1" fill="none" d="M1 10H196L190 5M190 15L196 10M197 4L197 16"/></svg>')`,
    backgroundSize: "auto 100%",
    backgroundPosition: "right 90%",
    backgroundRepeat: "no-repeat"
  },
  ".cm-trailingSpace": {
    backgroundColor: "#ff332255"
  },
  ".cm-button": {
    verticalAlign: "middle",
    color: "inherit",
    fontSize: "70%",
    padding: ".2em 1em",
    borderRadius: "1px"
  },
  "&light .cm-button": {
    backgroundImage: "linear-gradient(#eff1f5, #d9d9df)",
    border: "1px solid #888",
    "&:active": {
      backgroundImage: "linear-gradient(#b4b4b4, #d0d3d6)"
    }
  },
  "&dark .cm-button": {
    backgroundImage: "linear-gradient(#393939, #111)",
    border: "1px solid #888",
    "&:active": {
      backgroundImage: "linear-gradient(#111, #333)"
    }
  },
  ".cm-textfield": {
    verticalAlign: "middle",
    color: "inherit",
    fontSize: "70%",
    border: "1px solid silver",
    padding: ".2em .5em"
  },
  "&light .cm-textfield": {
    backgroundColor: "white"
  },
  "&dark .cm-textfield": {
    border: "1px solid #555",
    backgroundColor: "inherit"
  }
}, Ma), gp = {
  childList: !0,
  characterData: !0,
  subtree: !0,
  attributes: !0,
  characterDataOldValue: !0
}, Tn = O.ie && O.ie_version <= 11;
class pp {
  constructor(e) {
    this.view = e, this.active = !1, this.editContext = null, this.selectionRange = new _f(), this.selectionChanged = !1, this.delayedFlush = -1, this.resizeTimeout = -1, this.queue = [], this.delayedAndroidKey = null, this.flushingAndroidKey = -1, this.lastChange = 0, this.scrollTargets = [], this.intersection = null, this.resizeScroll = null, this.intersecting = !1, this.gapIntersection = null, this.gaps = [], this.printQuery = null, this.parentCheck = -1, this.dom = e.contentDOM, this.observer = new MutationObserver((t) => {
      for (let n of t)
        this.queue.push(n);
      (O.ie && O.ie_version <= 11 || O.ios && e.composing) && t.some((n) => n.type == "childList" && n.removedNodes.length || n.type == "characterData" && n.oldValue.length > n.target.nodeValue.length) ? this.flushSoon() : this.flush();
    }), window.EditContext && O.android && e.constructor.EDIT_CONTEXT !== !1 && // Chrome <126 doesn't support inverted selections in edit context (#1392)
    !(O.chrome && O.chrome_version < 126) && (this.editContext = new bp(e), e.state.facet(_e) && (e.contentDOM.editContext = this.editContext.editContext)), Tn && (this.onCharData = (t) => {
      this.queue.push({
        target: t.target,
        type: "characterData",
        oldValue: t.prevValue
      }), this.flushSoon();
    }), this.onSelectionChange = this.onSelectionChange.bind(this), this.onResize = this.onResize.bind(this), this.onPrint = this.onPrint.bind(this), this.onScroll = this.onScroll.bind(this), window.matchMedia && (this.printQuery = window.matchMedia("print")), typeof ResizeObserver == "function" && (this.resizeScroll = new ResizeObserver(() => {
      var t;
      ((t = this.view.docView) === null || t === void 0 ? void 0 : t.lastUpdate) < Date.now() - 75 && this.onResize();
    }), this.resizeScroll.observe(e.scrollDOM)), this.addWindowListeners(this.win = e.win), this.start(), typeof IntersectionObserver == "function" && (this.intersection = new IntersectionObserver((t) => {
      this.parentCheck < 0 && (this.parentCheck = setTimeout(this.listenForScroll.bind(this), 1e3)), t.length > 0 && t[t.length - 1].intersectionRatio > 0 != this.intersecting && (this.intersecting = !this.intersecting, this.intersecting != this.view.inView && this.onScrollChanged(document.createEvent("Event")));
    }, { threshold: [0, 1e-3] }), this.intersection.observe(this.dom), this.gapIntersection = new IntersectionObserver((t) => {
      t.length > 0 && t[t.length - 1].intersectionRatio > 0 && this.onScrollChanged(document.createEvent("Event"));
    }, {})), this.listenForScroll(), this.readSelectionRange();
  }
  onScrollChanged(e) {
    this.view.inputState.runHandlers("scroll", e), this.intersecting && this.view.measure();
  }
  onScroll(e) {
    this.intersecting && this.flush(!1), this.editContext && this.view.requestMeasure(this.editContext.measureReq), this.onScrollChanged(e);
  }
  onResize() {
    this.resizeTimeout < 0 && (this.resizeTimeout = setTimeout(() => {
      this.resizeTimeout = -1, this.view.requestMeasure();
    }, 50));
  }
  onPrint(e) {
    (e.type == "change" || !e.type) && !e.matches || (this.view.viewState.printing = !0, this.view.measure(), setTimeout(() => {
      this.view.viewState.printing = !1, this.view.requestMeasure();
    }, 500));
  }
  updateGaps(e) {
    if (this.gapIntersection && (e.length != this.gaps.length || this.gaps.some((t, n) => t != e[n]))) {
      this.gapIntersection.disconnect();
      for (let t of e)
        this.gapIntersection.observe(t);
      this.gaps = e;
    }
  }
  onSelectionChange(e) {
    let t = this.selectionChanged;
    if (!this.readSelectionRange() || this.delayedAndroidKey)
      return;
    let { view: n } = this, r = this.selectionRange;
    if (n.state.facet(_e) ? n.root.activeElement != this.dom : !ji(this.dom, r))
      return;
    let o = r.anchorNode && n.docView.nearest(r.anchorNode);
    if (o && o.ignoreEvent(e)) {
      t || (this.selectionChanged = !1);
      return;
    }
    (O.ie && O.ie_version <= 11 || O.android && O.chrome) && !n.state.selection.main.empty && // (Selection.isCollapsed isn't reliable on IE)
    r.focusNode && ci(r.focusNode, r.focusOffset, r.anchorNode, r.anchorOffset) ? this.flushSoon() : this.flush(!1);
  }
  readSelectionRange() {
    let { view: e } = this, t = mi(e.root);
    if (!t)
      return !1;
    let n = O.safari && e.root.nodeType == 11 && e.root.activeElement == this.dom && mp(this.view, t) || t;
    if (!n || this.selectionRange.eq(n))
      return !1;
    let r = ji(this.dom, n);
    return r && !this.selectionChanged && e.inputState.lastFocusTime > Date.now() - 200 && e.inputState.lastTouchTime < Date.now() - 300 && Yf(this.dom, n) ? (this.view.inputState.lastFocusTime = 0, e.docView.updateSelection(), !1) : (this.selectionRange.setRange(n), r && (this.selectionChanged = !0), !0);
  }
  setSelectionRange(e, t) {
    this.selectionRange.set(e.node, e.offset, t.node, t.offset), this.selectionChanged = !1;
  }
  clearSelectionRange() {
    this.selectionRange.set(null, 0, null, 0);
  }
  listenForScroll() {
    this.parentCheck = -1;
    let e = 0, t = null;
    for (let n = this.dom; n; )
      if (n.nodeType == 1)
        !t && e < this.scrollTargets.length && this.scrollTargets[e] == n ? e++ : t || (t = this.scrollTargets.slice(0, e)), t && t.push(n), n = n.assignedSlot || n.parentNode;
      else if (n.nodeType == 11)
        n = n.host;
      else
        break;
    if (e < this.scrollTargets.length && !t && (t = this.scrollTargets.slice(0, e)), t) {
      for (let n of this.scrollTargets)
        n.removeEventListener("scroll", this.onScroll);
      for (let n of this.scrollTargets = t)
        n.addEventListener("scroll", this.onScroll);
    }
  }
  ignore(e) {
    if (!this.active)
      return e();
    try {
      return this.stop(), e();
    } finally {
      this.start(), this.clear();
    }
  }
  start() {
    this.active || (this.observer.observe(this.dom, gp), Tn && this.dom.addEventListener("DOMCharacterDataModified", this.onCharData), this.active = !0);
  }
  stop() {
    this.active && (this.active = !1, this.observer.disconnect(), Tn && this.dom.removeEventListener("DOMCharacterDataModified", this.onCharData));
  }
  // Throw away any pending changes
  clear() {
    this.processRecords(), this.queue.length = 0, this.selectionChanged = !1;
  }
  // Chrome Android, especially in combination with GBoard, not only
  // doesn't reliably fire regular key events, but also often
  // surrounds the effect of enter or backspace with a bunch of
  // composition events that, when interrupted, cause text duplication
  // or other kinds of corruption. This hack makes the editor back off
  // from handling DOM changes for a moment when such a key is
  // detected (via beforeinput or keydown), and then tries to flush
  // them or, if that has no effect, dispatches the given key.
  delayAndroidKey(e, t) {
    var n;
    if (!this.delayedAndroidKey) {
      let r = () => {
        let o = this.delayedAndroidKey;
        o && (this.clearDelayedAndroidKey(), this.view.inputState.lastKeyCode = o.keyCode, this.view.inputState.lastKeyTime = Date.now(), !this.flush() && o.force && Pt(this.dom, o.key, o.keyCode));
      };
      this.flushingAndroidKey = this.view.win.requestAnimationFrame(r);
    }
    (!this.delayedAndroidKey || e == "Enter") && (this.delayedAndroidKey = {
      key: e,
      keyCode: t,
      // Only run the key handler when no changes are detected if
      // this isn't coming right after another change, in which case
      // it is probably part of a weird chain of updates, and should
      // be ignored if it returns the DOM to its previous state.
      force: this.lastChange < Date.now() - 50 || !!(!((n = this.delayedAndroidKey) === null || n === void 0) && n.force)
    });
  }
  clearDelayedAndroidKey() {
    this.win.cancelAnimationFrame(this.flushingAndroidKey), this.delayedAndroidKey = null, this.flushingAndroidKey = -1;
  }
  flushSoon() {
    this.delayedFlush < 0 && (this.delayedFlush = this.view.win.requestAnimationFrame(() => {
      this.delayedFlush = -1, this.flush();
    }));
  }
  forceFlush() {
    this.delayedFlush >= 0 && (this.view.win.cancelAnimationFrame(this.delayedFlush), this.delayedFlush = -1), this.flush();
  }
  pendingRecords() {
    for (let e of this.observer.takeRecords())
      this.queue.push(e);
    return this.queue;
  }
  processRecords() {
    let e = this.pendingRecords();
    e.length && (this.queue = []);
    let t = -1, n = -1, r = !1;
    for (let o of e) {
      let s = this.readMutation(o);
      s && (s.typeOver && (r = !0), t == -1 ? { from: t, to: n } = s : (t = Math.min(s.from, t), n = Math.max(s.to, n)));
    }
    return { from: t, to: n, typeOver: r };
  }
  readChange() {
    let { from: e, to: t, typeOver: n } = this.processRecords(), r = this.selectionChanged && ji(this.dom, this.selectionRange);
    if (e < 0 && !r)
      return null;
    e > -1 && (this.lastChange = Date.now()), this.view.inputState.lastFocusTime = 0, this.selectionChanged = !1;
    let o = new Eg(this.view, e, t, n);
    return this.view.docView.domChanged = { newSel: o.newSel ? o.newSel.main : null }, o;
  }
  // Apply pending changes, if any
  flush(e = !0) {
    if (this.delayedFlush >= 0 || this.delayedAndroidKey)
      return !1;
    e && this.readSelectionRange();
    let t = this.readChange();
    if (!t)
      return this.view.requestMeasure(), !1;
    let n = this.view.state, r = ya(this.view, t);
    return this.view.state == n && (t.domChanged || t.newSel && !t.newSel.main.eq(this.view.state.selection.main)) && this.view.update([]), r;
  }
  readMutation(e) {
    let t = this.view.docView.nearest(e.target);
    if (!t || t.ignoreMutation(e))
      return null;
    if (t.markDirty(e.type == "attributes"), e.type == "attributes" && (t.flags |= 4), e.type == "childList") {
      let n = ls(t, e.previousSibling || e.target.previousSibling, -1), r = ls(t, e.nextSibling || e.target.nextSibling, 1);
      return {
        from: n ? t.posAfter(n) : t.posAtStart,
        to: r ? t.posBefore(r) : t.posAtEnd,
        typeOver: !1
      };
    } else return e.type == "characterData" ? { from: t.posAtStart, to: t.posAtEnd, typeOver: e.target.nodeValue == e.oldValue } : null;
  }
  setWindow(e) {
    e != this.win && (this.removeWindowListeners(this.win), this.win = e, this.addWindowListeners(this.win));
  }
  addWindowListeners(e) {
    e.addEventListener("resize", this.onResize), this.printQuery ? this.printQuery.addEventListener ? this.printQuery.addEventListener("change", this.onPrint) : this.printQuery.addListener(this.onPrint) : e.addEventListener("beforeprint", this.onPrint), e.addEventListener("scroll", this.onScroll), e.document.addEventListener("selectionchange", this.onSelectionChange);
  }
  removeWindowListeners(e) {
    e.removeEventListener("scroll", this.onScroll), e.removeEventListener("resize", this.onResize), this.printQuery ? this.printQuery.removeEventListener ? this.printQuery.removeEventListener("change", this.onPrint) : this.printQuery.removeListener(this.onPrint) : e.removeEventListener("beforeprint", this.onPrint), e.document.removeEventListener("selectionchange", this.onSelectionChange);
  }
  update(e) {
    this.editContext && (this.editContext.update(e), e.startState.facet(_e) != e.state.facet(_e) && (e.view.contentDOM.editContext = e.state.facet(_e) ? this.editContext.editContext : null));
  }
  destroy() {
    var e, t, n;
    this.stop(), (e = this.intersection) === null || e === void 0 || e.disconnect(), (t = this.gapIntersection) === null || t === void 0 || t.disconnect(), (n = this.resizeScroll) === null || n === void 0 || n.disconnect();
    for (let r of this.scrollTargets)
      r.removeEventListener("scroll", this.onScroll);
    this.removeWindowListeners(this.win), clearTimeout(this.parentCheck), clearTimeout(this.resizeTimeout), this.win.cancelAnimationFrame(this.delayedFlush), this.win.cancelAnimationFrame(this.flushingAndroidKey), this.editContext && (this.view.contentDOM.editContext = null, this.editContext.destroy());
  }
}
function ls(i, e, t) {
  for (; e; ) {
    let n = q.get(e);
    if (n && n.parent == i)
      return n;
    let r = e.parentNode;
    e = r != i.dom ? r : t > 0 ? e.nextSibling : e.previousSibling;
  }
  return null;
}
function as(i, e) {
  let t = e.startContainer, n = e.startOffset, r = e.endContainer, o = e.endOffset, s = i.docView.domAtPos(i.state.selection.main.anchor);
  return ci(s.node, s.offset, r, o) && ([t, n, r, o] = [r, o, t, n]), { anchorNode: t, anchorOffset: n, focusNode: r, focusOffset: o };
}
function mp(i, e) {
  if (e.getComposedRanges) {
    let r = e.getComposedRanges(i.root)[0];
    if (r)
      return as(i, r);
  }
  let t = null;
  function n(r) {
    r.preventDefault(), r.stopImmediatePropagation(), t = r.getTargetRanges()[0];
  }
  return i.contentDOM.addEventListener("beforeinput", n, !0), i.dom.ownerDocument.execCommand("indent"), i.contentDOM.removeEventListener("beforeinput", n, !0), t ? as(i, t) : null;
}
class bp {
  constructor(e) {
    this.from = 0, this.to = 0, this.pendingContextChange = null, this.handlers = /* @__PURE__ */ Object.create(null), this.composing = null, this.resetRange(e.state);
    let t = this.editContext = new window.EditContext({
      text: e.state.doc.sliceString(this.from, this.to),
      selectionStart: this.toContextPos(Math.max(this.from, Math.min(this.to, e.state.selection.main.anchor))),
      selectionEnd: this.toContextPos(e.state.selection.main.head)
    });
    this.handlers.textupdate = (n) => {
      let r = e.state.selection.main, { anchor: o, head: s } = r, l = this.toEditorPos(n.updateRangeStart), a = this.toEditorPos(n.updateRangeEnd);
      e.inputState.composing >= 0 && !this.composing && (this.composing = { contextBase: n.updateRangeStart, editorBase: l, drifted: !1 });
      let c = { from: l, to: a, insert: W.of(n.text.split(`
`)) };
      if (c.from == this.from && o < this.from ? c.from = o : c.to == this.to && o > this.to && (c.to = o), c.from == c.to && !c.insert.length) {
        let h = E.single(this.toEditorPos(n.selectionStart), this.toEditorPos(n.selectionEnd));
        h.main.eq(r) || e.dispatch({ selection: h, userEvent: "select" });
        return;
      }
      if ((O.mac || O.android) && c.from == s - 1 && /^\. ?$/.test(n.text) && e.contentDOM.getAttribute("autocorrect") == "off" && (c = { from: l, to: a, insert: W.of([n.text.replace(".", " ")]) }), this.pendingContextChange = c, !e.state.readOnly) {
        let h = this.to - this.from + (c.to - c.from + c.insert.length);
        Hr(e, c, E.single(this.toEditorPos(n.selectionStart, h), this.toEditorPos(n.selectionEnd, h)));
      }
      this.pendingContextChange && (this.revertPending(e.state), this.setSelection(e.state));
    }, this.handlers.characterboundsupdate = (n) => {
      let r = [], o = null;
      for (let s = this.toEditorPos(n.rangeStart), l = this.toEditorPos(n.rangeEnd); s < l; s++) {
        let a = e.coordsForChar(s);
        o = a && new DOMRect(a.left, a.top, a.right - a.left, a.bottom - a.top) || o || new DOMRect(), r.push(o);
      }
      t.updateCharacterBounds(n.rangeStart, r);
    }, this.handlers.textformatupdate = (n) => {
      let r = [];
      for (let o of n.getTextFormats()) {
        let s = o.underlineStyle, l = o.underlineThickness;
        if (s != "None" && l != "None") {
          let a = this.toEditorPos(o.rangeStart), c = this.toEditorPos(o.rangeEnd);
          if (a < c) {
            let h = `text-decoration: underline ${s == "Dashed" ? "dashed " : s == "Squiggle" ? "wavy " : ""}${l == "Thin" ? 1 : 2}px`;
            r.push(ye.mark({ attributes: { style: h } }).range(a, c));
          }
        }
      }
      e.dispatch({ effects: ca.of(ye.set(r)) });
    }, this.handlers.compositionstart = () => {
      e.inputState.composing < 0 && (e.inputState.composing = 0, e.inputState.compositionFirstChange = !0);
    }, this.handlers.compositionend = () => {
      if (e.inputState.composing = -1, e.inputState.compositionFirstChange = null, this.composing) {
        let { drifted: n } = this.composing;
        this.composing = null, n && this.reset(e.state);
      }
    };
    for (let n in this.handlers)
      t.addEventListener(n, this.handlers[n]);
    this.measureReq = { read: (n) => {
      this.editContext.updateControlBounds(n.contentDOM.getBoundingClientRect());
      let r = mi(n.root);
      r && r.rangeCount && this.editContext.updateSelectionBounds(r.getRangeAt(0).getBoundingClientRect());
    } };
  }
  applyEdits(e) {
    let t = 0, n = !1, r = this.pendingContextChange;
    return e.changes.iterChanges((o, s, l, a, c) => {
      if (n)
        return;
      let h = c.length - (s - o);
      if (r && s >= r.to)
        if (r.from == o && r.to == s && r.insert.eq(c)) {
          r = this.pendingContextChange = null, t += h, this.to += h;
          return;
        } else
          r = null, this.revertPending(e.state);
      if (o += t, s += t, s <= this.from)
        this.from += h, this.to += h;
      else if (o < this.to) {
        if (o < this.from || s > this.to || this.to - this.from + c.length > 3e4) {
          n = !0;
          return;
        }
        this.editContext.updateText(this.toContextPos(o), this.toContextPos(s), c.toString()), this.to += h;
      }
      t += h;
    }), r && !n && this.revertPending(e.state), !n;
  }
  update(e) {
    let t = this.pendingContextChange, n = e.startState.selection.main;
    this.composing && (this.composing.drifted || !e.changes.touchesRange(n.from, n.to) && e.transactions.some((r) => !r.isUserEvent("input.type") && r.changes.touchesRange(this.from, this.to))) ? (this.composing.drifted = !0, this.composing.editorBase = e.changes.mapPos(this.composing.editorBase)) : !this.applyEdits(e) || !this.rangeIsValid(e.state) ? (this.pendingContextChange = null, this.reset(e.state)) : (e.docChanged || e.selectionSet || t) && this.setSelection(e.state), (e.geometryChanged || e.docChanged || e.selectionSet) && e.view.requestMeasure(this.measureReq);
  }
  resetRange(e) {
    let { head: t } = e.selection.main;
    this.from = Math.max(
      0,
      t - 1e4
      /* CxVp.Margin */
    ), this.to = Math.min(
      e.doc.length,
      t + 1e4
      /* CxVp.Margin */
    );
  }
  reset(e) {
    this.resetRange(e), this.editContext.updateText(0, this.editContext.text.length, e.doc.sliceString(this.from, this.to)), this.setSelection(e);
  }
  revertPending(e) {
    let t = this.pendingContextChange;
    this.pendingContextChange = null, this.editContext.updateText(this.toContextPos(t.from), this.toContextPos(t.from + t.insert.length), e.doc.sliceString(t.from, t.to));
  }
  setSelection(e) {
    let { main: t } = e.selection, n = this.toContextPos(Math.max(this.from, Math.min(this.to, t.anchor))), r = this.toContextPos(t.head);
    (this.editContext.selectionStart != n || this.editContext.selectionEnd != r) && this.editContext.updateSelection(n, r);
  }
  rangeIsValid(e) {
    let { head: t } = e.selection.main;
    return !(this.from > 0 && t - this.from < 500 || this.to < e.doc.length && this.to - t < 500 || this.to - this.from > 1e4 * 3);
  }
  toEditorPos(e, t = this.to - this.from) {
    e = Math.min(e, t);
    let n = this.composing;
    return n && n.drifted ? n.editorBase + (e - n.contextBase) : e + this.from;
  }
  toContextPos(e) {
    let t = this.composing;
    return t && t.drifted ? t.contextBase + (e - t.editorBase) : e - this.from;
  }
  destroy() {
    for (let e in this.handlers)
      this.editContext.removeEventListener(e, this.handlers[e]);
  }
}
class H {
  /**
  The current editor state.
  */
  get state() {
    return this.viewState.state;
  }
  /**
  To be able to display large documents without consuming too much
  memory or overloading the browser, CodeMirror only draws the
  code that is visible (plus a margin around it) to the DOM. This
  property tells you the extent of the current drawn viewport, in
  document positions.
  */
  get viewport() {
    return this.viewState.viewport;
  }
  /**
  When there are, for example, large collapsed ranges in the
  viewport, its size can be a lot bigger than the actual visible
  content. Thus, if you are doing something like styling the
  content in the viewport, it is preferable to only do so for
  these ranges, which are the subset of the viewport that is
  actually drawn.
  */
  get visibleRanges() {
    return this.viewState.visibleRanges;
  }
  /**
  Returns false when the editor is entirely scrolled out of view
  or otherwise hidden.
  */
  get inView() {
    return this.viewState.inView;
  }
  /**
  Indicates whether the user is currently composing text via
  [IME](https://en.wikipedia.org/wiki/Input_method), and at least
  one change has been made in the current composition.
  */
  get composing() {
    return !!this.inputState && this.inputState.composing > 0;
  }
  /**
  Indicates whether the user is currently in composing state. Note
  that on some platforms, like Android, this will be the case a
  lot, since just putting the cursor on a word starts a
  composition there.
  */
  get compositionStarted() {
    return !!this.inputState && this.inputState.composing >= 0;
  }
  /**
  The document or shadow root that the view lives in.
  */
  get root() {
    return this._root;
  }
  /**
  @internal
  */
  get win() {
    return this.dom.ownerDocument.defaultView || window;
  }
  /**
  Construct a new view. You'll want to either provide a `parent`
  option, or put `view.dom` into your document after creating a
  view, so that the user can see the editor.
  */
  constructor(e = {}) {
    var t;
    this.plugins = [], this.pluginMap = /* @__PURE__ */ new Map(), this.editorAttrs = {}, this.contentAttrs = {}, this.bidiCache = [], this.destroyed = !1, this.updateState = 2, this.measureScheduled = -1, this.measureRequests = [], this.contentDOM = document.createElement("div"), this.scrollDOM = document.createElement("div"), this.scrollDOM.tabIndex = -1, this.scrollDOM.className = "cm-scroller", this.scrollDOM.appendChild(this.contentDOM), this.announceDOM = document.createElement("div"), this.announceDOM.className = "cm-announced", this.announceDOM.setAttribute("aria-live", "polite"), this.dom = document.createElement("div"), this.dom.appendChild(this.announceDOM), this.dom.appendChild(this.scrollDOM), e.parent && e.parent.appendChild(this.dom);
    let { dispatch: n } = e;
    this.dispatchTransactions = e.dispatchTransactions || n && ((r) => r.forEach((o) => n(o, this))) || ((r) => this.update(r)), this.dispatch = this.dispatch.bind(this), this._root = e.root || Gf(e.parent) || document, this.viewState = new os(e.state || G.create(e)), e.scrollTo && e.scrollTo.is(Ii) && (this.viewState.scrollTarget = e.scrollTo.value.clip(this.viewState.state)), this.plugins = this.state.facet(Ot).map((r) => new Cn(r));
    for (let r of this.plugins)
      r.update(this);
    this.observer = new pp(this), this.inputState = new zg(this), this.inputState.ensureHandlers(this.plugins), this.docView = new Wo(this), this.mountStyles(), this.updateAttrs(), this.updateState = 0, this.requestMeasure(), !((t = document.fonts) === null || t === void 0) && t.ready && document.fonts.ready.then(() => this.requestMeasure());
  }
  dispatch(...e) {
    let t = e.length == 1 && e[0] instanceof me ? e : e.length == 1 && Array.isArray(e[0]) ? e[0] : [this.state.update(...e)];
    this.dispatchTransactions(t, this);
  }
  /**
  Update the view for the given array of transactions. This will
  update the visible document and selection to match the state
  produced by the transactions, and notify view plugins of the
  change. You should usually call
  [`dispatch`](https://codemirror.net/6/docs/ref/#view.EditorView.dispatch) instead, which uses this
  as a primitive.
  */
  update(e) {
    if (this.updateState != 0)
      throw new Error("Calls to EditorView.update are not allowed while an update is in progress");
    let t = !1, n = !1, r, o = this.state;
    for (let f of e) {
      if (f.startState != o)
        throw new RangeError("Trying to update state with a transaction that doesn't start from the previous state.");
      o = f.state;
    }
    if (this.destroyed) {
      this.viewState.state = o;
      return;
    }
    let s = this.hasFocus, l = 0, a = null;
    e.some((f) => f.annotation(Ca)) ? (this.inputState.notifiedFocused = s, l = 1) : s != this.inputState.notifiedFocused && (this.inputState.notifiedFocused = s, a = ka(o, s), a || (l = 1));
    let c = this.observer.delayedAndroidKey, h = null;
    if (c ? (this.observer.clearDelayedAndroidKey(), h = this.observer.readChange(), (h && !this.state.doc.eq(o.doc) || !this.state.selection.eq(o.selection)) && (h = null)) : this.observer.clear(), o.facet(G.phrases) != this.state.facet(G.phrases))
      return this.setState(o);
    r = Zi.create(this, o, e), r.flags |= l;
    let d = this.viewState.scrollTarget;
    try {
      this.updateState = 2;
      for (let f of e) {
        if (d && (d = d.map(f.changes)), f.scrollIntoView) {
          let { main: g } = f.state.selection;
          d = new Lt(g.empty ? g : E.cursor(g.head, g.head > g.anchor ? -1 : 1));
        }
        for (let g of f.effects)
          g.is(Ii) && (d = g.value.clip(this.state));
      }
      this.viewState.update(r, d), this.bidiCache = tn.update(this.bidiCache, r.changes), r.empty || (this.updatePlugins(r), this.inputState.update(r)), t = this.docView.update(r), this.state.facet(ri) != this.styleModules && this.mountStyles(), n = this.updateAttrs(), this.showAnnouncements(e), this.docView.updateSelection(t, e.some((f) => f.isUserEvent("select.pointer")));
    } finally {
      this.updateState = 0;
    }
    if (r.startState.facet(Fi) != r.state.facet(Fi) && (this.viewState.mustMeasureContent = !0), (t || n || d || this.viewState.mustEnforceCursorAssoc || this.viewState.mustMeasureContent) && this.requestMeasure(), t && this.docViewUpdate(), !r.empty)
      for (let f of this.state.facet(cr))
        try {
          f(r);
        } catch (g) {
          Xe(this.state, g, "update listener");
        }
    (a || h) && Promise.resolve().then(() => {
      a && this.state == a.startState && this.dispatch(a), h && !ya(this, h) && c.force && Pt(this.contentDOM, c.key, c.keyCode);
    });
  }
  /**
  Reset the view to the given state. (This will cause the entire
  document to be redrawn and all view plugins to be reinitialized,
  so you should probably only use it when the new state isn't
  derived from the old state. Otherwise, use
  [`dispatch`](https://codemirror.net/6/docs/ref/#view.EditorView.dispatch) instead.)
  */
  setState(e) {
    if (this.updateState != 0)
      throw new Error("Calls to EditorView.setState are not allowed while an update is in progress");
    if (this.destroyed) {
      this.viewState.state = e;
      return;
    }
    this.updateState = 2;
    let t = this.hasFocus;
    try {
      for (let n of this.plugins)
        n.destroy(this);
      this.viewState = new os(e), this.plugins = e.facet(Ot).map((n) => new Cn(n)), this.pluginMap.clear();
      for (let n of this.plugins)
        n.update(this);
      this.docView.destroy(), this.docView = new Wo(this), this.inputState.ensureHandlers(this.plugins), this.mountStyles(), this.updateAttrs(), this.bidiCache = [];
    } finally {
      this.updateState = 0;
    }
    t && this.focus(), this.requestMeasure();
  }
  updatePlugins(e) {
    let t = e.startState.facet(Ot), n = e.state.facet(Ot);
    if (t != n) {
      let r = [];
      for (let o of n) {
        let s = t.indexOf(o);
        if (s < 0)
          r.push(new Cn(o));
        else {
          let l = this.plugins[s];
          l.mustUpdate = e, r.push(l);
        }
      }
      for (let o of this.plugins)
        o.mustUpdate != e && o.destroy(this);
      this.plugins = r, this.pluginMap.clear();
    } else
      for (let r of this.plugins)
        r.mustUpdate = e;
    for (let r = 0; r < this.plugins.length; r++)
      this.plugins[r].update(this);
    t != n && this.inputState.ensureHandlers(this.plugins);
  }
  docViewUpdate() {
    for (let e of this.plugins) {
      let t = e.value;
      if (t && t.docViewUpdate)
        try {
          t.docViewUpdate(this);
        } catch (n) {
          Xe(this.state, n, "doc view update listener");
        }
    }
  }
  /**
  @internal
  */
  measure(e = !0) {
    if (this.destroyed)
      return;
    if (this.measureScheduled > -1 && this.win.cancelAnimationFrame(this.measureScheduled), this.observer.delayedAndroidKey) {
      this.measureScheduled = -1, this.requestMeasure();
      return;
    }
    this.measureScheduled = 0, e && this.observer.forceFlush();
    let t = null, n = this.scrollDOM, r = n.scrollTop * this.scaleY, { scrollAnchorPos: o, scrollAnchorHeight: s } = this.viewState;
    Math.abs(r - this.viewState.scrollTop) > 1 && (s = -1), this.viewState.scrollAnchorHeight = -1;
    try {
      for (let l = 0; ; l++) {
        if (s < 0)
          if (Fl(n))
            o = -1, s = this.viewState.heightMap.height;
          else {
            let g = this.viewState.scrollAnchorAt(r);
            o = g.from, s = g.top;
          }
        this.updateState = 1;
        let a = this.viewState.measure(this);
        if (!a && !this.measureRequests.length && this.viewState.scrollTarget == null)
          break;
        if (l > 5) {
          console.warn(this.measureRequests.length ? "Measure loop restarted more than 5 times" : "Viewport failed to stabilize");
          break;
        }
        let c = [];
        a & 4 || ([this.measureRequests, c] = [c, this.measureRequests]);
        let h = c.map((g) => {
          try {
            return g.read(this);
          } catch (p) {
            return Xe(this.state, p), hs;
          }
        }), d = Zi.create(this, this.state, []), f = !1;
        d.flags |= a, t ? t.flags |= a : t = d, this.updateState = 2, d.empty || (this.updatePlugins(d), this.inputState.update(d), this.updateAttrs(), f = this.docView.update(d), f && this.docViewUpdate());
        for (let g = 0; g < c.length; g++)
          if (h[g] != hs)
            try {
              let p = c[g];
              p.write && p.write(h[g], this);
            } catch (p) {
              Xe(this.state, p);
            }
        if (f && this.docView.updateSelection(!0), !d.viewportChanged && this.measureRequests.length == 0) {
          if (this.viewState.editorHeight)
            if (this.viewState.scrollTarget) {
              this.docView.scrollIntoView(this.viewState.scrollTarget), this.viewState.scrollTarget = null, s = -1;
              continue;
            } else {
              let p = (o < 0 ? this.viewState.heightMap.height : this.viewState.lineBlockAt(o).top) - s;
              if (p > 1 || p < -1) {
                r = r + p, n.scrollTop = r / this.scaleY, s = -1;
                continue;
              }
            }
          break;
        }
      }
    } finally {
      this.updateState = 0, this.measureScheduled = -1;
    }
    if (t && !t.empty)
      for (let l of this.state.facet(cr))
        l(t);
  }
  /**
  Get the CSS classes for the currently active editor themes.
  */
  get themeClasses() {
    return gr + " " + (this.state.facet(fr) ? Ra : Ta) + " " + this.state.facet(Fi);
  }
  updateAttrs() {
    let e = cs(this, da, {
      class: "cm-editor" + (this.hasFocus ? " cm-focused " : " ") + this.themeClasses
    }), t = {
      spellcheck: "false",
      autocorrect: "off",
      autocapitalize: "off",
      writingsuggestions: "false",
      translate: "no",
      contenteditable: this.state.facet(_e) ? "true" : "false",
      class: "cm-content",
      style: `${O.tabSize}: ${this.state.tabSize}`,
      role: "textbox",
      "aria-multiline": "true"
    };
    this.state.readOnly && (t["aria-readonly"] = "true"), cs(this, Fr, t);
    let n = this.observer.ignore(() => {
      let r = or(this.contentDOM, this.contentAttrs, t), o = or(this.dom, this.editorAttrs, e);
      return r || o;
    });
    return this.editorAttrs = e, this.contentAttrs = t, n;
  }
  showAnnouncements(e) {
    let t = !0;
    for (let n of e)
      for (let r of n.effects)
        if (r.is(H.announce)) {
          t && (this.announceDOM.textContent = ""), t = !1;
          let o = this.announceDOM.appendChild(document.createElement("div"));
          o.textContent = r.value;
        }
  }
  mountStyles() {
    this.styleModules = this.state.facet(ri);
    let e = this.state.facet(H.cspNonce);
    Ht.mount(this.root, this.styleModules.concat(fp).reverse(), e ? { nonce: e } : void 0);
  }
  readMeasured() {
    if (this.updateState == 2)
      throw new Error("Reading the editor layout isn't allowed during an update");
    this.updateState == 0 && this.measureScheduled > -1 && this.measure(!1);
  }
  /**
  Schedule a layout measurement, optionally providing callbacks to
  do custom DOM measuring followed by a DOM write phase. Using
  this is preferable reading DOM layout directly from, for
  example, an event handler, because it'll make sure measuring and
  drawing done by other components is synchronized, avoiding
  unnecessary DOM layout computations.
  */
  requestMeasure(e) {
    if (this.measureScheduled < 0 && (this.measureScheduled = this.win.requestAnimationFrame(() => this.measure())), e) {
      if (this.measureRequests.indexOf(e) > -1)
        return;
      if (e.key != null) {
        for (let t = 0; t < this.measureRequests.length; t++)
          if (this.measureRequests[t].key === e.key) {
            this.measureRequests[t] = e;
            return;
          }
      }
      this.measureRequests.push(e);
    }
  }
  /**
  Get the value of a specific plugin, if present. Note that
  plugins that crash can be dropped from a view, so even when you
  know you registered a given plugin, it is recommended to check
  the return value of this method.
  */
  plugin(e) {
    let t = this.pluginMap.get(e);
    return (t === void 0 || t && t.plugin != e) && this.pluginMap.set(e, t = this.plugins.find((n) => n.plugin == e) || null), t && t.update(this).value;
  }
  /**
  The top position of the document, in screen coordinates. This
  may be negative when the editor is scrolled down. Points
  directly to the top of the first line, not above the padding.
  */
  get documentTop() {
    return this.contentDOM.getBoundingClientRect().top + this.viewState.paddingTop;
  }
  /**
  Reports the padding above and below the document.
  */
  get documentPadding() {
    return { top: this.viewState.paddingTop, bottom: this.viewState.paddingBottom };
  }
  /**
  If the editor is transformed with CSS, this provides the scale
  along the X axis. Otherwise, it will just be 1. Note that
  transforms other than translation and scaling are not supported.
  */
  get scaleX() {
    return this.viewState.scaleX;
  }
  /**
  Provide the CSS transformed scale along the Y axis.
  */
  get scaleY() {
    return this.viewState.scaleY;
  }
  /**
  Find the text line or block widget at the given vertical
  position (which is interpreted as relative to the [top of the
  document](https://codemirror.net/6/docs/ref/#view.EditorView.documentTop)).
  */
  elementAtHeight(e) {
    return this.readMeasured(), this.viewState.elementAtHeight(e);
  }
  /**
  Find the line block (see
  [`lineBlockAt`](https://codemirror.net/6/docs/ref/#view.EditorView.lineBlockAt) at the given
  height, again interpreted relative to the [top of the
  document](https://codemirror.net/6/docs/ref/#view.EditorView.documentTop).
  */
  lineBlockAtHeight(e) {
    return this.readMeasured(), this.viewState.lineBlockAtHeight(e);
  }
  /**
  Get the extent and vertical position of all [line
  blocks](https://codemirror.net/6/docs/ref/#view.EditorView.lineBlockAt) in the viewport. Positions
  are relative to the [top of the
  document](https://codemirror.net/6/docs/ref/#view.EditorView.documentTop);
  */
  get viewportLineBlocks() {
    return this.viewState.viewportLines;
  }
  /**
  Find the line block around the given document position. A line
  block is a range delimited on both sides by either a
  non-[hidden](https://codemirror.net/6/docs/ref/#view.Decoration^replace) line break, or the
  start/end of the document. It will usually just hold a line of
  text, but may be broken into multiple textblocks by block
  widgets.
  */
  lineBlockAt(e) {
    return this.viewState.lineBlockAt(e);
  }
  /**
  The editor's total content height.
  */
  get contentHeight() {
    return this.viewState.contentHeight;
  }
  /**
  Move a cursor position by [grapheme
  cluster](https://codemirror.net/6/docs/ref/#state.findClusterBreak). `forward` determines whether
  the motion is away from the line start, or towards it. In
  bidirectional text, the line is traversed in visual order, using
  the editor's [text direction](https://codemirror.net/6/docs/ref/#view.EditorView.textDirection).
  When the start position was the last one on the line, the
  returned position will be across the line break. If there is no
  further line, the original position is returned.
  
  By default, this method moves over a single cluster. The
  optional `by` argument can be used to move across more. It will
  be called with the first cluster as argument, and should return
  a predicate that determines, for each subsequent cluster,
  whether it should also be moved over.
  */
  moveByChar(e, t, n) {
    return $n(this, e, Ko(this, e, t, n));
  }
  /**
  Move a cursor position across the next group of either
  [letters](https://codemirror.net/6/docs/ref/#state.EditorState.charCategorizer) or non-letter
  non-whitespace characters.
  */
  moveByGroup(e, t) {
    return $n(this, e, Ko(this, e, t, (n) => Rg(this, e.head, n)));
  }
  /**
  Get the cursor position visually at the start or end of a line.
  Note that this may differ from the _logical_ position at its
  start or end (which is simply at `line.from`/`line.to`) if text
  at the start or end goes against the line's base text direction.
  */
  visualLineSide(e, t) {
    let n = this.bidiSpans(e), r = this.textDirectionAt(e.from), o = n[t ? n.length - 1 : 0];
    return E.cursor(o.side(t, r) + e.from, o.forward(!t, r) ? 1 : -1);
  }
  /**
  Move to the next line boundary in the given direction. If
  `includeWrap` is true, line wrapping is on, and there is a
  further wrap point on the current line, the wrap point will be
  returned. Otherwise this function will return the start or end
  of the line.
  */
  moveToLineBoundary(e, t, n = !0) {
    return Tg(this, e, t, n);
  }
  /**
  Move a cursor position vertically. When `distance` isn't given,
  it defaults to moving to the next line (including wrapped
  lines). Otherwise, `distance` should provide a positive distance
  in pixels.
  
  When `start` has a
  [`goalColumn`](https://codemirror.net/6/docs/ref/#state.SelectionRange.goalColumn), the vertical
  motion will use that as a target horizontal position. Otherwise,
  the cursor's own horizontal position is used. The returned
  cursor will have its goal column set to whichever column was
  used.
  */
  moveVertically(e, t, n) {
    return $n(this, e, Mg(this, e, t, n));
  }
  /**
  Find the DOM parent node and offset (child offset if `node` is
  an element, character offset when it is a text node) at the
  given document position.
  
  Note that for positions that aren't currently in
  `visibleRanges`, the resulting DOM position isn't necessarily
  meaningful (it may just point before or after a placeholder
  element).
  */
  domAtPos(e) {
    return this.docView.domAtPos(e);
  }
  /**
  Find the document position at the given DOM node. Can be useful
  for associating positions with DOM events. Will raise an error
  when `node` isn't part of the editor content.
  */
  posAtDOM(e, t = 0) {
    return this.docView.posFromDOM(e, t);
  }
  posAtCoords(e, t = !0) {
    return this.readMeasured(), ba(this, e, t);
  }
  /**
  Get the screen coordinates at the given document position.
  `side` determines whether the coordinates are based on the
  element before (-1) or after (1) the position (if no element is
  available on the given side, the method will transparently use
  another strategy to get reasonable coordinates).
  */
  coordsAtPos(e, t = 1) {
    this.readMeasured();
    let n = this.docView.coordsAt(e, t);
    if (!n || n.left == n.right)
      return n;
    let r = this.state.doc.lineAt(e), o = this.bidiSpans(r), s = o[nt.find(o, e - r.from, -1, t)];
    return un(n, s.dir == be.LTR == t > 0);
  }
  /**
  Return the rectangle around a given character. If `pos` does not
  point in front of a character that is in the viewport and
  rendered (i.e. not replaced, not a line break), this will return
  null. For space characters that are a line wrap point, this will
  return the position before the line break.
  */
  coordsForChar(e) {
    return this.readMeasured(), this.docView.coordsForChar(e);
  }
  /**
  The default width of a character in the editor. May not
  accurately reflect the width of all characters (given variable
  width fonts or styling of invididual ranges).
  */
  get defaultCharacterWidth() {
    return this.viewState.heightOracle.charWidth;
  }
  /**
  The default height of a line in the editor. May not be accurate
  for all lines.
  */
  get defaultLineHeight() {
    return this.viewState.heightOracle.lineHeight;
  }
  /**
  The text direction
  ([`direction`](https://developer.mozilla.org/en-US/docs/Web/CSS/direction)
  CSS property) of the editor's content element.
  */
  get textDirection() {
    return this.viewState.defaultTextDirection;
  }
  /**
  Find the text direction of the block at the given position, as
  assigned by CSS. If
  [`perLineTextDirection`](https://codemirror.net/6/docs/ref/#view.EditorView^perLineTextDirection)
  isn't enabled, or the given position is outside of the viewport,
  this will always return the same as
  [`textDirection`](https://codemirror.net/6/docs/ref/#view.EditorView.textDirection). Note that
  this may trigger a DOM layout.
  */
  textDirectionAt(e) {
    return !this.state.facet(aa) || e < this.viewport.from || e > this.viewport.to ? this.textDirection : (this.readMeasured(), this.docView.textDirectionAt(e));
  }
  /**
  Whether this editor [wraps lines](https://codemirror.net/6/docs/ref/#view.EditorView.lineWrapping)
  (as determined by the
  [`white-space`](https://developer.mozilla.org/en-US/docs/Web/CSS/white-space)
  CSS property of its content element).
  */
  get lineWrapping() {
    return this.viewState.heightOracle.lineWrapping;
  }
  /**
  Returns the bidirectional text structure of the given line
  (which should be in the current document) as an array of span
  objects. The order of these spans matches the [text
  direction](https://codemirror.net/6/docs/ref/#view.EditorView.textDirection)—if that is
  left-to-right, the leftmost spans come first, otherwise the
  rightmost spans come first.
  */
  bidiSpans(e) {
    if (e.length > yp)
      return ea(e.length);
    let t = this.textDirectionAt(e.from), n;
    for (let o of this.bidiCache)
      if (o.from == e.from && o.dir == t && (o.fresh || Zl(o.isolates, n = Fo(this, e))))
        return o.order;
    n || (n = Fo(this, e));
    let r = hg(e.text, t, n);
    return this.bidiCache.push(new tn(e.from, e.to, t, n, !0, r)), r;
  }
  /**
  Check whether the editor has focus.
  */
  get hasFocus() {
    var e;
    return (this.dom.ownerDocument.hasFocus() || O.safari && ((e = this.inputState) === null || e === void 0 ? void 0 : e.lastContextMenu) > Date.now() - 3e4) && this.root.activeElement == this.contentDOM;
  }
  /**
  Put focus on the editor.
  */
  focus() {
    this.observer.ignore(() => {
      zl(this.contentDOM), this.docView.updateSelection();
    });
  }
  /**
  Update the [root](https://codemirror.net/6/docs/ref/##view.EditorViewConfig.root) in which the editor lives. This is only
  necessary when moving the editor's existing DOM to a new window or shadow root.
  */
  setRoot(e) {
    this._root != e && (this._root = e, this.observer.setWindow((e.nodeType == 9 ? e : e.ownerDocument).defaultView || window), this.mountStyles());
  }
  /**
  Clean up this editor view, removing its element from the
  document, unregistering event handlers, and notifying
  plugins. The view instance can no longer be used after
  calling this.
  */
  destroy() {
    this.root.activeElement == this.contentDOM && this.contentDOM.blur();
    for (let e of this.plugins)
      e.destroy(this);
    this.plugins = [], this.inputState.destroy(), this.docView.destroy(), this.dom.remove(), this.observer.destroy(), this.measureScheduled > -1 && this.win.cancelAnimationFrame(this.measureScheduled), this.destroyed = !0;
  }
  /**
  Returns an effect that can be
  [added](https://codemirror.net/6/docs/ref/#state.TransactionSpec.effects) to a transaction to
  cause it to scroll the given position or range into view.
  */
  static scrollIntoView(e, t = {}) {
    return Ii.of(new Lt(typeof e == "number" ? E.cursor(e) : e, t.y, t.x, t.yMargin, t.xMargin));
  }
  /**
  Return an effect that resets the editor to its current (at the
  time this method was called) scroll position. Note that this
  only affects the editor's own scrollable element, not parents.
  See also
  [`EditorViewConfig.scrollTo`](https://codemirror.net/6/docs/ref/#view.EditorViewConfig.scrollTo).
  
  The effect should be used with a document identical to the one
  it was created for. Failing to do so is not an error, but may
  not scroll to the expected position. You can
  [map](https://codemirror.net/6/docs/ref/#state.StateEffect.map) the effect to account for changes.
  */
  scrollSnapshot() {
    let { scrollTop: e, scrollLeft: t } = this.scrollDOM, n = this.viewState.scrollAnchorAt(e);
    return Ii.of(new Lt(E.cursor(n.from), "start", "start", n.top - e, t, !0));
  }
  /**
  Enable or disable tab-focus mode, which disables key bindings
  for Tab and Shift-Tab, letting the browser's default
  focus-changing behavior go through instead. This is useful to
  prevent trapping keyboard users in your editor.
  
  Without argument, this toggles the mode. With a boolean, it
  enables (true) or disables it (false). Given a number, it
  temporarily enables the mode until that number of milliseconds
  have passed or another non-Tab key is pressed.
  */
  setTabFocusMode(e) {
    e == null ? this.inputState.tabFocusMode = this.inputState.tabFocusMode < 0 ? 0 : -1 : typeof e == "boolean" ? this.inputState.tabFocusMode = e ? 0 : -1 : this.inputState.tabFocusMode != 0 && (this.inputState.tabFocusMode = Date.now() + e);
  }
  /**
  Returns an extension that can be used to add DOM event handlers.
  The value should be an object mapping event names to handler
  functions. For any given event, such functions are ordered by
  extension precedence, and the first handler to return true will
  be assumed to have handled that event, and no other handlers or
  built-in behavior will be activated for it. These are registered
  on the [content element](https://codemirror.net/6/docs/ref/#view.EditorView.contentDOM), except
  for `scroll` handlers, which will be called any time the
  editor's [scroll element](https://codemirror.net/6/docs/ref/#view.EditorView.scrollDOM) or one of
  its parent nodes is scrolled.
  */
  static domEventHandlers(e) {
    return yi.define(() => ({}), { eventHandlers: e });
  }
  /**
  Create an extension that registers DOM event observers. Contrary
  to event [handlers](https://codemirror.net/6/docs/ref/#view.EditorView^domEventHandlers),
  observers can't be prevented from running by a higher-precedence
  handler returning true. They also don't prevent other handlers
  and observers from running when they return true, and should not
  call `preventDefault`.
  */
  static domEventObservers(e) {
    return yi.define(() => ({}), { eventObservers: e });
  }
  /**
  Create a theme extension. The first argument can be a
  [`style-mod`](https://github.com/marijnh/style-mod#documentation)
  style spec providing the styles for the theme. These will be
  prefixed with a generated class for the style.
  
  Because the selectors will be prefixed with a scope class, rule
  that directly match the editor's [wrapper
  element](https://codemirror.net/6/docs/ref/#view.EditorView.dom)—to which the scope class will be
  added—need to be explicitly differentiated by adding an `&` to
  the selector for that element—for example
  `&.cm-focused`.
  
  When `dark` is set to true, the theme will be marked as dark,
  which will cause the `&dark` rules from [base
  themes](https://codemirror.net/6/docs/ref/#view.EditorView^baseTheme) to be used (as opposed to
  `&light` when a light theme is active).
  */
  static theme(e, t) {
    let n = Ht.newName(), r = [Fi.of(n), ri.of(pr(`.${n}`, e))];
    return t && t.dark && r.push(fr.of(!0)), r;
  }
  /**
  Create an extension that adds styles to the base theme. Like
  with [`theme`](https://codemirror.net/6/docs/ref/#view.EditorView^theme), use `&` to indicate the
  place of the editor wrapper element when directly targeting
  that. You can also use `&dark` or `&light` instead to only
  target editors with a dark or light theme.
  */
  static baseTheme(e) {
    return Df.lowest(ri.of(pr("." + gr, e, Ma)));
  }
  /**
  Retrieve an editor view instance from the view's DOM
  representation.
  */
  static findFromDOM(e) {
    var t;
    let n = e.querySelector(".cm-content"), r = n && q.get(n) || q.get(e);
    return ((t = r == null ? void 0 : r.rootView) === null || t === void 0 ? void 0 : t.view) || null;
  }
}
H.styleModule = ri;
H.inputHandler = sa;
H.clipboardInputFilter = zr;
H.clipboardOutputFilter = Nr;
H.scrollHandler = ha;
H.focusChangeEffect = la;
H.perLineTextDirection = aa;
H.exceptionSink = oa;
H.updateListener = cr;
H.editable = _e;
H.mouseSelectionStyle = ra;
H.dragMovesSelection = na;
H.clickAddsSelectionRange = ia;
H.decorations = wi;
H.outerDecorations = ua;
H.atomicRanges = Wr;
H.bidiIsolatedRanges = fa;
H.scrollMargins = ga;
H.darkTheme = fr;
H.cspNonce = /* @__PURE__ */ P.define({ combine: (i) => i.length ? i[0] : "" });
H.contentAttributes = Fr;
H.editorAttributes = da;
H.lineWrapping = /* @__PURE__ */ H.contentAttributes.of({ class: "cm-lineWrapping" });
H.announce = /* @__PURE__ */ ne.define();
const yp = 4096, hs = {};
class tn {
  constructor(e, t, n, r, o, s) {
    this.from = e, this.to = t, this.dir = n, this.isolates = r, this.fresh = o, this.order = s;
  }
  static update(e, t) {
    if (t.empty && !e.some((o) => o.fresh))
      return e;
    let n = [], r = e.length ? e[e.length - 1].dir : be.LTR;
    for (let o = Math.max(0, e.length - 10); o < e.length; o++) {
      let s = e[o];
      s.dir == r && !t.touchesRange(s.from, s.to) && n.push(new tn(t.mapPos(s.from, 1), t.mapPos(s.to, -1), s.dir, s.isolates, !1, s.order));
    }
    return n;
  }
}
function cs(i, e, t) {
  for (let n = i.state.facet(e), r = n.length - 1; r >= 0; r--) {
    let o = n[r], s = typeof o == "function" ? o(i) : o;
    s && rr(s, t);
  }
  return t;
}
class Ut extends Wt {
  /**
  @internal
  */
  compare(e) {
    return this == e || this.constructor == e.constructor && this.eq(e);
  }
  /**
  Compare this marker to another marker of the same type.
  */
  eq(e) {
    return !1;
  }
  /**
  Called if the marker has a `toDOM` method and its representation
  was removed from a gutter.
  */
  destroy(e) {
  }
}
Ut.prototype.elementClass = "";
Ut.prototype.toDOM = void 0;
Ut.prototype.mapMode = Ae.TrackBefore;
Ut.prototype.startSide = Ut.prototype.endSide = -1;
Ut.prototype.point = !0;
const Da = ne.define(), Oa = ne.define(), wp = ye.mark({
  attributes: { style: "background-color: yellow; color: black" }
}), xp = At.define({
  // Start with an empty set of decorations
  create() {
    return ye.none;
  },
  // This is called whenever the editor updates it computes the new set
  update(i, e) {
    return i = i.map(e.changes), e.effects.forEach((t) => {
      t.is(Da) ? i = i.update({
        add: t.value,
        sort: !0
      }) : t.is(Oa) && (i = i.update({ filter: t.value }));
    }), i;
  },
  // Indicate that this field provides a set of decorations
  provide: (i) => H.decorations.from(i)
}), Zm = m.forwardRef(
  ({
    hasError: i,
    required: e,
    id: t,
    value: n = "",
    disabled: r = !1,
    onChange: o = () => null,
    ...s
  }, l) => {
    const a = m.useRef(), c = m.useRef(), h = m.useRef(), { error: d, ...f } = Ce("JsonInput"), g = !!d || i, p = f.id ?? t, b = f.required || e;
    let w;
    d ? w = `${p}-error` : f.hint && (w = `${p}-hint`);
    const y = (z) => {
      var Q, U;
      const F = (Q = c.current) == null ? void 0 : Q.doc;
      if (F) {
        const { text: K, to: L } = F.line(z), se = L - K.trimStart().length;
        L > se && ((U = h.current) == null || U.dispatch({
          effects: Da.of([wp.range(se, L)])
        }));
      }
    }, v = () => {
      var F, Q;
      const z = (F = c.current) == null ? void 0 : F.doc;
      if (z) {
        const U = z.length || 0;
        (Q = h.current) == null || Q.dispatch({
          effects: Oa.of((K, L) => L <= 0 || K >= U)
        });
      }
    }, k = ({ state: z, view: F }) => {
      h.current = F, c.current = z, v();
      const U = Oh()(F);
      U.length && y(z.doc.lineAt(U[0].from).number);
    }, C = (z, F) => {
      k(F), o(z);
    }, A = (z, F) => {
      h.current = z, c.current = F, k({ view: z, state: F });
    }, { setContainer: S, view: M } = Eh({
      value: n,
      onCreateEditor: A,
      container: a.current,
      editable: !r,
      extensions: [Dh(), xp],
      onChange: C,
      theme: "dark",
      basicSetup: {
        lineNumbers: !0,
        bracketMatching: !0,
        closeBrackets: !0,
        indentOnInput: !0,
        syntaxHighlighting: !0,
        highlightSelectionMatches: !0,
        tabSize: 2
      }
    }), N = ve(a, S);
    return m.useImperativeHandle(
      l,
      () => ({
        ...M == null ? void 0 : M.dom,
        focus() {
          M && M.focus();
        },
        scrollIntoView(z) {
          M && M.dom.scrollIntoView(z);
        }
      }),
      [M]
    ), /* @__PURE__ */ u(
      vp,
      {
        ref: N,
        $disabled: r,
        $hasError: g,
        alignItems: "stretch",
        hasRadius: !0,
        "aria-required": b,
        id: p,
        "aria-describedby": w,
        ...s
      }
    );
  }
), vp = x(T)`
  font-size: ${({ theme: i }) => i.fontSizes[3]};
  line-height: ${({ theme: i }) => i.lineHeights[6]};

  ${({ theme: i }) => i.breakpoints.medium} {
    font-size: ${({ theme: i }) => i.fontSizes[2]};
    line-height: ${({ theme: i }) => i.lineHeights[2]};
  }
  .cm-editor {
    /** 
     * Hard coded since the color is the same between themes,
     * theme.colors.neutral800 changes between themes 
     */
    background-color: #32324d;
    width: 100%;
    outline: none;
    cursor: ${({ $disabled: i }) => i ? "not-allowed" : "text"};
  }

  .cm-scroller {
    border: 1px solid ${({ theme: i, $hasError: e }) => e ? i.colors.danger600 : i.colors.neutral200};
    /* inputFocusStyle will receive hasError prop */
    ${at()}
  }

  .cm-editor,
  .cm-scroller {
    border-radius: ${({ theme: i }) => i.borderRadius};
  }

  .cm-gutters,
  .cm-activeLineGutter {
    /** 
     * Hard coded since the color is the same between themes,
     * theme.colors.neutral700 changes between themes 
     */
    background-color: #4a4a6a;
  }
`, e1 = xe(
  ({ disabled: i, ...e }, t) => /* @__PURE__ */ u(
    zn,
    {
      ref: t,
      tag: vi,
      tabIndex: i ? -1 : void 0,
      disabled: i,
      ...e
    }
  )
), Sp = x(R)`
  // To prevent global outline on focus visible to force an outline when Main is focused
  &:focus-visible {
    outline: none;
  }
`, t1 = ({ labelledBy: i = "main-content-title", ...e }) => /* @__PURE__ */ u(Sp, { "aria-labelledby": i, tag: "main", id: "main-content", tabIndex: -1, ...e }), Cp = x(R)`
  text-decoration: none;

  &:focus {
    left: ${({ theme: i }) => i.spaces[3]};
    top: ${({ theme: i }) => i.spaces[3]};
  }
`, i1 = ({ children: i }) => /* @__PURE__ */ u(
  Cp,
  {
    tag: "a",
    href: "#main-content",
    background: "primary600",
    color: "neutral0",
    left: "-100%",
    padding: 3,
    position: "absolute",
    top: "-100%",
    hasRadius: !0,
    zIndex: 9999,
    children: i
  }
), kp = $t.Root, $p = m.forwardRef((i, e) => /* @__PURE__ */ u($t.Trigger, { ...i, asChild: !0, ref: e })), Ap = m.forwardRef((i, e) => /* @__PURE__ */ u($t.Portal, { children: /* @__PURE__ */ u(Tp, { children: /* @__PURE__ */ u(Rp, { ref: e, ...i }) }) })), Tp = x($t.Overlay)`
  background: ${(i) => rl(i.theme.colors.neutral800, 0.2)};
  position: fixed;
  inset: 0;
  z-index: ${(i) => i.theme.zIndices.overlay};
  will-change: opacity;

  @media (prefers-reduced-motion: no-preference) {
    animation: ${te.overlayFadeIn} ${(i) => i.theme.motion.timings[200]}
      ${(i) => i.theme.motion.easings.authenticMotion};
  }
`, Rp = x($t.Content)`
  max-width: 83rem;
  max-height: 90vh;
  height: auto;
  width: calc(100% - ${({ theme: i }) => i.spaces[8]});
  overflow: hidden;
  margin: 0 auto;
  display: flex;
  flex-direction: column;

  position: fixed;
  top: 50%;
  left: 50%;
  transform: translate(-50%, -50%);

  border-radius: ${(i) => i.theme.borderRadius};
  background-color: ${(i) => i.theme.colors.neutral0};
  box-shadow: ${(i) => i.theme.shadows.popupShadow};
  z-index: ${(i) => i.theme.zIndices.modal};

  ${({ theme: i }) => i.breakpoints.medium} {
    width: calc(100% - ${({ theme: i }) => i.spaces[9]});
  }
  > form {
    display: flex;
    flex-direction: column;
    overflow: hidden;
  }
  @media (prefers-reduced-motion: no-preference) {
    &[data-state='open'] {
      animation-duration: ${(i) => i.theme.motion.timings[200]};
      animation-timing-function: ${(i) => i.theme.motion.easings.authenticMotion};
      animation-name: ${te.modalPopIn};
    }

    &[data-state='closed'] {
      animation-duration: ${(i) => i.theme.motion.timings[120]};
      animation-timing-function: ${(i) => i.theme.motion.easings.easeOutQuad};
      animation-name: ${te.modalPopOut};
    }
  }
`, Ea = m.forwardRef((i, e) => /* @__PURE__ */ u($t.Close, { ...i, asChild: !0, ref: e })), Mp = m.forwardRef(
  ({ children: i, closeLabel: e = "Close modal", ...t }, n) => /* @__PURE__ */ $(
    Dp,
    {
      ref: n,
      padding: 4,
      paddingLeft: 5,
      paddingRight: 5,
      background: "neutral100",
      justifyContent: "space-between",
      ...t,
      tag: "header",
      children: [
        i,
        /* @__PURE__ */ u(Ea, { children: /* @__PURE__ */ u(ot, { withTooltip: !1, label: e, children: /* @__PURE__ */ u(kt, {}) }) })
      ]
    }
  )
), Dp = x(T)`
  border-bottom: solid 1px ${(i) => i.theme.colors.neutral150};
`, Op = m.forwardRef((i, e) => /* @__PURE__ */ u($t.Title, { asChild: !0, children: /* @__PURE__ */ u(I, { tag: "h2", variant: "omega", fontWeight: "bold", ref: e, ...i }) })), Ep = m.forwardRef(({ children: i, ...e }, t) => /* @__PURE__ */ u(Ip, { ref: t, ...e, children: i })), Ip = x(hn)`
  padding-inline: ${(i) => i.theme.spaces[7]};

  & > div {
    padding-block: ${(i) => i.theme.spaces[8]};
    /* Add negative margin and padding to avoid cropping the box shadow when the inputs are focused */
    margin: 0 -2px 0 -2px;
    padding-left: 2px;
    padding-right: 2px;

    & > div {
      // the scroll area component applies a display: table to the child, which we don't want.
      display: block !important;
    }
  }
`, Pp = m.forwardRef((i, e) => /* @__PURE__ */ u(
  Lp,
  {
    ref: e,
    padding: 4,
    paddingLeft: 5,
    paddingRight: 5,
    background: "neutral100",
    justifyContent: "space-between",
    ...i,
    tag: "footer"
  }
)), Lp = x(T)`
  border-top: solid 1px ${(i) => i.theme.colors.neutral150};
  flex: 1;
`, n1 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  Body: Ep,
  Close: Ea,
  Content: Ap,
  Footer: Pp,
  Header: Mp,
  Root: kp,
  Title: Op,
  Trigger: $p
}, Symbol.toStringTag, { value: "Module" })), Bp = "", r1 = m.forwardRef(
  ({ startAction: i, locale: e, onValueChange: t, value: n, step: r = 1, disabled: o = !1, ...s }, l) => {
    const a = cn("NumberInput"), c = e || a.locale, h = m.useRef(new Ih(c, { style: "decimal" })), d = m.useRef(new Ph(c, { maximumFractionDigits: 20 })), [f, g] = zp({
      prop(S) {
        const M = String(n);
        return isNaN(Number(M)) || M !== S && S !== "" ? S : d.current.format(Number(n));
      },
      defaultProp: Bp,
      onChange(S) {
        if (!t) return;
        const M = h.current.parse(S ?? "");
        t(isNaN(M) ? void 0 : M);
      }
    }), p = (S) => {
      g(String(S));
    }, b = ({ target: { value: S } }) => {
      h.current.isValidPartialNumber(S) && p(S);
    }, y = ((S) => {
      const M = S.toString();
      return M.includes(".") ? M.split(".")[1].length : 0;
    })(r), v = () => {
      if (!f) {
        p(r);
        return;
      }
      const S = h.current.parse(f), M = isNaN(S) ? r : S + r, N = parseFloat(M.toFixed(y));
      p(d.current.format(N));
    }, k = () => {
      if (!f) {
        p(-r);
        return;
      }
      const S = h.current.parse(f), M = isNaN(S) ? -r : S - r, N = parseFloat(M.toFixed(y));
      p(d.current.format(N));
    };
    return /* @__PURE__ */ u(
      an,
      {
        ref: l,
        startAction: i,
        disabled: o,
        type: "text",
        inputMode: "decimal",
        onChange: b,
        onKeyDown: (S) => {
          if (!o)
            switch (S.key) {
              case Y.DOWN: {
                S.preventDefault(), k();
                break;
              }
              case Y.UP: {
                S.preventDefault(), v();
                break;
              }
            }
        },
        onBlur: () => {
          if (f) {
            const S = h.current.parse(f), M = isNaN(S) ? "" : d.current.format(S);
            p(M);
          }
        },
        value: f,
        endAction: /* @__PURE__ */ $(T, { direction: "column", children: [
          /* @__PURE__ */ u(
            ds,
            {
              disabled: o,
              "aria-hidden": !0,
              $reverse: !0,
              onClick: v,
              tabIndex: -1,
              type: "button",
              "data-testid": "ArrowUp",
              children: /* @__PURE__ */ u(Ze, { fill: "neutral500" })
            }
          ),
          /* @__PURE__ */ u(
            ds,
            {
              disabled: o,
              "aria-hidden": !0,
              onClick: k,
              tabIndex: -1,
              type: "button",
              "data-testid": "ArrowDown",
              children: /* @__PURE__ */ u(Ze, { fill: "neutral500" })
            }
          )
        ] }),
        ...s
      }
    );
  }
), ds = x.button`
  display: flex;
  justify-content: center;
  align-items: center;
  transform: translateY(${({ $reverse: i }) => i ? "-2px" : "2px"});
  cursor: ${({ disabled: i }) => i ? "not-allowed" : void 0};
  height: 1.1rem;

  svg {
    width: 1.2rem;
    transform: ${({ $reverse: i }) => i ? "rotateX(180deg)" : void 0};
  }
`;
function zp({
  prop: i,
  defaultProp: e,
  onChange: t = () => {
  }
}) {
  const [n, r] = Os({
    defaultProp: e,
    onChange: t
  }), o = i !== void 0, s = i instanceof Function ? i(n) : i, l = o ? s : n, a = ws(t), c = m.useCallback(
    (h) => {
      if (o) {
        const f = typeof h == "function" ? h(s) : h;
        f !== s && (a(f), r(h));
      } else
        r(h);
    },
    [o, s, r, a]
  );
  return [l, c];
}
const Ia = m.createContext({ activePage: 1, pageCount: 1 }), qr = () => m.useContext(Ia), o1 = ({ children: i, label: e = "Pagination", activePage: t, pageCount: n }) => {
  const r = m.useMemo(() => ({ activePage: t, pageCount: n }), [t, n]);
  return /* @__PURE__ */ u(Ia.Provider, { value: r, children: /* @__PURE__ */ u(R, { "aria-label": e, tag: "nav", children: /* @__PURE__ */ u(T, { tag: "ol", gap: 1, children: m.Children.map(i, (o, s) => /* @__PURE__ */ u("li", { children: o }, s)) }) }) });
}, s1 = xe(
  ({ children: i, ...e }, t) => {
    const { activePage: n } = qr(), r = n === 1;
    return /* @__PURE__ */ $(La, { ref: t, "aria-disabled": r, tabIndex: r ? -1 : void 0, ...e, children: [
      /* @__PURE__ */ u(lt, { children: i }),
      /* @__PURE__ */ u(vs, { "aria-hidden": !0 })
    ] });
  }
), l1 = xe(
  ({ children: i, ...e }, t) => {
    const { activePage: n, pageCount: r } = qr(), o = n === r;
    return /* @__PURE__ */ $(La, { ref: t, "aria-disabled": o, tabIndex: o ? -1 : void 0, ...e, children: [
      /* @__PURE__ */ u(lt, { children: i }),
      /* @__PURE__ */ u(wr, { "aria-hidden": !0 })
    ] });
  }
), Pa = x(vi)`
  padding: ${({ theme: i }) => i.spaces[3]};
  border-radius: ${({ theme: i }) => i.borderRadius};
  box-shadow: ${({ $active: i, theme: e }) => i ? e.shadows.filterShadow : void 0};
  text-decoration: none;
  display: flex;

  ${on}
`, La = x(Pa)`
  font-size: 1.1rem;

  svg path {
    fill: ${(i) => i["aria-disabled"] ? i.theme.colors.neutral300 : i.theme.colors.neutral600};
  }

  &:focus,
  &:hover {
    svg path {
      fill: ${(i) => i["aria-disabled"] ? i.theme.colors.neutral300 : i.theme.colors.neutral700};
    }
  }

  ${(i) => i["aria-disabled"] ? `
  pointer-events: none;
    ` : void 0}
`, a1 = xe(
  ({ number: i, children: e, ...t }, n) => {
    const { activePage: r } = qr(), o = r === i;
    return /* @__PURE__ */ $(Np, { ref: n, ...t, "aria-current": o, $active: o, children: [
      /* @__PURE__ */ u(lt, { children: e }),
      /* @__PURE__ */ u(I, { "aria-hidden": !0, fontWeight: o ? "bold" : void 0, lineHeight: "revert", variant: "pi", children: i })
    ] });
  }
), Np = x(Pa)`
  color: ${({ theme: i, $active: e }) => e ? i.colors.primary700 : i.colors.neutral800};
  background: ${({ theme: i, $active: e }) => e ? i.colors.neutral0 : void 0};

  &:hover {
    box-shadow: ${({ theme: i }) => i.shadows.filterShadow};
  }
`, h1 = ({ children: i, ...e }) => /* @__PURE__ */ $(R, { ...e, children: [
  /* @__PURE__ */ u(lt, { children: i }),
  /* @__PURE__ */ u(I, { "aria-hidden": !0, lineHeight: "revert", textColor: "neutral800", variant: "pi", children: "…" })
] }), Fp = _t.Root, Wp = _t.Anchor, Hp = _t.Arrow, Vp = m.forwardRef((i, e) => /* @__PURE__ */ u(_t.Trigger, { ...i, asChild: !0, ref: e })), jp = m.forwardRef((i, e) => /* @__PURE__ */ u(_t.Portal, { children: /* @__PURE__ */ u(qp, { sideOffset: 4, side: "bottom", align: "start", ...i, ref: e }) })), qp = x(_t.Content)`
  box-shadow: ${({ theme: i }) => i.shadows.filterShadow};
  z-index: ${({ theme: i }) => i.zIndices.popover};
  background-color: ${(i) => i.theme.colors.neutral0};
  border: 1px solid ${({ theme: i }) => i.colors.neutral150};
  border-radius: ${({ theme: i }) => i.borderRadius};

  @media (prefers-reduced-motion: no-preference) {
    animation-duration: ${(i) => i.theme.motion.timings[200]};

    &[data-state='open'] {
      animation-timing-function: ${(i) => i.theme.motion.easings.authenticMotion};

      &[data-side='top'] {
        animation-name: ${te.slideUpIn};
      }

      &[data-side='bottom'] {
        animation-name: ${te.slideDownIn};
      }
    }

    &[data-state='closed'] {
      animation-timing-function: ${(i) => i.theme.motion.easings.easeOutQuad};

      &[data-side='top'] {
        animation-name: ${te.slideUpOut};
      }

      &[data-side='bottom'] {
        animation-name: ${te.slideDownOut};
      }
    }
  }
`, Kp = m.forwardRef(
  ({ children: i, intersectionId: e, onReachEnd: t, ...n }, r) => {
    const o = m.useRef(null), s = ve(o, r), l = Se();
    return Si(o, t ?? (() => {
    }), {
      selectorToWatch: `#${Nt(l)}`,
      skipWhen: !e || !t
    }), /* @__PURE__ */ $(Up, { ref: s, ...n, children: [
      i,
      e && t && /* @__PURE__ */ u(R, { id: Nt(l), width: "100%", height: "1px" })
    ] });
  }
), Up = x(hn)`
  height: 20rem;
`, c1 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  Anchor: Wp,
  Arrow: Hp,
  Content: jp,
  Root: Fp,
  ScrollArea: Kp,
  Trigger: Vp
}, Symbol.toStringTag, { value: "Module" })), d1 = m.forwardRef(
  ({ size: i = "M", value: e, ...t }, n) => /* @__PURE__ */ u(_p, { ref: n, $size: i, ...t, children: /* @__PURE__ */ u(Gp, { style: { transform: `translate3D(-${100 - (e ?? 0)}%, 0, 0)` } }) })
), _p = x(ks.Root)`
  position: relative;
  overflow: hidden;
  width: ${(i) => i.$size === "S" ? "7.8rem" : "10.2rem"};
  height: ${(i) => i.$size === "S" ? "0.4rem" : "0.8rem"};
  background-color: ${(i) => i.theme.colors.neutral600};
  border-radius: ${(i) => i.theme.borderRadius};

  /* Fix overflow clipping in Safari */
  /* https://gist.github.com/domske/b66047671c780a238b51c51ffde8d3a0 */
  transform: translateZ(0);
`, Gp = x(ks.Indicator)`
  background-color: ${({ theme: i }) => i.colors.neutral0};
  border-radius: ${({ theme: i }) => i.borderRadius};
  width: 100%;
  height: 100%;

  @media (prefers-reduced-motion: no-preference) {
    transition: transform ${(i) => i.theme.motion.timings[320]}
      ${(i) => i.theme.motion.easings.authenticMotion};
  }
`, Yp = m.forwardRef((i, e) => /* @__PURE__ */ u(Xp, { ref: e, ...i })), Xp = x(vr.Root)`
  display: flex;
  flex-direction: column;
  gap: ${(i) => i.theme.spaces[3]};
`, Jp = m.forwardRef(({ children: i, id: e, ...t }, n) => {
  const r = Se(e);
  return /* @__PURE__ */ $(T, { gap: 2, children: [
    /* @__PURE__ */ u(Qp, { id: r, ref: n, ...t, children: /* @__PURE__ */ u(Zp, {}) }),
    /* @__PURE__ */ u(I, { tag: "label", htmlFor: r, children: i })
  ] });
}), Qp = x(vr.Item)`
  background: ${(i) => i.theme.colors.neutral0};
  width: 2rem;
  height: 2rem;
  flex: 0 0 2rem;
  border-radius: 50%;
  border: 1px solid ${(i) => i.theme.colors.neutral300};
  position: relative;
  cursor: pointer;
  z-index: 0;

  @media (prefers-reduced-motion: no-preference) {
    transition: border-color ${(i) => i.theme.motion.timings[120]}
      ${(i) => i.theme.motion.easings.easeOutQuad};
  }

  &[data-state='checked'] {
    border: 1px solid ${(i) => i.theme.colors.primary600};
  }

  &[data-disabled] {
    cursor: not-allowed;
    background-color: ${(i) => i.theme.colors.neutral200};
  }

  /* increase target size for touch devices https://www.w3.org/WAI/WCAG21/Understanding/target-size.html */
  &::before {
    content: '';
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    width: 100%;
    height: 100%;
    min-width: 44px;
    min-height: 44px;
  }
`, Zp = x(vr.Indicator)`
  display: flex;
  align-items: center;
  justify-content: center;
  width: 100%;
  height: 100%;
  position: relative;

  &[data-state='checked'] {
    @media (prefers-reduced-motion: no-preference) {
      animation: ${te.popIn} ${(i) => i.theme.motion.timings[200]};
    }
  }

  &::after {
    content: '';
    display: block;
    width: 1rem;
    height: 1rem;
    border-radius: 50%;
    background: ${(i) => i.theme.colors.primary600};
  }
`, u1 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  Group: Yp,
  Item: Jp
}, Symbol.toStringTag, { value: "Module" })), e0 = (i) => {
  const e = i.querySelector('[tabindex="0"]');
  e && e.focus();
}, Ba = m.createContext({
  rowIndex: 0,
  colIndex: 0,
  setTableValues() {
    throw new Error("setTableValues must be initialized via the RawTableContext.Provider");
  }
}), t0 = () => m.useContext(Ba), i0 = m.forwardRef(
  ({ colCount: i, rowCount: e, jumpStep: t = 3, initialCol: n = 0, initialRow: r = 0, ...o }, s) => {
    const l = m.useRef(null), a = m.useRef(!1), c = ve(l, s), [h, d] = m.useState(r), [f, g] = m.useState(n), p = m.useCallback(({ colIndex: y, rowIndex: v }) => {
      g(y), d(v);
    }, []);
    m.useEffect(() => {
      a.current && e0(l.current), a.current || (a.current = !0);
    }, [f, h]);
    const b = (y) => {
      switch (y.key) {
        case Y.RIGHT: {
          y.preventDefault(), g((v) => v < i - 1 ? v + 1 : v);
          break;
        }
        case Y.LEFT: {
          y.preventDefault(), g((v) => v > 0 ? v - 1 : v);
          break;
        }
        case Y.UP: {
          y.preventDefault(), d((v) => v > 0 ? v - 1 : v);
          break;
        }
        case Y.DOWN: {
          y.preventDefault(), d((v) => v < e - 1 ? v + 1 : v);
          break;
        }
        case Y.HOME: {
          y.preventDefault(), y.ctrlKey && d(0), g(0);
          break;
        }
        case Y.END: {
          y.preventDefault(), y.ctrlKey && d(e - 1), g(i - 1);
          break;
        }
        case Y.PAGE_DOWN: {
          y.preventDefault(), d((v) => v + t < e ? v + t : e - 1);
          break;
        }
        case Y.PAGE_UP: {
          y.preventDefault(), d((v) => v - t > 0 ? v - t : 0);
          break;
        }
      }
    }, w = m.useMemo(() => ({ rowIndex: h, colIndex: f, setTableValues: p }), [f, h, p]);
    return /* @__PURE__ */ u(Ba.Provider, { value: w, children: /* @__PURE__ */ u(
      "table",
      {
        role: "grid",
        ref: c,
        "aria-rowcount": e,
        "aria-colcount": i,
        onKeyDown: b,
        ...o
      }
    ) });
  }
), mt = (i, e) => [
  ...i.querySelectorAll(
    'a, button, input, textarea, select, details, [tabindex]:not([tabindex="-1"])'
  )
].filter((r) => r.hasAttribute("disabled") ? !1 : e ? !0 : r.getAttribute("tabindex") !== "-1"), Rn = (i) => i.filter((e) => e.tagName === "INPUT" ? e.type !== "checkbox" && e.type !== "radio" : !1), za = m.forwardRef(
  ({ coords: i = { col: 0, row: 0 }, tag: e = "td", ...t }, n) => {
    const r = m.useRef(null), o = ve(n, r), { rowIndex: s, colIndex: l, setTableValues: a } = t0(), [c, h] = m.useState(!1), d = (p) => {
      var y;
      const b = mt(r.current, !0);
      if (b.length === 0 || b.length === 1 && Rn(b).length === 0)
        return;
      if (b.length > 1 && !b.find((v) => v.tagName !== "BUTTON")) {
        p.preventDefault();
        const v = b.findIndex((k) => k === document.activeElement);
        if (p.key === Y.RIGHT) {
          const k = b[v + 1];
          k && (p.stopPropagation(), k.focus());
        } else if (p.key === Y.LEFT) {
          const k = b[v - 1];
          k && (p.stopPropagation(), k.focus());
        }
        return;
      }
      const w = p.key === Y.ENTER;
      if (w && !c)
        h(!0);
      else if ((p.key === Y.ESCAPE || w) && c) {
        if (w && ((y = document.activeElement) == null ? void 0 : y.tagName) === "A")
          return;
        h(!1), r.current.focus();
      } else c && p.stopPropagation();
    }, f = s === i.row - 1 && l === i.col - 1;
    He(() => {
      const p = mt(r.current, !0);
      p.length === 0 || p.length === 1 && Rn(p).length !== 0 || p.length > 1 && p.find((b) => b.tagName !== "BUTTON") ? (r.current.setAttribute("tabIndex", !c && f ? "0" : "-1"), p.forEach((b, w) => {
        b.setAttribute("tabIndex", c ? "0" : "-1"), c && w === 0 && b.focus();
      })) : p.forEach((b) => {
        b.setAttribute("tabIndex", f ? "0" : "-1");
      });
    }, [c, f]);
    const g = m.useCallback(() => {
      const p = mt(r.current, !0);
      p.length >= 1 && (Rn(p).length !== 0 || !p.find((b) => b.tagName !== "BUTTON")) && h(!0), a({ rowIndex: i.row - 1, colIndex: i.col - 1 });
    }, [i, a]);
    return He(() => {
      const p = r.current;
      return mt(p, !0).forEach((w) => {
        w.addEventListener("focus", g);
      }), () => {
        mt(p, !0).forEach((y) => {
          y.removeEventListener("focus", g);
        });
      };
    }, [g]), /* @__PURE__ */ u(R, { role: "gridcell", tag: e, ref: o, onKeyDown: d, ...t });
  }
), n0 = (i) => /* @__PURE__ */ u(za, { ...i, tag: "th" }), r0 = ({ children: i, ...e }) => {
  const t = m.Children.toArray(i).map((n) => m.isValidElement(n) ? m.cloneElement(n, { "aria-rowindex": 1 }) : n);
  return /* @__PURE__ */ u("thead", { ...e, children: t });
}, o0 = ({ children: i, ...e }) => {
  const t = m.Children.toArray(i).map((n, r) => m.isValidElement(n) ? m.cloneElement(n, { "aria-rowindex": r + 2 }) : n);
  return /* @__PURE__ */ u("tbody", { ...e, children: t });
}, s0 = ({ children: i, ...e }) => {
  const t = m.Children.toArray(i).map((n, r) => m.isValidElement(n) ? m.cloneElement(n, {
    "aria-colindex": r + 1,
    coords: { col: r + 1, row: e["aria-rowindex"] }
  }) : n);
  return /* @__PURE__ */ u(R, { tag: "tr", ...e, children: t });
}, l0 = x(kt)`
  font-size: 0.5rem;
  path {
    fill: ${({ theme: i }) => i.colors.neutral500};
  }
`, Na = x(Ss)`
  font-size: 1rem;
  path {
    fill: ${({ theme: i }) => i.colors.neutral500};
  }
`, a0 = x.div`
  border-radius: ${({ theme: i }) => i.borderRadius};
  border: 1px solid ${({ theme: i }) => i.colors.neutral150};

  &:focus-within {
    ${Na} {
      fill: ${({ theme: i }) => i.colors.primary600};
    }
  }
`, h0 = x(an)`
  border: 1px solid ${({ theme: i }) => i.colors.neutral150};
  padding: 0 0 0 8px;
  color: ${({ theme: i }) => i.colors.neutral800};

  &:hover {
    button {
      cursor: pointer;
    }
  }

  ${at()}

  > input::-ms-clear {
    display: none;
    width: 0;
    height: 0;
  }

  > input::-ms-reveal {
    display: none;
    width: 0;
    height: 0;
  }

  > input::-webkit-search-decoration,
  > input::-webkit-search-cancel-button,
  > input::-webkit-search-results-button,
  > input::-webkit-search-results-decoration {
    display: none;
  }
`, c0 = m.forwardRef(
  ({ name: i, children: e, value: t = "", onClear: n, clearLabel: r = "Clear", ...o }, s) => {
    const l = m.useRef(null), a = t.length > 0, c = (d) => {
      n(d), l.current.focus();
    }, h = Bs(s, l);
    return /* @__PURE__ */ u(a0, { children: /* @__PURE__ */ $(xt, { name: i, children: [
      /* @__PURE__ */ u(lt, { children: /* @__PURE__ */ u(Rr, { children: e }) }),
      /* @__PURE__ */ u(
        h0,
        {
          size: "S",
          type: "search",
          ref: h,
          value: t,
          startAction: /* @__PURE__ */ u(Na, { "aria-hidden": !0 }),
          onKeyDown: (d) => {
            d.stopPropagation(), d.key === "Escape" && a && c(d);
          },
          endAction: a ? /* @__PURE__ */ u(
            ot,
            {
              onClick: c,
              onMouseDown: (d) => {
                d.preventDefault();
              },
              label: r,
              size: "XS",
              variant: "ghost",
              type: "button",
              children: /* @__PURE__ */ u(l0, {})
            }
          ) : void 0,
          ...o
        }
      )
    ] }) });
  }
), d0 = (i) => /* @__PURE__ */ u("form", { ...i, role: "search" }), u0 = x(R)`
  display: inline-flex;
  border: none;

  & > svg {
    height: 1.2rem;
    width: 1.2rem;
  }

  & > svg path {
    fill: ${({ theme: i, ...e }) => e["aria-disabled"] ? i.colors.neutral600 : i.colors.primary600};
  }

  &:hover {
    cursor: ${({ $iconAction: i }) => i ? "pointer" : "initial"};
  }
`, f0 = ({ children: i, icon: e, label: t, disabled: n = !1, onClick: r, ...o }) => /* @__PURE__ */ $(
  T,
  {
    inline: !0,
    background: n ? "neutral200" : "primary100",
    color: n ? "neutral700" : "primary600",
    paddingLeft: 3,
    paddingRight: 1,
    borderColor: n ? "neutral300" : "primary200",
    hasRadius: !0,
    height: "3.2rem",
    ...o,
    children: [
      /* @__PURE__ */ u(g0, { $disabled: n, variant: "pi", fontWeight: "bold", children: i }),
      /* @__PURE__ */ u(
        u0,
        {
          tag: "button",
          disabled: n,
          "aria-disabled": n,
          "aria-label": t,
          padding: 2,
          onClick: (l) => {
            n || !r || r(l);
          },
          $iconAction: !!r,
          children: e
        }
      )
    ]
  }
), g0 = x(I)`
  color: inherit;
  border-right: 1px solid ${({ theme: i, $disabled: e }) => e ? i.colors.neutral300 : i.colors.primary200};
  padding-right: ${({ theme: i }) => i.spaces[2]};
`, p0 = m.forwardRef(
  ({
    children: i,
    clearLabel: e = "Clear",
    customizeContent: t,
    disabled: n,
    hasError: r,
    id: o,
    name: s,
    onChange: l,
    onClear: a,
    onCloseAutoFocus: c,
    onReachEnd: h,
    placeholder: d,
    required: f,
    size: g,
    startIcon: p,
    value: b,
    withTags: w,
    ...y
  }, v) => {
    const k = m.useRef(null), [C, A] = m.useState(), [S, M] = m.useState(!1), N = (V) => {
      l ? l(V) : A(V);
    }, z = (V) => () => {
      const qe = Array.isArray(b) ? b.filter((ae) => ae !== V) : (C ?? []).filter((ae) => ae !== V);
      l ? l(qe) : A(qe);
    }, F = (V) => {
      M(V);
    }, Q = Se(), U = `intersection-${Nt(Q)}`;
    Si(k, (V) => {
      h && h(V);
    }, {
      selectorToWatch: `#${U}`,
      /**
       * We need to know when the select is open because only then will viewportRef
       * not be null. Because it uses a portal that (sensibly) is not mounted 24/7.
       */
      skipWhen: !S
    });
    const L = typeof b < "u" && b !== null ? b : C, se = (V) => V && typeof V == "object" && V.value ? /* @__PURE__ */ u(
      f0,
      {
        tabIndex: -1,
        disabled: n,
        icon: /* @__PURE__ */ u(kt, { width: `${14 / 16}rem`, height: `${14 / 16}rem` }),
        onClick: z(V.value),
        children: V.textValue
      },
      V.value
    ) : null, { error: ue, ...B } = Ce("MultiSelect"), J = !!ue || r, re = B.id ?? o, oe = B.name ?? s, le = B.required ?? f;
    let Be;
    return ue ? Be = `${re}-error` : B.hint && (Be = `${re}-hint`), /* @__PURE__ */ $(
      al,
      {
        onOpenChange: F,
        disabled: n,
        required: le,
        onValueChange: N,
        value: L,
        ...y,
        multi: !0,
        children: [
          /* @__PURE__ */ u(
            hl,
            {
              ref: v,
              id: re,
              name: oe,
              "aria-label": y["aria-label"],
              "aria-describedby": Be ?? y["aria-describedby"],
              startIcon: p,
              hasError: J,
              disabled: n,
              clearLabel: e,
              onClear: L != null && L.length ? a : void 0,
              withTags: !!(w && ((L == null ? void 0 : L.length) ?? !1)),
              size: g,
              children: /* @__PURE__ */ u(
                cl,
                {
                  placeholder: d,
                  textColor: L != null && L.length ? "neutral800" : "neutral600",
                  withTags: w,
                  children: L != null && L.length ? w ? se : t ? t(L) : void 0 : void 0
                }
              )
            }
          ),
          /* @__PURE__ */ u(dl, { children: /* @__PURE__ */ u(ul, { position: "popper", sideOffset: 4, onCloseAutoFocus: c, children: /* @__PURE__ */ $(fl, { ref: k, children: [
            i,
            /* @__PURE__ */ u(R, { id: U, width: "100%", height: "1px" })
          ] }) }) })
        ]
      }
    );
  }
), Fa = m.forwardRef(
  ({ value: i, children: e, startIcon: t, ...n }, r) => /* @__PURE__ */ $(Dr, { ref: r, value: i.toString(), ...n, children: [
    t && /* @__PURE__ */ u(R, { tag: "span", "aria-hidden": !0, children: t }),
    /* @__PURE__ */ u(gl, { children: ({ isSelected: o, isIntermediate: s }) => /* @__PURE__ */ u(Tr, { checked: s ? "indeterminate" : o }) }),
    /* @__PURE__ */ u(I, { children: /* @__PURE__ */ u(pl, { children: e }) })
  ] })
), m0 = m.forwardRef(
  ({ children: i, label: e, startIcon: t, values: n = [], ...r }, o) => /* @__PURE__ */ $(qu, { ref: o, children: [
    /* @__PURE__ */ $(Dr, { value: n, ...r, children: [
      t && /* @__PURE__ */ u(R, { tag: "span", "aria-hidden": !0, children: t }),
      /* @__PURE__ */ u(gl, { children: ({ isSelected: s, isIntermediate: l }) => /* @__PURE__ */ u(Tr, { checked: l ? "indeterminate" : s }) }),
      /* @__PURE__ */ u(I, { children: e })
    ] }),
    i
  ] })
), f1 = ({ options: i, ...e }) => /* @__PURE__ */ u(p0, { ...e, children: i.map((t) => "children" in t ? /* @__PURE__ */ u(
  m0,
  {
    label: t.label,
    values: t.children.map((n) => n.value.toString()),
    children: t.children.map((n) => /* @__PURE__ */ u(b0, { value: n.value, children: n.label }, n.value))
  },
  t.label
) : /* @__PURE__ */ u(Fa, { value: t.value, children: t.label }, t.value)) }), b0 = x(Fa)`
  padding-left: ${({ theme: i }) => i.spaces[7]};
`, y0 = (i) => i === "XS" ? { paddingX: "0.6rem", paddingY: "0.2rem" } : i === "S" ? { paddingX: 2, paddingY: 1 } : { paddingX: 5, paddingY: 4 }, g1 = ({ variant: i = "primary", size: e = "M", children: t, ...n }) => {
  const r = `${i}100`, o = `${i}200`, s = `${i}600`, { paddingX: l, paddingY: a } = y0(e);
  return /* @__PURE__ */ u(
    R,
    {
      borderColor: o,
      color: s,
      background: r,
      hasRadius: !0,
      paddingTop: a,
      paddingBottom: a,
      paddingLeft: l,
      paddingRight: l,
      ...n,
      children: t
    }
  );
}, w0 = "23.2rem", p1 = m.forwardRef(({ ...i }, e) => /* @__PURE__ */ u(x0, { ref: e, ...i, tag: "nav" })), x0 = x(R)`
  width: ${w0};
  background: ${({ theme: i }) => i.colors.neutral100};
  position: sticky;
  top: 0;
  height: 100vh;
  overflow-y: auto;
  border-right: 1px solid ${({ theme: i }) => i.colors.neutral200};
  z-index: 1;
`, us = x(bl)`
  width: 2.4rem;
  background-color: ${({ theme: i }) => i.colors.neutral200};
`, m1 = ({
  tag: i = "h2",
  label: e,
  searchLabel: t = "",
  searchable: n = !1,
  onChange: r = () => {
  },
  value: o = "",
  onClear: s = () => {
  },
  onSubmit: l = () => {
  },
  id: a,
  placeholder: c
}) => {
  const [h, d] = m.useState(!1), f = uh(h), g = Se(a), p = m.useRef(void 0), b = m.useRef(void 0);
  m.useEffect(() => {
    h && p.current && p.current.focus(), f && !h && b.current && b.current.focus();
  }, [h, f]);
  const w = () => {
    d((C) => !C);
  }, y = (C) => {
    s(C), p.current.focus();
  }, v = (C) => {
    var A;
    ((A = C.relatedTarget) == null ? void 0 : A.id) !== g && d(!1);
  }, k = (C) => {
    C.key === Y.ESCAPE && d(!1);
  };
  return h ? /* @__PURE__ */ $(R, { paddingLeft: 4, paddingTop: 5, paddingBottom: 2, paddingRight: 4, children: [
    /* @__PURE__ */ u(d0, { children: /* @__PURE__ */ u(
      c0,
      {
        name: "searchbar",
        value: o,
        onChange: r,
        placeholder: c,
        onKeyDown: k,
        ref: p,
        onBlur: v,
        onClear: y,
        onSubmit: l,
        clearLabel: "Clear",
        children: t
      }
    ) }),
    /* @__PURE__ */ u(R, { paddingLeft: 2, paddingTop: 4, children: /* @__PURE__ */ u(us, {}) })
  ] }) : /* @__PURE__ */ $(T, { direction: "column", alignItems: "flex-start", paddingLeft: 6, paddingTop: 6, paddingBottom: 2, paddingRight: 4, children: [
    /* @__PURE__ */ $(T, { justifyContent: "space-between", alignItems: "flex-start", width: "100%", gap: 2, children: [
      /* @__PURE__ */ u(I, { variant: "beta", tag: i, children: e }),
      n && /* @__PURE__ */ u(ot, { ref: b, onClick: w, label: t, children: /* @__PURE__ */ u(Ss, {}) })
    ] }),
    /* @__PURE__ */ u(R, { paddingTop: 4, children: /* @__PURE__ */ u(us, {}) })
  ] });
}, b1 = xe(
  ({ active: i, children: e, icon: t = null, withBullet: n = !1, isSubSectionChild: r = !1, ...o }, s) => /* @__PURE__ */ $(
    v0,
    {
      background: "neutral100",
      paddingLeft: r ? 9 : 7,
      paddingBottom: 2,
      paddingTop: 2,
      ref: s,
      ...o,
      children: [
        /* @__PURE__ */ $(T, { children: [
          t ? /* @__PURE__ */ u(S0, { children: t }) : /* @__PURE__ */ u(mr, { $active: i }),
          /* @__PURE__ */ u(I, { paddingLeft: 2, children: e })
        ] }),
        n && /* @__PURE__ */ u(T, { paddingRight: 4, children: /* @__PURE__ */ u(mr, { $active: !0 }) })
      ]
    }
  )
), mr = x.span`
  width: 0.4rem;
  height: 0.4rem;
  background-color: ${({ theme: i, $active: e }) => e ? i.colors.primary600 : i.colors.neutral600};
  border-radius: 50%;
`, v0 = x(vi)`
  display: flex;
  align-items: center;
  justify-content: space-between;
  text-decoration: none;
  color: ${({ theme: i }) => i.colors.neutral800};
  svg > * {
    fill: ${({ theme: i }) => i.colors.neutral600};
  }

  &.active {
    ${({ theme: i }) => D`
        background-color: ${i.colors.primary100};
        border-right: 2px solid ${i.colors.primary600};
        color: ${i.colors.primary700};
        font-weight: 500;
      `}

    ${mr} {
      background-color: ${({ theme: i }) => i.colors.primary600};
    }
  }

  &:focus-visible {
    outline-offset: -2px;
  }
`, S0 = x.div`
  svg {
    height: 1.6rem;
    width: 1.6rem;
  }
`, C0 = x.button`
  border: none;
  padding: 0;
  background: transparent;
  display: flex;
  align-items: center;
`, y1 = ({ label: i, children: e, id: t }) => {
  const [n, r] = m.useState(!0), o = Se(t);
  return /* @__PURE__ */ $(R, { children: [
    /* @__PURE__ */ u(R, { paddingLeft: 7, paddingTop: 2, paddingBottom: 2, paddingRight: 4, children: /* @__PURE__ */ u(T, { justifyContent: "space-between", children: /* @__PURE__ */ $(C0, { onClick: () => {
      r((l) => !l);
    }, "aria-expanded": n, "aria-controls": o, children: [
      /* @__PURE__ */ u(
        Ze,
        {
          width: "1.2rem",
          height: "1.2rem",
          "aria-hidden": !0,
          fill: "neutral700",
          style: { transform: `rotateX(${n ? "0deg" : "180deg"})` }
        }
      ),
      /* @__PURE__ */ u(R, { paddingLeft: 2, children: /* @__PURE__ */ u(I, { tag: "span", fontWeight: "semiBold", textColor: "neutral800", children: i }) })
    ] }) }) }),
    n && /* @__PURE__ */ u("ul", { id: o, children: m.Children.map(e, (l, a) => /* @__PURE__ */ u("li", { children: l }, a)) })
  ] });
}, k0 = ({
  collapsable: i = !1,
  label: e,
  onClick: t = () => {
  },
  ariaExpanded: n,
  ariaControls: r
}) => i ? /* @__PURE__ */ $(
  T,
  {
    tag: "button",
    onClick: t,
    "aria-expanded": n,
    "aria-controls": r,
    textAlign: "left",
    alignItems: "center",
    children: [
      /* @__PURE__ */ u(R, { paddingRight: 1, children: /* @__PURE__ */ u(I, { variant: "sigma", textColor: "neutral600", children: e }) }),
      i && /* @__PURE__ */ u(
        Ze,
        {
          width: "1.2rem",
          "aria-hidden": !0,
          fill: "neutral500",
          style: { transform: n ? "rotateX(0deg)" : "rotateX(180deg)" }
        }
      )
    ]
  }
) : /* @__PURE__ */ u(T, { children: /* @__PURE__ */ u(R, { paddingRight: 1, children: /* @__PURE__ */ u(I, { variant: "sigma", textColor: "neutral600", children: e }) }) }), $0 = x(R)`
  & > svg {
    height: 0.4rem;
    fill: ${({ theme: i }) => i.colors.neutral500};
  }
`, w1 = ({ collapsable: i = !1, label: e, badgeLabel: t, children: n, id: r }) => {
  const [o, s] = m.useState(!0), l = Se(r);
  return /* @__PURE__ */ $(T, { direction: "column", alignItems: "stretch", gap: 1, children: [
    /* @__PURE__ */ u($0, { paddingLeft: 6, paddingTop: 2, paddingBottom: 2, paddingRight: 4, children: /* @__PURE__ */ $(R, { position: "relative", paddingRight: t ? 6 : 0, children: [
      /* @__PURE__ */ u(
        k0,
        {
          onClick: () => {
            s((c) => !c);
          },
          ariaExpanded: o,
          ariaControls: l,
          collapsable: i,
          label: e
        }
      ),
      t && /* @__PURE__ */ u(
        Ps,
        {
          backgroundColor: "neutral150",
          textColor: "neutral600",
          position: "absolute",
          right: 0,
          top: "50%",
          transform: "translateY(-50%)",
          children: t
        }
      )
    ] }) }),
    (!i || o) && /* @__PURE__ */ u("ol", { id: l, children: m.Children.map(n, (c, h) => /* @__PURE__ */ u("li", { children: c }, h)) })
  ] });
}, x1 = ({ children: i, spacing: e = 2, horizontal: t = !1, ...n }) => /* @__PURE__ */ u(R, { paddingTop: 2, paddingBottom: 4, children: /* @__PURE__ */ u(
  T,
  {
    tag: "ol",
    gap: e,
    direction: t ? "row" : "column",
    alignItems: t ? "center" : "stretch",
    ...n,
    children: m.Children.map(i, (r, o) => /* @__PURE__ */ u("li", { children: r }, o))
  }
) }), v1 = m.forwardRef(
  ({
    visibleLabels: i,
    onLabel: e = "On",
    offLabel: t = "Off",
    onCheckedChange: n,
    checked: r,
    defaultChecked: o,
    disabled: s,
    ...l
  }, a) => {
    const [c, h] = We({
      prop: r,
      defaultProp: o
    });
    return /* @__PURE__ */ $(T, { gap: 3, children: [
      /* @__PURE__ */ u(
        A0,
        {
          ref: a,
          onCheckedChange: wt(n, (f) => {
            h(f);
          }),
          checked: c,
          disabled: s,
          ...l,
          children: /* @__PURE__ */ u(T0, {})
        }
      ),
      i ? /* @__PURE__ */ u(R0, { "aria-hidden": !0, "data-disabled": s, "data-state": c ? "checked" : "unchecked", children: c ? e : t }) : null
    ] });
  }
), A0 = x($s.Root)`
  width: 4rem;
  height: 2.4rem;
  border-radius: 1.2rem;
  background-color: ${({ theme: i }) => i.colors.danger500};

  &[data-state='checked'] {
    background-color: ${({ theme: i }) => i.colors.success500};
  }

  &[data-disabled] {
    background-color: ${({ theme: i }) => i.colors.neutral300};
  }

  @media (prefers-reduced-motion: no-preference) {
    transition: ${(i) => i.theme.transitions.backgroundColor};
  }
`, T0 = x($s.Thumb)`
  display: block;
  height: 1.6rem;
  width: 1.6rem;
  border-radius: 50%;
  background-color: ${({ theme: i }) => i.colors.neutral0};
  transform: translateX(4px);

  &[data-state='checked'] {
    transform: translateX(20px);
  }

  @media (prefers-reduced-motion: no-preference) {
    transition: transform ${(i) => i.theme.motion.timings[120]}
      ${(i) => i.theme.motion.easings.authenticMotion};
  }
`, R0 = x(I)`
  color: ${(i) => i.theme.colors.danger600};

  &[data-state='checked'] {
    color: ${(i) => i.theme.colors.success600};
  }

  &[data-disabled='true'] {
    color: ${({ theme: i }) => i.colors.neutral500};
  }
`, [M0, Kr] = Gt("Tabs"), D0 = m.forwardRef(
  ({ disabled: i = !1, variant: e = "regular", hasError: t, ...n }, r) => /* @__PURE__ */ u(M0, { disabled: i, hasError: t, variant: e, children: /* @__PURE__ */ u(O0, { ref: r, ...n }) })
), O0 = x(rn.Root)`
  width: 100%;
  position: relative;
`, E0 = m.forwardRef((i, e) => {
  const { variant: t } = Kr("List");
  return /* @__PURE__ */ u(I0, { ref: e, ...i, $variant: t });
}), I0 = x(rn.List)`
  display: flex;
  align-items: ${(i) => i.$variant === "regular" ? "flex-end" : "unset"};
  position: relative;
  z-index: 0;
`, P0 = m.forwardRef(
  ({ children: i, disabled: e, ...t }, n) => {
    const { disabled: r, variant: o, hasError: s } = Kr("Trigger"), l = r === !0 || r === t.value || e, a = s === t.value;
    return /* @__PURE__ */ $(L0, { ref: n, ...t, $hasError: a, $variant: o, disabled: l, children: [
      /* @__PURE__ */ u(Ha, { fontWeight: "bold", variant: o === "simple" ? "sigma" : void 0, children: i }),
      o === "simple" ? /* @__PURE__ */ u(Wa, {}) : null
    ] });
  }
), Wa = x.span`
  display: block;
  width: 100%;
  background-color: currentColor;
  position: absolute;
  bottom: 0;
  left: 0;
  opacity: 0;
  height: 0.2rem;
`, Ha = x(I)``, L0 = x(rn.Trigger)`
  position: relative;
  color: ${(i) => i.$hasError ? i.theme.colors.danger600 : i.theme.colors.neutral600};
  cursor: pointer;
  z-index: 0;

  ${(i) => i.$variant === "simple" ? D`
        padding-block: ${(e) => e.theme.spaces[4]};
        padding-inline: ${(e) => e.theme.spaces[4]};

        & > ${Ha} {
          line-height: 1.2rem;
        }

        &[data-state='active'] {
          color: ${i.$hasError ? i.theme.colors.danger600 : i.theme.colors.primary700};

          & > ${Wa} {
            opacity: 1;
          }
        }
      ` : D`
        padding-block: ${(e) => e.theme.spaces[3]};
        padding-inline: ${(e) => e.theme.spaces[3]};
        flex: 1;
        background-color: ${(e) => e.theme.colors.neutral100};
        border-bottom: solid 1px ${(e) => e.theme.colors.neutral150};

        &:not([data-state='active']) + &:not([data-state='active']) {
          border-left: solid 1px ${(e) => e.theme.colors.neutral150};
        }

        &[data-state='active'] {
          padding-block: ${(e) => e.theme.spaces[4]};
          padding-inline: ${(e) => e.theme.spaces[4]};
          color: ${i.$hasError ? i.theme.colors.danger600 : i.theme.colors.primary700};
          border-top-right-radius: ${(e) => e.theme.borderRadius};
          border-top-left-radius: ${(e) => e.theme.borderRadius};
          background-color: ${(e) => e.theme.colors.neutral0};
          border-bottom: solid 1px ${(e) => e.theme.colors.neutral0};
          box-shadow: ${i.theme.shadows.tableShadow};
          z-index: 1;
        }
      `}

  &[data-disabled] {
    cursor: not-allowed;
    color: ${(i) => i.theme.colors.neutral400};
  }
`, B0 = m.forwardRef((i, e) => {
  const { variant: t } = Kr("Content");
  return /* @__PURE__ */ u(z0, { $variant: t, ref: e, ...i });
}), z0 = x(rn.Content)`
  ${(i) => i.$variant === "simple" ? D`
        
      ` : D`
        position: relative;
        z-index: 1;
        background-color: ${(e) => e.theme.colors.neutral0};
      `}
`, S1 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  Content: B0,
  List: E0,
  Root: D0,
  Trigger: P0
}, Symbol.toStringTag, { value: "Module" })), N0 = x(R)`
  overflow: hidden;
  border: 1px solid ${({ theme: i }) => i.colors.neutral150};
`, F0 = x(i0)`
  width: 100%;
  white-space: nowrap;
`, W0 = x(R)`
  &:before {
    // TODO: make sure to add a token for this weird stuff
    background: linear-gradient(90deg, #c0c0cf 0%, rgba(0, 0, 0, 0) 100%);
    opacity: 0.2;
    position: absolute;
    height: 100%;
    content: ${({ $overflowing: i }) => i === "both" || i === "left" ? "''" : void 0};
    box-shadow: ${({ theme: i }) => i.shadows.tableShadow};
    width: ${({ theme: i }) => i.spaces[2]};
    left: 0;
  }

  &:after {
    // TODO: make sure to add a token for this weird stuff
    background: linear-gradient(270deg, #c0c0cf 0%, rgba(0, 0, 0, 0) 100%);
    opacity: 0.2;
    position: absolute;
    height: 100%;
    content: ${({ $overflowing: i }) => i === "both" || i === "right" ? "''" : void 0};
    box-shadow: ${({ theme: i }) => i.shadows.tableShadow};
    width: ${({ theme: i }) => i.spaces[2]};
    right: 0;
    top: 0;
  }
`, H0 = x(R)`
  overflow-x: auto;
`, C1 = m.forwardRef(({ footer: i, ...e }, t) => {
  const n = m.useRef(null), [r, o] = m.useState(), s = (l) => {
    const a = l.target.scrollWidth - l.target.clientWidth;
    if (l.target.scrollLeft === 0) {
      o("right");
      return;
    }
    if (l.target.scrollLeft === a) {
      o("left");
      return;
    }
    l.target.scrollLeft > 0 && o("both");
  };
  return m.useEffect(() => {
    n.current.scrollWidth > n.current.clientWidth && o("right");
  }, []), /* @__PURE__ */ $(N0, { shadow: "tableShadow", hasRadius: !0, background: "neutral0", children: [
    /* @__PURE__ */ u(W0, { $overflowing: r, position: "relative", children: /* @__PURE__ */ u(H0, { ref: n, onScroll: s, paddingLeft: 6, paddingRight: 6, children: /* @__PURE__ */ u(F0, { ref: t, ...e }) }) }),
    i
  ] });
}), V0 = x(o0)`
  & tr:last-of-type {
    border-bottom: none;
  }
`, k1 = ({ children: i, ...e }) => /* @__PURE__ */ u(V0, { ...e, children: i }), j0 = x(r0)`
  border-bottom: 1px solid ${({ theme: i }) => i.colors.neutral150};
`, $1 = ({ children: i, ...e }) => /* @__PURE__ */ u(j0, { ...e, children: i }), q0 = x(s0)`
  border-bottom: 1px solid ${({ theme: i }) => i.colors.neutral150};

  & td,
  & th {
    padding: ${({ theme: i }) => i.spaces[4]};
  }

  & td:first-of-type,
  & th:first-of-type {
    padding: 0 ${({ theme: i }) => i.spaces[1]};
  }

  // Resetting padding values and fixing a height
  th {
    padding-top: 0;
    padding-bottom: 0;
    height: 5.6rem;
  }
`, A1 = (i) => /* @__PURE__ */ u(q0, { ...i }), Va = x(za)`
  vertical-align: middle;
  text-align: left;
  outline-offset: -4px;

  /**
  * Hack to make sure the checkbox looks aligned
  */
  input {
    vertical-align: sub;
  }
`, T1 = m.forwardRef(({ children: i, action: e, ...t }, n) => /* @__PURE__ */ u(Va, { color: "neutral600", as: n0, ref: n, ...t, children: /* @__PURE__ */ $(T, { children: [
  i,
  e
] }) })), R1 = m.forwardRef(({ children: i, ...e }, t) => /* @__PURE__ */ u(Va, { color: "neutral800", ref: t, ...e, children: i })), K0 = x(R)`
  height: 2.4rem;
  width: 2.4rem;
  border-radius: 50%;
  display: flex;
  justify-content: center;
  align-items: center;

  svg {
    height: 1rem;
    width: 1rem;
  }

  svg path {
    fill: ${({ theme: i }) => i.colors.primary600};
  }
`, U0 = x(R)`
  border-radius: 0 0 ${({ theme: i }) => i.borderRadius} ${({ theme: i }) => i.borderRadius};
  display: block;
  width: 100%;
  border: none;
`, M1 = ({ children: i, icon: e, ...t }) => /* @__PURE__ */ $("div", { children: [
  /* @__PURE__ */ u(bl, {}),
  /* @__PURE__ */ u(U0, { tag: "button", background: "primary100", padding: 5, ...t, children: /* @__PURE__ */ $(T, { children: [
    /* @__PURE__ */ u(K0, { "aria-hidden": !0, background: "primary200", children: e }),
    /* @__PURE__ */ u(R, { paddingLeft: 3, children: /* @__PURE__ */ u(I, { variant: "pi", fontWeight: "bold", textColor: "primary600", children: i }) })
  ] }) })
] }), D1 = xe(
  ({ children: i, startIcon: e, endIcon: t, disabled: n = !1, loading: r = !1, type: o = "button", ...s }, l) => {
    const a = n || r;
    return /* @__PURE__ */ $(
      Y0,
      {
        ref: l,
        disabled: a,
        "aria-disabled": a,
        tag: "button",
        type: o,
        gap: 2,
        ...s,
        children: [
          r ? /* @__PURE__ */ u(G0, { "aria-hidden": !0, children: /* @__PURE__ */ u(xs, {}) }) : e,
          /* @__PURE__ */ u(I, { variant: "pi", children: i }),
          t
        ]
      }
    );
  }
), _0 = fe`
  from {
    transform: rotate(0deg);
  }
  to {
    transform: rotate(359deg);
  }
`, G0 = x.span`
  display: flex;
  animation: ${_0} 2s infinite linear;
  will-change: transform;
`, Y0 = x(T)`
  border: none;
  background-color: transparent;
  color: ${(i) => i.theme.colors.primary600};
  cursor: pointer;

  &[aria-disabled='true'] {
    pointer-events: none;
    color: ${(i) => i.theme.colors.neutral600};
  }

  ${on}
`, X0 = m.forwardRef((i, e) => /* @__PURE__ */ u(an, { ref: e, ...i }));
X0.displayName = "TextInput";
const O1 = m.forwardRef(
  ({
    disabled: i,
    hasError: e,
    id: t,
    name: n,
    required: r,
    resizable: o = !0,
    ...s
  }, l) => {
    const { error: a, ...c } = Ce("Textarea"), h = !!a || e, d = c.id ?? t, f = c.name ?? n, g = c.required || r;
    let p;
    return a ? p = `${d}-error` : c.hint && (p = `${d}-hint`), /* @__PURE__ */ u(J0, { borderColor: h ? "danger600" : "neutral200", $hasError: h, hasRadius: !0, children: /* @__PURE__ */ u(
      Q0,
      {
        "aria-invalid": h,
        "aria-required": g,
        tag: "textarea",
        background: i ? "neutral150" : "neutral0",
        color: i ? "neutral600" : "neutral800",
        disabled: i,
        hasRadius: !0,
        ref: l,
        lineHeight: 4,
        padding: 4,
        width: "100%",
        height: "100%",
        id: d,
        name: f,
        "aria-describedby": p,
        $resizable: o,
        ...s
      }
    ) });
  }
), J0 = x(R)`
  ${at()}
`, Q0 = x(R)`
  display: block;
  border: none;
  resize: ${({ $resizable: i }) => i ? "vertical" : "none"};
  min-height: ${({ minHeight: i }) => i || "10.5rem"};
  font-size: ${({ theme: i }) => i.fontSizes[3]};

  ${({ theme: i }) => i.breakpoints.small} {
    font-size: ${({ theme: i }) => i.fontSizes[2]};
  }

  &::placeholder {
    color: ${({ theme: i }) => i.colors.neutral600};
    font-size: ${({ theme: i }) => i.fontSizes[3]};
    opacity: 1;

    ${({ theme: i }) => i.breakpoints.small} {
      font-size: ${({ theme: i }) => i.fontSizes[2]};
    }
  }

  &:focus-within {
    outline: none;
  }

  &:disabled {
    cursor: not-allowed;
  }
`, E1 = m.forwardRef(
  ({
    offLabel: i,
    onLabel: e,
    disabled: t,
    hasError: n,
    required: r,
    id: o,
    name: s,
    checked: l,
    onChange: a,
    ...c
  }, h) => {
    const [d = !1, f] = We({
      prop: l
    }), g = d !== null && !d, { error: p, ...b } = Ce("Toggle"), w = !!p || n, y = b.id ?? o, v = b.name ?? s, k = b.required || r;
    let C;
    return p ? C = `${y}-error` : b.hint && (C = `${y}-hint`), /* @__PURE__ */ $(
      Z0,
      {
        position: "relative",
        hasRadius: !0,
        padding: 1,
        background: t ? "neutral150" : "neutral100",
        borderStyle: "solid",
        borderWidth: "1px",
        borderColor: w ? "danger600" : "neutral200",
        wrap: "wrap",
        cursor: t ? "not-allowed" : "pointer",
        $hasError: w,
        children: [
          /* @__PURE__ */ u(
            fs,
            {
              hasRadius: !0,
              flex: "1 1 50%",
              paddingTop: 2,
              paddingBottom: 2,
              paddingLeft: 3,
              paddingRight: 3,
              justifyContent: "center",
              background: t && g ? "neutral200" : g ? "neutral0" : "transparent",
              borderColor: t && g ? "neutral300" : g ? "neutral200" : t ? "neutral150" : "neutral100",
              children: /* @__PURE__ */ u(
                I,
                {
                  variant: "pi",
                  fontWeight: "bold",
                  textTransform: "uppercase",
                  textColor: t ? "neutral700" : g ? "danger700" : "neutral600",
                  children: i
                }
              )
            }
          ),
          /* @__PURE__ */ u(
            fs,
            {
              hasRadius: !0,
              flex: "1 1 50%",
              paddingLeft: 3,
              paddingRight: 3,
              justifyContent: "center",
              background: t && d ? "neutral200" : d ? "neutral0" : "transparent",
              borderColor: t && d ? "neutral300" : d ? "neutral200" : t ? "neutral150" : "neutral100",
              children: /* @__PURE__ */ u(
                I,
                {
                  variant: "pi",
                  fontWeight: "bold",
                  textTransform: "uppercase",
                  textColor: t ? "neutral700" : d ? "primary600" : "neutral600",
                  children: e
                }
              )
            }
          ),
          /* @__PURE__ */ u(
            em,
            {
              ...c,
              id: y,
              name: v,
              ref: h,
              onChange: (A) => {
                f(A.currentTarget.checked), a == null || a(A);
              },
              type: "checkbox",
              "aria-required": k,
              disabled: t,
              "aria-disabled": t,
              checked: !!d,
              "aria-describedby": C
            }
          )
        ]
      }
    );
  }
), Z0 = x(T)`
  ${at()}
`, fs = x(T)`
  padding-block: 0.6rem;
`, em = x.input`
  height: 100%;
  left: 0;
  opacity: 0;
  position: absolute;
  top: 0;
  z-index: 0;
  width: 100%;
`, tm = {
  x: 0,
  y: 0,
  width: 0,
  height: 0,
  top: 0,
  left: 0,
  bottom: 0,
  right: 0
};
function I1() {
  const [i, e] = Mn(null), [t, n] = Mn(tm), r = ps(
    () => new ResizeObserver((o) => {
      if (o[0]) {
        const { x: s, y: l, width: a, height: c, top: h, left: d, bottom: f, right: g } = o[0].contentRect;
        n({ x: s, y: l, width: a, height: c, top: h, left: d, bottom: f, right: g });
      }
    }),
    []
  );
  return He(() => {
    if (i)
      return r.observe(i), () => {
        r.disconnect();
      };
  }, [i, r]), [e, t];
}
const P1 = ({ onEscape: i, restoreFocus: e = !0, skipAutoFocus: t = !1, ...n }) => {
  const r = m.useRef(null);
  return m.useEffect(() => {
    let s = null;
    return e && (s = document.activeElement), () => {
      s && s.focus();
    };
  }, [e]), m.useEffect(() => {
    if (!r.current || t) return;
    const s = mt(r.current);
    s.length > 0 ? s[0].focus() : console.warn(
      "[FocusTrap]: it seems there are no focusable elements in the focus trap tree. Make sure there s at least one."
    );
  }, [t]), /* @__PURE__ */ u("div", { ref: r, onKeyDown: (s) => {
    if (s.key === Y.ESCAPE && i) {
      i();
      return;
    }
    if (s.key !== Y.TAB) return;
    const l = mt(r.current);
    if (l.length > 0) {
      const a = l[0], c = l[l.length - 1];
      s.shiftKey ? a === document.activeElement && (s.preventDefault(), c.focus()) : c === document.activeElement && (s.preventDefault(), a.focus());
    }
  }, ...n });
}, L1 = ({ tagName: i, attributeName: e = "", ...t }) => {
  const n = () => {
    const s = document.activeElement;
    return s ? i ? s.tagName.toLowerCase() === i : s.hasAttribute(e) : !1;
  }, r = (s) => i ? s.querySelectorAll(i) : s.querySelectorAll(`[${e}]`);
  return /* @__PURE__ */ u(R, { onKeyDown: (s) => {
    switch (s.key) {
      case Y.RIGHT:
      case Y.DOWN: {
        if (n()) {
          s.preventDefault();
          const l = document.activeElement, a = [...r(s.currentTarget)], c = a.findIndex((d) => d === l), h = c + 1 < a.length ? c + 1 : 0;
          a[h].focus();
        }
        break;
      }
      case Y.LEFT:
      case Y.UP: {
        if (n()) {
          s.preventDefault();
          const l = document.activeElement, a = [...r(s.currentTarget)], c = a.findIndex((d) => d === l), h = c - 1 > -1 ? c - 1 : a.length - 1;
          a[h].focus();
        }
        break;
      }
      case Y.HOME: {
        n() && (s.preventDefault(), r(s.currentTarget).item(0).focus());
        break;
      }
      case Y.END: {
        if (n()) {
          s.preventDefault();
          const l = r(s.currentTarget);
          l.item(l.length - 1).focus();
        }
        break;
      }
    }
  }, ...t });
};
export {
  zt as AccessibleIcon,
  Sm as Accordion,
  Cm as Alert,
  km as Avatar,
  Ps as Badge,
  vi as BaseLink,
  R as Box,
  Ac as Breadcrumbs,
  zn as Button,
  Rm as Card,
  dd as CardAction,
  Mm as CardAsset,
  Dm as CardBadge,
  Om as CardBody,
  Em as CardCheckbox,
  Im as CardContent,
  Pm as CardHeader,
  zm as CardSubtitle,
  Lm as CardTimer,
  Bm as CardTitle,
  kd as Carousel,
  jm as CarouselActions,
  qm as CarouselImage,
  Vm as CarouselInput,
  Km as CarouselSlide,
  Tr as Checkbox,
  au as Combobox,
  gu as ComboboxOption,
  Tc as Crumb,
  Mc as CrumbLink,
  cd as CrumbSimpleMenu,
  yf as DatePicker,
  Xm as DateTimePicker,
  Ym as DesignSystemProvider,
  _m as Dialog,
  Ou as DismissibleLayer,
  bl as Divider,
  h1 as Dots,
  Jm as EmptyStateLayout,
  Hm as Field,
  T as Flex,
  P1 as FocusTrap,
  Um as Grid,
  ot as IconButton,
  $m as IconButtonGroup,
  Zm as JSONInput,
  L1 as KeyboardNavigable,
  Wc as Link,
  e1 as LinkButton,
  Ru as LiveRegions,
  Vd as Loader,
  t1 as Main,
  Am as Menu,
  Tm as MenuItem,
  n1 as Modal,
  p0 as MultiSelect,
  m0 as MultiSelectGroup,
  f1 as MultiSelectNested,
  Fa as MultiSelectOption,
  l1 as NextLink,
  r1 as NumberInput,
  a1 as PageLink,
  o1 as Pagination,
  c1 as Popover,
  ll as Portal,
  s1 as PreviousLink,
  d1 as ProgressBar,
  u1 as Radio,
  i0 as RawTable,
  o0 as RawTbody,
  za as RawTd,
  n0 as RawTh,
  r0 as RawThead,
  s0 as RawTr,
  hn as ScrollArea,
  d0 as SearchForm,
  c0 as Searchbar,
  ad as SimpleMenu,
  yo as SingleSelect,
  wo as SingleSelectOption,
  i1 as SkipToContent,
  g1 as Status,
  p1 as SubNav,
  m1 as SubNavHeader,
  b1 as SubNavLink,
  y1 as SubNavLinkSection,
  w1 as SubNavSection,
  x1 as SubNavSections,
  v1 as Switch,
  M1 as TFooter,
  C1 as Table,
  S1 as Tabs,
  f0 as Tag,
  k1 as Tbody,
  R1 as Td,
  D1 as TextButton,
  X0 as TextInput,
  O1 as Textarea,
  T1 as Th,
  $1 as Thead,
  vf as TimePicker,
  E1 as Toggle,
  Ar as Tooltip,
  A1 as Tr,
  I as Typography,
  lt as VisuallyHidden,
  Os as _internaluseUncontrolledState,
  N1 as composeEventHandlers,
  Bs as composeRefs,
  ei as convertUTCDateToCalendarDateTime,
  Nm as darkTheme,
  Fm as extendTheme,
  Wm as getThemeSize,
  at as inputFocusStyle,
  Oc as isSSR,
  Zs as lightTheme,
  F1 as useCallbackRef,
  W1 as useCollator,
  ve as useComposedRefs,
  We as useControllableState,
  Ue as useDateFormatter,
  cn as useDesignSystem,
  Ce as useField,
  H1 as useFilter,
  Se as useId,
  He as useIsomorphicLayoutEffect,
  I1 as useMeasure,
  Gm as useNotifyAT
};
