import { FlexProps } from '../../primitives/Flex';
import { PolymorphicComponentPropsWithRef } from '../../types';
import * as React from 'react';
type TextButtonProps<C extends React.ElementType = 'button'> = FlexProps<C> & {
    disabled?: boolean;
    endIcon?: React.ReactNode;
    loading?: boolean;
    startIcon?: React.ReactNode;
    type?: 'button' | 'submit' | 'reset';
};
declare const TextButton: TextButtonComponent<"button">;
type TextButtonComponent<C extends React.ElementType = 'button'> = <T extends React.ElementType = C>(props: PolymorphicComponentPropsWithRef<T, TextButtonProps<T>>) => JSX.Element;
export { TextButton };
export type { TextButtonProps };
//# sourceMappingURL=TextButton.d.ts.map