import * as React from 'react';
import * as SelectParts from './SelectParts';
type SingleSelectPropsWithoutLabel = Omit<SelectParts.SingleSelectProps, 'value'> & Pick<SelectParts.ContentProps, 'onCloseAutoFocus'> & Pick<SelectParts.TriggerProps, 'clearLabel' | 'onClear' | 'startIcon' | 'name' | 'id' | 'hasError' | 'size'> & Pick<SelectParts.ValueProps, 'placeholder'> & {
    /**
     * @default (value) => value.toString()
     */
    customizeContent?(value?: string | number): string;
    onChange?: (value: string | number) => void;
    onReachEnd?: (entry: IntersectionObserverEntry) => void;
    value?: string | number | null;
};
export type SingleSelectProps = SingleSelectPropsWithoutLabel & {
    'aria-label'?: string;
    'aria-describedby'?: string;
};
export type SingleSelectElement = HTMLDivElement;
export declare const SingleSelect: React.ForwardRefExoticComponent<Omit<import('@strapi/ui-primitives/dist/components/Select/Select').SingleSelectProps, "value"> & Pick<import('@strapi/ui-primitives/dist/components/Select/Select').SelectContentImplProps, "onCloseAutoFocus"> & Pick<SelectParts.TriggerProps, "id" | "name" | "size" | "startIcon" | "hasError" | "clearLabel" | "onClear"> & Pick<SelectParts.ValueProps, "placeholder"> & {
    /**
     * @default (value) => value.toString()
     */
    customizeContent?(value?: string | number): string;
    onChange?: ((value: string | number) => void) | undefined;
    onReachEnd?: ((entry: IntersectionObserverEntry) => void) | undefined;
    value?: string | number | null | undefined;
} & {
    'aria-label'?: string | undefined;
    'aria-describedby'?: string | undefined;
} & React.RefAttributes<HTMLDivElement>>;
export interface SingleSelectOptionProps extends Omit<SelectParts.ItemProps, 'value'> {
    startIcon?: React.ReactNode;
    value: string | number;
}
export declare const SingleSelectOption: React.ForwardRefExoticComponent<SingleSelectOptionProps & React.RefAttributes<HTMLDivElement>>;
export {};
//# sourceMappingURL=SingleSelect.d.ts.map