'use strict';

var _ = require('lodash');

const checkFieldsDontHaveDuplicates = (fields)=>{
    if (_.isNil(fields)) {
        // Only check if the fields exist
        return true;
    }
    if (!Array.isArray(fields)) {
        return false;
    }
    return _.uniq(fields).length === fields.length;
};

module.exports = checkFieldsDontHaveDuplicates;
//# sourceMappingURL=check-fields-dont-have-duplicates.js.map
