/// <reference types="koa" />
import type { Core } from '@strapi/types';
declare const getAdminEE: () => {
    controllers: {
        ai?: {
            getAiToken(ctx: import("koa").Context): Promise<import("koa").Context | undefined>;
            getAiUsage(ctx: import("koa").Context): Promise<import("koa").Context | undefined>;
            getAIFeatureConfig(ctx: import("koa").Context): Promise<void>;
        } | undefined;
        'audit-logs'?: {
            findMany(ctx: import("koa").Context): Promise<void>;
            findOne(ctx: import("koa").Context): Promise<void>;
        } | undefined;
        authentication: {
            getProviders(ctx: import("koa").Context): Promise<void>;
            getProviderLoginOptions(ctx: import("koa").Context): Promise<void>;
            updateProviderLoginOptions(ctx: import("koa").Context): Promise<void>;
            providerLogin(ctx: import("koa").Context, next: import("koa").Next): any;
        };
        role: {
            create(ctx: import("koa").Context): Promise<void>;
            deleteOne(ctx: import("koa").Context): Promise<any>;
            deleteMany(ctx: import("koa").Context): Promise<any>;
        };
        user: {
            create(ctx: import("koa").Context): Promise<void>;
            update(ctx: import("koa").Context): Promise<import("koa").Context | undefined>;
            isSSOLocked(ctx: import("koa").Context): Promise<void>;
        };
        admin: {
            getProjectType(): Promise<{
                data: {
                    isEE: boolean | undefined;
                    isTrial: boolean;
                    features: {
                        [key: string]: any;
                        name: string;
                    }[];
                    flags: {};
                    type: string | null | undefined;
                    ai: {
                        enabled: boolean;
                    };
                };
            } | {
                data: {
                    isEE: boolean;
                    features: never[];
                    flags: {};
                    ai: {
                        enabled: boolean;
                    };
                    isTrial?: undefined;
                    type?: undefined;
                };
            }>;
            licenseLimitInformation(): Promise<{
                data: {
                    enforcementUserCount: any;
                    currentActiveUserCount: any;
                    permittedSeats: number | null | undefined;
                    shouldNotify: boolean;
                    shouldStopCreate: boolean;
                    licenseLimitStatus: string | null;
                    isHostedOnStrapiCloud: boolean;
                    aiLicenseKey: unknown;
                    type: string | null | undefined;
                    isTrial: boolean;
                    features: {
                        [key: string]: any;
                        name: string;
                    }[];
                };
            }>;
        };
    };
    routes: {
        ai?: {
            type: string;
            routes: {
                method: string;
                path: string;
                handler: string;
                config: {
                    policies: string[];
                };
            }[];
        } | undefined;
        'audit-logs'?: {
            type: string;
            routes: {
                method: string;
                path: string;
                handler: string;
                config: {
                    middlewares: Core.MiddlewareHandler[];
                    policies: (string | {
                        name: string;
                        config: {
                            actions: string[];
                        };
                    })[];
                };
            }[];
        } | undefined;
        sso: {
            type: string;
            routes: ({
                method: string;
                path: string;
                handler: string;
                config: {
                    middlewares: Core.MiddlewareHandler[];
                    auth: boolean;
                    policies?: undefined;
                };
            } | {
                method: string;
                path: string;
                handler: string;
                config: {
                    middlewares: Core.MiddlewareHandler[];
                    policies: (string | {
                        name: string;
                        config: {
                            actions: string[];
                        };
                    })[];
                    auth?: undefined;
                };
            })[];
        };
        'license-limit': {
            type: string;
            routes: {
                method: string;
                path: string;
                handler: string;
                config: {
                    policies: string[];
                };
            }[];
        };
    };
    register({ strapi }: {
        strapi: Core.Strapi;
    }): Promise<void>;
    destroy({ strapi }: {
        strapi: Core.Strapi;
    }): Promise<void>;
    bootstrap: (args: any) => Promise<void>;
    contentTypes: {
        'audit-log': {
            schema: {
                kind: string;
                collectionName: string;
                info: {
                    singularName: string;
                    pluralName: string;
                    displayName: string;
                };
                options: {
                    timestamps: boolean;
                };
                pluginOptions: {
                    'content-manager': {
                        visible: boolean;
                    };
                    'content-type-builder': {
                        visible: boolean;
                    };
                };
                attributes: {
                    action: {
                        type: string;
                        required: boolean;
                    };
                    date: {
                        type: string;
                        required: boolean;
                    };
                    user: {
                        type: string;
                        relation: string;
                        target: string;
                    };
                    payload: {
                        type: string;
                    };
                };
            };
        };
    };
    services: {
        auth: {
            forgotPassword: ({ email }?: any) => Promise<any>;
            resetPassword: ({ resetPasswordToken, password }?: any) => Promise<any>;
        };
        passport: {
            providerRegistry: Map<any, any>;
            getStrategyCallbackURL: (providerName: string) => string;
            syncProviderRegistryWithConfig: () => void;
            authEventsMapper: {
                onSSOAutoRegistration: string;
                onConnectionSuccess: string;
                onConnectionError: string;
            };
            getPassportStrategies: () => any[];
        };
        role: {
            ssoCheckRolesIdForDeletion: (ids: any) => Promise<void>;
        };
        user: {
            updateEEDisabledUsersList: (id: string, input: any) => Promise<void>;
            removeFromEEDisabledUsersList: (ids: unknown) => Promise<void>;
            getCurrentActiveUserCount: () => Promise<number>;
            deleteByIds: (ids: any) => Promise<any[]>;
            deleteById: (id: unknown) => Promise<any>;
            updateById: (id: any, attributes: any) => Promise<any>;
        };
        metrics: {
            startCron: (strapi: Core.Strapi) => void;
            getSSOProvidersList: () => Promise<any>;
            sendUpdateProjectInformation: (strapi: Core.Strapi) => Promise<void>;
        };
        'seat-enforcement': {
            seatEnforcementWorkflow: () => Promise<void>;
            getDisabledUserList: () => Promise<unknown>;
        };
        'persist-tables': {
            persistTablesWithPrefix: (tableNamePrefix: string) => Promise<void>;
            removePersistedTablesWithSuffix: (tableNameSuffix: string) => Promise<void>;
            persistTables: (tables: (string | import("./services/persist-tables").PersistedTable)[]) => Promise<void>;
            findTables: typeof import("./services/persist-tables").findTables;
        };
    };
};
export default getAdminEE;
//# sourceMappingURL=index.d.ts.map