import * as React from 'react';
import { ConfigureStoreOptions } from '@reduxjs/toolkit';
import { fireEvent, waitFor, RenderOptions as RTLRenderOptions, RenderResult, act, screen, RenderHookOptions, RenderHookResult, Queries } from '@testing-library/react';
import { userEvent } from '@testing-library/user-event';
import { MemoryRouterProps } from 'react-router-dom';
import { type Permission } from '../src/features/Auth';
import { server } from './server';
interface ProvidersProps {
    children: React.ReactNode;
    initialEntries?: MemoryRouterProps['initialEntries'];
    storeConfig?: Partial<ConfigureStoreOptions>;
    permissions?: Permission[] | ((defaultPermissions: Permission[]) => Permission[] | undefined);
}
declare const defaultTestStoreConfig: () => {
    preloadedState: {
        admin_app: {
            language: {
                locale: string;
                localeNames: {
                    en: string;
                };
            };
            permissions: {
                contentManager: {
                    main: never[];
                    collectionTypesConfigurations: {
                        action: string;
                        subject: null;
                    }[];
                    componentsConfigurations: {
                        action: string;
                        subject: null;
                    }[];
                    singleTypesConfigurations: {
                        action: string;
                        subject: null;
                    }[];
                };
                marketplace: {
                    main: {
                        action: string;
                        subject: null;
                    }[];
                    read: {
                        action: string;
                        subject: null;
                    }[];
                };
                settings: {
                    roles: {
                        main: {
                            action: string;
                            subject: null;
                        }[];
                        create: {
                            action: string;
                            subject: null;
                        }[];
                        delete: {
                            action: string;
                            subject: null;
                        }[];
                        read: {
                            action: string;
                            subject: null;
                        }[];
                        update: {
                            action: string;
                            subject: null;
                        }[];
                    };
                    users: {
                        main: {
                            action: string;
                            subject: null;
                        }[];
                        create: {
                            action: string;
                            subject: null;
                        }[];
                        delete: {
                            action: string;
                            subject: null;
                        }[];
                        read: {
                            action: string;
                            subject: null;
                        }[];
                        update: {
                            action: string;
                            subject: null;
                        }[];
                    };
                    webhooks: {
                        main: {
                            action: string;
                            subject: null;
                        }[];
                        create: {
                            action: string;
                            subject: null;
                        }[];
                        delete: {
                            action: string;
                            subject: null;
                        }[];
                        read: {
                            action: string;
                            subject: null;
                        }[];
                        update: {
                            action: string;
                            subject: null;
                        }[];
                    };
                    'api-tokens': {
                        main: {
                            action: string;
                            subject: null;
                        }[];
                        create: {
                            action: string;
                            subject: null;
                        }[];
                        delete: {
                            action: string;
                            subject: null;
                        }[];
                        read: {
                            action: string;
                            subject: null;
                        }[];
                        update: {
                            action: string;
                            subject: null;
                        }[];
                        regenerate: {
                            action: string;
                            subject: null;
                        }[];
                    };
                    'transfer-tokens': {
                        main: {
                            action: string;
                            subject: null;
                        }[];
                        create: {
                            action: string;
                            subject: null;
                        }[];
                        delete: {
                            action: string;
                            subject: null;
                        }[];
                        read: {
                            action: string;
                            subject: null;
                        }[];
                        update: {
                            action: string;
                            subject: null;
                        }[];
                        regenerate: {
                            action: string;
                            subject: null;
                        }[];
                    };
                    'project-settings': {
                        read: {
                            action: string;
                            subject: null;
                        }[];
                        update: {
                            action: string;
                            subject: null;
                        }[];
                    };
                    auditLogs: {
                        main: {
                            action: string;
                            subject: null;
                        }[];
                        read: {
                            action: string;
                            subject: null;
                        }[];
                        update: {
                            action: string;
                            subject: null;
                        }[];
                    };
                    'review-workflows': {
                        main: {
                            action: string;
                            subject: null;
                        }[];
                        read: {
                            action: string;
                            subject: null;
                        }[];
                        create: {
                            action: string;
                            subject: null;
                        }[];
                        delete: {
                            action: string;
                            subject: null;
                        }[];
                        update: {
                            action: string;
                            subject: null;
                        }[];
                    };
                    sso: {
                        main: {
                            action: string;
                            subject: null;
                        }[];
                        read: {
                            action: string;
                            subject: null;
                        }[];
                        update: {
                            action: string;
                            subject: null;
                        }[];
                    };
                };
            };
            theme: {
                availableThemes: never[];
                currentTheme: string;
            };
            token: string | null;
        };
    };
    reducer: {
        adminApi: import("redux").Reducer<import("@reduxjs/toolkit/query").CombinedState<{}, "GuidedTourMeta" | "HomepageKeyStatistics" | "AIUsage" | "AIFeatureConfig", "adminApi">, import("redux").AnyAction>;
        admin_app: import("redux").Reducer<import("../src/reducer").AppState>;
    };
    middleware: (getDefaultMiddleware: any) => any[];
};
export interface RenderOptions {
    renderOptions?: RTLRenderOptions;
    userEventOptions?: Parameters<typeof userEvent.setup>[0];
    initialEntries?: MemoryRouterProps['initialEntries'];
    providerOptions?: Pick<ProvidersProps, 'storeConfig' | 'permissions'>;
}
/**
 * @alpha
 * @description A custom render function that wraps the component with the necessary providers,
 * for use of testing components within the Strapi Admin.
 */
declare const render: (ui: React.ReactElement, { renderOptions, userEventOptions, initialEntries, providerOptions }?: RenderOptions) => RenderResult & {
    user: ReturnType<typeof userEvent.setup>;
};
/**
 * @alpha
 * @description A custom render-hook function that wraps the component with the necessary providers,
 * for use of testing hooks within the Strapi Admin.
 */
declare const renderHook: <Result, Props, Q extends Queries, Container extends Element | DocumentFragment = HTMLElement, BaseElement extends Element | DocumentFragment = Container>(hook: (initialProps: Props) => Result, options?: RenderHookOptions<Props, Q, Container, BaseElement> & Pick<RenderOptions, 'initialEntries' | 'providerOptions'>) => RenderHookResult<Result, Props>;
export { render, renderHook, waitFor, server, act, screen, fireEvent, defaultTestStoreConfig };
