'use strict';

var react = require('@reduxjs/toolkit/query/react');
var baseQuery = require('../utils/baseQuery.js');

/**
 * @public
 * @description This is the redux toolkit api for the admin panel, users
 * should use a combination of `enhanceEndpoints` to add their TagTypes
 * to utilise in their `injectEndpoints` construction for automatic cache
 * re-validation. We specifically do not store any tagTypes by default leaving
 * the API surface as small as possible. None of the data-fetching looks for the
 * StrapiApp are stored here either.
 */ const adminApi = react.createApi({
    reducerPath: 'adminApi',
    baseQuery: baseQuery.fetchBaseQuery(),
    tagTypes: [
        'GuidedTourMeta',
        'HomepageKeyStatistics',
        'AIUsage',
        'AIFeatureConfig'
    ],
    endpoints: ()=>({})
});

exports.adminApi = adminApi;
//# sourceMappingURL=api.js.map
