'use strict';

var jsxRuntime = require('react/jsx-runtime');
var React = require('react');
var designSystem = require('@strapi/design-system');
var icons = require('@strapi/icons');
var reactIntl = require('react-intl');
var ConfirmDialog = require('../../../../components/ConfirmDialog.js');
var Tours = require('../../../../components/GuidedTour/Tours.js');
var Layout = require('../../../../components/Layouts/Layout.js');
var BackButton = require('../../../../features/BackButton.js');
var Notifications = require('../../../../features/Notifications.js');
var useAPIErrorHandler = require('../../../../hooks/useAPIErrorHandler.js');
var transferTokens = require('../../../../services/transferTokens.js');

function _interopNamespaceDefault(e) {
  var n = Object.create(null);
  if (e) {
    Object.keys(e).forEach(function (k) {
      if (k !== 'default') {
        var d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: function () { return e[k]; }
        });
      }
    });
  }
  n.default = e;
  return Object.freeze(n);
}

var React__namespace = /*#__PURE__*/_interopNamespaceDefault(React);

const Regenerate = ({ onRegenerate, url })=>{
    const { formatMessage } = reactIntl.useIntl();
    const [showConfirmDialog, setShowConfirmDialog] = React__namespace.useState(false);
    const [isLoadingConfirmation, setIsLoadingConfirmation] = React__namespace.useState(false);
    const { toggleNotification } = Notifications.useNotification();
    const { _unstableFormatAPIError: formatAPIError } = useAPIErrorHandler.useAPIErrorHandler();
    const [regenerateToken] = transferTokens.useRegenerateTokenMutation();
    const regenerateData = async ()=>{
        try {
            const res = await regenerateToken(url);
            if ('error' in res) {
                toggleNotification({
                    type: 'danger',
                    message: formatAPIError(res.error)
                });
                return;
            }
            if (onRegenerate) {
                onRegenerate(res.data.accessKey);
            }
        } catch (error) {
            toggleNotification({
                type: 'danger',
                message: formatMessage({
                    id: 'notification.error',
                    defaultMessage: 'Something went wrong'
                })
            });
        } finally{
            setIsLoadingConfirmation(false);
        }
    };
    const handleConfirmRegeneration = async ()=>{
        regenerateData();
        setShowConfirmDialog(false);
    };
    return /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Dialog.Root, {
        open: showConfirmDialog,
        onOpenChange: setShowConfirmDialog,
        children: [
            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Dialog.Trigger, {
                children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Button, {
                    startIcon: /*#__PURE__*/ jsxRuntime.jsx(icons.ArrowClockwise, {}),
                    type: "button",
                    size: "S",
                    variant: "tertiary",
                    onClick: ()=>setShowConfirmDialog(true),
                    name: "regenerate",
                    children: formatMessage({
                        id: 'Settings.tokens.regenerate',
                        defaultMessage: 'Regenerate'
                    })
                })
            }),
            /*#__PURE__*/ jsxRuntime.jsx(ConfirmDialog.ConfirmDialog, {
                title: formatMessage({
                    id: 'Settings.tokens.RegenerateDialog.title',
                    defaultMessage: 'Regenerate token'
                }),
                endAction: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Button, {
                    startIcon: /*#__PURE__*/ jsxRuntime.jsx(icons.ArrowClockwise, {}),
                    loading: isLoadingConfirmation,
                    onClick: handleConfirmRegeneration,
                    children: formatMessage({
                        id: 'Settings.tokens.Button.regenerate',
                        defaultMessage: 'Regenerate'
                    })
                }),
                children: formatMessage({
                    id: 'Settings.tokens.popUpWarning.message',
                    defaultMessage: 'Are you sure you want to regenerate this token?'
                })
            })
        ]
    });
};
const FormHead = ({ title, token, setToken, toggleToken, showToken, canShowToken, canEditInputs, canRegenerate, isSubmitting, regenerateUrl })=>{
    const { formatMessage } = reactIntl.useIntl();
    const handleRegenerate = (newKey)=>{
        setToken({
            ...token,
            accessKey: newKey
        });
        toggleToken?.();
    };
    return /*#__PURE__*/ jsxRuntime.jsx(Layout.Layouts.Header, {
        title: token?.name || formatMessage(title),
        primaryAction: canEditInputs ? /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
            gap: 2,
            children: [
                canRegenerate && token?.id && /*#__PURE__*/ jsxRuntime.jsx(Regenerate, {
                    onRegenerate: handleRegenerate,
                    url: `${regenerateUrl}${token?.id ?? ''}`
                }),
                token?.id && toggleToken && /*#__PURE__*/ jsxRuntime.jsx(Tours.tours.apiTokens.ViewAPIToken, {
                    children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Tooltip, {
                        label: !canShowToken && formatMessage({
                            id: 'Settings.tokens.encryptionKeyMissing',
                            defaultMessage: 'In order to view the token, you need a valid encryption key in the admin configuration'
                        }),
                        children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Button, {
                            type: "button",
                            startIcon: showToken ? /*#__PURE__*/ jsxRuntime.jsx(icons.EyeStriked, {}) : /*#__PURE__*/ jsxRuntime.jsx(icons.Eye, {}),
                            variant: "secondary",
                            onClick: ()=>toggleToken?.(),
                            disabled: !canShowToken,
                            children: formatMessage({
                                id: 'Settings.tokens.viewToken',
                                defaultMessage: 'View token'
                            })
                        })
                    })
                }),
                /*#__PURE__*/ jsxRuntime.jsx(designSystem.Button, {
                    disabled: isSubmitting,
                    loading: isSubmitting,
                    startIcon: /*#__PURE__*/ jsxRuntime.jsx(icons.Check, {}),
                    type: "submit",
                    size: "S",
                    children: formatMessage({
                        id: 'global.save',
                        defaultMessage: 'Save'
                    })
                })
            ]
        }) : canRegenerate && token?.id && /*#__PURE__*/ jsxRuntime.jsx(Regenerate, {
            onRegenerate: handleRegenerate,
            url: `${regenerateUrl}${token?.id ?? ''}`
        }),
        navigationAction: // The back link for mobile works differently; it is placed higher up in the DOM.
        /*#__PURE__*/ jsxRuntime.jsx(designSystem.Box, {
            display: {
                initial: 'none',
                medium: 'block'
            },
            children: /*#__PURE__*/ jsxRuntime.jsx(BackButton.BackButton, {})
        }),
        ellipsis: true
    });
};

exports.FormHead = FormHead;
//# sourceMappingURL=FormHead.js.map
