'use strict';

var jsxRuntime = require('react/jsx-runtime');
var React = require('react');
var designSystem = require('@strapi/design-system');
var icons = require('@strapi/icons');
var reactIntl = require('react-intl');
var reactRouterDom = require('react-router-dom');
var styled = require('styled-components');
var Tracking = require('../features/Tracking.js');
var MainNav = require('./MainNav/MainNav.js');
var MainNavLinks = require('./MainNav/MainNavLinks.js');
var NavBrand = require('./MainNav/NavBrand.js');
var NavBurgerMenu = require('./MainNav/NavBurgerMenu.js');
var NavUser = require('./MainNav/NavUser.js');
var TrialCountdown = require('./MainNav/TrialCountdown.js');

function _interopNamespaceDefault(e) {
  var n = Object.create(null);
  if (e) {
    Object.keys(e).forEach(function (k) {
      if (k !== 'default') {
        var d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: function () { return e[k]; }
        });
      }
    });
  }
  n.default = e;
  return Object.freeze(n);
}

var React__namespace = /*#__PURE__*/_interopNamespaceDefault(React);

const sortLinks = (links)=>{
    return links.sort((a, b)=>{
        // if no position is defined, we put the link in the position of the external plugins, before the plugins list
        const positionA = a.position ?? 6;
        const positionB = b.position ?? 6;
        if (positionA < positionB) {
            return -1;
        } else {
            return 1;
        }
    });
};
const NavListWrapper = styled.styled(designSystem.Flex)`
  width: 100%;
  overflow-y: auto;
  scrollbar-width: none;
  -ms-overflow-style: none;

  &::-webkit-scrollbar {
    display: none;
  }
`;
const MenuDetails = styled.styled(designSystem.Flex)`
  flex: 1;
  flex-direction: row;
  justify-content: space-between;
  overflow-x: auto;

  ${({ theme })=>theme.breakpoints.large} {
    flex-direction: column;
    overflow-y: auto;
    overflow-x: hidden;
  }
`;
const LeftMenu = ({ generalSectionLinks, pluginsSectionLinks, topMobileNavigation, burgerMobileNavigation })=>{
    const [isBurgerMenuShown, setIsBurgerMenuShown] = React__namespace.useState(false);
    const { trackUsage } = Tracking.useTracking();
    const { pathname } = reactRouterDom.useLocation();
    const { formatMessage, locale } = reactIntl.useIntl();
    const formatter = designSystem.useCollator(locale, {
        sensitivity: 'base'
    });
    const handleClickOnLink = (destination)=>{
        trackUsage('willNavigate', {
            from: pathname,
            to: destination
        });
    };
    // Close burger menu when route changes
    React__namespace.useEffect(()=>{
        setIsBurgerMenuShown(false);
    }, [
        pathname
    ]);
    const listLinksAlphabeticallySorted = [
        ...pluginsSectionLinks,
        ...generalSectionLinks
    ].sort((a, b)=>formatter.compare(formatMessage(a.intlLabel), formatMessage(b.intlLabel)));
    const listLinks = sortLinks(listLinksAlphabeticallySorted);
    /**
   * Return filtered mobile navigation links (used for both top and burger menu)
   */ const mapMobileNavigationLinks = (mobileNavLinks)=>mobileNavLinks.reduce((acc, mobileLink)=>{
            const linkFound = listLinks.find((link)=>link.to === mobileLink.to);
            if (linkFound) {
                acc.push(mobileLink.link ? {
                    ...linkFound,
                    navigationLink: mobileLink.link
                } : linkFound);
            }
            return acc;
        }, []);
    /**
   * Mobile top navigation
   */ const topMobileNavigationLinks = mapMobileNavigationLinks(topMobileNavigation);
    /**
   * Mobile burger menu
   */ const excludedPluginsFromBurgerMenu = [
        'content-manager',
        'content-type-builder',
        'upload',
        'content-releases'
    ];
    const burgerMenuPluginsLinks = pluginsSectionLinks.filter((plugin)=>!excludedPluginsFromBurgerMenu.some((link)=>plugin.to.includes(link)));
    const burgerMobileNavigationLinks = [
        ...burgerMenuPluginsLinks,
        ...mapMobileNavigationLinks(burgerMobileNavigation)
    ];
    return /*#__PURE__*/ jsxRuntime.jsxs(jsxRuntime.Fragment, {
        children: [
            /*#__PURE__*/ jsxRuntime.jsxs(MainNav.MainNav, {
                children: [
                    /*#__PURE__*/ jsxRuntime.jsx(NavBrand.NavBrand, {}),
                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Divider, {}),
                    /*#__PURE__*/ jsxRuntime.jsxs(MenuDetails, {
                        children: [
                            /*#__PURE__*/ jsxRuntime.jsx(NavListWrapper, {
                                tag: "ul",
                                gap: 3,
                                direction: {
                                    initial: 'row',
                                    large: 'column'
                                },
                                alignItems: "center",
                                justifyContent: {
                                    initial: 'center',
                                    large: 'flex-start'
                                },
                                flex: 1,
                                paddingLeft: {
                                    initial: 3,
                                    large: 0
                                },
                                paddingRight: {
                                    initial: 3,
                                    large: 0
                                },
                                paddingTop: 3,
                                paddingBottom: 3,
                                children: /*#__PURE__*/ jsxRuntime.jsx(MainNavLinks.MainNavIcons, {
                                    listLinks: listLinks,
                                    mobileLinks: topMobileNavigationLinks,
                                    handleClickOnLink: handleClickOnLink
                                })
                            }),
                            /*#__PURE__*/ jsxRuntime.jsx(TrialCountdown.TrialCountdown, {}),
                            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Box, {
                                display: {
                                    initial: 'none',
                                    large: 'flex'
                                },
                                borderStyle: "solid",
                                borderWidth: {
                                    initial: 0,
                                    large: '1px 0 0 0'
                                },
                                borderColor: "neutral150",
                                padding: 3,
                                children: /*#__PURE__*/ jsxRuntime.jsx(NavUser.NavUser, {})
                            })
                        ]
                    }),
                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Box, {
                        padding: 3,
                        display: {
                            initial: 'flex',
                            large: 'none'
                        },
                        children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.IconButton, {
                            onClick: ()=>setIsBurgerMenuShown((prev)=>!prev),
                            style: {
                                border: 'none'
                            },
                            label: "Menu",
                            type: "button",
                            "aria-expanded": isBurgerMenuShown,
                            "aria-controls": "burger-menu",
                            children: !isBurgerMenuShown ? /*#__PURE__*/ jsxRuntime.jsx(icons.List, {
                                fill: "neutral1000"
                            }) : /*#__PURE__*/ jsxRuntime.jsx(icons.Cross, {
                                fill: "neutral1000"
                            })
                        })
                    })
                ]
            }),
            /*#__PURE__*/ jsxRuntime.jsx(NavBurgerMenu.NavBurgerMenu, {
                isShown: isBurgerMenuShown,
                listLinks: burgerMobileNavigationLinks,
                handleClickOnLink: handleClickOnLink,
                onClose: ()=>setIsBurgerMenuShown(false)
            })
        ]
    });
};

exports.LeftMenu = LeftMenu;
//# sourceMappingURL=LeftMenu.js.map
