import { jsxs, jsx } from 'react/jsx-runtime';
import { memo, forwardRef } from 'react';
import { useComposedRefs, Field, Flex, TextButton, Toggle } from '@strapi/design-system';
import { useIntl } from 'react-intl';
import { useFocusInputField } from '../../hooks/useFocusInputField.mjs';
import { useField } from '../Form.mjs';

const BooleanInput = /*#__PURE__*/ forwardRef(({ name, required, label, hint, labelAction, ...props }, ref)=>{
    const { formatMessage } = useIntl();
    const field = useField(name);
    const fieldRef = useFocusInputField(name);
    const composedRefs = useComposedRefs(ref, fieldRef);
    const handleClear = ()=>{
        field.onChange(name, null);
    };
    const showClearButton = !required && field.value !== null;
    return /*#__PURE__*/ jsxs(Field.Root, {
        error: field.error,
        name: name,
        hint: hint,
        required: required,
        maxWidth: "320px",
        children: [
            /*#__PURE__*/ jsxs(Flex, {
                justifyContent: "space-between",
                alignItems: "flex-end",
                gap: 2,
                children: [
                    /*#__PURE__*/ jsx(Field.Label, {
                        action: labelAction,
                        children: label
                    }),
                    showClearButton && /*#__PURE__*/ jsx(TextButton, {
                        onClick: handleClear,
                        children: formatMessage({
                            id: 'clearLabel',
                            defaultMessage: 'Clear'
                        })
                    })
                ]
            }),
            /*#__PURE__*/ jsx(Toggle, {
                ref: composedRefs,
                checked: field.value === null ? null : field.value || false,
                offLabel: formatMessage({
                    id: 'app.components.ToggleCheckbox.off-label',
                    defaultMessage: 'False'
                }),
                onLabel: formatMessage({
                    id: 'app.components.ToggleCheckbox.on-label',
                    defaultMessage: 'True'
                }),
                onChange: field.onChange,
                name: name,
                ...props
            }),
            /*#__PURE__*/ jsx(Field.Hint, {}),
            /*#__PURE__*/ jsx(Field.Error, {})
        ]
    });
});
const MemoizedBooleanInput = /*#__PURE__*/ memo(BooleanInput);

export { MemoizedBooleanInput as BooleanInput };
//# sourceMappingURL=Boolean.mjs.map
