function nextResetDate() {
    return Date.now() + 24 * 60 * 60 * 1000; // Now + 24 hours.
}
const createMiddleware = ({ sendEvent, strapi })=>{
    const state = {
        expires: nextResetDate(),
        counter: 0
    };
    const middleware = async (ctx, next)=>{
        const { url, method } = ctx.request;
        if (!url.includes('.') && url.includes(strapi.config.get('api.rest.prefix')) && [
            'GET',
            'PUT',
            'POST',
            'DELETE'
        ].includes(method)) {
            if (Date.now() > state.expires) {
                state.expires = nextResetDate();
                state.counter = 0;
            }
            // Send max. 1000 events per day.
            if (state.counter < 1000) {
                sendEvent('didReceiveRequest', {
                    eventProperties: {
                        url: ctx.request.url
                    }
                });
                // Increase counter.
                state.counter += 1;
            }
        }
        await next();
    };
    return middleware;
};

export { createMiddleware as default };
//# sourceMappingURL=middleware.mjs.map
