import { defineProvider } from './provider.mjs';
import { createSessionManager } from '../services/session-manager.mjs';

var sessionManager = defineProvider({
    init (strapi) {
        strapi.add('sessionManager', ()=>createSessionManager({
                db: strapi.db
            }));
    },
    async register (strapi) {
        // Get JWT secret from admin auth settings (same as admin token service)
        const adminAuth = strapi.config.get('admin.auth');
        const jwtSecret = adminAuth?.secret;
        if (!jwtSecret) {
            throw new Error('Missing admin.auth.secret configuration. The SessionManager requires a JWT secret');
        }
    }
});

export { sessionManager as default };
//# sourceMappingURL=session-manager.mjs.map
