'use strict';

var provider = require('./provider.js');
var sessionManager$1 = require('../services/session-manager.js');

var sessionManager = provider.defineProvider({
    init (strapi) {
        strapi.add('sessionManager', ()=>sessionManager$1.createSessionManager({
                db: strapi.db
            }));
    },
    async register (strapi) {
        // Get JWT secret from admin auth settings (same as admin token service)
        const adminAuth = strapi.config.get('admin.auth');
        const jwtSecret = adminAuth?.secret;
        if (!jwtSecret) {
            throw new Error('Missing admin.auth.secret configuration. The SessionManager requires a JWT secret');
        }
    }
});

module.exports = sessionManager;
//# sourceMappingURL=session-manager.js.map
