var name = "@strapi/core";
var version = "5.33.1";
var description = "Core of Strapi";
var homepage = "https://strapi.io";
var bugs = {
    url: "https://github.com/strapi/strapi/issues"
};
var repository = {
    type: "git",
    url: "git://github.com/strapi/strapi.git"
};
var license = "SEE LICENSE IN LICENSE";
var author = {
    name: "Strapi Solutions SAS",
    email: "hi@strapi.io",
    url: "https://strapi.io"
};
var maintainers = [
    {
        name: "Strapi Solutions SAS",
        email: "hi@strapi.io",
        url: "https://strapi.io"
    }
];
var main = "./dist/index.js";
var module = "./dist/index.mjs";
var source = "./src/index.ts";
var types = "./dist/index.d.ts";
var exports = {
    ".": {
        types: "./dist/index.d.ts",
        source: "./src/index.ts",
        "import": "./dist/index.mjs",
        require: "./dist/index.js",
        "default": "./dist/index.js"
    },
    "./package.json": "./package.json"
};
var files = [
    "dist/",
    "resources/"
];
var scripts = {
    build: "run -T npm-run-all clean --parallel build:code build:types",
    "build:code": "run -T  rollup -c",
    "build:types": "run -T tsc -p tsconfig.build.json --emitDeclarationOnly",
    watch: "run -T rollup -c -w",
    clean: "run -T rimraf ./dist",
    lint: "run -T eslint .",
    prepublishOnly: "yarn clean && yarn build",
    "test:unit": "run -T jest",
    "test:unit:watch": "run -T jest --watch"
};
var dependencies = {
    "@koa/cors": "5.0.0",
    "@koa/router": "12.0.2",
    "@paralleldrive/cuid2": "2.2.2",
    "@strapi/admin": "5.33.1",
    "@strapi/database": "5.33.1",
    "@strapi/generators": "5.33.1",
    "@strapi/logger": "5.33.1",
    "@strapi/permissions": "5.33.1",
    "@strapi/types": "5.33.1",
    "@strapi/typescript-utils": "5.33.1",
    "@strapi/utils": "5.33.1",
    "@vercel/stega": "0.1.2",
    bcryptjs: "2.4.3",
    boxen: "5.1.2",
    chalk: "4.1.2",
    "ci-info": "4.0.0",
    "cli-table3": "0.6.2",
    commander: "8.3.0",
    configstore: "5.0.1",
    copyfiles: "2.4.1",
    debug: "4.3.4",
    delegates: "1.0.0",
    dotenv: "16.4.5",
    execa: "5.1.1",
    "fs-extra": "11.2.0",
    glob: "10.3.10",
    "global-agent": "3.0.0",
    "http-errors": "2.0.0",
    inquirer: "8.2.5",
    "is-docker": "2.2.1",
    "json-logic-js": "2.0.5",
    jsonwebtoken: "9.0.0",
    koa: "2.16.1",
    "koa-body": "6.0.1",
    "koa-compose": "4.1.0",
    "koa-compress": "5.1.1",
    "koa-favicon": "2.1.0",
    "koa-helmet": "7.0.2",
    "koa-ip": "^2.1.3",
    "koa-session": "6.4.0",
    "koa-static": "5.0.0",
    lodash: "4.17.21",
    "mime-types": "2.1.35",
    "node-schedule": "2.1.1",
    open: "8.4.0",
    ora: "5.4.1",
    "package-json": "7.0.0",
    "pkg-up": "3.1.0",
    qs: "6.11.1",
    "resolve.exports": "2.0.2",
    semver: "7.5.4",
    statuses: "2.0.1",
    typescript: "5.4.4",
    undici: "6.21.2",
    yup: "0.32.9",
    zod: "3.25.67"
};
var devDependencies = {
    "@strapi/ts-zen": "^0.2.0",
    "@swc/core": "1.13.5",
    "@types/bcryptjs": "2.4.3",
    "@types/configstore": "5.0.1",
    "@types/delegates": "1.0.0",
    "@types/fs-extra": "11.0.4",
    "@types/global-agent": "2.1.3",
    "@types/http-errors": "2.0.4",
    "@types/jest": "29.5.2",
    "@types/json-logic-js": "2.0.8",
    "@types/koa": "2.13.4",
    "@types/koa-compress": "4.0.3",
    "@types/koa-session": "6.4.1",
    "@types/koa-static": "4.0.2",
    "@types/koa__router": "12.0.0",
    "@types/lodash": "^4.14.191",
    "@types/mime-types": "2.1.1",
    "@types/node": "24.10.0",
    "@types/node-schedule": "2.1.7",
    "@types/statuses": "2.0.1",
    "eslint-config-custom": "5.33.1",
    supertest: "6.3.3",
    tsconfig: "5.33.1"
};
var engines = {
    node: ">=20.0.0 <=24.x.x",
    npm: ">=6.0.0"
};
var pkg = {
    name: name,
    version: version,
    description: description,
    homepage: homepage,
    bugs: bugs,
    repository: repository,
    license: license,
    author: author,
    maintainers: maintainers,
    main: main,
    module: module,
    source: source,
    types: types,
    exports: exports,
    files: files,
    scripts: scripts,
    dependencies: dependencies,
    devDependencies: devDependencies,
    engines: engines
};

export { author, bugs, pkg as default, dependencies, description, devDependencies, engines, exports, files, homepage, license, main, maintainers, module, name, repository, scripts, source, types, version };
//# sourceMappingURL=package.json.mjs.map
