import type { SVGProps } from 'react';
import { Ref, forwardRef } from 'react';
const SvgReddit = (props: SVGProps<SVGSVGElement>, ref: Ref<SVGSVGElement>) => (
  <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32" width={16} height={16} ref={ref} {...props}>
    <path
      fill="#FF4500"
      d="M16 0C7.164 0 0 7.164 0 16a15.95 15.95 0 0 0 4.686 11.314L1.64 30.36c-.605.605-.177 1.639.678 1.639H16c8.836 0 16-7.164 16-16S24.836 0 16 0"
    />
    <path
      fill="#fff"
      d="M19.255 7.545a2.668 2.668 0 0 0 5.261-.614 2.666 2.666 0 0 0-5.277-.54 4.307 4.307 0 0 0-3.84 4.277v.013c-2.345.099-4.487.767-6.187 1.82a3.736 3.736 0 1 0-3.869 6.34c.124 4.338 4.85 7.826 10.664 7.826s10.547-3.492 10.664-7.833a3.737 3.737 0 0 0-1.602-7.111c-.857 0-1.645.288-2.275.773-1.715-1.061-3.88-1.729-6.25-1.817v-.01a3.16 3.16 0 0 1 2.71-3.121zM9.062 17.829c.063-1.355.963-2.395 2.01-2.395 1.045 0 1.845 1.098 1.783 2.454-.063 1.354-.844 1.847-1.891 1.847S9 19.184 9.062 17.829m11.883-2.395c1.047 0 1.947 1.04 2.009 2.395s-.855 1.906-1.902 1.906-1.828-.491-1.89-1.848c-.063-1.355.735-2.453 1.783-2.453m-1.245 5.53c.196.02.321.224.245.406a4.268 4.268 0 0 1-7.875 0 .296.296 0 0 1 .245-.406c1.15-.116 2.394-.18 3.692-.18 1.3 0 2.542.064 3.693.18"
    />
  </svg>
);
const ForwardRef = forwardRef(SvgReddit);
export default ForwardRef;
