import { z } from 'zod';
import type { UID } from '@strapi/types';
export declare const maxLengthGreaterThanMinLength: z.SuperRefinement<Record<string, unknown>>;
export declare const maxGreaterThanMin: z.SuperRefinement<Record<string, unknown>>;
declare const createComponentSchema: z.ZodObject<{
    uid: z.ZodType<`${string}.${string}`, z.ZodTypeDef, `${string}.${string}`>;
    displayName: z.ZodString;
    icon: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    category: z.ZodString;
    pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
} & {
    action: z.ZodLiteral<"create">;
    config: z.ZodDefault<z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>>;
    attributes: z.ZodEffects<z.ZodArray<z.ZodObject<{
        action: z.ZodLiteral<"create">;
        name: z.ZodEffects<z.ZodString, string, string>;
        properties: z.ZodEffects<z.ZodEffects<z.ZodEffects<z.ZodEffects<z.ZodUnion<[z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"media">;
            multiple: z.ZodOptional<z.ZodBoolean>;
            required: z.ZodOptional<z.ZodBoolean>;
            allowedTypes: z.ZodOptional<z.ZodArray<z.ZodEnum<["images", "videos", "files", "audios"]>, "atleastone">>;
        }, "strip", z.ZodTypeAny, {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"text">;
            default: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            minLength: z.ZodOptional<z.ZodNumber>;
            maxLength: z.ZodOptional<z.ZodNumber>;
            required: z.ZodOptional<z.ZodBoolean>;
            unique: z.ZodOptional<z.ZodBoolean>;
            regex: z.ZodEffects<z.ZodOptional<z.ZodString>, string | undefined, string | undefined>;
        }, "strip", z.ZodTypeAny, {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
            default: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            minLength: z.ZodOptional<z.ZodNumber>;
            maxLength: z.ZodOptional<z.ZodNumber>;
            required: z.ZodOptional<z.ZodBoolean>;
            unique: z.ZodOptional<z.ZodBoolean>;
            regex: z.ZodEffects<z.ZodOptional<z.ZodString>, string | undefined, string | undefined>;
        } & {
            type: z.ZodLiteral<"string">;
        }, "strip", z.ZodTypeAny, {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"richtext">;
            required: z.ZodOptional<z.ZodBoolean>;
            minLength: z.ZodOptional<z.ZodNumber>;
            maxLength: z.ZodOptional<z.ZodNumber>;
            default: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"blocks">;
            required: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"json">;
            required: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodEffects<z.ZodOptional<z.ZodUnknown>, unknown, unknown>;
        }, "strip", z.ZodTypeAny, {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"enumeration">;
            required: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodOptional<z.ZodString>;
            enumName: z.ZodEffects<z.ZodOptional<z.ZodString>, string | undefined, string | undefined>;
            enum: z.ZodEffects<z.ZodArray<z.ZodEffects<z.ZodString, string, string>, "many">, string[], string[]>;
        }, "strip", z.ZodTypeAny, {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"password">;
            required: z.ZodOptional<z.ZodBoolean>;
            minLength: z.ZodOptional<z.ZodNumber>;
            maxLength: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"email">;
            required: z.ZodOptional<z.ZodBoolean>;
            minLength: z.ZodOptional<z.ZodNumber>;
            maxLength: z.ZodOptional<z.ZodNumber>;
            default: z.ZodOptional<z.ZodString>;
            unique: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"integer">;
            required: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodOptional<z.ZodNumber>;
            unique: z.ZodOptional<z.ZodBoolean>;
            min: z.ZodOptional<z.ZodNumber>;
            max: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"biginteger">;
            required: z.ZodOptional<z.ZodBoolean>;
            unique: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            min: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            max: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"float">;
            required: z.ZodOptional<z.ZodBoolean>;
            unique: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodOptional<z.ZodNumber>;
            min: z.ZodOptional<z.ZodNumber>;
            max: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"decimal">;
            required: z.ZodOptional<z.ZodBoolean>;
            unique: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodOptional<z.ZodNumber>;
            min: z.ZodOptional<z.ZodNumber>;
            max: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"time">;
            required: z.ZodOptional<z.ZodBoolean>;
            unique: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
            required: z.ZodOptional<z.ZodBoolean>;
            unique: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodOptional<z.ZodString>;
        } & {
            type: z.ZodLiteral<"date">;
        }, "strip", z.ZodTypeAny, {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
            required: z.ZodOptional<z.ZodBoolean>;
            unique: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodOptional<z.ZodString>;
        } & {
            type: z.ZodLiteral<"datetime">;
        }, "strip", z.ZodTypeAny, {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"timestamp">;
        }, "strip", z.ZodTypeAny, {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"boolean">;
            required: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"component">;
            component: z.ZodString;
            repeatable: z.ZodOptional<z.ZodBoolean>;
            required: z.ZodOptional<z.ZodBoolean>;
            min: z.ZodOptional<z.ZodNumber>;
            max: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">>, z.ZodDiscriminatedUnion<"relation", [z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"oneToOne">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"oneToMany">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"morphOne">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"morphMany">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"morphToOne">;
        }, "strip", z.ZodTypeAny, {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"morphToMany">;
        }, "strip", z.ZodTypeAny, {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>]> | z.ZodDiscriminatedUnion<"relation", [z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"oneToOne">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"oneToMany">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"manyToOne">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"manyToMany">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"morphOne">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"morphMany">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"morphToOne">;
        }, "strip", z.ZodTypeAny, {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"morphToMany">;
        }, "strip", z.ZodTypeAny, {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>]> | z.ZodDiscriminatedUnion<"relation", [z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"oneToOne">;
            target: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"oneToMany">;
            target: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>]>]>, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | z.objectOutputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | z.objectInputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">>, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | z.objectOutputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | z.objectInputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">>, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | z.objectOutputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | z.objectInputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">>, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | z.objectOutputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | z.objectInputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">> | z.ZodEffects<z.ZodEffects<z.ZodEffects<z.ZodEffects<z.ZodEffects<z.ZodUnion<[z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"media">;
            multiple: z.ZodOptional<z.ZodBoolean>;
            required: z.ZodOptional<z.ZodBoolean>;
            allowedTypes: z.ZodOptional<z.ZodArray<z.ZodEnum<["images", "videos", "files", "audios"]>, "atleastone">>;
        }, "strip", z.ZodTypeAny, {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"text">;
            default: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            minLength: z.ZodOptional<z.ZodNumber>;
            maxLength: z.ZodOptional<z.ZodNumber>;
            required: z.ZodOptional<z.ZodBoolean>;
            unique: z.ZodOptional<z.ZodBoolean>;
            regex: z.ZodEffects<z.ZodOptional<z.ZodString>, string | undefined, string | undefined>;
        }, "strip", z.ZodTypeAny, {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
            default: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            minLength: z.ZodOptional<z.ZodNumber>;
            maxLength: z.ZodOptional<z.ZodNumber>;
            required: z.ZodOptional<z.ZodBoolean>;
            unique: z.ZodOptional<z.ZodBoolean>;
            regex: z.ZodEffects<z.ZodOptional<z.ZodString>, string | undefined, string | undefined>;
        } & {
            type: z.ZodLiteral<"string">;
        }, "strip", z.ZodTypeAny, {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"richtext">;
            required: z.ZodOptional<z.ZodBoolean>;
            minLength: z.ZodOptional<z.ZodNumber>;
            maxLength: z.ZodOptional<z.ZodNumber>;
            default: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"blocks">;
            required: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"json">;
            required: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodEffects<z.ZodOptional<z.ZodUnknown>, unknown, unknown>;
        }, "strip", z.ZodTypeAny, {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"enumeration">;
            required: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodOptional<z.ZodString>;
            enumName: z.ZodEffects<z.ZodOptional<z.ZodString>, string | undefined, string | undefined>;
            enum: z.ZodEffects<z.ZodArray<z.ZodEffects<z.ZodString, string, string>, "many">, string[], string[]>;
        }, "strip", z.ZodTypeAny, {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"password">;
            required: z.ZodOptional<z.ZodBoolean>;
            minLength: z.ZodOptional<z.ZodNumber>;
            maxLength: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"email">;
            required: z.ZodOptional<z.ZodBoolean>;
            minLength: z.ZodOptional<z.ZodNumber>;
            maxLength: z.ZodOptional<z.ZodNumber>;
            default: z.ZodOptional<z.ZodString>;
            unique: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"integer">;
            required: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodOptional<z.ZodNumber>;
            unique: z.ZodOptional<z.ZodBoolean>;
            min: z.ZodOptional<z.ZodNumber>;
            max: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"biginteger">;
            required: z.ZodOptional<z.ZodBoolean>;
            unique: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            min: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            max: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"float">;
            required: z.ZodOptional<z.ZodBoolean>;
            unique: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodOptional<z.ZodNumber>;
            min: z.ZodOptional<z.ZodNumber>;
            max: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"decimal">;
            required: z.ZodOptional<z.ZodBoolean>;
            unique: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodOptional<z.ZodNumber>;
            min: z.ZodOptional<z.ZodNumber>;
            max: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"time">;
            required: z.ZodOptional<z.ZodBoolean>;
            unique: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
            required: z.ZodOptional<z.ZodBoolean>;
            unique: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodOptional<z.ZodString>;
        } & {
            type: z.ZodLiteral<"date">;
        }, "strip", z.ZodTypeAny, {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
            required: z.ZodOptional<z.ZodBoolean>;
            unique: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodOptional<z.ZodString>;
        } & {
            type: z.ZodLiteral<"datetime">;
        }, "strip", z.ZodTypeAny, {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"timestamp">;
        }, "strip", z.ZodTypeAny, {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"boolean">;
            required: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"component">;
            component: z.ZodString;
            repeatable: z.ZodOptional<z.ZodBoolean>;
            required: z.ZodOptional<z.ZodBoolean>;
            min: z.ZodOptional<z.ZodNumber>;
            max: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">>, z.ZodDiscriminatedUnion<"relation", [z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"oneToOne">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"oneToMany">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"morphOne">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"morphMany">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"morphToOne">;
        }, "strip", z.ZodTypeAny, {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"morphToMany">;
        }, "strip", z.ZodTypeAny, {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>]> | z.ZodDiscriminatedUnion<"relation", [z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"oneToOne">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"oneToMany">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"manyToOne">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"manyToMany">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"morphOne">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"morphMany">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"morphToOne">;
        }, "strip", z.ZodTypeAny, {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"morphToMany">;
        }, "strip", z.ZodTypeAny, {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>]> | z.ZodDiscriminatedUnion<"relation", [z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"oneToOne">;
            target: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"oneToMany">;
            target: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>]>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"uid">;
            targetField: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            required: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            minLength: z.ZodOptional<z.ZodNumber>;
            maxLength: z.ZodOptional<z.ZodNumber>;
            options: z.ZodOptional<z.ZodObject<{
                separator: z.ZodOptional<z.ZodString>;
                lowercase: z.ZodOptional<z.ZodBoolean>;
                decamelize: z.ZodOptional<z.ZodBoolean>;
                customReplacements: z.ZodOptional<z.ZodArray<z.ZodArray<z.ZodString, "many">, "many">>;
                preserveLeadingUnderscore: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                separator?: string | undefined;
                lowercase?: boolean | undefined;
                decamelize?: boolean | undefined;
                customReplacements?: string[][] | undefined;
                preserveLeadingUnderscore?: boolean | undefined;
            }, {
                separator?: string | undefined;
                lowercase?: boolean | undefined;
                decamelize?: boolean | undefined;
                customReplacements?: string[][] | undefined;
                preserveLeadingUnderscore?: boolean | undefined;
            }>>;
            regex: z.ZodEffects<z.ZodOptional<z.ZodString>, string | undefined, string | undefined>;
        }, "strip", z.ZodTypeAny, {
            type: "uid";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            targetField?: string | null | undefined;
            options?: {
                separator?: string | undefined;
                lowercase?: boolean | undefined;
                decamelize?: boolean | undefined;
                customReplacements?: string[][] | undefined;
                preserveLeadingUnderscore?: boolean | undefined;
            } | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "uid";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            targetField?: string | null | undefined;
            options?: {
                separator?: string | undefined;
                lowercase?: boolean | undefined;
                decamelize?: boolean | undefined;
                customReplacements?: string[][] | undefined;
                preserveLeadingUnderscore?: boolean | undefined;
            } | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"dynamiczone">;
            components: z.ZodArray<z.ZodString, "atleastone">;
            required: z.ZodOptional<z.ZodBoolean>;
            min: z.ZodOptional<z.ZodNumber>;
            max: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            components: [string, ...string[]];
            type: "dynamiczone";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            components: [string, ...string[]];
            type: "dynamiczone";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>]>, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            components: [string, ...string[]];
            type: "dynamiczone";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "uid";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            targetField?: string | null | undefined;
            options?: {
                separator?: string | undefined;
                lowercase?: boolean | undefined;
                decamelize?: boolean | undefined;
                customReplacements?: string[][] | undefined;
                preserveLeadingUnderscore?: boolean | undefined;
            } | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | z.objectOutputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            components: [string, ...string[]];
            type: "dynamiczone";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "uid";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            targetField?: string | null | undefined;
            options?: {
                separator?: string | undefined;
                lowercase?: boolean | undefined;
                decamelize?: boolean | undefined;
                customReplacements?: string[][] | undefined;
                preserveLeadingUnderscore?: boolean | undefined;
            } | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | z.objectInputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">>, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            components: [string, ...string[]];
            type: "dynamiczone";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "uid";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            targetField?: string | null | undefined;
            options?: {
                separator?: string | undefined;
                lowercase?: boolean | undefined;
                decamelize?: boolean | undefined;
                customReplacements?: string[][] | undefined;
                preserveLeadingUnderscore?: boolean | undefined;
            } | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | z.objectOutputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            components: [string, ...string[]];
            type: "dynamiczone";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "uid";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            targetField?: string | null | undefined;
            options?: {
                separator?: string | undefined;
                lowercase?: boolean | undefined;
                decamelize?: boolean | undefined;
                customReplacements?: string[][] | undefined;
                preserveLeadingUnderscore?: boolean | undefined;
            } | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | z.objectInputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">>, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            components: [string, ...string[]];
            type: "dynamiczone";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "uid";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            targetField?: string | null | undefined;
            options?: {
                separator?: string | undefined;
                lowercase?: boolean | undefined;
                decamelize?: boolean | undefined;
                customReplacements?: string[][] | undefined;
                preserveLeadingUnderscore?: boolean | undefined;
            } | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | z.objectOutputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            components: [string, ...string[]];
            type: "dynamiczone";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "uid";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            targetField?: string | null | undefined;
            options?: {
                separator?: string | undefined;
                lowercase?: boolean | undefined;
                decamelize?: boolean | undefined;
                customReplacements?: string[][] | undefined;
                preserveLeadingUnderscore?: boolean | undefined;
            } | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | z.objectInputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">>, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            components: [string, ...string[]];
            type: "dynamiczone";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "uid";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            targetField?: string | null | undefined;
            options?: {
                separator?: string | undefined;
                lowercase?: boolean | undefined;
                decamelize?: boolean | undefined;
                customReplacements?: string[][] | undefined;
                preserveLeadingUnderscore?: boolean | undefined;
            } | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | z.objectOutputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            components: [string, ...string[]];
            type: "dynamiczone";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "uid";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            targetField?: string | null | undefined;
            options?: {
                separator?: string | undefined;
                lowercase?: boolean | undefined;
                decamelize?: boolean | undefined;
                customReplacements?: string[][] | undefined;
                preserveLeadingUnderscore?: boolean | undefined;
            } | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | z.objectInputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">>, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            components: [string, ...string[]];
            type: "dynamiczone";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "uid";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            targetField?: string | null | undefined;
            options?: {
                separator?: string | undefined;
                lowercase?: boolean | undefined;
                decamelize?: boolean | undefined;
                customReplacements?: string[][] | undefined;
                preserveLeadingUnderscore?: boolean | undefined;
            } | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | z.objectOutputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            components: [string, ...string[]];
            type: "dynamiczone";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "uid";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            targetField?: string | null | undefined;
            options?: {
                separator?: string | undefined;
                lowercase?: boolean | undefined;
                decamelize?: boolean | undefined;
                customReplacements?: string[][] | undefined;
                preserveLeadingUnderscore?: boolean | undefined;
            } | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | z.objectInputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">>;
    }, "strip", z.ZodTypeAny, {
        action: "create";
        name: string;
        properties: {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            components: [string, ...string[]];
            type: "dynamiczone";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "uid";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            targetField?: string | null | undefined;
            options?: {
                separator?: string | undefined;
                lowercase?: boolean | undefined;
                decamelize?: boolean | undefined;
                customReplacements?: string[][] | undefined;
                preserveLeadingUnderscore?: boolean | undefined;
            } | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | z.objectOutputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">;
    }, {
        action: "create";
        name: string;
        properties: {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            components: [string, ...string[]];
            type: "dynamiczone";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "uid";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            targetField?: string | null | undefined;
            options?: {
                separator?: string | undefined;
                lowercase?: boolean | undefined;
                decamelize?: boolean | undefined;
                customReplacements?: string[][] | undefined;
                preserveLeadingUnderscore?: boolean | undefined;
            } | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | z.objectInputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">;
    }>, "many">, {
        action: "create";
        name: string;
        properties: {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            components: [string, ...string[]];
            type: "dynamiczone";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "uid";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            targetField?: string | null | undefined;
            options?: {
                separator?: string | undefined;
                lowercase?: boolean | undefined;
                decamelize?: boolean | undefined;
                customReplacements?: string[][] | undefined;
                preserveLeadingUnderscore?: boolean | undefined;
            } | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | z.objectOutputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">;
    }[], {
        action: "create";
        name: string;
        properties: {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            components: [string, ...string[]];
            type: "dynamiczone";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "uid";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            targetField?: string | null | undefined;
            options?: {
                separator?: string | undefined;
                lowercase?: boolean | undefined;
                decamelize?: boolean | undefined;
                customReplacements?: string[][] | undefined;
                preserveLeadingUnderscore?: boolean | undefined;
            } | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | z.objectInputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">;
    }[]>;
}, "strip", z.ZodTypeAny, {
    uid: `${string}.${string}`;
    attributes: {
        action: "create";
        name: string;
        properties: {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            components: [string, ...string[]];
            type: "dynamiczone";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "uid";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            targetField?: string | null | undefined;
            options?: {
                separator?: string | undefined;
                lowercase?: boolean | undefined;
                decamelize?: boolean | undefined;
                customReplacements?: string[][] | undefined;
                preserveLeadingUnderscore?: boolean | undefined;
            } | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | z.objectOutputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">;
    }[];
    category: string;
    displayName: string;
    config: Record<string, unknown>;
    action: "create";
    pluginOptions?: Record<string, unknown> | undefined;
    description?: string | undefined;
    icon?: string | undefined;
}, {
    uid: `${string}.${string}`;
    attributes: {
        action: "create";
        name: string;
        properties: {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            components: [string, ...string[]];
            type: "dynamiczone";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "uid";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            targetField?: string | null | undefined;
            options?: {
                separator?: string | undefined;
                lowercase?: boolean | undefined;
                decamelize?: boolean | undefined;
                customReplacements?: string[][] | undefined;
                preserveLeadingUnderscore?: boolean | undefined;
            } | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | z.objectInputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">;
    }[];
    category: string;
    displayName: string;
    action: "create";
    pluginOptions?: Record<string, unknown> | undefined;
    description?: string | undefined;
    icon?: string | undefined;
    config?: Record<string, unknown> | undefined;
}>;
declare const updateComponentSchema: z.ZodObject<{
    uid: z.ZodType<`${string}.${string}`, z.ZodTypeDef, `${string}.${string}`>;
    displayName: z.ZodString;
    icon: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
} & {
    action: z.ZodLiteral<"update">;
    category: z.ZodOptional<z.ZodString>;
    attributes: z.ZodEffects<z.ZodArray<z.ZodDiscriminatedUnion<"action", [z.ZodObject<{
        action: z.ZodLiteral<"create">;
        name: z.ZodEffects<z.ZodString, string, string>;
        properties: z.ZodEffects<z.ZodEffects<z.ZodEffects<z.ZodEffects<z.ZodUnion<[z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"media">;
            multiple: z.ZodOptional<z.ZodBoolean>;
            required: z.ZodOptional<z.ZodBoolean>;
            allowedTypes: z.ZodOptional<z.ZodArray<z.ZodEnum<["images", "videos", "files", "audios"]>, "atleastone">>;
        }, "strip", z.ZodTypeAny, {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"text">;
            default: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            minLength: z.ZodOptional<z.ZodNumber>;
            maxLength: z.ZodOptional<z.ZodNumber>;
            required: z.ZodOptional<z.ZodBoolean>;
            unique: z.ZodOptional<z.ZodBoolean>;
            regex: z.ZodEffects<z.ZodOptional<z.ZodString>, string | undefined, string | undefined>;
        }, "strip", z.ZodTypeAny, {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
            default: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            minLength: z.ZodOptional<z.ZodNumber>;
            maxLength: z.ZodOptional<z.ZodNumber>;
            required: z.ZodOptional<z.ZodBoolean>;
            unique: z.ZodOptional<z.ZodBoolean>;
            regex: z.ZodEffects<z.ZodOptional<z.ZodString>, string | undefined, string | undefined>;
        } & {
            type: z.ZodLiteral<"string">;
        }, "strip", z.ZodTypeAny, {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"richtext">;
            required: z.ZodOptional<z.ZodBoolean>;
            minLength: z.ZodOptional<z.ZodNumber>;
            maxLength: z.ZodOptional<z.ZodNumber>;
            default: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"blocks">;
            required: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"json">;
            required: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodEffects<z.ZodOptional<z.ZodUnknown>, unknown, unknown>;
        }, "strip", z.ZodTypeAny, {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"enumeration">;
            required: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodOptional<z.ZodString>;
            enumName: z.ZodEffects<z.ZodOptional<z.ZodString>, string | undefined, string | undefined>;
            enum: z.ZodEffects<z.ZodArray<z.ZodEffects<z.ZodString, string, string>, "many">, string[], string[]>;
        }, "strip", z.ZodTypeAny, {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"password">;
            required: z.ZodOptional<z.ZodBoolean>;
            minLength: z.ZodOptional<z.ZodNumber>;
            maxLength: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"email">;
            required: z.ZodOptional<z.ZodBoolean>;
            minLength: z.ZodOptional<z.ZodNumber>;
            maxLength: z.ZodOptional<z.ZodNumber>;
            default: z.ZodOptional<z.ZodString>;
            unique: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"integer">;
            required: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodOptional<z.ZodNumber>;
            unique: z.ZodOptional<z.ZodBoolean>;
            min: z.ZodOptional<z.ZodNumber>;
            max: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"biginteger">;
            required: z.ZodOptional<z.ZodBoolean>;
            unique: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            min: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            max: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"float">;
            required: z.ZodOptional<z.ZodBoolean>;
            unique: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodOptional<z.ZodNumber>;
            min: z.ZodOptional<z.ZodNumber>;
            max: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"decimal">;
            required: z.ZodOptional<z.ZodBoolean>;
            unique: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodOptional<z.ZodNumber>;
            min: z.ZodOptional<z.ZodNumber>;
            max: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"time">;
            required: z.ZodOptional<z.ZodBoolean>;
            unique: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
            required: z.ZodOptional<z.ZodBoolean>;
            unique: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodOptional<z.ZodString>;
        } & {
            type: z.ZodLiteral<"date">;
        }, "strip", z.ZodTypeAny, {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
            required: z.ZodOptional<z.ZodBoolean>;
            unique: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodOptional<z.ZodString>;
        } & {
            type: z.ZodLiteral<"datetime">;
        }, "strip", z.ZodTypeAny, {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"timestamp">;
        }, "strip", z.ZodTypeAny, {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"boolean">;
            required: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"component">;
            component: z.ZodString;
            repeatable: z.ZodOptional<z.ZodBoolean>;
            required: z.ZodOptional<z.ZodBoolean>;
            min: z.ZodOptional<z.ZodNumber>;
            max: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">>, z.ZodDiscriminatedUnion<"relation", [z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"oneToOne">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"oneToMany">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"morphOne">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"morphMany">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"morphToOne">;
        }, "strip", z.ZodTypeAny, {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"morphToMany">;
        }, "strip", z.ZodTypeAny, {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>]> | z.ZodDiscriminatedUnion<"relation", [z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"oneToOne">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"oneToMany">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"manyToOne">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"manyToMany">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"morphOne">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"morphMany">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"morphToOne">;
        }, "strip", z.ZodTypeAny, {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"morphToMany">;
        }, "strip", z.ZodTypeAny, {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>]> | z.ZodDiscriminatedUnion<"relation", [z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"oneToOne">;
            target: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"oneToMany">;
            target: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>]>]>, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | z.objectOutputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | z.objectInputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">>, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | z.objectOutputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | z.objectInputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">>, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | z.objectOutputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | z.objectInputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">>, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | z.objectOutputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | z.objectInputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">> | z.ZodEffects<z.ZodEffects<z.ZodEffects<z.ZodEffects<z.ZodEffects<z.ZodUnion<[z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"media">;
            multiple: z.ZodOptional<z.ZodBoolean>;
            required: z.ZodOptional<z.ZodBoolean>;
            allowedTypes: z.ZodOptional<z.ZodArray<z.ZodEnum<["images", "videos", "files", "audios"]>, "atleastone">>;
        }, "strip", z.ZodTypeAny, {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"text">;
            default: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            minLength: z.ZodOptional<z.ZodNumber>;
            maxLength: z.ZodOptional<z.ZodNumber>;
            required: z.ZodOptional<z.ZodBoolean>;
            unique: z.ZodOptional<z.ZodBoolean>;
            regex: z.ZodEffects<z.ZodOptional<z.ZodString>, string | undefined, string | undefined>;
        }, "strip", z.ZodTypeAny, {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
            default: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            minLength: z.ZodOptional<z.ZodNumber>;
            maxLength: z.ZodOptional<z.ZodNumber>;
            required: z.ZodOptional<z.ZodBoolean>;
            unique: z.ZodOptional<z.ZodBoolean>;
            regex: z.ZodEffects<z.ZodOptional<z.ZodString>, string | undefined, string | undefined>;
        } & {
            type: z.ZodLiteral<"string">;
        }, "strip", z.ZodTypeAny, {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"richtext">;
            required: z.ZodOptional<z.ZodBoolean>;
            minLength: z.ZodOptional<z.ZodNumber>;
            maxLength: z.ZodOptional<z.ZodNumber>;
            default: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"blocks">;
            required: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"json">;
            required: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodEffects<z.ZodOptional<z.ZodUnknown>, unknown, unknown>;
        }, "strip", z.ZodTypeAny, {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"enumeration">;
            required: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodOptional<z.ZodString>;
            enumName: z.ZodEffects<z.ZodOptional<z.ZodString>, string | undefined, string | undefined>;
            enum: z.ZodEffects<z.ZodArray<z.ZodEffects<z.ZodString, string, string>, "many">, string[], string[]>;
        }, "strip", z.ZodTypeAny, {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"password">;
            required: z.ZodOptional<z.ZodBoolean>;
            minLength: z.ZodOptional<z.ZodNumber>;
            maxLength: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"email">;
            required: z.ZodOptional<z.ZodBoolean>;
            minLength: z.ZodOptional<z.ZodNumber>;
            maxLength: z.ZodOptional<z.ZodNumber>;
            default: z.ZodOptional<z.ZodString>;
            unique: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"integer">;
            required: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodOptional<z.ZodNumber>;
            unique: z.ZodOptional<z.ZodBoolean>;
            min: z.ZodOptional<z.ZodNumber>;
            max: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"biginteger">;
            required: z.ZodOptional<z.ZodBoolean>;
            unique: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            min: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            max: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"float">;
            required: z.ZodOptional<z.ZodBoolean>;
            unique: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodOptional<z.ZodNumber>;
            min: z.ZodOptional<z.ZodNumber>;
            max: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"decimal">;
            required: z.ZodOptional<z.ZodBoolean>;
            unique: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodOptional<z.ZodNumber>;
            min: z.ZodOptional<z.ZodNumber>;
            max: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"time">;
            required: z.ZodOptional<z.ZodBoolean>;
            unique: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
            required: z.ZodOptional<z.ZodBoolean>;
            unique: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodOptional<z.ZodString>;
        } & {
            type: z.ZodLiteral<"date">;
        }, "strip", z.ZodTypeAny, {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
            required: z.ZodOptional<z.ZodBoolean>;
            unique: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodOptional<z.ZodString>;
        } & {
            type: z.ZodLiteral<"datetime">;
        }, "strip", z.ZodTypeAny, {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"timestamp">;
        }, "strip", z.ZodTypeAny, {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"boolean">;
            required: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"component">;
            component: z.ZodString;
            repeatable: z.ZodOptional<z.ZodBoolean>;
            required: z.ZodOptional<z.ZodBoolean>;
            min: z.ZodOptional<z.ZodNumber>;
            max: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">>, z.ZodDiscriminatedUnion<"relation", [z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"oneToOne">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"oneToMany">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"morphOne">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"morphMany">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"morphToOne">;
        }, "strip", z.ZodTypeAny, {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"morphToMany">;
        }, "strip", z.ZodTypeAny, {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>]> | z.ZodDiscriminatedUnion<"relation", [z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"oneToOne">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"oneToMany">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"manyToOne">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"manyToMany">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"morphOne">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"morphMany">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"morphToOne">;
        }, "strip", z.ZodTypeAny, {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"morphToMany">;
        }, "strip", z.ZodTypeAny, {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>]> | z.ZodDiscriminatedUnion<"relation", [z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"oneToOne">;
            target: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"oneToMany">;
            target: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>]>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"uid">;
            targetField: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            required: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            minLength: z.ZodOptional<z.ZodNumber>;
            maxLength: z.ZodOptional<z.ZodNumber>;
            options: z.ZodOptional<z.ZodObject<{
                separator: z.ZodOptional<z.ZodString>;
                lowercase: z.ZodOptional<z.ZodBoolean>;
                decamelize: z.ZodOptional<z.ZodBoolean>;
                customReplacements: z.ZodOptional<z.ZodArray<z.ZodArray<z.ZodString, "many">, "many">>;
                preserveLeadingUnderscore: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                separator?: string | undefined;
                lowercase?: boolean | undefined;
                decamelize?: boolean | undefined;
                customReplacements?: string[][] | undefined;
                preserveLeadingUnderscore?: boolean | undefined;
            }, {
                separator?: string | undefined;
                lowercase?: boolean | undefined;
                decamelize?: boolean | undefined;
                customReplacements?: string[][] | undefined;
                preserveLeadingUnderscore?: boolean | undefined;
            }>>;
            regex: z.ZodEffects<z.ZodOptional<z.ZodString>, string | undefined, string | undefined>;
        }, "strip", z.ZodTypeAny, {
            type: "uid";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            targetField?: string | null | undefined;
            options?: {
                separator?: string | undefined;
                lowercase?: boolean | undefined;
                decamelize?: boolean | undefined;
                customReplacements?: string[][] | undefined;
                preserveLeadingUnderscore?: boolean | undefined;
            } | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "uid";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            targetField?: string | null | undefined;
            options?: {
                separator?: string | undefined;
                lowercase?: boolean | undefined;
                decamelize?: boolean | undefined;
                customReplacements?: string[][] | undefined;
                preserveLeadingUnderscore?: boolean | undefined;
            } | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"dynamiczone">;
            components: z.ZodArray<z.ZodString, "atleastone">;
            required: z.ZodOptional<z.ZodBoolean>;
            min: z.ZodOptional<z.ZodNumber>;
            max: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            components: [string, ...string[]];
            type: "dynamiczone";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            components: [string, ...string[]];
            type: "dynamiczone";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>]>, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            components: [string, ...string[]];
            type: "dynamiczone";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "uid";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            targetField?: string | null | undefined;
            options?: {
                separator?: string | undefined;
                lowercase?: boolean | undefined;
                decamelize?: boolean | undefined;
                customReplacements?: string[][] | undefined;
                preserveLeadingUnderscore?: boolean | undefined;
            } | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | z.objectOutputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            components: [string, ...string[]];
            type: "dynamiczone";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "uid";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            targetField?: string | null | undefined;
            options?: {
                separator?: string | undefined;
                lowercase?: boolean | undefined;
                decamelize?: boolean | undefined;
                customReplacements?: string[][] | undefined;
                preserveLeadingUnderscore?: boolean | undefined;
            } | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | z.objectInputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">>, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            components: [string, ...string[]];
            type: "dynamiczone";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "uid";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            targetField?: string | null | undefined;
            options?: {
                separator?: string | undefined;
                lowercase?: boolean | undefined;
                decamelize?: boolean | undefined;
                customReplacements?: string[][] | undefined;
                preserveLeadingUnderscore?: boolean | undefined;
            } | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | z.objectOutputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            components: [string, ...string[]];
            type: "dynamiczone";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "uid";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            targetField?: string | null | undefined;
            options?: {
                separator?: string | undefined;
                lowercase?: boolean | undefined;
                decamelize?: boolean | undefined;
                customReplacements?: string[][] | undefined;
                preserveLeadingUnderscore?: boolean | undefined;
            } | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | z.objectInputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">>, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            components: [string, ...string[]];
            type: "dynamiczone";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "uid";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            targetField?: string | null | undefined;
            options?: {
                separator?: string | undefined;
                lowercase?: boolean | undefined;
                decamelize?: boolean | undefined;
                customReplacements?: string[][] | undefined;
                preserveLeadingUnderscore?: boolean | undefined;
            } | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | z.objectOutputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            components: [string, ...string[]];
            type: "dynamiczone";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "uid";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            targetField?: string | null | undefined;
            options?: {
                separator?: string | undefined;
                lowercase?: boolean | undefined;
                decamelize?: boolean | undefined;
                customReplacements?: string[][] | undefined;
                preserveLeadingUnderscore?: boolean | undefined;
            } | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | z.objectInputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">>, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            components: [string, ...string[]];
            type: "dynamiczone";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "uid";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            targetField?: string | null | undefined;
            options?: {
                separator?: string | undefined;
                lowercase?: boolean | undefined;
                decamelize?: boolean | undefined;
                customReplacements?: string[][] | undefined;
                preserveLeadingUnderscore?: boolean | undefined;
            } | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | z.objectOutputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            components: [string, ...string[]];
            type: "dynamiczone";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "uid";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            targetField?: string | null | undefined;
            options?: {
                separator?: string | undefined;
                lowercase?: boolean | undefined;
                decamelize?: boolean | undefined;
                customReplacements?: string[][] | undefined;
                preserveLeadingUnderscore?: boolean | undefined;
            } | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | z.objectInputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">>, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            components: [string, ...string[]];
            type: "dynamiczone";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "uid";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            targetField?: string | null | undefined;
            options?: {
                separator?: string | undefined;
                lowercase?: boolean | undefined;
                decamelize?: boolean | undefined;
                customReplacements?: string[][] | undefined;
                preserveLeadingUnderscore?: boolean | undefined;
            } | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | z.objectOutputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            components: [string, ...string[]];
            type: "dynamiczone";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "uid";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            targetField?: string | null | undefined;
            options?: {
                separator?: string | undefined;
                lowercase?: boolean | undefined;
                decamelize?: boolean | undefined;
                customReplacements?: string[][] | undefined;
                preserveLeadingUnderscore?: boolean | undefined;
            } | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | z.objectInputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">>;
    }, "strip", z.ZodTypeAny, {
        action: "create";
        name: string;
        properties: {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            components: [string, ...string[]];
            type: "dynamiczone";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "uid";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            targetField?: string | null | undefined;
            options?: {
                separator?: string | undefined;
                lowercase?: boolean | undefined;
                decamelize?: boolean | undefined;
                customReplacements?: string[][] | undefined;
                preserveLeadingUnderscore?: boolean | undefined;
            } | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | z.objectOutputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">;
    }, {
        action: "create";
        name: string;
        properties: {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            components: [string, ...string[]];
            type: "dynamiczone";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "uid";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            targetField?: string | null | undefined;
            options?: {
                separator?: string | undefined;
                lowercase?: boolean | undefined;
                decamelize?: boolean | undefined;
                customReplacements?: string[][] | undefined;
                preserveLeadingUnderscore?: boolean | undefined;
            } | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | z.objectInputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">;
    }>, z.ZodObject<{
        action: z.ZodLiteral<"update">;
        name: z.ZodString;
        properties: z.ZodEffects<z.ZodEffects<z.ZodEffects<z.ZodEffects<z.ZodUnion<[z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"media">;
            multiple: z.ZodOptional<z.ZodBoolean>;
            required: z.ZodOptional<z.ZodBoolean>;
            allowedTypes: z.ZodOptional<z.ZodArray<z.ZodEnum<["images", "videos", "files", "audios"]>, "atleastone">>;
        }, "strip", z.ZodTypeAny, {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"text">;
            default: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            minLength: z.ZodOptional<z.ZodNumber>;
            maxLength: z.ZodOptional<z.ZodNumber>;
            required: z.ZodOptional<z.ZodBoolean>;
            unique: z.ZodOptional<z.ZodBoolean>;
            regex: z.ZodEffects<z.ZodOptional<z.ZodString>, string | undefined, string | undefined>;
        }, "strip", z.ZodTypeAny, {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
            default: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            minLength: z.ZodOptional<z.ZodNumber>;
            maxLength: z.ZodOptional<z.ZodNumber>;
            required: z.ZodOptional<z.ZodBoolean>;
            unique: z.ZodOptional<z.ZodBoolean>;
            regex: z.ZodEffects<z.ZodOptional<z.ZodString>, string | undefined, string | undefined>;
        } & {
            type: z.ZodLiteral<"string">;
        }, "strip", z.ZodTypeAny, {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"richtext">;
            required: z.ZodOptional<z.ZodBoolean>;
            minLength: z.ZodOptional<z.ZodNumber>;
            maxLength: z.ZodOptional<z.ZodNumber>;
            default: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"blocks">;
            required: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"json">;
            required: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodEffects<z.ZodOptional<z.ZodUnknown>, unknown, unknown>;
        }, "strip", z.ZodTypeAny, {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"enumeration">;
            required: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodOptional<z.ZodString>;
            enumName: z.ZodEffects<z.ZodOptional<z.ZodString>, string | undefined, string | undefined>;
            enum: z.ZodEffects<z.ZodArray<z.ZodEffects<z.ZodString, string, string>, "many">, string[], string[]>;
        }, "strip", z.ZodTypeAny, {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"password">;
            required: z.ZodOptional<z.ZodBoolean>;
            minLength: z.ZodOptional<z.ZodNumber>;
            maxLength: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"email">;
            required: z.ZodOptional<z.ZodBoolean>;
            minLength: z.ZodOptional<z.ZodNumber>;
            maxLength: z.ZodOptional<z.ZodNumber>;
            default: z.ZodOptional<z.ZodString>;
            unique: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"integer">;
            required: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodOptional<z.ZodNumber>;
            unique: z.ZodOptional<z.ZodBoolean>;
            min: z.ZodOptional<z.ZodNumber>;
            max: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"biginteger">;
            required: z.ZodOptional<z.ZodBoolean>;
            unique: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            min: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            max: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"float">;
            required: z.ZodOptional<z.ZodBoolean>;
            unique: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodOptional<z.ZodNumber>;
            min: z.ZodOptional<z.ZodNumber>;
            max: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"decimal">;
            required: z.ZodOptional<z.ZodBoolean>;
            unique: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodOptional<z.ZodNumber>;
            min: z.ZodOptional<z.ZodNumber>;
            max: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"time">;
            required: z.ZodOptional<z.ZodBoolean>;
            unique: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
            required: z.ZodOptional<z.ZodBoolean>;
            unique: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodOptional<z.ZodString>;
        } & {
            type: z.ZodLiteral<"date">;
        }, "strip", z.ZodTypeAny, {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
            required: z.ZodOptional<z.ZodBoolean>;
            unique: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodOptional<z.ZodString>;
        } & {
            type: z.ZodLiteral<"datetime">;
        }, "strip", z.ZodTypeAny, {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"timestamp">;
        }, "strip", z.ZodTypeAny, {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"boolean">;
            required: z.ZodOptional<z.ZodBoolean>;
            default: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"component">;
            component: z.ZodString;
            repeatable: z.ZodOptional<z.ZodBoolean>;
            required: z.ZodOptional<z.ZodBoolean>;
            min: z.ZodOptional<z.ZodNumber>;
            max: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">>, z.ZodDiscriminatedUnion<"relation", [z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"oneToOne">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"oneToMany">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"morphOne">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"morphMany">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"morphToOne">;
        }, "strip", z.ZodTypeAny, {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"morphToMany">;
        }, "strip", z.ZodTypeAny, {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>]> | z.ZodDiscriminatedUnion<"relation", [z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"oneToOne">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"oneToMany">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"manyToOne">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"manyToMany">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"morphOne">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"morphMany">;
            target: z.ZodString;
            targetAttribute: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        }, {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"morphToOne">;
        }, "strip", z.ZodTypeAny, {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"morphToMany">;
        }, "strip", z.ZodTypeAny, {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>]> | z.ZodDiscriminatedUnion<"relation", [z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"oneToOne">;
            target: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"relation">;
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            relation: z.ZodLiteral<"oneToMany">;
            target: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        }, {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        }>]>]>, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | z.objectOutputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | z.objectInputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">>, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | z.objectOutputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | z.objectInputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">>, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "blocks";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "json";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: unknown;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            enum: string[];
            type: "enumeration";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            enumName?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "text";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "string";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            regex?: string | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "password";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "email";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "integer";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "biginteger";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: string | null | undefined;
            max?: string | null | undefined;
            default?: string | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "float";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "decimal";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            default?: number | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "time";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "date";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "datetime";
            unique?: boolean | undefined;
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "timestamp";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "boolean";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: boolean | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            component: string;
            type: "component";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            min?: number | undefined;
            max?: number | undefined;
            configurable?: boolean | null | undefined;
            repeatable?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | {
            type: "media";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            allowedTypes?: ["images" | "videos" | "files" | "audios", ...("images" | "videos" | "files" | "audios")[]] | undefined;
            multiple?: boolean | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: {
                visible: Record<string, any[]>;
            } | undefined;
        } | z.objectOutputType<{
            configurable: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            private: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
            pluginOptions: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            conditions: z.ZodEffects<z.ZodOptional<z.ZodObject<{
                visible: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodAny, "many">>;
            }, "strip", z.ZodTypeAny, {
                visible: Record<string, any[]>;
            }, {
                visible: Record<string, any[]>;
            }>>, {
                visible: Record<string, any[]>;
            } | undefined, unknown>;
        } & {
            type: z.ZodLiteral<"customField">;
            customField: z.ZodString;
        }, z.ZodTypeAny, "passthrough">, {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "oneToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "manyToOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "manyToMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphOne";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphMany";
            target: string;
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
            targetAttribute?: string | null | undefined;
        } | {
            relation: "morphToOne";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            relation: "morphToMany";
            type: "relation";
            private?: boolean | null | undefined;
            configurable?: boolean | null | undefined;
            pluginOptions?: Record<string, unknown> | undefined;
            conditions?: unknown;
        } | {
            type: "richtext";
            required?: boolean | undefined;
            private?: boolean | null | undefined;
            default?: string | undefined;
            configurable?: boolean | null | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            pluginOp