const parseDateValue = (value)=>{
    if (value instanceof Date && isValidDate(value)) {
        return value;
    }
    if (typeof value === 'string' || typeof value === 'number') {
        const date = new Date(value);
        if (isValidDate(date)) {
            return date;
        }
    }
};
const isValidDate = (date)=>!isNaN(date.getTime());

export { parseDateValue };
//# sourceMappingURL=parseDateValue.mjs.map
