/**
 * Hook that provides tracking functionality with automatic CTB session ID inclusion.
 * This version accepts arbitrary event names (string) to allow feature-specific
 * events that are not yet declared in the central tracking typings.
 *
 * Note: this intentionally relaxes TypeScript restrictions so callers can
 * emit new tracking event names without needing to update the upstream
 * tracking type definitions. The session ID is merged into the properties
 * object before forwarding to the original tracking implementation.
 */
export declare const useCTBTracking: () => {
    trackUsage: (event: string, properties?: Record<string, unknown>) => any;
};
