import { jsx, jsxs, Fragment } from 'react/jsx-runtime';
import { Layouts, tours } from '@strapi/admin/strapi-admin';
import { Flex, Button, Box, Typography } from '@strapi/design-system';
import { Pencil, Plus, Information } from '@strapi/icons';
import upperFirst from 'lodash/upperFirst';
import { useIntl } from 'react-intl';
import { useParams, Navigate } from 'react-router-dom';
import { styled } from 'styled-components';
import 'react';
import '../../components/CTBSession/sessionContext.mjs';
import { useCTBTracking } from '../../components/CTBSession/useCTBTracking.mjs';
import { useDataManager } from '../../components/DataManager/useDataManager.mjs';
import { useFormModalNavigation } from '../../components/FormModalNavigation/useFormModalNavigation.mjs';
import { List } from '../../components/List.mjs';
import { getTrad } from '../../utils/getTrad.mjs';
import { LinkToCMSettingsView } from './LinkToCMSettingsView.mjs';

const LayoutsHeaderCustom = styled(Layouts.Header)`
  overflow: hidden;
  text-overflow: ellipsis;
  white-space: nowrap;
`;
const ListView = ()=>{
    const { isInDevelopmentMode, contentTypes, components, isLoading } = useDataManager();
    const { formatMessage } = useIntl();
    const { trackUsage } = useCTBTracking();
    const { contentTypeUid, componentUid } = useParams();
    const { onOpenModalAddComponentsToDZ, onOpenModalAddField, onOpenModalEditSchema } = useFormModalNavigation();
    const type = contentTypeUid ? contentTypes[contentTypeUid] : componentUid ? components[componentUid] : null;
    if (isLoading) {
        return null;
    }
    if (!type) {
        const allowedEndpoints = Object.values(contentTypes).filter((ct)=>ct.visible === true && !ct.plugin).map((ct)=>ct.uid).sort();
        if (allowedEndpoints.length > 0) {
            return /*#__PURE__*/ jsx(Navigate, {
                to: `/plugins/content-type-builder/content-types/${allowedEndpoints[0]}`
            });
        }
        return /*#__PURE__*/ jsx(Navigate, {
            to: "/plugins/content-type-builder/content-types/create-content-type"
        });
    }
    if (contentTypeUid && type.modelType === 'contentType' && type.visible === false) {
        return /*#__PURE__*/ jsx(Navigate, {
            to: "/plugins/content-type-builder/content-types/create-content-type",
            replace: true
        });
    }
    const isFromPlugin = 'plugin' in type && type?.plugin !== undefined;
    const forTarget = contentTypeUid ? 'contentType' : 'component';
    const label = type?.info?.displayName ?? '';
    const canEdit = isInDevelopmentMode && !isFromPlugin;
    const handleClickAddComponentToDZ = (dynamicZoneTarget)=>{
        onOpenModalAddComponentsToDZ({
            dynamicZoneTarget,
            targetUid: type.uid
        });
    };
    const onEdit = ()=>{
        if ('kind' in type) {
            if (type?.kind === 'collectionType') {
                trackUsage('willEditNameOfContentType');
            }
            if (type?.kind === 'singleType') {
                trackUsage('willEditNameOfSingleType');
            }
            onOpenModalEditSchema({
                modalType: forTarget,
                forTarget: forTarget,
                targetUid: type.uid,
                kind: type?.kind
            });
            return;
        }
        onOpenModalEditSchema({
            modalType: forTarget,
            forTarget: forTarget,
            targetUid: type.uid
        });
    };
    const addNewFieldLabel = formatMessage({
        id: getTrad('table.button.no-fields'),
        defaultMessage: 'Add new field'
    });
    const addAnotherFieldLabel = formatMessage({
        id: getTrad('button.attributes.add.another'),
        defaultMessage: 'Add another field'
    });
    const isDeleted = type.status === 'REMOVED';
    const primaryAction = isInDevelopmentMode && /*#__PURE__*/ jsxs(Flex, {
        gap: 2,
        children: [
            /*#__PURE__*/ jsx(LinkToCMSettingsView, {
                type: type,
                disabled: type.status === 'NEW' || isDeleted
            }, "link-to-cm-settings-view"),
            /*#__PURE__*/ jsx(Button, {
                startIcon: /*#__PURE__*/ jsx(Pencil, {}),
                variant: "tertiary",
                onClick: onEdit,
                disabled: !canEdit || isDeleted,
                children: formatMessage({
                    id: 'app.utils.edit',
                    defaultMessage: 'Edit'
                })
            }),
            /*#__PURE__*/ jsx(Button, {
                startIcon: /*#__PURE__*/ jsx(Plus, {}),
                variant: "secondary",
                minWidth: "max-content",
                onClick: ()=>{
                    onOpenModalAddField({
                        forTarget,
                        targetUid: type.uid
                    });
                },
                disabled: isDeleted,
                children: type.attributes.length === 0 ? addNewFieldLabel : addAnotherFieldLabel
            })
        ]
    });
    return /*#__PURE__*/ jsxs(Fragment, {
        children: [
            /*#__PURE__*/ jsx(tours.contentTypeBuilder.Introduction, {
                children: /*#__PURE__*/ jsx(Box, {})
            }),
            isDeleted && /*#__PURE__*/ jsx(Flex, {
                background: "danger100",
                justifyContent: 'center',
                padding: 4,
                children: /*#__PURE__*/ jsxs(Flex, {
                    gap: 2,
                    children: [
                        /*#__PURE__*/ jsx(Information, {
                            fill: "danger600",
                            height: "2rem",
                            width: "2rem"
                        }),
                        /*#__PURE__*/ jsx(Typography, {
                            children: formatMessage({
                                id: getTrad('table.warning.deleted'),
                                defaultMessage: `This {kind} has been deleted`
                            }, {
                                kind: type.modelType === 'contentType' ? 'Content Type' : 'Component'
                            })
                        })
                    ]
                })
            }),
            /*#__PURE__*/ jsx(LayoutsHeaderCustom, {
                id: "title",
                primaryAction: primaryAction,
                title: upperFirst(label)
            }),
            /*#__PURE__*/ jsx(Layouts.Content, {
                children: /*#__PURE__*/ jsx(Box, {
                    background: "neutral0",
                    shadow: "filterShadow",
                    hasRadius: true,
                    overflow: "auto",
                    borderColor: "neutral150",
                    children: /*#__PURE__*/ jsx(List, {
                        type: type,
                        addComponentToDZ: handleClickAddComponentToDZ,
                        isMain: true
                    })
                })
            })
        ]
    });
};

export { ListView as default };
//# sourceMappingURL=ListView.mjs.map
