'use strict';

var jsxRuntime = require('react/jsx-runtime');
var strapiAdmin = require('@strapi/admin/strapi-admin');
var designSystem = require('@strapi/design-system');
var Icons = require('@strapi/icons');
var upperFirst = require('lodash/upperFirst');
var reactIntl = require('react-intl');
var reactRouterDom = require('react-router-dom');
var styledComponents = require('styled-components');
require('react');
require('../../components/CTBSession/sessionContext.js');
var useCTBTracking = require('../../components/CTBSession/useCTBTracking.js');
var useDataManager = require('../../components/DataManager/useDataManager.js');
var useFormModalNavigation = require('../../components/FormModalNavigation/useFormModalNavigation.js');
var List = require('../../components/List.js');
var getTrad = require('../../utils/getTrad.js');
var LinkToCMSettingsView = require('./LinkToCMSettingsView.js');

const LayoutsHeaderCustom = styledComponents.styled(strapiAdmin.Layouts.Header)`
  overflow: hidden;
  text-overflow: ellipsis;
  white-space: nowrap;
`;
const ListView = ()=>{
    const { isInDevelopmentMode, contentTypes, components, isLoading } = useDataManager.useDataManager();
    const { formatMessage } = reactIntl.useIntl();
    const { trackUsage } = useCTBTracking.useCTBTracking();
    const { contentTypeUid, componentUid } = reactRouterDom.useParams();
    const { onOpenModalAddComponentsToDZ, onOpenModalAddField, onOpenModalEditSchema } = useFormModalNavigation.useFormModalNavigation();
    const type = contentTypeUid ? contentTypes[contentTypeUid] : componentUid ? components[componentUid] : null;
    if (isLoading) {
        return null;
    }
    if (!type) {
        const allowedEndpoints = Object.values(contentTypes).filter((ct)=>ct.visible === true && !ct.plugin).map((ct)=>ct.uid).sort();
        if (allowedEndpoints.length > 0) {
            return /*#__PURE__*/ jsxRuntime.jsx(reactRouterDom.Navigate, {
                to: `/plugins/content-type-builder/content-types/${allowedEndpoints[0]}`
            });
        }
        return /*#__PURE__*/ jsxRuntime.jsx(reactRouterDom.Navigate, {
            to: "/plugins/content-type-builder/content-types/create-content-type"
        });
    }
    if (contentTypeUid && type.modelType === 'contentType' && type.visible === false) {
        return /*#__PURE__*/ jsxRuntime.jsx(reactRouterDom.Navigate, {
            to: "/plugins/content-type-builder/content-types/create-content-type",
            replace: true
        });
    }
    const isFromPlugin = 'plugin' in type && type?.plugin !== undefined;
    const forTarget = contentTypeUid ? 'contentType' : 'component';
    const label = type?.info?.displayName ?? '';
    const canEdit = isInDevelopmentMode && !isFromPlugin;
    const handleClickAddComponentToDZ = (dynamicZoneTarget)=>{
        onOpenModalAddComponentsToDZ({
            dynamicZoneTarget,
            targetUid: type.uid
        });
    };
    const onEdit = ()=>{
        if ('kind' in type) {
            if (type?.kind === 'collectionType') {
                trackUsage('willEditNameOfContentType');
            }
            if (type?.kind === 'singleType') {
                trackUsage('willEditNameOfSingleType');
            }
            onOpenModalEditSchema({
                modalType: forTarget,
                forTarget: forTarget,
                targetUid: type.uid,
                kind: type?.kind
            });
            return;
        }
        onOpenModalEditSchema({
            modalType: forTarget,
            forTarget: forTarget,
            targetUid: type.uid
        });
    };
    const addNewFieldLabel = formatMessage({
        id: getTrad.getTrad('table.button.no-fields'),
        defaultMessage: 'Add new field'
    });
    const addAnotherFieldLabel = formatMessage({
        id: getTrad.getTrad('button.attributes.add.another'),
        defaultMessage: 'Add another field'
    });
    const isDeleted = type.status === 'REMOVED';
    const primaryAction = isInDevelopmentMode && /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
        gap: 2,
        children: [
            /*#__PURE__*/ jsxRuntime.jsx(LinkToCMSettingsView.LinkToCMSettingsView, {
                type: type,
                disabled: type.status === 'NEW' || isDeleted
            }, "link-to-cm-settings-view"),
            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Button, {
                startIcon: /*#__PURE__*/ jsxRuntime.jsx(Icons.Pencil, {}),
                variant: "tertiary",
                onClick: onEdit,
                disabled: !canEdit || isDeleted,
                children: formatMessage({
                    id: 'app.utils.edit',
                    defaultMessage: 'Edit'
                })
            }),
            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Button, {
                startIcon: /*#__PURE__*/ jsxRuntime.jsx(Icons.Plus, {}),
                variant: "secondary",
                minWidth: "max-content",
                onClick: ()=>{
                    onOpenModalAddField({
                        forTarget,
                        targetUid: type.uid
                    });
                },
                disabled: isDeleted,
                children: type.attributes.length === 0 ? addNewFieldLabel : addAnotherFieldLabel
            })
        ]
    });
    return /*#__PURE__*/ jsxRuntime.jsxs(jsxRuntime.Fragment, {
        children: [
            /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.tours.contentTypeBuilder.Introduction, {
                children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Box, {})
            }),
            isDeleted && /*#__PURE__*/ jsxRuntime.jsx(designSystem.Flex, {
                background: "danger100",
                justifyContent: 'center',
                padding: 4,
                children: /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Flex, {
                    gap: 2,
                    children: [
                        /*#__PURE__*/ jsxRuntime.jsx(Icons.Information, {
                            fill: "danger600",
                            height: "2rem",
                            width: "2rem"
                        }),
                        /*#__PURE__*/ jsxRuntime.jsx(designSystem.Typography, {
                            children: formatMessage({
                                id: getTrad.getTrad('table.warning.deleted'),
                                defaultMessage: `This {kind} has been deleted`
                            }, {
                                kind: type.modelType === 'contentType' ? 'Content Type' : 'Component'
                            })
                        })
                    ]
                })
            }),
            /*#__PURE__*/ jsxRuntime.jsx(LayoutsHeaderCustom, {
                id: "title",
                primaryAction: primaryAction,
                title: upperFirst(label)
            }),
            /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.Layouts.Content, {
                children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Box, {
                    background: "neutral0",
                    shadow: "filterShadow",
                    hasRadius: true,
                    overflow: "auto",
                    borderColor: "neutral150",
                    children: /*#__PURE__*/ jsxRuntime.jsx(List.List, {
                        type: type,
                        addComponentToDZ: handleClickAddComponentToDZ,
                        isMain: true
                    })
                })
            })
        ]
    });
};

module.exports = ListView;
//# sourceMappingURL=ListView.js.map
