import { jsxs, jsx, Fragment } from 'react/jsx-runtime';
import { useEffect, Suspense, lazy } from 'react';
import { useAppInfo, useGuidedTour, Page, Layouts } from '@strapi/admin/strapi-admin';
import { useAIAvailability } from '@strapi/admin/strapi-admin/ee';
import { useIntl } from 'react-intl';
import { Routes, Route } from 'react-router-dom';
import { Chat } from '../../components/AIChat/Chat.mjs';
import { prefetchAIToken } from '../../components/AIChat/lib/aiClient.mjs';
import { ChatProvider } from '../../components/AIChat/providers/ChatProvider.mjs';
import { AutoReloadOverlayBlockerProvider } from '../../components/AutoReloadOverlayBlocker.mjs';
import { ContentTypeBuilderNav } from '../../components/ContentTypeBuilderNav/ContentTypeBuilderNav.mjs';
import { CTBSessionProvider } from '../../components/CTBSession/CTBSessionProvider.mjs';
import DataManagerProvider from '../../components/DataManager/DataManagerProvider.mjs';
import { ExitPrompt } from '../../components/ExitPrompt.mjs';
import { FormModal } from '../../components/FormModal/FormModal.mjs';
import { FormModalNavigationProvider } from '../../components/FormModalNavigation/FormModalNavigationProvider.mjs';
import { PERMISSIONS } from '../../constants.mjs';
import { pluginId } from '../../pluginId.mjs';
import { EmptyState } from '../ListView/EmptyState.mjs';

const ListView = /*#__PURE__*/ lazy(()=>import('../ListView/ListView.mjs'));
const App = ()=>{
    const { formatMessage } = useIntl();
    const title = formatMessage({
        id: `${pluginId}.plugin.name`,
        defaultMessage: 'Content Types Builder'
    });
    const autoReload = useAppInfo('DataManagerProvider', (state)=>state.autoReload);
    const isAIEnabled = useAIAvailability();
    const state = useGuidedTour('ContentTypeBuilderApp', (s)=>s.state);
    const dispatch = useGuidedTour('ContentTypeBuilderApp', (s)=>s.dispatch);
    // Prefetch AI token on initial load
    useEffect(()=>{
        prefetchAIToken();
    }, []);
    // Set tour type based on AI availability when the app loads
    useEffect(()=>{
        const tourType = isAIEnabled ? 'ContentTypeBuilderAI' : 'ContentTypeBuilderNoAI';
        const currentTourType = state.tours.contentTypeBuilder.tourType;
        if (currentTourType !== tourType) {
            dispatch({
                type: 'set_tour_type',
                payload: {
                    tourName: 'contentTypeBuilder',
                    tourType
                }
            });
        }
    }, [
        isAIEnabled,
        state.tours.contentTypeBuilder.tourType,
        dispatch
    ]);
    return /*#__PURE__*/ jsxs(Page.Protect, {
        permissions: PERMISSIONS.main,
        children: [
            /*#__PURE__*/ jsx(Page.Title, {
                children: title
            }),
            /*#__PURE__*/ jsx(AutoReloadOverlayBlockerProvider, {
                children: /*#__PURE__*/ jsx(CTBSessionProvider, {
                    children: /*#__PURE__*/ jsx(FormModalNavigationProvider, {
                        children: /*#__PURE__*/ jsxs(DataManagerProvider, {
                            children: [
                                /*#__PURE__*/ jsx(ExitPrompt, {}),
                                /*#__PURE__*/ jsx(ChatProvider, {
                                    children: /*#__PURE__*/ jsxs(Fragment, {
                                        children: [
                                            autoReload && /*#__PURE__*/ jsx(FormModal, {}),
                                            /*#__PURE__*/ jsx(Layouts.Root, {
                                                sideNav: /*#__PURE__*/ jsx(ContentTypeBuilderNav, {}),
                                                children: /*#__PURE__*/ jsx(Suspense, {
                                                    fallback: /*#__PURE__*/ jsx(Page.Loading, {}),
                                                    children: /*#__PURE__*/ jsxs(Routes, {
                                                        children: [
                                                            /*#__PURE__*/ jsx(Route, {
                                                                path: "content-types/create-content-type",
                                                                element: /*#__PURE__*/ jsx(EmptyState, {})
                                                            }),
                                                            /*#__PURE__*/ jsx(Route, {
                                                                path: "content-types/:contentTypeUid",
                                                                element: /*#__PURE__*/ jsx(ListView, {})
                                                            }),
                                                            /*#__PURE__*/ jsx(Route, {
                                                                path: `component-categories/:categoryUid/:componentUid`,
                                                                element: /*#__PURE__*/ jsx(ListView, {})
                                                            }),
                                                            /*#__PURE__*/ jsx(Route, {
                                                                path: "*",
                                                                element: /*#__PURE__*/ jsx(ListView, {})
                                                            })
                                                        ]
                                                    })
                                                })
                                            }),
                                            /*#__PURE__*/ jsx(Chat, {})
                                        ]
                                    })
                                })
                            ]
                        })
                    })
                })
            })
        ]
    });
};

export { App as default };
//# sourceMappingURL=index.mjs.map
