'use strict';

var jsxRuntime = require('react/jsx-runtime');
var designSystem = require('@strapi/design-system');
var get = require('lodash/get');
var reactIntl = require('react-intl');
var conditions = require('../utils/conditions.js');
var GenericInputs = require('./GenericInputs.js');

/* eslint-disable react/no-array-index-key */ const TabForm = ({ form, formErrors, genericInputProps, modifiedData, onChange })=>{
    const { formatMessage } = reactIntl.useIntl();
    return /*#__PURE__*/ jsxRuntime.jsx(jsxRuntime.Fragment, {
        children: form.map((section, sectionIndex)=>{
            // Don't display an empty section
            if (section.items.length === 0) {
                return null;
            }
            return /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Box, {
                children: [
                    section.sectionTitle && /*#__PURE__*/ jsxRuntime.jsx(designSystem.Box, {
                        paddingBottom: 4,
                        children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Typography, {
                            variant: "delta",
                            tag: "h3",
                            children: formatMessage(section.sectionTitle)
                        })
                    }),
                    section.intlLabel && /*#__PURE__*/ jsxRuntime.jsx(designSystem.Typography, {
                        variant: "pi",
                        textColor: "neutral600",
                        children: formatMessage(section.intlLabel)
                    }),
                    /*#__PURE__*/ jsxRuntime.jsx(designSystem.Grid.Root, {
                        gap: 4,
                        children: section.items.map((input, i)=>{
                            const key = `${sectionIndex}.${i}`;
                            /**
                 * Use undefined as the default value because not every input wants a string e.g. Date pickers
                 */ const value = get(modifiedData, input.name, undefined);
                            // When extending the yup schema of an existing field (like in https://github.com/strapi/strapi/blob/293ff3b8f9559236609d123a2774e3be05ce8274/packages/strapi-plugin-i18n/admin/src/index.js#L52)
                            // and triggering a yup validation error in the UI (missing a required field for example)
                            // We got an object that looks like: formErrors = { "pluginOptions.i18n.localized": {...} }
                            // In order to deal with this error, we can't rely on lodash.get to resolve this key
                            // - lodash will try to access {pluginOptions: {i18n: {localized: true}}})
                            // - and we just want to access { "pluginOptions.i18n.localized": {...} }
                            // NOTE: this is a hack
                            const pluginOptionError = Object.keys(formErrors).find((key)=>key === input.name);
                            // Retrieve the error for a specific input
                            const errorId = pluginOptionError ? formErrors[pluginOptionError].id : get(formErrors, [
                                ...input.name.split('.')// The filter here is used when creating a component
                                // in the component step 1 modal
                                // Since the component info is stored in the
                                // componentToCreate object we can access the error
                                // By removing the key
                                .filter((key)=>key !== 'componentToCreate'),
                                'id'
                            ], null);
                            if (input.type === 'pushRight') {
                                return /*#__PURE__*/ jsxRuntime.jsx(designSystem.Grid.Item, {
                                    col: input.size || 6,
                                    xs: 12,
                                    direction: "column",
                                    alignItems: "stretch",
                                    children: /*#__PURE__*/ jsxRuntime.jsx("div", {})
                                }, input.name || key);
                            }
                            // Special handling for 'condition-form'
                            if (input.type === 'condition-form') {
                                const currentCondition = get(modifiedData, input.name);
                                // Get all attributes from the content type schema
                                const contentTypeAttributes = genericInputProps.contentTypeSchema?.attributes || [];
                                if (!genericInputProps.contentTypeSchema) {
                                    console.warn('contentTypeSchema is undefined, skipping condition form');
                                    return null;
                                }
                                // Filter for boolean and enumeration fields only, excluding the current field
                                const availableFields = conditions.getAvailableConditionFields(contentTypeAttributes, modifiedData.name);
                                const noFieldsMessage = formatMessage({
                                    id: 'form.attribute.condition.no-fields',
                                    defaultMessage: 'No boolean or enumeration fields available to set conditions on.'
                                });
                                return /*#__PURE__*/ jsxRuntime.jsx(designSystem.Grid.Item, {
                                    col: input.size || 12,
                                    xs: 12,
                                    direction: "column",
                                    alignItems: "stretch",
                                    children: !currentCondition || Object.keys(currentCondition).length === 0 ? /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Box, {
                                        children: [
                                            currentCondition && Object.keys(currentCondition).length > 0 && /*#__PURE__*/ jsxRuntime.jsx(designSystem.Typography, {
                                                variant: "sigma",
                                                textColor: "neutral800",
                                                marginBottom: 2,
                                                children: conditions.formatCondition(currentCondition, availableFields, genericInputProps.attributeName || modifiedData.name)
                                            }),
                                            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Tooltip, {
                                                label: noFieldsMessage,
                                                children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Button, {
                                                    marginTop: currentCondition && Object.keys(currentCondition).length > 0 ? 0 : 4,
                                                    fullWidth: true,
                                                    variant: "secondary",
                                                    onClick: ()=>{
                                                        onChange({
                                                            target: {
                                                                name: input.name,
                                                                value: {
                                                                    visible: {
                                                                        '==': [
                                                                            {
                                                                                var: ''
                                                                            },
                                                                            ''
                                                                        ]
                                                                    }
                                                                }
                                                            }
                                                        });
                                                    },
                                                    startIcon: /*#__PURE__*/ jsxRuntime.jsx("span", {
                                                        "aria-hidden": true,
                                                        children: "＋"
                                                    }),
                                                    disabled: availableFields.length === 0,
                                                    children: formatMessage({
                                                        id: 'form.attribute.condition.apply',
                                                        defaultMessage: 'Apply condition'
                                                    })
                                                })
                                            })
                                        ]
                                    }) : /*#__PURE__*/ jsxRuntime.jsx(GenericInputs.GenericInput, {
                                        ...input,
                                        ...genericInputProps,
                                        error: errorId,
                                        onChange: onChange,
                                        value: value,
                                        autoFocus: i === 0,
                                        attributeName: modifiedData.name,
                                        conditionFields: availableFields,
                                        onDelete: ()=>{
                                            onChange({
                                                target: {
                                                    name: input.name
                                                }
                                            });
                                        }
                                    })
                                }, input.name || key);
                            }
                            // Default rendering for all other input types
                            return /*#__PURE__*/ jsxRuntime.jsx(designSystem.Grid.Item, {
                                col: input.size || 6,
                                xs: 12,
                                direction: "column",
                                alignItems: "stretch",
                                children: /*#__PURE__*/ jsxRuntime.jsx(GenericInputs.GenericInput, {
                                    ...input,
                                    ...genericInputProps,
                                    error: errorId,
                                    onChange: onChange,
                                    value: value,
                                    autoFocus: i === 0
                                })
                            }, input.name || key);
                        })
                    })
                ]
            }, sectionIndex);
        })
    });
};

exports.TabForm = TabForm;
//# sourceMappingURL=TabForm.js.map
