import { jsxs, jsx } from 'react/jsx-runtime';
import { useRef, useEffect } from 'react';
import { Field, TextInput } from '@strapi/design-system';
import { useIntl } from 'react-intl';
import { nameToSlug } from '../utils/nameToSlug.mjs';

const SingularName = ({ description = null, error = null, intlLabel, modifiedData, name, onChange, value = null })=>{
    const { formatMessage } = useIntl();
    const onChangeRef = useRef(onChange);
    const previousValue = useRef(value);
    const previousDisplayName = useRef(modifiedData?.displayName || '');
    const displayName = modifiedData?.displayName || '';
    useEffect(()=>{
        if (displayName && displayName !== previousDisplayName.current) {
            const newValue = nameToSlug(displayName);
            onChangeRef.current({
                target: {
                    name,
                    value: newValue
                }
            });
            previousValue.current = newValue;
            previousDisplayName.current = displayName;
        } else if (!displayName) {
            onChangeRef.current({
                target: {
                    name,
                    value: ''
                }
            });
            previousValue.current = '';
            previousDisplayName.current = '';
        }
    }, [
        displayName,
        name,
        value
    ]);
    const errorMessage = error ? formatMessage({
        id: error,
        defaultMessage: error
    }) : '';
    const hint = description ? formatMessage({
        id: description.id,
        defaultMessage: description.defaultMessage
    }, {
        ...description.values
    }) : '';
    const label = formatMessage(intlLabel);
    return /*#__PURE__*/ jsxs(Field.Root, {
        error: errorMessage,
        hint: hint,
        name: name,
        children: [
            /*#__PURE__*/ jsx(Field.Label, {
                children: label
            }),
            /*#__PURE__*/ jsx(TextInput, {
                onChange: onChange,
                value: value || '',
                type: "text"
            }),
            /*#__PURE__*/ jsx(Field.Error, {}),
            /*#__PURE__*/ jsx(Field.Hint, {})
        ]
    });
};

export { SingularName };
//# sourceMappingURL=SingularName.mjs.map
