'use strict';

var jsxRuntime = require('react/jsx-runtime');
var React = require('react');
var designSystem = require('@strapi/design-system');
var reactIntl = require('react-intl');
var nameToSlug = require('../utils/nameToSlug.js');

const SingularName = ({ description = null, error = null, intlLabel, modifiedData, name, onChange, value = null })=>{
    const { formatMessage } = reactIntl.useIntl();
    const onChangeRef = React.useRef(onChange);
    const previousValue = React.useRef(value);
    const previousDisplayName = React.useRef(modifiedData?.displayName || '');
    const displayName = modifiedData?.displayName || '';
    React.useEffect(()=>{
        if (displayName && displayName !== previousDisplayName.current) {
            const newValue = nameToSlug.nameToSlug(displayName);
            onChangeRef.current({
                target: {
                    name,
                    value: newValue
                }
            });
            previousValue.current = newValue;
            previousDisplayName.current = displayName;
        } else if (!displayName) {
            onChangeRef.current({
                target: {
                    name,
                    value: ''
                }
            });
            previousValue.current = '';
            previousDisplayName.current = '';
        }
    }, [
        displayName,
        name,
        value
    ]);
    const errorMessage = error ? formatMessage({
        id: error,
        defaultMessage: error
    }) : '';
    const hint = description ? formatMessage({
        id: description.id,
        defaultMessage: description.defaultMessage
    }, {
        ...description.values
    }) : '';
    const label = formatMessage(intlLabel);
    return /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Field.Root, {
        error: errorMessage,
        hint: hint,
        name: name,
        children: [
            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Field.Label, {
                children: label
            }),
            /*#__PURE__*/ jsxRuntime.jsx(designSystem.TextInput, {
                onChange: onChange,
                value: value || '',
                type: "text"
            }),
            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Field.Error, {}),
            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Field.Hint, {})
        ]
    });
};

exports.SingularName = SingularName;
//# sourceMappingURL=SingularName.js.map
