import { jsxs, jsx } from 'react/jsx-runtime';
import { useRef, useEffect } from 'react';
import { Field, TextInput } from '@strapi/design-system';
import pluralize from 'pluralize';
import { useIntl } from 'react-intl';
import { nameToSlug } from '../utils/nameToSlug.mjs';

const PluralName = ({ description, error, intlLabel, modifiedData, name, onChange, value })=>{
    const { formatMessage } = useIntl();
    const onChangeRef = useRef(onChange);
    const displayName = modifiedData?.displayName || '';
    const previousDisplayName = useRef(displayName);
    const previousValue = useRef(value);
    useEffect(()=>{
        if (displayName && displayName !== previousDisplayName.current) {
            const baseValue = nameToSlug(displayName);
            let newValue = baseValue;
            try {
                newValue = pluralize(baseValue, 2);
            } catch (err) {
            // If pluralize fails, use the base value
            }
            onChangeRef.current({
                target: {
                    name,
                    value: newValue
                }
            });
            previousValue.current = newValue;
            previousDisplayName.current = displayName;
        } else if (!displayName) {
            onChangeRef.current({
                target: {
                    name,
                    value: ''
                }
            });
            previousValue.current = '';
            previousDisplayName.current = '';
        }
    }, [
        displayName,
        name,
        value
    ]);
    const errorMessage = error ? formatMessage({
        id: error,
        defaultMessage: error
    }) : '';
    const hint = description ? formatMessage({
        id: description.id,
        defaultMessage: description.defaultMessage
    }, {
        ...description.values
    }) : '';
    const label = formatMessage(intlLabel);
    return /*#__PURE__*/ jsxs(Field.Root, {
        error: errorMessage,
        hint: hint,
        name: name,
        children: [
            /*#__PURE__*/ jsx(Field.Label, {
                children: label
            }),
            /*#__PURE__*/ jsx(TextInput, {
                onChange: onChange,
                value: value || '',
                type: "text"
            }),
            /*#__PURE__*/ jsx(Field.Error, {})
        ]
    });
};

export { PluralName };
//# sourceMappingURL=PluralName.mjs.map
