'use strict';

var jsxRuntime = require('react/jsx-runtime');
var React = require('react');
var designSystem = require('@strapi/design-system');
var pluralize = require('pluralize');
var reactIntl = require('react-intl');
var nameToSlug = require('../utils/nameToSlug.js');

const PluralName = ({ description, error, intlLabel, modifiedData, name, onChange, value })=>{
    const { formatMessage } = reactIntl.useIntl();
    const onChangeRef = React.useRef(onChange);
    const displayName = modifiedData?.displayName || '';
    const previousDisplayName = React.useRef(displayName);
    const previousValue = React.useRef(value);
    React.useEffect(()=>{
        if (displayName && displayName !== previousDisplayName.current) {
            const baseValue = nameToSlug.nameToSlug(displayName);
            let newValue = baseValue;
            try {
                newValue = pluralize(baseValue, 2);
            } catch (err) {
            // If pluralize fails, use the base value
            }
            onChangeRef.current({
                target: {
                    name,
                    value: newValue
                }
            });
            previousValue.current = newValue;
            previousDisplayName.current = displayName;
        } else if (!displayName) {
            onChangeRef.current({
                target: {
                    name,
                    value: ''
                }
            });
            previousValue.current = '';
            previousDisplayName.current = '';
        }
    }, [
        displayName,
        name,
        value
    ]);
    const errorMessage = error ? formatMessage({
        id: error,
        defaultMessage: error
    }) : '';
    const hint = description ? formatMessage({
        id: description.id,
        defaultMessage: description.defaultMessage
    }, {
        ...description.values
    }) : '';
    const label = formatMessage(intlLabel);
    return /*#__PURE__*/ jsxRuntime.jsxs(designSystem.Field.Root, {
        error: errorMessage,
        hint: hint,
        name: name,
        children: [
            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Field.Label, {
                children: label
            }),
            /*#__PURE__*/ jsxRuntime.jsx(designSystem.TextInput, {
                onChange: onChange,
                value: value || '',
                type: "text"
            }),
            /*#__PURE__*/ jsxRuntime.jsx(designSystem.Field.Error, {})
        ]
    });
};

exports.PluralName = PluralName;
//# sourceMappingURL=PluralName.js.map
