import { jsx, jsxs } from 'react/jsx-runtime';
import { useState } from 'react';
import { useSensors, useSensor, PointerSensor, KeyboardSensor, DndContext, closestCenter, DragOverlay } from '@dnd-kit/core';
import { restrictToVerticalAxis } from '@dnd-kit/modifiers';
import { sortableKeyboardCoordinates, SortableContext, verticalListSortingStrategy, useSortable } from '@dnd-kit/sortable';
import { CSS } from '@dnd-kit/utilities';
import { tours } from '@strapi/admin/strapi-admin';
import { Box, EmptyStateLayout, Button } from '@strapi/design-system';
import { Plus } from '@strapi/icons';
import { EmptyDocuments } from '@strapi/icons/symbols';
import { createPortal } from 'react-dom';
import { useIntl } from 'react-intl';
import { styled } from 'styled-components';
import { getTrad } from '../utils/getTrad.mjs';
import { AttributeRow } from './AttributeRow.mjs';
import './CTBSession/sessionContext.mjs';
import { useCTBTracking } from './CTBSession/useCTBTracking.mjs';
import { useDataManager } from './DataManager/useDataManager.mjs';
import { TFooter, NestedTFooter } from './Footers.mjs';
import { useFormModalNavigation } from './FormModalNavigation/useFormModalNavigation.mjs';

const ListGrid = styled(Box)`
  white-space: nowrap;
  list-style: none;
  list-style-type: none;
`;
const SortableRow = (props)=>{
    const { isInDevelopmentMode } = useDataManager();
    const { isDragging, attributes, listeners, setNodeRef, transform, transition, setActivatorNodeRef } = useSortable({
        disabled: !isInDevelopmentMode || props.item.status === 'REMOVED' || props.type.status === 'REMOVED',
        id: props.item.id,
        data: {
            index: props.item.index
        }
    });
    const style = {
        transform: CSS.Transform.toString({
            x: transform?.x ?? 0,
            y: transform?.y ?? 0,
            scaleX: 1,
            scaleY: 1
        }),
        transition
    };
    return /*#__PURE__*/ jsx(AttributeRow, {
        ref: setNodeRef,
        handleRef: setActivatorNodeRef,
        isDragging: isDragging,
        attributes: attributes,
        listeners: listeners,
        style: style,
        ...props
    });
};
const List = ({ addComponentToDZ, firstLoopComponentUid, isFromDynamicZone = false, isMain = false, isSub = false, secondLoopComponentUid, type })=>{
    const { formatMessage } = useIntl();
    const { trackUsage } = useCTBTracking();
    const { isInDevelopmentMode, moveAttribute } = useDataManager();
    const { onOpenModalAddField } = useFormModalNavigation();
    const items = type?.attributes.map((item, index)=>{
        return {
            id: `${type.uid}_${item.name}`,
            index,
            ...item
        };
    });
    const [activeId, setActiveId] = useState(null);
    const isDeleted = type?.status === 'REMOVED';
    const sensors = useSensors(useSensor(PointerSensor), useSensor(KeyboardSensor, {
        coordinateGetter: sortableKeyboardCoordinates
    }));
    function handlerDragStart({ active }) {
        if (!active) {
            return;
        }
        setActiveId(active.id);
    }
    function handleDragEnd(event) {
        const { active, over } = event;
        setActiveId(null);
        if (over) {
            if (active.id !== over.id) {
                moveAttribute({
                    forTarget: type.modelType,
                    targetUid: type.uid,
                    from: active.data.current.index,
                    to: over.data.current.index
                });
            }
        }
    }
    const activeItem = items.find((item)=>item.id === activeId);
    const onClickAddField = ()=>{
        if (isDeleted) {
            return;
        }
        trackUsage('hasClickedCTBAddFieldBanner');
        onOpenModalAddField({
            forTarget: type?.modelType,
            targetUid: type.uid
        });
    };
    if (type?.attributes.length === 0 && isMain) {
        return /*#__PURE__*/ jsx(EmptyStateLayout, {
            action: /*#__PURE__*/ jsx(tours.contentTypeBuilder.AddFields, {
                children: /*#__PURE__*/ jsx(Button, {
                    onClick: onClickAddField,
                    size: "L",
                    startIcon: /*#__PURE__*/ jsx(Plus, {}),
                    variant: "secondary",
                    children: formatMessage({
                        id: getTrad('table.button.no-fields'),
                        defaultMessage: 'Add new field'
                    })
                })
            }),
            content: formatMessage(type.modelType === 'contentType' ? {
                id: getTrad('table.content.no-fields.collection-type'),
                defaultMessage: 'Add your first field to this Collection-Type'
            } : {
                id: getTrad('table.content.no-fields.component'),
                defaultMessage: 'Add your first field to this component'
            }),
            hasRadius: true,
            icon: /*#__PURE__*/ jsx(EmptyDocuments, {
                width: "16rem"
            })
        });
    }
    return /*#__PURE__*/ jsxs(DndContext, {
        sensors: sensors,
        collisionDetection: closestCenter,
        onDragEnd: handleDragEnd,
        onDragStart: handlerDragStart,
        onDragCancel: ()=>setActiveId(null),
        modifiers: [
            restrictToVerticalAxis
        ],
        children: [
            /*#__PURE__*/ jsxs(ListGrid, {
                tag: "ul",
                children: [
                    /*#__PURE__*/ createPortal(/*#__PURE__*/ jsx(DragOverlay, {
                        zIndex: 10,
                        children: activeItem && /*#__PURE__*/ jsx(AttributeRow, {
                            isOverlay: true,
                            item: activeItem,
                            firstLoopComponentUid: firstLoopComponentUid,
                            isFromDynamicZone: isFromDynamicZone,
                            secondLoopComponentUid: secondLoopComponentUid,
                            type: type,
                            addComponentToDZ: addComponentToDZ
                        })
                    }), document.body),
                    /*#__PURE__*/ jsx(SortableContext, {
                        items: items,
                        strategy: verticalListSortingStrategy,
                        children: items.map((item)=>{
                            return /*#__PURE__*/ jsx(SortableRow, {
                                item: item,
                                firstLoopComponentUid: firstLoopComponentUid,
                                isFromDynamicZone: isFromDynamicZone,
                                secondLoopComponentUid: secondLoopComponentUid,
                                type: type,
                                addComponentToDZ: addComponentToDZ
                            }, item.id);
                        })
                    })
                ]
            }),
            isMain && isInDevelopmentMode && /*#__PURE__*/ jsx(TFooter, {
                cursor: isDeleted ? 'normal' : 'pointer',
                icon: /*#__PURE__*/ jsx(Plus, {}),
                onClick: onClickAddField,
                color: isDeleted ? 'neutral' : 'primary',
                children: formatMessage({
                    id: getTrad(`form.button.add.field.to.${type.modelType === 'component' ? 'component' : type.kind}`),
                    defaultMessage: 'Add another field'
                })
            }),
            isSub && isInDevelopmentMode && /*#__PURE__*/ jsx(NestedTFooter, {
                cursor: isDeleted ? 'normal' : 'pointer',
                icon: /*#__PURE__*/ jsx(Plus, {}),
                onClick: onClickAddField,
                color: isFromDynamicZone && !isDeleted ? 'primary' : 'neutral',
                children: formatMessage({
                    id: getTrad(`form.button.add.field.to.component`),
                    defaultMessage: 'Add another field'
                })
            })
        ]
    });
};

export { List, ListGrid };
//# sourceMappingURL=List.mjs.map
