'use strict';

var jsxRuntime = require('react/jsx-runtime');
var React = require('react');
var core = require('@dnd-kit/core');
var modifiers = require('@dnd-kit/modifiers');
var sortable = require('@dnd-kit/sortable');
var utilities = require('@dnd-kit/utilities');
var strapiAdmin = require('@strapi/admin/strapi-admin');
var designSystem = require('@strapi/design-system');
var Icons = require('@strapi/icons');
var Symbols = require('@strapi/icons/symbols');
var reactDom = require('react-dom');
var reactIntl = require('react-intl');
var styledComponents = require('styled-components');
var getTrad = require('../utils/getTrad.js');
var AttributeRow = require('./AttributeRow.js');
require('./CTBSession/sessionContext.js');
var useCTBTracking = require('./CTBSession/useCTBTracking.js');
var useDataManager = require('./DataManager/useDataManager.js');
var Footers = require('./Footers.js');
var useFormModalNavigation = require('./FormModalNavigation/useFormModalNavigation.js');

const ListGrid = styledComponents.styled(designSystem.Box)`
  white-space: nowrap;
  list-style: none;
  list-style-type: none;
`;
const SortableRow = (props)=>{
    const { isInDevelopmentMode } = useDataManager.useDataManager();
    const { isDragging, attributes, listeners, setNodeRef, transform, transition, setActivatorNodeRef } = sortable.useSortable({
        disabled: !isInDevelopmentMode || props.item.status === 'REMOVED' || props.type.status === 'REMOVED',
        id: props.item.id,
        data: {
            index: props.item.index
        }
    });
    const style = {
        transform: utilities.CSS.Transform.toString({
            x: transform?.x ?? 0,
            y: transform?.y ?? 0,
            scaleX: 1,
            scaleY: 1
        }),
        transition
    };
    return /*#__PURE__*/ jsxRuntime.jsx(AttributeRow.AttributeRow, {
        ref: setNodeRef,
        handleRef: setActivatorNodeRef,
        isDragging: isDragging,
        attributes: attributes,
        listeners: listeners,
        style: style,
        ...props
    });
};
const List = ({ addComponentToDZ, firstLoopComponentUid, isFromDynamicZone = false, isMain = false, isSub = false, secondLoopComponentUid, type })=>{
    const { formatMessage } = reactIntl.useIntl();
    const { trackUsage } = useCTBTracking.useCTBTracking();
    const { isInDevelopmentMode, moveAttribute } = useDataManager.useDataManager();
    const { onOpenModalAddField } = useFormModalNavigation.useFormModalNavigation();
    const items = type?.attributes.map((item, index)=>{
        return {
            id: `${type.uid}_${item.name}`,
            index,
            ...item
        };
    });
    const [activeId, setActiveId] = React.useState(null);
    const isDeleted = type?.status === 'REMOVED';
    const sensors = core.useSensors(core.useSensor(core.PointerSensor), core.useSensor(core.KeyboardSensor, {
        coordinateGetter: sortable.sortableKeyboardCoordinates
    }));
    function handlerDragStart({ active }) {
        if (!active) {
            return;
        }
        setActiveId(active.id);
    }
    function handleDragEnd(event) {
        const { active, over } = event;
        setActiveId(null);
        if (over) {
            if (active.id !== over.id) {
                moveAttribute({
                    forTarget: type.modelType,
                    targetUid: type.uid,
                    from: active.data.current.index,
                    to: over.data.current.index
                });
            }
        }
    }
    const activeItem = items.find((item)=>item.id === activeId);
    const onClickAddField = ()=>{
        if (isDeleted) {
            return;
        }
        trackUsage('hasClickedCTBAddFieldBanner');
        onOpenModalAddField({
            forTarget: type?.modelType,
            targetUid: type.uid
        });
    };
    if (type?.attributes.length === 0 && isMain) {
        return /*#__PURE__*/ jsxRuntime.jsx(designSystem.EmptyStateLayout, {
            action: /*#__PURE__*/ jsxRuntime.jsx(strapiAdmin.tours.contentTypeBuilder.AddFields, {
                children: /*#__PURE__*/ jsxRuntime.jsx(designSystem.Button, {
                    onClick: onClickAddField,
                    size: "L",
                    startIcon: /*#__PURE__*/ jsxRuntime.jsx(Icons.Plus, {}),
                    variant: "secondary",
                    children: formatMessage({
                        id: getTrad.getTrad('table.button.no-fields'),
                        defaultMessage: 'Add new field'
                    })
                })
            }),
            content: formatMessage(type.modelType === 'contentType' ? {
                id: getTrad.getTrad('table.content.no-fields.collection-type'),
                defaultMessage: 'Add your first field to this Collection-Type'
            } : {
                id: getTrad.getTrad('table.content.no-fields.component'),
                defaultMessage: 'Add your first field to this component'
            }),
            hasRadius: true,
            icon: /*#__PURE__*/ jsxRuntime.jsx(Symbols.EmptyDocuments, {
                width: "16rem"
            })
        });
    }
    return /*#__PURE__*/ jsxRuntime.jsxs(core.DndContext, {
        sensors: sensors,
        collisionDetection: core.closestCenter,
        onDragEnd: handleDragEnd,
        onDragStart: handlerDragStart,
        onDragCancel: ()=>setActiveId(null),
        modifiers: [
            modifiers.restrictToVerticalAxis
        ],
        children: [
            /*#__PURE__*/ jsxRuntime.jsxs(ListGrid, {
                tag: "ul",
                children: [
                    /*#__PURE__*/ reactDom.createPortal(/*#__PURE__*/ jsxRuntime.jsx(core.DragOverlay, {
                        zIndex: 10,
                        children: activeItem && /*#__PURE__*/ jsxRuntime.jsx(AttributeRow.AttributeRow, {
                            isOverlay: true,
                            item: activeItem,
                            firstLoopComponentUid: firstLoopComponentUid,
                            isFromDynamicZone: isFromDynamicZone,
                            secondLoopComponentUid: secondLoopComponentUid,
                            type: type,
                            addComponentToDZ: addComponentToDZ
                        })
                    }), document.body),
                    /*#__PURE__*/ jsxRuntime.jsx(sortable.SortableContext, {
                        items: items,
                        strategy: sortable.verticalListSortingStrategy,
                        children: items.map((item)=>{
                            return /*#__PURE__*/ jsxRuntime.jsx(SortableRow, {
                                item: item,
                                firstLoopComponentUid: firstLoopComponentUid,
                                isFromDynamicZone: isFromDynamicZone,
                                secondLoopComponentUid: secondLoopComponentUid,
                                type: type,
                                addComponentToDZ: addComponentToDZ
                            }, item.id);
                        })
                    })
                ]
            }),
            isMain && isInDevelopmentMode && /*#__PURE__*/ jsxRuntime.jsx(Footers.TFooter, {
                cursor: isDeleted ? 'normal' : 'pointer',
                icon: /*#__PURE__*/ jsxRuntime.jsx(Icons.Plus, {}),
                onClick: onClickAddField,
                color: isDeleted ? 'neutral' : 'primary',
                children: formatMessage({
                    id: getTrad.getTrad(`form.button.add.field.to.${type.modelType === 'component' ? 'component' : type.kind}`),
                    defaultMessage: 'Add another field'
                })
            }),
            isSub && isInDevelopmentMode && /*#__PURE__*/ jsxRuntime.jsx(Footers.NestedTFooter, {
                cursor: isDeleted ? 'normal' : 'pointer',
                icon: /*#__PURE__*/ jsxRuntime.jsx(Icons.Plus, {}),
                onClick: onClickAddField,
                color: isFromDynamicZone && !isDeleted ? 'primary' : 'neutral',
                children: formatMessage({
                    id: getTrad.getTrad(`form.button.add.field.to.component`),
                    defaultMessage: 'Add another field'
                })
            })
        ]
    });
};

exports.List = List;
exports.ListGrid = ListGrid;
//# sourceMappingURL=List.js.map
