import get from 'lodash/get';
import { makeUnique } from '../../../utils/makeUnique.mjs';

const retrieveSpecificInfoFromComponents = (allComponents, keysToRetrieve)=>{
    const allData = Object.keys(allComponents).map((compo)=>{
        return get(allComponents, [
            compo,
            ...keysToRetrieve
        ], '');
    });
    return makeUnique(allData);
};

export { retrieveSpecificInfoFromComponents };
//# sourceMappingURL=retrieveSpecificInfoFromComponents.mjs.map
