import { useState } from 'react';
import { useNotification } from '@strapi/admin/strapi-admin';
import 'react/jsx-runtime';
import '../../CTBSession/sessionContext.mjs';
import { useCTBTracking } from '../../CTBSession/useCTBTracking.mjs';
import { useStrapiChat } from '../providers/ChatProvider.mjs';
import { useFetchSendFeedback } from './useAIFetch.mjs';
import { useTranslations } from './useTranslations.mjs';

const useFeedback = ()=>{
    const { fetch: sendFeedback, isPending, error } = useFetchSendFeedback();
    const { id, messages, schemas } = useStrapiChat();
    const { toggleNotification } = useNotification();
    const { trackUsage } = useCTBTracking();
    const { t } = useTranslations();
    // Keep track of messages that have received feedback
    const [votedMessages, setVotedMessages] = useState({});
    const hasVoted = (messageId)=>{
        return !!votedMessages[messageId];
    };
    const upvoteMessage = (messageId)=>{
        // Prevent spamming upvote
        if (hasVoted(messageId)) {
            return Promise.resolve();
        }
        trackUsage('didVoteAnswer', {
            value: 'positive'
        });
        toggleNotification({
            type: 'success',
            message: t('chat.feedback.submitted', 'Thank you for your feedback! ')
        });
        // Record this message as upvoted
        setVotedMessages((prev)=>({
                ...prev,
                [messageId]: 'upvote'
            }));
        return sendFeedback({
            body: {
                type: 'upvote',
                chatId: id,
                messageId,
                messages,
                schemas
            }
        });
    };
    const downvoteMessage = (messageId, feedback, reasons)=>{
        trackUsage('didVoteAnswer', {
            value: 'negative'
        });
        toggleNotification({
            type: 'success',
            message: t('chat.feedback.submitted', 'Thank you for your feedback! ')
        });
        return sendFeedback({
            body: {
                type: 'downvote',
                chatId: id,
                messageId,
                messages,
                feedback,
                reasons,
                schemas
            }
        });
    };
    return {
        upvoteMessage,
        downvoteMessage,
        isPending,
        error
    };
};

export { useFeedback };
//# sourceMappingURL=useFeedback.mjs.map
