'use strict';

var React = require('react');
var strapiAdmin = require('@strapi/admin/strapi-admin');
require('react/jsx-runtime');
require('../../CTBSession/sessionContext.js');
var useCTBTracking = require('../../CTBSession/useCTBTracking.js');
var ChatProvider = require('../providers/ChatProvider.js');
var useAIFetch = require('./useAIFetch.js');
var useTranslations = require('./useTranslations.js');

const useFeedback = ()=>{
    const { fetch: sendFeedback, isPending, error } = useAIFetch.useFetchSendFeedback();
    const { id, messages, schemas } = ChatProvider.useStrapiChat();
    const { toggleNotification } = strapiAdmin.useNotification();
    const { trackUsage } = useCTBTracking.useCTBTracking();
    const { t } = useTranslations.useTranslations();
    // Keep track of messages that have received feedback
    const [votedMessages, setVotedMessages] = React.useState({});
    const hasVoted = (messageId)=>{
        return !!votedMessages[messageId];
    };
    const upvoteMessage = (messageId)=>{
        // Prevent spamming upvote
        if (hasVoted(messageId)) {
            return Promise.resolve();
        }
        trackUsage('didVoteAnswer', {
            value: 'positive'
        });
        toggleNotification({
            type: 'success',
            message: t('chat.feedback.submitted', 'Thank you for your feedback! ')
        });
        // Record this message as upvoted
        setVotedMessages((prev)=>({
                ...prev,
                [messageId]: 'upvote'
            }));
        return sendFeedback({
            body: {
                type: 'upvote',
                chatId: id,
                messageId,
                messages,
                schemas
            }
        });
    };
    const downvoteMessage = (messageId, feedback, reasons)=>{
        trackUsage('didVoteAnswer', {
            value: 'negative'
        });
        toggleNotification({
            type: 'success',
            message: t('chat.feedback.submitted', 'Thank you for your feedback! ')
        });
        return sendFeedback({
            body: {
                type: 'downvote',
                chatId: id,
                messageId,
                messages,
                feedback,
                reasons,
                schemas
            }
        });
    };
    return {
        upvoteMessage,
        downvoteMessage,
        isPending,
        error
    };
};

exports.useFeedback = useFeedback;
//# sourceMappingURL=useFeedback.js.map
