import type { PageEvent, RendererHooks } from "../..";
import { CommentDisplayPart, DeclarationReflection, Reflection } from "../../../models";
import { JSX, NeverIfInternal, Options } from "../../../utils";
import type { DefaultTheme } from "./DefaultTheme";
import { icons } from "./partials/icon";
export declare class DefaultThemeRenderContext {
    private theme;
    page: PageEvent<Reflection>;
    private _refIcons;
    options: Options;
    constructor(theme: DefaultTheme, page: PageEvent<Reflection>, options: Options);
    /**
     * @deprecated Will be removed in 0.26, no longer required.
     */
    iconsCache(): JSX.Element;
    /**
     * Icons available for use within the page.
     *
     * Note: This creates a reference to icons declared by {@link DefaultTheme.icons},
     * to customize icons, that object must be modified instead.
     */
    get icons(): Readonly<typeof icons>;
    hook: (name: keyof RendererHooks) => JSX.Element[];
    /** Avoid this in favor of urlTo if possible */
    relativeURL: (url: string, cacheBust?: boolean) => string;
    urlTo: (reflection: Reflection) => string;
    markdown: (md: readonly CommentDisplayPart[] | NeverIfInternal<string | undefined>) => string;
    getNavigation: () => import("./DefaultTheme").NavigationElement[];
    getReflectionClasses: (refl: DeclarationReflection) => string;
    reflectionTemplate: (props: PageEvent<import("../../../models").ContainerReflection>) => JSX.Element;
    indexTemplate: (props: PageEvent<import("../../../models").ProjectReflection>) => JSX.Element;
    hierarchyTemplate: (props: PageEvent<import("../../../models").ProjectReflection>) => JSX.Element;
    defaultLayout: (template: import("../..").RenderTemplate<PageEvent<Reflection>>, props: PageEvent<Reflection>) => JSX.Element;
    /**
     * Rendered just after the description for a reflection.
     * This can be used to render a shortened type display of a reflection that the
     * rest of the page expands on.
     *
     * Note: Will not be called for variables/type aliases, as they are summarized
     * by their type declaration, which is already rendered by {@link DefaultThemeRenderContext.memberDeclaration}
     */
    reflectionPreview: (props: Reflection) => JSX.Element | undefined;
    analytics: () => JSX.Element | undefined;
    breadcrumb: (props: Reflection) => JSX.Element | undefined;
    commentSummary: (props: Reflection) => JSX.Element | undefined;
    commentTags: (props: Reflection) => JSX.Element | undefined;
    reflectionFlags: (props: Reflection) => JSX.Element;
    footer: () => JSX.Element | undefined;
    header: (props: PageEvent<Reflection>) => JSX.Element;
    hierarchy: (props: import("../../../models").DeclarationHierarchy | undefined) => JSX.Element | undefined;
    index: (props: import("../../../models").ContainerReflection) => JSX.Element;
    member: (props: DeclarationReflection) => JSX.Element;
    memberDeclaration: (props: DeclarationReflection) => JSX.Element;
    memberGetterSetter: (props: DeclarationReflection) => JSX.Element;
    memberReference: (props: import("../../../models").ReferenceReflection) => JSX.Element;
    memberSignatureBody: (props: import("../../../models").SignatureReflection, r_1?: {
        hideSources?: boolean | undefined;
    } | undefined) => JSX.Element;
    memberSignatureTitle: (props: import("../../../models").SignatureReflection, r_1?: {
        hideName?: boolean | undefined;
        arrowStyle?: boolean | undefined;
    } | undefined) => JSX.Element;
    memberSignatures: (props: DeclarationReflection) => JSX.Element;
    memberSources: (props: import("../../../models").SignatureReflection | DeclarationReflection) => JSX.Element;
    members: (props: import("../../../models").ContainerReflection) => JSX.Element;
    membersGroup: (group: import("../../../models").ReflectionGroup) => JSX.Element;
    sidebar: (props: PageEvent<Reflection>) => JSX.Element;
    pageSidebar: (props: PageEvent<Reflection>) => JSX.Element;
    sidebarLinks: () => JSX.Element | null;
    settings: () => JSX.Element;
    navigation: (props: PageEvent<Reflection>) => JSX.Element;
    pageNavigation: (props: PageEvent<Reflection>) => JSX.Element;
    parameter: (props: DeclarationReflection) => JSX.Element;
    toolbar: (props: PageEvent<Reflection>) => JSX.Element;
    type: (type: import("../../../models").Type | undefined, options?: {
        topLevelLinks: boolean;
    } | undefined) => JSX.Element;
    typeAndParent: (props: import("../../../models").Type) => JSX.Element;
    typeParameters: (typeParameters: import("../../../models").TypeParameterReflection[]) => JSX.Element;
}
