"use strict";
var __esDecorate = (this && this.__esDecorate) || function (ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};
var __runInitializers = (this && this.__runInitializers) || function (thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};
var __setFunctionName = (this && this.__setFunctionName) || function (f, name, prefix) {
    if (typeof name === "symbol") name = name.description ? "[".concat(name.description, "]") : "";
    return Object.defineProperty(f, "name", { configurable: true, value: prefix ? "".concat(prefix, " ", name) : name });
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CommentPlugin = void 0;
const components_1 = require("../components");
const converter_1 = require("../converter");
const models_1 = require("../../models");
const utils_1 = require("../../utils");
const CategoryPlugin_1 = require("./CategoryPlugin");
/**
 * These tags are not useful to display in the generated documentation.
 * They should be ignored when parsing comments. Any relevant type information
 * (for JS users) will be consumed by TypeScript and need not be preserved
 * in the comment.
 *
 * Note that param/arg/argument/return/returns are not present.
 * These tags will have their type information stripped when parsing, but still
 * provide useful information for documentation.
 */
const NEVER_RENDERED = [
    "@augments",
    "@callback",
    "@class",
    "@constructor",
    "@enum",
    "@extends",
    "@this",
    "@type",
    "@typedef",
];
/**
 * Handles most behavior triggered by comments. `@group` and `@category` are handled by their respective plugins, but everything else is here.
 *
 * How it works today
 * ==================
 * During conversion:
 * - Handle visibility flags (`@private`, `@protected`. `@public`)
 * - Handle module renames (`@module`)
 * - Remove excluded tags & comment discovery tags (`@module`, `@packageDocumentation`)
 * - Copy comments for type parameters from the parent container (for classes/interfaces)
 *
 * Resolve begin:
 * - Remove hidden reflections
 *
 * Resolve:
 * - Apply `@label` tag
 * - Copy comments on signature containers to the signature if signatures don't already have a comment
 *   and then remove the comment on the container.
 * - Copy comments to parameters and type parameters (for signatures)
 * - Apply `@group` and `@category` tags
 *
 * Resolve end:
 * - Copy auto inherited comments from heritage clauses
 * - Handle `@inheritDoc`
 * - Resolve `@link` tags to point to target reflections
 *
 * How it should work
 * ==================
 * During conversion:
 * - Handle visibility flags (`@private`, `@protected`. `@public`)
 * - Handle module renames (`@module`)
 * - Remove excluded tags & comment discovery tags (`@module`, `@packageDocumentation`)
 *
 * Resolve begin (100):
 * - Copy auto inherited comments from heritage clauses
 * - Apply `@label` tag
 *
 * Resolve begin (75)
 * - Handle `@inheritDoc`
 *
 * Resolve begin (50)
 * - Copy comments on signature containers to the signature if signatures don't already have a comment
 *   and then remove the comment on the container.
 * - Copy comments for type parameters from the parent container (for classes/interfaces)
 *
 * Resolve begin (25)
 * - Remove hidden reflections
 *
 * Resolve:
 * - Copy comments to parameters and type parameters (for signatures)
 * - Apply `@group` and `@category` tags
 *
 * Resolve end:
 * - Resolve `@link` tags to point to target reflections
 *
 */
let CommentPlugin = (() => {
    var _CommentPlugin_excludeTags_accessor_storage, _CommentPlugin_excludeInternal_accessor_storage, _CommentPlugin_excludePrivate_accessor_storage, _CommentPlugin_excludeProtected_accessor_storage, _CommentPlugin_excludeNotDocumented_accessor_storage, _CommentPlugin_excludeCategories_accessor_storage, _CommentPlugin_defaultCategory_accessor_storage;
    let _classDecorators = [(0, components_1.Component)({ name: "comment" })];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = components_1.ConverterComponent;
    let _instanceExtraInitializers = [];
    let _excludeTags_decorators;
    let _excludeTags_initializers = [];
    let _excludeInternal_decorators;
    let _excludeInternal_initializers = [];
    let _excludePrivate_decorators;
    let _excludePrivate_initializers = [];
    let _excludeProtected_decorators;
    let _excludeProtected_initializers = [];
    let _excludeNotDocumented_decorators;
    let _excludeNotDocumented_initializers = [];
    let _excludeCategories_decorators;
    let _excludeCategories_initializers = [];
    let _defaultCategory_decorators;
    let _defaultCategory_initializers = [];
    var CommentPlugin = _classThis = class extends _classSuper {
        constructor() {
            super(...arguments);
            _CommentPlugin_excludeTags_accessor_storage.set(this, (__runInitializers(this, _instanceExtraInitializers), __runInitializers(this, _excludeTags_initializers, void 0)));
            _CommentPlugin_excludeInternal_accessor_storage.set(this, __runInitializers(this, _excludeInternal_initializers, void 0));
            _CommentPlugin_excludePrivate_accessor_storage.set(this, __runInitializers(this, _excludePrivate_initializers, void 0));
            _CommentPlugin_excludeProtected_accessor_storage.set(this, __runInitializers(this, _excludeProtected_initializers, void 0));
            _CommentPlugin_excludeNotDocumented_accessor_storage.set(this, __runInitializers(this, _excludeNotDocumented_initializers, void 0));
            _CommentPlugin_excludeCategories_accessor_storage.set(this, __runInitializers(this, _excludeCategories_initializers, void 0));
            _CommentPlugin_defaultCategory_accessor_storage.set(this, __runInitializers(this, _defaultCategory_initializers, void 0));
        }
        get excludeTags() { return __classPrivateFieldGet(this, _CommentPlugin_excludeTags_accessor_storage, "f"); }
        set excludeTags(value) { __classPrivateFieldSet(this, _CommentPlugin_excludeTags_accessor_storage, value, "f"); }
        get excludeInternal() { return __classPrivateFieldGet(this, _CommentPlugin_excludeInternal_accessor_storage, "f"); }
        set excludeInternal(value) { __classPrivateFieldSet(this, _CommentPlugin_excludeInternal_accessor_storage, value, "f"); }
        get excludePrivate() { return __classPrivateFieldGet(this, _CommentPlugin_excludePrivate_accessor_storage, "f"); }
        set excludePrivate(value) { __classPrivateFieldSet(this, _CommentPlugin_excludePrivate_accessor_storage, value, "f"); }
        get excludeProtected() { return __classPrivateFieldGet(this, _CommentPlugin_excludeProtected_accessor_storage, "f"); }
        set excludeProtected(value) { __classPrivateFieldSet(this, _CommentPlugin_excludeProtected_accessor_storage, value, "f"); }
        get excludeNotDocumented() { return __classPrivateFieldGet(this, _CommentPlugin_excludeNotDocumented_accessor_storage, "f"); }
        set excludeNotDocumented(value) { __classPrivateFieldSet(this, _CommentPlugin_excludeNotDocumented_accessor_storage, value, "f"); }
        get excludeCategories() { return __classPrivateFieldGet(this, _CommentPlugin_excludeCategories_accessor_storage, "f"); }
        set excludeCategories(value) { __classPrivateFieldSet(this, _CommentPlugin_excludeCategories_accessor_storage, value, "f"); }
        get defaultCategory() { return __classPrivateFieldGet(this, _CommentPlugin_defaultCategory_accessor_storage, "f"); }
        set defaultCategory(value) { __classPrivateFieldSet(this, _CommentPlugin_defaultCategory_accessor_storage, value, "f"); }
        get excludeNotDocumentedKinds() {
            this._excludeKinds ??= this.application.options
                .getValue("excludeNotDocumentedKinds")
                .reduce((a, b) => a | models_1.ReflectionKind[b], 0);
            return this._excludeKinds;
        }
        /**
         * Create a new CommentPlugin instance.
         */
        initialize() {
            this.listenTo(this.owner, {
                [converter_1.Converter.EVENT_CREATE_DECLARATION]: this.onDeclaration,
                [converter_1.Converter.EVENT_CREATE_SIGNATURE]: this.onDeclaration,
                [converter_1.Converter.EVENT_CREATE_TYPE_PARAMETER]: this.onCreateTypeParameter,
                [converter_1.Converter.EVENT_RESOLVE_BEGIN]: this.onBeginResolve,
                [converter_1.Converter.EVENT_RESOLVE]: this.onResolve,
                [converter_1.Converter.EVENT_END]: () => {
                    this._excludeKinds = undefined;
                },
            });
        }
        /**
         * Apply all comment tag modifiers to the given reflection.
         *
         * @param reflection  The reflection the modifiers should be applied to.
         * @param comment  The comment that should be searched for modifiers.
         */
        applyModifiers(reflection, comment) {
            if (reflection.kindOf(models_1.ReflectionKind.SomeModule)) {
                comment.removeModifier("@namespace");
            }
            if (reflection.kindOf(models_1.ReflectionKind.Interface)) {
                comment.removeModifier("@interface");
            }
            if (comment.hasModifier("@private")) {
                reflection.setFlag(models_1.ReflectionFlag.Private);
                if (reflection.kindOf(models_1.ReflectionKind.CallSignature)) {
                    reflection.parent?.setFlag(models_1.ReflectionFlag.Private);
                }
                comment.removeModifier("@private");
            }
            if (comment.hasModifier("@protected")) {
                reflection.setFlag(models_1.ReflectionFlag.Protected);
                if (reflection.kindOf(models_1.ReflectionKind.CallSignature)) {
                    reflection.parent?.setFlag(models_1.ReflectionFlag.Protected);
                }
                comment.removeModifier("@protected");
            }
            if (comment.hasModifier("@public")) {
                reflection.setFlag(models_1.ReflectionFlag.Public);
                if (reflection.kindOf(models_1.ReflectionKind.CallSignature)) {
                    reflection.parent?.setFlag(models_1.ReflectionFlag.Public);
                }
                comment.removeModifier("@public");
            }
            if (comment.hasModifier("@readonly")) {
                const target = reflection.kindOf(models_1.ReflectionKind.GetSignature)
                    ? reflection.parent
                    : reflection;
                target.setFlag(models_1.ReflectionFlag.Readonly);
                comment.removeModifier("@readonly");
            }
            if (comment.hasModifier("@event") ||
                comment.hasModifier("@eventProperty")) {
                comment.blockTags.push(new models_1.CommentTag("@group", [{ kind: "text", text: "Events" }]));
                comment.removeModifier("@event");
                comment.removeModifier("@eventProperty");
            }
            if (reflection.kindOf(models_1.ReflectionKind.Module | models_1.ReflectionKind.Namespace) ||
                reflection.kind === models_1.ReflectionKind.Project) {
                comment.removeTags("@module");
                comment.removeModifier("@packageDocumentation");
            }
        }
        /**
         * Triggered when the converter has created a type parameter reflection.
         *
         * @param context  The context object describing the current state the converter is in.
         * @param reflection  The reflection that is currently processed.
         */
        onCreateTypeParameter(_context, reflection) {
            const comment = reflection.parent?.comment;
            if (comment) {
                let tag = comment.getIdentifiedTag(reflection.name, "@typeParam");
                if (!tag) {
                    tag = comment.getIdentifiedTag(reflection.name, "@template");
                }
                if (!tag) {
                    tag = comment.getIdentifiedTag(`<${reflection.name}>`, "@param");
                }
                if (!tag) {
                    tag = comment.getIdentifiedTag(reflection.name, "@param");
                }
                if (tag) {
                    reflection.comment = new models_1.Comment(tag.content);
                    (0, utils_1.removeIfPresent)(comment.blockTags, tag);
                }
            }
        }
        /**
         * Triggered when the converter has created a declaration or signature reflection.
         *
         * Invokes the comment parser.
         *
         * @param context  The context object describing the current state the converter is in.
         * @param reflection  The reflection that is currently processed.
         * @param node  The node that is currently processed if available.
         */
        onDeclaration(_context, reflection) {
            const comment = reflection.comment;
            if (!comment)
                return;
            if (reflection.kindOf(models_1.ReflectionKind.SomeModule)) {
                const tag = comment.getTag("@module");
                if (tag) {
                    // If no name is specified, this is a flag to mark a comment as a module comment
                    // and should not result in a reflection rename.
                    const newName = models_1.Comment.combineDisplayParts(tag.content).trim();
                    if (newName.length && !newName.includes("\n")) {
                        reflection.name = newName;
                    }
                    (0, utils_1.removeIfPresent)(comment.blockTags, tag);
                }
            }
            this.applyModifiers(reflection, comment);
            this.removeExcludedTags(comment);
        }
        /**
         * Triggered when the converter begins resolving a project.
         *
         * @param context  The context object describing the current state the converter is in.
         */
        onBeginResolve(context) {
            const project = context.project;
            const reflections = Object.values(project.reflections);
            // Remove hidden reflections
            const hidden = new Set();
            for (const ref of reflections) {
                if (ref.kindOf(models_1.ReflectionKind.Accessor) && ref.flags.isReadonly) {
                    const decl = ref;
                    if (decl.setSignature) {
                        hidden.add(decl.setSignature);
                    }
                    // Clear flag set by @readonly since it shouldn't be rendered.
                    ref.setFlag(models_1.ReflectionFlag.Readonly, false);
                }
                if (this.isHidden(ref)) {
                    hidden.add(ref);
                }
            }
            hidden.forEach((reflection) => project.removeReflection(reflection));
            // remove functions with empty signatures after their signatures have been removed
            const [allRemoved, someRemoved] = (0, utils_1.partition)((0, utils_1.unique)((0, utils_1.filterMap)(hidden, (reflection) => reflection.parent?.kindOf(models_1.ReflectionKind.SignatureContainer)
                ? reflection.parent
                : void 0)), (method) => method.getNonIndexSignatures().length === 0);
            allRemoved.forEach((reflection) => {
                project.removeReflection(reflection);
            });
            someRemoved.forEach((reflection) => {
                reflection.sources = reflection
                    .getNonIndexSignatures()
                    .flatMap((s) => s.sources ?? []);
            });
        }
        /**
         * Triggered when the converter resolves a reflection.
         *
         * Cleans up comment tags related to signatures like `@param` or `@returns`
         * and moves their data to the corresponding parameter reflections.
         *
         * This hook also copies over the comment of function implementations to their
         * signatures.
         *
         * @param context  The context object describing the current state the converter is in.
         * @param reflection  The reflection that is currently resolved.
         */
        onResolve(context, reflection) {
            if (reflection.comment) {
                if (reflection.comment.label &&
                    !/[A-Z_][A-Z0-9_]/.test(reflection.comment.label)) {
                    context.logger.warn(`The label "${reflection.comment.label}" for ${reflection.getFriendlyFullName()} cannot be referenced with a declaration reference. ` +
                        `Labels may only contain A-Z, 0-9, and _, and may not start with a number.`);
                }
                mergeSeeTags(reflection.comment);
                movePropertyTags(reflection.comment, reflection);
            }
            if (!(reflection instanceof models_1.DeclarationReflection)) {
                return;
            }
            if (reflection.type instanceof models_1.ReflectionType) {
                this.moveCommentToSignatures(reflection, reflection.type.declaration.getNonIndexSignatures());
            }
            else {
                this.moveCommentToSignatures(reflection, reflection.getNonIndexSignatures());
            }
        }
        moveCommentToSignatures(reflection, signatures) {
            if (!signatures.length) {
                return;
            }
            const comment = reflection.kindOf(models_1.ReflectionKind.ClassOrInterface)
                ? undefined
                : reflection.comment;
            for (const signature of signatures) {
                const signatureHadOwnComment = !!signature.comment;
                const childComment = (signature.comment ||= comment?.clone());
                if (!childComment)
                    continue;
                signature.parameters?.forEach((parameter, index) => {
                    if (parameter.name === "__namedParameters") {
                        const commentParams = childComment.blockTags.filter((tag) => tag.tag === "@param" && !tag.name?.includes("."));
                        if (signature.parameters?.length === commentParams.length &&
                            commentParams[index].name) {
                            parameter.name = commentParams[index].name;
                        }
                    }
                    const tag = childComment.getIdentifiedTag(parameter.name, "@param");
                    if (tag) {
                        parameter.comment = new models_1.Comment(models_1.Comment.cloneDisplayParts(tag.content));
                    }
                });
                for (const parameter of signature.typeParameters || []) {
                    const tag = childComment.getIdentifiedTag(parameter.name, "@typeParam") ||
                        childComment.getIdentifiedTag(parameter.name, "@template") ||
                        childComment.getIdentifiedTag(`<${parameter.name}>`, "@param");
                    if (tag) {
                        parameter.comment = new models_1.Comment(models_1.Comment.cloneDisplayParts(tag.content));
                    }
                }
                this.validateParamTags(signature, childComment, signature.parameters || [], signatureHadOwnComment);
                childComment?.removeTags("@param");
                childComment?.removeTags("@typeParam");
                childComment?.removeTags("@template");
            }
            // Since this reflection has signatures, we need to remove the comment from the non-primary
            // declaration location. For functions/methods/constructors, this means removing it from
            // the wrapping reflection. For type aliases, classes, and interfaces, this means removing
            // it from the contained signatures... if it's the same as what is on the signature.
            // This is important so that in type aliases we don't end up with a comment rendered twice.
            if (reflection.kindOf(models_1.ReflectionKind.SignatureContainer)) {
                delete reflection.comment;
            }
            else {
                reflection.comment?.removeTags("@param");
                reflection.comment?.removeTags("@typeParam");
                reflection.comment?.removeTags("@template");
                const parentComment = models_1.Comment.combineDisplayParts(reflection.comment?.summary);
                for (const sig of signatures) {
                    if (models_1.Comment.combineDisplayParts(sig.comment?.summary) ===
                        parentComment) {
                        delete sig.comment;
                    }
                }
            }
        }
        removeExcludedTags(comment) {
            for (const tag of NEVER_RENDERED) {
                comment.removeTags(tag);
                comment.removeModifier(tag);
            }
            for (const tag of this.excludeTags) {
                comment.removeTags(tag);
                comment.removeModifier(tag);
            }
        }
        /**
         * Determines whether or not a reflection has been hidden
         *
         * @param reflection Reflection to check if hidden
         */
        isHidden(reflection) {
            const comment = reflection.comment;
            if (reflection.flags.hasFlag(models_1.ReflectionFlag.Private) &&
                this.excludePrivate) {
                return true;
            }
            if (reflection.flags.hasFlag(models_1.ReflectionFlag.Protected) &&
                this.excludeProtected) {
                return true;
            }
            if (this.excludedByCategory(reflection)) {
                return true;
            }
            if (!comment) {
                // We haven't moved comments from the parent for signatures without a direct
                // comment, so don't exclude those due to not being documented.
                if (reflection.kindOf(models_1.ReflectionKind.CallSignature |
                    models_1.ReflectionKind.ConstructorSignature) &&
                    reflection.parent?.comment) {
                    return false;
                }
                if (this.excludeNotDocumented) {
                    // Don't let excludeNotDocumented remove parameters.
                    if (!(reflection instanceof models_1.DeclarationReflection) &&
                        !(reflection instanceof models_1.SignatureReflection)) {
                        return false;
                    }
                    if (!reflection.kindOf(this.excludeNotDocumentedKinds)) {
                        return false;
                    }
                    // excludeNotDocumented should hide a module only if it has no visible children
                    if (reflection.kindOf(models_1.ReflectionKind.SomeModule)) {
                        if (!reflection.children) {
                            return true;
                        }
                        return reflection.children.every((child) => this.isHidden(child));
                    }
                    // signature containers should only be hidden if all their signatures are hidden
                    if (reflection.kindOf(models_1.ReflectionKind.SignatureContainer)) {
                        return reflection
                            .getAllSignatures()
                            .every((child) => this.isHidden(child));
                    }
                    // excludeNotDocumented should never hide parts of "type" reflections
                    return inTypeLiteral(reflection) === false;
                }
                return false;
            }
            const isHidden = comment.hasModifier("@hidden") ||
                comment.hasModifier("@ignore") ||
                (comment.hasModifier("@internal") && this.excludeInternal);
            if (isHidden &&
                reflection.kindOf(models_1.ReflectionKind.ContainsCallSignatures)) {
                return reflection
                    .getNonIndexSignatures()
                    .every((sig) => {
                    return !sig.comment || this.isHidden(sig);
                });
            }
            return isHidden;
        }
        excludedByCategory(reflection) {
            const excludeCategories = this.excludeCategories;
            let target;
            if (reflection instanceof models_1.DeclarationReflection) {
                target = reflection;
            }
            else if (reflection instanceof models_1.SignatureReflection) {
                target = reflection.parent;
            }
            if (!target || !excludeCategories.length)
                return false;
            const categories = CategoryPlugin_1.CategoryPlugin.getCategories(target);
            if (categories.size === 0) {
                categories.add(this.defaultCategory);
            }
            return excludeCategories.some((cat) => categories.has(cat));
        }
        validateParamTags(signature, comment, params, signatureHadOwnComment) {
            const paramTags = comment.blockTags.filter((tag) => tag.tag === "@param");
            (0, utils_1.removeIf)(paramTags, (tag) => params.some((param) => param.name === tag.name));
            moveNestedParamTags(/* in-out */ paramTags, params);
            if (signatureHadOwnComment && paramTags.length) {
                for (const tag of paramTags) {
                    this.application.logger.warn(`The signature ${signature.getFriendlyFullName()} has an @param with name "${tag.name}", which was not used.`);
                }
            }
        }
    };
    _CommentPlugin_excludeTags_accessor_storage = new WeakMap();
    _CommentPlugin_excludeInternal_accessor_storage = new WeakMap();
    _CommentPlugin_excludePrivate_accessor_storage = new WeakMap();
    _CommentPlugin_excludeProtected_accessor_storage = new WeakMap();
    _CommentPlugin_excludeNotDocumented_accessor_storage = new WeakMap();
    _CommentPlugin_excludeCategories_accessor_storage = new WeakMap();
    _CommentPlugin_defaultCategory_accessor_storage = new WeakMap();
    __setFunctionName(_classThis, "CommentPlugin");
    (() => {
        const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
        _excludeTags_decorators = [(0, utils_1.Option)("excludeTags")];
        _excludeInternal_decorators = [(0, utils_1.Option)("excludeInternal")];
        _excludePrivate_decorators = [(0, utils_1.Option)("excludePrivate")];
        _excludeProtected_decorators = [(0, utils_1.Option)("excludeProtected")];
        _excludeNotDocumented_decorators = [(0, utils_1.Option)("excludeNotDocumented")];
        _excludeCategories_decorators = [(0, utils_1.Option)("excludeCategories")];
        _defaultCategory_decorators = [(0, utils_1.Option)("defaultCategory")];
        __esDecorate(_classThis, null, _excludeTags_decorators, { kind: "accessor", name: "excludeTags", static: false, private: false, access: { has: obj => "excludeTags" in obj, get: obj => obj.excludeTags, set: (obj, value) => { obj.excludeTags = value; } }, metadata: _metadata }, _excludeTags_initializers, _instanceExtraInitializers);
        __esDecorate(_classThis, null, _excludeInternal_decorators, { kind: "accessor", name: "excludeInternal", static: false, private: false, access: { has: obj => "excludeInternal" in obj, get: obj => obj.excludeInternal, set: (obj, value) => { obj.excludeInternal = value; } }, metadata: _metadata }, _excludeInternal_initializers, _instanceExtraInitializers);
        __esDecorate(_classThis, null, _excludePrivate_decorators, { kind: "accessor", name: "excludePrivate", static: false, private: false, access: { has: obj => "excludePrivate" in obj, get: obj => obj.excludePrivate, set: (obj, value) => { obj.excludePrivate = value; } }, metadata: _metadata }, _excludePrivate_initializers, _instanceExtraInitializers);
        __esDecorate(_classThis, null, _excludeProtected_decorators, { kind: "accessor", name: "excludeProtected", static: false, private: false, access: { has: obj => "excludeProtected" in obj, get: obj => obj.excludeProtected, set: (obj, value) => { obj.excludeProtected = value; } }, metadata: _metadata }, _excludeProtected_initializers, _instanceExtraInitializers);
        __esDecorate(_classThis, null, _excludeNotDocumented_decorators, { kind: "accessor", name: "excludeNotDocumented", static: false, private: false, access: { has: obj => "excludeNotDocumented" in obj, get: obj => obj.excludeNotDocumented, set: (obj, value) => { obj.excludeNotDocumented = value; } }, metadata: _metadata }, _excludeNotDocumented_initializers, _instanceExtraInitializers);
        __esDecorate(_classThis, null, _excludeCategories_decorators, { kind: "accessor", name: "excludeCategories", static: false, private: false, access: { has: obj => "excludeCategories" in obj, get: obj => obj.excludeCategories, set: (obj, value) => { obj.excludeCategories = value; } }, metadata: _metadata }, _excludeCategories_initializers, _instanceExtraInitializers);
        __esDecorate(_classThis, null, _defaultCategory_decorators, { kind: "accessor", name: "defaultCategory", static: false, private: false, access: { has: obj => "defaultCategory" in obj, get: obj => obj.defaultCategory, set: (obj, value) => { obj.defaultCategory = value; } }, metadata: _metadata }, _defaultCategory_initializers, _instanceExtraInitializers);
        __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
        CommentPlugin = _classThis = _classDescriptor.value;
        if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
        __runInitializers(_classThis, _classExtraInitializers);
    })();
    return CommentPlugin = _classThis;
})();
exports.CommentPlugin = CommentPlugin;
function inTypeLiteral(refl) {
    while (refl) {
        if (refl.kind === models_1.ReflectionKind.TypeLiteral) {
            return true;
        }
        refl = refl.parent;
    }
    return false;
}
// Moves tags like `@param foo.bar docs for bar` into the `bar` property of the `foo` parameter.
function moveNestedParamTags(
/* in-out */ paramTags, parameters) {
    const used = new Set();
    for (const param of parameters) {
        const visitor = {
            reflection(target) {
                const tags = paramTags.filter((t) => t.name?.startsWith(`${param.name}.`));
                for (const tag of tags) {
                    const path = tag.name.split(".");
                    path.shift();
                    const child = target.declaration.getChildByName(path);
                    if (child && !child.comment) {
                        child.comment = new models_1.Comment(models_1.Comment.cloneDisplayParts(tag.content));
                        used.add(paramTags.indexOf(tag));
                    }
                }
            },
            // #1876, also do this for unions/intersections.
            union(u) {
                u.types.forEach((t) => t.visit(visitor));
            },
            intersection(i) {
                i.types.forEach((t) => t.visit(visitor));
            },
        };
        param.type?.visit(visitor);
    }
    const toRemove = Array.from(used)
        .sort((a, b) => a - b)
        .reverse();
    for (const index of toRemove) {
        paramTags.splice(index, 1);
    }
}
function movePropertyTags(comment, container) {
    const propTags = comment.blockTags.filter((tag) => tag.tag === "@prop" || tag.tag === "@property");
    comment.removeTags("@prop");
    comment.removeTags("@property");
    for (const prop of propTags) {
        if (!prop.name)
            continue;
        const child = container.getChildByName(prop.name);
        if (child) {
            child.comment = new models_1.Comment(models_1.Comment.cloneDisplayParts(prop.content));
            if (child instanceof models_1.DeclarationReflection && child.signatures) {
                for (const sig of child.signatures) {
                    sig.comment = new models_1.Comment(models_1.Comment.cloneDisplayParts(prop.content));
                }
            }
        }
    }
}
function mergeSeeTags(comment) {
    const see = comment.getTags("@see");
    if (see.length < 2)
        return;
    const index = comment.blockTags.indexOf(see[0]);
    comment.removeTags("@see");
    see[0].content = see.flatMap((part) => [
        { kind: "text", text: " - " },
        ...part.content,
        { kind: "text", text: "\n" },
    ]);
    comment.blockTags.splice(index, 0, see[0]);
}
