import { PaperPlane } from '@strapi/icons';
import { ReleaseAction } from './components/ReleaseAction.mjs';
import { ReleaseActionModalForm } from './components/ReleaseActionModal.mjs';
import { addColumnToTableHook } from './components/ReleaseListCell.mjs';
import { Panel } from './components/ReleasesPanel.mjs';
import { PERMISSIONS, PLUGIN_ID } from './constants.mjs';
import { pluginId } from './pluginId.mjs';
import { prefixPluginTranslations } from './utils/prefixPluginTranslations.mjs';

function __variableDynamicImportRuntime4__(path) {
  switch (path) {
    case './translations/en.json': return import('./translations/en.json.mjs');
    case './translations/uk.json': return import('./translations/uk.json.mjs');
    default: return new Promise(function(resolve, reject) {
      (typeof queueMicrotask === 'function' ? queueMicrotask : setTimeout)(
        reject.bind(null, new Error("Unknown variable dynamic import: " + path))
      );
    })
   }
 }
// eslint-disable-next-line import/no-default-export
const admin = {
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    register (app) {
        /**
     * Hook that adds the locale column in the Release Details table
     * @constant
     * @type {string}
     */ app.createHook('ContentReleases/pages/ReleaseDetails/add-locale-in-releases');
        if (window.strapi.features.isEnabled('cms-content-releases')) {
            app.addMenuLink({
                to: `plugins/${pluginId}`,
                icon: PaperPlane,
                intlLabel: {
                    id: `${pluginId}.plugin.name`,
                    defaultMessage: 'Releases'
                },
                Component: ()=>import('./pages/App.mjs').then((mod)=>({
                            default: mod.App
                        })),
                permissions: PERMISSIONS.main,
                position: 2
            });
            // Insert the releases container into the CM's sidebar on the Edit View
            const contentManagerPluginApis = app.getPlugin('content-manager').apis;
            if ('addEditViewSidePanel' in contentManagerPluginApis && typeof contentManagerPluginApis.addEditViewSidePanel === 'function') {
                contentManagerPluginApis.addEditViewSidePanel([
                    Panel
                ]);
            }
            // Insert the "add to release" action into the CM's Edit View
            if ('addDocumentAction' in contentManagerPluginApis && typeof contentManagerPluginApis.addDocumentAction === 'function') {
                contentManagerPluginApis.addDocumentAction((actions)=>{
                    const indexOfDeleteAction = actions.findIndex((action)=>action.type === 'unpublish');
                    actions.splice(indexOfDeleteAction, 0, ReleaseActionModalForm);
                    return actions;
                });
            }
            app.addSettingsLink('global', {
                id: pluginId,
                to: 'releases',
                intlLabel: {
                    id: `${pluginId}.plugin.name`,
                    defaultMessage: 'Releases'
                },
                licenseOnly: true,
                permissions: [],
                async Component () {
                    const { ProtectedReleasesSettingsPage } = await import('./pages/ReleasesSettingsPage.mjs');
                    return {
                        default: ProtectedReleasesSettingsPage
                    };
                }
            });
            if ('addBulkAction' in contentManagerPluginApis && typeof contentManagerPluginApis.addBulkAction === 'function') {
                contentManagerPluginApis.addBulkAction((actions)=>{
                    // We want to add this action to just before the delete action all the time
                    const deleteActionIndex = actions.findIndex((action)=>action.type === 'delete');
                    actions.splice(deleteActionIndex, 0, ReleaseAction);
                    return actions;
                });
            }
            // Hook that adds a column into the CM's LV table
            app.registerHook('Admin/CM/pages/ListView/inject-column-in-table', addColumnToTableHook);
            app.widgets.register([
                {
                    icon: PaperPlane,
                    title: {
                        id: `${PLUGIN_ID}.widget.upcoming-releases.title`,
                        defaultMessage: 'Upcoming releases'
                    },
                    component: async ()=>{
                        const { UpcomingReleasesWidget } = await import('./components/Widgets.mjs');
                        return UpcomingReleasesWidget;
                    },
                    pluginId: PLUGIN_ID,
                    id: 'upcoming-releases',
                    link: {
                        label: {
                            id: `${PLUGIN_ID}.widget.upcoming-releases.link`,
                            defaultMessage: 'Open Releases'
                        },
                        href: '/plugins/content-releases'
                    }
                }
            ]);
        } else if (!window.strapi.features.isEnabled('cms-content-releases') && window.strapi?.flags?.promoteEE) {
            app.addSettingsLink('global', {
                id: pluginId,
                to: '/plugins/purchase-content-releases',
                intlLabel: {
                    id: `${pluginId}.plugin.name`,
                    defaultMessage: 'Releases'
                },
                permissions: [],
                async Component () {
                    const { PurchaseContentReleases } = await import('./pages/PurchaseContentReleases.mjs');
                    return {
                        default: PurchaseContentReleases
                    };
                },
                licenseOnly: true
            });
        }
    },
    async registerTrads ({ locales }) {
        const importedTrads = await Promise.all(locales.map((locale)=>{
            return __variableDynamicImportRuntime4__(`./translations/${locale}.json`).then(({ default: data })=>{
                return {
                    data: prefixPluginTranslations(data, 'content-releases'),
                    locale
                };
            }).catch(()=>{
                return {
                    data: {},
                    locale
                };
            });
        }));
        return Promise.resolve(importedTrads);
    }
};

export { admin as default };
//# sourceMappingURL=index.mjs.map
