import * as React from 'react';
import { Primitive } from '@radix-ui/react-primitive';
import type { ComponentPropsWithoutRef } from '@radix-ui/react-primitive';
/**
 * VirtualizedViewport - Renders only visible items for performance optimization
 * Used when Combobox/Select has many items (>100)
 */
type VirtualizedViewportElement = React.ElementRef<typeof Primitive.div>;
type PrimitiveDivProps = ComponentPropsWithoutRef<typeof Primitive.div>;
export interface VirtualizedViewportProps extends PrimitiveDivProps {
    /**
     * Estimated size of each item in pixels
     * @default 40
     */
    estimatedItemSize?: number;
    /**
     * Number of items to render outside the visible area
     * @default 5
     */
    overscan?: number;
    /**
     * Callback to get the count of total items
     */
    getItemCount: () => number;
    /**
     * Callback when viewport ref changes
     */
    onViewportChange?: (node: VirtualizedViewportElement | null) => void;
}
export declare const VirtualizedViewport: React.ForwardRefExoticComponent<VirtualizedViewportProps & React.RefAttributes<HTMLDivElement>>;
export {};
