export interface App {
    keys: string[];
}
export interface Cron {
    enabled?: boolean;
    tasks?: object;
}
export interface Dirs {
    public?: string;
}
export interface Logger {
    updates?: {
        enabled?: boolean;
    } | undefined;
    startup?: {
        enabled?: boolean;
    } | undefined;
}
export interface ServerTransfer {
    remote?: {
        enabled?: boolean;
    } | undefined;
}
export interface ServerAdmin {
    autoOpen?: boolean;
}
export interface Proxy {
    global?: string;
    http?: string;
    https?: string;
    fetch?: string;
}
export interface Webhooks {
    populateRelations?: boolean;
    [key: string]: unknown;
}
export interface Http {
    serverOptions?: {
        requestTimeout?: number;
        [key: string]: unknown;
    } | undefined;
    [key: string]: unknown;
}
export interface Server {
    host: string;
    port: number;
    app: App;
    socket?: string | number;
    emitErrors?: boolean;
    url?: string;
    absoluteUrl?: string;
    proxy?: boolean | Proxy;
    globalProxy?: string;
    cron?: Cron;
    dirs?: Dirs;
    logger?: Logger;
    transfer?: ServerTransfer;
    admin?: ServerAdmin;
    webhooks?: Webhooks;
    http?: Http;
}
//# sourceMappingURL=server.d.ts.map