import type { SVGProps } from 'react';
import { Ref, forwardRef } from 'react';
const SvgEmptyDocuments = (props: SVGProps<SVGSVGElement>, ref: Ref<SVGSVGElement>) => (
  <svg xmlns="http://www.w3.org/2000/svg" width={16} height={16} fill="none" viewBox="0 0 217 121" ref={ref} {...props}>
    <g clipPath="url(#EmptyDocuments_svg__a)" opacity={0.84}>
      <path
        fill="#D9D8FF"
        fillOpacity={0.8}
        fillRule="evenodd"
        d="M189.917 20.442a7.583 7.583 0 0 1 0 15.167h-43.334a7.584 7.584 0 1 1 0 15.167h23.834a7.583 7.583 0 0 1 0 15.166h-11.022c-5.281 0-9.562 3.396-9.562 7.584q0 2.934 3.19 5.479c2.017 1.608 4.824 1.818 7.065 3.097a7.584 7.584 0 0 1-3.755 14.174H66.417a7.583 7.583 0 1 1 0-15.167h-42.25a7.583 7.583 0 0 1 0-15.167H67.5a7.583 7.583 0 0 0 0-15.166H40.417a7.583 7.583 0 0 1 0-15.167H83.75a7.583 7.583 0 0 1 0-15.167zm0 30.334a7.583 7.583 0 0 1 0 15.166 7.584 7.584 0 0 1 0-15.166"
        clipRule="evenodd"
      />
      <path
        fill="#fff"
        fillRule="evenodd"
        d="m133.228 20.443 10.077 73.496.905 7.373a4.33 4.33 0 0 1-3.773 4.829l-63.44 7.79a4.334 4.334 0 0 1-4.83-3.773l-9.766-79.547a2.167 2.167 0 0 1 1.886-2.414l.023-.003 5.263-.59zm-59.4 6.683 4.97-.557z"
        clipRule="evenodd"
      />
      <path
        stroke="#7B79FF"
        strokeWidth={2.5}
        d="m73.829 27.126 4.97-.557m54.429-6.126 10.077 73.496.905 7.373a4.33 4.33 0 0 1-3.773 4.829l-63.44 7.79a4.334 4.334 0 0 1-4.83-3.773l-9.766-79.547a2.167 2.167 0 0 1 1.886-2.414l.023-.003 5.263-.59z"
      />
      <path
        fill="#F0F0FF"
        fillRule="evenodd"
        d="m130.485 25.068 9.121 66.607.821 6.683c.264 2.152-1.246 4.109-3.373 4.37l-56.812 6.976c-2.128.261-4.066-1.272-4.33-3.425l-8.83-71.908a2.166 2.166 0 0 1 1.887-2.414l7.028-.863"
        clipRule="evenodd"
      />
      <path
        fill="#fff"
        fillRule="evenodd"
        stroke="#7B79FF"
        strokeWidth={2.5}
        d="M135.998 6.63H86.645a2.97 2.97 0 0 0-2.107.872 2.97 2.97 0 0 0-.873 2.107v82.333c0 .823.334 1.568.873 2.107a2.97 2.97 0 0 0 2.106.872h63.917a2.97 2.97 0 0 0 2.107-.872 2.97 2.97 0 0 0 .872-2.107V24.164a2.98 2.98 0 0 0-.873-2.108L138.104 7.502a2.98 2.98 0 0 0-2.106-.872Z"
        clipRule="evenodd"
      />
      <path
        stroke="#7B79FF"
        strokeLinecap="round"
        strokeLinejoin="round"
        strokeWidth={2.5}
        d="M136.478 7.879v12.563a3.25 3.25 0 0 0 3.25 3.25h8.595M95.311 78.942h28.167m-28.167-55.25h28.167zm0 13h46.583zm0 14.084h46.583zm0 14.083h46.583z"
      />
    </g>
    <defs>
      <clipPath id="EmptyDocuments_svg__a">
        <path fill="#fff" d="M.667.797h216v120h-216z" />
      </clipPath>
    </defs>
  </svg>
);
const ForwardRef = forwardRef(SvgEmptyDocuments);
export default ForwardRef;
