declare const _default: {
    homepage: ({ strapi }: {
        strapi: import("@strapi/types/dist/core").Strapi;
    }) => {
        addStatusToDocuments(documents: import("../../../shared/contracts/homepage").RecentDocument[]): Promise<import("../../../shared/contracts/homepage").RecentDocument[]>;
        queryLastDocuments(additionalQueryParams?: Record<string, unknown> | undefined, draftAndPublishOnly?: boolean | undefined): Promise<import("../../../shared/contracts/homepage").RecentDocument[]>;
        getRecentlyPublishedDocuments(): Promise<import("../../../shared/contracts/homepage").RecentDocument[]>;
        getRecentlyUpdatedDocuments(): Promise<import("../../../shared/contracts/homepage").RecentDocument[]>;
        getCountDocuments(): Promise<{
            draft: number;
            published: number;
            modified: number;
        }>;
    };
    components: ({ strapi }: {
        strapi: import("@strapi/types/dist/core").Strapi;
    }) => {
        findAllComponents(): unknown[];
        findComponent(uid: `${string}.${string}`): any;
        findConfiguration(component: import("@strapi/types/dist/struct").ComponentSchema): Promise<{
            uid: string;
            settings: import("../../../shared/contracts/content-types").Settings;
            metadatas: import("../../../shared/contracts/content-types").Metadatas;
            layouts: import("../../../shared/contracts/content-types").Layouts;
            options?: object | undefined;
            category: string;
        }>;
        updateConfiguration(component: import("@strapi/types/dist/struct").ComponentSchema, newConfiguration: import("./configuration").ConfigurationUpdate): Promise<{
            uid: string;
            settings: import("../../../shared/contracts/content-types").Settings;
            metadatas: import("../../../shared/contracts/content-types").Metadatas;
            layouts: import("../../../shared/contracts/content-types").Layouts;
            options?: object | undefined;
            category: string;
        }>;
        findComponentsConfigurations(model: import("@strapi/types/dist/struct").ComponentSchema): Promise<Record<string, import("../../../shared/contracts/content-types").Configuration & {
            category: string;
            isComponent: boolean;
        }>>;
        syncConfigurations(): Promise<void>;
    };
    'content-types': ({ strapi }: {
        strapi: import("@strapi/types/dist/core").Strapi;
    }) => {
        findAllContentTypes(): unknown[];
        findContentType(uid: import("@strapi/types/dist/uid").ContentType): any;
        findDisplayedContentTypes(): unknown[];
        findContentTypesByKind(kind: {
            kind: import("@strapi/types/dist/struct").ContentTypeKind | undefined;
        }): unknown[];
        findConfiguration(contentType: import("@strapi/types/dist/struct").ContentTypeSchema): Promise<any>;
        updateConfiguration(contentType: import("@strapi/types/dist/struct").ContentTypeSchema, newConfiguration: import("./configuration").ConfigurationUpdate): Promise<any>;
        findComponentsConfigurations(contentType: import("@strapi/types/dist/struct").ContentTypeSchema): any;
        syncConfigurations(): Promise<void>;
    };
    'data-mapper': () => {
        toContentManagerModel(contentType: import("@strapi/types/dist/struct").ComponentSchema): {
            apiID: string;
            isDisplayed: boolean;
            attributes: any;
            modelType: "component";
            uid: `${string}.${string}`;
            category: string;
            modelName: string;
            globalId: string;
            pluginOptions?: import("@strapi/types/dist/struct").SchemaPluginOptions | undefined;
            options?: import("@strapi/types/dist/struct").SchemaOptions | undefined;
            collectionName?: string | undefined;
            plugin?: string | undefined;
            info: import("@strapi/types/dist/struct").SchemaInfo;
        };
        toDto: import("lodash/fp").LodashPick2x1;
    };
    'document-metadata': ({ strapi }: {
        strapi: import("@strapi/types/dist/core").Strapi;
    }) => {
        getAvailableLocales(uid: import("@strapi/types/dist/uid").ContentType, version: import("./document-metadata").DocumentVersion, allVersions: import("./document-metadata").DocumentVersion[]): Promise<import("../../../shared/contracts/collection-types").AvailableLocaleDocument[]>;
        getAvailableStatus(version: import("./document-metadata").DocumentVersion, allVersions: import("./document-metadata").DocumentVersion[]): Partial<import("./document-metadata").DocumentVersion> | undefined;
        getManyAvailableStatus(uid: import("@strapi/types/dist/uid").ContentType, documents: import("./document-metadata").DocumentVersion[]): Promise<any[]>;
        getStatus(version: import("./document-metadata").DocumentVersion, otherDocumentStatuses?: import("../../../shared/contracts/collection-types").AvailableStatusDocument[] | undefined): string;
        getMetadata(uid: import("@strapi/types/dist/uid").ContentType, version: import("./document-metadata").DocumentVersion, { availableLocales, availableStatus }?: import("./document-metadata").GetMetadataOptions): Promise<{
            availableLocales: import("../../../shared/contracts/collection-types").AvailableLocaleDocument[];
            availableStatus: Partial<import("./document-metadata").DocumentVersion>[];
        }>;
        formatDocumentWithMetadata(uid: import("@strapi/types/dist/uid").ContentType, document: import("./document-metadata").DocumentVersion, opts?: import("./document-metadata").GetMetadataOptions): Promise<{
            data: {
                status: string | undefined;
                id: string | number;
                documentId: string;
                locale?: string | undefined;
                localizations?: import("./document-metadata").DocumentVersion[] | undefined;
                updatedAt?: string | Date | null | undefined;
                publishedAt?: string | Date | null | undefined;
            };
            meta: {
                availableLocales: import("../../../shared/contracts/collection-types").AvailableLocaleDocument[];
                availableStatus: Partial<import("./document-metadata").DocumentVersion>[];
            };
        }>;
    };
    'document-manager': ({ strapi }: {
        strapi: import("@strapi/types/dist/core").Strapi;
    }) => {
        findOne(id: string, uid: `admin::${string}` | `strapi::${string}` | `api::${string}.${string}` | `plugin::${string}.${string}`, opts?: Omit<import("@strapi/types/dist/modules/documents/params/document-engine").FindOne<import("@strapi/types/dist/uid").ContentType>, "documentId">): Promise<import("@strapi/types/dist/modules/documents").AnyDocument | null>;
        findLocales(id: string | string[] | undefined, uid: `admin::${string}` | `strapi::${string}` | `api::${string}.${string}` | `plugin::${string}.${string}`, opts: {
            populate?: {
                populate?: import("@strapi/types/dist/modules/documents/params/populate").Any<any> | undefined;
            } | undefined;
            locale?: string | string[] | undefined;
            isPublished?: boolean | undefined;
        }): Promise<any[]>;
        findMany(opts: import("@strapi/types/dist/modules/documents/params/document-engine").FindMany<import("@strapi/types/dist/uid").ContentType> | undefined, uid: `admin::${string}` | `strapi::${string}` | `api::${string}.${string}` | `plugin::${string}.${string}`): Promise<import("@strapi/types/dist/modules/documents").AnyDocument[]>;
        findPage(opts: import("@strapi/types/dist/modules/documents/params/document-engine").FindMany<import("@strapi/types/dist/uid").ContentType> | undefined, uid: `admin::${string}` | `strapi::${string}` | `api::${string}.${string}` | `plugin::${string}.${string}`): Promise<{
            results: import("@strapi/types/dist/modules/documents").AnyDocument[];
            pagination: import("@strapi/utils/dist/pagination").PagePatinationInformation;
        }>;
        create(uid: `admin::${string}` | `strapi::${string}` | `api::${string}.${string}` | `plugin::${string}.${string}`, opts?: import("@strapi/types/dist/modules/documents/params/document-engine").Create<import("@strapi/types/dist/uid").ContentType>): Promise<import("@strapi/types/dist/modules/documents").AnyDocument>;
        update(id: string, uid: `admin::${string}` | `strapi::${string}` | `api::${string}.${string}` | `plugin::${string}.${string}`, opts?: Omit<import("@strapi/types/dist/modules/documents/params/document-engine").Update<import("@strapi/types/dist/uid").ContentType>, "documentId">): Promise<import("@strapi/types/dist/modules/documents").AnyDocument | null>;
        clone(id: string, body: Partial<import("@strapi/types/dist/modules/documents/params/data").Input<`admin::${string}` | `strapi::${string}` | `api::${string}.${string}` | `plugin::${string}.${string}`>>, uid: `admin::${string}` | `strapi::${string}` | `api::${string}.${string}` | `plugin::${string}.${string}`): Promise<import("@strapi/types/dist/modules/documents").AnyDocument | undefined>;
        exists(uid: `admin::${string}` | `strapi::${string}` | `api::${string}.${string}` | `plugin::${string}.${string}`, id?: string | undefined): Promise<boolean>;
        delete(id: string, uid: `admin::${string}` | `strapi::${string}` | `api::${string}.${string}` | `plugin::${string}.${string}`, opts?: Omit<import("@strapi/types/dist/modules/documents/params/document-engine").Delete<import("@strapi/types/dist/uid").ContentType>, "documentId">): Promise<{}>;
        deleteMany(documentIds: string[], uid: `admin::${string}` | `strapi::${string}` | `api::${string}.${string}` | `plugin::${string}.${string}`, opts?: (import("@strapi/types/dist/modules/documents/params/document-engine").FindMany<import("@strapi/types/dist/uid").ContentType> | undefined) & {
            locale?: string | undefined;
        }): Promise<{
            count: number;
        }>;
        publish(id: string, uid: `admin::${string}` | `strapi::${string}` | `api::${string}.${string}` | `plugin::${string}.${string}`, opts?: Omit<import("@strapi/types/dist/modules/documents/params/document-engine").Publish<import("@strapi/types/dist/uid").ContentType>, "documentId">): Promise<import("@strapi/types/dist/modules/documents").AnyDocument[]>;
        publishMany(uid: import("@strapi/types/dist/uid").ContentType, documentIds: string[], locale?: string | string[] | undefined): Promise<number>;
        unpublishMany(documentIds: string[], uid: `admin::${string}` | `strapi::${string}` | `api::${string}.${string}` | `plugin::${string}.${string}`, opts?: Omit<import("@strapi/types/dist/modules/documents/params/document-engine").Unpublish<import("@strapi/types/dist/uid").ContentType>, "documentId">): Promise<{
            count: number;
        }>;
        unpublish(id: string, uid: `admin::${string}` | `strapi::${string}` | `api::${string}.${string}` | `plugin::${string}.${string}`, opts?: Omit<import("@strapi/types/dist/modules/documents/params/document-engine").Unpublish<import("@strapi/types/dist/uid").ContentType>, "documentId">): Promise<import("@strapi/types/dist/modules/documents").AnyDocument | undefined>;
        discardDraft(id: string, uid: `admin::${string}` | `strapi::${string}` | `api::${string}.${string}` | `plugin::${string}.${string}`, opts?: Omit<import("@strapi/types/dist/modules/documents/params/document-engine").DiscardDraft<import("@strapi/types/dist/uid").ContentType>, "documentId">): Promise<import("@strapi/types/dist/modules/documents").AnyDocument | undefined>;
        countDraftRelations(id: string, uid: import("@strapi/types/dist/uid").ContentType, locale: string): Promise<number>;
        countManyEntriesDraftRelations(documentIds: string[], uid: `admin::${string}` | `strapi::${string}` | `api::${string}.${string}` | `plugin::${string}.${string}`, locale: string | string[]): Promise<number>;
    };
    'field-sizes': ({ strapi }: {
        strapi: import("@strapi/types/dist/core").Strapi;
    }) => {
        getAllFieldSizes(): Record<string, {
            default: 8 | 6 | 4 | 12;
            isResizable: boolean;
        } | undefined>;
        hasFieldSize(type: string): boolean;
        getFieldSize(type?: string | undefined): {
            default: 8 | 6 | 4 | 12;
            isResizable: boolean;
        };
        setFieldSize(type: string, size: {
            default: 8 | 6 | 4 | 12;
            isResizable: boolean;
        } | undefined): void;
        setCustomFieldInputSizes(): void;
    };
    metrics: ({ strapi }: {
        strapi: import("@strapi/types/dist/core").Strapi;
    }) => {
        sendDidConfigureListView: (contentType: import("@strapi/types/dist/struct").ContentTypeSchema, configuration: import("../../../shared/contracts/content-types").Configuration) => Promise<void>;
    };
    'permission-checker': ({ strapi }: {
        strapi: import("@strapi/types/dist/core").Strapi;
    }) => {
        create: ({ userAbility, model }: {
            userAbility: any;
            model: string;
        }) => {
            can: (action: string, entity?: ({
                id: import("@strapi/types/dist/data").ID;
            } & {
                [key: string]: any;
            }) | undefined, field: string) => any;
            cannot: (action: string, entity?: ({
                id: import("@strapi/types/dist/data").ID;
            } & {
                [key: string]: any;
            }) | undefined, field: string) => any;
            sanitizeOutput: (data: {
                id: import("@strapi/types/dist/data").ID;
            } & {
                [key: string]: any;
            }, { action }?: {
                action?: string | undefined;
            }) => any;
            sanitizeQuery: (query: {
                page?: string | undefined;
                pageSize?: string | undefined;
                sort?: string | undefined;
            }, { action }?: {
                action?: string | undefined;
            }) => any;
            sanitizeCreateInput: (data: any) => any;
            sanitizeUpdateInput: (entity: {
                id: import("@strapi/types/dist/data").ID;
            } & {
                [key: string]: any;
            }) => (data: any) => any;
            validateQuery: (query: {
                page?: string | undefined;
                pageSize?: string | undefined;
                sort?: string | undefined;
            }, { action }?: {
                action?: string | undefined;
            }) => any;
            validateInput: (action: string, data: any, entity?: ({
                id: import("@strapi/types/dist/data").ID;
            } & {
                [key: string]: any;
            }) | undefined) => any;
            sanitizedQuery: (query: {
                page?: string | undefined;
                pageSize?: string | undefined;
                sort?: string | undefined;
            }, action?: {
                action?: string | undefined;
            }) => Promise<any>;
        };
    };
    permission: ({ strapi }: {
        strapi: import("@strapi/types/dist/core").Strapi;
    }) => {
        canConfigureContentType({ userAbility, contentType, }: {
            userAbility: any;
            contentType: import("@strapi/types/dist/struct").ContentTypeSchema;
        }): any;
        registerPermissions(): Promise<void>;
    };
    'populate-builder': () => (uid: import("@strapi/types/dist/uid").Schema) => {
        populateFromQuery(query: object): any;
        countRelations({ toMany, toOne }?: {
            toMany: boolean;
            toOne: boolean;
        }): any;
        populateDeep(level?: number): any;
        build(): Promise<{} | undefined>;
    };
    uid: ({ strapi }: {
        strapi: import("@strapi/types/dist/core").Strapi;
    }) => {
        generateUIDField({ contentTypeUID, field, data, locale, }: {
            contentTypeUID: import("@strapi/types/dist/uid").ContentType;
            field: string;
            data: Record<string, any>;
            locale?: string | undefined;
        }): Promise<string>;
        findUniqueUID({ contentTypeUID, field, value, locale, }: {
            contentTypeUID: import("@strapi/types/dist/uid").ContentType;
            field: string;
            value: string;
            locale?: string | undefined;
        }): Promise<string>;
        checkUIDAvailability({ contentTypeUID, field, value, locale, }: {
            contentTypeUID: import("@strapi/types/dist/uid").ContentType;
            field: string;
            value: string;
            locale?: string | undefined;
        }): Promise<boolean>;
    };
};
export default _default;
//# sourceMappingURL=index.d.ts.map