import type { Core } from '@strapi/types';
export type HandlerParams = {
    documentId: string;
    locale: string;
    status: 'published' | 'draft';
};
/**
 * @deprecated Use Core.Config.Admin['preview'] from @strapi/types instead
 * Keeping for backward compatibility
 */
export type PreviewConfig = NonNullable<Core.Config.Admin['preview']>;
/**
 * Read configuration for static preview
 */
declare const createPreviewConfigService: ({ strapi }: {
    strapi: Core.Strapi;
}) => {
    register(): void;
    isConfigured(): boolean;
    isEnabled(): boolean;
    /**
     * Validate if the configuration is valid
     */
    validate(): void;
    /**
     * Utility to get the preview handler from the configuration
     */
    getPreviewHandler(): NonNullable<Core.Config.Admin['preview']>['config']['handler'];
};
export { createPreviewConfigService };
//# sourceMappingURL=preview-config.d.ts.map