import type { MainField } from './attributes';
import type { RelationResult } from '../../../shared/contracts/relations';
/**
 * @internal
 * @description Get the label of a relation, the contract has [key: string]: unknown,
 * so we need to check if the mainFieldKey is defined and if the relation has a value
 * under that property. If it does, we then verify it's type of string and return it.
 *
 * We fallback to the documentId.
 */
declare const getRelationLabel: (relation: RelationResult, mainField?: MainField) => string;
export { getRelationLabel };
