import { RelationResult as RelResult, FindAvailable, FindExisting } from '../../../shared/contracts/relations';
import type { Modules } from '@strapi/types';
import type { errors } from '@strapi/utils';
interface RelationResult extends RelResult {
    __temp_key__: string;
}
type GetRelationsResponse = {
    results: Array<RelationResult>;
    pagination: {
        page: NonNullable<Modules.EntityService.Params.Pagination.PageNotation['page']>;
        pageSize: NonNullable<Modules.EntityService.Params.Pagination.PageNotation['pageSize']>;
        pageCount: number;
        total: number;
    } | null;
    error?: never;
} | {
    results?: never;
    pagination?: never;
    error: errors.ApplicationError | errors.YupValidationError;
};
declare const useGetRelationsQuery: import("@reduxjs/toolkit/dist/query/react/buildHooks").UseQuery<import("@reduxjs/toolkit/query").QueryDefinition<FindExisting.Params & {
    params?: (Partial<Pick<import("../../../shared/contracts/relations").Pagination, "page" | "pageSize">> & {
        locale?: string | null | undefined;
        _filter?: string | undefined;
        _q?: string | undefined;
        status?: Modules.Documents.Params.PublicationStatus.Kind | undefined;
        idsToOmit?: string[] | undefined;
        idsToInclude?: string[] | undefined;
    }) | undefined;
}, import("@reduxjs/toolkit/query").BaseQueryFn<string | import("@strapi/admin/strapi-admin").QueryArguments, unknown, import("@strapi/admin/strapi-admin").BaseQueryError, {}, {}>, "GuidedTourMeta" | "HomepageKeyStatistics" | "AIUsage" | "AIFeatureConfig" | "ComponentConfiguration" | "ContentTypesConfiguration" | "ContentTypeSettings" | "Document" | "InitialData" | "HistoryVersion" | "Relations" | "UidAvailability" | "RecentDocumentList" | "CountDocuments" | "UpcomingReleasesList" | "AILocalizationJobs", GetRelationsResponse, "adminApi">>, useLazySearchRelationsQuery: import("@reduxjs/toolkit/dist/query/react/buildHooks").UseLazyQuery<import("@reduxjs/toolkit/query").QueryDefinition<FindAvailable.Params & {
    params?: (Partial<Pick<import("../../../shared/contracts/relations").Pagination, "page" | "pageSize">> & {
        id?: import("@strapi/types/dist/data").ID | undefined;
        locale?: string | undefined;
        _filter?: string | undefined;
        _q?: string | undefined;
        idsToOmit?: string[] | undefined;
        idsToInclude?: string[] | undefined;
    }) | undefined;
}, import("@reduxjs/toolkit/query").BaseQueryFn<string | import("@strapi/admin/strapi-admin").QueryArguments, unknown, import("@strapi/admin/strapi-admin").BaseQueryError, {}, {}>, "GuidedTourMeta" | "HomepageKeyStatistics" | "AIUsage" | "AIFeatureConfig" | "ComponentConfiguration" | "ContentTypesConfiguration" | "ContentTypeSettings" | "Document" | "InitialData" | "HistoryVersion" | "Relations" | "UidAvailability" | "RecentDocumentList" | "CountDocuments" | "UpcomingReleasesList" | "AILocalizationJobs", {
    results: RelResult[];
    pagination: import("../../../shared/contracts/relations").Pagination;
    error?: undefined;
} | {
    results?: undefined;
    pagination?: undefined;
    error: errors.ApplicationError<"ApplicationError", string, unknown> | errors.YupValidationError<string>;
}, "adminApi">>;
export { useGetRelationsQuery, useLazySearchRelationsQuery };
export type { RelationResult };
